/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.BackgroundInitializerTest;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackgroundInitializerSupplierTest
extends BackgroundInitializerTest {
    @Override
    protected BackgroundInitializerTest.AbstractBackgroundInitializerTestImpl getBackgroundInitializerTestImpl() {
        return new SupplierBackgroundInitializerTestImpl();
    }

    @Override
    protected SupplierBackgroundInitializerTestImpl getBackgroundInitializerTestImpl(ExecutorService exec) {
        return new SupplierBackgroundInitializerTestImpl(exec);
    }

    @Test
    public void testClose() throws Exception {
        BackgroundInitializerTest.AbstractBackgroundInitializerTestImpl init = this.getBackgroundInitializerTestImpl();
        Assertions.assertFalse((boolean)init.getCloseableCounter().isClosed(), (String)"closed without close() call");
        init.close();
        Assertions.assertFalse((boolean)init.getCloseableCounter().isClosed(), (String)"closed() succeeded before start()");
        init.start();
        init.get();
        Assertions.assertFalse((boolean)init.getCloseableCounter().isClosed(), (String)"closed() succeeded after start() but before close()");
        init.close();
        Assertions.assertTrue((boolean)init.getCloseableCounter().isClosed(), (String)"closed() did not succeed");
    }

    @Test
    public void testCloseWithCheckedException() throws Exception {
        IOException ioException = new IOException();
        FailableConsumer IOExceptionConsumer = cc -> {
            throw ioException;
        };
        SupplierBackgroundInitializerTestImpl init = new SupplierBackgroundInitializerTestImpl(IOExceptionConsumer);
        init.start();
        init.get();
        try {
            init.close();
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(ConcurrentException.class));
            Assertions.assertSame((Object)ioException, (Object)e.getCause());
        }
    }

    @Test
    public void testCloseWithRuntimeException() throws Exception {
        NullPointerException npe = new NullPointerException();
        FailableConsumer NullPointerExceptionConsumer = cc -> {
            throw npe;
        };
        SupplierBackgroundInitializerTestImpl init = new SupplierBackgroundInitializerTestImpl(NullPointerExceptionConsumer);
        init.start();
        init.get();
        try {
            init.close();
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertSame((Object)npe, (Object)e);
        }
    }

    protected static final class SupplierBackgroundInitializerTestImpl
    extends BackgroundInitializerTest.AbstractBackgroundInitializerTestImpl {
        SupplierBackgroundInitializerTestImpl() {
            this.setSupplierAndCloser(cc -> cc.close());
        }

        SupplierBackgroundInitializerTestImpl(ExecutorService exec) {
            super(exec);
            this.setSupplierAndCloser(cc -> cc.close());
        }

        SupplierBackgroundInitializerTestImpl(FailableConsumer<?, ?> consumer) {
            this.setSupplierAndCloser(consumer);
        }

        private void setSupplierAndCloser(FailableConsumer<?, ?> consumer) {
            try {
                FailableSupplier supplier = () -> this.initializeInternal();
                Field initializer = AbstractConcurrentInitializer.class.getDeclaredField("initializer");
                initializer.setAccessible(true);
                initializer.set((Object)this, supplier);
                Field closer = AbstractConcurrentInitializer.class.getDeclaredField("closer");
                closer.setAccessible(true);
                closer.set((Object)this, consumer);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Assertions.fail();
            }
        }
    }
}

