/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gradle.plugin.management.internal.MergedPluginRequests;
import org.gradle.plugin.management.internal.MultiPluginRequests;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.SingletonPluginRequests;

public interface PluginRequests
extends Iterable<PluginRequestInternal> {
    public static final PluginRequests EMPTY = new EmptyPluginRequests();

    public boolean isEmpty();

    default public PluginRequests mergeWith(PluginRequests requests) {
        if (this.isEmpty()) {
            return requests;
        }
        if (requests.isEmpty()) {
            return this;
        }
        return new MergedPluginRequests(this, requests);
    }

    public static PluginRequests of(PluginRequestInternal request) {
        return new SingletonPluginRequests(request);
    }

    public static PluginRequests of(List<PluginRequestInternal> list) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        if (list.size() == 1) {
            return new SingletonPluginRequests(list.get(0));
        }
        return new MultiPluginRequests(list);
    }

    public static class EmptyPluginRequests
    implements PluginRequests {
        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public PluginRequests mergeWith(PluginRequests requests) {
            return requests;
        }

        @Override
        public Iterator<PluginRequestInternal> iterator() {
            return Collections.emptyIterator();
        }
    }
}

