/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.text;

import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharFilter;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Formats;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.HtmlChunk;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineColumn;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.NaturalComparator;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.com.intellij.util.NotNullFunction;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.kotlin.com.intellij.util.text.MergingCharSequence;

public class StringUtil
extends StringUtilRt {
    public static final String ELLIPSIS = "\u2026";
    public static final String THREE_DOTS = "...";
    public static final Function<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final Function<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    @NotNull
    public static final Function<String, String> TRIMMER = StringUtil::trim;
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    private static final String[] ourOtherNonCapitalizableWords = new String[]{"iOS", "iPhone", "iPad", "iMac"};
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        List<String> words = StringUtil.getWordsIn(find);
        words.sort((o1, o2) -> o2.length() - o1.length());
        List<String> list2 = words;
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapePattern(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.replace(StringUtil.replace(text2, "'", "''"), "{", "'{'");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T> org.jetbrains.kotlin.com.intellij.util.Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        org.jetbrains.kotlin.com.intellij.util.Function<Object, String> function2 = Object::toString;
        if (function2 == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return function2;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        String string2 = StringUtil.replace(text2, oldS, newS, false);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceIgnoreCase(@NotNull String text2, @NotNull String oldS, @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        String string2 = StringUtil.replace(text2, oldS, newS, true);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        String string2 = buffer.replace(oldChar, newChar);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text2.length()) {
            int index2;
            int n = index2 = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i) : text2.indexOf(oldS, i);
            if (index2 < 0) {
                if (i == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i);
            }
            newText.append(text2, i, index2);
            newText.append(newS);
            i = index2 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char c, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        for (int i = Math.min(fromIndex, where.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), c)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return Strings.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        return StringUtil.stripHtml(html, convertBreaks ? "\n\n" : null);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, @Nullable String breaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        if (breaks != null) {
            html = html.replaceAll("<br/?>", breaks);
        }
        String string2 = html.replaceAll("<(.|\n)*?>", "");
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        return string2;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return Strings.toLowerCase(str);
    }

    @Contract(pure=true)
    @NotNull
    public static String getPackageName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return StringUtil.getPackageName(fqName2, '.');
    }

    @Contract(pure=true)
    @NotNull
    public static String getPackageName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string2 = fqName2.substring(0, lastPointIdx);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(37);
            }
            return string2;
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        int count = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text2.length() && text2.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeLineBreak(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        StringBuilder buffer = new StringBuilder(text2.length());
        block4: for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text2, int line, int col) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        int curLine = 0;
        int offset2 = 0;
        while (line != curLine) {
            if (offset2 == text2.length()) {
                return -1;
            }
            char c = text2.charAt(offset2);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset2 < text2.length() - 1 && text2.charAt(offset2 + 1) == '\n') {
                    ++offset2;
                }
            }
            ++offset2;
        }
        return offset2 + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset2) {
        LineColumn lineColumn;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text2, offset2)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text2, int offset2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset2; ++curOffset) {
            if (curOffset == text2.length()) {
                return null;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text2.length() - 1 && text2.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset2 - curLineStart);
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        return StringUtil.fixCapitalization(s, ArrayUtil.mergeArrays(ourPrepositions, ourOtherNonCapitalizableWords), true);
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        return StringUtil.fixCapitalization(s, ourPrepositions, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, true);
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, String @NotNull [] prepositions, boolean title) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            char prevPrevChar;
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (!title && j > i + 1 && !Character.isLowerCase(s.charAt(i + 1))) continue;
            char c = prevPrevChar = i > 1 ? s.charAt(i - 2) : (char)'\u0000';
            if (prevChar == '.' && (prevPrevChar == ' ' || prevPrevChar == '*') || prevChar == '~' && prevPrevChar == ' ' || StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string2 = buffer == null ? s : buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, String @NotNull [] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == StringUtil.toLowerCase(preposition.charAt(j))) continue;
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static NotNullFunction<String, String> escaper(boolean escapeSlash, @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = dom -> {
            StringBuilder builder2 = new StringBuilder(dom.length());
            StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder2);
            return builder2.toString();
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder2 = buffer;
        if (stringBuilder2 == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder2;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return string2;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        return StringUtilRt.isQuotedString(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        String string2 = StringUtilRt.unquoteString(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        String string2 = StringUtilRt.unquoteString(s, quotationChar);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        return string2;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    public static String unescapeAnsiStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '?': {
                    buffer.append('?');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'v': {
                    buffer.append('\u000b');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    count = 3;
                    radix = 8;
                    suffixLen = 0;
                    decode = true;
                    break;
                }
                case 'x': {
                    count = 2;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'u': {
                    count = 4;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'U': {
                    count = 8;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (decode) {
                decode = false;
                StringBuilder sb = new StringBuilder(count);
                for (int pos = idx + suffixLen; pos < length && count > 0; --count, ++pos) {
                    char chl = s.charAt(pos);
                    if (!(radix == 16 && StringUtil.isHexDigit(chl) || radix == 8 && StringUtil.isOctalDigit(chl))) break;
                    sb.append(chl);
                }
                if (sb.length() != 0) {
                    try {
                        long code = Long.parseLong(sb.toString(), radix);
                        idx += sb.length() + suffixLen - 1;
                        buffer.append((char)code);
                    }
                    catch (NumberFormatException e) {
                        buffer.append('\\').append(ch);
                    }
                } else {
                    buffer.append('\\').append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(81);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String pluralize(@NotNull @NonNls String word) {
        if (word == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        String string2 = Strings.pluralize(word);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text2, boolean allWords) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        return StringUtil.capitalizeWords(text2, " \t\n\r\f([<", allWords, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text2, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        if (tokenizerDelim == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        StringTokenizer tokenizer = new StringTokenizer(text2, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text2.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string2 = out.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        String string2 = Introspector.decapitalize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String decapitalize(@NotNull String s, boolean ignoreAbbreviation) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        if (s == null || s.length() == 0) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(91);
            }
            return string2;
        }
        if (!ignoreAbbreviation && s.length() > 1 && Character.isUpperCase(s.charAt(1)) && Character.isUpperCase(s.charAt(0))) {
            String string3 = s;
            if (string3 == null) {
                StringUtil.$$$reportNull$$$0(92);
            }
            return string3;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        String string2 = Strings.capitalize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return string2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return Strings.isCapitalized(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(96);
            }
            return string2;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        return Strings.stringHashCode(chars);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from2, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return Strings.stringHashCode(chars, from2, to);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from2, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        return Strings.stringHashCode(chars, from2, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from2, int to) {
        return Strings.stringHashCode(chars, from2, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from2, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(100);
        }
        return Strings.stringHashCodeInsensitive(chars, from2, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from2, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return Strings.stringHashCodeInsensitive(chars, from2, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from2, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        return Strings.stringHashCodeInsensitive(chars, from2, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        return Strings.stringHashCodeInsensitive(chars);
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        int h = 0;
        for (int off = 0; off < chars.length(); ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string2, String ... prefixes) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        int offset2 = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string2.regionMatches(offset2, prefix, 0, prefixLen)) {
                return false;
            }
            offset2 += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return Strings.trim(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        String string2 = Strings.trimEnd(s, suffix);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        String string2 = Strings.trimEnd(s, suffix, ignoreCase);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        String string2 = Strings.trimEnd(s, suffix);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLog(@NotNull String text2, int limit) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        if (limit > 5 && text2.length() > limit) {
            String string2 = text2.substring(0, limit - 5) + " ...\n";
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(116);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string2) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        String string3 = StringUtil.trimLeading((CharSequence)string2).toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimLeading(@NotNull CharSequence string2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(120);
        }
        for (index2 = 0; index2 < string2.length() && Character.isWhitespace(string2.charAt(index2)); ++index2) {
        }
        CharSequence charSequence2 = string2.subSequence(index2, string2.length());
        if (charSequence2 == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        return charSequence2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        for (index2 = 0; index2 < string2.length() && string2.charAt(index2) == symbol2; ++index2) {
        }
        String string3 = string2.substring(index2);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(123);
        }
        return string3;
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder2, char symbol2) {
        int index2;
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        for (index2 = 0; index2 < builder2.length() && builder2.charAt(index2) == symbol2; ++index2) {
        }
        if (index2 > 0) {
            builder2.delete(0, index2);
        }
        StringBuilder stringBuilder2 = builder2;
        if (stringBuilder2 == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        return stringBuilder2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string2) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        String string3 = StringUtil.trimTrailing((CharSequence)string2).toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimTrailing(@NotNull CharSequence string2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        for (index2 = string2.length() - 1; index2 >= 0 && Character.isWhitespace(string2.charAt(index2)); --index2) {
        }
        CharSequence charSequence2 = string2.subSequence(0, index2 + 1);
        if (charSequence2 == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        return charSequence2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        for (index2 = string2.length() - 1; index2 >= 0 && string2.charAt(index2) == symbol2; --index2) {
        }
        String string3 = string2.substring(0, index2 + 1);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        return string3;
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder2, char symbol2) {
        int index2;
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        for (index2 = builder2.length() - 1; index2 >= 0 && builder2.charAt(index2) == symbol2; --index2) {
        }
        builder2.setLength(index2 + 1);
        StringBuilder stringBuilder2 = builder2;
        if (stringBuilder2 == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        return stringBuilder2;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    public static CharSequence trim(@Nullable CharSequence s) {
        int endIndex;
        int startIndex;
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return s;
        }
        for (startIndex = 0; startIndex < length && Character.isWhitespace(s.charAt(startIndex)); ++startIndex) {
        }
        if (startIndex == length) {
            return Strings.EMPTY_CHAR_SEQUENCE;
        }
        for (endIndex = length - 1; endIndex >= startIndex && Character.isWhitespace(s.charAt(endIndex)); --endIndex) {
        }
        if (startIndex > 0 || ++endIndex < length) {
            return s.subSequence(startIndex, endIndex);
        }
        return s;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return Strings.endsWithChar(s, suffix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        String string2 = Strings.trimStart(s, prefix);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimExtensions(@NotNull String name2) {
        int index2;
        if (name2 == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        String string2 = (index2 = name2.indexOf(46)) < 0 ? name2 : name2.substring(0, index2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String base, int count) {
        if (base == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        if (count == 1) {
            String string2 = base;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(140);
            }
            return string2;
        }
        return StringUtil.pluralize(base);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol2, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol2);
            }
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value2, String defaultValue) {
        return StringUtil.isEmpty(value2) ? defaultValue : value2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return Strings.isNotEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return Strings.isEmpty(cs);
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        String string2 = Strings.notNullize(s);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        String string2 = Strings.notNullize(s, defaultValue);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        return Strings.nullize(s, defaultValue);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        return Strings.nullize(s, nullizeSpaces);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return Strings.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @Contract(pure=true)
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        String string2 = ExceptionUtil.getThrowableText(aThrowable);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        return ExceptionUtil.getMessage(e);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return new String(buffer);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        List<String> list2 = StringUtilRt.splitHonorQuotes(s, separator);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        return StringUtil.split(s, separator, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        return StringUtil.split(s, separator, true, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        if (separator.length() == 0) {
            List<CharSequence> list2 = Collections.singletonList(s);
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(162);
            }
            return list2;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index2 = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index2 + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index2 : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        return StringUtil.tokenize(new StringTokenizer(s, separators));
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(final @NotNull StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        Iterable<String> iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(167);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getWordsIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        SmartList<String> result2 = null;
        int start = -1;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text2.length() - 1) {
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(text2.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result2 == null) {
                result2 = new SmartList<String>();
            }
            result2.add(text2.substring(start, i));
            start = -1;
        }
        if (result2 == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(169);
            }
            return list2;
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        return StringUtil.getWordIndicesIn(text2, null);
    }

    @Contract(pure=true)
    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text2, @Nullable Set<Character> separatorsSet) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        SmartList<TextRange> result2 = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text2.length(); ++i) {
            boolean isIdentifierPart;
            char c = text2.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text2.length() - 1) {
                result2.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result2.add(new TextRange(start, i));
            start = -1;
        }
        SmartList<TextRange> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings2, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        return StringUtil.join(strings2, 0, strings2.length, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings2, int startIndex, int endIndex, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result2.append(separator);
            }
            result2.append(strings2[i]);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String @NotNull [] zip(String @NotNull [] strings1, String @NotNull [] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result2 = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = strings1[i] + separator + strings2[i];
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        return result2;
    }

    @Contract(pure=true)
    public static String @NotNull [] surround(String @NotNull [] strings2, @NotNull String prefix, @NotNull String suffix) {
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        String[] result2 = ArrayUtil.newStringArray(strings2.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = prefix + strings2[i] + suffix;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        return result2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull org.jetbrains.kotlin.com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        if (f == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        if (items == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        String string2 = Strings.join(items, f, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull org.jetbrains.kotlin.com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        String string2 = Strings.join(items, f, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        String string2 = Strings.join(items, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull org.jetbrains.kotlin.com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        String string2 = Strings.join(items, f, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        return string2;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull org.jetbrains.kotlin.com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        Strings.join(items, f, separator, result2);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings2, @NotNull String separator) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        String string2 = Strings.join(strings2, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        return string2;
    }

    public static void join(@NotNull Collection<String> strings2, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        Strings.join(strings2, separator, result2);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(int @NotNull [] strings2, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        String string2 = Strings.join(strings2, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        String string2 = Strings.join(strings2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(215);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<CharSequence, ?, String> joining() {
        Collector<CharSequence, ?, String> collector2 = Collectors.joining(", ");
        if (collector2 == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        return collector2;
    }

    @Contract(pure=true)
    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        if ((len = text2.length()) > 0) {
            int to;
            int from2 = StringUtil.isQuoteAt(text2, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text2, len - 1) ? len - 1 : len;
            if (from2 > 0 || to < len) {
                String string2 = text2.substring(from2, to);
                if (string2 == null) {
                    StringUtil.$$$reportNull$$$0(218);
                }
                return string2;
            }
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        String string2 = Formats.formatFileSize(fileSize);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String string2) {
        void unitSeparator;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        String string3 = Formats.formatFileSize(fileSize, (String)unitSeparator);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String formatDuration(long duration) {
        String string2 = Formats.formatDuration(duration);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String formatDuration(@NotNull Duration duration) {
        if (duration == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        String string2 = Formats.formatDuration(duration);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    @NonNls
    public static String formatDuration(long duration, @NotNull String string2) {
        void unitSeparator;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        String string3 = Formats.formatDuration(duration, (String)unitSeparator);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        return string3;
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        if (word == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        return Strings.unpluralize(word);
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value2) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        for (int i = 0; i < value2.length(); ++i) {
            if (!Character.isLetter(value2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull @NonNls String chars) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return Strings.containsAnyChar(value2, chars);
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars, int start, int end) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        return Strings.containsAnyChar(value2, chars, start, end);
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value2, char ch) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        return Strings.containsChar(value2, ch);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return new String(buffer);
    }

    @Contract(pure=true)
    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String trim(@NotNull String s, @NotNull CharFilter filter2) {
        char ch;
        int start;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        int end = s.length();
        for (start = 0; start < end && !filter2.accept(ch = s.charAt(start)); ++start) {
        }
        while (start < end && !filter2.accept(ch = s.charAt(end - 1))) {
            --end;
        }
        String string2 = s.substring(start, end);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(240);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        return StringUtil.findMatches(s, pattern, 1);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(244);
        }
        SmartList<String> result2 = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result2.add(group);
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(247);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceSubstring(@NotNull String string2, @NotNull TextRange range, @NotNull String replacement) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        if (range == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        String string3 = range.replace(string2, replacement);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        return !text2.isEmpty() && Character.isWhitespace(text2.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index2, char c) {
        return index2 >= 0 && index2 < seq.length() && seq.charAt(index2) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        return StringUtilRt.startsWith(text2, prefix);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, int startIndex, @NotNull CharSequence prefix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        return Strings.startsWith(text2, startIndex, prefix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        return Strings.endsWith(text2, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, int start, int end, @NotNull CharSequence suffix) {
        int suffixLen;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        if (end < (suffixLen = suffix.length())) {
            return false;
        }
        for (int i = end - 1; i >= end - suffixLen && i >= start; --i) {
            if (text2.charAt(i) == suffix.charAt(i + suffixLen - end)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        String string2 = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        return string2;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && Strings.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        String string2 = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        return string2;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        return Strings.contains(s, start, end, c);
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        return Strings.indexOf(s, c);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        return Strings.indexOf(s, c, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        return Strings.indexOf(s, c, start, end);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence2, @NotNull CharSequence infix) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        return Strings.contains(sequence2, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        return Strings.indexOf(sequence2, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        return Strings.indexOf(sequence2, infix, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start, int end) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        return Strings.indexOf(sequence2, infix, start, end);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    public static int indexOf(char @NotNull [] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringBefore(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(300);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(0, i);
    }

    @Contract(pure=true)
    @NotNull
    public static String substringBeforeLast(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        if ((i = text2.lastIndexOf(subString)) == -1) {
            String string2 = text2;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(303);
            }
            return string2;
        }
        String string3 = text2.substring(0, i);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        return string3;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfter(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(305);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i + subString.length());
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfterLast(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        if ((i = text2.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @Contract(pure=true)
    @NotNull
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        String string2 = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? THREE_DOTS : "") : text2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        if (text2.length() <= length) {
            CharSequence charSequence2 = text2;
            if (charSequence2 == null) {
                StringUtil.$$$reportNull$$$0(313);
            }
            return charSequence2;
        }
        if (appendEllipsis) {
            String string2 = text2.subSequence(0, length) + THREE_DOTS;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(314);
            }
            return string2;
        }
        CharSequence charSequence3 = text2.subSequence(0, length);
        if (charSequence3 == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        return charSequence3;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        if (text2.length() <= length) {
            CharSequence charSequence2 = text2;
            if (charSequence2 == null) {
                StringUtil.$$$reportNull$$$0(317);
            }
            return charSequence2;
        }
        if (prependEllipsis) {
            String string2 = THREE_DOTS + text2.subSequence(text2.length() - length, text2.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(318);
            }
            return string2;
        }
        CharSequence charSequence3 = text2.subSequence(text2.length() - length, text2.length());
        if (charSequence3 == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        return charSequence3;
    }

    @Contract(pure=true)
    @NotNull
    public static String firstLast(@NotNull String text2, int length) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        String string2 = text2.length() > length ? text2.subSequence(0, length / 2) + ELLIPSIS + text2.subSequence(text2.length() - length / 2 - 1, text2.length()) : text2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        return StringUtil.escapeChars(str, character);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(323);
        }
        if (character == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string2 = buf.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        return string2;
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(326);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        return StringUtil.escapeChar(str, '\"');
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        return StringUtil.escapeChar(str, '/');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        return StringUtil.escapeChar(str, '\\');
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string2 = buf.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string2 = buf.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        return string2;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder2) {
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        StringUtil.quote(builder2, '\"');
    }

    public static void quote(@NotNull StringBuilder builder2, char quotingChar) {
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        builder2.insert(0, quotingChar);
        builder2.append(quotingChar);
    }

    @Contract(pure=true)
    @NotNull
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        String string2 = '\"' + str + "\"";
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        return string2;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.unescapeXmlEntities(text2);
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.escapeXmlEntities(text2);
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeXmlEntities(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        String string2 = Strings.unescapeXmlEntities(text2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        String string2 = Strings.escapeXmlEntities(text2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        return StringUtil.removeHtmlTags(htmlString, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString, boolean isRemoveStyleTag) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(346);
        }
        if (StringUtil.isEmpty(htmlString)) {
            return "";
        }
        MyHtml2Text parser = isRemoveStyleTag ? new MyHtml2Text(true) : new MyHtml2Text(false);
        try {
            parser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
        String string2 = parser.getText();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(347);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String removeEllipsisSuffix(@NotNull @Nls String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        if (s.endsWith(THREE_DOTS)) {
            String string2 = s.substring(0, s.length() - THREE_DOTS.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(349);
            }
            return string2;
        }
        if (s.endsWith(ELLIPSIS)) {
            String string3 = s.substring(0, s.length() - ELLIPSIS.length());
            if (string3 == null) {
                StringUtil.$$$reportNull$$$0(350);
            }
            return string3;
        }
        String string4 = s;
        if (string4 == null) {
            StringUtil.$$$reportNull$$$0(351);
        }
        return string4;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeMnemonics(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(352);
        }
        return StringUtil.replace(text2, MN_CHARS, MN_QUOTED);
    }

    @Contract(pure=true)
    @NotNull
    public static String htmlEmphasize(@NotNull @Nls String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        String string2 = HtmlChunk.tag("code").addText(text2).wrapWith("b").toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeToRegexp(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(355);
        }
        StringBuilder result2 = new StringBuilder(text2.length());
        String string2 = StringUtil.escapeToRegexp(text2, result2).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(356);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text2, @NotNull StringBuilder builder2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        StringBuilder stringBuilder2 = Strings.escapeToRegexp(text2, builder2);
        if (stringBuilder2 == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        return stringBuilder2;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(char @NotNull [] chars, int startOffset, int backslashOffset) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        if (chars[backslashOffset] != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text2, int startOffset, int backslashOffset) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        if (text2.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text2.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text2, @NotNull List<String> from2, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        if (from2 == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        String string2 = Strings.replace(text2, from2, to);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String @NotNull [] filterEmptyStrings(String @NotNull [] strings2) {
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        int emptyCount = 0;
        for (String string2 : strings2) {
            if (string2 != null && !string2.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings2 == null) {
                StringUtil.$$$reportNull$$$0(367);
            }
            return strings2;
        }
        String[] result2 = ArrayUtil.newStringArray(strings2.length - emptyCount);
        int count = 0;
        for (String string3 : strings2) {
            if (string3 == null || string3.isEmpty()) continue;
            result2[count++] = string3;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        return result2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return Strings.countChars(text2, c);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset2, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        return Strings.countChars(text2, c, offset2, stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start, int end, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        return Strings.countChars(text2, c, start, end, stopAtOtherChar);
    }

    @Contract(pure=true)
    @Nullable
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Contract(pure=true)
    @Nullable
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string2 = escaped.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(377);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String getQualifiedName(@Nullable @NonNls String packageName2, @NotNull @NonNls String className2) {
        if (className2 == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        if (packageName2 == null || packageName2.isEmpty()) {
            String string2 = className2;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(379);
            }
            return string2;
        }
        String string3 = packageName2 + '.' + className2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        return string3;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts2;
            boolean left = part1.length > idx;
            String[] stringArray = parts2 = left ? part1 : part2;
            while (idx < parts2.length) {
                String p = parts2[idx];
                int cmp = p.matches("\\d+") ? Integer.valueOf(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        int res2 = 0;
        for (int i = 0; i < text2.length() && (i = text2.indexOf(c, i)) >= 0; ++i) {
            ++res2;
        }
        return res2;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(382);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        int res2 = 0;
        for (int i = 0; i < text2.length() && (i = text2.indexOf(s, i)) >= 0; ++i) {
            ++res2;
        }
        return res2;
    }

    @Contract(pure=true)
    @NotNull
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name2) {
        if (name2 == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        if (StringUtil.isEmptyOrSpaces(name2)) {
            String string2 = name2;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(385);
            }
            return string2;
        }
        char c = name2.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string3 = "an" + Character.toUpperCase(c) + name2.substring(1);
            if (string3 == null) {
                StringUtil.$$$reportNull$$$0(386);
            }
            return string3;
        }
        String string4 = "a" + Character.toUpperCase(c) + name2.substring(1);
        if (string4 == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        return string4;
    }

    @Contract(pure=true)
    @NotNull
    public static String sanitizeJavaIdentifier(@NotNull String name2) {
        if (name2 == null) {
            StringUtil.$$$reportNull$$$0(388);
        }
        StringBuilder result2 = new StringBuilder(name2.length());
        for (int i = 0; i < name2.length(); ++i) {
            char ch = name2.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        return string2;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context2 = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context2 = StringUtil.escapeStringCharacters(context2);
            throw new AssertionError((Object)("Wrong line separators: '" + context2 + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        String string2 = idx >= s.length() ? "" : s.substring(idx);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string2) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        return StringUtil.splitByLines(string2, true);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string2, boolean excludeEmptyStrings) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        String[] stringArray = (excludeEmptyStrings ? Splitters.EOL_SPLIT_PATTERN : Splitters.EOL_SPLIT_PATTERN_WITH_EMPTY).split(string2);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(395);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesDontTrim(@NotNull String string2) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        String[] stringArray = Splitters.EOL_SPLIT_DONT_TRIM_PATTERN.split(string2);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesKeepSeparators(@NotNull String string2) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(398);
        }
        String[] stringArray = Splitters.EOL_SPLIT_KEEP_SEPARATORS.split(string2);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(399);
        }
        return stringArray;
    }

    @Contract(pure=true)
    @NotNull
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        ArrayList<Pair<String, Integer>> res2 = new ArrayList<Pair<String, Integer>>();
        s = s + " ";
        StringBuilder name2 = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name2.length() <= 0) continue;
                res2.add(Pair.create(name2.toString(), startInd));
                name2.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name2.append(s.charAt(i));
        }
        ArrayList<Pair<String, Integer>> arrayList = res2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isDecimalDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int compare(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int length1 = s1.length();
        int length2 = s2.length();
        for (int i = 0; i < length1 && i < length2; ++i) {
            int diff = Strings.compare(s1.charAt(i), s2.charAt(i), ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return length1 - length2;
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, false);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c;
        int start2;
        char c2;
        int start1;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    @NotNull
    public static String collapseWhiteSpace(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        StringBuilder result2 = new StringBuilder();
        boolean space = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (StringUtil.isWhiteSpace(ch)) {
                if (space) continue;
                space = true;
                continue;
            }
            if (space && result2.length() > 0) {
                result2.append(' ');
            }
            result2.append(ch);
            space = false;
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        for (String string2 : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string2)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatLinks(@NotNull String message2) {
        if (message2 == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9./\\-+]+");
        StringBuffer result2 = new StringBuffer();
        Matcher m = linkPattern.matcher(message2);
        while (m.find()) {
            m.appendReplacement(result2, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result2);
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol2) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        if (symbol2 == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol2.length();
            assert (prefixLength >= 0);
            String string2 = text2.substring(0, prefixLength) + symbol2 + text2.substring(textLength - suffixLength);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(413);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        String symbol2 = useEllipsisSymbol ? ELLIPSIS : THREE_DOTS;
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol2);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        return StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        return StringUtil.shortenPathWithEllipsis(path, maxLength, false);
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return Strings.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return Strings.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return Strings.toUpperCase(s);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return Strings.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean isUpperCase(@NotNull CharSequence sequence2) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(418);
        }
        for (int i = 0; i < sequence2.length(); ++i) {
            if (Character.isUpperCase(sequence2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text2) {
        int index2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        if ((index2 = StringUtil.indexOfAny(text2, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text2, index2);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text2, int index2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        if (index2 < 0 || index2 >= text2.length()) {
            return null;
        }
        char ch = text2.charAt(index2);
        if (ch == '\r') {
            return index2 + 1 < text2.length() && text2.charAt(index2 + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(421);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(422);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text2, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, keepCarriageReturn);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(425);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        return string2;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, int @Nullable [] offsetsToKeep) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator, offsetsToKeep);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        return string2;
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string2, int defaultValue) {
        return StringUtilRt.parseInt(string2, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string2, long defaultValue) {
        return StringUtilRt.parseLong(string2, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string2, double defaultValue) {
        return StringUtilRt.parseDouble(string2, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string2, E defaultValue, @NotNull Class<E> clazz) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        return StringUtilRt.parseEnum(string2, defaultValue, clazz);
    }

    @Contract(pure=true)
    @NotNull
    public static String getShortName(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        String string2 = StringUtilRt.getShortName(aClass);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String getShortName(@NotNull @NonNls String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        String string2 = StringUtilRt.getShortName(fqName2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String getShortName(@NotNull @NonNls String fqName2, char separator) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        String string2 = StringUtilRt.getShortName(fqName2, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        return string2;
    }

    public static boolean isShortNameOf(@NotNull String fqName2, @NotNull String shortName) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        if (shortName == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        if (fqName2.length() < shortName.length()) {
            return false;
        }
        if (fqName2.length() == shortName.length()) {
            return fqName2.equals(shortName);
        }
        int diff = fqName2.length() - shortName.length();
        if (fqName2.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName2.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className2 = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className2)) {
            return s;
        }
        return s.length() > className2.length() && !Character.isLetter(s.charAt(className2.length())) ? StringUtil.trimStart(s, className2) : s;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence2, long delay) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        final long myTime = System.currentTimeMillis() + delay;
        return new BombedCharSequence(sequence2){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string2, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(446);
        }
        return (s = StringUtil.toLowerCase(string2)).startsWith(StringUtil.toLowerCase(smallPart)) && StringUtil.toLowerCase(bigPart).startsWith(s);
    }

    public static boolean hasUpperCaseChar(@NotNull String s) {
        char[] chars;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(@NotNull String s) {
        char[] chars;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text2) {
        if (text2 == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text2);
        if (!matcher.find()) {
            return text2;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text2.length());
        while (matcher.find()) {
            sb.append(text2, lastEnd, matcher.start());
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text2.substring(lastEnd));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(449);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        String string2 = sb.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(450);
        }
        return string2;
    }

    @Contract(pure=true)
    public static byte @NotNull [] parseHexString(@NotNull String str) {
        int len;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        if ((len = str.length()) % 2 != 0) {
            throw new IllegalArgumentException("Non-even-length: " + str);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(452);
        }
        return bytes;
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    public static int skipWhitespaceForward(@NotNull CharSequence text2, int pos) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        int length = text2.length();
        while (pos < length && StringUtil.isWhitespaceOrTab(text2.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespaceBackward(@NotNull CharSequence text2, int pos) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(454);
        }
        while (pos > 0 && StringUtil.isWhitespaceOrTab(text2.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    private static boolean isWhitespaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    @Deprecated
    @Nls
    @NotNull
    public static String naturalJoin(List<String> strings2) {
        if (strings2.isEmpty()) {
            return "";
        }
        if (strings2.size() == 1) {
            String string2 = strings2.get(0);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(455);
            }
            return string2;
        }
        String lastWord = strings2.get(strings2.size() - 1);
        String leadingWords = StringUtil.join(strings2.subList(0, strings2.size() - 1), ", ");
        String string3 = leadingWords + " and " + lastWord;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(456);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 96: 
            case 109: 
            case 112: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 151: 
            case 162: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 365: 
            case 367: 
            case 368: 
            case 377: 
            case 379: 
            case 380: 
            case 385: 
            case 386: 
            case 387: 
            case 389: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 405: 
            case 408: 
            case 413: 
            case 414: 
            case 422: 
            case 424: 
            case 427: 
            case 430: 
            case 434: 
            case 436: 
            case 438: 
            case 450: 
            case 452: 
            case 455: 
            case 456: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 96: 
            case 109: 
            case 112: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 151: 
            case 162: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 365: 
            case 367: 
            case 368: 
            case 377: 
            case 379: 
            case 380: 
            case 385: 
            case 386: 
            case 387: 
            case 389: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 405: 
            case 408: 
            case 413: 
            case 414: 
            case 422: 
            case 424: 
            case 427: 
            case 430: 
            case 434: 
            case 436: 
            case 438: 
            case 450: 
            case 452: 
            case 455: 
            case 456: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 96: 
            case 109: 
            case 112: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 151: 
            case 162: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 365: 
            case 367: 
            case 368: 
            case 377: 
            case 379: 
            case 380: 
            case 385: 
            case 386: 
            case 387: 
            case 389: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 405: 
            case 408: 
            case 413: 
            case 414: 
            case 422: 
            case 424: 
            case 427: 
            case 430: 
            case 434: 
            case 436: 
            case 438: 
            case 450: 
            case 452: 
            case 455: 
            case 456: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 84: 
            case 85: 
            case 115: 
            case 168: 
            case 171: 
            case 172: 
            case 217: 
            case 252: 
            case 253: 
            case 255: 
            case 257: 
            case 259: 
            case 287: 
            case 299: 
            case 301: 
            case 305: 
            case 307: 
            case 310: 
            case 312: 
            case 316: 
            case 320: 
            case 341: 
            case 343: 
            case 352: 
            case 353: 
            case 355: 
            case 357: 
            case 361: 
            case 362: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 375: 
            case 381: 
            case 382: 
            case 409: 
            case 410: 
            case 411: 
            case 415: 
            case 419: 
            case 420: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 453: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 15: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 79: 
            case 141: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 406: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 322: 
            case 323: 
            case 327: 
            case 329: 
            case 330: 
            case 331: 
            case 333: 
            case 336: 
            case 339: 
            case 451: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 108: 
            case 111: 
            case 183: 
            case 258: 
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 135: 
            case 182: 
            case 254: 
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 35: 
            case 36: 
            case 435: 
            case 437: 
            case 439: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 46: 
            case 261: 
            case 264: 
            case 266: 
            case 268: 
            case 271: 
            case 402: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 47: 
            case 262: 
            case 265: 
            case 267: 
            case 269: 
            case 272: 
            case 403: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 88: 
            case 90: 
            case 93: 
            case 95: 
            case 107: 
            case 110: 
            case 113: 
            case 134: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 160: 
            case 164: 
            case 235: 
            case 238: 
            case 241: 
            case 243: 
            case 246: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 285: 
            case 286: 
            case 289: 
            case 291: 
            case 293: 
            case 295: 
            case 297: 
            case 309: 
            case 348: 
            case 383: 
            case 390: 
            case 391: 
            case 400: 
            case 404: 
            case 447: 
            case 448: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 82: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 231: 
            case 233: 
            case 290: 
            case 292: 
            case 294: 
            case 296: 
            case 298: 
            case 360: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 105: 
            case 118: 
            case 120: 
            case 122: 
            case 126: 
            case 128: 
            case 130: 
            case 248: 
            case 393: 
            case 394: 
            case 396: 
            case 398: 
            case 431: 
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 124: 
            case 132: 
            case 337: 
            case 338: 
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 137: 
            case 384: 
            case 388: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 174: 
            case 176: 
            case 187: 
            case 192: 
            case 195: 
            case 199: 
            case 203: 
            case 206: 
            case 209: 
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 175: 
            case 177: 
            case 184: 
            case 205: 
            case 208: 
            case 212: 
            case 214: 
            case 366: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 186: 
            case 191: 
            case 198: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 188: 
            case 190: 
            case 194: 
            case 197: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 204: 
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 221: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 229: 
            case 230: 
            case 232: 
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 236: 
            case 239: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 242: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 277: 
            case 279: 
            case 281: 
            case 283: 
            case 418: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 278: 
            case 280: 
            case 282: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 288: 
            case 300: 
            case 302: 
            case 306: 
            case 308: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 324: {
                objectArray2 = objectArray3;
                objectArray3[0] = "character";
                break;
            }
            case 326: 
            case 328: 
            case 335: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 345: 
            case 346: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 363: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 364: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 373: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 376: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 378: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 412: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 416: 
            case 417: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 426: 
            case 429: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 432: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 10: 
            case 365: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 65: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeAnsiStringCharacters";
                break;
            }
            case 83: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 89: 
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 109: 
            case 112: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 119: 
            case 121: 
            case 123: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 127: 
            case 129: 
            case 131: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 142: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 178: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 216: {
                objectArray = objectArray2;
                objectArray2[1] = "joining";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 220: 
            case 222: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 223: 
            case 225: 
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 251: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 303: 
            case 304: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 311: 
            case 313: 
            case 314: 
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 317: 
            case 318: 
            case 319: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 325: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlEntities";
                break;
            }
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeXmlEntities";
                break;
            }
            case 347: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 349: 
            case 350: 
            case 351: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEllipsisSuffix";
                break;
            }
            case 354: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 356: 
            case 359: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 367: 
            case 368: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 377: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 379: 
            case 380: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 385: 
            case 386: 
            case 387: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 389: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 399: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 405: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseWhiteSpace";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 413: 
            case 414: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 422: 
            case 424: 
            case 427: 
            case 430: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 434: 
            case 436: 
            case 438: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 450: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 452: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
            case 455: 
            case 456: {
                objectArray = objectArray2;
                objectArray2[1] = "naturalJoin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 96: 
            case 109: 
            case 112: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 151: 
            case 162: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 365: 
            case 367: 
            case 368: 
            case 377: 
            case 379: 
            case 380: 
            case 385: 
            case 386: 
            case 387: 
            case 389: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 405: 
            case 408: 
            case 413: 
            case 414: 
            case 422: 
            case 424: 
            case 427: 
            case 430: 
            case 434: 
            case 436: 
            case 438: 
            case 450: 
            case 452: 
            case 455: 
            case 456: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 362: 
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 70: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unescapeAnsiStringCharacters";
                break;
            }
            case 82: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 88: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 113: 
            case 442: 
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 118: 
            case 120: 
            case 122: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 126: 
            case 128: 
            case 130: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 224: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 238: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 241: 
            case 242: 
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 246: 
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 248: 
            case 249: 
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 253: 
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 261: 
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 273: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 274: 
            case 275: 
            case 276: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 301: 
            case 302: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 305: 
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 307: 
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 310: 
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 322: 
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 323: 
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 327: 
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 333: 
            case 335: 
            case 336: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 339: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 343: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 345: 
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "removeEllipsisSuffix";
                break;
            }
            case 352: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 353: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 355: 
            case 357: 
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 360: 
            case 361: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 366: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 369: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 370: 
            case 371: 
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 373: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 378: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 381: 
            case 382: 
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 388: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 390: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 393: 
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 402: 
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 409: 
            case 411: 
            case 412: 
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 416: 
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 421: 
            case 423: 
            case 425: 
            case 426: 
            case 428: 
            case 429: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 431: 
            case 432: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 433: 
            case 435: 
            case 437: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 439: 
            case 440: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 441: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 444: 
            case 445: 
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 447: {
                objectArray = objectArray;
                objectArray[2] = "hasUpperCaseChar";
                break;
            }
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "hasLowerCaseChar";
                break;
            }
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 451: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceForward";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceBackward";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 96: 
            case 109: 
            case 112: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 149: 
            case 151: 
            case 162: 
            case 163: 
            case 167: 
            case 169: 
            case 170: 
            case 173: 
            case 178: 
            case 181: 
            case 185: 
            case 189: 
            case 193: 
            case 196: 
            case 200: 
            case 207: 
            case 213: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 225: 
            case 227: 
            case 237: 
            case 240: 
            case 245: 
            case 251: 
            case 263: 
            case 270: 
            case 303: 
            case 304: 
            case 311: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 321: 
            case 325: 
            case 332: 
            case 334: 
            case 340: 
            case 342: 
            case 344: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 354: 
            case 356: 
            case 359: 
            case 365: 
            case 367: 
            case 368: 
            case 377: 
            case 379: 
            case 380: 
            case 385: 
            case 386: 
            case 387: 
            case 389: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 405: 
            case 408: 
            case 413: 
            case 414: 
            case 422: 
            case 424: 
            case 427: 
            case 430: 
            case 434: 
            case 436: 
            case 438: 
            case 450: 
            case 452: 
            case 455: 
            case 456: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;
        private boolean myDefused;

        public BombedCharSequence(@NotNull CharSequence sequence2) {
            if (sequence2 == null) {
                BombedCharSequence.$$$reportNull$$$0(0);
            }
            this.delegate = sequence2;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if (this.myDefused) {
                return;
            }
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string2 = this.delegate.toString();
            if (string2 == null) {
                BombedCharSequence.$$$reportNull$$$0(1);
            }
            return string2;
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i, int i1) {
            this.check();
            CharSequence charSequence2 = this.delegate.subSequence(i, i1);
            if (charSequence2 == null) {
                BombedCharSequence.$$$reportNull$$$0(2);
            }
            return charSequence2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        public void parse(@NotNull Reader in) throws IOException {
            if (in == null) {
                MyHtml2Text.$$$reportNull$$$0(0);
            }
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char @NotNull [] text2, int pos) {
            if (text2 == null) {
                MyHtml2Text.$$$reportNull$$$0(1);
            }
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text2);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag, MutableAttributeSet set, int i) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(2);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag, int pos) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(3);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(@NotNull HTML.Tag tag) {
            if (tag == null) {
                MyHtml2Text.$$$reportNull$$$0(4);
            }
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(System.lineSeparator());
            }
        }

        @NotNull
        public String getText() {
            String string2 = this.myBuffer.toString();
            if (string2 == null) {
                MyHtml2Text.$$$reportNull$$$0(5);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleStartTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEndTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTag";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Splitters {
        private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
        private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
        private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
        private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    }
}

