/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeAnnotationContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

public final class TypeInfo {
    public static final TypeInfo[] EMPTY_ARRAY = new TypeInfo[0];
    private static final String[] ourIndexFrequentType = new String[]{"", "boolean", "byte", "char", "double", "float", "int", "long", "null", "short", "void", "Object", "java.lang.Object", "String", "java.lang.String"};
    private static final Object2IntMap<String> ourFrequentTypeIndex = new Object2IntOpenHashMap<String>();
    private static final TypeInfo NULL;
    public final String text;
    public final byte arrayCount;
    public final boolean isEllipsis;
    private TypeAnnotationContainer myTypeAnnotations;

    public TypeInfo(String text2) {
        this(text2, 0, false);
    }

    public TypeInfo(String text2, byte arrayCount, boolean ellipsis) {
        this.text = text2 == null ? null : TypeInfo.internFrequentType(text2);
        this.arrayCount = arrayCount;
        this.isEllipsis = ellipsis;
    }

    public void setTypeAnnotations(@NotNull TypeAnnotationContainer typeAnnotations) {
        if (typeAnnotations == null) {
            TypeInfo.$$$reportNull$$$0(0);
        }
        if (this.myTypeAnnotations != null) {
            throw new IllegalStateException();
        }
        this.myTypeAnnotations = typeAnnotations;
    }

    @NotNull
    public TypeAnnotationContainer getTypeAnnotations() {
        TypeAnnotationContainer typeAnnotationContainer = this.myTypeAnnotations == null ? TypeAnnotationContainer.EMPTY : this.myTypeAnnotations;
        if (typeAnnotationContainer == null) {
            TypeInfo.$$$reportNull$$$0(1);
        }
        return typeAnnotationContainer;
    }

    @NotNull
    public String getShortTypeText() {
        if (this.text == null) {
            return "";
        }
        String name2 = PsiNameHelper.getShortClassName(this.text);
        if (this.arrayCount > 0) {
            name2 = name2 + StringUtil.repeat("[]", this.arrayCount);
        }
        String string2 = name2;
        if (string2 == null) {
            TypeInfo.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public String toString() {
        String text2 = TypeInfo.createTypeText(this);
        return text2 != null ? text2 : "null";
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        TypeInfo typeInfo = NULL;
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(3);
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo create(@NotNull LighterAST tree, @NotNull LighterASTNode element, StubElement<?> parentStub) {
        String text2;
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(4);
        }
        if (element == null) {
            TypeInfo.$$$reportNull$$$0(5);
        }
        int arrayCount = 0;
        boolean isEllipsis = false;
        boolean hasAnnotation = false;
        LighterASTNode typeElement = null;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            text2 = ((PsiClassStub)parentStub).getName();
        } else {
            for (LighterASTNode child : tree.getChildren(element)) {
                IElementType type2 = child.getTokenType();
                if (type2 == JavaElementType.TYPE) {
                    typeElement = child;
                    continue;
                }
                if (type2 != JavaTokenType.LBRACKET) continue;
                arrayCount = (byte)(arrayCount + 1);
            }
            if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
                LighterASTNode parent2 = tree.getParent(element);
                assert (parent2 != null) : element;
                List<LighterASTNode> fields2 = LightTreeUtil.getChildrenOfType(tree, parent2, JavaElementType.FIELD);
                int idx = fields2.indexOf(element);
                for (int i = idx - 1; i >= 0 && typeElement == null; --i) {
                    typeElement = LightTreeUtil.firstChildOfType(tree, (LighterASTNode)fields2.get(i), JavaElementType.TYPE);
                }
            }
            assert (typeElement != null) : element + " in " + parentStub;
            LighterASTNode nested = LightTreeUtil.firstChildOfType(tree, typeElement, JavaElementType.TYPE);
            if (nested != null) {
                for (LighterASTNode child : tree.getChildren(typeElement)) {
                    IElementType tokenType = child.getTokenType();
                    if (tokenType == JavaTokenType.LBRACKET) {
                        arrayCount = (byte)(arrayCount + 1);
                        continue;
                    }
                    if (tokenType == JavaTokenType.ELLIPSIS) {
                        arrayCount = (byte)(arrayCount + 1);
                        isEllipsis = true;
                        continue;
                    }
                    if (tokenType != JavaElementType.ANNOTATION) continue;
                    hasAnnotation = true;
                }
                text2 = LightTreeUtil.toFilteredString(tree, nested, null);
            } else {
                text2 = LightTreeUtil.toFilteredString(tree, typeElement, null);
            }
        }
        TypeInfo info = new TypeInfo(text2, (byte)arrayCount, isEllipsis);
        if (hasAnnotation) {
            TypeAnnotationContainer.Collector collector2 = new TypeAnnotationContainer.Collector(info);
            int nestingLevel = arrayCount;
            for (LighterASTNode child : tree.getChildren(typeElement)) {
                IElementType tokenType = child.getTokenType();
                if (tokenType == JavaElementType.TYPE) {
                    nestingLevel = 0;
                    continue;
                }
                if (tokenType == JavaTokenType.LBRACKET) {
                    ++nestingLevel;
                    continue;
                }
                if (tokenType != JavaElementType.ANNOTATION) continue;
                String anno = LightTreeUtil.toFilteredString(tree, child, null);
                byte[] typePath = new byte[nestingLevel];
                Arrays.fill(typePath, (byte)0);
                collector2.add(typePath, anno);
            }
            collector2.install();
        }
        TypeInfo typeInfo = info;
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(6);
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText, boolean isEllipsis) {
        if (typeText == null) {
            TypeInfo.$$$reportNull$$$0(7);
        }
        assert (!typeText.endsWith("...")) : typeText;
        byte arrayCount = 0;
        while (typeText.endsWith("[]")) {
            arrayCount = (byte)(arrayCount + 1);
            typeText = typeText.substring(0, typeText.length() - 2);
        }
        return new TypeInfo(typeText, arrayCount, isEllipsis);
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText) {
        if (typeText == null) {
            TypeInfo.$$$reportNull$$$0(8);
        }
        boolean isEllipsis = false;
        if (typeText.endsWith("...")) {
            isEllipsis = true;
            typeText = typeText.substring(0, typeText.length() - 3);
        }
        return TypeInfo.fromString(typeText, isEllipsis);
    }

    @NotNull
    public static TypeInfo readTYPE(@NotNull StubInputStream record2) throws IOException {
        int flags;
        if (record2 == null) {
            TypeInfo.$$$reportNull$$$0(9);
        }
        if ((flags = record2.readByte() & 0xFF) == 31) {
            TypeInfo typeInfo = NULL;
            if (typeInfo == null) {
                TypeInfo.$$$reportNull$$$0(10);
            }
            return typeInfo;
        }
        byte arrayCount = BitUtil.isSet(flags, 64) ? record2.readByte() : (byte)0;
        boolean hasEllipsis = BitUtil.isSet(flags, 128);
        boolean hasTypeAnnotations = BitUtil.isSet(flags, 32);
        int frequentIndex = 0x1F & flags;
        String text2 = frequentIndex == 0 ? record2.readNameString() : ourIndexFrequentType[frequentIndex];
        TypeInfo info = new TypeInfo(text2, arrayCount, hasEllipsis);
        info.setTypeAnnotations(hasTypeAnnotations ? TypeAnnotationContainer.readTypeAnnotations(record2) : TypeAnnotationContainer.EMPTY);
        TypeInfo typeInfo = info;
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(11);
        }
        return typeInfo;
    }

    public static void writeTYPE(@NotNull StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (dataStream == null) {
            TypeInfo.$$$reportNull$$$0(12);
        }
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(13);
        }
        if (typeInfo == NULL) {
            dataStream.writeByte(31);
            return;
        }
        String text2 = typeInfo.text;
        byte arrayCount = typeInfo.arrayCount;
        int frequentIndex = ourFrequentTypeIndex.getInt(text2);
        boolean hasTypeAnnotations = typeInfo.myTypeAnnotations != null && !typeInfo.myTypeAnnotations.isEmpty();
        int flags = (typeInfo.isEllipsis ? 128 : 0) | (arrayCount != 0 ? 64 : 0) | (hasTypeAnnotations ? 32 : 0) | frequentIndex;
        dataStream.writeByte(flags);
        if (arrayCount != 0) {
            dataStream.writeByte(arrayCount);
        }
        if (frequentIndex == 0) {
            dataStream.writeName(text2);
        }
        if (hasTypeAnnotations) {
            TypeAnnotationContainer.writeTypeAnnotations(dataStream, typeInfo.myTypeAnnotations);
        }
    }

    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(14);
        }
        if (typeInfo == NULL || typeInfo.text == null) {
            return null;
        }
        if (typeInfo.arrayCount == 0) {
            return typeInfo.text;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(typeInfo.text);
        int arrayCount = typeInfo.isEllipsis ? typeInfo.arrayCount - 1 : typeInfo.arrayCount;
        for (int i = 0; i < arrayCount; ++i) {
            buf.append("[]");
        }
        if (typeInfo.isEllipsis) {
            buf.append("...");
        }
        return TypeInfo.internFrequentType(buf.toString());
    }

    @NotNull
    public static String internFrequentType(@NotNull String type2) {
        int frequentIndex;
        if (type2 == null) {
            TypeInfo.$$$reportNull$$$0(15);
        }
        String string2 = (frequentIndex = ourFrequentTypeIndex.getInt(type2)) == 0 ? StringUtil.internEmptyString(type2) : ourIndexFrequentType[frequentIndex];
        if (string2 == null) {
            TypeInfo.$$$reportNull$$$0(16);
        }
        return string2;
    }

    static {
        for (int i = 0; i < ourIndexFrequentType.length; ++i) {
            ourFrequentTypeIndex.put(ourIndexFrequentType[i], i);
        }
        assert (ourFrequentTypeIndex.size() == ourIndexFrequentType.length);
        NULL = new TypeInfo(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readTYPE";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "internFrequentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTypeAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readTYPE";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeTYPE";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTypeText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "internFrequentType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

