/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.NoMatchingArtifactVariantsException;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.IncompatibleResolutionFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class IncompatibleArtifactVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<NoMatchingArtifactVariantsException, IncompatibleResolutionFailure> {
    private static final String NO_MATCHING_VARIANTS_PREFIX = "No matching variant errors are explained in more detail at ";
    private static final String NO_MATCHING_VARIANTS_SECTION = "sub:variant-no-match";

    @Override
    public NoMatchingArtifactVariantsException describeFailure(IncompatibleResolutionFailure failure) {
        String msg = this.buildIncompatibleArtifactVariantsFailureMsg(failure);
        NoMatchingArtifactVariantsException result = new NoMatchingArtifactVariantsException(msg);
        this.suggestSpecificDocumentation(result, NO_MATCHING_VARIANTS_PREFIX, NO_MATCHING_VARIANTS_SECTION);
        this.suggestReviewAlgorithm(result);
        return result;
    }

    private String buildIncompatibleArtifactVariantsFailureMsg(IncompatibleResolutionFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), failure.getSchema());
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No variants of " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.getRequestedName()) + " match the consumer attributes");
        formatter.startChildren();
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : failure.getCandidates()) {
            formatter.node(assessedCandidate.getDisplayName());
            this.formatAttributeMatchesForIncompatibility(assessedCandidate, formatter, describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

