;; VR5000 pipeline description.
;;   Copyright (C) 2004-2023 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.

(define_insn_reservation "r5k_load" 2
  (and (eq_attr "cpu" "r5000")
       (eq_attr "type" "load,fpload,fpidxload,mfc,mtc"))
  "alu")

(define_insn_reservation "r5k_imul_si" 5
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "imul,imul3,imadd")
	    (eq_attr "mode" "SI")))
  "imuldiv*5")

(define_insn_reservation "r5k_imul_di" 9
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "imul,imul3,imadd")
	    (eq_attr "mode" "DI")))
  "imuldiv*9")

(define_insn_reservation "r5k_idiv_si" 36
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "SI")))
  "imuldiv*36")

(define_insn_reservation "r5k_idiv_di" 68
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "imuldiv*68")

(define_insn_reservation "r5k_fmove" 1
  (and (eq_attr "cpu" "r5000")
       (eq_attr "type" "fcmp,fabs,fneg,fmove"))
  "alu")

(define_insn_reservation "r5k_fmul_single" 4
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r5k_fmul_double" 5
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "DF")))
  "alu")

(define_insn_reservation "r5k_fdiv_single" 21
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r5k_fsqrt_double" 36
  (and (eq_attr "cpu" "r5000")
       (and (eq_attr "type" "fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "alu")
