/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Enumeration;

public class CvsLogParser
implements Enumeration {
    protected StreamTokenizer st;
    protected boolean changes = false;
    protected boolean more = false;

    public CvsLogParser(String file) throws FileNotFoundException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        this.st = new StreamTokenizer(r);
        this.st.eolIsSignificant(true);
        this.st.ordinaryChar(47);
        this.st.ordinaryChar(39);
        this.more = true;
    }

    public boolean hasMoreElements() {
        return this.more;
    }

    public Object nextElement() {
        StringBuffer token = new StringBuffer();
        StringBuffer line = new StringBuffer();
        boolean moreToken = true;
        this.changes = false;
        try {
            block8: while (this.more && moreToken) {
                this.st.nextToken();
                switch (this.st.ttype) {
                    case -1: {
                        this.more = false;
                    }
                    case 10: {
                        token.append(line.toString());
                        if (line.toString().endsWith("=============================================================================")) {
                            moreToken = false;
                            continue block8;
                        }
                        line = new StringBuffer("\n");
                        continue block8;
                    }
                    case -3: {
                        line.append(this.st.sval);
                        line.append(' ');
                        continue block8;
                    }
                    case -2: {
                        if (this.st.nval > 0.0 && line.toString().endsWith("selected revisions :")) {
                            this.changes = true;
                        }
                        line.append(this.st.nval);
                        continue block8;
                    }
                }
                line.append((char)this.st.ttype);
            }
            return token.toString();
        }
        catch (IOException ioe) {
            this.more = false;
            return "";
        }
    }

    private boolean hasChanged() {
        return this.changes;
    }

    public static void main(String[] args) {
        try {
            CvsLogParser p = new CvsLogParser(args[0]);
            while (p.hasMoreElements()) {
                String token = (String)p.nextElement();
                if (!p.hasChanged()) continue;
                System.out.println(token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

