/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openide.util.Utilities;

public final class TopologicalSortException
extends Exception {
    private Collection vertexes;
    private Map edges;
    private Set[] result;
    private int counter;
    private Stack dualGraph = new Stack();

    TopologicalSortException(Collection collection, Map map) {
        this.vertexes = collection;
        this.edges = map;
    }

    public final List partialSort() {
        Set[] setArray = this.topologicalSets();
        ArrayList arrayList = new ArrayList(this.vertexes.size());
        for (int i = 0; i < setArray.length; ++i) {
            arrayList.addAll(setArray[i]);
        }
        return arrayList;
    }

    public final Set[] unsortableSets() {
        Set[] setArray = this.topologicalSets();
        ArrayList<Set> arrayList = new ArrayList<Set>();
        for (int i = 0; i < setArray.length; ++i) {
            if (setArray[i].size() <= 1 && setArray[i] instanceof HashSet) continue;
            arrayList.add(setArray[i]);
        }
        return arrayList.toArray(new Set[0]);
    }

    public final void printStackTrace(PrintWriter printWriter) {
        printWriter.print("TopologicalSortException - Collection: ");
        printWriter.print(this.vertexes);
        printWriter.print(" with edges ");
        printWriter.print(this.edges);
        printWriter.println(" cannot be sorted");
        Set[] setArray = this.unsortableSets();
        for (int i = 0; i < setArray.length; ++i) {
            printWriter.print(" Conflict #");
            printWriter.print(i);
            printWriter.print(": ");
            printWriter.println(setArray[i]);
        }
        super.printStackTrace(printWriter);
    }

    public final void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    public final Set[] topologicalSets() {
        Object object;
        Object object2;
        if (this.result != null) {
            return this.result;
        }
        HashMap hashMap = new HashMap();
        this.counter = 0;
        Iterator<Object> iterator = this.vertexes.iterator();
        while (iterator.hasNext()) {
            this.constructDualGraph(this.counter, iterator.next(), hashMap);
        }
        HashMap<Object, Set<Object>> hashMap2 = new HashMap<Object, Set<Object>>();
        ArrayList<Set<Object>> arrayList = new ArrayList<Set<Object>>();
        while (!this.dualGraph.isEmpty()) {
            object2 = (Vertex)this.dualGraph.pop();
            if (((Vertex)object2).visited) continue;
            object = new HashSet();
            this.visitDualGraph((Vertex)object2, (Collection)object);
            if (object.size() == 1 && ((Vertex)object2).edgesFrom.contains(object2)) {
                object = Collections.singleton(((Vertex)object2).object);
            }
            arrayList.add((Set<Object>)object);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                hashMap2.put(iterator.next(), (Set<Object>)object);
            }
        }
        object2 = new HashMap();
        iterator = this.edges.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            Collection collection = (Collection)object.getValue();
            if (collection == null || collection.isEmpty()) continue;
            Set set = (Set)hashMap2.get(object.getKey());
            ArrayList<Set> arrayList2 = (ArrayList<Set>)((HashMap)object2).get(set);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Set>();
                ((HashMap)object2).put(set, arrayList2);
            }
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Set set2 = (Set)hashMap2.get(iterator2.next());
                if (set == set2) continue;
                arrayList2.add(set2);
            }
        }
        try {
            this.result = Utilities.topologicalSort(arrayList, (Map)object2).toArray(new Set[0]);
        }
        catch (TopologicalSortException topologicalSortException) {
            throw new IllegalStateException("Cannot happen");
        }
        return this.result;
    }

    private Vertex constructDualGraph(int n, Object object, HashMap hashMap) {
        Vertex vertex = (Vertex)hashMap.get(object);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex(object, n++);
        hashMap.put(object, vertex);
        Collection collection = (Collection)this.edges.get(object);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vertex vertex2 = this.constructDualGraph(n, iterator.next(), hashMap);
                vertex2.edgesFrom.add(vertex);
            }
        }
        vertex.y = n++;
        this.dualGraph.push(vertex);
        return vertex;
    }

    private void visitDualGraph(Vertex vertex, Collection collection) {
        if (vertex.visited) {
            return;
        }
        collection.add(vertex.object);
        vertex.visited = true;
        Iterator iterator = vertex.edges();
        while (iterator.hasNext()) {
            Vertex vertex2 = (Vertex)iterator.next();
            this.visitDualGraph(vertex2, collection);
        }
    }

    private static final class Vertex
    implements Comparable {
        public Object object;
        public List edgesFrom = new ArrayList();
        public final int x;
        public int y;
        public boolean sorted;
        public boolean visited;

        public Vertex(Object object, int n) {
            this.x = n;
            this.object = object;
        }

        public Iterator edges() {
            if (!this.sorted) {
                Collections.sort(this.edgesFrom);
                this.sorted = true;
            }
            return this.edgesFrom.iterator();
        }

        public int compareTo(Object object) {
            Vertex vertex = (Vertex)object;
            return vertex.y - this.y;
        }
    }
}

