/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.argouml.core.propertypanels.ui.ScrollList;
import org.argouml.core.propertypanels.ui.SimpleListModel;
import org.argouml.core.propertypanels.ui.UMLLinkedList;

class ScrollListImpl
extends JScrollPane
implements ScrollList,
KeyListener {
    private static final long serialVersionUID = 6711776013279497682L;
    private UMLLinkedList list;
    int originalHeight;

    public ScrollListImpl(SimpleListModel listModel) {
        this.setHorizontalScrollBarPolicy(31);
        this.list = new UMLLinkedList(listModel, true, false);
        this.setViewportView(this.list);
    }

    public ScrollListImpl(ListModel listModel, int visibleRowCount) {
        this.setHorizontalScrollBarPolicy(31);
        this.list = new UMLLinkedList(listModel, true, true);
        this.list.setVisibleRowCount(visibleRowCount);
        this.setViewportView(this.list);
    }

    @Deprecated
    public ScrollListImpl(JList alist) {
        this.setHorizontalScrollBarPolicy(31);
        this.list = (UMLLinkedList)alist;
        this.setViewportView(this.list);
    }

    public ListModel getListModel() {
        return this.list.getModel();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            Point posn = this.getViewport().getViewPosition();
            if (posn.x > 0) {
                this.getViewport().setViewPosition(new Point(posn.x - 1, posn.y));
            }
        } else if (e.getKeyCode() == 39) {
            Point posn = this.getViewport().getViewPosition();
            if (this.list.getWidth() - posn.x > this.getViewport().getWidth()) {
                this.getViewport().setViewPosition(new Point(posn.x + 1, posn.y));
            }
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void addNotify() {
        super.addNotify();
        this.list.addKeyListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.list.removeKeyListener(this);
    }

    public JList getList() {
        return this.list;
    }
}

