/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.model.Model;
import org.argouml.uml.ui.UMLListCellRenderer2;

public class UMLEditableComboBox
extends UMLComboBox
implements FocusListener {
    public UMLEditableComboBox(UMLComboBoxModel model, Action selectAction, boolean showIcon) {
        super(model, showIcon);
        this.setEditable(true);
        this.setEditor(new UMLComboBoxEditor(showIcon));
        this.getEditor().addActionListener(this);
    }

    public UMLEditableComboBox(UMLComboBoxModel model, Action selectAction) {
        this(model, selectAction, true);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() instanceof JTextField) {
            Object oldValue = this.getSelectedItem();
            ComboBoxEditor editor = this.getEditor();
            Object item = editor.getItem();
            this.doOnEdit(item);
            if (oldValue == this.getSelectedItem()) {
                this.getEditor().setItem(this.getSelectedItem());
            }
        }
    }

    protected void doOnEdit(Object item) {
    }

    public final void focusGained(FocusEvent arg0) {
        this.getEditor().selectAll();
    }

    public final void focusLost(FocusEvent arg0) {
        this.doOnEdit(this.getEditor().getItem());
    }

    public void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        ((UMLComboBoxModel)this.getModel()).setFilter("");
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected class UMLComboBoxEditor
    extends BasicComboBoxEditor {
        private UMLImagePanel panel;
        private boolean theShowIcon;

        public UMLComboBoxEditor(boolean showIcon) {
            this.panel = new UMLImagePanel(this.editor, showIcon);
            this.setShowIcon(showIcon);
        }

        public void setItem(Object anObject) {
            if (((UMLComboBoxModel)UMLEditableComboBox.this.getModel()).contains(anObject)) {
                this.editor.setText(((UMLListCellRenderer2)UMLEditableComboBox.this.getRenderer()).makeText(anObject));
                if (this.theShowIcon && anObject != null) {
                    this.panel.setIcon(ResourceLoaderWrapper.getInstance().lookupIcon(anObject));
                }
            } else if (Model.getFacade().isAUMLElement(anObject)) {
                super.setItem(Model.getFacade().getName(anObject));
            } else {
                super.setItem(anObject);
            }
        }

        public boolean isShowIcon() {
            return this.theShowIcon;
        }

        public void setShowIcon(boolean showIcon) {
            this.theShowIcon = showIcon;
        }

        public Component getEditorComponent() {
            return this.panel;
        }

        public void addActionListener(ActionListener l) {
            this.panel.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.panel.removeActionListener(l);
        }

        public void selectAll() {
            super.selectAll();
        }

        public Object getItem() {
            return this.panel.getText();
        }

        private class UMLImagePanel
        extends JPanel {
            private JLabel imageIconLabel = new JLabel();
            private JTextField theTextField;
            private boolean keyTyped = false;

            public UMLImagePanel(JTextField textField, boolean showIcon) {
                this.setLayout(new BorderLayout());
                this.theTextField = textField;
                this.setBorder(BorderFactory.createBevelBorder(1));
                if (showIcon) {
                    this.imageIconLabel.setOpaque(true);
                    this.imageIconLabel.setBackground(this.theTextField.getBackground());
                    this.add((Component)this.imageIconLabel, "West");
                }
                this.add((Component)this.theTextField, "Center");
                this.theTextField.addFocusListener(UMLEditableComboBox.this);
                this.theTextField.addKeyListener(new KeyListener(){

                    public void keyTyped(KeyEvent arg0) {
                        UMLImagePanel.this.keyTyped = true;
                    }

                    public void keyReleased(KeyEvent arg0) {
                    }

                    public void keyPressed(KeyEvent arg0) {
                    }
                });
                this.theTextField.getDocument().addDocumentListener(new DocumentListener(){

                    public void changedUpdate(DocumentEvent ev) {
                        try {
                            String filter = ev.getDocument().getText(0, ev.getDocument().getLength());
                            if (UMLImagePanel.this.keyTyped) {
                                ((UMLComboBoxModel)UMLEditableComboBox.this.getModel()).setFilter(filter);
                                UMLImagePanel.this.keyTyped = false;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }

                    public void insertUpdate(DocumentEvent ev) {
                        try {
                            String filter = ev.getDocument().getText(0, ev.getDocument().getLength());
                            if (UMLImagePanel.this.keyTyped) {
                                ((UMLComboBoxModel)UMLEditableComboBox.this.getModel()).setFilter(filter);
                                UMLImagePanel.this.keyTyped = false;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }

                    public void removeUpdate(DocumentEvent ev) {
                        try {
                            String filter = ev.getDocument().getText(0, ev.getDocument().getLength());
                            if (UMLImagePanel.this.keyTyped) {
                                ((UMLComboBoxModel)UMLEditableComboBox.this.getModel()).setFilter(filter);
                                UMLImagePanel.this.keyTyped = false;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }

            public void setText(String text) {
                this.theTextField.setText(text);
            }

            public String getText() {
                return this.theTextField.getText();
            }

            public void setIcon(Icon i) {
                if (i != null) {
                    this.imageIconLabel.setIcon(i);
                    this.imageIconLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                } else {
                    this.imageIconLabel.setIcon(null);
                    this.imageIconLabel.setBorder(null);
                }
                this.imageIconLabel.invalidate();
                this.validate();
                this.repaint();
            }

            public void selectAll() {
                this.theTextField.selectAll();
            }

            public void addActionListener(ActionListener l) {
                this.theTextField.addActionListener(l);
            }

            public void removeActionListener(ActionListener l) {
                this.theTextField.removeActionListener(l);
            }
        }
    }
}

