/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.argouml.core.propertypanels.ui.ActionSetMultiplicity;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.core.propertypanels.ui.UMLSearchableComboBox;
import org.argouml.model.Model;

class UMLMultiplicityPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -3087728411434482078L;
    private MultiplicityComboBox multiplicityComboBox;
    private MultiplicityCheckBox checkBox;
    private static List<String> multiplicityList = new ArrayList<String>();

    public UMLMultiplicityPanel(String propertyName, Object target) {
        super(new BorderLayout());
        if (target == null) {
            throw new IllegalArgumentException("A target must be supplied");
        }
        MultiplicityComboBoxModel multiplicityComboBoxModel = new MultiplicityComboBoxModel(target, propertyName);
        this.checkBox = new MultiplicityCheckBox(target);
        this.multiplicityComboBox = new MultiplicityComboBox(multiplicityComboBoxModel, multiplicityComboBoxModel.getAction());
        this.multiplicityComboBox.setEditable(true);
        this.multiplicityComboBox.addItemListener(this);
        this.add((Component)this.checkBox, "West");
        this.add((Component)this.multiplicityComboBox, "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getMinimumSize().height);
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.multiplicityComboBox) {
            String item = (String)this.multiplicityComboBox.getSelectedItem();
            Object target = this.multiplicityComboBox.getTarget();
            String currentMult = Model.getFacade().toString(Model.getFacade().getMultiplicity(target));
            if (!currentMult.equals(item)) {
                Model.getCoreHelper().setMultiplicity(target, item);
            }
        }
    }

    private Object getTarget() {
        return this.multiplicityComboBox.getTarget();
    }

    static {
        multiplicityList.add("1");
        multiplicityList.add("0..1");
        multiplicityList.add("0..*");
        multiplicityList.add("1..*");
    }

    private class MultiplicityCheckBox
    extends JCheckBox
    implements ItemListener {
        public MultiplicityCheckBox(Object target) {
            this.setSelected(Model.getFacade().getMultiplicity(target) != null);
            this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String comboText = (String)UMLMultiplicityPanel.this.multiplicityComboBox.getSelectedItem();
                if (comboText == null) {
                    Model.getCoreHelper().setMultiplicity(UMLMultiplicityPanel.this.getTarget(), "1");
                } else {
                    Model.getCoreHelper().setMultiplicity(UMLMultiplicityPanel.this.getTarget(), comboText);
                }
                UMLMultiplicityPanel.this.multiplicityComboBox.setEnabled(true);
                UMLMultiplicityPanel.this.multiplicityComboBox.setEditable(true);
            } else {
                UMLMultiplicityPanel.this.multiplicityComboBox.setEnabled(false);
                UMLMultiplicityPanel.this.multiplicityComboBox.setEditable(false);
                Model.getCoreHelper().setMultiplicity(UMLMultiplicityPanel.this.getTarget(), null);
            }
        }
    }

    private class MultiplicityComboBoxModel
    extends UMLComboBoxModel {
        private static final long serialVersionUID = 1096137101625304715L;

        public MultiplicityComboBoxModel(Object target, String propertySetName) {
            super(target, propertySetName, false);
        }

        protected boolean isValidElement(Object element) {
            return element instanceof String;
        }

        protected void buildModelList() {
            this.setElements(multiplicityList);
            Object t = this.getTarget();
            if (Model.getFacade().isAModelElement(t)) {
                this.addElement(Model.getFacade().toString(Model.getFacade().getMultiplicity(t)));
            }
        }

        public void addElement(Object o) {
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("Only strings can be added to the combo");
            }
            if (!multiplicityList.contains(o) && this.isValidElement(o)) {
                multiplicityList.add((String)o);
            }
            super.addElement(o);
        }

        public void setSelectedItem(Object anItem) {
            if (!(anItem instanceof String)) {
                anItem = Model.getFacade().toString(anItem);
            }
            this.addElement(anItem);
            super.setSelectedItem(anItem);
        }

        protected Object getSelectedModelElement() {
            if (this.getTarget() != null) {
                return Model.getFacade().toString(Model.getFacade().getMultiplicity(this.getTarget()));
            }
            return null;
        }

        public Action getAction() {
            return new ActionSetClassifierRoleMultiplicity();
        }

        class ActionSetClassifierRoleMultiplicity
        extends ActionSetMultiplicity {
            private static final long serialVersionUID = -6091471231385415904L;

            public void setSelectedItem(Object item, Object target) {
                if (target != null && Model.getFacade().isAClassifierRole(target)) {
                    if (Model.getFacade().isAMultiplicity(item)) {
                        Model.getCoreHelper().setMultiplicity(target, item);
                    } else if (item instanceof String) {
                        Model.getCoreHelper().setMultiplicity(target, (String)item);
                    }
                }
            }
        }
    }

    private class MultiplicityComboBox
    extends UMLSearchableComboBox {
        private static final long serialVersionUID = -5860730478954634611L;

        public MultiplicityComboBox(MultiplicityComboBoxModel model, Action selectAction) {
            super((UMLComboBoxModel)model, selectAction);
            Object target = model.getTarget();
            boolean exists = Model.getFacade().getMultiplicity(target) != null;
            this.setEnabled(exists);
            this.setEditable(exists);
        }

        protected void doOnEdit(Object item) {
            String text = (String)item;
            Model.getCoreHelper().setMultiplicity(this.getTarget(), text);
            text = Model.getFacade().toString(Model.getFacade().getMultiplicity(this.getTarget()));
            Object o = this.search(text);
            if (o == null) {
                ((MultiplicityComboBoxModel)this.getModel()).addElement(text);
            }
            this.setSelectedItem(text);
            this.getEditor().setItem(text);
        }
    }
}

