/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.uml.ui.AbstractActionAddModelElement2;
import org.argouml.uml.ui.AbstractActionRemoveElement;

class UMLSignalContextListModel
extends UMLModelElementListModel {
    private static final long serialVersionUID = 2002737769556890982L;

    public UMLSignalContextListModel(Object modelElement) {
        super("context", modelElement.getClass(), (AbstractActionAddModelElement2)new ActionAddContextSignal(), new ActionRemoveContextSignal());
        this.setTarget(modelElement);
    }

    protected void buildModelList() {
        if (this.getTarget() != null) {
            this.setAllElements(Model.getFacade().getContexts(this.getTarget()));
        }
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isABehavioralFeature(element) && Model.getFacade().getContexts(this.getTarget()).contains(element);
    }

    private static class ActionAddContextSignal
    extends AbstractActionAddModelElement2 {
        protected List getChoices() {
            ArrayList ret = new ArrayList();
            Object model = ProjectManager.getManager().getCurrentProject().getModel();
            if (this.getTarget() != null) {
                ret.addAll(Model.getModelManagementHelper().getAllBehavioralFeatures(model));
            }
            return ret;
        }

        protected List getSelected() {
            ArrayList ret = new ArrayList();
            ret.addAll(Model.getFacade().getContexts(this.getTarget()));
            return ret;
        }

        protected String getDialogTitle() {
            return Translator.localize((String)"dialog.title.add-contexts");
        }

        protected void doIt(Collection selected) {
            Model.getCommonBehaviorHelper().setContexts(this.getTarget(), selected);
        }
    }

    private static class ActionRemoveContextSignal
    extends AbstractActionRemoveElement {
        private static final long serialVersionUID = -3345844954130000669L;

        public ActionRemoveContextSignal() {
            super(Translator.localize((String)"menu.popup.remove"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object context = this.getObjectToRemove();
            if (context != null) {
                Object signal = this.getTarget();
                if (Model.getFacade().isASignal(signal)) {
                    Model.getCommonBehaviorHelper().removeContext(signal, context);
                }
            }
        }
    }
}

