/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.model.UmlChangeEvent;
import org.argouml.ui.UndoableAction;

class UMLStateMachineContextComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 7260158369581330096L;

    public UMLStateMachineContextComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, false);
    }

    protected void buildModelList() {
        ArrayList elements = new ArrayList();
        Project p = ProjectManager.getManager().getCurrentProject();
        for (Object model : p.getUserDefinedModelList()) {
            elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getClassifier()));
            elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getBehavioralFeature()));
        }
        this.setElements(elements);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAClassifier(element) || Model.getFacade().isABehavioralFeature(element);
    }

    protected Object getSelectedModelElement() {
        return Model.getFacade().getContext(this.getTarget());
    }

    public void modelChanged(UmlChangeEvent evt) {
    }

    public Action getAction() {
        return new ActionSetContextStateMachine();
    }

    private class ActionSetContextStateMachine
    extends UndoableAction {
        private static final long serialVersionUID = -8118983979324112900L;

        protected ActionSetContextStateMachine() {
            super(Translator.localize((String)"action.set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"action.set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox source = (UMLComboBox)e.getSource();
            Object target = source.getTarget();
            if (Model.getFacade().getContext(target) != source.getSelectedItem()) {
                Model.getStateMachinesHelper().setContext(target, source.getSelectedItem());
            }
        }
    }
}

