/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;
import org.argouml.uml.util.PathComparator;

class UMLStructuralFeatureTypeComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 2283910742530930285L;

    public UMLStructuralFeatureTypeComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAClass(element) || Model.getFacade().isAInterface(element) || Model.getFacade().isADataType(element);
    }

    protected void buildModelList() {
        TreeSet elements = new TreeSet(new PathComparator());
        Project p = ProjectManager.getManager().getCurrentProject();
        if (p == null) {
            return;
        }
        if (Model.getFacade().getUmlVersion().charAt(0) != '1' && Model.getFacade().isAStereotype(Model.getFacade().getOwner(this.getTarget()))) {
            elements.addAll(Model.getExtensionMechanismsHelper().getCommonTaggedValueTypes());
        } else {
            for (Object model : p.getUserDefinedModelList()) {
                elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getUMLClass()));
                elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getInterface()));
                elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getDataType()));
            }
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                elements.addAll(p.getProfileConfiguration().findByMetaType(Model.getMetaTypes().getClassifier()));
            } else {
                elements.addAll(p.getProfileConfiguration().findByMetaType(Model.getMetaTypes().getDataType()));
                elements.addAll(Model.getExtensionMechanismsHelper().getCommonTaggedValueTypes());
            }
        }
        this.setElements(elements);
    }

    protected void buildMinimalModelList() {
        ArrayList<Object> list = new ArrayList<Object>(1);
        Object element = this.getSelectedModelElement();
        if (element != null) {
            list.add(element);
        }
        this.setElements(list);
    }

    protected boolean isLazy() {
        return true;
    }

    protected Object getSelectedModelElement() {
        Object o = null;
        if (this.getTarget() != null) {
            o = Model.getFacade().getType(this.getTarget());
        }
        return o;
    }

    protected void addOtherModelEventListeners(Object newTarget) {
        super.addOtherModelEventListeners(newTarget);
        Model.getPump().addClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getNamespace(), "ownedElement");
        Model.getPump().addClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getUMLClass(), "name");
        Model.getPump().addClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getInterface(), "name");
        Model.getPump().addClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getDataType(), "name");
    }

    protected void removeOtherModelEventListeners(Object oldTarget) {
        super.removeOtherModelEventListeners(oldTarget);
        Model.getPump().removeClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getNamespace(), "ownedElement");
        Model.getPump().removeClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getUMLClass(), "name");
        Model.getPump().removeClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getInterface(), "name");
        Model.getPump().removeClassModelEventListener((PropertyChangeListener)this, Model.getMetaTypes().getDataType(), "name");
    }

    public Action getAction() {
        return new ActionSetStructuralFeatureType();
    }

    class ActionSetStructuralFeatureType
    extends UndoableAction {
        private static final long serialVersionUID = 8227201276430122294L;

        protected ActionSetStructuralFeatureType() {
            super(Translator.localize((String)"Set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"Set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            assert (e.getSource() instanceof UMLComboBox);
            Object oldClassifier = null;
            UMLComboBox box = (UMLComboBox)e.getSource();
            Object feature = box.getTarget();
            assert (feature != null);
            oldClassifier = Model.getFacade().getType(feature);
            Object selectedClassifier = box.getSelectedItem();
            Object newClassifier = Model.getFacade().isAElement(selectedClassifier) ? selectedClassifier : null;
            if (newClassifier != oldClassifier) {
                Model.getCoreHelper().setType(feature, newClassifier);
            }
        }
    }
}

