/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.transformer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.model.Model;
import org.argouml.transformer.Transformer;
import org.argouml.transformer.TransformerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventTransformer
implements Transformer {
    EventTransformer() {
    }

    @Override
    public List<Action> actions(Project p, Object sourceModelElement) {
        assert (Model.getFacade().isAEvent(sourceModelElement));
        ArrayList<Action> result = new ArrayList<Action>();
        if (!Model.getFacade().isACallEvent(sourceModelElement)) {
            result.add((Action)((Object)new EventToCallEvent(p, sourceModelElement)));
        }
        if (!Model.getFacade().isASignalEvent(sourceModelElement)) {
            result.add((Action)((Object)new EventToSignalEvent(p, sourceModelElement)));
        }
        if (!Model.getFacade().isAChangeEvent(sourceModelElement)) {
            result.add((Action)((Object)new EventToChangeEvent(p, sourceModelElement)));
        }
        if (!Model.getFacade().isATimeEvent(sourceModelElement)) {
            result.add((Action)((Object)new EventToTimeEvent(p, sourceModelElement)));
        }
        return result;
    }

    @Override
    public boolean canTransform(Object sourceModelElement) {
        return Model.getFacade().isAEvent(sourceModelElement);
    }

    class EventToTimeEvent
    extends EventTransformerAction {
        EventToTimeEvent(Project project, Object sourceModelElement) {
            super(Translator.localize((String)"transform.button.new-timeevent"), project, sourceModelElement);
        }

        protected Object buildEvent(String text, String name, Object ns, Object trans) {
            Object evt = Model.getStateMachinesFactory().buildTimeEvent(text, ns);
            Model.getCoreHelper().setName(evt, name);
            return evt;
        }
    }

    class EventToChangeEvent
    extends EventTransformerAction {
        EventToChangeEvent(Project project, Object sourceModelElement) {
            super(Translator.localize((String)"transform.button.new-changeevent"), project, sourceModelElement);
        }

        protected Object buildEvent(String text, String name, Object ns, Object trans) {
            Object evt = Model.getStateMachinesFactory().buildChangeEvent(text, ns);
            Model.getCoreHelper().setName(evt, name);
            return evt;
        }
    }

    class EventToSignalEvent
    extends EventTransformerAction {
        EventToSignalEvent(Project project, Object sourceModelElement) {
            super(Translator.localize((String)"transform.button.new-signalevent"), project, sourceModelElement);
        }

        protected Object buildEvent(String text, String name, Object ns, Object trans) {
            return Model.getStateMachinesFactory().buildSignalEvent(text, ns);
        }
    }

    class EventToCallEvent
    extends EventTransformerAction {
        EventToCallEvent(Project project, Object sourceModelElement) {
            super(Translator.localize((String)"transform.button.new-callevent"), project, sourceModelElement);
        }

        protected Object buildEvent(String text, String name, Object ns, Object trans) {
            Object evt = Model.getStateMachinesFactory().buildCallEvent(ns);
            Model.getCoreHelper().setName(evt, text);
            Object op = Model.getStateMachinesHelper().findOperationByName(trans, text);
            if (op != null) {
                Model.getCommonBehaviorHelper().setOperation(evt, op);
            }
            return evt;
        }
    }

    abstract class EventTransformerAction
    extends TransformerAction {
        EventTransformerAction(String nameKey, Project project, Object sourceModelElement) {
            super(nameKey, project, sourceModelElement);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            String text = this.getText();
            String name = this.getName();
            Object ns = Model.getFacade().getNamespace(this.getSource());
            ArrayList transitions = new ArrayList(Model.getFacade().getTransitions(this.getSource()));
            ArrayList parameters = new ArrayList(Model.getFacade().getParameters(this.getSource()));
            Object trans = null;
            if (!transitions.isEmpty()) {
                trans = transitions.iterator().next();
            }
            Object evt = this.buildEvent(text, name, ns, trans);
            for (Object param : parameters) {
                Model.getCoreHelper().removeParameter(this.getSource(), param);
                Model.getCoreHelper().addParameter(evt, param);
            }
            for (Object t : transitions) {
                Model.getStateMachinesHelper().setTrigger(t, null);
                Model.getStateMachinesHelper().setTrigger(t, evt);
            }
            Model.getUmlFactory().delete(this.getSource());
        }

        protected String getText() {
            Object timeExpr;
            Object changeExpr;
            String text = "";
            if (Model.getFacade().isACallEvent(this.getSource())) {
                text = Model.getFacade().getName(this.getSource());
            }
            if (Model.getFacade().isAChangeEvent(this.getSource()) && (changeExpr = Model.getFacade().getChangeExpression(this.getSource())) != null) {
                text = Model.getDataTypesHelper().getBody(changeExpr);
            }
            if (Model.getFacade().isATimeEvent(this.getSource()) && (timeExpr = Model.getFacade().getWhen(this.getSource())) != null) {
                text = Model.getDataTypesHelper().getBody(timeExpr);
            }
            if (Model.getFacade().isASignalEvent(this.getSource())) {
                text = Model.getFacade().getName(this.getSource());
            }
            return text;
        }

        protected String getName() {
            String name = "";
            if (Model.getFacade().isAChangeEvent(this.getSource())) {
                name = Model.getFacade().getName(this.getSource());
            }
            if (Model.getFacade().isATimeEvent(this.getSource())) {
                name = Model.getFacade().getName(this.getSource());
            }
            return name;
        }

        protected abstract Object buildEvent(String var1, String var2, Object var3, Object var4);
    }
}

