/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.transformer;

import java.util.HashSet;
import java.util.List;
import org.argouml.i18n.Translator;
import org.argouml.kernel.ActionList;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.transformer.Transformer;
import org.argouml.ui.ContextActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransformerManager
implements ContextActionFactory {
    private HashSet<Transformer> transformers;
    private static TransformerManager instance = new TransformerManager();

    private TransformerManager() {
    }

    public static TransformerManager getInstance() {
        return instance;
    }

    private HashSet<Transformer> getTransformers() {
        if (this.transformers == null) {
            this.transformers = new HashSet();
        }
        return this.transformers;
    }

    void addTransformer(Transformer t) {
        this.getTransformers().add(t);
    }

    public List createContextPopupActions(Object element) {
        Project p = ProjectManager.getManager().getCurrentProject();
        ActionList result = new ActionList(Translator.localize((String)"transform.menu.popup.transform"));
        for (Transformer t : this.getTransformers()) {
            if (!t.canTransform(element)) continue;
            result.addAll(t.actions(p, element));
        }
        return result.size() > 0 ? result : null;
    }
}

