/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.tigris.swidgets.GridLayout2;

public class NewspaperLayout
extends GridLayout2 {
    private int gridGap = 0;
    private int preferredX;
    private int preferredY;
    private int gridWidth;

    public NewspaperLayout() {
        this(1, 0, 0, 0, 0);
    }

    public NewspaperLayout(int n, int n2) {
        this(n, n2, 0, 0, 0);
    }

    public NewspaperLayout(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, 21, 0, 18);
        this.gridGap = n5;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        JComponent jComponent = (JComponent)container;
        Rectangle rectangle = jComponent.getVisibleRect();
        Insets insets = container.getInsets();
        this.layoutContainer(container);
        if (this.preferredX < insets.right + this.gridWidth + insets.left) {
            this.preferredX = insets.right + this.gridWidth + insets.left;
        }
        return new Dimension(this.preferredX, this.preferredY);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        return new Dimension(insets.right + this.gridWidth + insets.left, 0);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3 = container.getComponentCount();
            if (n3 == 0) {
                return;
            }
            Insets insets = container.getInsets();
            int n4 = this.getRows();
            int n5 = this.getColumns();
            if (n4 > 0) {
                n5 = (n3 + n4 - 1) / n4;
            } else {
                n4 = (n3 + n5 - 1) / n5;
            }
            this.setColWidth(new int[n5]);
            this.setRowHeight(new int[n4]);
            this.setLargestWidth(0);
            this.setLargestHeight(0);
            if (this.getCellSizing() == 22) {
                n2 = container.getWidth() - (insets.left + insets.right + (n5 - 1) * this.getHgap());
                n = container.getHeight() - (insets.top + insets.bottom + (n4 - 1) * this.getVgap());
                this.setLargestWidth(n2 / n5);
                this.setLargestHeight(n / n4);
            } else {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n4; ++n) {
                        int n6 = n * n5 + n2;
                        if (container.getComponent(n6).getPreferredSize().getWidth() > (double)this.getColWidth()[n2]) {
                            this.getColWidth()[n2] = (int)container.getComponent(n6).getPreferredSize().getWidth();
                            if (this.getColWidth()[n2] > this.getLargestWidth()) {
                                this.setLargestWidth(this.getColWidth()[n2]);
                            }
                        }
                        if (!(container.getComponent(n6).getPreferredSize().getHeight() > (double)this.getRowHeight()[n])) continue;
                        this.getRowHeight()[n] = (int)container.getComponent(n6).getPreferredSize().getHeight();
                        if (this.getRowHeight()[n] <= this.getLargestHeight()) continue;
                        this.setLargestHeight(this.getRowHeight()[n]);
                    }
                }
            }
            this.gridWidth = (n5 - 1) * this.getHgap();
            for (n2 = 0; n2 < n5; ++n2) {
                this.gridWidth += this.getColWidth()[n2];
            }
            n2 = (n4 - 1) * this.getVgap();
            for (n = 0; n < n4; ++n) {
                n2 += this.getRowHeight()[n];
            }
            n = this.positionComponentsInternal(container, this.getColWidth(), this.getRowHeight(), n2, n4, n5);
            if (n > 0) {
                this.positionComponentsExternal(container, this.getColWidth(), this.getRowHeight(), n2, n4, n5, n);
            }
        }
    }

    private int positionComponentsInternal(Container container, int[] nArray, int[] nArray2, int n, int n2, int n3) {
        JComponent jComponent = (JComponent)container;
        int n4 = (int)jComponent.getVisibleRect().getHeight();
        int n5 = (int)jComponent.getVisibleRect().getWidth();
        int n6 = container.getComponentCount();
        Insets insets = container.getInsets();
        int n7 = 0;
        int n8 = 0;
        int n9 = insets.top;
        for (int i = 0; i < n2; ++i) {
            int n10 = this.getComponentCellHeight(i);
            if (n9 + n10 + insets.bottom > n4) {
                n9 = insets.top;
                if (insets.left + insets.right + ++n7 * (this.gridWidth + this.gridGap) + this.gridWidth > n5) {
                    return n7;
                }
            }
            int n11 = insets.left + n7 * (this.gridWidth + this.gridGap);
            for (int j = 0; j < n3; ++j) {
                int n12 = this.getComponentCellWidth(j);
                int n13 = i * n3 + j;
                if (n13 < n6) {
                    this.positionComponentInCell(container.getComponent(n13), n11, n9, n12, n10);
                    if (n9 + n10 > n8) {
                        n8 = n9 + n10;
                    }
                }
                n11 += n12 + this.getHgap();
            }
            n9 += n10 + this.getVgap();
        }
        this.preferredY = n8 + insets.bottom;
        return -1;
    }

    private boolean positionComponentsExternal(Container container, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        int n5 = container.getComponentCount();
        Insets insets = container.getInsets();
        int n6 = 0;
        int n7 = n / n4;
        int n8 = 0;
        int n9 = insets.top;
        for (int i = 0; i < n2; ++i) {
            int n10 = this.getCellSizing() != 21 ? this.getLargestHeight() : nArray2[i];
            int n11 = insets.left + n6 * (this.gridWidth + this.gridGap);
            for (int j = 0; j < n3; ++j) {
                int n12 = this.getCellSizing() != 21 ? this.getLargestWidth() : nArray[j];
                int n13 = i * n3 + j;
                if (n13 < n5) {
                    this.positionComponentInCell(container.getComponent(n13), n11, n9, n12, n10);
                    if (n9 + n10 > n8) {
                        n8 = n9 + n10;
                    }
                }
                n11 += n12 + this.getHgap();
            }
            if ((n9 += n10 + this.getVgap()) < n7 + insets.top) continue;
            n9 = insets.top;
            ++n6;
        }
        this.preferredY = n8 + insets.bottom;
        return true;
    }
}

