/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.tigris.swidgets.LineLayout;
import org.tigris.swidgets.Orientation;

public class ProportionalLayout
extends LineLayout {
    protected Hashtable componentTable = new Hashtable();

    public ProportionalLayout() {
        this(HORIZONTAL);
    }

    public ProportionalLayout(Orientation orientation) {
        super(orientation);
    }

    public final void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = "";
        }
        this.addLayoutComponent((String)object, component);
    }

    public void addLayoutComponent(String string, Component component) {
        try {
            this.componentTable.put(component, string.toString());
        }
        catch (Exception exception) {
            this.componentTable.put(component, "");
        }
    }

    public void removeLayoutComponent(Component component) {
        this.componentTable.remove(component);
    }

    public void layoutContainer(Container container) {
        Object object;
        Serializable serializable;
        double d = 0.0;
        int n = this._orientation.getLengthMinusInsets(container);
        Enumeration enumeration = this.componentTable.keys();
        while (enumeration.hasMoreElements()) {
            serializable = (Component)enumeration.nextElement();
            if (!((Component)serializable).isVisible()) continue;
            object = (String)this.componentTable.get(serializable);
            if (((String)object).length() != 0) {
                d += Double.parseDouble((String)object);
                continue;
            }
            n -= this._orientation.getLength((Component)serializable);
        }
        serializable = container.getInsets();
        object = new Point(((Insets)serializable).top, ((Insets)serializable).left);
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            String string = (String)this.componentTable.get(component);
            if (string.length() != 0) {
                n2 = (int)((double)n * Double.parseDouble(string) / d);
                if (n2 < 0) {
                    n2 = 0;
                }
            } else {
                n2 = this._orientation.getLength(component);
            }
            component.setSize(this._orientation.setLength(container.getSize(), n2));
            component.setLocation((Point)object);
            object = this._orientation.addToPosition((Point)object, n2);
        }
    }
}

