/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.tigris.swidgets.ArrowButton;
import org.tigris.swidgets.Horizontal;
import org.tigris.swidgets.Orientation;
import org.tigris.swidgets.SerialLayout;
import org.tigris.swidgets.Vertical;

public class Splitter
extends JComponent {
    public static final Orientation HORIZONTAL_SPLIT = Horizontal.getInstance();
    public static final Orientation VERTICAL_SPLIT = Vertical.getInstance();
    protected static final int NONE = -1;
    protected static final int WEST = 0;
    protected static final int EAST = 1;
    protected static final int NORTH = 0;
    protected static final int SOUTH = 1;
    private Orientation orientation;
    private int lastPosition;
    private int lastLength;
    private int quickHide = -1;
    private boolean panelHidden = false;
    private boolean dynamicResize = true;
    private Component[] sideComponent = new Component[2];
    private int splitterSize = 10;
    private ArrowButton buttonNorth = null;
    private ArrowButton buttonSouth = null;
    private BasicSplitPaneDivider _divider = null;
    private static final int DIVIDER_PADDING = 4;
    private static final int MIN_SPLITTER_SIZE = 5;

    public Splitter(Orientation orientation) {
        JSplitPane jSplitPane;
        this.orientation = orientation;
        if (orientation == HORIZONTAL_SPLIT) {
            jSplitPane = new JSplitPane(1, true);
            this.splitterSize = Math.max(jSplitPane.getPreferredSize().width - 4, 5);
        } else {
            jSplitPane = new JSplitPane(0, true);
            this.splitterSize = Math.max(jSplitPane.getPreferredSize().height - 4, 5);
        }
        this.setLayout(new SerialLayout(orientation.getPerpendicular()));
        this.setSize(this.splitterSize, this.splitterSize);
        this.setPreferredSize(this.getSize());
        SplitPaneUI splitPaneUI = jSplitPane.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            this._divider = ((BasicSplitPaneUI)splitPaneUI).createDefaultDivider();
            this._divider.setSize(this.getSize());
        }
        this.setCursor(orientation.getCursor());
        MyMouseListener myMouseListener = new MyMouseListener();
        this.addMouseListener(myMouseListener);
        this.addMouseMotionListener(myMouseListener);
    }

    public void registerComponent(int n, Component component) {
        this.sideComponent[n] = component;
        this.setVisible(this.sideComponent[0] != null && this.sideComponent[1] != null);
    }

    public Component getRegisteredComponent(int n) {
        return this.sideComponent[n];
    }

    public void setQuickHide(int n) {
        this.quickHide = n;
        if (n != -1 && this.buttonNorth == null) {
            this.buttonNorth = this.orientation.getStartArrowButton();
            this.buttonSouth = this.orientation.getEndArrowButton();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Splitter.this.toggleHide();
                }
            };
            this.buttonNorth.addActionListener(actionListener);
            this.buttonSouth.addActionListener(actionListener);
            this.add(this.buttonNorth);
            this.add(this.buttonSouth);
        }
        this.showButtons();
    }

    private void showButtons() {
        if (this.buttonNorth != null) {
            if (this.panelHidden) {
                this.buttonNorth.setVisible(this.quickHide == 1);
                this.buttonSouth.setVisible(this.quickHide == 0);
            } else {
                this.buttonNorth.setVisible(this.quickHide == 0);
                this.buttonSouth.setVisible(this.quickHide == 1);
            }
        }
    }

    public void toggleHide() {
        if (this.quickHide == -1) {
            return;
        }
        int n = 0;
        if (this.panelHidden) {
            n = this.lastPosition;
            if (this.quickHide == 1) {
                n = this.orientation.getPosition(this) - this.lastLength;
            }
        } else if (this.quickHide == 1) {
            n = this.orientation.getPosition(this) + this.orientation.getLength(this.sideComponent[1]);
        }
        this.lastLength = this.orientation.getLength(this.sideComponent[this.quickHide]);
        this.lastPosition = this.orientation.getPosition(this);
        this.setLocation(this.orientation.setPosition(this.getLocation(), n));
        this.resizeComponents(n - this.lastPosition);
        this.panelHidden = !this.panelHidden;
        this.showButtons();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        if (this._divider != null) {
            this._divider.setSize(dimension);
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this._divider != null) {
            this._divider.setSize(n, n2);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this._divider != null) {
            this._divider.paint(graphics);
        }
    }

    private int moveSplitter(int n) {
        if (this.sideComponent[0] != null && this.sideComponent[1] != null) {
            int n2 = 0;
            n2 = n >= 0 ? this.restrictMovement(this.sideComponent[0], this.sideComponent[1], n, -1) : this.restrictMovement(this.sideComponent[1], this.sideComponent[0], n, 1);
            this.setLocation(this.orientation.addToPosition(this.getLocation(), n2));
            return n2;
        }
        return 0;
    }

    private void resizeComponents(int n) {
        this.sideComponent[0].setSize(this.orientation.addLength(this.sideComponent[0].getSize(), n));
        this.sideComponent[1].setSize(this.orientation.subtractLength(this.sideComponent[1].getSize(), n));
        this.sideComponent[1].setLocation(this.orientation.addToPosition(this.sideComponent[1].getLocation(), n));
        this.sideComponent[0].validate();
        this.sideComponent[1].validate();
    }

    private int restrictMovement(Component component, Component component2, int n, int n2) {
        Dimension dimension = component.getMaximumSize();
        int n3 = this.orientation.getLength(dimension);
        int n4 = this.orientation.getLength(component);
        if (n4 + n * n2 > n3) {
            n = (n4 - n3) * n2;
        }
        Dimension dimension2 = component2.getMinimumSize();
        int n5 = this.orientation.getLength(dimension2);
        n4 = this.orientation.getLength(component2);
        if (n4 + n * n2 < n5) {
            n = (n5 - n4) * n2;
        }
        return n;
    }

    private class MyMouseListener
    implements MouseMotionListener,
    MouseListener {
        private int positionOfSplitterWhenPressed;
        private int mousePositionOnSplitterWhenPressed;

        private MyMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!Splitter.this.dynamicResize) {
                Splitter.this.moveSplitter(Splitter.this.orientation.getPosition(mouseEvent) - this.mousePositionOnSplitterWhenPressed);
                Splitter.this.resizeComponents(Splitter.this.orientation.getPosition(Splitter.this.getLocation()) - this.positionOfSplitterWhenPressed);
            }
            this.mousePositionOnSplitterWhenPressed = 0;
            this.positionOfSplitterWhenPressed = 0;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = Splitter.this.orientation.getPosition(mouseEvent) - this.mousePositionOnSplitterWhenPressed;
            int n2 = Splitter.this.moveSplitter(n);
            if (n2 == 0) {
                return;
            }
            if (Splitter.this.dynamicResize) {
                Splitter.this.resizeComponents(n2);
            }
            if (Splitter.this.panelHidden) {
                Splitter.this.panelHidden = false;
                Splitter.this.showButtons();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mousePositionOnSplitterWhenPressed = Splitter.this.orientation.getPosition(mouseEvent);
            this.positionOfSplitterWhenPressed = Splitter.this.orientation.getPosition(Splitter.this.getLocation());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && Splitter.this.sideComponent[0] != null && Splitter.this.sideComponent[1] != null) {
                Splitter.this.toggleHide();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

