/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import org.tigris.swidgets.Orientation;
import org.tigris.swidgets.ProportionalLayout;
import org.tigris.swidgets.Splitter;

public class SplitterLayout
extends ProportionalLayout {
    private SplitterMouseListener splitterMouseListener = new SplitterMouseListener();

    public SplitterLayout() {
        this(HORIZONTAL);
    }

    public SplitterLayout(Orientation orientation) {
        super(orientation);
    }

    public void addLayoutComponent(String string, Component component) {
        super.addLayoutComponent(string, component);
        component.setSize(component.getPreferredSize());
        Container container = component.getParent();
        if (container instanceof Container) {
            Container container2 = container;
            int n = this.getComponentPosition(component);
            int n2 = container2.getComponentCount();
            if (component instanceof Splitter) {
                Component component2;
                Splitter splitter = (Splitter)component;
                splitter.addMouseListener(this.splitterMouseListener);
                if (n > 0 && !((component2 = container2.getComponent(n - 1)) instanceof Splitter)) {
                    splitter.registerComponent(0, component2);
                }
                if (n < n2 - 1 && !((component2 = container2.getComponent(n + 1)) instanceof Splitter)) {
                    splitter.registerComponent(1, component2);
                }
            } else {
                Splitter splitter;
                Component component3;
                if (n > 0 && (component3 = container2.getComponent(n - 1)) instanceof Splitter) {
                    splitter = (Splitter)component3;
                    splitter.registerComponent(1, component);
                }
                if (n < n2 - 1 && (component3 = container2.getComponent(n + 1)) instanceof Splitter) {
                    splitter = (Splitter)component3;
                    splitter.registerComponent(0, component);
                }
            }
        }
    }

    private void calculateProportions() {
        String string;
        Component component;
        double d = 0.0;
        Enumeration enumeration = this.componentTable.keys();
        while (enumeration.hasMoreElements()) {
            component = (Component)enumeration.nextElement();
            string = (String)this.componentTable.get(component);
            if (string.length() == 0) continue;
            d += (double)this._orientation.getLength(component);
        }
        enumeration = this.componentTable.keys();
        while (enumeration.hasMoreElements()) {
            component = (Component)enumeration.nextElement();
            string = (String)this.componentTable.get(component);
            if (string.length() == 0) continue;
            double d2 = (double)(this._orientation.getLength(component) * 100) / d;
            this.componentTable.put(component, Double.toString(d2));
        }
    }

    private void calculateProportions(Component component, Component component2) {
        String string = (String)this.componentTable.get(component);
        String string2 = (String)this.componentTable.get(component2);
        double d = this._orientation.getLength(component);
        double d2 = this._orientation.getLength(component2);
        double d3 = Double.parseDouble(string) + Double.parseDouble(string2);
        double d4 = d3 * d / (d + d2);
        double d5 = d3 - d4;
        this.componentTable.put(component, Double.toString(d4));
        this.componentTable.put(component2, Double.toString(d5));
    }

    public int getComponentPosition(Component component) {
        Container container = component.getParent();
        if (container instanceof Container) {
            Container container2 = container;
            int n = container2.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (component != container2.getComponent(i)) continue;
                return i;
            }
        }
        return -1;
    }

    private class SplitterMouseListener
    implements MouseListener {
        private SplitterMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Splitter splitter = (Splitter)mouseEvent.getComponent();
            Component component = splitter.getRegisteredComponent(0);
            Component component2 = splitter.getRegisteredComponent(1);
            if (component != null && component2 != null) {
                String string = (String)SplitterLayout.this.componentTable.get(component);
                String string2 = (String)SplitterLayout.this.componentTable.get(component2);
                if (string.length() != 0 && string2.length() != 0) {
                    SplitterLayout.this.calculateProportions(component, component2);
                } else if (string.length() != 0 || string2.length() != 0) {
                    SplitterLayout.this.calculateProportions();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

