/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Registry<T> {
    private static final Logger LOG = Logger.getLogger(Registry.class);
    Map<String, Map<String, List<T>>> registry = Collections.synchronizedMap(new HashMap());

    Registry() {
    }

    void register(T item, String key, String[] subkeys) {
        Map<String, List<T>> entry = this.registry.get(key);
        if (entry == null) {
            entry = new HashMap<String, List<T>>();
            this.registry.put(key, entry);
        }
        if (subkeys == null || subkeys.length < 1) {
            subkeys = new String[]{""};
        }
        for (int i = 0; i < subkeys.length; ++i) {
            List<T> list = entry.get(subkeys[i]);
            if (list == null) {
                list = new ArrayList<T>();
                entry.put(subkeys[i], list);
            }
            if (!list.contains(item)) {
                list.add(item);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Duplicate registration attempt for " + key + ":" + subkeys + " Listener: " + item));
        }
    }

    void unregister(T item, String key, String[] subkeys) {
        Map<String, List<T>> entry = this.registry.get(key);
        if (entry == null) {
            return;
        }
        if (subkeys != null && subkeys.length > 0) {
            for (int i = 0; i < subkeys.length; ++i) {
                this.lookupRemoveItem(entry, subkeys[i], item);
            }
        } else if (item == null) {
            this.registry.remove(key);
        } else {
            this.lookupRemoveItem(entry, "", item);
        }
    }

    private void lookupRemoveItem(Map<String, List<T>> map, String key, T item) {
        List<T> list = map.get(key);
        if (list == null) {
            return;
        }
        if (item == null) {
            map.remove(key);
            return;
        }
        if (LOG.isDebugEnabled() && !list.contains(item)) {
            LOG.debug((Object)("Attempt to unregister non-existant registration" + key + " Listener: " + item));
        }
        while (list.contains(item)) {
            list.remove(item);
        }
        if (list.isEmpty()) {
            map.remove(key);
        }
    }

    Collection<T> getMatches(String key, String subkey) {
        ArrayList results = new ArrayList();
        Map<String, List<T>> entry = this.registry.get(key);
        if (entry != null) {
            if (entry.containsKey(subkey)) {
                results.addAll(entry.get(subkey));
            }
            if (entry.containsKey("")) {
                results.addAll(entry.get(""));
            }
        }
        return results;
    }
}

