/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.tigris.toolbar.ToolBar;
import org.tigris.toolbar.ToolBarManager;
import org.tigris.toolbar.toolbutton.PopupToolBoxButton;

public class ToolBarFactory {
    private Object[] items;
    private boolean rollover;
    private boolean floatable;
    private int orientation = 0;
    private String dropDownToolTip;

    public ToolBarFactory(Object[] objectArray) {
        this.items = objectArray;
    }

    public ToolBarFactory(Collection collection) {
        this.items = collection.toArray();
    }

    public void setRollover(boolean bl) {
        this.rollover = bl;
    }

    public void setFloatable(boolean bl) {
        this.floatable = bl;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setDropDownTooltip(String string) {
        this.dropDownToolTip = string;
    }

    public JToolBar createToolBar() {
        return this.createToolBar(null);
    }

    public JToolBar createToolBar(String string) {
        ToolBar toolBar = new ToolBar(string);
        if (!ToolBarManager.alwaysUseStandardRollover()) {
            if (this.rollover) {
                toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            } else {
                toolBar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
            }
        }
        toolBar.setFloatable(this.floatable);
        ToolBarFactory.addItemsToToolBar((JToolBar)toolBar, this.items, this.rollover, this.dropDownToolTip);
        toolBar.setOrientation(this.orientation);
        return toolBar;
    }

    public static JToolBar createToolBar(Object[] objectArray) {
        return ToolBarFactory.createToolBar(false, "", objectArray, true);
    }

    public static JToolBar createToolBar(boolean bl, Object[] objectArray) {
        return ToolBarFactory.createToolBar(bl, objectArray, true);
    }

    public static JToolBar createToolBar(boolean bl, Object[] objectArray, boolean bl2) {
        return ToolBarFactory.createToolBar(bl, "", objectArray, bl2);
    }

    public static JToolBar createToolBar(String string, Object[] objectArray) {
        return ToolBarFactory.createToolBar(false, string, objectArray, true);
    }

    public static JToolBar createToolBar(String string, Object[] objectArray, boolean bl) {
        return ToolBarFactory.createToolBar(false, string, objectArray, bl);
    }

    public static JToolBar createToolBar(boolean bl, String string, Object[] objectArray, boolean bl2) {
        ToolBar toolBar = new ToolBar(string);
        if (!ToolBarManager.alwaysUseStandardRollover()) {
            if (bl) {
                toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            } else {
                toolBar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
            }
        }
        toolBar.setFloatable(bl2);
        ToolBarFactory.addItemsToToolBar((JToolBar)toolBar, objectArray, bl, null);
        return toolBar;
    }

    public static JToolBar createToolBar(Collection collection) {
        return ToolBarFactory.createToolBar(false, "", collection, true);
    }

    public static JToolBar createToolBar(boolean bl, Collection collection) {
        return ToolBarFactory.createToolBar(bl, collection, true);
    }

    public static JToolBar createToolBar(boolean bl, Collection collection, boolean bl2) {
        return ToolBarFactory.createToolBar(bl, "", collection, bl2);
    }

    public static JToolBar createToolBar(String string, Collection collection) {
        return ToolBarFactory.createToolBar(false, string, collection, true);
    }

    public static JToolBar createToolBar(String string, Collection collection, boolean bl) {
        return ToolBarFactory.createToolBar(false, string, collection, bl);
    }

    public static JToolBar createToolBar(boolean bl, String string, Collection collection, boolean bl2) {
        ToolBar toolBar = new ToolBar(string);
        if (bl) {
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        } else {
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        }
        toolBar.setFloatable(bl2);
        ToolBarFactory.addItemsToToolBar((JToolBar)toolBar, collection, bl, null);
        return toolBar;
    }

    public static JToolBar createToolBar(JMenu jMenu) {
        return ToolBarFactory.createToolBar(false, "", jMenu, true);
    }

    public static JToolBar createToolBar(boolean bl, JMenu jMenu) {
        return ToolBarFactory.createToolBar(bl, jMenu, true);
    }

    public static JToolBar createToolBar(boolean bl, JMenu jMenu, boolean bl2) {
        return ToolBarFactory.createToolBar(bl, "", jMenu, bl2);
    }

    public static JToolBar createToolBar(String string, JMenu jMenu) {
        return ToolBarFactory.createToolBar(false, string, jMenu, true);
    }

    public static JToolBar createToolBar(String string, JMenu jMenu, boolean bl) {
        return ToolBarFactory.createToolBar(false, string, jMenu, bl);
    }

    public static JToolBar createToolBar(boolean bl, String string, JMenu jMenu, boolean bl2) {
        int n = jMenu.getMenuComponentCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || ((JMenuItem)component).getIcon() == null) continue;
            ++n2;
        }
        Object[] objectArray = new Action[n2];
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || ((JMenuItem)component).getIcon() == null) continue;
            objectArray[n2++] = ((JMenuItem)component).getAction();
        }
        ToolBar toolBar = new ToolBar(string);
        if (bl) {
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        } else {
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        }
        toolBar.setFloatable(bl2);
        ToolBarFactory.addItemsToToolBar((JToolBar)toolBar, objectArray, bl, null);
        return toolBar;
    }

    private static void addItemsToToolBar(JToolBar jToolBar, Object[] objectArray, boolean bl, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            ToolBarFactory.addItemToToolBar(jToolBar, objectArray[i], bl, string);
        }
    }

    private static void addItemsToToolBar(JToolBar jToolBar, Collection collection, boolean bl, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ToolBarFactory.addItemToToolBar(jToolBar, iterator.next(), bl, string);
        }
    }

    private static void addItemToToolBar(JToolBar jToolBar, Object object, boolean bl, String string) {
        if (object == null) {
            jToolBar.addSeparator();
        } else if (object instanceof Action) {
            Action action = (Action)object;
            JButton jButton = jToolBar.add(action);
            if (jButton.getToolTipText() == null || jButton.getToolTipText().trim().length() == 0) {
                jButton.setToolTipText((String)action.getValue("Name"));
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            PopupToolBoxButton popupToolBoxButton = ToolBarFactory.buildPopupToolBoxButton(objectArray, bl, string);
            if (!ToolBarManager.alwaysUseStandardRollover()) {
                popupToolBoxButton.setBorderPainted(false);
            }
            jToolBar.add(popupToolBoxButton);
        } else if (object instanceof Component) {
            jToolBar.add((Component)object);
        }
    }

    private static PopupToolBoxButton buildPopupToolBoxButton(Object[] objectArray, boolean bl, String string) {
        PopupToolBoxButton popupToolBoxButton = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2;
            if (objectArray[i] instanceof Action) {
                objectArray2 = (Object[])objectArray[i];
                if (popupToolBoxButton == null) {
                    popupToolBoxButton = new PopupToolBoxButton((Action)objectArray2, 0, 1, bl);
                }
                popupToolBoxButton.add((Action)objectArray2);
                continue;
            }
            if (!(objectArray[i] instanceof Object[])) continue;
            objectArray2 = (Object[])objectArray[i];
            for (int j = 0; j < objectArray2.length; ++j) {
                Action action = (Action)objectArray2[j];
                if (popupToolBoxButton == null) {
                    int n = objectArray2.length;
                    popupToolBoxButton = new PopupToolBoxButton(action, 0, n, bl);
                }
                popupToolBoxButton.add(action);
            }
        }
        popupToolBoxButton.setDropDownToolTip(string);
        return popupToolBoxButton;
    }
}

