/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ToolBarUI;
import org.tigris.toolbar.layouts.DockBoundary;
import org.tigris.toolbar.layouts.DockLayout;
import org.tigris.toolbar.layouts.DockingConstraints;

class ToolBarHandler {
    private DockingConstraints ourConstraints = new DockingConstraints();
    private JToolBar ourToolBar = null;
    private DockLayout ourDockLayout = null;
    private JDialog ourFloatFrame = null;
    private DraggingWindow ourDraggingWindow = null;
    private ToolBarDragListener ourDragListener = null;
    private UIChangeListener ourUIListener = null;
    private boolean ourToolBarIsDragging = false;
    private boolean ourToolBarShouldFloat = false;
    private static boolean ourVersionIsCompatible = false;
    public static final String TOOL_BAR_HANDLER_KEY = "ToolBarHandler";
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;

    public ToolBarHandler(JToolBar jToolBar, DockLayout dockLayout) {
        this.ourToolBar = jToolBar;
        this.ourDockLayout = dockLayout;
        if (!ourVersionIsCompatible) {
            String string = System.getProperty("java.specification.version");
            try {
                float f = Float.parseFloat(string);
                if (f > 1.2f) {
                    ourVersionIsCompatible = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ourVersionIsCompatible) {
            this.ourDragListener = new ToolBarDragListener();
            this.ourUIListener = new UIChangeListener();
            this.installListeners();
        }
    }

    public void setConstraints(DockingConstraints dockingConstraints) {
        this.ourConstraints = dockingConstraints;
    }

    public DockingConstraints getConstraints() {
        return this.ourConstraints;
    }

    public int getDockEdge() {
        return this.ourConstraints.getEdge();
    }

    public void setDockEdge(int n) {
        this.ourConstraints.setEdge(n);
    }

    public int getDockIndex() {
        return this.ourConstraints.getIndex();
    }

    public void setDockIndex(int n) {
        this.ourConstraints.setIndex(n);
    }

    public int getRowIndex() {
        return this.ourConstraints.getRow();
    }

    public void setRowIndex(int n) {
        this.ourConstraints.setRow(n);
    }

    public void hideToolBar() {
        Container container = this.ourDockLayout.getTargetContainer();
        container.remove(this.ourToolBar);
        JDialog jDialog = this.getFloatingFrame();
        if (jDialog != null) {
            jDialog.setVisible(false);
            jDialog.getContentPane().remove(this.ourToolBar);
        }
        container.validate();
        container.repaint();
    }

    public void dockToolBar() {
        this.dockToolBar(this.getDockEdge());
    }

    public void dockToolBar(int n) {
        this.dockToolBar(n, this.getRowIndex(), this.getDockIndex());
    }

    public void dockToolBar(int n, int n2, int n3) {
        Container container = this.ourDockLayout.getTargetContainer();
        if (container == null) {
            return;
        }
        container.remove(this.ourToolBar);
        JDialog jDialog = this.getFloatingFrame();
        if (jDialog != null) {
            jDialog.setVisible(false);
            jDialog.getContentPane().remove(this.ourToolBar);
        }
        this.ourConstraints.setEdge(n);
        this.ourConstraints.setRow(n2);
        this.ourConstraints.setIndex(n3);
        container.add((Component)this.ourToolBar, this.ourConstraints);
        this.ourToolBarShouldFloat = false;
        container.validate();
        container.repaint();
    }

    public void floatToolBar() {
        Point point = this.getFloatingLocation();
        this.floatToolBar(point.x, point.y);
    }

    public void floatToolBar(int n, int n2) {
        this.floatToolBar(n, n2, false);
    }

    public void floatToolBar(int n, int n2, boolean bl) {
        JDialog jDialog = this.getFloatingFrame();
        if (jDialog == null) {
            return;
        }
        Container container = this.ourDockLayout.getTargetContainer();
        if (container != null) {
            container.remove(this.ourToolBar);
        }
        jDialog.setVisible(false);
        jDialog.getContentPane().remove(this.ourToolBar);
        this.ourToolBar.setOrientation(0);
        jDialog.getContentPane().add((Component)this.ourToolBar, "Center");
        jDialog.pack();
        if (bl) {
            n -= jDialog.getWidth() / 2;
            n2 -= jDialog.getHeight() / 2;
        }
        jDialog.setLocation(n, n2);
        jDialog.setTitle(this.ourToolBar.getName());
        jDialog.setVisible(true);
        this.ourToolBarShouldFloat = true;
        if (container != null) {
            container.validate();
            container.repaint();
        }
    }

    public Point getFloatingLocation() {
        JDialog jDialog = this.getFloatingFrame();
        if (jDialog != null) {
            return jDialog.getLocation();
        }
        return new Point(0, 0);
    }

    public void setFloatingLocation(int n, int n2) {
        JDialog jDialog = this.getFloatingFrame();
        if (jDialog != null) {
            jDialog.setLocation(n, n2);
        }
    }

    public boolean shouldFloat() {
        return this.ourToolBarShouldFloat;
    }

    public void setShouldFloat(boolean bl) {
        this.ourToolBarShouldFloat = bl;
    }

    private DockBoundary getDockableBoundary(Point point) {
        return this.ourDockLayout.getDockableBoundary(point);
    }

    private boolean isDraggable(Point point, JToolBar jToolBar) {
        if (jToolBar == null) {
            return false;
        }
        DockBoundary dockBoundary = this.ourDockLayout.getBoundary(point);
        if (dockBoundary == null) {
            return true;
        }
        if (dockBoundary.containsToolBar(jToolBar)) {
            return dockBoundary.isDraggablePoint(point, jToolBar);
        }
        return true;
    }

    private JDialog getFloatingFrame() {
        if (this.ourFloatFrame == null) {
            Window window = SwingUtilities.getWindowAncestor(this.ourDockLayout.getTargetContainer());
            if (window == null) {
                return null;
            }
            Frame frame = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            }
            this.ourFloatFrame = new JDialog(frame);
            this.ourFloatFrame.setDefaultCloseOperation(0);
            this.ourFloatFrame.addWindowListener(new FloatFrameCloseListener());
            this.ourFloatFrame.getContentPane().setLayout(new BorderLayout());
            this.ourFloatFrame.setTitle(this.ourToolBar.getName());
            this.ourFloatFrame.setResizable(false);
        }
        return this.ourFloatFrame;
    }

    private DraggingWindow getDraggingWindow() {
        Window window;
        if (this.ourDraggingWindow == null && (window = SwingUtilities.getWindowAncestor(this.ourDockLayout.getTargetContainer())) != null) {
            this.ourDraggingWindow = new DraggingWindow(window);
        }
        return this.ourDraggingWindow;
    }

    public void uninstallListeners() {
        this.ourToolBar.removeMouseListener(this.ourDragListener);
        this.ourToolBar.removeMouseMotionListener(this.ourDragListener);
        this.ourToolBar.removePropertyChangeListener(this.ourUIListener);
    }

    private void installListeners() {
        int n;
        if (!ourVersionIsCompatible) {
            return;
        }
        this.ourToolBar.removePropertyChangeListener("UI", this.ourUIListener);
        ToolBarUI toolBarUI = this.ourToolBar.getUI();
        toolBarUI.uninstallUI(this.ourToolBar);
        List<EventListener> list = Arrays.asList(this.ourToolBar.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = ToolBarHandler.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener));
        List<EventListener> list2 = Arrays.asList(this.ourToolBar.getListeners(class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = ToolBarHandler.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener));
        toolBarUI.installUI(this.ourToolBar);
        MouseListener[] mouseListenerArray = (MouseListener[])this.ourToolBar.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = ToolBarHandler.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
        MouseMotionListener[] mouseMotionListenerArray = (MouseMotionListener[])this.ourToolBar.getListeners(class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = ToolBarHandler.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener);
        for (n = 0; n < mouseListenerArray.length; ++n) {
            if (list.contains(mouseListenerArray[n])) continue;
            this.ourToolBar.removeMouseListener(mouseListenerArray[n]);
        }
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            if (list2.contains(mouseMotionListenerArray[n])) continue;
            this.ourToolBar.removeMouseMotionListener(mouseMotionListenerArray[n]);
        }
        this.ourToolBar.addMouseListener(this.ourDragListener);
        this.ourToolBar.addMouseMotionListener(this.ourDragListener);
        this.ourToolBar.addPropertyChangeListener("UI", this.ourUIListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DraggingWindow
    extends JWindow {
        private Border myFloatBorder = null;
        private Border myDockBorder = null;
        private Color myFloatColor = null;
        private Color myDockColor = null;
        private JPanel myContent = null;

        public DraggingWindow(Window window) {
            super(window);
            Color color = UIManager.getColor("ToolBar.floatingForeground");
            Color color2 = UIManager.getColor("ToolBar.dockingForeground");
            if (color == null) {
                color = Color.darkGray;
            }
            if (color2 == null) {
                color2 = Color.yellow;
            }
            this.myFloatBorder = BorderFactory.createLineBorder(color, 3);
            this.myDockBorder = BorderFactory.createLineBorder(color2, 3);
            this.myContent = new JPanel();
            this.myContent.setOpaque(true);
            color = UIManager.getColor("ToolBar.floatingBackground");
            color2 = UIManager.getColor("ToolBar.dockingBackground");
            if (color == null) {
                color = this.myContent.getBackground();
            }
            if (color2 == null) {
                color2 = this.myContent.getBackground();
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.myContent, "Center");
        }

        public void presentWindow(Point point, boolean bl, int n) {
            this.setCentroidLocation(point);
            int n2 = bl ? n : 0;
            this.setSize(this.getPreferredToolBarSize(n2));
            this.myContent.setBorder(bl ? this.myDockBorder : this.myFloatBorder);
            this.myContent.setBackground(bl ? this.myDockColor : this.myFloatColor);
            this.setCentroidLocation(point);
            this.validate();
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }

        public void hideWindow() {
            this.setVisible(false);
        }

        private void setCentroidLocation(Point point) {
            this.setLocation(point.x - this.getWidth() / 2, point.y - this.getHeight() / 2);
        }

        private Point getCentroidLocation() {
            Point point = this.getLocation();
            point.x += this.getWidth() / 2;
            point.y += this.getHeight() / 2;
            return point;
        }

        private Dimension getPreferredToolBarSize(int n) {
            Component[] componentArray = ToolBarHandler.this.ourToolBar.getComponents();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                if (n == 0) {
                    n2 += dimension.width;
                    n3 = Math.max(n3, dimension.height);
                    continue;
                }
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
            }
            return new Dimension(n2, n3);
        }
    }

    private class ToolBarDragListener
    extends MouseInputAdapter {
        private ToolBarDragListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            DockBoundary dockBoundary;
            ToolBarHandler.this.ourDraggingWindow = ToolBarHandler.this.getDraggingWindow();
            if (ToolBarHandler.this.ourDraggingWindow == null) {
                return;
            }
            if ((mouseEvent.getModifiers() & 0x10) != 16) {
                this.hideDraggingWindow();
                return;
            }
            Container container = ToolBarHandler.this.ourDockLayout.getTargetContainer();
            if (container == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(ToolBarHandler.this.ourToolBar, point, container);
            if (!ToolBarHandler.this.isDraggable(point, ToolBarHandler.this.ourToolBar)) {
                this.hideDraggingWindow();
                return;
            }
            int n = 0;
            boolean bl = false;
            if (!mouseEvent.isControlDown() && (dockBoundary = ToolBarHandler.this.getDockableBoundary(point)) != null) {
                bl = true;
                n = dockBoundary.getOrientation();
            }
            SwingUtilities.convertPointToScreen(point, container);
            ToolBarHandler.this.ourDraggingWindow.presentWindow(point, bl, n);
            ToolBarHandler.this.ourToolBarIsDragging = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ToolBarHandler.this.ourToolBarIsDragging) {
                return;
            }
            if ((mouseEvent.getModifiers() & 0x10) != 16) {
                return;
            }
            this.hideDraggingWindow();
            Container container = ToolBarHandler.this.ourDockLayout.getTargetContainer();
            if (container == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(ToolBarHandler.this.ourToolBar, point, container);
            DockBoundary dockBoundary = null;
            if (!mouseEvent.isControlDown() && (dockBoundary = ToolBarHandler.this.getDockableBoundary(point)) != null) {
                ToolBarHandler.this.setDockIndex(dockBoundary.getDockIndex(point));
                ToolBarHandler.this.setRowIndex(dockBoundary.getRowIndex(point));
                ToolBarHandler.this.setDockEdge(dockBoundary.getEdge());
            }
            if (dockBoundary != null) {
                ToolBarHandler.this.dockToolBar(ToolBarHandler.this.getDockEdge(), ToolBarHandler.this.getRowIndex(), ToolBarHandler.this.getDockIndex());
            } else {
                SwingUtilities.convertPointToScreen(point, container);
                ToolBarHandler.this.floatToolBar(point.x, point.y, true);
            }
        }

        private void hideDraggingWindow() {
            if (ToolBarHandler.this.ourDraggingWindow != null) {
                ToolBarHandler.this.ourDraggingWindow.hideWindow();
                ToolBarHandler.this.ourToolBarIsDragging = false;
            }
        }
    }

    private class UIChangeListener
    implements PropertyChangeListener {
        private UIChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ToolBarHandler.this.installListeners();
        }
    }

    private class FloatFrameCloseListener
    extends WindowAdapter {
        private FloatFrameCloseListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ToolBarHandler.this.dockToolBar(ToolBarHandler.this.getDockEdge(), ToolBarHandler.this.getRowIndex(), ToolBarHandler.this.getDockIndex());
        }
    }
}

