/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.RefEnum;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public final class EnumResolver {
    private static final String ENUMIMPL_SUFFIX = "Enum";
    private static final Hashtable enumCache = new Hashtable(50);

    public static synchronized RefEnum resolveEnum(String ifcName, String label) {
        String enumKey = label + ":" + ifcName;
        RefEnum en = (RefEnum)enumCache.get(enumKey);
        if (en == null) {
            try {
                Class cl = BaseObjectHandler.resolveInterface(ifcName + ENUMIMPL_SUFFIX);
                Field f = cl.getField(TagSupport.mapEnumLiteral(label));
                en = (RefEnum)f.get(null);
                enumCache.put(enumKey, en);
            }
            catch (NoSuchFieldException e) {
                throw new InvalidNameException(label, "Invalid literal name '" + label + "' for enumeration " + ifcName);
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        return en;
    }
}

