/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.jmi.reflect.DuplicateException;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.AttrList;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;

public class AttrUList
extends AttrList {
    private Set innerSet = null;

    public AttrUList() {
    }

    AttrUList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }

    public AttrUList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, List values) throws StorageException {
        super(mdrObject, desc, values);
        this.innerSet = new HashSet();
        Iterator it = this.inner.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (this.innerSet.add(value)) continue;
            throw new DuplicateException(value, this.getMetaElement());
        }
    }

    protected AttrUList(StorableFeatured mdrObject, List values, int maxSize, Class type, String attrName, boolean isRefObject, MOFID metaMofId, Set innerSet) {
        super(mdrObject, values, maxSize, type, attrName, isRefObject, metaMofId);
        this.innerSet = innerSet;
    }

    protected void checkUnwrap() {
        if (this.innerSet == null) {
            super.checkUnwrap();
            this.innerSet = new HashSet(this.inner);
        }
    }

    public boolean remove(Object obj) {
        super.remove(obj);
        return this.innerSet.remove(obj);
    }

    public Object set(int param, Object obj) {
        Object retValue = super.set(param, obj);
        this.innerSet.remove(retValue);
        if (!this.innerSet.add(obj)) {
            throw new DuplicateException(obj, this.getMetaElement());
        }
        return retValue;
    }

    public ListIterator listIterator(int param) {
        this.checkUnwrap();
        return new AttrUListIterator(this.innerList.listIterator(param));
    }

    public Iterator iterator() {
        this.checkUnwrap();
        return new AttrUListIterator(this.innerList.listIterator());
    }

    public ListIterator listIterator() {
        this.checkUnwrap();
        return new AttrUListIterator(this.innerList.listIterator());
    }

    public Object remove(int param) {
        Object retValue = super.remove(param);
        this.innerSet.remove(retValue);
        return retValue;
    }

    public void add(int param, Object obj) {
        super.add(param, obj);
        if (!this.innerSet.add(obj)) {
            throw new DuplicateException(obj, this.getMetaElement());
        }
    }

    public boolean add(Object obj) {
        super.add(obj);
        return this.innerSet.add(obj);
    }

    public List subList(int param, int param1) {
        this.checkUnwrap();
        return new AttrUList(this.mdrObject, this.innerList.subList(param, param1), this.maxSize, this.type, this.attrName, this.isRefObject, this.metaMofId, this.innerSet);
    }

    public boolean contains(Object obj) {
        this.checkUnwrap();
        return this.innerSet.contains(obj);
    }

    public boolean containsAll(Collection collection) {
        this.checkUnwrap();
        return this.innerSet.containsAll(collection);
    }

    protected class AttrUListIterator
    extends AttrList.AttrListIterator {
        protected AttrUListIterator(ListIterator iterator) {
            super(iterator);
        }

        public void remove() {
            super.remove();
            AttrUList.this.innerSet.remove(this.lastRead);
        }

        public void add(Object obj) {
            if (!AttrUList.this.innerSet.add(obj)) {
                throw new DuplicateException(obj, AttrUList.this.getMetaElement());
            }
            super.add(obj);
        }

        public void set(Object obj) {
            super.set(obj);
            AttrUList.this.innerSet.remove(this.lastRead);
            if (!AttrUList.this.innerSet.add(obj)) {
                throw new DuplicateException(obj, AttrUList.this.getMetaElement());
            }
        }
    }
}

