/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class IndexImmutSet
implements Collection {
    protected final MdrStorage storage;
    protected final MultivaluedIndex index;
    protected final Object indexKey;

    protected IndexImmutSet(MdrStorage storage, MultivaluedIndex index, Object indexKey) {
        this.storage = storage;
        this.index = index;
        this.indexKey = indexKey;
    }

    protected Collection getItems() {
        try {
            return this.index.getItems(this.indexKey);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    protected Collection getObjects() {
        try {
            return this.storage.getObjectsFromIndex(this.index, this.indexKey);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public int size() {
        return this.getItems().size();
    }

    public boolean contains(Object obj) {
        return this.getItems().contains(obj);
    }

    public Iterator iterator() {
        return new IndexImmutIterator(this.getObjects().iterator());
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    public boolean containsAll(Collection collection) {
        return this.getItems().containsAll(collection);
    }

    public Object[] toArray(Object[] obj) {
        return this.getObjects().toArray(obj);
    }

    public Object[] toArray() {
        return this.getObjects().toArray();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected class IndexImmutIterator
    implements Iterator {
        protected Iterator innerIterator;

        protected IndexImmutIterator(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public Object next() {
            return this.innerIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

