/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tudresden.ocl.lib.Ocl;
import tudresden.ocl.lib.OclAnyImpl;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclCollection;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclFactory;
import tudresden.ocl.lib.OclInteger;
import tudresden.ocl.lib.OclIterator;
import tudresden.ocl.lib.OclReal;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclSequence;
import tudresden.ocl.lib.OclSet;
import tudresden.ocl.lib.OclState;
import tudresden.ocl.lib.OclString;

public class DefaultOclFactory
implements OclFactory {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$List;

    public OclRoot getOclRepresentationFor(Object o) {
        if (o == null) {
            return new OclAnyImpl(null);
        }
        if (o instanceof String) {
            return new OclString((String)o);
        }
        if (o instanceof Collection) {
            Collection oc = (Collection)o;
            if (o instanceof Set || Ocl.TAKE_VECTORS_AS_SET && o instanceof Vector) {
                HashSet<OclRoot> set = new HashSet<OclRoot>();
                Iterator i = oc.iterator();
                while (i.hasNext()) {
                    set.add(this.getOclRepresentationFor(i.next()));
                }
                return new OclSet(set);
            }
            if (o instanceof List) {
                ArrayList<OclRoot> list = new ArrayList<OclRoot>();
                Iterator i = oc.iterator();
                while (i.hasNext()) {
                    list.add(this.getOclRepresentationFor(i.next()));
                }
                return new OclSequence(list);
            }
            throw new OclException("encountered a java.util.Collection, which is neither Set or List.");
        }
        if (o instanceof Map) {
            Map om = (Map)o;
            HashSet<OclRoot> set = new HashSet<OclRoot>();
            Iterator i = om.values().iterator();
            while (i.hasNext()) {
                set.add(this.getOclRepresentationFor(i.next()));
            }
            if (om.size() != set.size()) {
                throw new OclException("map values in feature " + o + " are not unique.");
            }
            return new OclSet(set);
        }
        if (o.getClass().isArray()) {
            Object[] oa = (Object[])o;
            ArrayList<OclRoot> list = new ArrayList<OclRoot>();
            int i = 0;
            while (i < oa.length) {
                list.add(this.getOclRepresentationFor(oa[i]));
                ++i;
            }
            return new OclSequence(list);
        }
        if (o instanceof Boolean) {
            return this.getOclRepresentationFor((Boolean)o);
        }
        if (o instanceof Byte) {
            return this.getOclRepresentationFor((Byte)o);
        }
        if (o instanceof Short) {
            return this.getOclRepresentationFor((Short)o);
        }
        if (o instanceof Integer) {
            return this.getOclRepresentationFor((Integer)o);
        }
        if (o instanceof Long) {
            return this.getOclRepresentationFor((Long)o);
        }
        if (o instanceof Float) {
            return this.getOclRepresentationFor(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return this.getOclRepresentationFor((Double)o);
        }
        if (o instanceof Character) {
            return this.getOclRepresentationFor(((Character)o).charValue());
        }
        return new OclAnyImpl(o);
    }

    public OclRoot getOclRepresentationForNull(Class c) {
        if ((class$java$lang$String == null ? (class$java$lang$String = DefaultOclFactory.class$("java.lang.String")) : class$java$lang$String) == c) {
            return new OclString("");
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = DefaultOclFactory.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(c)) {
            if ((class$java$util$Set == null ? (class$java$util$Set = DefaultOclFactory.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(c) || Ocl.TAKE_VECTORS_AS_SET && (class$java$util$Vector == null ? (class$java$util$Vector = DefaultOclFactory.class$("java.util.Vector")) : class$java$util$Vector).isAssignableFrom(c)) {
                return new OclSet(new HashSet());
            }
            if ((class$java$util$List == null ? (class$java$util$List = DefaultOclFactory.class$("java.util.List")) : class$java$util$List).isAssignableFrom(c)) {
                return new OclSequence(new ArrayList());
            }
            throw new OclException("encountered a java.util.Collection, which is neither Set or List.");
        }
        if (c.isArray()) {
            return new OclSequence(new ArrayList());
        }
        return null;
    }

    public OclBoolean getOclRepresentationFor(boolean b) {
        if (b) {
            return OclBoolean.TRUE;
        }
        return OclBoolean.FALSE;
    }

    public OclRoot getOclRepresentationFor(byte b) {
        return new OclInteger((long)b);
    }

    public OclRoot getOclRepresentationFor(short s) {
        return new OclInteger((long)s);
    }

    public OclRoot getOclRepresentationFor(int i) {
        return new OclInteger(i);
    }

    public OclRoot getOclRepresentationFor(long l) {
        return new OclInteger(l);
    }

    public OclRoot getOclRepresentationFor(float f) {
        return new OclReal((double)f);
    }

    public OclRoot getOclRepresentationFor(double d) {
        return new OclReal(d);
    }

    public OclRoot getOclRepresentationFor(char c) {
        return new OclString(new Character(c).toString());
    }

    public OclState getOclStateFor(String s) {
        return new OclState(s);
    }

    public Object reconvert(Class targetType, OclRoot oclObject) {
        if (oclObject instanceof OclString) {
            return ((OclString)oclObject).getString();
        }
        if (oclObject instanceof OclCollection) {
            OclCollection oc = (OclCollection)oclObject;
            Vector<Object> v = new Vector<Object>();
            OclIterator iter = oc.getIterator();
            while (iter.hasNext()) {
                iter.next();
                OclRoot obj = iter.getValue();
                v.add(this.reconvert(null, obj));
            }
            return v;
        }
        if (oclObject instanceof OclBoolean) {
            return new Boolean(((OclBoolean)oclObject).isTrue());
        }
        if (oclObject instanceof OclInteger) {
            return new Integer(((OclInteger)oclObject).getInt());
        }
        if (oclObject instanceof OclReal) {
            return new Float((float)((OclReal)oclObject).getDouble());
        }
        if (oclObject instanceof OclAnyImpl) {
            OclAnyImpl impl = (OclAnyImpl)oclObject;
            return impl.getObject();
        }
        return null;
    }

    public OclSequence getOclSequenceFor(Object o) {
        if (o instanceof Vector) {
            ArrayList<OclRoot> list = new ArrayList<OclRoot>();
            Enumeration enumeration = ((Vector)o).elements();
            while (enumeration.hasMoreElements()) {
                list.add(Ocl.getOclRepresentationFor(enumeration.nextElement()));
            }
            return new OclSequence(list);
        }
        if (o instanceof List) {
            return new OclSequence((List)o);
        }
        return new OclSequence(0, "failed cast to OclSequence");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

