/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Point;
import java.awt.Rectangle;

public class Geometry {
    private static Point tempPoint = new Point(0, 0);
    private static Rectangle tempRect1 = new Rectangle();

    public static void ptClosestTo(Rectangle r, Point p, Point res) {
        boolean NORTHWEST = false;
        boolean NORTH = true;
        int NORTHEAST = 2;
        int WEST = 3;
        int CENTER = 4;
        int EAST = 5;
        int SOUTHWEST = 6;
        int SOUTH = 7;
        int SOUTHEAST = 8;
        int x1 = Math.min(r.x, r.x + (r.width - 1));
        int y1 = Math.min(r.y, r.y + (r.height - 1));
        int x2 = Math.max(r.x, r.x + (r.width - 1));
        int y2 = Math.max(r.y, r.y + (r.height - 1));
        int c = p.x < x1 ? 0 : (p.x > x2 ? 2 : 1);
        if (p.y > y2) {
            c += 6;
        } else if (p.y > y1 && (c += 3) == 4) {
            int shortDist;
            int westDist = p.x - x1;
            int eastDist = x2 - p.x;
            int northDist = p.y - y1;
            int southDist = y2 - p.y;
            if (westDist < eastDist) {
                shortDist = westDist;
                c = 3;
            } else {
                shortDist = eastDist;
                c = 5;
            }
            if (northDist < shortDist) {
                shortDist = northDist;
                c = 1;
            }
            if (southDist < shortDist) {
                shortDist = southDist;
                c = 7;
            }
        }
        switch (c) {
            case 0: {
                res.x = x1;
                res.y = y1;
                return;
            }
            case 1: {
                res.x = p.x;
                res.y = y1;
                return;
            }
            case 2: {
                res.x = x2;
                res.y = y1;
                return;
            }
            case 3: {
                res.x = x1;
                res.y = p.y;
                return;
            }
            case 4: {
                res.x = p.x;
                res.y = p.y;
                return;
            }
            case 5: {
                res.x = x2;
                res.y = p.y;
                return;
            }
            case 6: {
                res.x = x1;
                res.y = y2;
                return;
            }
            case 7: {
                res.x = p.x;
                res.y = y2;
                return;
            }
            case 8: {
                res.x = x2;
                res.y = y2;
                return;
            }
        }
    }

    public static Point ptClosestTo(Rectangle r, Point p) {
        Point res = new Point(0, 0);
        Geometry.ptClosestTo(r, p, res);
        return res;
    }

    public static double segmentAngle(Point p1, Point p2) {
        if (p2.x == p1.x) {
            if (p2.y > p1.y) {
                return 90.0;
            }
            return 270.0;
        }
        if (p2.y == p1.y) {
            if (p2.x > p1.x) {
                return 0.0;
            }
            return 180.0;
        }
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double m = dy / dx;
        double a = Math.atan(m) * 180.0 / Math.PI;
        if (dx < 0.0) {
            a = 180.0 + a;
        } else if (dy < 0.0) {
            a = 360.0 + a;
        }
        return a;
    }

    public static double diffAngle(double angle1, double angle2) {
        double diff = Math.abs(angle1 - angle2);
        if (diff > 180.0) {
            diff = 360.0 - diff;
        }
        return diff;
    }

    public static void ptClosestTo(int x1, int y1, int x2, int y2, Point p, Point res) {
        if (y1 == y2 && x1 == x2) {
            res.x = x1;
            res.y = y1;
            return;
        }
        if (y1 == y2) {
            res.y = y1;
            res.x = Geometry.mid(x1, x2, p.x);
            return;
        }
        if (x1 == x2) {
            res.x = x1;
            res.y = Geometry.mid(y1, y2, p.y);
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        res.x = dy * (dy * x1 - dx * (y1 - p.y)) + dx * dx * p.x;
        res.x /= dx * dx + dy * dy;
        res.y = dx * (p.x - res.x) / dy + p.y;
        if (x2 > x1) {
            if (res.x > x2) {
                res.x = x2;
                res.y = y2;
            } else if (res.x < x1) {
                res.x = x1;
                res.y = y1;
            }
        } else if (res.x < x2) {
            res.x = x2;
            res.y = y2;
        } else if (res.x > x1) {
            res.x = x1;
            res.y = y1;
        }
    }

    private static int mid(int a, int b, int c) {
        if (a <= b) {
            if (b <= c) {
                return b;
            }
            if (c <= a) {
                return a;
            }
            return c;
        }
        if (b >= c) {
            return b;
        }
        if (c >= a) {
            return a;
        }
        return c;
    }

    public static Point ptClosestTo(int x1, int y1, int x2, int y2, Point p) {
        Point res = new Point(0, 0);
        Geometry.ptClosestTo(x1, y1, x2, y2, p, res);
        return res;
    }

    public static Point ptClosestTo(Point p1, Point p2, Point p) {
        return Geometry.ptClosestTo(p1.x, p1.y, p2.x, p2.y, p);
    }

    public static synchronized void ptClosestTo(int[] xs, int[] ys, int n, Point p, Point res) {
        res.x = xs[0];
        res.y = ys[0];
        int bestDist = (res.x - p.x) * (res.x - p.x) + (res.y - p.y) * (res.y - p.y);
        Geometry.tempPoint.x = 0;
        Geometry.tempPoint.y = 0;
        for (int i = 0; i < n - 1; ++i) {
            Geometry.ptClosestTo(xs[i], ys[i], xs[i + 1], ys[i + 1], p, tempPoint);
            int tDist = (Geometry.tempPoint.x - p.x) * (Geometry.tempPoint.x - p.x) + (Geometry.tempPoint.y - p.y) * (Geometry.tempPoint.y - p.y);
            if (bestDist <= tDist) continue;
            bestDist = tDist;
            res.x = Geometry.tempPoint.x;
            res.y = Geometry.tempPoint.y;
        }
    }

    public static Point ptClosestTo(int[] xs, int[] ys, int n, Point p) {
        Point res = new Point(0, 0);
        Geometry.ptClosestTo(xs, ys, n, p, res);
        return res;
    }

    public static synchronized boolean nearPolySegment(int[] xs, int[] ys, int n, int x, int y, int grip) {
        for (int i = 0; i < n - 1; ++i) {
            int x1 = xs[i];
            int y1 = ys[i];
            int x2 = xs[i + 1];
            int y2 = ys[i + 1];
            if (!Geometry.nearSegment(x1, y1, x2, y2, x, y, grip)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean nearSegment(int x1, int y1, int x2, int y2, int x, int y, int grip) {
        tempRect1.setBounds(x - grip, y - grip, 2 * grip, 2 * grip);
        return Geometry.intersects(tempRect1, x1, y1, x2, y2);
    }

    public static synchronized boolean intersects(Rectangle r, int x1, int y1, int x2, int y2) {
        return r.intersectsLine(x1, y1, x2, y2);
    }

    public static int counterClockWise(int x1, int y1, int x2, int y2, int x, int y) {
        int dx1 = x2 - x1;
        int dy2 = y - y1;
        int dy1 = y2 - y1;
        int dx2 = x - x1;
        if (dx1 * dy2 > dy1 * dx2) {
            return 1;
        }
        if (dx1 * dy2 < dy1 * dx2) {
            return -1;
        }
        if (dx1 * dx2 < 0 || dy1 * dy2 < 0) {
            return -1;
        }
        if (dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2) {
            return 1;
        }
        return 0;
    }
}

