/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.tigris.gef.base.AlignAction;
import org.tigris.gef.base.DistributeAction;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.util.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeBroom
extends FigModifyingModeImpl {
    private static final long serialVersionUID = -6846688672699867345L;
    private static final String resource = "GefBase";
    private final int DIRECTION_UNDEFINED = 0;
    private final int DIRECTION_UPWARD = 1;
    private final int DIRECTION_DOWNWARD = 2;
    private final int DIRECTION_RIGHTWARD = 3;
    private final int DIRECTION_LEFTWARD = 4;
    private final int DEFINE_DIRECTION_TOLERANCE = 10;
    private final int BROOM_WIDTH_NORMAL = 200;
    private final int BROOM_WIDTH_SMALL = 30;
    private final int MAX_TOUCHED_FIGS = 1000;
    private final int DISTRIBUTE_EVEN_SPACE = 0;
    private final int DISTRIBUTE_PACK = 1;
    private final int DISTRIBUTE_SPREAD = 2;
    private final int DISTRIBUTE_ORIG = 3;
    private final Font HINT_FONT = new Font("Dialog", 0, 9);
    private Point _start = new Point(0, 0);
    private Vector<Fig> _LastTouched = new Vector();
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int _lastX1;
    private int _lastY1;
    private int _lastX2;
    private int _lastY2;
    private int _lastMX;
    private int _lastMY;
    private int _dir = 0;
    private boolean _magnetic = false;
    private boolean _movable = true;
    private boolean _draw = false;
    private Fig[] _touched = new Fig[1000];
    private int[] _origX = new int[1000];
    private int[] _origY = new int[1000];
    private int[] _offX = new int[1000];
    private int[] _offY = new int[1000];
    private int _nTouched = 0;
    private int _broomMargin = 0;
    private int _distributeMode = 0;
    private Rectangle _addRect = new Rectangle();
    private Rectangle _selectRect = new Rectangle();
    private Rectangle _bigDamageRect = new Rectangle(0, 0, 400, 400);
    private Rectangle _origBBox = null;
    private String _hint = null;

    public ModeBroom(Editor par) {
        super(par);
    }

    public ModeBroom() {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        this._touched = new Fig[1000];
        this._origX = new int[1000];
        this._origY = new int[1000];
        this._offX = new int[1000];
        this._offY = new int[1000];
        this._nTouched = 0;
        this._dir = 0;
        this._magnetic = false;
        this._draw = true;
        this.x2 = this._start.x = me.getX();
        this.x1 = this._start.x;
        this.y2 = this._start.y = me.getY();
        this.y1 = this._start.y;
        this._lastX1 = this.x1;
        this._lastY1 = this.y1;
        this._lastX2 = this.x2;
        this._lastY2 = this.y2;
        this._selectRect.setBounds(this.x1 - 14, this.y1 - 14, this.x2 - this.x1 + 28, this.y2 - this.y1 + 28);
        this.editor.damaged(this._selectRect);
        me.consume();
        this._hint = null;
        this.start();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        me.consume();
        this.editor.getSelectionManager().deselectAll();
        Point snapPt = me.getPoint();
        snapPt.x = Math.max(0, snapPt.x);
        snapPt.y = Math.max(0, snapPt.y);
        this._lastMX = snapPt.x;
        this._lastMY = snapPt.y;
        this.editor.snap(snapPt);
        int x = snapPt.x;
        int y = snapPt.y;
        this._selectRect.setBounds(this.x1 - 4, this.y1 - 4, this.x2 - this.x1 + 8, this.y2 - this.y1 + 8);
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this.editor.damaged(this._bigDamageRect);
        this.editor.damaged(this._selectRect);
        if (this._dir == 0) {
            this._broomMargin = me.isShiftDown() ? 30 : 200;
            int dx = me.getX() - this._start.x;
            int dy = me.getY() - this._start.y;
            if (Math.abs(dx) < 10 && Math.abs(dy) < 10) {
                return;
            }
            if (Math.abs(dx) > Math.abs(dy)) {
                this._dir = dx > 0 ? 3 : 4;
                this.x1 = this.x2 = x;
                this.y1 = y - this._broomMargin / 2;
                this.y2 = y + this._broomMargin / 2;
                if (me.isShiftDown()) {
                    this.y1 = y - this._broomMargin / 2;
                    this.y2 = y + this._broomMargin / 2;
                }
            } else {
                this._dir = dy > 0 ? 2 : 1;
                this.y1 = this.y2 = y;
                this.x1 = x - this._broomMargin / 2;
                this.x2 = x + this._broomMargin / 2;
                if (me.isShiftDown()) {
                    this.x1 = x - this._broomMargin / 2;
                    this.x2 = x + this._broomMargin / 2;
                }
            }
        }
        if (!this._magnetic) {
            this.addNewItems();
        }
        this._lastX1 = this.x1;
        this._lastY1 = this.y1;
        this._lastX2 = this.x2;
        this._lastY2 = this.y2;
        switch (this._dir) {
            case 1: {
                if (this._movable) {
                    this.y1 = this.y2 = Math.min(y, this._start.y);
                    if (this._magnetic) {
                        this.y1 = this.y2 = y;
                    }
                }
                this.x1 = Math.min(this.x1, this._lastMX - this._broomMargin / 2);
                this.x2 = Math.max(this.x2, this._lastMX + this._broomMargin / 2);
                break;
            }
            case 2: {
                if (this._movable) {
                    this.y1 = this.y2 = Math.max(y, this._start.y);
                    if (this._magnetic) {
                        this.y1 = this.y2 = y;
                    }
                }
                this.x1 = Math.min(this.x1, this._lastMX - this._broomMargin / 2);
                this.x2 = Math.max(this.x2, this._lastMX + this._broomMargin / 2);
                break;
            }
            case 3: {
                if (this._movable) {
                    this.x1 = this.x2 = Math.max(x, this._start.x);
                    if (this._magnetic) {
                        this.x1 = this.x2 = x;
                    }
                }
                this.y1 = Math.min(this.y1, this._lastMY - this._broomMargin / 2);
                this.y2 = Math.max(this.y2, this._lastMY + this._broomMargin / 2);
                break;
            }
            case 4: {
                if (this._movable) {
                    this.x1 = this.x2 = Math.min(x, this._start.x);
                    if (this._magnetic) {
                        this.x1 = this.x2 = x;
                    }
                }
                this.y1 = Math.min(this.y1, this._lastMY - this._broomMargin / 2);
                this.y2 = Math.max(this.y2, this._lastMY + this._broomMargin / 2);
            }
        }
        if (this._movable) {
            Fig f;
            int i;
            Vector<FigEdge> nonMovingEdges = new Vector<FigEdge>();
            Vector<FigEdge> movingEdges = new Vector<FigEdge>();
            for (i = 0; i < this._nTouched; ++i) {
                f = this._touched[i];
                int newX = x;
                int newY = y;
                int figX = f.getX();
                int figY = f.getY();
                int dx = 0;
                int dy = 0;
                switch (this._dir) {
                    case 1: {
                        if (!this._magnetic) {
                            newY = Math.min(y, this._origY[i] + this._offY[i]);
                        }
                        dy = Math.max(-figY, newY - figY - this._offY[i]);
                        break;
                    }
                    case 2: {
                        if (!this._magnetic) {
                            newY = Math.max(y, this._origY[i] + this._offY[i]);
                        }
                        dy = newY - figY - this._offY[i];
                        break;
                    }
                    case 3: {
                        if (!this._magnetic) {
                            newX = Math.max(x, this._origX[i] + this._offX[i]);
                        }
                        dx = newX - figX - this._offX[i];
                        break;
                    }
                    case 4: {
                        if (!this._magnetic) {
                            newX = Math.min(x, this._origX[i] + this._offX[i]);
                        }
                        dx = Math.max(-figX, newX - figX - this._offX[i]);
                    }
                }
                if (f instanceof FigNode) {
                    FigNode fn = (FigNode)f;
                    fn.superTranslate(dx, dy);
                    for (FigEdge fe : fn.getFigEdges(null)) {
                        if (nonMovingEdges.contains(fe) && !movingEdges.contains(fe)) {
                            movingEdges.addElement(fe);
                            fe.translateEdge(dx, dy);
                            continue;
                        }
                        nonMovingEdges.addElement(fe);
                    }
                } else {
                    f.translate(dx, dy);
                }
                if (!(dx <= 0 && dy <= 0 || f instanceof FigEdge)) {
                    MutableGraphSupport.enableSaveAction();
                }
                f.endTrans();
            }
            for (i = 0; i < this._nTouched; ++i) {
                f = this._touched[i];
                if (!(f instanceof FigNode)) continue;
                ((FigNode)f).updateEdges();
            }
        }
        this._selectRect.setBounds(this.x1 - 4, this.y1 - 4, this.x2 - this.x1 + 8, this.y2 - this.y1 + 8);
        this.editor.damaged(this._selectRect);
        this._hint = null;
        this.touching();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        this._selectRect.setBounds(this.x1 - 1, this.y1 - 1, this.x2 - this.x1 + 2, this.y2 - this.y1 + 20);
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this.editor.damaged(this._bigDamageRect);
        this.editor.damaged(this._selectRect);
        if (this._LastTouched.size() > 0) {
            this.editor.getSelectionManager().selectFigs(this._LastTouched);
        }
        this._draw = false;
        this.done();
        me.consume();
        this._hint = null;
    }

    public void addNewItems() {
        if (this._nTouched >= 1000) {
            return;
        }
        this._addRect.setBounds(this._lastX1, this._lastY1, this._lastX2 - this._lastX1, this._lastY2 - this._lastY1);
        this._addRect.add(this._selectRect);
        block0: for (Fig f : this.editor.getFigs()) {
            Rectangle figBounds = f.getBounds();
            if (!this._addRect.intersects(figBounds) || this._dir == 4 && figBounds.x + figBounds.width > this._addRect.x + this._addRect.width || this._dir == 3 && figBounds.x < this._addRect.x || this._dir == 1 && figBounds.y + figBounds.height > this._addRect.y + this._addRect.height || this._dir == 2 && figBounds.y < this._addRect.y) continue;
            for (int i = 0; i < this._nTouched; ++i) {
                Fig ft = this._touched[i];
                if (ft == f) continue block0;
            }
            this._touched[this._nTouched] = f;
            this._origX[this._nTouched] = f.getX();
            this._origY[this._nTouched] = f.getY();
            this._offX[this._nTouched] = this._dir == 4 ? f.getWidth() : 0;
            this._offY[this._nTouched] = this._dir == 1 ? f.getHeight() : 0;
            ++this._nTouched;
            this._origBBox = null;
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        super.keyTyped(ke);
        if (ke.isConsumed()) {
            return;
        }
        if ('\n' == ke.getKeyChar() || '\t' == ke.getKeyChar()) {
            this._magnetic = !this._magnetic;
        } else if (' ' == ke.getKeyChar()) {
            this.doDistibute(false, ke.isShiftDown());
            ke.consume();
        } else {
            return;
        }
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this.editor.damaged(this._bigDamageRect);
        this.editor.damaged(this._selectRect);
    }

    public void doDistibute(boolean alignToGrid, boolean doCentering) {
        this._movable = false;
        Vector<Fig> figs = this._LastTouched;
        if (figs == null) {
            figs = this.touching();
        }
        int request = 0;
        int size = figs.size();
        if (this._distributeMode == 0 || this._distributeMode == 2) {
            request = 4;
            if (this._dir == 1 || this._dir == 2) {
                request = 0;
            }
        } else if (this._distributeMode == 1) {
            request = 6;
            if (this._dir == 1 || this._dir == 2) {
                request = 2;
            }
        }
        if (this._distributeMode == 3) {
            for (int i = 0; i < size; ++i) {
                Fig f = figs.elementAt(i);
                if (this._dir == 1 || this._dir == 2) {
                    f.setLocation(this._origX[i], f.getY());
                } else {
                    f.setLocation(f.getX(), this._origY[i]);
                }
                f.endTrans();
            }
        } else {
            DistributeAction d = new DistributeAction(request, figs);
            if (this._distributeMode == 2) {
                d.setBoundingBox(this._selectRect);
            } else if (this._distributeMode == 0 && this._origBBox != null) {
                d.setBoundingBox(this._origBBox);
            }
            d.actionPerformed(null);
            if (doCentering) {
                int centerRequest = 5;
                if (this._dir == 1 || this._dir == 2) {
                    centerRequest = 6;
                }
                AlignAction a = new AlignAction(centerRequest, figs);
                a.actionPerformed(null);
            }
            if (alignToGrid) {
                AlignAction a = new AlignAction(7, figs);
                a.actionPerformed(null);
            }
            if (this._distributeMode == 0 && this._origBBox == null) {
                this._origBBox = d.getBoundingBox();
            }
        }
        this._hint = this._distributeMode == 0 ? "BroomSpaceEvenly" : (this._distributeMode == 1 ? "BroomPackTightly" : (this._distributeMode == 2 ? "BroomSpreadOut" : (this._distributeMode == 3 ? "BroomOriginal" : "(internal prog error)")));
        if (doCentering) {
            this._hint = this._hint + "Center";
        }
        if (alignToGrid) {
            this._hint = this._hint + "Snap";
        }
        this._hint = Localizer.localize(resource, this._hint);
        this._distributeMode = (this._distributeMode + 1) % 4;
    }

    public Vector<Fig> touching() {
        Vector<Fig> figs = new Vector<Fig>(this._nTouched);
        for (int i = 0; i < this._nTouched; ++i) {
            if (!this._touched[i].getBounds().intersects(this._selectRect) || this._touched[i] instanceof FigEdge) continue;
            figs.addElement(this._touched[i]);
        }
        this._LastTouched = figs;
        return figs;
    }

    @Override
    public String instructions() {
        return Localizer.localize(resource, "BroomInstructions");
    }

    @Override
    public void paint(Graphics g) {
        if (!this._draw) {
            return;
        }
        Color selectRectColor = Globals.getPrefs().getRubberbandColor();
        if (this._magnetic) {
            g.setColor(Color.red);
        } else {
            g.setColor(selectRectColor);
        }
        if (this._hint != null) {
            g.setFont(this.HINT_FONT);
        }
        int bm = this._broomMargin / 2;
        switch (this._dir) {
            case 0: {
                g.fillRect(this.x1 - 10, (this.y1 + this.y2) / 2 - 2, 20, 4);
                g.fillRect((this.x1 + this.x2) / 2 - 2, this.y1 - 10, 4, 20);
                break;
            }
            case 1: {
                g.fillRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1 + 4);
                g.drawLine(this._lastMX - bm, this.y2 + 4, this._lastMX - bm, this.y2 + 8);
                g.drawLine(this._lastMX + bm - 1, this.y2 + 4, this._lastMX + bm - 1, this.y2 + 8);
                if (this._movable) {
                    g.fillRect((this.x1 + this.x2) / 2 - 2, this.y1, 4, 14);
                }
                if (this._hint == null) break;
                g.drawString(this._hint, (this.x1 + this.x2) / 2 + 5, this.y1 + 15);
                break;
            }
            case 2: {
                g.fillRect(this.x1, this.y1 - 4, this.x2 - this.x1, this.y2 - this.y1 + 4);
                if (this._movable) {
                    g.fillRect((this.x1 + this.x2) / 2 - 2, this.y1 - 14, 4, 14);
                }
                g.drawLine(this._lastMX - bm, this.y1 - 4, this._lastMX - bm, this.y1 - 8);
                g.drawLine(this._lastMX + bm - 1, this.y1 - 4, this._lastMX + bm - 1, this.y1 - 8);
                if (this._hint == null) break;
                g.drawString(this._hint, (this.x1 + this.x2) / 2 + 5, this.y1 - 8);
                break;
            }
            case 3: {
                g.fillRect(this.x1 - 4, this.y1, this.x2 - this.x1 + 4, this.y2 - this.y1);
                g.drawLine(this.x1 - 4, this._lastMY - bm, this.x1 - 8, this._lastMY - bm);
                g.drawLine(this.x1 - 4, this._lastMY + bm - 1, this.x1 - 8, this._lastMY + bm - 1);
                if (this._movable) {
                    g.fillRect(this.x1 - 14, (this.y1 + this.y2) / 2 - 2, 14, 4);
                }
                if (this._hint == null) break;
                g.drawString(this._hint, this.x1 - 70, (this.y1 + this.y2) / 2 - 10);
                break;
            }
            case 4: {
                g.fillRect(this.x1, this.y1, this.x2 - this.x1 + 4, this.y2 - this.y1);
                g.drawLine(this.x2 + 4, this._lastMY - bm, this.x2 + 8, this._lastMY - bm);
                g.drawLine(this.x2 + 4, this._lastMY + bm - 1, this.x2 + 8, this._lastMY + bm - 1);
                if (this._movable) {
                    g.fillRect(this.x1, (this.y1 + this.y2) / 2 - 2, 14, 4);
                }
                if (this._hint == null) break;
                g.drawString(this._hint, this.x2 + 5, (this.y1 + this.y2) / 2 - 10);
            }
        }
    }
}

