/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.util.Localizer;

public class ModeDragScroll
extends FigModifyingModeImpl
implements ActionListener {
    private static final long serialVersionUID = -3744868964626889125L;
    private Dimension _viewportExtent;
    private boolean autoscroll = false;
    private Timer autoTimer;
    private int recentX;
    private int recentY;
    private static final int AUTOSCROLL_DELAY = 200;
    private static final int SCROLL_INCREMENT = 10;
    private boolean _isScrolling = false;
    private JViewport _viewport = null;
    private Cursor _oldCursor = null;
    private JComponent _component = null;
    private Dimension componentSize = null;
    private Point viewPosition = new Point();
    private int deltaX;
    private int deltaY;
    private int lastX;
    private int lastY;
    private boolean simpleDrag = false;

    public ModeDragScroll(Editor editor) {
        super(editor);
        this.autoTimer = new Timer(200, this);
    }

    public ModeDragScroll() {
        this((Editor)null);
    }

    public boolean canExit() {
        return false;
    }

    public String instructions() {
        return Localizer.localize("GefBase", "ModeDragScrollInstructions");
    }

    public void mousePressed(MouseEvent me) {
        int onmask = 2048;
        int offmask = 640;
        boolean buttonCondition = (me.getModifiersEx() & (onmask | offmask)) == onmask;
        onmask = 1024;
        offmask = 6336;
        boolean bl = this.simpleDrag = (me.getModifiersEx() & (onmask | offmask)) == onmask;
        if (!buttonCondition) {
            return;
        }
        this._component = this.editor.getJComponent();
        if (this._component == null) {
            return;
        }
        Container parent = this._component.getParent();
        if (!(parent instanceof JViewport)) {
            return;
        }
        this._isScrolling = true;
        me = this.editor.retranslateMouseEvent(me);
        this._viewport = (JViewport)parent;
        this.viewPosition = this._viewport.getViewPosition();
        this._viewportExtent = this._viewport.getExtentSize();
        this.componentSize = this._component.getSize();
        this.deltaX = 0;
        this.deltaY = 0;
        this.lastX = me.getX();
        this.lastY = me.getY();
        this._oldCursor = this._component.getCursor();
        this._component.setCursor(Cursor.getPredefinedCursor(13));
        me.consume();
        this.editor.translateMouseEvent(me);
        if (this.simpleDrag) {
            this.autoTimer.stop();
            this.autoscroll = false;
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (this.simpleDrag) {
            me = this.editor.retranslateMouseEvent(me);
            int mouseX = me.getX();
            int mouseY = me.getY();
            this.recentX = mouseX;
            this.recentY = mouseY;
            JComponent jComponent = this.editor.getJComponent();
            if (jComponent != null && jComponent.getParent() instanceof JViewport) {
                boolean ok = this.doScroll(jComponent, mouseX, mouseY);
                if (ok && !this.autoscroll) {
                    this.autoscroll = true;
                    this.autoTimer.start();
                } else if (!ok) {
                    this.autoscroll = false;
                    this.autoTimer.stop();
                }
            }
        } else {
            if (!this._isScrolling) {
                return;
            }
            me = this.editor.retranslateMouseEvent(me);
            int x = me.getX();
            int y = me.getY();
            int factor = me.isShiftDown() ? 4 : 1;
            this.deltaX = factor * (this.lastX - x);
            this.deltaY = factor * (this.lastY - y);
            this.deltaX = Math.max(-this.viewPosition.x, this.deltaX);
            this.deltaX = Math.min(this.componentSize.width - (this.viewPosition.x + this._viewportExtent.width), this.deltaX);
            this.deltaY = Math.max(-this.viewPosition.y, this.deltaY);
            this.deltaY = Math.min(this.componentSize.height - (this.viewPosition.y + this._viewportExtent.height), this.deltaY);
            this.viewPosition.x += this.deltaX;
            this.viewPosition.y += this.deltaY;
            this._viewport.setViewPosition(this.viewPosition);
            if (this.deltaX != 0) {
                this.lastX = x + this.deltaX;
            }
            if (this.deltaY != 0) {
                this.lastY = y + this.deltaY;
            }
            me.consume();
            this.editor.translateMouseEvent(me);
        }
    }

    private final boolean doScroll(JComponent jComponent, int mouseX, int mouseY) {
        if (jComponent != null && jComponent.getParent() instanceof JViewport) {
            Dimension componentSize = jComponent.getSize();
            JViewport view = (JViewport)jComponent.getParent();
            Rectangle viewRect = view.getViewRect();
            int viewRight = viewRect.x + viewRect.width;
            int viewY = viewRect.y + viewRect.height;
            if (mouseX > viewRight && viewRight <= componentSize.width - 10) {
                view.setViewPosition(new Point(viewRect.x + 10, viewRect.y));
                return true;
            }
            if (mouseX < viewRect.x && viewRect.x - 10 >= 0) {
                view.setViewPosition(new Point(viewRect.x - 10, viewRect.y));
                return true;
            }
            if (mouseY > viewY && viewY <= componentSize.height - 10) {
                view.setViewPosition(new Point(viewRect.x, viewRect.y + 10));
                return true;
            }
            if (mouseY < viewRect.y && viewRect.y - 10 >= 0) {
                view.setViewPosition(new Point(viewRect.x, viewRect.y - 10));
                return true;
            }
        }
        return false;
    }

    public void mouseReleased(MouseEvent me) {
        if (this.autoscroll) {
            this.autoTimer.stop();
            this.autoscroll = false;
            this.simpleDrag = false;
        }
        if (!this._isScrolling) {
            return;
        }
        this._isScrolling = false;
        this.viewPosition = null;
        this._component.setCursor(this._oldCursor);
        this._component = null;
        this.componentSize = null;
        this._viewport = null;
        this._oldCursor = null;
        me.consume();
    }

    public void actionPerformed(ActionEvent e) {
        MouseEvent me = new MouseEvent(this.getEditor().getJComponent(), 506, 0L, 16, this.recentX, this.recentY, 0, false);
        this.getEditor().mouseDragged(me);
    }
}

