/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Mode;
import org.tigris.gef.util.Localizer;

public class SetModeAction
extends AbstractAction {
    private static final long serialVersionUID = -5362721817833001571L;
    protected Hashtable modeArgs;
    protected Hashtable args;

    public SetModeAction(Properties args) {
        this("SetEditorMode", args);
    }

    public SetModeAction(String name, Properties args) {
        super(name);
        this.args = args;
    }

    public SetModeAction(String name) {
        this(name, false);
    }

    public SetModeAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public SetModeAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SetModeAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public SetModeAction(Class modeClass) {
        super("SetEditorMode");
        this.setArg("desiredModeClass", modeClass);
    }

    public SetModeAction(Class modeClass, String name) {
        super(name);
        this.setArg("desiredModeClass", modeClass);
    }

    public SetModeAction(Class modeClass, boolean sticky) {
        super("SetEditorMode");
        this.setArg("desiredModeClass", modeClass);
        this.setArg("shouldBeSticky", sticky ? Boolean.TRUE : Boolean.FALSE);
    }

    public SetModeAction(Class modeClass, Hashtable modeArgs) {
        super("SetEditorMode");
        this.setArg("desiredModeClass", modeClass);
        this.modeArgs = modeArgs;
    }

    public SetModeAction(Class modeClass, String arg, Object value) {
        this(modeClass, arg, value, "SetEditorMode");
        this.modeArgs = new Hashtable(1);
        this.modeArgs.put(arg, value);
        this.setArg("desiredModeClass", modeClass);
    }

    public SetModeAction(Class modeClass, String arg, Object value, String name) {
        super(name);
        this.modeArgs = new Hashtable(1);
        this.modeArgs.put(arg, value);
        this.setArg("desiredModeClass", modeClass);
    }

    public SetModeAction(Class modeClass, String arg, Object value, String name, ImageIcon icon) {
        super(name, icon);
        this.modeArgs = new Hashtable(1);
        this.modeArgs.put(arg, value);
        this.setArg("desiredModeClass", modeClass);
    }

    public void actionPerformed(ActionEvent e) {
        Mode mode;
        Class desiredModeClass = (Class)this.getArg("desiredModeClass");
        try {
            mode = (Mode)desiredModeClass.newInstance();
        }
        catch (InstantiationException ignore) {
            return;
        }
        catch (IllegalAccessException ignore) {
            return;
        }
        mode.init(this.modeArgs);
        Boolean shouldBeSticky = (Boolean)this.getArg("shouldBeSticky");
        if (shouldBeSticky == null) {
            Globals.mode(mode);
        } else {
            Globals.mode(mode, shouldBeSticky);
        }
    }

    private void setArg(String key, Object value) {
        if (this.args == null) {
            this.args = new Hashtable();
        }
        this.args.put(key, value);
    }

    private Object getArg(String key) {
        if (this.args == null) {
            return null;
        }
        return this.args.get(key);
    }
}

