/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;

public class IDFilter
extends StartTagBuffer {
    private String requiredId;
    private int activeDepth = 0;
    private boolean matched = false;
    private IntHashSet nonIDs;

    public IDFilter(String id) {
        this.requiredId = id;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.matched = false;
        if (this.activeDepth > 0) {
            ++this.activeDepth;
        }
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        super.attribute(nameCode, typeCode, value, locationId, properties);
        if (((nameCode & 0xFFFFF) == 388 || this.isIDCode(typeCode)) && ((Object)value).toString().equals(this.requiredId)) {
            this.matched = true;
        }
    }

    public void startContent() throws XPathException {
        if (this.activeDepth > 0) {
            super.startContent();
        } else if (this.matched) {
            this.activeDepth = 1;
            super.startContent();
        }
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        if (this.activeDepth == 1) {
            this.declareAllNamespaces();
        } else {
            super.declareNamespacesForStartElement();
        }
    }

    public void endElement() throws XPathException {
        if (this.activeDepth > 0) {
            this.nextReceiver.endElement();
            --this.activeDepth;
        } else {
            this.undeclareNamespacesForElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.processingInstruction(target, data, locationId, properties);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.comment(chars, locationId, properties);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    private boolean isIDCode(int typeCode) {
        if ((typeCode & 0xFFFFF) == 560) {
            return true;
        }
        if (typeCode < 1024) {
            return false;
        }
        if (this.nonIDs == null) {
            this.nonIDs = new IntHashSet(20);
        }
        if (this.nonIDs.contains(typeCode)) {
            return false;
        }
        SchemaType type = this.getConfiguration().getSchemaType(typeCode);
        if (type.isAtomicType()) {
            if (this.getConfiguration().getTypeHierarchy().isSubType((AtomicType)type, BuiltInAtomicType.ID)) {
                return true;
            }
            this.nonIDs.add(typeCode);
            return false;
        }
        return false;
    }
}

