# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	adler2@2.0.1
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.11
	autocfg@1.5.0
	bitflags@2.9.4
	bitvec@1.0.1
	bumpalo@3.19.0
	bytemuck@1.23.2
	byteorder-lite@0.1.0
	cc@1.2.38
	cfg-if@1.0.3
	clap@4.5.53
	clap_builder@4.5.53
	clap_lex@0.7.5
	colorchoice@1.0.4
	crc32fast@1.5.0
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.21
	either@1.15.0
	env_filter@0.1.3
	env_logger@0.11.8
	equivalent@1.0.2
	errno@0.3.14
	fdeflate@0.3.7
	filetime@0.2.26
	find-msvc-tools@0.1.2
	flate2@1.1.2
	funty@2.0.0
	glob@0.3.3
	hashbrown@0.16.1
	image@0.25.9
	indexmap@2.12.1
	is_terminal_polyfill@1.70.1
	libc@0.2.175
	libdeflate-sys@1.25.0
	libdeflater@1.25.0
	libredox@0.1.10
	linux-raw-sys@0.11.0
	log@0.4.28
	miniz_oxide@0.8.9
	moxcms@0.7.5
	num-traits@0.2.19
	once_cell_polyfill@1.70.1
	parse-size@1.1.0
	pkg-config@0.3.32
	png@0.18.0
	pxfm@0.1.24
	radium@0.7.0
	rayon-core@1.13.0
	rayon@1.11.0
	redox_syscall@0.5.17
	rgb@0.8.52
	rustc-hash@2.1.1
	rustix@1.1.2
	shlex@1.3.0
	simd-adler32@0.3.7
	strsim@0.11.1
	tap@1.0.1
	terminal_size@0.4.3
	utf8parse@0.2.2
	windows-link@0.1.3
	windows-link@0.2.0
	windows-sys@0.60.2
	windows-sys@0.61.0
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.53.0
	wyz@0.5.1
	zopfli@0.8.3
"

RUST_MIN_VER="1.85.1"

inherit cargo

DESCRIPTION="Multithreaded lossless PNG compression optimizer written in Rust"
HOMEPAGE="https://github.com/oxipng/oxipng"
SRC_URI="
	https://github.com/oxipng/oxipng/archive/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 MIT"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~riscv ~x86"

BDEPEND="virtual/pkgconfig"
DEPEND=">=app-arch/libdeflate-1.23"
RDEPEND="${DEPEND}"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/${PN}"
QA_PRESTRIPPED="usr/bin/${PN}"

src_prepare() {
	pushd "${WORKDIR}" || die
	eapply "${FILESDIR}"/oxipng-10.0.0-libdeflater-1.25.0-relax-libdeflate-sys-version.patch
	popd > /dev/null || die

	# Remove the linker configs (in `.cargo/config.toml`) specific to GitHub CI.
	# https://bugs.gentoo.org/924946
	rm -rv "${S}/.cargo/config.toml" || die

	default_src_prepare
}

src_configure() {
	export PKG_CONFIG_ALLOW_CROSS=1
	local myfeatures=(
		system-libdeflate
	)

	cargo_src_configure
}

src_install() {
	cargo_src_install

	dodoc CHANGELOG.md README.md
}
