;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2019 Ivan Petkov <ivanppetkov@gmail.com>
;;; Copyright © 2019, 2020, 2021, 2022 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2019-2022 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2019 Giacomo Leidi <goodoldpaul@autistici.org>
;;; Copyright © 2019–2021 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2019, 2020 John Soo <jsoo1@asu.edu>
;;; Copyright © 2019, 2020 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2020 Jakub Kądziołka <kuba@kadziolka.net>
;;; Copyright © 2020 Leo Famulari <leo@famulari.name>
;;; Copyright © 2020 Gabriel Arazas <foo.dogsquared@gmail.com>
;;; Copyright © 2020 André Batista <nandre@riseup.net>
;;; Copyright © 2020 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2020 Antoine Côté <antoine.cote@posteo.net>
;;; Copyright © 2021, 2022 Maxim Cournoyer <maxim.cournoyer@gmail.com>
;;; Copyright © 2021 aecepoglu <aecepoglu@fastmail.fm>
;;; Copyright © 2021, 2022 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2021 Alexandru-Sergiu Marton <brown121407@posteo.ro>
;;; Copyright © 2021 Antero Mejr <antero@kodmin.com>
;;; Copyright © 2021 Maxim Cournoyer <maxim.cournoyer@gmail.com>
;;; Copyright © 2021 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2021 muradm <mail@muradm.net>
;;; Copyright © 2021, 2022 Petr Hodina <phodina@protonmail.com>
;;; Copyright © 2021, 2022 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2021 Jacob Hrbek <kreyren@rixotstudio.cz>
;;; Copyright © 2021, 2022 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2022 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2022 Marius Bakke <marius@gnu.org>
;;; Copyright © 2022 Evgenii Lepikhin <e.lepikhin@corp.mail.ru>
;;; Copyright © 2022 Gabriel Arazas <foo.dogsquared@gmail.com>
;;; Copyright © 2022 ( <paren@disroot.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages crates-io)
  #:use-module (guix build-system cargo)
  #:use-module (guix download)
  #:use-module (guix git-download)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix utils)
  #:use-module (gnu packages)
  #:use-module (gnu packages admin)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages crates-graphics)
  #:use-module (gnu packages crates-gtk)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages gettext)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages image)
  #:use-module (gnu packages jemalloc)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages m4)
  #:use-module (gnu packages mail)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages nettle)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages pulseaudio)
  #:use-module (gnu packages python)
  #:use-module (gnu packages rust)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages sequoia)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages web)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages webkit)
  #:use-module (srfi srfi-1))

;;;
;;; Please: Try to add new module packages in alphabetic order.
;;;

(define-public rust-ab-glyph-rasterizer-0.1
  (package
    (name "rust-ab-glyph-rasterizer")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ab_glyph_rasterizer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zzz78231w849xslz9s0pwjj6gp02wfbbxdpysqhwwq1vqr5xznr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/alexheretic/ab-glyph")
    (synopsis "Coverage rasterization for lines, quadratic & cubic beziers")
    (description
     "This package provides coverage rasterization for lines, quadratic and
cubic beziers.")
    (license license:asl2.0)))

(define-public rust-abomonation-0.7
  (package
    (name "rust-abomonation")
    (version "0.7.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "abomonation" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1cjg3hjf028n447pdj7zcdgrkngx30as8ndxlxx947wvr49jkrsn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-recycler" ,rust-recycler-0.1))))
    (home-page "https://github.com/TimelyDataflow/abomonation")
    (synopsis "High performance and very unsafe serialization library")
    (description
     "This package provides a high performance and very unsafe serialization
library in Rust.")
    (license license:expat)))

(define-public rust-actix-0.10
  (package
    (name "rust-actix")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q6cd08d0xikilj9l3gfsyhva5b91y55lfxy7yd7w7ivizw43qhv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;doc test fails
       #:cargo-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-derive" ,rust-actix-derive-0.5)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3)
        ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.19)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.19))))
    (home-page "https://actix.rs")
    (synopsis "Actor framework for Rust")
    (description "This package provides Actix actor framework for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-0.8
  (package
    (inherit rust-actix-0.10)
    (name "rust-actix")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xqyrwq7hgi640h5czy73zrkxl1s0yhm7laxga13dwhkfg9f6737"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-http" ,rust-actix-http-0.2)
        ("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-derive" ,rust-actix-derive-0.4)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.3)
        ("rust-derive-more" ,rust-derive-more-0.14)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-hashbrown" ,rust-hashbrown-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-parking-lot" ,rust-parking-lot-0.8)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-tokio-codec" ,rust-tokio-codec-0.1)
        ("rust-tokio-executor" ,rust-tokio-executor-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.11))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3))))))

(define-public rust-actix-codec-0.3
  (package
    (name "rust-actix-codec")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-codec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w7506qd2f8q83z6l5lqx1363ks0ysx8f7qgvy8fknrq70xq7lbq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3))))
    (home-page "https://actix.rs")
    (synopsis "Codec utilities for working with framed protocols")
    (description
     "This package provides codec utilities for working with framed
protocols.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-codec-0.2
  (package
    (inherit rust-actix-codec-0.3)
    (name "rust-actix-codec")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-codec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "100k0n155fnnjqjz2s1gnwim2fp7s1mw942x0famg89cbh55zr89"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.2))))))

(define-public rust-actix-codec-0.1
  (package
    (inherit rust-actix-codec-0.3)
    (name "rust-actix-codec")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-codec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lv42xf57y3kwy8nl2a9pkz35yvbspd9250virfr7p069fpi2b4z"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-tokio-codec" ,rust-tokio-codec-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1))))))

(define-public rust-actix-connect-2
  (package
    (name "rust-actix-connect")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-connect" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1p6hh5rj9zpx4wx0h87d56ahk68hmhpw2gmfsfl5pwb312hkfy0p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.14)
        ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.19)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.19)
        ("rust-webpki" ,rust-webpki-0.21))))
    (home-page "https://actix.rs")
    (synopsis "TCP connector service for Actix ecosystem")
    (description
     "This package provides a TCP connector service for Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-connect-1
  (package
    (inherit rust-actix-connect-2)
    (name "rust-actix-connect")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-connect" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0v77m394gzbrrzg12xkqgli11vwhig0zcxy3yhmq1s91j9bcjp69"))))
    (arguments
     ;; XXX: The crate fails to't build with: "error[E0432]: unresolved import
     ;; `trust_dns_resolver::Background`".  I assume it really expects
     ;; trust-dns-resolver at version 0.18-alpha.2, which we do not provide.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.18)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.18)
        ("rust-webpki" ,rust-webpki-0.21))
       #:cargo-development-inputs
       (("rust-actix-testing" ,rust-actix-testing-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-version-requirements
           (lambda _
             (substitute* "Cargo.toml"
               (("0.18.0-alpha.2")
                ,(package-version rust-trust-dns-proto-0.18)))
             #t)))))))

(define-public rust-actix-connect-0.2
  (package
    (inherit rust-actix-connect-2)
    (name "rust-actix-connect")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-connect" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "187whz05gjkp9pcza4i714v0a8yxlg3jdrzii7gaqsxl9fyykbcz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-actix-utils" ,rust-actix-utils-0.4)
        ("rust-derive-more" ,rust-derive-more-0.15)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-tokio-current-thread" ,rust-tokio-current-thread-0.1)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.3)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.9)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.11)
        ("rust-webpki" ,rust-webpki-0.19))
       #:cargo-development-inputs
       (("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-actix-test-server" ,rust-actix-test-server-0.2)
        ("rust-bytes" ,rust-bytes-0.4))))))

(define-public rust-actix-derive-0.5
  (package
    (name "rust-actix-derive")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k1kg4gkp2jhi5fgdfd0cq2qfbyy3gfgwqjrvzq1hzrjmynwwnmr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;bootsrapping issues with rust-actix
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       ;; #:cargo-development-inputs
       ;; (("rust-actix" ,rust-actix-0.8))
       ))
    (home-page "https://github.com/actix/actix-derive/")
    (synopsis "Proc macros for Actix Rust actor framework")
    (description
     "This package provides proc macros for the Rust actor framework Actix.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-derive-0.4
  (package
    (inherit rust-actix-derive-0.5)
    (name "rust-actix-derive")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0v0mvq883aq5z6d0893bh32bfddvfajh5bm7nkl0l8idpzbzdx8b"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-actix-http-2
  (package
    (name "rust-actix-http")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x78h9lzqdhp06v1kf4dhbiqp8sc911w4lqfj5rmdbhpg3l9j8j5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix" ,rust-actix-0.10)
        ("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-connect" ,rust-actix-connect-2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-2)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-brotli2" ,rust-brotli2-0.3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-cookie" ,rust-cookie-0.14)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-h2" ,rust-h2-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-pin-project" ,rust-pin-project-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.2))))
    (home-page "https://actix.rs")
    (synopsis "HTTP primitives for the Actix ecosystem")
    (description
     "This package provides HTTP primitives for the Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-http-1
  (package
    (inherit rust-actix-http-2)
    (name "rust-actix-http")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06chrs9asbxmxzgiw5sw7ky97yrin9g88nmd6w407a6y9z668rn1"))))
    ;; XXX: The crate fails to't build with with the same error as
    ;; rust-actix-connect.  Skip build for now.
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-connect" ,rust-actix-connect-1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-base64" ,rust-base64-0.11)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-brotli2" ,rust-brotli2-0.3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-h2" ,rust-h2-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-ring" ,rust-ring-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-sha1" ,rust-sha1-0.6)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.1))
       #:cargo-development-inputs
       (("rust-actix-http-test" ,rust-actix-http-test-1))))))

(define-public rust-actix-http-0.2
  (package
    (inherit rust-actix-http-2)
    (name "rust-actix-http")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fdi9pi33am22qbqni5dn2in11xfbchgsjnm9ws0s918rmvhzdgw"))))
    ;; XXX: The crate fails to't build without rust-actix-http-test-0.2 making
    ;; a circular dependency with rust-awc-0.2
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-actix-connect" ,rust-actix-connect-0.2)
        ("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.1)
        ("rust-actix-utils" ,rust-actix-utils-0.4)
        ("rust-base64" ,rust-base64-0.10)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-brotli2" ,rust-brotli2-0.3)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-derive-more" ,rust-derive-more-0.15)
        ("rust-either" ,rust-either-1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-h2" ,rust-h2-0.1)
        ("rust-hashbrown" ,rust-hashbrown-0.6)
        ("rust-http" ,rust-http-0.1)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-ring" ,rust-ring-0.14)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-sha1" ,rust-sha1-0.6)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio-current-thread" ,rust-tokio-current-thread-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.11)
        ("rust-webpki-roots" ,rust-webpki-roots-0.16))))))

(define-public rust-actix-http-test-1
  (package
    (name "rust-actix-http-test")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06z6iy9ffsjcw3g8zwwghky5zpyg7c1z823x35lgc4y1yjzxfizq"))))
    (build-system cargo-build-system)
    (arguments
     ;; XXX: The crate fails to't build with with the same error as
     ;; rust-actix-connect.  Skip build for now.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-connect" ,rust-actix-connect-1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-testing" ,rust-actix-testing-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-awc" ,rust-awc-1)
        ("rust-base64" ,rust-base64-0.11)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-sha1" ,rust-sha1-0.6)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.1))
       #:cargo-development-inputs
       (("rust-actix-http" ,rust-actix-http-1))))
    (home-page "https://actix.rs")
    (synopsis "Helpers for Actix applications to use during testing")
    (description
     "This package provides various helpers for Actix applications to use
during testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-http-test-0.2
  (package
    (inherit rust-actix-http-test-1)
    (name "rust-actix-http-test-2")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0m1ghgllf7ws5wk51x8phcdjq21phylawmvp7wb29zd1d0aw2aac"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-actix-connect" ,rust-actix-connect-0.2)
        ("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-server" ,rust-actix-server-0.6)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-actix-utils" ,rust-actix-utils-0.4)
        ("rust-awc" ,rust-awc-0.2)
        ("rust-base64" ,rust-base64-0.10)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-sha1" ,rust-sha1-0.6)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2))))))

(define-public rust-actix-macros-0.1
  (package
    (name "rust-actix-macros")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mfnprr8gy1gb5xcr18iwsv781hysvh7sr5xxg6ghyi61gh8rjml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://actix.rs")
    (synopsis "Actix runtime macros")
    (description "This package provides Actix runtime macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-router-0.2
  (package
    (name "rust-actix-router")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-router" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0df2626hk4n4yki6j88v3k0gcm8pi5hdnm1mldyvyi8nvbdzgldv"))))
    (build-system cargo-build-system)
    (arguments
     ;; Tests fail with "error[E0432]: unresolved import `serde_derive`".
     `(#:tests? #false
       #:cargo-inputs
       (("rust-bytestring" ,rust-bytestring-0.1)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://actix.rs")
    (synopsis "Resource path matching library")
    (description "This package provides resource path matching library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-router-0.1
  (package
    (inherit rust-actix-router-0.2)
    (name "rust-actix-router")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-router" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xyc0kzawfwjfiw4znb7xx6hh4r7nnwjq44i08fjc1724ysln8i3"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-http" ,rust-http-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-string" ,rust-string-0.2))))))

(define-public rust-actix-rt-1
  (package
    (name "rust-actix-rt")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-rt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09xj7pxy0ng13rd6hya1md98dhk0586p4bsfrwmxxlg028lwqgql"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://actix.rs")
    (synopsis "Actix runtime")
    (description "This package provides Actix runtime.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-rt-0.2
  (package
    (inherit rust-actix-rt-1)
    (name "rust-actix-rt")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-rt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13h9dph54lhxlzcz6wxmsv96qqpbh1dzr4365gn84gb00qfxmjc8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-actix-threadpool" ,rust-actix-threadpool-0.1)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-tokio-current-thread" ,rust-tokio-current-thread-0.1)
        ("rust-tokio-executor" ,rust-tokio-executor-0.1)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2))))))

(define-public rust-actix-server-1
  (package
    (name "rust-actix-server")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-server" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13khzd6pz9pqksxmw2syipfwq2gi5v9warx6pa24g8iccxp7wh25"))))
    (build-system cargo-build-system)
    (arguments
     ;; Tests fail with "error[E0432]: unresolved import `bytes`" error.
     `(#:tests? #false
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-uds" ,rust-mio-uds-0.6)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-socket2" ,rust-socket2-0.3))))
    (home-page "https://actix.rs")
    (synopsis "General purpose TCP server built for the Actix ecosystem")
    (description
     "This package provides a general purpose TCP server built for the Actix
ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-server-0.6
  (package
    (inherit rust-actix-server-1)
    (name "rust-actix-server")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-server" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19b2sl8dz01xfrynmf4iixq4a15g0gk1z43lby7762ldmws6aqnx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-uds" ,rust-mio-uds-0.6)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.3)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.9)
        ("rust-tokio-signal" ,rust-tokio-signal-0.2)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2)
        ("rust-tokio-uds" ,rust-tokio-uds-0.2)
        ("rust-webpki" ,rust-webpki-0.19)
        ("rust-webpki-roots" ,rust-webpki-roots-0.16))
       #:cargo-development-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-env-logger" ,rust-env-logger-0.6))))))

(define-public rust-actix-server-0.5
  (package
    (inherit rust-actix-server-1)
    (name "rust-actix-server")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-server" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fyxkkgm3cbyzxgx0qw86i1dq9hrr891n1c7mc7450n8arir735s"))))
    (arguments
     `(#:cargo-inputs
       (("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.3)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.9)
        ("rust-tokio-signal" ,rust-tokio-signal-0.2)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2)
        ("rust-webpki" ,rust-webpki-0.19)
        ("rust-webpki-roots" ,rust-webpki-roots-0.16))
       #:cargo-development-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-env-logger" ,rust-env-logger-0.6))))))

(define-public rust-actix-server-config-0.1
  (package
    (name "rust-actix-server-config")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-server-config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c7zp4l63n5skljbpq6j0a0avdjv6w067bdc5ca96bb8kjc38fj8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.3)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.9)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-uds" ,rust-tokio-uds-0.2))))
    (home-page "https://actix.rs")
    (synopsis "Actix server config utils")
    (description "Actix server config utils.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-service-1
  (package
    (name "rust-actix-service")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-service" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fw2b1cpxrpqk778mpvxv0cazj0pwjyb6khzs4syhnqvb1fl6lh0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-pin-project" ,rust-pin-project-0.4))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://actix.rs")
    (synopsis
     "Service trait and combinators for asynchronous request/response")
    (description
     "This package provides a service trait and combinators for representing
asynchronous request/response operations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-service-0.4
  (package
    (inherit rust-actix-service-1)
    (name "rust-actix-service")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-service" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gvpw11hcr1zmi5qzq3np6qzd0j51mdxn7yfgmzgyhc8ja7b99dw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-0.2))))))

(define-public rust-actix-testing-1
  (package
    (name "rust-actix-testing")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-testing" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "073r3rlnz9km7w7zfhpj6snb453hhp7d354adbp79awrhyirq8s7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-socket2" ,rust-socket2-0.3))))
    (home-page "https://actix.rs")
    (synopsis "Actix testing utils")
    (description "This package provides Actix testing utils.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-testing-0.1
  (package
    (inherit rust-actix-testing-1)
    (name "rust-actix-testing")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-testing" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w9p7wv2n2wda8ph3ahp8fqslmbh12vs206l4i49jl37mjbiw05g"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-server" ,rust-actix-server-0.6)
        ("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1))))))

(define-public rust-actix-test-server-0.2
  (package
    (name "rust-actix-test-server")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-test-server" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lqx8adsl3nlhbnvvjrmy9mkfa0d8wmwyy4gdz5ik8xhbwibxnn2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-server" ,rust-actix-server-0.5)
        ("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.9)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-webpki" ,rust-webpki-0.19)
        ("rust-webpki-roots" ,rust-webpki-roots-0.16))
       #:cargo-development-inputs
       (("rust-actix-service" ,rust-actix-service-0.4))))
    (home-page "https://actix.rs")
    (synopsis "Actix test server")
    (description "Actix test server.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-threadpool-0.3
  (package
    (name "rust-actix-threadpool")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-threadpool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c0frk19ml94d01mvgv5g60mhq86gfi34c3lsfpvjm18016z02fj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-threadpool" ,rust-threadpool-1))))
    (home-page "https://actix.rs")
    (synopsis "Actix thread pool for sync code")
    (description "This package provides Actix thread pool for sync code.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-threadpool-0.1
  (package
    (inherit rust-actix-threadpool-0.3)
    (name "rust-actix-threadpool")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-threadpool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pfk6k09cdw0w63wh8glqm6bvqz0hlqwhyqvdfw6yzns2dfyhnkb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-more" ,rust-derive-more-0.15)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-threadpool" ,rust-threadpool-1))))))

(define-public rust-actix-tls-2
  (package
    (name "rust-actix-tls")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yqmlyn02c72a1rrmjkfx5hnz286130y3sq4ll1mbkv1fdyrny14"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.14)
        ("rust-tokio-tls" ,rust-tokio-tls-0.3)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.20))))
    (home-page "https://actix.rs")
    (synopsis "TLS acceptor services for Actix ecosystem")
    (description
     "This package provides TLS acceptor services for Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-tls-1
  (package
    (inherit rust-actix-tls-2)
    (name "rust-actix-tls")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a4m96jz6vzmknpk5m803c337c6dillnqq4w71nrlphhmzxb9rd4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-tokio-tls" ,rust-tokio-tls-0.3)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))
       #:cargo-development-inputs
       (("rust-actix-testing" ,rust-actix-testing-1))))))

(define-public rust-actix-utils-2
  (package
    (name "rust-actix-utils")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nkby6wpwcmjr3zcghd962l2hyjry0aayncyjzbx2ck6qpg2541f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-either" ,rust-either-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-slab" ,rust-slab-0.4))))
    (home-page "https://actix.rs")
    (synopsis "Network related services and utilities for the Actix ecosystem")
    (description
     "This package provides various network related services and utilities for
the Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-utils-1
  (package
    (inherit rust-actix-utils-2)
    (name "rust-actix-utils")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kkz2hfz8r2k1gxcjk2qq1h1qxlb487g023q4v1dw6ph3dizby7w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-slab" ,rust-slab-0.4))))))

(define-public rust-actix-utils-0.4
  (package
    (inherit rust-actix-utils-2)
    (name "rust-actix-utils")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15bv06z7pccnmh067l5zj0fvpmfagnil7lvznnl3fp4gjh4k334h"))))
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-tokio-current-thread" ,rust-tokio-current-thread-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-0.2))))))

(define-public rust-actix-web-3
  (package
    (name "rust-actix-web")
    (version "3.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11kv8y1p9dw78lnhrw3rqavhmazmy7s0z8j14a3a1yp7fahx8hg6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-http" ,rust-actix-http-2)
        ("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-router" ,rust-actix-router-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-testing" ,rust-actix-testing-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-2)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-actix-web-codegen" ,rust-actix-web-codegen-0.4)
        ("rust-awc" ,rust-awc-2)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-pin-project" ,rust-pin-project-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-time" ,rust-time-0.2)
        ("rust-tinyvec" ,rust-tinyvec-1)
        ("rust-url" ,rust-url-2))))
    (home-page "https://actix.rs")
    (synopsis "Powerful, pragmatic, and fast web framework for Rust")
    (description
     "Actix Web is a powerful, pragmatic, and fast web framework for
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-web-2
  (package
    (inherit rust-actix-web-3)
    (name "rust-actix-web")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dgnn7xiw2yhvrx7l7b57gwra7yfqawka5xz1lpq4h0h8qifhn1i"))))
    (arguments
     ;; XXX: The crate fails to't build with with the same error as
     ;; rust-actix-connect.  Skip build for now.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-http" ,rust-actix-http-1)
        ("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-router" ,rust-actix-router-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-testing" ,rust-actix-testing-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-actix-web-codegen" ,rust-actix-web-codegen-0.2)
        ("rust-awc" ,rust-awc-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-2))))))

(define-public rust-actix-web-1
  (package
    (inherit rust-actix-web-3)
    (name "rust-actix-web")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00wvayn7v2s61hylisr53f48s2bzg8jp3bmrqh1vkb6vgjb1nfmg"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-actix-http" ,rust-actix-http-0.2)
        ("rust-actix-router" ,rust-actix-router-0.1)
        ("rust-actix-rt" ,rust-actix-rt-0.2)
        ("rust-actix-server" ,rust-actix-server-0.6)
        ("rust-actix-server-config" ,rust-actix-server-config-0.1)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-actix-testing" ,rust-actix-testing-0.1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.1)
        ("rust-actix-utils" ,rust-actix-utils-0.4)
        ("rust-actix-web-codegen" ,rust-actix-web-codegen-0.1)
        ("rust-awc" ,rust-awc-0.2)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-derive-more" ,rust-derive-more-0.15)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-hashbrown" ,rust-hashbrown-0.6)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-actix" ,rust-actix-0.8)
        ("rust-actix-connect" ,rust-actix-connect-0.2)
        ("rust-actix-http-test" ,rust-actix-http-test-0.2)
        ("rust-brotli2" ,rust-brotli2-0.3)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2))))))

(define-public rust-actix-web-codegen-0.4
  (package
    (name "rust-actix-web-codegen")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ys3f6q0hgflqvp271s49q88m41db3iynm7ydxy0wgikjdqgf9md"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://actix.rs")
    (synopsis "Actix web proc macros")
    (description "This package provides Actix web proc macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-web-codegen-0.2
  (package
    (inherit rust-actix-web-codegen-0.4)
    (name "rust-actix-web-codegen")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rjpzwsm51nfjqsz269jwbkiic9d454bnsk9ng882wp0rdsz86x7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-web" ,rust-actix-web-2))))))

(define-public rust-actix-web-codegen-0.1
  (package
    (inherit rust-actix-web-codegen-0.4)
    (name "rust-actix-web-codegen")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1frs0id6k1vjczhnfhwh8q8birp27imlvgi6jylfxh911r9372h6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-actix-http" ,rust-actix-http-0.2)
        ("rust-actix-http-test" ,rust-actix-http-test-0.2)
        ("rust-actix-web" ,rust-actix-web-1)
        ("rust-futures" ,rust-futures-0.1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))))

(define-public rust-adaptive-barrier-0.1
  (package
    (name "rust-adaptive-barrier")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adaptive-barrier" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "003ygsiqsd85v0p846q1ym23dbp4iagn89p7k6yrvbg9di1mbjqc"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/vorner/adaptive-barrier")
    (synopsis "Barrier with adaptable number of thread subsciptions")
    (description
     "This is a Barrier synchronization primitive, similar to
@code{std::sync::Barrier}, but one that adjusts the expected number of
threads.  This makes it robust in face of panics (it won't make your program
deadlock, like the standard Barrier).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-adblock-0.4
  (package
    (name "rust-adblock")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/brave/adblock-rust")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (patches (search-patches "rust-adblock-ignore-live-tests.patch"))
       (sha256
        (base32
         "0l2iacwkm66z6wc71wy62x2k5xllx94adrqncicxqsx203c3ljpl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-addr" ,rust-addr-0.14)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-cssparser" ,rust-cssparser-0.25)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-idna" ,rust-idna-0.2)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lifeguard" ,rust-lifeguard-0.6)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-percent-encoding"
         ,rust-percent-encoding-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-rmp-serde" ,rust-rmp-serde-0.13)
        ("rust-rmp-serde" ,rust-rmp-serde-0.15)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-selectors" ,rust-selectors-0.21)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-twoway" ,rust-twoway-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-csv" ,rust-csv-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-tokio" ,rust-tokio-1.8))))
    (native-inputs (list pkg-config openssl))
    (home-page "https://github.com/brave/adblock-rust/")
    (synopsis "Adblock Plus syntax filter parsing and matching")
    (description "This package provides native Rust module for Adblock Plus
syntax (e.g.  EasyList, EasyPrivacy) filter parsing and matching.")
    (license license:mpl2.0)))

(define-public rust-addr2line-0.17
  (package
    (name "rust-addr2line")
    (version "0.17.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "addr2line" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0sw16zqy6w0ar633z69m7lw6gb0k1y7xj3387a8wly43ij5div5r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false ;use of undeclared crate or module `auxiliary`
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.3)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-gimli" ,rust-gimli-0.26)
        ("rust-object" ,rust-object-0.27)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-smallvec" ,rust-smallvec-1))
       #:cargo-development-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-clap" ,rust-clap-2)
        ("rust-findshlibs" ,rust-findshlibs-0.10)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-typed-arena" ,rust-typed-arena-2))))
    (home-page "https://github.com/gimli-rs/addr2line")
    (synopsis "Symbolication library written in Rust, using gimli")
    (description
     "This package provides a cross-platform symbolication library written in
Rust, using gimli.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-addr-0.14
  (package
    (name "rust-addr")
    (version "0.14.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "addr" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "0w6v0wwv203v0lyvwsq27rwfhvmw7dsmrqc9r3gszbx2974wlk65"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-no-std-net" ,rust-no-std-net-0.5)
         ("rust-psl" ,rust-psl-2)
         ("rust-psl-types" ,rust-psl-types-2)
         ("rust-publicsuffix" ,rust-publicsuffix-2)
         ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/addr-rs/addr")
    (synopsis "Parsing domain names")
    (description "This package provides a library for parsing domain names.")
    (license (list license:expat license:asl2.0))))

(define-public rust-adler-1
  (package
    (name "rust-adler")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adler" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zim79cvzd5yrkzl3nyfx0avijwgk9fqv3yrscdy1cc79ih02qpj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/jonas-schievink/adler")
    (synopsis "Implementation of the Adler-32 checksum")
    (description
     "This crate provides a simple implementation of the Adler-32
checksum, used in the zlib compression format.")
    (license
     (list license:expat
           license:asl2.0
           (license:non-copyleft "https://spdx.org/licenses/0BSD.html")))))

(define-public rust-adler-0.2
  (package
    (inherit rust-adler-1)
    (name "rust-adler")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adler" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zpdsrfq5bd34941gmrlamnzjfbsx0x586afb7b0jqhr8g1lwapf"))))
    (build-system cargo-build-system)))

(define-public rust-adler32-1
  (package
    (name "rust-adler32")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "adler32" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0d7jq7jsjyhsgbhnfq5fvrlh9j0i9g1fqrl2735ibv5f75yjgqda"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-getrandom" ,rust-getrandom-0.1)
        ("rust-humansize" ,rust-humansize-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/remram44/adler32-rs")
    (synopsis "Implementation of the Adler32 rolling hash algorithm")
    (description
     "This library is an implementation of the Adler32 rolling hash algorithm in
the Rust programming language.")
    (license (list license:bsd-3
                   license:zlib))))

(define-public rust-aead-0.4
  (package
    (name "rust-aead-4")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aead" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xw8kp9j1whfdxhgmr2qf9xgslkg52zh6gzmhsh13y9w3s73nq8b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.3)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-heapless" ,rust-heapless-0.7)
        ("rust-rand-core" ,rust-rand-core-0.6))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis
     "Traits for Authenticated Encryption with Associated Data (AEAD) algorithms")
    (description
     "This package provides traits for Authenticated Encryption with Associated
Data (AEAD) algorithms, such as AES-GCM as ChaCha20Poly1305, which provide a
high-level API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aead-0.3
  (package
    (name "rust-aead")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aead" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c8388alvivcj4qkxgh4s4l6fbczn3p8wc0pnar6crlfvcdmvjbz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.3)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-heapless" ,rust-heapless-0.5))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for Authenticated Encryption with Associated Data (AEAD)
algorithms")
    (description "This package provides traits for Authenticated Encryption
with Associated Data (AEAD) algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aead-0.2
  (package
    (inherit rust-aead-0.3)
    (name "rust-aead")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aead" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r3ijikx9h117q0xgkc56yb0501kifjr3gsfp5bvnrz7asdipw2c"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.12)
        ("rust-heapless" ,rust-heapless-0.5))))))

(define-public rust-aes-0.7
  (package
    (name "rust-aes")
    (version "0.7.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f0sdx2fsa8w3l7xzsyi9ry3shvnnsgc0znh50if9fm95vslg2wy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cipher" ,rust-cipher-0.3)
        ("rust-cpufeatures" ,rust-cpufeatures-0.2)
        ("rust-ctr" ,rust-ctr-0.8)
        ("rust-opaque-debug" ,rust-opaque-debug-0.3))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Facade for AES (Rijndael) block ciphers implementations")
    (description "This package provides a facade for AES (Rijndael) block
ciphers implementations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aes-0.6
  (package
    (inherit rust-aes-0.7)
    (name "rust-aes")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q85mw70mgr4glza9y9lrs9nxfa1cdcqzfk6wx0smb3623pr2hw8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-aes-soft" ,rust-aes-soft-0.6)
        ("rust-aesni" ,rust-aesni-0.10)
        ("rust-cipher" ,rust-cipher-0.2))
       #:cargo-development-inputs
       (("rust-cipher" ,rust-cipher-0.2))))))

(define-public rust-aes-0.4
  (package
    (inherit rust-aes-0.6)
    (name "rust-aes")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xgsp2bn5llsppald60iw4497gaspslg0a8hknhniiz4zmki607p"))))
    (arguments
     `(#:cargo-inputs
       (("rust-aes-soft" ,rust-aes-soft-0.4)
        ("rust-aesni" ,rust-aesni-0.7)
        ("rust-block-cipher" ,rust-block-cipher-0.7))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7))))))

(define-public rust-aes-0.3
  (package
    (inherit rust-aes-0.4)
    (name "rust-aes")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j90iwpax0y1dqq14i8y9xgpcnnlgnljwkxg3mhzrralwf7ivssl"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aes-soft" ,rust-aes-soft-0.3)
        ("rust-aesni" ,rust-aesni-0.6)
        ("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6))))))

(define-public rust-aes-gcm-0.8
  (package
    (name "rust-aes-gcm")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-gcm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nl8iwlh209y1vj9n2lm1a70i69clvg2z6x69bi4dgdrpgxbay2j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aead" ,rust-aead-0.3)
        ("rust-aes" ,rust-aes-0.6)
        ("rust-cipher" ,rust-cipher-0.2)
        ("rust-ctr" ,rust-ctr-0.6)
        ("rust-ghash" ,rust-ghash-0.3)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/RustCrypto/AEADs")
    (synopsis "AES-GCM (Galois/Counter Mode) Authenticated Encryption")
    (description "This package provides a pure Rust implementation of the
AES-GCM (Galois/Counter Mode) Authenticated Encryption with Associated
Data (AEAD) Cipher with optional architecture-specific hardware
acceleration.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-aes-gcm-0.6
  (package
    (inherit rust-aes-gcm-0.8)
    (name "rust-aes-gcm")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-gcm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lga8my3zlc0b1nhcpc1hrbykfm014fqs6d64bwrjqii05w01xc6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-aead" ,rust-aead-0.3)
        ("rust-aes" ,rust-aes-0.4)
        ("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-ghash" ,rust-ghash-0.3)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-criterion-cycles-per-byte"
         ,rust-criterion-cycles-per-byte-0.1)
        ("rust-hex-literal" ,rust-hex-literal-0.2))))))

(define-public rust-aes-gcm-0.5
  (package
    (inherit rust-aes-gcm-0.6)
    (name "rust-aes-gcm")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-gcm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f66b5bmyj38r1hj55wzamlzw3y1aql34lgwr2vxn93073d6njl3"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aead" ,rust-aead-0.2)
        ("rust-aes" ,rust-aes-0.3)
        ("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6)
        ("rust-ghash" ,rust-ghash-0.2)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))))))

(define-public rust-aes-soft-0.6
  (package
    (name "rust-aes-soft")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-soft" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wj0fi2pvmlw09yvb1aqf0mfkzrfxmjsf90finijh255ir4wf55y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Bit-sliced implementation of AES (Rijndael) block ciphers")
    (description "This package provides a bit-sliced implementation of
AES (Rijndael) block ciphers.

This package is deprecated and was replaced by the @code{aes} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aes-soft-0.4
  (package
    (inherit rust-aes-soft-0.6)
    (name "rust-aes-soft")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-soft" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19szsg0qqxq42k7bj5p3svb147n8wxy9a20n4g7mcl2fwrz689a9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7))))))

(define-public rust-aes-soft-0.3
  (package
    (inherit rust-aes-soft-0.4)
    (name "rust-aes-soft")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-soft" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "039si7yjp0wcd750sgq52c60sh2ikaxwd7rq7g0ba7ws7ypfgmyg"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))))))

(define-public rust-aesni-0.10
  (package
    (name "rust-aesni")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aesni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kmh07fp9hbi1aa8dr2rybbgw8vqz6hjmk34c4w7sbscx7si2bpa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cipher" ,rust-cipher-0.2)
        ("rust-opaque-debug" ,rust-opaque-debug-0.3))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "AES (Rijndael) block ciphers implementation using AES-NI")
    (description "This package provides an implementation of AES (Rijndael)
block ciphers using AES-NI.

This package is deprecated and was replaced by the @code{aes} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aesni-0.7
  (package
    (inherit rust-aesni-0.10)
    (name "rust-aesni")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aesni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0r6j0mjkyqnwvgib01cvrwfw8rlx1biw75234niv723n1fdx6l6h"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2)
        ("rust-stream-cipher" ,rust-stream-cipher-0.4))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-stream-cipher" ,rust-stream-cipher-0.4))))))

(define-public rust-aesni-0.6
  (package
    (inherit rust-aesni-0.7)
    (name "rust-aesni")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aesni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "007imgcfl82nilfpamj5dik83pkcmkzvbkxp384p7r3iz6sscw1g"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2)
        ("rust-stream-cipher" ,rust-stream-cipher-0.3))))))

(define-public rust-afl-0.8
  (package
    (name "rust-afl")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "afl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rw11hycfjhqbc7z1smn75m0sczq519msjwimxh7b8s6n4pzk5r7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-xdg" ,rust-xdg-2))))
    (home-page "https://github.com/rust-fuzz/afl.rs")
    (synopsis
     "Fuzzing Rust code with american-fuzzy-lop")
    (description
     "Fuzz Rust code with american-fuzzy-lop.")
    (license license:asl2.0)))

(define-public rust-ahash-0.7
  (package
    (name "rust-ahash")
    (version "0.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "163vy6jcd7r3jczsv4zyhlc5x9dqsfgg1yrqbm3xhygr1czq7fs3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/tkaitchuck/ahash")
    (synopsis "Non-cryptographic hash function using AES-NI")
    (description "This package provides a non-cryptographic hash function
using AES-NI for high performance.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ahash-0.4
  (package
    (inherit rust-ahash-0.7)
    (name "rust-ahash")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06bxygcis4pfx0axi1ld0lclg8mf4plywdy7fnkyw2hrhcb74rkd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-ahash-0.3
  (package
    (inherit rust-ahash-0.4)
    (name "rust-ahash")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05qjnr0wccch0gg2kghg0xyh8qd5gfqd15q9dd6r1lamcs375zg8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-ahash-0.2
  (package
    (inherit rust-ahash-0.4)
    (name "rust-ahash")
    (version "0.2.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yzdrxaq99zfy0niq5i3cz5jv569s3s6z5q2cxcg08y6prh1nri9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-aho-corasick-0.7
  (package
    (name "rust-aho-corasick")
    (version "0.7.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aho-corasick" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vv50b3nvkhyy7x7ip19qnsq11bqlnffkmj2yx2xlyk5wzawydqy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3))))
    (home-page "https://github.com/BurntSushi/aho-corasick")
    (synopsis "Fast multiple substring searching")
    (description "This package provides a fast multiple substring searching.")
    (license (list license:unlicense license:expat))))

(define-public rust-aho-corasick-0.6
  (package
    (inherit rust-aho-corasick-0.7)
    (name "rust-aho-corasick")
    (version "0.6.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "aho-corasick" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19f8v503ibvlyr824g5ynicrh1lsmp2i0zmpszr8lqay0qw3vkl1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-csv" ,rust-csv-1)
        ("rust-docopt" ,rust-docopt-1)
        ("rust-memmap" ,rust-memmap-0.6)
        ("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))))

(define-public rust-aho-corasick-0.5
  (package
    (inherit rust-aho-corasick-0.6)
    (name "rust-aho-corasick")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aho-corasick" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rnvdmlajikq0i4zdy1p3pv699q6apvsxfc7av7byhppllp2r5ya"))))
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-0.1))
       #:cargo-development-inputs
       (("rust-csv" ,rust-csv-0.14)
        ("rust-docopt" ,rust-docopt-0.6)
        ("rust-memmap" ,rust-memmap-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))))

(define-public rust-alacritty-config-derive-0.1
  (package
    (name "rust-alacritty-config-derive")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alacritty_config_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dn3cg233jyi06xz8q1vfgjikdpcjdid36kqnl0yawdqpm2lq13p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/alacritty/alacritty")
    (synopsis "Failure resistant deserialization derive")
    (description
     "This package provides a failure resistant deserialization derive.")
    (license (list license:expat license:asl2.0))))

(define-public rust-alacritty-terminal-0.15
  (package
    (name "rust-alacritty-terminal")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alacritty_terminal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qv8zv20qgn407v8m196p68yddvhalcppc21702698cj99b45ckc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-alacritty-config-derive" ,rust-alacritty-config-derive-0.1)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-dirs" ,rust-dirs-2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-anonymous-pipes" ,rust-mio-anonymous-pipes-0.2)
        ("rust-mio-extras" ,rust-mio-extras-2)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-nix" ,rust-nix-0.23)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-regex-automata" ,rust-regex-automata-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-vte" ,rust-vte-0.10)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/alacritty/alacritty")
    (synopsis "Library for writing terminal emulators")
    (description
     "This package provides a library for writing terminal emulators.")
    (license license:asl2.0)))

(define-public rust-alga-0.9
  (package
    (name "rust-alga")
    (version "0.9.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "alga" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wl4z8ini9269x04g8wwdz1nn3hmmvaaysq4jwhymikyg81kv0jg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-decimal" ,rust-decimal-2)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-alga-derive" ,rust-alga-derive-0.9)
        ("rust-quickcheck" ,rust-quickcheck-0.8))))
    (home-page "https://github.com/rustsim/alga")
    (synopsis "Abstract algebra for Rust")
    (description "Alga aims to provide solid mathematical abstractions to
algebra-focused applications.  It defines and organizes through trait
inheritance the basic building blocks of general algebraic structures.
Specific implementations of algebraic structure traits are left to other
crates.  Higher-level traits for specialized domains of algebra (like linear
algebra) are also provided and will prove useful for applications that include
code that is generic with regard to the algebraic entity types.")
    (license license:asl2.0)))

(define-public rust-alga-derive-0.9
  (package
    (name "rust-alga-derive")
    (version "0.9.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "alga-derive" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0a2594j6blczz18vfg85agr7vsjrbq6900d3xwxw0zzbqj9j2adz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-edit-distance" ,rust-edit-distance-2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rustsim/alga")
    (synopsis "Dutomatic deriving of abstract algebra traits")
    (description "Derive attribute for implementing algebraic traits from the
@code{alga} crate.")
    (license license:asl2.0)))

(define-public rust-aliasable-deref-trait-0.2
  (package
    (name "rust-aliasable-deref-trait")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aliasable_deref_trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0abzqsxd09jxl01brzjnwk8zg7k8zma76gzq87385q8fqm710jxb"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/avitex/rust-aliasable-deref-trait")
    (synopsis "Marker trait for aliasable pointers")
    (description
     "This package provides a marker trait for types that deref to an
address that is aliasable when coerced to a raw pointer")
    (license license:expat)))

(define-public rust-aliasable-0.1
  (package
    (name "rust-aliasable")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "aliasable" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1z8548zdjlm4ps1k0d7x68lfdyji02crwcc9rw3q3bb106f643r5"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-aliasable-deref-trait" ,rust-aliasable-deref-trait-0.2)
         ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/avitex/rust-aliasable")
    (synopsis "Basic aliasable (non unique pointer) types")
    (description
     "Rust library providing basic aliasable (non @code{core::ptr::Unique})
types.")
    (license license:expat)))

(define-public rust-alloc-no-stdlib-2
  (package
    (name "rust-alloc-no-stdlib")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-no-stdlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19lhmi73fii1b6vrzh23vvp5yjqm33cb94h9yz17pn25b51yr4ji"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dropbox/rust-alloc-no-stdlib")
    (synopsis "Dynamic allocator that may be used with or without the stdlib")
    (description "This package provides a dynamic allocator that may be used
with or without the stdlib.  This allows a package with nostd to allocate
memory dynamically and be used either with a custom allocator, items on the
stack, or by a package that wishes to simply use Box<>.  It also provides
options to use calloc or a mutable global variable for pre-zeroed memory.")
    (license license:bsd-3)))

(define-public rust-alloc-stdlib-0.2
  (package
    (name "rust-alloc-stdlib")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-stdlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1hj3r1x88aajnvigdck0diygj2isc90wa271kkj1swgiq3nxfzk9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2))))
    (home-page "https://github.com/dropbox/rust-alloc-no-stdlib")
    (synopsis "Dynamic allocator example that may be used with the stdlib")
    (description "This package provides a dynamic allocator example that may
be used with the stdlib.")
    (license license:bsd-3)))

(define-public rust-always-assert-0.1
  (package
    (name "rust-always-assert")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "always-assert" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04ad9wbh70nii1ilcd1mxv85yqx18jf9vsmh3ddps886bmi8ixpv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-log" ,rust-log-0.4))))
    (home-page
     "https://github.com/matklad/always-assert")
    (synopsis
     "Recoverable assertions for long-running robust applications")
    (description
     "This package provides a recoverable assertions for long-running robust
applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-glue-0.2
  (package
    (name "rust-android-glue")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android-glue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "01y495x4i9vqkwmklwn2xk7sqg666az2axjcpkr4iwngdwi48100"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tomaka/android-rs-glue")
    (synopsis "Glue for the Android JNI")
    (description "This package provides the glue for the Android JNI.")
    (license license:expat)))

(define-public rust-android-log-sys-0.2
  (package
    (name "rust-android-log-sys")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_log-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bhhs1cgzp9vzjvkn2q31ppc7w4am5s273hkvl5iac5475kmp5l5"))))
    (arguments `(#:skip-build? #true))  ;XXX: Android only
    (build-system cargo-build-system)
    (home-page "https://github.com/nercury/android_log-sys-rs")
    (synopsis "FFI bindings to Android log Library")
    (description "This package provides FFI bindings to Android log Library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-log-sys-0.1
  (package
    (inherit rust-android-log-sys-0.2)
    (name "rust-android-log-sys")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_log-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0klq7cp4lm74gjf9p12zdjcr159blbicrfvadmaqvfxbi8njw1dq"))))
    (arguments `(#:skip-build? #true)))) ;XXX: Android only

(define-public rust-android-logger-0.10
  (package
    (name "rust-android-logger")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rigzgkaik2y7pvsilpjdy19mdq1kkamw2rdf9fjkvb5hfqhkvfr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-android-log-sys" ,rust-android-log-sys-0.2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/Nercury/android_logger-rs")
    (synopsis "Logging implementation for @code{log}")
    (description
     "This library is a drop-in replacement for @code{env_logger}.  Instead,
it outputs messages to Android's logcat.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-logger-0.8
  (package
    (inherit rust-android-logger-0.10)
    (name "rust-android-logger")
    (version "0.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kj8i03fqqwxd803hrk27j2399v27ajjj9zxi2nnyml0s4nm9gcc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-android-log-sys" ,rust-android-log-sys-0.1)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4))))))

(define-public rust-ansi-parser-0.6
  (package
    (name "rust-ansi-parser")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-parser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "152idb8a6gwdxzj6m099h3xgx8vw0sjc6skgw94nm2k3y5swc6kn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-heapless" ,rust-heapless-0.5)
        ("rust-nom" ,rust-nom-4))))
    (home-page "https://gitlab.com/DavidBittner/ansi-parser")
    (synopsis "Library using nom for parsing ANSI escape codes")
    (description
     "This package provides a library using nom for parsing ANSI
escape codes.")
    (license license:mpl2.0)))

(define-public rust-antidote-1
  (package
    (name "rust-antidote")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "antidote" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19g2sw2qa2ibnh4x7j1snk46593jgx6y7rnvva496ynq61af5z9l"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-antidote")
    (synopsis "Poison-free Mutex and RwLock types")
    (description
     "These types expose identical APIs to the standard library @code{Mutex} and
@code{RwLock} except that they do not return @code{PoisonError}s.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-anyhow-1
  (package
    (name "rust-anyhow")
    (version "1.0.65")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anyhow" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00jnbylbji1wxvgpk6fcpcxyh4firn223w0lpdvxm1117r71l5lq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/anyhow")
    (synopsis "Flexible concrete Error type")
    (description "This package provides a flexible concrete Error type built on
@code{std::error::Error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anymap-0.12
  (package
    (name "rust-anymap")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anymap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0i23vv38i22aazp5z2hz0a44b943b6w5121kwwnpq1brpm1l559k"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page
     "https://github.com/chris-morgan/anymap")
    (synopsis
     "Safe and convenient store for one value of each type")
    (description
     "This package provides a safe and convenient store for one value of each
type.")
    (license (list license:expat license:asl2.0))))

(define-public rust-app-dirs2-2
  (package
    (name "rust-app-dirs2")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "app_dirs2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04v2q3jkqr32mwqs4niqfyhbkvvgrcsw0dajwqaz83nc5hs1igsm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jni" ,rust-jni-0.18)
        ("rust-ndk-glue" ,rust-ndk-glue-0.2)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-test-case" ,rust-test-case-1))))
    (home-page "https://lib.rs/app_dirs2")
    (synopsis "Put app's data in the right place on every platform")
    (description
     "This package helps you to put your app's data in the right place
on every platform.")
    (license license:expat)))

(define-public rust-approx-0.5
  (package
    (name "rust-approx")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17p9g3yl061zdlrqj10npybmng81jz71dzmcanmjgcb35qhgfb87"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/brendanzab/approx")
    (synopsis "Approximate floating point equality comparisons and assertions")
    (description
     "This crate provides facilities for testing the approximate equality of
floating-point based types, using either relative difference, or units in the
last place (ULPs) comparisons.")
    (license license:asl2.0)))

(define-public rust-approx-0.4
  (package
    (name "rust-approx")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0y52dg58lapl4pp1kqlznfw1blbki0nx6b0aw8kja2yi3gyhaaiz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/brendanzab/approx")
    (synopsis "Approximate floating point equality comparisons and assertions")
    (description
     "This crate provides facilities for testing the approximate equality of
floating-point based types, using either relative difference, or units in the
last place (ULPs) comparisons.")
    (license license:asl2.0)))

(define-public rust-approx-0.3
  (package
    (inherit rust-approx-0.4)
    (name "rust-approx")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1hx580xjdxl3766js9b49rnbnmr8gw8c060809l43k9f0xshprph"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))))))

(define-public rust-approx-0.1
  (package
    (inherit rust-approx-0.3)
    (name "rust-approx")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "153awzwywmb61xg857b80l63b1x6hifx2pha7lxf6fck9qxwraq8"))))
    (arguments '())))

(define-public rust-arbitrary-1
  (package
    (name "rust-arbitrary")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14a6r7q9b1kf1m7810p8bcl51q11mrwc5z7fjkz0lx6kdvyk0x13"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-arbitrary" ,rust-derive-arbitrary-1))))
    (home-page "https://github.com/rust-fuzz/arbitrary")
    (synopsis "Trait for generating structured data from unstructured data")
    (description
     "The @code{Arbitrary} crate lets you construct arbitrary instance of
a type.

This crate is primarily intended to be combined with a fuzzer like
@code{libFuzzer} and @code{cargo-fuzz} or AFL, and to help you turn the raw,
untyped byte buffers that they produce into well-typed, valid, structured
values.  This allows you to combine structure-aware test case generation with
coverage-guided, mutation-based fuzzers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arbitrary-0.4
  (package/inherit rust-arbitrary-1
    (name "rust-arbitrary")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sa55cynafwzvlhyhfpm3vmi2fydj3ipdj5yfbaif7l56cixfmfv"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-arbitrary" ,rust-derive-arbitrary-0.4))))))

(define-public rust-arboard-1
  (package
    (name "rust-arboard")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arboard" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a5qfmpzcf5rwlwsligf9z1gzndpvj0jncc4s3k3z5g214c4l127"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-clipboard-win" ,rust-clipboard-win-4)
        ("rust-core-graphics" ,rust-core-graphics-0.21)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-image" ,rust-image-0.23)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-foundation" ,rust-objc-foundation-0.1)
        ("rust-objc-id" ,rust-objc-id-0.1)
        ("rust-scopeguard" ,rust-scopeguard-1)
        ("rust-simple-logger" ,rust-simple-logger-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-wl-clipboard-rs" ,rust-wl-clipboard-rs-0.4)
        ("rust-x11rb" ,rust-x11rb-0.8))))
    (home-page "https://github.com/ArturKovacs/arboard")
    (synopsis "Image and text handling for the OS clipboard")
    (description
     "This package provides image and text handling for the OS clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arc-swap-1
  (package
    (name "rust-arc-swap")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arc-swap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wwdvayqa07grw4ljvb6plbw0wdg78jcdg3hwnlq2yqljlrxdmyl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-adaptive-barrier" ,rust-adaptive-barrier-0.1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-proptest" ,rust-proptest-0.10))))
    (home-page "https://github.com/vorner/arc-swap")
    (synopsis "Atomically swappable Arc")
    (description "This package provides an atomically swappable Arc.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-arc-swap-0.4
  (package
    (inherit rust-arc-swap-1)
    (name "rust-arc-swap")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arc-swap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zwswfi9n7n3hiq51w1xv34572k2diazx680rrxlc9w07c9akf6p"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-itertools" ,rust-itertools-0.8)
        ("rust-model" ,rust-model-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-proptest" ,rust-proptest-0.8)
        ("rust-version-sync" ,rust-version-sync-0.8))))))

(define-public rust-arg-enum-proc-macro-0.3
  (package
    (name "rust-arg-enum-proc-macro")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "arg_enum_proc_macro" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "021rr6j3n031ynfbm7kwb3j3bxvbsz40n0nqi78k47d3p92rihcv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/lu-zero/arg_enum_proc_macro")
    (synopsis "Procedural macro compatible with clap arg_enum")
    (description
     "This package provides a procedural macro compatible with clap's
@code{arg_enum}.")
    (license license:expat)))

(define-public rust-argh-shared-0.1
  (package
    (name "rust-argh-shared")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "argh_shared" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0crzkzr4mq9gyys3m0idgsfwwrwd4dk70scp7rspvb2fmgd01piq"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/google/argh")
    (synopsis "Derive-based argument parsing optimized for code size")
    (description "Derive-based argument parsing optimized for code size")
    (license license:bsd-3)))

(define-public rust-argh-derive-0.1
  (package
    (name "rust-argh-derive")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "argh_derive" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "13qz9i9frdjl1v9aqw5b2cs7wn3h34x2xkpsi9wcl1hcpjd23ba8"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build?
        #t
        #:cargo-inputs
        (("rust-argh-shared" ,rust-argh-shared-0.1)
         ("rust-heck" ,rust-heck-0.3)
         ("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/google/argh")
    (synopsis "Derive-based argument parsing optimized for code size")
    (description "Derive-based argument parsing optimized for code size")
    (license license:bsd-3)))

(define-public rust-argh-0.1
  (package
    (name "rust-argh")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "argh" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1gy9y69d38q7f5147kj823swgggc3m30x7z2z1lrjpwpsxncf8zh"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-argh-derive" ,rust-argh-derive-0.1)
         ("rust-argh-shared" ,rust-argh-shared-0.1))))
    (home-page "https://github.com/google/argh")
    (synopsis "Derive-based argument parser optimized for code size")
    (description "Derive-based argument parser optimized for code size")
    (license license:bsd-3)))

(define-public rust-arr-macro-impl-0.1
  (package
    (name "rust-arr-macro-impl")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "arr_macro_impl" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1lbjilz3pvwav72dfkcbz99rsq7m04xbdpqh8g3yvx3jsn5wf286"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/JoshMcguigan/arr_macro")
    (synopsis "Private impl crate for arr_macro")
    (description "This package provides a private @code{impl} crate for
@code{arr_macro}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arr-macro-0.1
  (package
    (name "rust-arr-macro")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "arr_macro" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "199086q8zva66lbg9bpz6fa67s81ra7yfa8148cwy1w7lkymn43a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arr-macro-impl" ,rust-arr-macro-impl-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/JoshMcguigan/arr_macro")
    (synopsis "Initialize arrays with ease")
    (description "Array macro helps initialize arrays. It is useful when
initializing large arrays (greater than 32 elements), or arrays of types which
do not implement the copy or default traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-array-macro-1
  (package
    (name "rust-array-macro")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "array-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19mdx2xlppnqwl6rhsbzylx61a0kkp2ql8q16195b7iga977ps86"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://gitlab.com/KonradBorowski/array-macro")
    (synopsis "Array multiple elements constructor syntax")
    (description "This package implements constructor syntax for arrays with
multiple elements.")
    (license (list license:expat license:asl2.0))))

(define-public rust-array-ops-0.1
  (package
    (name "rust-array-ops")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "array-ops" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jn7l9gppp6kr9kgsy22sw5p9cn1jazmqxy296gjwiwz5d11i4fc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rand-core" ,rust-rand-core-0.5)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4))))
    (home-page "https://github.com/bodil/array-ops")
    (synopsis "Automatic method implementations for array data types")
    (description "This package provides a number of traits with default
implementations for most of the standard library's methods on array like data
structures.")
    (license license:mpl2.0)))

(define-public rust-arrayref-0.3
  (package
    (name "rust-arrayref")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayref" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0i6m1l3f73i0lf0cjdf5rh3xpvxydyhfbakq7xx7bkrp5qajgid4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6))))
    (home-page "https://github.com/droundy/arrayref")
    (synopsis "Macros to take array references of slices")
    (description
     "Macros to take array references of slices.")
    (license license:bsd-2)))

(define-public rust-arrayvec-0.7
  (package
    (name "rust-arrayvec")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mjl8jjqxpl0x7sm9cij61cppi7yi38cdrd1l8zjw7h7qxk2v9cd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/bluss/arrayvec")
    (synopsis "Vector with fixed capacity")
    (description
     "This package provides a vector with fixed capacity, backed by an
array (it can be stored on the stack too).  Implements fixed capacity
ArrayVec and ArrayString.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arrayvec-0.5
  (package
    (inherit rust-arrayvec-0.7)
    (name "rust-arrayvec")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12q6hn01x5435bprwlb7w9m7817dyfq55yrl4psygr78bp32zdi3"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-arrayvec-0.4
  (package
    (inherit rust-arrayvec-0.5)
    (name "rust-arrayvec")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fdiv5m627gh6flp4mpmi1mh647imm9x423licsr11psz97d97yd"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nodrop" ,rust-nodrop-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-arrow-5
  (package
    (name "rust-arrow")
    (version "5.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zj2sjlnkwz2sdfc83zcz75vg1d3900h8ix15nkjsbz5hd1pzvri"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-flatbuffers" ,rust-flatbuffers-2)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.7)
        ("rust-multiversion" ,rust-multiversion-0.6)
        ("rust-num" ,rust-num-0.4)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-prettytable-rs" ,rust-prettytable-rs-0.8)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Rust implementation of Apache Arrow")
    (description
     "This crate is a Rust implementation of Apache Arrow in-memory columnar
format.")
    (license license:asl2.0)))

(define-public rust-arrow-4
  (package
    (inherit rust-arrow-5)
    (name "rust-arrow")
    (version "4.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "141qb0yqk179n324qrhbv14ysz13mcfsw00d6m09882gx9637wzn"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-aliases" ,rust-cfg-aliases-0.1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-flatbuffers" ,rust-flatbuffers-0.8)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.7)
        ("rust-multiversion" ,rust-multiversion-0.6)
        ("rust-num" ,rust-num-0.4)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-prettytable-rs" ,rust-prettytable-rs-0.8)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-arrow-format-0.3
  (package
    (name "rust-arrow-format")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-format" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0apg3x3yllbazh6jr85g5yammjqxpnrk6jm4n2yypyhbcvcs4zcz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-flatbuffers" ,rust-flatbuffers-2)
        ("rust-prost" ,rust-prost-0.9)
        ("rust-prost-derive" ,rust-prost-derive-0.9)
        ("rust-tonic" ,rust-tonic-0.6))))
    (home-page "https://crates.io/crates/arrow-format")
    (synopsis "Unofficial flatbuffers and tonic code of Apache Arrow spec")
    (description "This package provides an nofficial flatbuffers and tonic
code of Apache Arrow spec.")
    (license license:asl2.0)))

(define-public rust-arrow2-0.7
  (package
    (name "rust-arrow2")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15dkirkx07bagjgcar2ikmvs0d1zsk5l99bsszla91rxbivy4wyq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.7)
        ("rust-arrow-format" ,rust-arrow-format-0.3)
        ("rust-avro-rs" ,rust-avro-rs-0.13)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.6)
        ("rust-comfy-table" ,rust-comfy-table-4)
        ("rust-csv" ,rust-csv-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-hash-hasher" ,rust-hash-hasher-2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-libflate" ,rust-libflate-1)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-multiversion" ,rust-multiversion-0.6)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-parquet2" ,rust-parquet2-0.6)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-simdutf8" ,rust-simdutf8-0.1)
        ("rust-streaming-iterator" ,rust-streaming-iterator-0.1)
        ("rust-strength-reduce" ,rust-strength-reduce-0.2)
        ("rust-zstd" ,rust-zstd-0.9))))
    (home-page "https://github.com/jorgecarleitao/arrow2")
    (synopsis "Unofficial implementation of Apache Arrow spec in safe Rust")
    (description
     "Arrow2 is a Rust library to work with the Arrow format.  It is
a re-write of the official Arrow crate using transmute-free operations.")
    (license license:asl2.0)))

(define-public rust-arrow2-0.5
  (package
    (inherit rust-arrow2-0.7)
    (name "rust-arrow2")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "042m859jfffnhi84qc919pkyanlr98wqqf67pcrylk4hhh0v84xx"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.7)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.5)
        ("rust-comfy-table" ,rust-comfy-table-4)
        ("rust-csv" ,rust-csv-1)
        ("rust-flatbuffers" ,rust-flatbuffers-2)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-hash-hasher" ,rust-hash-hasher-2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-multiversion" ,rust-multiversion-0.6)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-parquet2" ,rust-parquet2-0.4)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-iterator" ,rust-streaming-iterator-0.1)
        ("rust-strength-reduce" ,rust-strength-reduce-0.2)
        ("rust-zstd" ,rust-zstd-0.9))))))

(define-public rust-article-scraper-1
  (package
    (name "rust-article-scraper")
    (version "1.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "article_scraper" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l904hn99fgj83f3dhspxgz1j3xzgjbnbfsgvmhd1jg5l4hqfhxp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests use the network
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-image" ,rust-image-0.23)
        ("rust-libxml" ,rust-libxml-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-regex" ,rust-regex-1)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-url" ,rust-url-2))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list libxml2 openssl))
    (home-page "https://gitlab.com/news-flash/article_scraper")
    (synopsis "Scrap article contents from the web")
    (description "This package provides a crate to scrap article contents from
the web.")
    ;; No copyright headers in the source code.  LICENSE indicates gpl3.
    (license license:gpl3)))

(define-public rust-askama-escape-0.10
  (package
    (name "rust-askama-escape")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "askama_escape" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ys6wcrkpzygk6r93zd0rhinhy89rraarl0m4afwi023m70hihch"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/djc/askama")
    (synopsis
     "Optimized HTML escaping code, extracted from Askama")
    (description
     "This package provides a optimized HTML escaping code, extracted from
Askama.")
    (license (list license:expat license:asl2.0))))

(define-public rust-askama-shared-0.11
  (package
    (name "rust-askama-shared")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "askama_shared" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g3ksf5is0qwx9rd5lxn5gbvxfcpby5gl9cahg26wl1w1xzbg0i5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-askama-escape" ,rust-askama-escape-0.10)
        ("rust-humansize" ,rust-humansize-1)
        ("rust-nom" ,rust-nom-6)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-percent-encoding"
         ,rust-percent-encoding-2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-syn" ,rust-syn-1)
        ("rust-toml" ,rust-toml-0.5))))
    (home-page "https://github.com/djc/askama")
    (synopsis "Shared code for Askama")
    (description "This package provides a shared code for Askama.")
    (license (list license:expat license:asl2.0))))

(define-public rust-askama-derive-0.10
  (package
    (name "rust-askama-derive")
    (version "0.10.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "askama_derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08jmqb4lq5cvfjjcq7kjk5q4589zlsvc3ld35yfjyf4hqb22aafa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-askama-shared" ,rust-askama-shared-0.11)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/djc/askama")
    (synopsis "Procedural macro package for Askama")
    (description
     "This package provide procedural macro package for Askama.")
    (license (list license:expat license:asl2.0))))

(define-public rust-askama-0.10
  (package
    (name "rust-askama")
    (version "0.10.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "askama" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0d1iwywdgw3nba2iphayw8sfm3s8m9izwnhfar707qa7ds5p766j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-askama-derive" ,rust-askama-derive-0.10)
        ("rust-askama-escape" ,rust-askama-escape-0.10)
        ("rust-askama-shared" ,rust-askama-shared-0.11)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-mime-guess" ,rust-mime-guess-2))))
    (home-page "https://github.com/djc/askama")
    (synopsis
     "Type-safe, compiled Jinja-like templates for Rust")
    (description
     "This package provides a type-safe, compiled Jinja-like templates for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-asn1-derive-0.8
  (package
    (name "rust-asn1-derive")
    (version "0.8.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "asn1_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "098w0mxz4bx9w7v72gsl5wva6f0qbvzyc52m0s0n8svqbyh4z2dw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/alex/rust-asn1")
    (synopsis "#[derive] support for asn1")
    (description
     "This package provides #[derive] support for @code{asn1}.")
    (license license:bsd-3)))

(define-public rust-asn1-0.8
  (package
    (name "rust-asn1")
    (version "0.8.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "asn1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1caacmvgn463n1yc4ac6vl9phrh56ij7l3xgf6qgzbpyjm8v7zyg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-asn1-derive" ,rust-asn1-derive-0.8)
        ("rust-chrono" ,rust-chrono-0.4))
       #:cargo-development-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/alex/rust-asn1")
    (synopsis "ASN.1 (DER) parser and writer")
    (description
     "This is a Rust library for parsing and generating ASN.1 data (DER only).")
    (license license:bsd-3)))

(define-public rust-as-slice-0.1
  (package
    (name "rust-as-slice")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as-slice" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q3a9494ikaq38zjg5px5gwwrbdgnyj23b505224njlmwd4knh25"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array-0.14" ,rust-generic-array-0.14)
        ("rust-generic-array-0.13" ,rust-generic-array-0.13)
        ("rust-generic-array-0.12" ,rust-generic-array-0.12)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/japaric/as-slice")
    (synopsis "AsSlice and AsMutSlice traits")
    (description "This package provides @code{AsSlice} and @code{AsMutSlice}
traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ascii-1
  (package
    (name "rust-ascii")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ascii" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0281gc828q4j692gb66jfdr5k16gyszgqflylh0pp30rllv63xdv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/tomprogrammer/rust-ascii")
    (synopsis "ASCII-only equivalents to `char`, `str` and `String`")
    (description
     "A rust library that provides ASCII-only string and character types,
equivalent to the @code{char}, @code{str} and @code{String} types in the
standard library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ascii-0.9
  (package
    (inherit rust-ascii-1)
    (name "rust-ascii")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0km3zzkhrr22drf9p1zcblqirlxkdc7zra25acpi0h8qax5c1cga"))))
    (arguments
     `(#:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-ascii-0.8
  (package
    (inherit rust-ascii-1)
    (name "rust-ascii")
    (version "0.8.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "051gh2bgjq90s0f0i0hd9p4z4fpg5k82b570d1223jj7rhd8kglp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-ascii-utils-0.9
  (package
    (name "rust-ascii-utils")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jpp550pwi38msflpy7lnqm2r153kn9k19bss6k9ak9yacq8z4vi"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/tredoe/ascii_utils")
    (synopsis "Utilities to handle ASCII characters")
    (description
     "This library provides utilities to handle ASCII characters.")
    (license license:mpl2.0)))

(define-public rust-assert-0.7
  (package
    (name "rust-assert")
    (version "0.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hnph97yz3hpf71s4rdzcrgd492d1m7rj0k48ymxl1w5d2g8v450"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/stainless-steel/assert")
    (synopsis "Assertions for testing")
    (description "This package provides assertions for testing.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-assert-approx-eq-1
  (package
    (name "rust-assert-approx-eq")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_approx_eq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zagfwfad5wssmr830gk3489f97ppczv6xs627jxniwm6ssdl1rw"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/ashleygwilliams/assert_approx_eq")
    (synopsis "Assert approximately equal")
    (description
     "This package provides a Rust macro for asserting two numbers are
approximately equal.")
    ;; Either license can be chosen at the users option.
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cli-0.6
  (package
    (name "rust-assert-cli")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-cli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jc1bh3cvnl66bl7s5gr1xnm0hl8d2l3gmil0pmhp5v2xp0bg6m2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;; requires `printenv`, but installing coreutils doesn't help
       #:cargo-inputs
       (("rust-colored" ,rust-colored-1)
        ("rust-difference" ,rust-difference-2)
        ("rust-environment" ,rust-environment-0.1)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1))))
    (home-page "https://github.com/assert-rs/assert_cli")
    (synopsis "Test CLI Applications")
    (description "This package helps testing CLI Applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cmd-2
  (package
    (name "rust-assert-cmd")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_cmd" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gpqwasl690zimy13rn614mpzgykpa09v5xivs4pdmpg77fivblk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-concolor" ,rust-concolor-0.0.8)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-predicates" ,rust-predicates-2)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-wait-timeout" ,rust-wait-timeout-0.2)
        ("rust-yansi" ,rust-yansi-0.5))))
    (home-page "https://github.com/assert-rs/assert_cmd")
    (synopsis "Test CLI Applications")
    (description "@code{assert_cmd} aims to simplify the process for doing
integration testing of CLIs, including finding your crate's binary to test and
assertions on the result of your program's run.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cmd-1
  (package
    (inherit rust-assert-cmd-2)
    (name "rust-assert-cmd")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-cmd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pz938z0wipy2czmp5aym6agfsgkpzd9rhbjqg3s9p84s0dq681x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-predicates" ,rust-predicates-2)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-wait-timeout" ,rust-wait-timeout-0.2))
       #:cargo-development-inputs
       (("rust-escargot" ,rust-escargot-0.5))))))

(define-public rust-assert-cmd-0.9
  (package
    (inherit rust-assert-cmd-1)
    (name "rust-assert-cmd")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-cmd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02gq7j9qzjkbyq4hk18cih3kylk3dyxwa2gc5k7lah9kdwkhrdn5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-escargot" ,rust-escargot-0.3)
        ("rust-predicates" ,rust-predicates-0.9)
        ("rust-predicates-core" ,rust-predicates-core-0.9)
        ("rust-predicates-tree" ,rust-predicates-tree-0.9))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1))))))

(define-public rust-assert-fs-1
  (package
    (name "rust-assert-fs")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-fs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gm1xsxmv1s8810kbjiw4rnikqi76a3yhrb8b717g90dw1rbn2fg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-concolor" ,rust-concolor-0.0.8)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-globwalk" ,rust-globwalk-0.8)
        ("rust-predicates" ,rust-predicates-2)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-yansi" ,rust-yansi-0.5))))
    (home-page "https://github.com/assert-rs/assert_fs")
    (synopsis "Filesystem fixtures and assertions for testing")
    (description
     "This crate provides file system fixtures and assertions for testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-json-diff-1
  (package
    (name "rust-assert-json-diff")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-json-diff" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h2w4n8f8a1n9sc8snka0arzw5x95ky5k8i7603z3lhkcplwnna2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-extend" ,rust-extend-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/davidpdrsn/assert-json-diff")
    (synopsis "Easily compare two JSON values and get great output")
    (description
     "This crate includes macros for comparing two serializable values
by diffing their JSON representations.  It is designed to give much
more helpful error messages than the standard @code{assert_eq!}.  It
basically does a diff of the two objects and tells you the exact
differences.  This is useful when asserting that two large JSON
objects are the same.")
    (license license:expat)))

(define-public rust-assert-matches-1
  (package
    (name "rust-assert-matches")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_matches" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a9b3p9vy0msylyr2022sk5flid37ini1dxji5l3vwxsvw4xcd4v"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/murarth/assert_matches")
    (synopsis "Asserts that a value matches a pattern")
    (description
     "This package asserts that a value matches a pattern in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aster-0.41
  (package
    (name "rust-aster")
    (version "0.41.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aster" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q704kn23wnwnrxml7w1mxw6a3xb6386x5wgys6ibnyramrxzksc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-compiletest-rs" ,rust-compiletest-rs-0.2)
        ("rust-syntex-syntax" ,rust-syntex-syntax-0.58))))
    (home-page "https://github.com/serde-rs/aster")
    (synopsis "Libsyntax ast builder")
    (description "This package provides a libsyntax ast builder.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-attributes-1
  (package
    (name "rust-async-attributes")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08w41342hybxhln7j7hjsf7v04p3r9d6qdczfwp8d53xj5bd3lzg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-0.99))))
    (home-page "https://github.com/async-rs/async-attributes")
    (synopsis "Experimental language-level polyfills for Async Rust")
    (description
     "This package provides experimental language-level polyfills for Async
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-channel-1
  (package
    (name "rust-async-channel")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ffn42ig82az8ndgjb545imifarcavwxs9dff6psbdkdjj1hsx2r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-1)
        ("rust-event-listener" ,rust-event-listener-2)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs
       (("rust-blocking" ,rust-blocking-0.6)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-futures-lite" ,rust-futures-lite-1))))
    (home-page "https://github.com/stjepang/async-channel")
    (synopsis "Async multi-producer multi-consumer channel")
    (description
     "Async multi-producer multi-consumer channel")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-compression-0.3
  (package
    (name "rust-async-compression")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-compression" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dwm5zgi560m1xy30k3a4sg96mlfkjdk8jl6a1dk4d72ah8iyb5p"))))
    (build-system cargo-build-system)
    (arguments
     ;; FIXME: Tests fail with "error[E0432]: unresolved import `syn::export`"
     ;; when compiling ntest_test_cases v0.3.4.
     `(#:tests? #false
       #:cargo-inputs
       (("rust-brotli" ,rust-brotli-3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-bzip2" ,rust-bzip2-0.4)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-xz2" ,rust-xz2-0.1)
        ("rust-zstd" ,rust-zstd-0.6)
        ("rust-zstd-safe" ,rust-zstd-safe-3))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-test" ,rust-futures-test-0.3)
        ("rust-ntest" ,rust-ntest-0.3)
        ("rust-proptest" ,rust-proptest-0.9)
        ("rust-proptest-derive" ,rust-proptest-derive-0.1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-timebomb" ,rust-timebomb-0.1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio-util" ,rust-tokio-util-0.4)
        ("rust-tokio-util" ,rust-tokio-util-0.6))))
    (home-page "https://github.com/Nemo157/async-compression")
    (synopsis "Adaptors between compression crates and Rust's modern asynchronous IO types")
    (description "This package provides adaptors between compression crates
and Rust's modern asynchronous IO types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-datagram-3
  (package
    (name "rust-async-datagram")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-datagram" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k4kiy67d24ay8l7xrfjpsa4zkmhxv97ddj0f16rcv61qkky3i4f"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rustasync/async-datagram")
    (synopsis "Async datagram traits")
    (description "This package provides asynchronous datagram traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-dup-1
  (package
    (name "rust-async-dup")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-dup" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z3grxarv9wpck6jm31qayib9barf12a47gvii9934n0ilms29vl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-simple-mutex" ,rust-simple-mutex-1))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-smol" ,rust-smol-0.1))))
    (home-page "https://github.com/stjepang/async-dup")
    (synopsis "Duplicate an async I/O handle")
    (description
     "This crate provides two tools, Arc and Mutex.  Arc implements
AsyncRead, AsyncWrite, and AsyncSeek if a reference to the inner type
does.  A reference to Mutex implements AsyncRead, AsyncWrite, and
AsyncSeek if the inner type does.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-executor-1
  (package
    (name "rust-async-executor")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ilivvzc082ynr096xxghc8hdmlmacxilcpn738ylh5lqxq7k1zb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-task" ,rust-async-task-4)
        ("rust-concurrent-queue" ,rust-concurrent-queue-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-vec-arena" ,rust-vec-arena-1))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-easy-parallel" ,rust-easy-parallel-3))))
    (home-page "https://github.com/stjepang/async-executor")
    (synopsis "Async executor")
    (description "This library provides async executors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-fs-1
  (package
    (name "rust-async-fs")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-fs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qnsqg0jjpda590w8nvbhh5mcmdyx5f43xx2g313fz0izzwa8g4b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-lock" ,rust-async-lock-2)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-futures-lite" ,rust-futures-lite-1))))
    (home-page "https://github.com/stjepang/async-fs")
    (synopsis "Async filesystem primitives in Rust")
    (description "This package provides async filesystem primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-global-executor-2
  (package
    (name "rust-async-global-executor")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-global-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xjacr43sbz2zk0zygpd9k14n95wa61x8n9i8mcdwdkz659fr1lm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-executor" ,rust-async-executor-1)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-async-mutex" ,rust-async-mutex-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3))))
    (home-page "https://github.com/async-rs/async-global-executor")
    (synopsis "Global executor built on top of @code{async-executor} and
@code{async-io}")
    (description
     "This package provides a global executor built on top of
@code{async-executor} and @code{async-io}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-h1-2
  (package
    (name "rust-async-h1")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-h1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1p6ls50p1ixnxrhmx4sdb5d2kqrl1kfhcb0lkqlhzzqjz1sqmip5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-dup" ,rust-async-dup-1)
        ("rust-async-std" ,rust-async-std-1)
        ("rust-byte-pool" ,rust-byte-pool-0.2)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-http-types" ,rust-http-types-2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-1))))
    (home-page "https://github.com/http-rs/async-h1")
    (synopsis "Asynchronous HTTP 1.1 parser")
    (description
     "This package provides an asynchronous HTTP 1.1 parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-io-1
  (package
    (name "rust-async-io")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zg0bvb58615qar6ih3ddr1cyjh0fsrfdhpy90z1qxjnfpqgh5ck"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-nb-connect" ,rust-nb-connect-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking" ,rust-parking-2)
        ("rust-polling" ,rust-polling-2)
        ("rust-vec-arena" ,rust-vec-arena-1)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-net" ,rust-async-net-1)
        ("rust-inotify" ,rust-inotify-0.8)
        ("rust-nix" ,rust-nix-0.18)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-timerfd" ,rust-timerfd-1)
        ("rust-uds-windows" ,rust-uds-windows-0.1))))
    (home-page "https://github.com/stjepang/async-io")
    (synopsis "Async I/O and timers")
    (description
     "This crate provides two tools: Async, an adapter for standard networking
types (and many other types) to use in async programs, and Timer, a future
that expires at a point in time.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-lock-2
  (package
    (name "rust-async-lock")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yrvnshs94aiimvprqkhcg1z7x9abzsja8f4ifcakr5x6abn15hr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-2))))
    (home-page "https://github.com/stjepang/async-lock")
    (synopsis "Async synchronization primitives")
    (description "This package provides Async synchronization primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-log-1
  (package
    (name "rust-async-log")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-log" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16ymra7f8169br9ss9m9n4l6rjcav9ns6r9mv4nr4r9i9wq37fpm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-log-attributes" ,rust-async-log-attributes-1)
        ("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/async-rs/async-log")
    (synopsis "Async tracing capabilities for the @code{log} crate")
    (description
     "This crate provides extension types and hooks to @code{log} to enable
asynchronous logging.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-log-attributes-1
  (package
    (name "rust-async-log-attributes")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-log-attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b9nysb5yxf772cinl5rsyhl2zazj2qfhbckv1kjz9qr3gkgi5ys"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/rustasync/runtime")
    (synopsis
     "Proc Macro attributes for the async-log crate")
    (description
     "This package provides proc macro attributes for the @code{async-log}
crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-macros-1
  (package
    (name "rust-async-macros")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fib4wxiym9f045xqb8a2gyfa8yym3hb62g4jqjfmzn14jdxa8g4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))
       #:cargo-development-inputs
       (("rust-futures-preview" ,rust-futures-preview-0.3))))
    (home-page "https://github.com/async-rs/async-macros")
    (synopsis "Macros for async-std")
    (description "Macros for async-std.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-mutex-1
  (package
    (name "rust-async-mutex")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-mutex" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vhmsscqx48dmxw0yir6az0pbwcq6qjvcv2f43vdpn95vd9bi7a7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true      ;XXX: enable when rust-async-std-1 is packaged
       #:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-2))
       #:cargo-development-inputs
       (;("rust-async-std" ,rust-async-std-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-intrusive" ,rust-futures-intrusive-0.3)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-smol" ,rust-smol-0.1)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/stjepang/async-lock")
    (synopsis "Async synchronisation primitives")
    (description "This crate provides the following async synchronisation
primitives:

@itemize
@item Barrier: enables tasks to synchronize all together at the same time.
@item Mutex: a mutual exclusion lock.
@item RwLock: a reader-writer lock, allowing any number of readers or a single writer.
@item Semaphore: limits the number of concurrent operations.
@end itemize")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-native-tls-0.3
  (package
    (name "rust-async-native-tls")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-native-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cwv4vbrvcbv58b51y1azfbszzgzhrzxx92q5nl6hk6kkf97m7ly"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true       ;XXX: build when rust-async-std-1 is packaged
       #:cargo-inputs
       (;;("rust-async-std" ,rust-async-std-1)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-threadpool" ,rust-threadpool-1))))
    (home-page "https://docs.rs/crate/async-native-tls/")
    (synopsis "Native TLS using futures")
    (description "Native TLS using futures")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-net-1
  (package
    (name "rust-async-net")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-net" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rgvvqb1l86hawl1j0jfyzq35yracbbh29109131izmghmf4gph6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-io" ,rust-async-io-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1))))
    (home-page "https://github.com/stjepang/async-net")
    (synopsis "Async networking primitives for TCP/UDP/Unix communication")
    (description
     "Async networking primitives for TCP/UDP/Unix communication")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-process-1
  (package
    (name "rust-async-process")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-process" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nmvqwqxzy0gv7n8agknaijns9dsxqj81bxms4bs647vq44ym32c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=set_current_dir_works"
                            "--skip=signal_reported_right"
                            "--skip=stdin_works")
       #:cargo-inputs
       (("rust-async-io" ,rust-async-io-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-event-listener" ,rust-event-listener-2)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/stjepang/async-process")
    (synopsis "Async interface for working with processes")
    (description
     "This crate is an async version of @code{std::process}.  A background
thread named @code{async-process} is lazily created on first use, which waits
for spawned child processes to exit and then calls the @code{wait()} syscall
to clean up the ``zombie'' processes.

This is unlike the process API in the standard library, where dropping
a running Child leaks its resources.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-ready-3
  (package
    (name "rust-async-ready")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-ready" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09xw34q0k48r1bvs3s1l2a1mglz98l7zjbkdcy861k8zsyfwfw4l"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rustasync/async-ready")
    (synopsis "Async readiness traits")
    (description
     "This package provides Async readiness traits.  Those can be useful when
implementing async state machines that can later be wrapped in dedicated
futures.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-std-1
  (package
    (name "rust-async-std")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-std" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h834fni3npsggjqin8386d2fn11m2z42dr1ymq0aknppa2ndw6r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-attributes" ,rust-async-attributes-1)
        ("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-global-executor" ,rust-async-global-executor-2)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-async-lock" ,rust-async-lock-2)
        ("rust-async-process" ,rust-async-process-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-gloo-timers" ,rust-gloo-timers-0.2)
        ("rust-kv-log-macro" ,rust-kv-log-macro-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-surf" ,rust-surf-2)
        ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4))))
    (home-page "https://async.rs")
    (synopsis "Async version of the Rust standard library")
    (description
     "This crate provides an async version of @code{std}.  It provides all the
interfaces you are used to, but in an async version and ready for Rust's
@code{async/await} syntax.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-std-0.99
  (package
    (inherit rust-async-std-1)
    (name "rust-async-std")
    (version "0.99.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-std" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k34181r1xzalyf7alka0ibnbqll6s5l435ycydm7fv1g6gill24"))))
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=io_timeout")
       #:cargo-inputs
       (("rust-async-attributes" ,rust-async-attributes-1)
        ("rust-async-macros" ,rust-async-macros-1)
        ("rust-async-task" ,rust-async-task-1)
        ("rust-broadcaster" ,rust-broadcaster-0.2)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.3)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.7)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-timer" ,rust-futures-timer-1)
        ("rust-kv-log-macro" ,rust-kv-log-macro-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-uds" ,rust-mio-uds-0.6)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.1)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-femme" ,rust-femme-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-async-stream-0.3
  (package
    (name "rust-async-stream")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-stream" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0986b72jksg4lndw76py9glry3snc29bbqrna874wl5jwgkp84qp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=test")
       #:cargo-inputs
       (("rust-async-stream-impl" ,rust-async-stream-impl-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-test" ,rust-tokio-test-0.4)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/tokio-rs/async-stream")
    (synopsis "Asynchronous streams using async & await notation")
    (description
     "This package provides asynchronous streams using async & await
notation.")
    (license license:expat)))

(define-public rust-async-stream-impl-0.3
  (package
    (name "rust-async-stream-impl")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-stream-impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "024k57iwmmhzvbzacxlkssh45cqlnb8xjlvlsp60jm6fsb4di3k4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=try_stream"
                            "--skip=stream")
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/tokio-rs/async-stream")
    (synopsis "Proc macros for async-stream crate")
    (description
     "This package provides proc macros for @code{rust-async-stream}
crate.")
    (license license:expat)))

(define-public rust-async-task-4
  (package
    (name "rust-async-task")
    (version "4.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w0a1c8jim6s5bvcyiiwg9m4bdv3xnd4hbjm97ndgmphmgg32679"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-flume" ,rust-flume-0.10))))
    (home-page "https://github.com/stjepang/async-task")
    (synopsis "Task abstraction for building executors")
    (description
     "This package provides a task abstraction for building executors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-task-3
  (package
    (inherit rust-async-task-4)
    (name "rust-async-task")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lrm7cm9dpashmkbqa8mvglbf85gadviqil7qnnrm0pjdqap4xy1"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures" ,rust-futures-0.3))))))

(define-public rust-async-task-1
  (package
    (inherit rust-async-task-4)
    (name "rust-async-task")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0p88087z43zvv924my16a17qd65kdlv1r59h80h73rvrn0bc1hha"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures" ,rust-futures-0.3))))))

(define-public rust-async-tls-0.10
  (package
    (name "rust-async-tls")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "126by0la2wvfadazfnmw7b6ch07dk9ggny94a3vvzgk2qdpqn3fx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-rustls" ,rust-rustls-0.19)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.21))))
    (home-page "https://github.com/async-std/async-tls")
    (synopsis "Asynchronous TLS/SSL streams using Rustls")
    (description
     "This package provides asynchronous TLS/SSL streams using Rustls.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-trait-0.1
  (package
    (name "rust-async-trait")
    (version "0.1.57")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0vw256zb104ni4lw0r5j3jdws54r9n01mvl8gs6pacmwp1348ikn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-attributes" ,rust-tracing-attributes-0.1)
        ("rust-tracing-futures" ,rust-tracing-futures-0.2)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/async-trait")
    (synopsis "Type erasure for async trait methods")
    (description "This package provides type erasure for async trait
methods.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atom-0.3
  (package
    (name "rust-atom")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qig9fcdqf07mzzpkicm5wgxv0zpr28njdsqf708wxq27yf6k1iw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/slide-rs/atom")
    (synopsis "Safe abstraction around AtomicPtr")
    (description "This package provides a safe abstraction around AtomicPtr.")
    (license license:asl2.0)))

(define-public rust-atomic-polyfill-1
  (package
    (name "rust-atomic-polyfill")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "atomic-polyfill" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ckvmx98ffyxax1irb61p0aln4v65xxnz4d2qgavhvcd513zb6fj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-critical-section" ,rust-critical-section-1))))
    (home-page "https://github.com/embassy-rs/atomic-polyfill")
    (synopsis "Atomic polyfills, for targets where they're not available")
    (description "This package provides atomic polyfills, for targets where
they're not available.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atomic-polyfill-0.1
  (package
    (name "rust-atomic-polyfill")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic-polyfill" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hk08pdp6dgxqhy05l75518svrrrm7c1shfn51dk4claad4dg1p6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-critical-section" ,rust-critical-section-0.2)
        ("rust-riscv-target" ,rust-riscv-target-0.1))))
    (home-page "https://github.com/embassy-rs/atomic-polyfill")
    (synopsis "Atomic polyfills, for targets where they're not available")
    (description "This package provides atomic polyfills, for targets where
they're not available.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atomic-waker-1
  (package
    (name "rust-atomic-waker")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic-waker" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ansiq5vlw684fhks2x4a4is2rqlbv50q5mi8x0fxxvx5q2p8lq6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3))))
    (home-page "https://github.com/stjepang/atomic-waker")
    (synopsis "Synchronization primitive for task wakeup")
    (description
     "This package provides a synchronization primitive for task wakeup.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-atty-0.2
  (package
    (name "rust-atty")
    (version "0.2.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atty" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hermit-abi" ,rust-hermit-abi-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/softprops/atty")
    (synopsis "Simple interface for querying atty")
    (description
     "This package provides a simple interface for querying atty.")
    (license license:expat)))

(define-public rust-atty-0.2.11
  (package
    (inherit rust-atty-0.2)
    (name "rust-atty")
    (version "0.2.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "atty" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0lln6vaczj521qqjbaqnb81w5p6xk4fjfkg33r0m22cm4f3mnzcs"))))
    (arguments
      `(#:skip-build?
        #t
        #:cargo-inputs
        (("rust-libc" ,rust-libc-0.2)
         ("rust-termion" ,rust-termion-1)
         ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-autocfg-1
  (package
    (name "rust-autocfg")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "autocfg" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cuviper/autocfg")
    (synopsis
     "Automatic cfg for Rust compiler features")
    (description
     "Automatic cfg for Rust compiler features.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-autocfg-0.1
  (package
    (inherit rust-autocfg-1)
    (name "rust-autocfg")
    (version "0.1.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "autocfg" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1chwgimpx5z7xbag7krr9d8asxfqbh683qhgl9kn3hxk2l0djj8x"))))
    (arguments '(#:skip-build? #t))))

(define-public rust-automod-1
  (package
    (name "rust-automod")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "automod" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1z8kdbvvz0k8mfs45mvs16lr9xj59cdcp0sm45fawfh93gai4mhg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       ;; Tests not included in tar.
       #:tests? #f))
    (home-page "https://github.com/dtolnay/automod")
    (synopsis "Pull in every source file in a directory as a module")
    (description "Pull in every source file in a directory as a module.")
    (license (list license:expat license:asl2.0))))

(define-public rust-average-0.13
  (package
    (name "rust-average")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "average" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c97m8yagvq8r6qgd3harm5vnkdbld4mxg9byyxh6igjsf8wfgl4"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             ;; The resolver feature is not supported by our versions of Cargo.
             (("resolver = \"2\".*") "")
             ;; Relax version requirement for byteorder
             (("=1.3") "^1.3"))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-easy-cast" ,rust-easy-cast-0.4)
        ("rust-float-ord" ,rust-float-ord-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.3)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rand-distr" ,rust-rand-distr-0.4)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.6)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))
    (home-page "https://github.com/vks/average")
    (synopsis "Calculate statistics iteratively")
    (description "This crate provides tools for calculating statistics
iteratively in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-average-0.10
  (package
    (name "rust-average")
    (version "0.10.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "average" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1dmsxqcr1n0i20qr9g2g6j89kkx8dy6w18dbqzx1wi42wj1chgvh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-conv" ,rust-conv-0.3)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.2)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-proptest" ,rust-proptest-0.9)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-distr" ,rust-rand-distr-0.2)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))
    (home-page "https://github.com/vks/average")
    (synopsis "Calculate statistics iteratively")
    (description "This crate provides for calculating statistics iteratively
in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-av-metrics-0.7
  (package
    (name "rust-av-metrics")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "av-metrics" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y1q61lhahljxh1l2brp8v795qf6g7gr4h4vdmq43g5z5pq2dw50"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.8)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lab" ,rust-lab-0.11)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-v-frame" ,rust-v-frame-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-y4m" ,rust-y4m-0.7))))
    (home-page "https://github.com/rust-av/av-metrics")
    (synopsis "Collection of algorithms for measuring audio/video metrics")
    (description
     "This package provides a collection of algorithms for measuring
audio/video metrics.")
    (license license:expat)))

(define-public rust-average-0.9
  (package
    (inherit rust-average-0.10)
    (name "rust-average")
    (version "0.9.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "average" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f8ya00bv6qki9m7b4lb3bn845rj473mx02qpm7wgy5qc1yp75xs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-conv" ,rust-conv-0.3)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))))

(define-public rust-avro-rs-0.13
  (package
    (name "rust-avro-rs")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "avro-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dsy8r4c6l4xx9wp80byrb24zvlf9m19f5nwpklis8hhczfm1rgc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-crc" ,rust-crc-1)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libflate" ,rust-libflate-1)
        ("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-snap" ,rust-snap-0.2)
        ("rust-strum" ,rust-strum-0.18)
        ("rust-strum-macros" ,rust-strum-macros-0.18)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-typed-builder" ,rust-typed-builder-0.5)
        ("rust-uuid" ,rust-uuid-0.8)
        ("rust-zerocopy" ,rust-zerocopy-0.3))))
    (home-page "https://github.com/flavray/avro-rs")
    (synopsis "Library for working with Apache Avro in Rust")
    (description
     "This package is a library for working with Apache Avro in Rust.")
    (license license:expat)))

(define-public rust-awc-2
  (package
    (name "rust-awc")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "awc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14g6m53zmxw3f1sf990l7ps3w2fq2c29n1slpizc7kxhwy8f90dk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-http" ,rust-actix-http-2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7))))
    (home-page "https://actix.rs")
    (synopsis "Async HTTP and WebSocket client library")
    (description
     "This package provides async HTTP and WebSocket client library
built on the Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-awc-1
  (package
    (inherit rust-awc-2)
    (name "rust-awc")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "awc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1idacmq7n3irmdjkbxc5kdwspxk9w1gip94pcmfk7wky3m6isq6p"))))
    ;; XXX: The crate fails to't build with with the same error as
    ;; rust-actix-connect.  Skip build for now.
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-http" ,rust-actix-http-1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-base64" ,rust-base64-0.11)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6))
       #:cargo-development-inputs
       (("rust-actix-http-test" ,rust-actix-http-test-1)
        ("rust-actix-web" ,rust-actix-web-2)
        ("rust-brotli" ,rust-brotli-3))))))

(define-public rust-awc-0.2
  (package
    (inherit rust-awc-2)
    (name "rust-awc-2")
    (version "0.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "awc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i5qinnh37bwpx86m2yyq1q1bnsa31vlwlz7942bzlwd4y1m56ay"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.1)
        ("rust-actix-http" ,rust-actix-http-0.2)
        ("rust-actix-service" ,rust-actix-service-0.4)
        ("rust-base64" ,rust-base64-0.10)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-derive-more" ,rust-derive-more-0.15)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rustls" ,rust-rustls-0.15)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2))))))

(define-public rust-az-1
  (package
    (name "rust-az")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "az" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1i2s9bqar8hfxjmfr2cbhi4s26s2sd1kc3x3g517ygshyp8sawgp"))))
    (build-system cargo-build-system)
    (home-page "https://gitlab.com/tspiteri/az")
    (synopsis "Casts and checked casts")
    (description "This crate provides casts and checked casts.")
    (license (list license:expat license:asl2.0))))

(define-public rust-backtrace-0.3
  (package
    (name "rust-backtrace")
    (version "0.3.66")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backtrace" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19yrfx0gprqmzphmf6qv32g93w76ny5g751ks1abdkqnsqcl7f6a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-addr2line" ,rust-addr2line-0.17)
        ("rust-cc" ,rust-cc-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.7)
        ("rust-miniz-oxide" ,rust-miniz-oxide-0.5)
        ("rust-object" ,rust-object-0.29)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/rust-lang/backtrace-rs")
    (synopsis "Acquire a stack trace (backtrace) at runtime in a Rust program")
    (description
     "This package provides a library to acquire a stack
trace (backtrace) at runtime in a Rust program.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-backtrace-0.3.35
  (package
    (inherit rust-backtrace-0.3)
    (name "rust-backtrace")
    (version "0.3.35")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backtrace" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mfwbb6832rh1za304w8x37bvs9fjbybpmmz0iksqfzsaf108w8k"))))))

(define-public rust-bare-metal-1
  (package
    (name "rust-bare-metal")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bare-metal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00wn61b219nkfcwggim5pj7mcyn1gkq8zqaq4gjlb0rri9d8zzpq"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rust-embedded/bare-metal")
    (synopsis "Abstractions common to bare metal systems")
    (description "This package provides abstractions common to bare metal
systems.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bare-metal-0.2
  (package
    (inherit rust-bare-metal-1)
    (name "rust-bare-metal")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bare-metal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cy5pbb92fznnri72y6drfpjxj4qdmd62f0rrlgy70dxlppn9ssx"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-barrel-0.6
  (package
    (name "rust-barrel")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "barrel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qgzrfpp2acb06bbqrf5a8pjjwf3dwinq7sv2hqq0b1jn5wcjrwx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-diesel" ,rust-diesel-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://rust-db.github.io/barrel/")
    (synopsis "Powerful schema migration building API for Rust")
    (description "This package provides a powerful schema migration building
API for Rust.")
    (license (list license:expat license:x11 license:asl2.0))))

(define-public rust-base32-0.4
  (package
    (name "rust-base32")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base32" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ykwx8jhksqxghfgyw2pzikzjf4n9wqm1x2ww5wqyn68ssf6dki3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/andreasots/base32")
    (synopsis "Base32 encoder/decoder for Rust")
    (description "This library lets you encode and decode in either
RFC4648 Base32 or in Crockford Base32.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-base58-0.1
  (package
    (name "rust-base58")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base58" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10xfw6v7jzn9i682mkw9nqybzafrvl3i2wawwgp5a8gh2n0fw92h"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/debris/base58")
    (synopsis "Tiny and fast base58 encoding")
    (description
     "Encode to base58 using only Rust.  This package is based on
@url{https://github.com/trezor/trezor-crypto/blob/master/base58.c} at commit
c6e7d37.  However, this package works only up to 128 bytes.")
    (license license:expat)))

(define-public rust-base64-0.13
  (package
    (name "rust-base64")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1z82g23mbzjgijkpcrilc7nljpxpvpf7zxf6iyiapkgka2ngwkch"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-structopt" ,rust-structopt-0.3))
       #:phases
        (modify-phases %standard-phases
         (add-after 'unpack 'fix-criterion-minor-version
          (lambda* _
           (substitute* "Cargo.toml"
             (("0\\.3\\.2")
              ,(package-version rust-criterion-0.3))))))))
    (home-page "https://github.com/marshallpierce/rust-base64")
    (synopsis "Encodes and decodes base64 as bytes or utf8")
    (description
     "This package encodes and decodes base64 as bytes or utf8.")
    (license (list license:expat license:asl2.0))))

(define-public rust-base64-0.12
  (package
    (inherit rust-base64-0.13)
    (name "rust-base64")
    (version "0.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zq33had71xh48n17g4kqs96szhx3yh7qibzwi4fk217n3vz0h9l"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; 'doctest' isn't stable until rust-1.40
           (substitute* "src/lib.rs"
             (("\\(doctest") "(test"))
           #t))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-base64-0.11
  (package
    (inherit rust-base64-0.12)
    (name "rust-base64")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1iqmims6yvr6vwzyy54qd672zw29ipjj17p8klcr578c9ajpw6xl"))))))

(define-public rust-base64-0.10
  (package
    (inherit rust-base64-0.11)
    (name "rust-base64")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13k6bvd3n6dm7jqn9x918w65dd9xhx454bqphbnv0bkd6n9dj98b"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-base64-0.9
  (package
    (inherit rust-base64-0.11)
    (name "rust-base64")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hs62r35bgxslawyrn1vp9rmvrkkm76fqv0vqcwd048vs876r7a8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-safemem" ,rust-safemem-0.3))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))))

(define-public rust-base64-0.6
  (package
    (inherit rust-base64-0.13)
    (name "rust-base64")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ja3c7wlzp3sb14f2ksp27x1mk8ycgh1391nnd7fvw01fnc4yhwn"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-safemem" ,rust-safemem-0.2))))))

(define-public rust-base64ct-1
  (package
    (name "rust-base64ct")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64ct" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1818i0gpg7q35s6yglmhgciwi3jwx65mqc2ipjl54jfbmm288kw7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-proptest" ,rust-proptest-1))))
    (home-page "https://github.com/RustCrypto/formats/tree/master/base64ct")
    (synopsis "Implementation of Base64 (RFC 4648)")
    (description
     "This package is a pure Rust implementation of Base64 (RFC 4648) which
avoids any usages of data-dependent branches/LUTs and thereby provides
portable \"best effort\" constant-time operation and embedded-friendly
@code{no_std} support.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-base64ct-1.0.1
  (package
    (inherit rust-base64ct-1)
    (name "rust-base64ct")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64ct" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sx4a44c2n450lsmi0q1mgfbjhkw1sx57462cv77p0mmy9mgscla"))))
    (arguments '())))

(define-public rust-base-x-0.2
  (package
    (name "rust-base-x")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base-x" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1hfy0wv7j5ynd73yk1vyr32pqa77rp15lkrc54f8ky9c6hcbc80v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-json" ,rust-json-0.11)
        ("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/OrKoN/base-x-rs")
    (synopsis "Encode/decode any base")
    (description "This library provides for encoding and decoding any base.")
    (license license:expat)))

(define-public rust-bat-0.18
  (package
    (name "bat")
    (version "0.18.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bat" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qlk032dd6zxda1v7clah33nafxygaw3x7f73ajwlvk956nrn1js"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ansi-colours" ,rust-ansi-colours-1)
        ("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-bugreport" ,rust-bugreport-0.4)
        ("rust-clap" ,rust-clap-2)
        ("rust-clircle" ,rust-clircle-0.3)
        ("rust-console" ,rust-console-0.14)
        ("rust-content-inspector" ,rust-content-inspector-0.2)
        ("rust-dirs-next" ,rust-dirs-next-2)
        ("rust-encoding" ,rust-encoding-0.2)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-git2" ,rust-git2-0.13)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-grep-cli" ,rust-grep-cli-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-path-abs" ,rust-path-abs-0.5)
        ("rust-semver" ,rust-semver-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-shell-words" ,rust-shell-words-1)
        ("rust-syntect" ,rust-syntect-4)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-wild" ,rust-wild-2))
       #:cargo-development-inputs
       (("rust-assert-cmd" ,rust-assert-cmd-1)
        ("rust-nix" ,rust-nix-0.21)
        ("rust-predicates" ,rust-predicates-1)
        ("rust-serial-test" ,rust-serial-test-0.5)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-wait-timeout" ,rust-wait-timeout-0.2))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list libgit2 zlib))
    (home-page "https://github.com/sharkdp/bat")
    (synopsis "@command{cat} clone with syntax highlighting and git integration")
    (description
     "@command{bat} is a drop-in @command{cat} replacement featuring syntax
highlighting for a large number of languages, git integration, and automatic
paging.")
    (license (list license:expat license:asl2.0))))

(define-public rust-beef-0.5
  (package
    (name "rust-beef")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "beef" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02blba0j192l0374kqwn8rjsc8aifj43xi26v142ijpjim1f4dk7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/maciejhirsz/beef")
    (synopsis "Faster, more compact implementation of Cow")
    (description "This package provides faster, more compact implementation of
Cow.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bencher-0.1
  (package
    (name "rust-bencher")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bencher" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1x8p2xblgqssay8cdykp5pkfc0np0jk5bs5cx4f5av097aav9zbx"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluss/bencher/")
    (synopsis "Port of the libtest benchmark runner to Rust stable")
    (description "This package provides a port of the libtest (unstable Rust)
benchmark runner to Rust stable releases.  Supports running benchmarks and
filtering based on the name.  Benchmark execution works exactly the same way
and no more (caveat: black_box is still missing!).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-bigdecimal-0.3
  (package
    (name "rust-bigdecimal")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bigdecimal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i1px8hk4l71n307c7h7igrdy37pzpm7dcni269gwab438ak7bva"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.4)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/akubera/bigdecimal-rs")
    (synopsis "Arbitrary precision decimal numbers")
    (description "This package provides arbitrary precision decimal numbers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bigdecimal-0.2
  (package
    (inherit rust-bigdecimal-0.3)
    (name "rust-bigdecimal")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bigdecimal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fd5chyy76y4qb043w1bbgz1v22f9hw5703f5r90ac5hwqk3qh6c"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bigdecimal-0.1
  (package
    (inherit rust-bigdecimal-0.2)
    (name "rust-bigdecimal")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bigdecimal" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "0i32g88sin9dzr4jn41wgg3pyx2xxm0m1a9s5vh9lpyj5lg1jx0k"))))
    (arguments
      `(#:cargo-inputs
        (("rust-num-bigint" ,rust-num-bigint-0.2)
         ("rust-num-integer" ,rust-num-integer-0.1)
         ("rust-num-traits" ,rust-num-traits-0.2)
         ("rust-serde" ,rust-serde-1))
        #:cargo-development-inputs
        (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bincode-1
  (package
    (name "rust-bincode")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bincode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bfw3mnwzx5g1465kiqllp5n4r10qrqy88kdlp3jfwnq2ya5xx5i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-bytes" ,rust-serde-bytes-0.11)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/servo/bincode")
    (synopsis
     "Binary serialization/deserialization strategy")
    (description
     "This package provides a binary serialization/deserialization strategy
that uses Serde for transforming structs into bytes and vice versa!")
    (license license:expat)))

(define-public rust-bincode-0.8
  (package
    (inherit rust-bincode-1)
    (name "rust-bincode")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bincode" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0nbj0lwykwa1a7sa4303rxgpng9p2hcz9s5d5qcrckrpmcxjsjkf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-num-traits" ,rust-num-traits-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-bytes" ,rust-serde-bytes-0.10)
        ("rust-serde-derive" ,rust-serde-derive-1))))))

(define-public rust-bindgen-0.59
  (package
    (name "rust-bindgen")
    (version "0.59.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f4fpycxmbrqk8r2x9brhfgjh86mzc6bngn4a9631x78b2jaklib"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.6)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-1)
        ("rust-which" ,rust-which-4))))
    (home-page "https://rust-lang.github.io/rust-bindgen/")
    (synopsis "Generate Rust FFI bindings to C and C++ libraries")
    (description "This package can be used to automatically generate Rust FFI
bindings to C and C++ libraries.")
    (license license:bsd-3)))

(define-public rust-bindgen-0.58
  (package
    (inherit rust-bindgen-0.59)
    (name "rust-bindgen")
    (version "0.58.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13r505nn28ay0byfd96hdg8xwcpa2r20czjy111pl66p22s2718g"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-1)
        ("rust-which" ,rust-which-3))))))

(define-public rust-bindgen-0.57
  (package
    (inherit rust-bindgen-0.58)
    (name "rust-bindgen")
    (version "0.57.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g96ypnck6n60p3cz9k3y3jnxi4z7jfv2pha5bxsm8269806aj7x"))))
    (arguments
     `(#:tests? #false ;tests/headers/16-byte-alignment.h does not exist
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs
     (list clang))))

(define-public rust-bindgen-0.55
  (package
    (inherit rust-bindgen-0.57)
    (name "rust-bindgen")
    (version "0.55.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hxlvy9q9984rr3rqaxwmgxjrd9wh11mcc161hv3shz6b7jkrcbm"))))
    (inputs
     (list clang))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))))

(define-public rust-bindgen-0.54
  (package
    (inherit rust-bindgen-0.55)
    (name "rust-bindgen")
    (version "0.54.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0dn7dlwa0abjlqbl2kvwfdy6k6kgcqg6ixcjmk6pc3dpps09pm7l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; not all test files included
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.29)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs
     (list clang))))

(define-public rust-bindgen-0.53
  (package
    (inherit rust-bindgen-0.54)
    (name "rust-bindgen")
    (version "0.53.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1rc9grfd25bk5b2acmqljhx55ndbzmh7w8b3x6q707cb4s6rfan7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.29)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.52
  (package
    (inherit rust-bindgen-0.53)
    (name "rust-bindgen")
    (version "0.52.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0mzy2gjiaggl602yn4a11xzrxfj18kl7pwqa5yv32njkxd257j7i"))))
    (arguments
     `(#:cargo-inputs
       (("rust-shlex" ,rust-shlex-0.1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-peeking-take-while"
         ,rust-peeking-take-while-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.51
  (package
    (inherit rust-bindgen-0.52)
    (name "rust-bindgen")
    (version "0.51.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x9gndlnwmxsihxvsc3izyyss7g8b2djn0daafshj1gcy69i7mzb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-shlex" ,rust-shlex-0.1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-peeking-take-while"
         ,rust-peeking-take-while-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs `())))

(define-public rust-bindgen-0.50
  (package
    (inherit rust-bindgen-0.51)
    (name "rust-bindgen")
    (version "0.50.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fp98x0k4cawil3rqxsfrb58pq3mb5mn37rp745zxfmjfigml3nb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.49
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.49.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vjacbvashvds5rbrlqvq5fy55wmp50iia3mnczvycap7mzhh1sc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.48
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.48.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1jpk0p4l4dg1lpvciq9q8wm94sjsflb1vb5x2gk9dlizv4gl2gcx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.26)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-hashbrown" ,rust-hashbrown-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.47
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.47.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b9fyq3h4lz5xfy6gv5h8v6j3hzyqcarlylvw9zc715pas1pz09a"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.26)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-hashbrown" ,rust-hashbrown-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-2))))))

(define-public rust-bindgen-0.46
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.46.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qclvj5pydn5camw396b0r3nz4nn3p5wpxg4fgg1favp043pyzwg"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.26)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-hashbrown" ,rust-hashbrown-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))) )

(define-public rust-bindgen-0.37
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.37.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "08f2cyzr8fc027mzj2lhmn5j3w318g2ql7yfw5ngxa3yhy1an98v"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-peeking-take-while"
         ,rust-peeking-take-while-0.1)
        ("rust-cexpr" ,rust-cexpr-0.2)
        ("rust-clang-sys" ,rust-clang-sys-0.23)
        ("rust-proc-macro2" ,rust-proc-macro2-0.3)  ; 0.3.5
        ("rust-log" ,rust-log-0.4)
        ("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-quote" ,rust-quote-0.5)
        ("rust-which" ,rust-which-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-clap" ,rust-clap-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bio-types-0.12
  (package
    (name "rust-bio-types")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio-types" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dmcjwky9fszmwwg7ywv52xhz93zibsgl7nj9x7gadvz8yb45g0k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-derive-new" ,rust-derive-new-0.5)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-petgraph" ,rust-petgraph-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://rust-bio.github.io")
    (synopsis "Common biomedical types for use in rust-bio and rust-htslib")
    (description
     "This package provides a collection of common biomedical types for use in
rust-bio and rust-htslib.")
    (license license:expat)))

(define-public rust-bio-0.32
  (package
    (name "rust-bio")
    (version "0.32.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wj6s3hzpx5xhajcnvdabbgpalgghdni7gmlhjl6i9pfh1xiq5pi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-bio-types" ,rust-bio-types-0.12)
        ("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-bv" ,rust-bv-0.11)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-csv" ,rust-csv-1)
        ("rust-custom-derive" ,rust-custom-derive-0.1)
        ("rust-enum-map" ,rust-enum-map-0.6)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-getset" ,rust-getset-0.0.9)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-multimap" ,rust-multimap-0.8)
        ("rust-ndarray" ,rust-ndarray-0.13)
        ("rust-newtype-derive" ,rust-newtype-derive-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-ordered-float" ,rust-ordered-float-1)
        ("rust-petgraph" ,rust-petgraph-0.5)
        ("rust-quick-error" ,rust-quick-error-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-snafu" ,rust-snafu-0.6)
        ("rust-statrs" ,rust-statrs-0.12)
        ("rust-strum" ,rust-strum-0.18)
        ("rust-strum-macros" ,rust-strum-macros-0.18)
        ("rust-triple-accel" ,rust-triple-accel-0.3)
        ("rust-vec-map" ,rust-vec-map-0.8))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-0.10))))
    (home-page "https://rust-bio.github.io")
    (synopsis "Bioinformatics library for Rust")
    (description
     "This package provides a bioinformatics library for Rust.  This library
provides implementations of many algorithms and data structures that are
useful for bioinformatics, but also in other fields.")
    (license license:expat)))

(define-public rust-bio-0.33
  (package
    (name "rust-bio")
    (version "0.33.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zaghvazh243x2pg866hjx1zwwpp9qzwkf45iz2fs9af5y661gz5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-approx" ,rust-approx-0.3)
        ("rust-bio-types" ,rust-bio-types-0.12)
        ("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-bv" ,rust-bv-0.11)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-csv" ,rust-csv-1)
        ("rust-custom-derive" ,rust-custom-derive-0.1)
        ("rust-enum-map" ,rust-enum-map-0.6)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-getset" ,rust-getset-0.0.9)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-multimap" ,rust-multimap-0.8)
        ("rust-ndarray" ,rust-ndarray-0.13)
        ("rust-newtype-derive" ,rust-newtype-derive-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-ordered-float" ,rust-ordered-float-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-petgraph" ,rust-petgraph-0.5)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-statrs" ,rust-statrs-0.13)
        ("rust-strum" ,rust-strum-0.19)
        ("rust-strum-macros" ,rust-strum-macros-0.19)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-triple-accel" ,rust-triple-accel-0.3)
        ("rust-vec-map" ,rust-vec-map-0.8))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-0.10)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://rust-bio.github.io")
    (synopsis "Bioinformatics library for Rust")
    (description
     "This package provides a bioinformatics library for Rust.  This library
provides implementations of many algorithms and data structures that are
useful for bioinformatics, but also in other fields.")
    (license license:expat)))

(define-public rust-bio-0.39
  (package
    (name "rust-bio")
    (version "0.39.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bio" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "00k0zv4yyiipzg2arnkrplfi0digwnv89bczfzhyva68yfv8scvb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-approx" ,rust-approx-0.5)
        ("rust-bio-types" ,rust-bio-types-0.12)
        ("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-bv" ,rust-bv-0.11)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-csv" ,rust-csv-1)
        ("rust-custom-derive" ,rust-custom-derive-0.1)
        ("rust-enum-map" ,rust-enum-map-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-getset" ,rust-getset-0.1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-multimap" ,rust-multimap-0.8)
        ("rust-ndarray" ,rust-ndarray-0.15)
        ("rust-newtype-derive" ,rust-newtype-derive-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-ordered-float" ,rust-ordered-float-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-petgraph" ,rust-petgraph-0.6)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-statrs" ,rust-statrs-0.14)
        ("rust-strum" ,rust-strum-0.21)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-triple-accel" ,rust-triple-accel-0.4)
        ("rust-vec-map" ,rust-vec-map-0.8))))
    (home-page "https://rust-bio.github.io")
    (synopsis "Bioinformatics library for Rust")
    (description
     "This package provides a bioinformatics library for Rust.  This library
provides implementations of many algorithms and data structures that are
useful for bioinformatics, but also in other fields.")
    (license license:expat)))

(define-public rust-bit-field-0.10
  (package
    (name "rust-bit-field")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-field" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "192rsg8g3ki85gj8rzslblnwr53yw5q4l8vfg6bf1lkn4cfdvdnw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/phil-opp/rust-bit-field")
    (synopsis "Methods for operating on individual bits and ranges of bits")
    (description
     "This is a simple crate which provides the BitField trait, which provides
methods for operating on individual bits and ranges of bits on Rust's integral
types.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-set-0.5
  (package
    (name "rust-bit-set")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "100ac8867bvbx9kv634w4xjk98b71i8nq4wdcvpf3cf4ha4j6k78"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bit-vec" ,rust-bit-vec-0.5))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/contain-rs/bit-set")
    (synopsis "Set of bits")
    (description
     "This package provides a set of bits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-set-0.4
  (package
    (inherit rust-bit-set-0.5)
    (name "rust-bit-set")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0320hhcbr73yzjpj2237vw2zq728yg7vmzb8dardg04ff4263gyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bit-vec" ,rust-bit-vec-0.4))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bit-vec-0.6
  (package
    (name "rust-bit-vec")
    (version "0.6.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bit-vec" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ywqjnv60cdh1slhz67psnp422md6jdliji6alq0gmly2xm9p7rl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.7)
        ("rust-rand-xorshift" ,rust-rand-xorshift-0.2)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/contain-rs/bit-vec")
    (synopsis "Vector of bits")
    (description
     "This package provides a vector of bits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bit-vec-0.5
  (package
    (inherit rust-bit-vec-0.6)
    (name "rust-bit-vec")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fyh8221s6cxlmng01v8v2ljhavzawqqs8r1xjc66ap5sjavx6zm"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bit-vec-0.4
  (package
    (inherit rust-bit-vec-0.5)
    (name "rust-bit-vec")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pw902a8ail0k64a7092a8vngfzsq7xkj2r22hz6q1z62s5zzd02"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bitcoin-hashes-0.10
  (package
    (name "rust-bitcoin-hashes")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bitcoin-hashes" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1c25nzrd2kn5znhjgxb9n48hc7swapiln8dqqndq368x38gcjv00"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-core2" ,rust-core2-0.3)
         ("rust-schemars" ,rust-schemars-0.8)
         ("rust-serde" ,rust-serde-1))
        #:cargo-development-inputs
        (("rust-serde-json" ,rust-serde-json-1)
         ("rust-serde-test" ,rust-serde-test-1)
         ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/rust-bitcoin/bitcoin_hashes/")
    (synopsis "Hash functions used by @code{rust-bitcoin}")
    (description "This Rust library provides hash functions that are used by
@code{rust-bitcoin}.")
    (license license:cc0)))

(define-public rust-bitfield-0.13
  (package
    (name "rust-bitfield")
    (version "0.13.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitfield" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06g7jb5r2b856vnhx76081fg90jvmy61kjqcfjysgmd5hclvvbs6"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/dzamlo/rust-bitfield")
    (synopsis "Macros to generate bitfield-like struct")
    (description
     "This crate provides macros to generate bitfield-like struct.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitflags-1
  (package
    (name "rust-bitflags")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12ki6w8gn1ldq7yz9y680llwk5gmrhrzszaa17g1sbrw2r2qvwxy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ; Tests require rust-1.46 or newer.
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-trybuild" ,rust-trybuild-1)
        ("rust-walkdir" ,rust-walkdir-2))))
    (home-page "https://github.com/bitflags/bitflags")
    (synopsis "Macro to generate structures which behave like bitflags")
    (description "This package provides a macro to generate structures which
behave like a set of bitflags.")
    (license (list license:asl2.0
                   license:expat))))

;; XXX: The package below is meant to fix rust-nix-0.22, which has the
;; following requirements for bitflags version: ">=1.1.0 <1.3.0", and every
;; package using the latter as a dependency (e.g., nushell 0.43).
(define-public rust-bitflags-1.2
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg"))))))

(define-public rust-bitflags-0.9
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.9.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bitflags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19dk39gfwmhi3iy1x0wgml1fv1bkb525ywy25zwihbm063i05zaf"))))))

(define-public rust-bitflags-0.8
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1x5z8hmirpnapkx6sww8gkc6x0q8ppni0lbsigm3mrba5byfjw0k"))))))

(define-public rust-bitflags-0.7
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v8hh6wdkpk9my8z8442g4hqrqf05h0qj53dsay6mv18lqvqklda"))))))

(define-public rust-bitflags-0.2
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09yk0lk3vjsrvfcnzljmgvz9inpjs0idykvni7kij38l5vn807x4"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))))

(define-public rust-bitmaps-2
  (package
    (name "rust-bitmaps")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitmaps" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18k4mcwxl96yvii5kcljkpb8pg5j4jj1zbsdn26nsx4r83846403"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-0.9)
        ("rust-proptest-derive" ,rust-proptest-derive-0.1))))
    (home-page "https://github.com/bodil/bitmaps")
    (synopsis "Fixed size compact boolean array in Rust")
    (description "This crate provides a convenient and efficient way of
declaring and working with fixed size bitmaps in Rust.")
    (license license:mpl2.0)))

(define-public rust-bitpacking-0.8
  (package
    (name "rust-bitpacking")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitpacking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mw2xbpkw9zhfq5lir6bgkalhhfqb5p7xwx5yimc0ry1ffnd5ix8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t #:cargo-inputs (("rust-crunchy" ,rust-crunchy-0.2))))
    (home-page "https://crates.io/crates/bitpacking")
    (synopsis "Fast integer compression/decompression via SIMD bit-packing")
    (description
     "This crate provides fast integer compression and decompression via SIMD
bit-packing.  It is a port of simdcomp C library to Rust.")
    (license license:expat)))

(define-public rust-bitreader-0.3
  (package
    (name "rust-bitreader")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitreader" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06wlzf8ra7k8ya0m71dq0kxbaalaan48dymairn9q8s4gld1hy4i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1))))
    (home-page "https://github.com/irauta/bitreader")
    (synopsis "Individual bits reader from a slice of bytes")
    (description "BitReader helps reading individual bits from a slice of
bytes.  You can read an arbitrary numbers of bits from the byte slice, for
example 13 bits at once.  The reader internally keeps track of position within
the buffer.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitstream-io-1
  (package
    (name "rust-bitstream-io")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitstream-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01pyk3pipwcbaghi7f0lmp3izjl902cv21yf4b1v5nipkrrrqlq3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/tuffy/bitstream-io")
    (synopsis "Read/write un-aligned values from big or little-endian streams")
    (description
     "This package is a library for reading/writing un-aligned values from/to
streams in big-endian and little-endian formats.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitstream-io-0.8
  (package
    (inherit rust-bitstream-io-1)
    (name "rust-bitstream-io")
    (version "0.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitstream-io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00a6wy54s1dmadm5xz8k2cbsd7ixvm48mlc45bk0fdy0pbra6jk1"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-bitvec-0.22
  (package
    (name "rust-bitvec")
    (version "0.22.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09xm84dg04y8k3cm7aa81n2xfvcnidahx0qpqc60l4w6ih5g0dsj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-1)
        ("rust-radium" ,rust-radium-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.4))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://bitvecto-rs.github.io/bitvec")
    (synopsis "Manipulate memory, bit by bit")
    (description
     "This package provides a crate for manipulating memory, bit by bit.")
    (license license:expat)))

(define-public rust-bitvec-0.20
  (package
    (inherit rust-bitvec-0.22)
    (name "rust-bitvec")
    (version "0.20.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitvec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j3qn0z31j06c965hs3kh41l78hxbzzsf1h46xvs3ym48i1i8x3p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-1.1)
        ("rust-radium" ,rust-radium-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.2))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))))

(define-public rust-bitvec-0.19
  (package
    (inherit rust-bitvec-0.22)
    (name "rust-bitvec")
    (version "0.19.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10bz751jbsy8fj203ibjwil07p2fwfzvx7b326wfssaravlkbfm7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-1.1)
        ("rust-radium" ,rust-radium-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))))

(define-public rust-blake2-0.9
  (package
    (name "rust-blake2")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blake2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x7i67c0hn3bzcwny08rgjrrnarqnqw10qpmh2blbx9hd78kfkha"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-opaque-debug" ,rust-opaque-debug-0.3))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/RustCrypto/hashes")
    (synopsis "BLAKE2 hash functions")
    (description "This package provides BLAKE2 hash functions in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blake2-0.8
  (package
    (name "rust-blake2")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blake2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c4k11j04kqhkci6i9b7lz6p13kpcv228pdqixgrawvavaq0gjwl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byte-tools" ,rust-byte-tools-0.3)
        ("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-digest" ,rust-digest-0.8)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-digest" ,rust-digest-0.8)
        ("rust-hex-literal" ,rust-hex-literal-0.1))))
    (home-page "https://github.com/RustCrypto/hashes")
    (synopsis "BLAKE2 hash functions")
    (description "This package provides BLAKE2 hash functions in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blake2b-simd-0.5
  (package
    (name "rust-blake2b-simd")
    (version "0.5.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blake2b-simd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12icvk8ixlivv3jv5nyrg01sajp4s279zb1kmif0nfja4ms2vyyq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arrayref" ,rust-arrayref-0.3)
        ("rust-arrayvec" ,rust-arrayvec-0.5)
        ("rust-constant-time-eq" ,rust-constant-time-eq-0.1))))
    (home-page "https://github.com/oconnor663/blake2_simd")
    (synopsis "Pure Rust BLAKE2b implementation with dynamic SIMD")
    (description
     "This package provides a pure Rust implementation of the BLAKE2b and
BLAKE2bp hash functions.")
    (license license:expat)))

(define-public rust-blakeout-0.3
  (package
    (name "rust-blakeout")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blakeout" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dxcg3sjxd82mn7mq4ammrfpidqf9zsagvhfzgblsi8g4b2fgvw1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blake2" ,rust-blake2-0.9)
        ("rust-digest" ,rust-digest-0.9))))
    (home-page "https://github.com/Revertron/Blakeout")
    (synopsis "Memory hard hashing algorithm based on Blake2s")
    (description "This package provides memory hard hashing algorithm
based on Blake2s.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blobby-0.3
  (package
    (name "rust-blobby")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blobby" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v7a6lzxbvrxpnk2jv895315v7yas1cvk26mmbl90ylp1719ax44"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-hex" ,rust-hex-0.4))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Iterator over simple binary blob storage")
    (description "This package provides an iterator over simple binary blob
storage.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blobby-0.1
  (package
    (inherit rust-blobby-0.3)
    (name "rust-blobby")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blobby" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xicpf3s2mi5xqnx8ps5mdych4ib5nh2nfsbrsg8ar8bjk1girbg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-hex" ,rust-hex-0.3))))))

(define-public rust-block-0.1
  (package
    (name "rust-block")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16k9jgll25pzsq14f244q22cdv0zb4bqacldg3kx6h89d7piz30d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-objc-test-utils" ,rust-objc-test-utils-0.0))))
    (home-page "https://github.com/SSheldon/rust-block")
    (synopsis "Rust interface for Apple's C language extension of blocks")
    (description "This package provides a rust interface for Apple's C language
extension of blocks.")
    (license license:expat)))

(define-public rust-block-buffer-0.10
  (package
    (name "rust-block-buffer")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-buffer" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "15cbh9jbcfcbbi863dlmamjka2f8l55ld915vr0b0xlf0l16mlzi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Fixed size buffer for block processing of data")
    (description
     "Fixed size buffer for block processing of data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-buffer-0.9
  (package
    (inherit rust-block-buffer-0.10)
    (name "rust-block-buffer")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1r4pf90s7d7lj1wdjhlnqa26vvbm6pnc33z138lxpnp9srpi2lj1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.2)
        ("rust-generic-array" ,rust-generic-array-0.14))))))

(define-public rust-block-buffer-0.7
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12v8wizynqin0hqf140kmp9s38q223mp1b0hkqk8j5pk8720v560"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.1)
        ("rust-byte-tools" ,rust-byte-tools-0.3)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-generic-array" ,rust-generic-array-0.12))))))

(define-public rust-block-buffer-0.3
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1axki8f4rhnxvk6hlli4i53sgmi7c15ffryrv4757nzcp6cc4xm0"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arrayref" ,rust-arrayref-0.3)
        ("rust-byte-tools" ,rust-byte-tools-0.2))))))

(define-public rust-block-buffer-0.2
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "055q90a6vk80j85i3fixjd5ci0dznrm9lkdd6xbjk7sx5w2a2f8k"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byte-tools" ,rust-byte-tools-0.2)
        ("rust-generic-array" ,rust-generic-array-0.8))))))

(define-public rust-block-cipher-0.7
  (package
    (name "rust-block-cipher")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-cipher" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "043zgfz1x4sxkdcsyabrcr440fcwhfpcqqa54jm7zp35wx4n84zs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for description of block ciphers")
    (description "This package provides traits for description of block
ciphers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-cipher-trait-0.6
  (package
    (name "rust-block-cipher-trait")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-cipher-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x273w6fwka0i48nrv428birdrs2jz6jdnmc0dhc1rq9pm4lv4hw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.12))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Block cipher algorithms")
    (description "This package provides a collection of block cipher
algorithms.  This package is deprecated.  Please use block-cipher instead.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-cipher-trait-0.4
  (package
    (inherit rust-block-cipher-trait-0.6)
    (name "rust-block-cipher-trait")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-cipher-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10qmg8vphqmfllb9a2yx6s7r66jh1wh33clhsawq7ikg2wgz2p6q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.8))))))

(define-public rust-block-modes-0.8
  (package
    (name "rust-block-modes")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-modes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13id7rw1lhi83i701za8w5is3a8qkf4vfigqw3f8jp8mxldkvc1c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.2)
        ("rust-cipher" ,rust-cipher-0.3))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Block cipher modes of operation")
    (description "This package provides a collection of block ciphers
and block modes.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-modes-0.7
  (package
    (inherit rust-block-modes-0.8)
    (name "rust-block-modes")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-modes" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w3jc3n7k4xq98b9mfina4wwpg1fq1s3b0mm5whqialb7q3yi82p"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.2)
        ("rust-cipher" ,rust-cipher-0.2))
       #:cargo-development-inputs
       (("rust-aes" ,rust-aes-0.6)
        ("rust-hex-literal" ,rust-hex-literal-0.2))))))

(define-public rust-block-padding-0.2
  (package
    (name "rust-block-padding")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-padding" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x6b2dgink7rc3755r8jl4kmndydy5563h3wz7z9jqrb25ygv2y9"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Padding and unpadding of messages divided into blocks")
    (description
     "Padding and unpadding of messages divided into blocks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-padding-0.1
  (package
    (inherit rust-block-padding-0.2)
    (name "rust-block-padding")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-padding" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02fz9wx5dmgpc79ndrb9xfxqlrkk7lg5wki2blz2zqg27spw6kbd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byte-tools" ,rust-byte-tools-0.3))))))

(define-public rust-blocking-1
  (package
    (name "rust-blocking")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s9myg9gqmwzrbc38p23bh4vkc8w4pbpddqrcrrl1xz1xpdp1qf5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-task" ,rust-async-task-4)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/stjepang/blocking")
    (synopsis "Thread pool for isolating blocking I/O in async programs")
    (description
     "This package provides a thread pool for isolating blocking I/O in async
programs.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-blocking-0.6
  (package
    (inherit rust-blocking-1)
    (name "rust-blocking")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13g1xlsd1ardf9wxkj1d03baxfy8f8kvgjz55l6zi1q4jn5f0c1z"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-blocking-0.4
  (package
    (inherit rust-blocking-0.6)
    (name "rust-blocking")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0av1h5p6lb5bpzghmzsksx31icvdwrpxxzkq6r56n1l5pzvqyinj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-futures-lite" ,rust-futures-lite-0.1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking" ,rust-parking-1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-boxfnonce-0.1
  (package
    (name "rust-boxfnonce")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "boxfnonce" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09ilf4zyx92hyhkxlsxksfyprzr9iwq5gqqb22aaqr32c8fwp22r"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/stbuehler/rust-boxfnonce")
    (synopsis "Safe FnOnce boxing for Rust")
    (description "This package provides a safe FnOnce boxing for Rust.")
    (license license:expat)))

(define-public rust-boxxy-0.11
  (package
    (name "rust-boxxy")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "boxxy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10p8i30ri9rhrmlbdxp9s4k4fgsjq6q6b1x2ncchli1ad6psylms"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-bufstream" ,rust-bufstream-0.1)
        ("rust-caps" ,rust-caps-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clap" ,rust-clap-2)
        ("rust-errno" ,rust-errno-0.2)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-hyper" ,rust-hyper-0.12)
        ("rust-hyper-rustls" ,rust-hyper-rustls-0.17)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libflate" ,rust-libflate-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.15)
        ("rust-pledge" ,rust-pledge-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-rustyline" ,rust-rustyline-5)
        ("rust-sha2" ,rust-sha2-0.8)
        ("rust-tar" ,rust-tar-0.4)
        ("rust-tokio-core" ,rust-tokio-core-0.1)
        ("rust-url" ,rust-url-2)
        ("rust-webpki" ,rust-webpki-0.21))
       #:cargo-development-inputs
       (("rust-ctrlc" ,rust-ctrlc-3)
        ("rust-elf" ,rust-elf-0.0.10)
        ("rust-env-logger" ,rust-env-logger-0.6))))
    (home-page "https://github.com/kpcyrd/boxxy-rs")
    (synopsis "Linkable sandbox explorer")
    (description
     "This library provides an interactive shell that can be linked into a
program to verify sandboxing measures are adequate.")
    (license license:lgpl3)))

(define-public rust-bresenham-0.1
  (package
    (name "rust-bresenham")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bresenham" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mvg3zcyll0m3z79jwbg183ha4kb7bw06rd286ijwvgn4mi13hdz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mbr/bresenham-rs")
    (synopsis
     "Iterator-based integer-only implementation of Bresenham's line algorithm")
    (description
     "This package provides a fast, iterator-based integer-only implementation of
Bresenham's line algorithm.")
    (license license:expat)))

(define-public rust-broadcaster-0.2
  (package
    (name "rust-broadcaster")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "broadcaster" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1848lwapy955rs8kbiv87adj68vdlh6vlj8n4wq10vx541j49887"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-futures-executor-preview" ,rust-futures-executor-preview-0.3))))
    (home-page "https://github.com/leo60228/broadcaster")
    (synopsis "Broadcasting futures mpmc channel")
    (description
     "This package provides a wrapper for any Stream and Sink implementing the
@code{mpsc} pattern to enable broadcasting items.")
    (license (list license:expat license:asl2.0))))

(define-public rust-brotli-3
  (package
    (name "rust-brotli")
    (version "3.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0gk1g3fx1vps2ic8kh5n32gzq9h5w1j3ff6lvjm171ph428r2abz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2)
        ("rust-alloc-stdlib" ,rust-alloc-stdlib-0.2)
        ("rust-brotli-decompressor" ,rust-brotli-decompressor-2)
        ("rust-packed-simd" ,rust-packed-simd-0.3)
        ("rust-sha2" ,rust-sha2-0.8))))
    (home-page "https://github.com/dropbox/rust-brotli")
    (synopsis "Brotli compressor and decompressor")
    (description "This package provides a brotli compressor and decompressor
with no dependency on the rust stdlib.  This makes it suitable for embedded
devices and kernels.")
    (license (list license:bsd-3 license:expat))))

(define-public rust-brotli-decompressor-2
  (package
    (name "rust-brotli-decompressor")
    (version "2.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli-decompressor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "102v89h9z0p45j5fsjna97761nxx9nxz9ccpwxma6p5zad32vbar"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2)
        ("rust-alloc-stdlib" ,rust-alloc-stdlib-0.2))))
    (home-page "https://github.com/dropbox/rust-brotli-decompressor")
    (synopsis "Brotli decompressor")
    (description "This package provides a brotli decompressor with no
dependency on the rust stdlib.  This makes it suitable for embedded devices
and kernels.")
    (license (list license:bsd-3 license:expat))))

(define-public rust-brotli-sys-0.3
  (package
    (name "rust-brotli-sys")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kdfdbcba6zwa13xpjwgiplblkdf6vigxjbwwp6l2ascbylxwia4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/alexcrichton/brotli2-rs")
    (synopsis "Raw bindings to libbrotli")
    (description "This package provides raw bindings to libbrotli.")
    (license (list license:expat license:asl2.0))))

(define-public rust-brotli2-0.3
  (package
    (name "rust-brotli2")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13jnhpmfkqy2xar4lxrsk3rx3i12bgnarnsxq4arhc6yxb1kdc0c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-brotli-sys" ,rust-brotli-sys-0.3)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.4))))
    (home-page "https://github.com/alexcrichton/brotli2-rs")
    (synopsis "Rust bindings to compression library libbrotli")
    (description
     "This package provides bindings to libbrotli to provide brotli
decompression and compression to Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bs58-0.2
  (package
    (name "rust-bs58")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bs58" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "125i962x0m0ggdif6ds51wfif2lypiicy469dj5j2l6rm6xycpn9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-sha2" ,rust-sha2-0.8))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-base58" ,rust-base58-0.1)
        ("rust-rust-base58" ,rust-rust-base58-0.0))))
    (home-page "https://github.com/mycorrhiza/bs58-rs")
    (synopsis "Another Base58 codec implementation")
    (description
     "Another Base58 codec implementation.  Compared to the base58 crate this
is significantly faster at decoding (about 2.4x as fast when decoding 32
bytes), almost the same speed for encoding (about 3% slower when encoding 32
bytes), doesn't have the 128 byte limitation and supports a configurable
alphabet.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bson-2
  (package
    (name "rust-bson")
    (version "2.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bson" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0ff1xj1vgh2l6sl5gqhkgsfkbhh11jkwd5wf3h0f0mrbg1kd8n7z"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-ahash" ,rust-ahash-0.7)
         ("rust-base64" ,rust-base64-0.13)
         ("rust-chrono" ,rust-chrono-0.4)
         ("rust-hex" ,rust-hex-0.4)
         ("rust-indexmap" ,rust-indexmap-1)
         ("rust-lazy-static" ,rust-lazy-static-1)
         ("rust-rand" ,rust-rand-0.8)
         ("rust-serde" ,rust-serde-1)
         ("rust-serde-bytes" ,rust-serde-bytes-0.11)
         ("rust-serde-json" ,rust-serde-json-1)
         ("rust-uuid" ,rust-uuid-0.8))))
    (home-page "https://github.com/mongodb/bson-rust")
    (synopsis "Encoding and decoding support for BSON in Rust")
    (description
     "This crate provides encoding and decoding support for BSON.")
    (license license:expat)))

(define-public rust-bstr-0.2
  (package
    (name "rust-bstr")
    (version "0.2.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bstr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08rjbhysy6gg27db2h3pnhvr2mlr5vkj797i9625kwg8hgrnjdds"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex-automata" ,rust-regex-automata-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-ucd-parse" ,rust-ucd-parse-0.1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/BurntSushi/bstr")
    (synopsis
     "String type that is not required to be valid UTF-8")
    (description
     "This package provides a string type that is not required to be valid
UTF-8.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buf-redux-0.8
  (package
    (name "rust-buf-redux")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buf_redux" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zy0p4vd2kjk7z5m4m8kdwhs5cmx1z02n7v36njhgfs8fs4aclxr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-memchr" ,rust-memchr-2)
        ("rust-safemem" ,rust-safemem-0.3)
        ("rust-slice-deque" ,rust-slice-deque-0.2))))
    (home-page "https://github.com/abonander/buf_redux")
    (synopsis "Drop-in replacements for buffered I/O in @code{std::io}")
    (description
     "This package provides drop-in replacements for buffered I/O in
@code{std::io}, with extra features.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buffered-reader-1
  (package
    (name "rust-buffered-reader")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffered-reader" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jf6iqxm3yllm9h3q5f90yj8y9qzr5h0a7aiw38cgk4hagh2s8d4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bzip2" ,rust-bzip2-0.4)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://sequoia-pgp.org/")
    (synopsis "Super-powered Reader")
    (description
     "Like the @code{BufRead} trait, the @code{BufferedReader} trait has an
internal buffer that is directly exposed to the user.  This design enables two
performance optimizations.  First, the use of an internal buffer amortizes
system calls.  Second, exposing the internal buffer allows the user to work
with data in place, which avoids another copy.")
    (license license:gpl3)))

(define-public rust-buffered-reader-0.9
  (package
    (inherit rust-buffered-reader-1)
    (name "rust-buffered-reader")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffered-reader" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05rklfiia1k4c4ifpim08l22i0q0l3j9xdg2yh3njrp6w58z6z13"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bzip2" ,rust-bzip2-0.3)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-libc" ,rust-libc-0.2))))))

(define-public rust-buffering-0.4
  (package
    (name "rust-buffering")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wmgy84j5scbndzx7mccz07z34n98fwnfah1zd5kzqjaif5iqk76"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-buffering-nocopy-macro" ,rust-buffering-nocopy-macro-0.2))))
    (home-page "https://github.com/jbaublitz/buffering")
    (synopsis "Library primarily designed for network packet buffer operations")
    (description
     "This package provides a library primarily designed for network packet
buffer operations.")
    (license license:bsd-3)))

(define-public rust-buffering-0.3
  (package
    (inherit rust-buffering-0.4)
    (name "rust-buffering")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11cyq2nm569j028g93jxk00h8nfwc3l6n3hqw79w34na01p3lq97"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-buffering-nocopy-macro" ,rust-buffering-nocopy-macro-0.1))))))

(define-public rust-buffering-nocopy-macro-0.2
  (package
    (name "rust-buffering-nocopy-macro")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering_nocopy_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a8zs7s5z0f977g7zx95b8sf8gqa8iwh13rj639wk080d00l5kaa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/jbaublitz/buffering")
    (synopsis "Proc-macro crate for buffering")
    (description "This package provides a proc-macro crate for buffering.")
    (license license:bsd-3)))

(define-public rust-buffering-nocopy-macro-0.1
  (package
    (inherit rust-buffering-nocopy-macro-0.2)
    (name "rust-buffering-nocopy-macro")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering_nocopy_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03b6wp4i3273jzw2nbnrnddlxyma3p465y2dszx6vc3ysq0fdlj7"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.14))))))

(define-public rust-bufstream-0.1
  (package
    (name "rust-bufstream")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bufstream" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1j7f52rv73hd1crzrrfb9dr50ccmi3hb1ybd6s5dyg6jmllqkqs0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1))))
    (home-page "https://github.com/alexcrichton/bufstream")
    (synopsis "I/O streams with separate read/write buffers")
    (description
     "This package provides buffered I/O for streams where each read/write
half is separately buffered.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bugreport-0.4
  (package
    (name "rust-bugreport")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bugreport" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gday6f2brqgzl12a0vf7fx1hh1mim6gdjxc6dfwk9v4i19pxsd0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-git-version" ,rust-git-version-0.3)
        ("rust-shell-escape" ,rust-shell-escape-0.1)
        ("rust-sys-info" ,rust-sys-info-0.9))))
    (home-page "https://github.com/sharkdp/bugreport")
    (synopsis "Collect system and environment information for bug reports")
    (description
     "bugreport is a Rust library that helps application developers to
automatically collect information about the system and the environment that
users can send along with a bug report.")
    (license (list license:expat license:asl2.0))))

(define-public rust-build-const-0.2
  (package
    (name "rust-build-const")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "build_const" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0faz882spx9474cszay2djmb0lghbwq51qayabcar1s7g4r2l29r"))))
    (build-system cargo-build-system)
    (home-page "https://crates.io/crates/build_const")
    (synopsis "Create importable constants from build.rs or a script")
    (description "This package provides a library for creating importable
constants from build.rs or a script.")
    (license license:expat)))

(define-public rust-bumpalo-3
  (package
    (name "rust-bumpalo")
    (version "3.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bumpalo" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ccn025n0x1gc0ijjlabin2xs7dkx5yfagkskr93yw9c06pyfncw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ;cargo_readme_up_to_date test fails
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/fitzgen/bumpalo")
    (synopsis "Fast bump allocation arena for Rust")
    (description
     "This package provides a fast bump allocation arena for Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bv-0.11
  (package
    (name "rust-bv")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h5kbl54fsccznfixw83xndbripw39y2qkqjwf709p75iqfvnd48"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-feature-probe" ,rust-feature-probe-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6))))
    (home-page "https://github.com/tov/bv-rs")
    (synopsis "Bit-vectors and bit-slices")
    (description "The main type exported by this library, @code{BitVec}, is a
packed, growable bit-vector.  Its API mirrors that of @code{Vec} where
reasonable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-byte-pool-0.2
  (package
    (name "rust-byte-pool")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-pool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yh96ral0pni02bzm3fhvicp1ixz1hz3c5m03hsyq66mk61fjf0y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-queue" ,rust-crossbeam-queue-0.2)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://crates.io/crates/byte-pool")
    (synopsis "Pool of byte slices, for efficient memory usage")
    (description
     "This package provides a pool of byte slices, for efficient
memory usage.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-byte-slice-cast-1
  (package
    (name "rust-byte-slice-cast")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "byte-slice-cast" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "162618ai9pnsim49lkjpq2yi2b3wssclvqxwwycw8xrbb58wfc0x"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sdroege/bytes-num-slice-cast")
    (synopsis
      "Safely cast bytes slices from/to slices of built-in fundamental numeric types")
    (description "This Rust library enables safely cast bytes slices from/to slices
of built-in fundamental numeric types.")
    (license license:expat)))

(define-public rust-byte-tools-0.3
  (package
    (name "rust-byte-tools")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-tools" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mqi29wsm8njpl51pfwr31wmpzs5ahlcb40wsjyd92l90ixcmdg3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Bytes related utility functions")
    (description "Bytes related utility functions.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-byte-tools-0.2
  (package
    (inherit rust-byte-tools-0.3)
    (name "rust-byte-tools")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-tools" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h2zxygfnn46akmgh8cdp4x6xy4kb0b45rzmj76rxa0j99bk432n"))))))

(define-public rust-byte-unit-4
  (package
    (name "rust-byte-unit")
    (version "4.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-unit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lxi11qf6h1rqr0yhsh7i6755l325qrkv9r4bgismyik531mi1qw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-utf8-width" ,rust-utf8-width-0.1))))
    (home-page "https://magiclen.org/byte-unit")
    (synopsis "Library for interaction with units of bytes")
    (description
     "This package provides a library for interaction with units of bytes.")
    (license license:expat)))

(define-public rust-bytecheck-0.5
  (package
    (name "rust-bytecheck")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecheck" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q11ap6nqj0rsc8ypwjh918916zlrcrzdgqm175gnpb2yn9axyh1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytecheck-derive" ,rust-bytecheck-derive-0.5)
        ("rust-log" ,rust-log-0.4)
        ("rust-ptr-meta" ,rust-ptr-meta-0.1)
        ("rust-simdutf8" ,rust-simdutf8-0.1))))
    (home-page "https://github.com/rkyv/bytecheck")
    (synopsis "Type validation framework")
    (description "This package provides a type validation framework for
Rust.")
    (license license:expat)))

(define-public rust-bytecheck-derive-0.5
  (package
    (name "rust-bytecheck-derive")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecheck_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0grbkwwv5j91n7zrimci6fh4k79flxga3mkjg50jysnyraizi088"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rkyv/bytecheck")
    (synopsis "Derive macro for bytecheck")
    (description "This package provides a Derive macro for bytecheck, the type
validation framework for Rust.")
    (license license:expat)))

(define-public rust-bytecount-0.6
  (package
    (name "rust-bytecount")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecount" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0vplsx73zncb7mz8x0fs3k0p0rz5bmavj09vjk5nqn4z6fa7h0dh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/llogiq/bytecount")
    (synopsis "Count occurrences of a given byte")
    (description
     "Count occurrences of a given byte, or the number of UTF-8 code points,
in a byte slice, fast.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bytecount-0.5
  (package
    (inherit rust-bytecount-0.6)
    (name "rust-bytecount")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecount" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0z6a280kiy4kg5v3qw97pbyvwycr17fsm41804i8zpq7nmads3xy"))))
    (arguments
     `(#:cargo-inputs
       (("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-bytecount-0.4
  (package
    (inherit rust-bytecount-0.5)
    (name "rust-bytecount")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytecount" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "13qpy38z5wx0rzcdvr2h0ixbfgi1dbrif068il3hwn3k2mah88mr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-bytemuck-1.5
  (package
    (name "rust-bytemuck")
    (version "1.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18355qn3r9yp7ibg00r688sjx58g2qsjylwyq15w5b41b46asjss"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytemuck-derive" ,rust-bytemuck-derive-1))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Crate for mucking around with piles of bytes")
    (description
     "This package provides a crate for mucking around with piles of bytes.")
    (license license:zlib)))

(define-public rust-bytemuck-1
  (package
    (name "rust-bytemuck")
    (version "1.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "071043n73hwi55z9c55ga4v52v8a7ri56gqja8r98clkdyxns14j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytemuck-derive" ,rust-bytemuck-derive-1))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Crate for mucking around with piles of bytes")
    (description
     "This package provides a crate for mucking around with piles of bytes.")
    (license license:zlib)))

(define-public rust-bytemuck-derive-1
  (package
    (name "rust-bytemuck-derive")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck-derive" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1k59b6g2d87nf32qwhp73vng3al0zklxg64iiwf0pkxy74xf5ni8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-bytemuck" ,rust-bytemuck-1))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Derive proc-macros for @code{bytemuck}")
    (description
     "This package derives proc-macros for the @code{bytemuck} crate.")
    (license
      (list license:zlib license:asl2.0 license:expat))))

(define-public rust-byteorder-1
  (package
    (name "rust-byteorder")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/BurntSushi/byteorder")
    (synopsis "Reading/writing numbers in big-endian and little-endian")
    (description
     "This library is used for reading or writing numbers in big-endian and
little-endian.")
    (license (list license:expat license:unlicense))))

(define-public rust-byteorder-0.5
  (package
    (inherit rust-byteorder-1)
    (name "rust-byteorder")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ma8pkyz1jbglr29m1yzlc9ghmv6672nvsrn7zd0yn5jqs60xh8g"))))
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bytes-1
  (package
    (name "rust-bytes")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y70b249m02lfp0j6565b29kviapj4xsl9whamcqwddnp9kjv1y4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-loom" ,rust-loom-0.4)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/tokio-rs/bytes")
    (synopsis "Types and traits for working with bytes")
    (description "This package is a utility library for working with bytes.")
    (license license:expat)))

(define-public rust-bytes-0.6
  (package
    (inherit rust-bytes-1)
    (name "rust-bytes")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05ivrcbgl4f7z2zzm9hbsi8cy66spi70xlm6fp16zsq4ylsvrp70"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-loom" ,rust-loom-0.3)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-bytes-0.5
  (package
    (inherit rust-bytes-0.6)
    (name "rust-bytes")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f5s7xq6qzmdh22ygsy8v0sp02m51y0radvq4i4y8cizy1lfqk0f"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))))))

(define-public rust-bytes-0.4
  (package
    (inherit rust-bytes-0.5)
    (name "rust-bytes")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0768a55q2fsqdjsvcv98ndg9dq7w2g44dvq1avhwpxrdzbydyvr0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-either" ,rust-either-1)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-bytes-0.3
  (package
    (inherit rust-bytes-0.4)
    (name "rust-bytes")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytes" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09vcp9kh12pva2xn2ir79k90v1a0id8f4sdv1abn5ifw2bqsyaf1"))))
    (arguments
     `(#:tests? #f      ; Tests not distributed in crate.
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bytestring-0.1
  (package
    (name "rust-bytestring")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytestring" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qzkncgky5p5vsdb9msmfg6d92dcs9idcjcr5nk7inkja7x0az7w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://actix.rs")
    (synopsis "UTF-8 encoded string with Bytes as a storage")
    (description
     "This package provides a UTF-8 encoded string with Bytes as a storage.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bzip2-0.4
  (package
    (name "rust-bzip2")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bzip2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gpwm7qj8adi0zffm8r17vkv6f98d1q9glvpjk28v0wb6kz88p97"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bzip2-sys" ,rust-bzip2-sys-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-partial-io" ,rust-partial-io-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-tokio-core" ,rust-tokio-core-0.1))))
    (home-page "https://github.com/alexcrichton/bzip2-rs")
    (synopsis
     "Rust bindings to libbzip2 for bzip2 compression and decompression")
    (description
     "Bindings to @code{libbzip2} for @code{bzip2} compression and decompression
exposed as Reader/Writer streams.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bytesize-1
  (package
    (name "rust-bytesize")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytesize" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0w7wmmbcirxp5isza0i1lxq5d7r7f0z1pxbxl5f6s1n5m8vfqn3c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/hyunsik/bytesize/")
    (synopsis "Human-readable byte count representation library for Rust")
    (description "ByteSize is an utility for human-readable byte count
representation, with support for both SI and binary units.")
    (license license:asl2.0)))

(define-public rust-bzip2-0.3
  (package
    (inherit rust-bzip2-0.4)
    (name "rust-bzip2")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bzip2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fvfwanp42j1zpig880jhb5mc0na50bijmwd6211p77sy35w7ds2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bzip2-sys" ,rust-bzip2-sys-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-partial-io" ,rust-partial-io-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-tokio-core" ,rust-tokio-core-0.1))))))

(define-public rust-bzip2-sys-0.1
  (package
    (name "rust-bzip2-sys")
    (version "0.1.9+1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bzip2-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pi8lxzb1104q9cpvv1jgnk909cggqh2zcdhywqwlbq6c2i3jfxd"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (delete-file-recursively "bzip2-1.0.8")
            (delete-file "build.rs")
            ;; Inspired by Debian's patch.
            (with-output-to-file "build.rs"
              (lambda _
                (format #t "fn main() {~@
                        println!(\"cargo:rustc-link-lib=bz2\");~@
                        }~%")))
            #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/alexcrichton/bzip2-rs")
    (synopsis "Rust bindings to libbzip2")
    (description
     "Bindings to @code{libbzip2} for bzip2 compression and decompression
exposed as Reader/Writer streams.")
    (license (list license:expat license:asl2.0))))

(define-public rust-c-linked-list-1
  (package
    (name "rust-c-linked-list")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "c_linked_list" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jvjr3233wqgx6li65kciqpg354pvb0cv1i8hc71ka5lsf5m2r29"))))
    (build-system cargo-build-system)
    (home-page "https://canndrew.org/rust-doc/c_linked_list/")
    (synopsis "Utilities for handling NULL-terminated C linked lists")
    (description "This package provides utilities for handling
NULL-terminated C linked lists.")
    (license (list license:expat license:bsd-3))))

(define-public rust-c2-chacha-0.2
  (package
    (name "rust-c2-chacha")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "c2-chacha" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00a11qdc8mg3z0k613rhprkc9p6xz0y7b1681x32ixg0hr3x0r3x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-ppv-lite86" ,rust-ppv-lite86-0.2)
        ("rust-stream-cipher" ,rust-stream-cipher-0.3))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/cryptocorrosion/cryptocorrosion")
    (synopsis "The ChaCha family of stream ciphers")
    (description
     "The ChaCha family of stream ciphers.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cache-padded-1
  (package
    (name "rust-cache-padded")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cache-padded" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fkdwv9vjazm6fs3s5v56mm4carwswdmw8fcwm9ygrcvihcya6k3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stjepang/cache-padded")
    (synopsis "Prevent once piece of data invalidating other cached data")
    (description
     "In concurrent programming, sometimes it is desirable to make sure
commonly accessed shared data is not all placed into the same cache line.
Updating an atomic value invalides the whole cache line it belongs to, which
makes the next access to the same cache line slower for other CPU cores.  Use
CachePadded to ensure updating one piece of data doesn't invalidate other
cached data.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-calamine-0.18
  (package
    (name "rust-calamine")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calamine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fssrwkwar1z4d2f0xl3cqg2y8qlmlc05g5xy305mkmxlj6sfv5q"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-codepage" ,rust-codepage-0.1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-quick-xml" ,rust-quick-xml-0.19)
        ("rust-serde" ,rust-serde-1)
        ("rust-zip" ,rust-zip-0.5))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-glob" ,rust-glob-0.3))))
    (home-page "https://github.com/tafia/calamine")
    (synopsis "Reader and deserializer for spreadsheet files")
    (description
     "@code{calamine} is a pure Rust library to read and deserialize any
spreadsheet file.")
    (license license:expat)))

(define-public rust-calloop-0.9
  (package
    (name "rust-calloop")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10mbcsd7fj3cg0a463h3003wycv955cnj4pm2gla2sp5xxhyqbmz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;XXX fails without stdin, fixed in 0.11
       #:cargo-inputs
       (("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.22))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3))))
    (home-page "https://github.com/Smithay/calloop")
    (synopsis "Callback-based event loop")
    (description "This package provides a callback-based event loop.")
    (license license:expat)))

(define-public rust-calloop-0.6
  (package
    (inherit rust-calloop-0.9)
    (name "rust-calloop")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z3jlsv3g28097dhsmi2l8nzkd3p937jhb4pg52njhb0wxkn20qb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.18))))))

(define-public rust-calloop-0.4
  (package
    (inherit rust-calloop-0.6)
    (name "rust-calloop")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0q6ic9lr0s86886mbyn4yncg68b2sykgwjf3iygdw01swmxhk8ks"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (substitute* "Cargo.toml"
              (("=1.0.0") "^1.0.0"))
            #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2)
        ("rust-nix" ,rust-nix-0.14))
       #:cargo-development-inputs
       (("rust-lazycell" ,rust-lazycell-1))))))

(define-public rust-camino-1
  (package
    (name "rust-camino")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "camino" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07jc2jsyyhd2d0clpr0ama61b2hv09qzbfba2mx27pc87qg0xbc8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proptest" ,rust-proptest-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page
     "https://github.com/withoutboats/camino")
    (synopsis "UTF-8 paths")
    (description "This package provides a UTF-8 paths.")
    (license (list license:expat license:asl2.0))))

(define-public rust-canonical-path-2
  (package
    (name "rust-canonical-path")
    (version "2.0.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "canonical-path" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0vvsjda6ka5nz8zvx6r08zqi0j59sjccgcbjxj96xj764w9y1sg6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t))
    (home-page "https://github.com/iqlusioninc/crates/")
    (synopsis "Path and PathBuf-like types for canonical filesystem paths")
    (description
     "This package provides Path and PathBuf-like types for representing
canonical filesystem paths.")
    (license license:asl2.0)))

(define-public rust-capnp-0.13
  (package
    (name "rust-capnp")
    (version "0.13.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bx2pj0ysmyd1ryd5s43m3c7n5k067x1aciqiiyg4kjswlcs6xjf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Runtime library for Cap'n Proto data encoding")
    (description "This package provides a runtime library for Cap'n Proto data
encoding.")
    (license license:expat)))

(define-public rust-capnp-futures-0.13
  (package
    (name "rust-capnp-futures")
    (version "0.13.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp-futures" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18q93ncbfcnjq7zhvy9idnifypmi2qcp775q7454y3r4lvvdcyyw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.13)
        ("rust-futures" ,rust-futures-0.3))
       #:cargo-development-inputs
       (("rust-capnp" ,rust-capnp-0.13)
        ("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Async serialization for Cap'n Proto messages")
    (description "This package provides async serialization for Cap'n Proto
messages.")
    (license license:expat)))

(define-public rust-capnp-rpc-0.13
  (package
    (name "rust-capnp-rpc")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp-rpc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17p0y0yk68pzsnpmaklhiqrrlrrv0ld8nhbg4qflmgibshi8b69p"))))
    (build-system cargo-build-system)
    (native-inputs
     (list capnproto))
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.13)
        ("rust-capnp-futures" ,rust-capnp-futures-0.13)
        ("rust-futures" ,rust-futures-0.3))
       #:cargo-development-inputs
       (("rust-capnpc" ,rust-capnpc-0.13))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Cap'n Proto remote procedure call protocol implementation")
    (description "This package provides an implementation of the Cap'n Proto
remote procedure call protocol")
    (license license:expat)))

(define-public rust-capnpc-0.13
  (package
    (name "rust-capnpc")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnpc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hbm5xqpam3f0ha5ds39wjmpqpzdalpbrls9wlp7m3slh3p5r1c1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-capnp" ,rust-capnp-0.13))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Cap'n Proto code generation")
    (description "Cap'n Proto code generation")
    (license license:expat)))

(define-public rust-caps-0.5
  (package
    (name "rust-caps")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "caps" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h4m9s09plj85y5lb5j9hck36r8w63ifpc9s09mzi0zjvvfz5260"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-errno" ,rust-errno-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/lucab/caps-rs")
    (synopsis "Pure-Rust library to work with Linux capabilities")
    (description
     "This package provides a pure-Rust library to work with Linux
capabilities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-caps-0.3
  (package
    (inherit rust-caps-0.5)
    (name "rust-caps")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "caps" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vplgzx8nifzr3f0l8ca77jqnz3fdymdg0ickacgdvawc44a3n90"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-errno" ,rust-errno-0.2)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-libc" ,rust-libc-0.2))))))

(define-public rust-cargo-0.53
  (package
    (name "rust-cargo")
    (version "0.53.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12ns9v4dd8vnvsaqgd897h2zc19w00i5ii3slda653zbhfzm6zna"))))
    (build-system cargo-build-system)
    (arguments
     `(;; The test suite is disabled as the internal 'cargo-test-macro' and
       ;; 'cargo-test-support' crates are not included in the release.
       #:tests? #f
       #:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-bytesize" ,rust-bytesize-1)
        ("rust-cargo-platform" ,rust-cargo-platform-0.1)
        ("rust-clap" ,rust-clap-2)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-crates-io" ,rust-crates-io-0.33)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-crypto-hash" ,rust-crypto-hash-0.3)
        ("rust-curl" ,rust-curl-0.4)
        ("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-fwdansi" ,rust-fwdansi-1)
        ("rust-git2" ,rust-git2-0.13)
        ("rust-git2-curl" ,rust-git2-curl-0.14)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-home" ,rust-home-0.5)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-ignore" ,rust-ignore-0.4)
        ("rust-im-rc" ,rust-im-rc-15)
        ("rust-jobserver" ,rust-jobserver-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.12)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-opener" ,rust-opener-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-pretty-env-logger" ,rust-pretty-env-logger-0.4)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rustc-workspace-hack" ,rust-rustc-workspace-hack-1)
        ("rust-rustfix" ,rust-rustfix-0.5)
        ("rust-same-file" ,rust-same-file-1)
        ("rust-semver" ,rust-semver-0.10)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-ignored" ,rust-serde-ignored-0.1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-shell-escape" ,rust-shell-escape-0.1)
        ("rust-strip-ansi-escapes" ,rust-strip-ansi-escapes-0.1)
        ("rust-tar" ,rust-tar-0.4)
        ("rust-tar" ,rust-tar-0.4)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-unicode-xid" ,rust-unicode-xid-0.2)
        ("rust-url" ,rust-url-2)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list curl libssh2 libgit2 openssl zlib))
    (home-page "https://crates.io")
    (synopsis "Package manager for Rust")
    (description "Cargo, a package manager for Rust.  This package provides
the library crate of Cargo.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-metadata-0.15
  (package
    (name "rust-cargo-metadata")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-metadata" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dpcddizs4zhbvbsv3kxx9p0qppidxh05jz7dlf45f5rsm9pbfrs"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Allow older versions of the serde crates.
           (substitute* "Cargo.toml"
             (("1.0.136") "1.0.133")
             (("1.0.79") "1.0.74"))))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f              ; Not all tests included.
       #:cargo-inputs
       (("rust-camino" ,rust-camino-1)
        ("rust-cargo-platform" ,rust-cargo-platform-0.1)
        ("rust-derive-builder" ,rust-derive-builder-0.11)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/oli-obk/cargo_metadata")
    (synopsis "Structured access to the output of `cargo metadata`")
    (description
     "This package provides structured access to the output of @code{cargo
metadata}.")
    (license license:expat)))

(define-public rust-cargo-metadata-0.14
  (package
    (inherit rust-cargo-metadata-0.15)
    (name "rust-cargo-metadata")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-metadata" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04kfzvmh80pq0bw1cwzlz71wfrign2k7792mc4gi8hs1jkgfcams"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-camino" ,rust-camino-1)
        ("rust-cargo-platform" ,rust-cargo-platform-0.1)
        ("rust-derive-builder" ,rust-derive-builder-0.9)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cargo-metadata-0.13
  (package
    (inherit rust-cargo-metadata-0.14)
    (name "rust-cargo-metadata")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-metadata" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11cnz97byqswmhpbbig9hss5kf8bmxq9nd5xjg3l2rsnnv040i32"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-camino" ,rust-camino-1)
        ("rust-cargo-platform" ,rust-cargo-platform-0.1)
        ("rust-derive-builder" ,rust-derive-builder-0.9)
        ("rust-semver" ,rust-semver-0.11)
        ("rust-semver-parser" ,rust-semver-parser-0.10)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cargo-metadata-0.9
  (package
    (inherit rust-cargo-metadata-0.13)
    (name "rust-cargo-metadata")
    (version "0.9.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cargo_metadata" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "00pjms89lghvizh4d55lz80hvrih9r55xv9m5wd9vcsgc163gqs6"))))
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-semver" ,rust-semver-0.9)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-docopt" ,rust-docopt-1)
        ("rust-structopt" ,rust-structopt-0.2))))))

(define-public rust-cargo-metadata-0.6
  (package
    (inherit rust-cargo-metadata-0.9)
    (name "rust-cargo-metadata")
    (version "0.6.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cargo_metadata" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1givpi2w7iwqqnl87x5yc15zcm5hs6yw490sb6abkfp1h39v9lg5"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-semver" ,rust-semver-0.9)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (;("rust-docopt" ,rust-docopt-0.8)
        ("rust-clap" ,rust-clap-2))))))

(define-public rust-cargo-metadata-0.2
  (package
    (inherit rust-cargo-metadata-0.9)
    (name "rust-cargo-metadata")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-metadata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ywd10r8gnfcmpg2cjv99gcwydgrn0syw252qcsgd1118sw5f45y"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cargo-lock-7
  (package
    (name "rust-cargo-lock")
    (version "7.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cargo-lock" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "122wirj0d44xi2i7sc6anjimqfvgw5p5ry840zikc82vpn44pc3z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gumdrop" ,rust-gumdrop-0.8)
        ("rust-petgraph" ,rust-petgraph-0.6)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-url" ,rust-url-2))))
    (home-page "https://rustsec.org")
    (synopsis "@file{Cargo.lock} parser with optional dependency graph analysis")
    (description
     "This package provides self-contained @file{Cargo.lock} parser with
optional dependency graph analysis.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cargo-platform-0.1
  (package
    (name "rust-cargo-platform")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-platform" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mzi60pf0z83qkzqp7jwd61xnqz2b5ydsj7rnnikbgyicd5989h2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Target platform abstraction for Cargo")
    (description "This package provides abstractions for the target platforms
supported by Cargo.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cassowary-0.3
  (package
    (name "rust-cassowary")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cassowary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lvanj0gsk6pc1chqrh4k5k0vi1rfbgzmsk46dwy3nmrqyw711nz"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/dylanede/cassowary-rs")
    (synopsis
     "Implementation of the Cassowary linear constraint solving algorithm")
    (description
     "This package provides a Rust implementation of the Cassowary linear
constraint solving algorithm.

The Cassowary algorithm is designed for naturally laying out user interfaces
using linear constraints, like ``this button must line up with this text
box''.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cast-0.3
  (package
    (name "rust-cast")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dbyngbyz2qkk0jn2sxil8vrz3rnpcj142y184p9l4nbl9radcip"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/japaric/cast.rs")
    (synopsis
     "Ergonomic, checked cast functions for primitive types")
    (description
     "Ergonomic, checked cast functions for primitive types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cast-0.2
  (package
    (inherit rust-cast-0.3)
    (name "rust-cast")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cast" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1c5z7zryj0zwnhdgs6rw5dfvnlwc1vm19jzrlgx5055alnwk952b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))))

(define-public rust-cblas-sys-0.1
  (package
    (name "rust-cblas-sys")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cblas-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rgsn3klhhh09d8qf3b87zl4rwk93l2g0qzh9hhb0lff5kcfrzmn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/blas-lapack-rs/cblas-sys")
    (synopsis "Bindings to CBLAS (C)")
    (description
     "The package provides bindings to CBLAS (C).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cc-1
  (package
    (name "rust-cc")
    (version "1.0.73")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04ccylrjq94jssh8f7d7hxv64gs9f1m1jrsxb7wqgfxk4xljmzrg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-jobserver" ,rust-jobserver-0.1))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/alexcrichton/cc-rs")
    (synopsis "Invoke the native C compiler")
    (description
     "This package provides a build-time dependency for Cargo build scripts to
assist in invoking the native C compiler to compile native C code into a static
archive to be linked into Rustcode.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cesu8-1
  (package
    (name "rust-cesu8")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cesu8" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g6q58wa7khxrxcxgnqyi9s1z2cjywwwd3hzr5c55wskhx6s0hvd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/emk/cesu8-rs")
    (synopsis "Convert to and from CESU-8 encoding")
    (description
     "This library implements the CESU-8 compatibility encoding scheme.  This
is a non-standard variant of UTF-8 that is used internally by some systems
that need to represent UTF-16 data as 8-bit characters.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cexpr-0.6
  (package
    (name "rust-cexpr")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rl77bwhs5p979ih4r0202cn5jrfsrbgrksp40lkfz5vk1x3ib3g"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t #:cargo-inputs (("rust-nom" ,rust-nom-7))))
    (inputs
     (list clang))
    (home-page "https://github.com/jethrogb/rust-cexpr")
    (synopsis "C expression parser and evaluator")
    (description
     "This package provides a C expression parser and evaluator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cexpr-0.4
  (package
    (inherit rust-cexpr-0.6)
    (name "rust-cexpr")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09qd1k1mrhcqfhqmsz4y1bya9gcs29si7y3w96pqkgid4y2dpbpl"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-5))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.28))))))

(define-public rust-cexpr-0.3
  (package
    (inherit rust-cexpr-0.4)
    (name "rust-cexpr")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07fdfj4ff2974y33yixrb657riq9zl9b9h9lr0h7ridhhvxvbrgw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-4))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.28))))))

(define-public rust-cexpr-0.2
  (package
    (inherit rust-cexpr-0.3)
    (name "rust-cexpr")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v1xa3758czmj8h97gh548mr8g0v13ixxvrlm1s79nb7jmgc9aj2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-3))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.11))))))

(define-public rust-cfg-aliases-0.1
  (package
    (name "rust-cfg-aliases")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg_aliases" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17p821nc6jm830vzl2lmwz60g3a30hcm33nk6l257i1rjdqw85px"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/katharostech/cfg_aliases")
    (synopsis "Utility to help you with long winded @code{#[cfg()]} checks")
    (description
     "CFG Aliases is a tiny utility to help save you a lot of effort with long
winded @code{#[cfg()]} checks.")
    (license license:expat)))

(define-public rust-cfg-expr-0.10
  (package
    (name "rust-cfg-expr")
    (version "0.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-expr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nw50j1sl6q96067399r1c6ppwp483q6vvmqdsnv493cv7sarb0a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.12))
       #:cargo-development-inputs
       (("rust-similar-asserts" ,rust-similar-asserts-1))))
    (home-page "https://github.com/EmbarkStudios/cfg-expr")
    (synopsis "Parser and evaluator for Rust @code{cfg()} expressions")
    (description
     "This package provides a parser and evaluator for Rust @code{cfg()}
expressions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cfg-expr-0.8
  (package
    (inherit rust-cfg-expr-0.10)
    (name "rust-cfg-expr")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-expr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03lgv8psc2qrr93hxgdfmfwbj1crpzghxd7qh6w2nz0l4qryh4ml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.12))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2))))))

(define-public rust-cfg-if-1
  (package
    (name "rust-cfg-if")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-if" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/alexcrichton/cfg-if")
    (synopsis "Define an item depending on parameters")
    (description
     "This package provides a macro to ergonomically define an item depending
on a large number of @code{#[cfg]} parameters.  Structured like an if-else
chain, the first matching branch is the item that gets emitted.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cfg-if-0.1
  (package
    (inherit rust-cfg-if-1)
    (name "rust-cfg-if")
    (version "0.1.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cfg-if" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "08h80ihs74jcyp24cd75wwabygbbdgl05k6p5dmq8akbr78vv1a7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))))

(define-public rust-chacha20-0.8
  (package
    (name "rust-chacha20")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chacha20" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14cgpnnpqsn5hmqkgrj4yaqdsvy56hkgcw5s2gqsxwhc7m1jmdq1"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("version = \">=1, <1.5\"") "version = \"^1\""))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cipher" ,rust-cipher-0.3)
        ("rust-cpufeatures" ,rust-cpufeatures-0.2)
        ("rust-rand-core" ,rust-rand-core-0.6)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-cipher" ,rust-cipher-0.3)
        ("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/RustCrypto/stream-ciphers")
    (synopsis "ChaCha20 stream cipher implemented in pure Rust")
    (description
     "The ChaCha20 stream cipher (RFC 8439) implemented in pure Rust using traits
from the RustCrypto @code{cipher} crate, with optional architecture-specific
hardware acceleration (AVX2, SSE2).  Additionally provides the ChaCha8, ChaCha12,
XChaCha20, XChaCha12 and XChaCha8 stream ciphers, and also optional
@code{rand_core-compatible} RNGs based on those ciphers.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-chacha20poly1305-0.9
  (package
    (name "rust-chacha20poly1305")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chacha20poly1305" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0alawaaakczsll1b98qf4m6r6kfaw28506ljvsysjyjz3mnyv11v"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("version = \">=1, <1.5\"") "version = \"^1\""))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aead" ,rust-aead-0.4)
        ("rust-chacha20" ,rust-chacha20-0.8)
        ("rust-cipher" ,rust-cipher-0.3)
        ("rust-poly1305" ,rust-poly1305-0.7)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-aead" ,rust-aead-0.4))))
    (home-page "https://github.com/RustCrypto/AEADs")
    (synopsis
     "Pure Rust implementation of ChaCha20Poly1305 Authenticated Encryption")
    (description
     "Pure Rust implementation of the ChaCha20Poly1305 Authenticated
Encryption with Additional Data Cipher (RFC 8439) with optional
architecture-specific hardware acceleration.  Also contains implementations of
the XChaCha20Poly1305 extended nonce variant of ChaCha20Poly1305, and the
reduced-round ChaCha8Poly1305 and ChaCha12Poly1305 lightweight variants.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-chalk-derive-0.75
  (package
    (name "rust-chalk-derive")
    (version "0.75.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chalk-derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v1i5sb1w2skqg5sjy3gimdglsq0in6mc1zz36qyc99lkrgknknm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-synstructure" ,rust-synstructure-0.12))))
    (home-page "https://github.com/rust-lang/chalk")
    (synopsis
     "Helper crate for use by chalk crates for `derive` macros")
    (description
     "This package provides a helper crate for use by chalk crates for `derive`
macros.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-chalk-derive-0.68
  (package
    (inherit rust-chalk-derive-0.75)
    (name "rust-chalk-derive")
    (version "0.68.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chalk-derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ss18zx2ddp50mvbwffs5jmmcs7a0pkiq1g62xa7z1bacvkm45ga"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-synstructure" ,rust-synstructure-0.12))))))

(define-public rust-chalk-ir-0.75
  (package
    (name "rust-chalk-ir")
    (version "0.75.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chalk-ir" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12iyziaw14qb0wz3pqx70qwqa9r0qsi5d4y6j0g32yabs2hyay9b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-chalk-derive" ,rust-chalk-derive-0.75)
        ("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/rust-lang/chalk")
    (synopsis
     "Chalk's internal representation of types, goals, and clauses")
    (description
     "This package provides Chalk's internal representation of types, goals, and
clauses.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-chalk-ir-0.68
  (package
    (inherit rust-chalk-ir-0.75)
    (name "rust-chalk-ir")
    (version "0.68.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chalk-ir" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0riyv4fjmxys8gsyrikn9in34cjcgwgj55qyaj9w9fld8kqxbmqr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-chalk-derive" ,rust-chalk-derive-0.68)
        ("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-chalk-recursive-0.75
  (package
    (name "rust-chalk-recursive")
    (version "0.75.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chalk-recursive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11bnn0yn9np4mar4nryys6w1ijizj3y9dcz3xbldxzx6fplmk7y3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chalk-derive" ,rust-chalk-derive-0.75)
        ("rust-chalk-ir" ,rust-chalk-ir-0.75)
        ("rust-chalk-solve" ,rust-chalk-solve-0.75)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-tracing" ,rust-tracing-0.1))))
    (home-page "https://github.com/rust-lang/chalk")
    (synopsis
     "Recursive solver for the Chalk project")
    (description
     "Recursive solver for the Chalk project")
    (license (list license:asl2.0 license:expat))))

(define-public rust-chalk-solve-0.75
  (package
    (name "rust-chalk-solve")
    (version "0.75.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chalk-solve" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07gaf59zr7pgpr01l3si7a8iici2qh5dh2w2b05agaq5cvds3lm5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chalk-derive" ,rust-chalk-derive-0.75)
        ("rust-chalk-ir" ,rust-chalk-ir-0.75)
        ("rust-ena" ,rust-ena-0.14)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-petgraph" ,rust-petgraph-0.5)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-subscriber"
         ,rust-tracing-subscriber-0.3)
        ("rust-tracing-tree" ,rust-tracing-tree-0.2))))
    (home-page "https://github.com/rust-lang/chalk")
    (synopsis
     "Combines the chalk-engine with chalk-ir")
    (description
     "This package provides a combines the chalk-engine with chalk-ir.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-charset-0.1
  (package
    (name "rust-charset")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "charset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wzwnck82maqa03hvpprpd1zvnzmzxpkqna4pxnf4g8wvxj6whjg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://docs.rs/charset/")
    (synopsis "Thunderbird-compatible character encoding decoding for email")
    (description
     "charset is a wrapper around @code{encoding_rs} that
provides (non-streaming) decoding for character encodings that occur in email
by providing decoding for UTF-7 in addition to the encodings defined by the
Encoding Standard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-0.4
  (package
    (name "rust-chrono")
    (version "0.4.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wyfl6c00vhfl562spnfcna3zkw8jqvcp652m9iskhl8j26dc2k7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pure-rust-locales" ,rust-pure-rust-locales-0.5)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-0.8)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-num-iter" ,rust-num-iter-0.1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))
       #:features '("unstable-locales")
       #:tests? #f))
    (home-page "https://github.com/chronotope/chrono")
    (synopsis "Date and time library for Rust")
    (description "Date and time library for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-humanize-0.2
  (package
    (name "rust-chrono-humanize")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-humanize" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jvm6fcs3zvz4kcqkp9q5hjy0i2zc17194nb63ckyn0xa0cw3p9f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4))))
    (home-page "https://gitlab.com/imp/chrono-humanize-rs")
    (synopsis "Human-friendly time expressions")
    (description
     "Chrono-Humanize provides human-friendly time expressions, similar to
Python arrow.humanize.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-tz-0.6
  (package
    (name "rust-chrono-tz")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12qcpjqva4fpj5kdcksbfhsc8dkbdhyi2z56p8dwf9bxc0f1rh34"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz-build" ,rust-chrono-tz-build-0.0.2)
        ("rust-phf" ,rust-phf-0.10)
        ("rust-serde" ,rust-serde-1)
        ("rust-uncased" ,rust-uncased-0.9))))
    (home-page "https://github.com/chronotope/chrono-tz")
    (synopsis "TimeZone implementations for rust-chrono from the IANA database")
    (description
     "Chrono-TZ is a library that provides implementors of the TimeZone trait
for @code{rust-chrono}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-tz-0.5
  (package
    (inherit rust-chrono-tz-0.6)
    (name "rust-chrono-tz")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "085i4940kn0fn4gkl3xi1kv3vp2frhfig1vla1i461pcbwas6m15"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
        ("rust-serde" ,rust-serde-1))))))

(define-public rust-chrono-tz-build-0.0.2
  (package
    (name "rust-chrono-tz-build")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz-build" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0schy3z03psvmc6734hgkx52cdb3zvixgzhvhr0mzxmj7x4qs1fv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
        ("rust-phf" ,rust-phf-0.10)
        ("rust-phf-codegen" ,rust-phf-codegen-0.10)
        ("rust-regex" ,rust-regex-1)
        ("rust-uncased" ,rust-uncased-0.9))))
    (home-page "https://github.com/chronotope/chrono-tz")
    (synopsis "Internal build script for chrono-tz Rust package")
    (description
     "This package contains the internal build script for
chrono-tz Rust crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chunked-transfer-1
  (package
    (name "rust-chunked-transfer")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chunked_transfer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bkdlsrszfcscw3j6yhs7kj6jbp8id47jjk6h9k58px47na5gy7z"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/frewsxcv/rust-chunked-transfer")
    (synopsis "Encoder and decoder for HTTP chunked transfer coding")
    (description "This package provides an encoder and decoder for HTTP chunked
transfer coding.")
    (license license:asl2.0)))

(define-public rust-chunked-transfer-0.3
  (package
    (inherit rust-chunked-transfer-1)
    (name "rust-chunked-transfer")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chunked_transfer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11yghnd24w0i9p8g368c3pg7qh9nfz7kgri6pywja9pnmakj13a9"))))))

(define-public rust-ci-info-0.3
  (package
    (name "rust-ci-info")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ci-info" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00pr17g6q6i752acrkycg0hkq3lm0p634anm41g3m6lqg8q83s75"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/sagiegurari/ci_info")
    (synopsis "Provides current CI environment information")
    (description
     "This package provides current CI environment information.")
    (license license:asl2.0)))

(define-public rust-clang-ast-0.1
  (package
    (name "rust-clang-ast")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-ast" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1sfqyxszas78s78nga88fl0i5qlr87qsj22vlxarhvx96q86impf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Uses unstable features.
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-clang-ast-test-suite" ,rust-clang-ast-test-suite-0.0.0)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/dtolnay/clang-ast")
    (synopsis "Data structures for processing Clang's ast format")
    (description "This package contains data structures for processing Clang's
@code{-ast-dump=json} format.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clang-ast-test-suite-0.0.0
  (package
    (name "rust-clang-ast-test-suite")
    (version "0.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-ast-test-suite" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "04c6p67w2f3s74pl83swj93l6p9g88vgki0rp2vxbb0bzm1hqy5h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t))   ; Not intended to be built independently.
    (home-page "https://github.com/dtolnay/clang-ast")
    (synopsis "Test suite of the clang-ast crate")
    (description
     "This package contains the test suite of the @code{clang-ast} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clang-sys-1
  (package
    (name "rust-clang-sys")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0695kfrqx7n091fzm6msbqg2q2kyhka64q08lm63f3l9d964i8cx"))))
    (build-system cargo-build-system)
    (inputs
     (list clang))
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.6))))
    (home-page "https://github.com/KyleMayes/clang-sys")
    (synopsis "Rust bindings for libclang")
    (description "This package provides Rust bindings for libclang.")
    (license license:asl2.0)))

(define-public rust-cipher-0.3
  (package
    (name "rust-cipher")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cipher" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1dyzsv0c84rgz98d5glnhsz4320wl24x3bq511vnyf0mxir21rby"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
        (("rust-blobby" ,rust-blobby-0.3)
         ("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://docs.rs/cipher/")
    (synopsis "Traits for describing block ciphers and stream ciphers")
    (description "This package provides traits which define the functionality
of block ciphers and stream ciphers.  See RustCrypto/block-ciphers and
RustCrypto/stream-ciphers for algorithm implementations which use these
traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cipher-0.2
  (package
    (inherit rust-cipher-0.3)
    (name "rust-cipher")
    (version "0.2.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cipher" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "00b8imbmdg7zdrbaczlivmdfdy09xldg95wl4iijl15xgjcfgy0j"))))))

(define-public rust-clang-sys-0.29
  (package
    (inherit rust-clang-sys-1)
    (name "rust-clang-sys")
    (version "0.29.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "02nibl74zbz5x693iy5vdbhnfckja47m7j1mp2bj7fjw3pgkfs7y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.28
  (package
    (inherit rust-clang-sys-0.29)
    (name "rust-clang-sys")
    (version "0.28.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ls8zcqi5bmmrvrk3b6r1ym4wlivinbv590d2dvg2xn9f44mbpl1"))))))

(define-public rust-clang-sys-0.26
  (package
    (inherit rust-clang-sys-0.28)
    (name "rust-clang-sys")
    (version "0.26.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1r50dwy5hj5gq07dn0qf8222d07qv0970ymx0j8n9779yayc3w3f"))))
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.23
  (package
    (inherit rust-clang-sys-0.26)
    (name "rust-clang-sys")
    (version "0.23.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1hjr333izzhs6bic84qwnyzy5xzmvasib8f3zkzj4ln3a97c1xyp"))))))

(define-public rust-clang-sys-0.22
  (package
    (inherit rust-clang-sys-0.26)
    (name "rust-clang-sys")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0f65dw1ydnzq4wrv894fql78n4ikb53jjp53xck0s4hb64s1m6lk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-glob" ,rust-glob-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.11
  (package
    (inherit rust-clang-sys-0.22)
    (name "rust-clang-sys")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17i47skqp1d9svil2m1wspnhz7ci1x0fipia70ns0qffciwiz48r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-0.7)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-glob" ,rust-glob-0.2)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.3))))))

(define-public rust-clap-derive-3
  (package
    (name "rust-clap-derive")
    (version "3.0.0-beta.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18cn82jhcha7m0nkpi1a03jx8k7aaq5kxfcxnsqpaa8ih5dp23rp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-heck" ,rust-heck-0.3)
        ("rust-proc-macro-error"
         ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://clap.rs/")
    (synopsis
     "Parse command line argument by defining a struct, derive crate")
    (description
     "This package provides a parse command line argument by defining a struct,
derive crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-3
  (package
    (name "rust-clap")
    (version "3.0.0-beta.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hm1kivw6190rxbfqhdr4hqwlrijvwh90i3d9dyyw0d5k0chdlab"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-clap-derive" ,rust-clap-derive-3)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-os-str-bytes" ,rust-os-str-bytes-2)
        ("rust-strsim" ,rust-strsim-0.10)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-textwrap" ,rust-textwrap-0.12)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-vec-map" ,rust-vec-map-0.8)
        ("rust-yaml-rust" ,rust-yaml-rust-0.4))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://clap.rs/")
    (synopsis "Command Line Argument Parser")
    (description
     "This package provides a simple to use, efficient, and full-featured
Command Line Argument Parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-2
  (package
    (inherit rust-clap-3)
    (name "rust-clap")
    (version "2.34.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "071q5d8jfwbazi6zhik9xwpacx5i6kb2vkzy060vhf0c3120aqd0"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-strsim" ,rust-strsim-0.8)
        ("rust-term-size" ,rust-term-size-0.3)
        ("rust-textwrap" ,rust-textwrap-0.11)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-vec-map" ,rust-vec-map-0.8)
        ("rust-yaml-rust" ,rust-yaml-rust-0.3))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (license license:expat)))

(define-public rust-clearscreen-1
  (package
    (name "rust-clearscreen")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clearscreen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "083ycj7qhwlq8azy0rl9lpbr69k87hn622wc8mi96w293rsq1zwy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nix" ,rust-nix-0.20)
        ("rust-terminfo" ,rust-terminfo-0.7)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-which" ,rust-which-4)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/watchexec/clearscreen")
    (synopsis "Cross-platform terminal screen clearing")
    (description
     "This crate provides cross-platform terminal screen clearing.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-clicolors-control-1
  (package
    (name "rust-clicolors-control")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clicolors-control" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "07klix8nbpwk0cg1k4h0kkiijm1jxvrzndqdkr7dqr6xvkjjw24h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/mitsuhiko/clicolors-control")
    (synopsis "Common utility library to control CLI colorization")
    (description
     "This package provides a common utility library to control CLI
colorization.")
    (license license:expat)))

(define-public rust-clipboard-win-4
  (package
    (name "rust-clipboard-win")
    (version "4.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clipboard-win" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a1cpp4yyizz41bkij5x85p220xxrlja6l6wwj9wkvwj364a2kjf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-code" ,rust-error-code-2)
        ("rust-str-buf" ,rust-str-buf-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/DoumanAsh/clipboard-win")
    (synopsis "Simple way to interact with Windows clipboard")
    (description
     "This package provides simple way to interact with Windows clipboard.")
    (license license:boost1.0)))

(define-public rust-clipboard-win-3
  (package
    (inherit rust-clipboard-win-4)
    (name "rust-clipboard-win")
    (version "3.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clipboard-win" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hh3npqfa1lfn62fwvkmjlpfnizq343a994b898ffsvb100mxpwz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-bytes-cast" ,rust-lazy-bytes-cast-5)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-clippy-0.0
  (package
    (name "rust-clippy")
    (version "0.0.302")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clippy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1562x3sq9mgmc8j39gd34wqm7ybrdvpmj7cc1n450gwsawayw4fr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-term" ,rust-term-0.5))))
    (home-page "https://github.com/rust-lang/rust-clippy")
    (synopsis
     "Lints to avoid common pitfalls in Rust")
    (description
     "This package provides a bunch of helpful lints to avoid common
pitfalls in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clippy-0.0.153
  (package
    (inherit rust-clippy-0.0)
    (name "rust-clippy")
    (version "0.0.153")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clippy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1b5c96303nc6ngphazjafafgjjfawfbsjrkr2c8m2xvg7finxf47"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cargo-metadata" ,rust-cargo-metadata-0.2)
        ("rust-clippy-lints" ,rust-clippy-lints-0.0.153))
       #:cargo-development-inputs
       (("rust-clippy-mini-macro-test" ,rust-clippy-mini-macro-test-0.1)
        ("rust-compiletest-rs" ,rust-compiletest-rs-0.2)
        ("rust-duct" ,rust-duct-0.8)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))))

(define-public rust-clippy-lints-0.0.153
  (package
    (name "rust-clippy-lints")
    (version "0.0.153")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clippy-lints" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "021w4cv2qwczkk0w4d6zy52yx6afi4yz5y29wq6xmb0wqwzp55ca"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-itertools" ,rust-itertools-0.6)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-pulldown-cmark" ,rust-pulldown-cmark-0.0.15)
        ("rust-quine-mc-cluskey" ,rust-quine-mc-cluskey-0.2)
        ("rust-regex-syntax" ,rust-regex-syntax-0.4)
        ("rust-semver" ,rust-semver-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-toml" ,rust-toml-0.4)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))))
    (home-page "https://github.com/rust-lang-nursery/rust-clippy")
    (synopsis "helpful lints to avoid common pitfalls in Rust")
    (description
     "This package provides a bunch of helpful lints to avoid common pitfalls
in Rust")
    (license license:mpl2.0)))

(define-public rust-clippy-mini-macro-test-0.1
  (package
    (name "rust-clippy-mini-macro-test")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clippy-mini-macro-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f1q09az4xk4aqnp8g1m6kf4hif75gr7rwzhh4yw7g1gqk94jsgq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t))
    (home-page "https://github.com/rust-lang-nursery/rust-clippy")
    (synopsis "Macro to test clippy's procedural macro checks")
    (description
     "This package provides a macro to test clippy's procedural macro
checks.")
    (license license:mpl2.0)))

(define-public rust-clircle-0.3
  (package
    (name "rust-clircle")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clircle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15p36klnsgjimfswi0mjc7wsh4b662v7gbfinh56ipk3bacbv2z6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/niklasmohrin/clircle")
    (synopsis "Detect IO circles in your CLI apps arguments")
    (description
     "Clircle provides a cross-platform API to detect read or write cycles
from your user-supplied arguments.  You can get the important identifiers of
a file (from a path) and for all three stdio streams, if they are piped from
or to a file as well.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cloudabi-0.1
  (package
    (name "rust-cloudabi")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudabi" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rv4yf5jlldfkynzrw687s00f4x12ypw7axv71vawhy6h4i52i23"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://cloudabi.org/")
    (synopsis "Low level interface to CloudABI")
    (description "This package provides a low level interface to CloudABI.  It
contains all syscalls and related types.")
    (license license:bsd-2)))

(define-public rust-cloudabi-0.0
  (package
    (inherit rust-cloudabi-0.1)
    (name "rust-cloudabi")
    (version "0.0.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudabi" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kxcg83jlihy0phnd2g8c2c303px3l2p3pkjz357ll6llnd5pz6x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1))))))

(define-public rust-cloudflare-zlib-sys-0.3
  (package
    (name "rust-cloudflare-zlib-sys")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cloudflare-zlib-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0vyd0l0vprvh9hc1ikllybrk8xc0lz9f509d2xgxgrpyxp8vch10"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/cloudflare/zlib")
    (synopsis
     "Cloudflare fork of zlib with massive performance improvements")
    (description
     "Cloudflare fork of zlib with massive performance improvements.")
    (license
     (list license:expat
           license:asl2.0
           license:zlib))))

(define-public rust-cmake-0.1
  (package
    (name "rust-cmake")
    (version "0.1.44")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cmake" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1fv346ipxmvff6qrnh78rild0s8k72ilfjkdsrk869562y62cmhf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/alexcrichton/cmake-rs")
    (synopsis "Rust build dependency for running cmake")
    (description
     "This package provides a build dependency for running @code{cmake} to build
a native library.  The CMake executable is assumed to be @code{cmake} unless the
CMAKE environmental variable is set.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cocoa-0.24
  (package
    (name "rust-cocoa")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cp8hsajmi7gini22bmlsf9dac7cap7x1k169vxhwlr3j8p90qvg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-cocoa-foundation" ,rust-cocoa-foundation-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Cocoa for macOS")
    (description "This package provides bindings to Cocoa for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cocoa-0.23
  (package
    (inherit rust-cocoa-0.24)
    (name "rust-cocoa")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cj4c2axmg7aiid2786mpzj7wxpd582biv7c7yimqfnggp002hn5"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-cocoa-foundation" ,rust-cocoa-foundation-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))))

(define-public rust-cocoa-0.22
  (package
    (inherit rust-cocoa-0.23)
    (name "rust-cocoa")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19qyyv01yzrm6aahn6cdxvb4jhl6v4fj0cgqkxmq38i7hq3dqzv6"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.21)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))))

(define-public rust-cocoa-0.19
  (package
    (inherit rust-cocoa-0.22)
    (name "rust-cocoa")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0034vahbfv574q4b63rj241b8rnka5cjiqsqc6wiggnin9l7g7zj"))))
    (arguments
     `(#:skip-build? #t     ; only for macOS
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.6)
        ("rust-core-graphics" ,rust-core-graphics-0.17)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))))

(define-public rust-cocoa-0.18
  (package
    (inherit rust-cocoa-0.19)
    (name "rust-cocoa")
    (version "0.18.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0m6fgdr4d2fp8jhkqvwr23hrqqqjv72g0j9vdgijc58k05j9j1hp"))))))

(define-public rust-cocoa-foundation-0.1
  (package
    (name "rust-cocoa-foundation")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa-foundation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0633ipbd28z35rsdmsl505f1aasrjsrrnirs826aa32nbnv4kpks"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics-types" ,rust-core-graphics-types-0.1)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Cocoa Foundation for macOS")
    (description
     "This package provides bindings to Cocoa Foundation for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codepage-0.1
  (package
    (name "rust-codepage")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codepage" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sdxp0f8dy2rscln646326lny9i0jm7ncgyp4yncdwndq0i943lb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-rs" ,rust-encoding-rs-0.8))))
    (home-page "https://docs.rs/codepage/")
    (synopsis "Mapping between Windows code page and @code{encoding_rs}")
    (description
     "This package provides mapping between Windows code page numbers and
@code{encoding_rs} character encodings.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codespan-reporting-0.11
  (package
    (name "rust-codespan-reporting")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codespan-reporting" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04wwbn2c5rcfz3zn4kj7nyvpj37hn5cxh0m8w1r3af4ak6w45kn6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))))
    (home-page "https://github.com/brendanzab/codespan")
    (synopsis "Beautiful diagnostic reporting for text-based programming languages")
    (description
     "Languages like Rust and Elm already support beautiful error
reporting output, but it can take a significant amount work to
implement this for new programming languages! The
@code{codespan-reporting} crate aims to make beautiful error
diagnostics easy and relatively painless for everyone!")
    (license license:asl2.0)))

(define-public rust-codespan-reporting-0.9
  (package
    (inherit rust-codespan-reporting-0.11)
    (name "rust-codespan-reporting")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codespan-reporting" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07g86hv1lp5bbr6w6hsa3mgdmavs36igc7k5pi1fvc86ad2n41vf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-insta" ,rust-insta-0.16)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-peg" ,rust-peg-0.6)
        ("rust-rustyline" ,rust-rustyline-6)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-unindent" ,rust-unindent-0.1))))))

(define-public rust-coitrees-0.2
  (package
    (name "rust-coitrees")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "coitrees" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1l2ybr8n02vm08wq9mrix7r07bgwm85i6fyachlm8d626w9w9d3f"))))
    (build-system cargo-build-system)
    (arguments
     ;; Check phase fails with:
     ;; no function or associated item named `with_name` found for struct
     ;; `Arg` in the current scope
     `(#:tests? #false
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-3))))
    (home-page "https://github.com/dcjones/coitrees")
    (synopsis "Data structure for overlap queries on sets of intervals")
    (description
     "This package provides a very fast data structure for overlap queries on
sets of intervals.")
    (license license:expat)))

(define-public rust-color-backtrace-0.5
  (package
    (name "rust-color-backtrace")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-backtrace" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11fn3snykx90w3nznzrcf4r164zmhk790asx0kzryf4r7i308v6d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))
    (home-page "https://github.com/athre0z/color-backtrace")
    (synopsis "Colorful panic backtraces")
    (description "This package provides colorful panic backtraces.")
    (license (list license:expat license:asl2.0))))

(define-public rust-color-quant-1
  (package
    (name "rust-color-quant")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-quant" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12q1n427h2bbmmm1mnglr57jaz2dj9apk0plcxw7nwqiai7qjyrx"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/PistonDevelopers/color_quant.git")
    (synopsis "Color quantization library to reduce n colors to 256 colors")
    (description
     "This package is a color quantization library to reduce n colors to 256
colors.")
    (license license:expat)))

(define-public rust-colored-2
  (package
    (name "rust-colored")
    (version "2.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "colored" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1gbcijscmznzy42rn213yp9ima7210zakgaqibgg1n441dsnyqdk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-rspec" ,rust-rspec-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-version-requirements
           (lambda _
             (substitute* "Cargo.toml"
               (("1.0.0-beta.3") ,(package-version rust-rspec-1)))
             #t)))))
    (home-page "https://github.com/mackwic/colored")
    (synopsis "Add colors in your terminal")
    (description
     "The most simple way to add colors in your terminal.")
    (license license:mpl2.0)))

(define-public rust-colored-1
  (package
    (inherit rust-colored-2)
    (name "rust-colored")
    (version "1.9.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "colored" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nbc1czs512h1k696y7glv1kjrb2b914zpxraic6q5fgv80wizzl"))))))

(define-public rust-combine-4
  (package
    (name "rust-combine")
    (version "4.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qihymj493vvs054gzpcmp4lzb098zrj2p9miv19yzvrrjm2gdsh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.6))))
    (home-page "https://github.com/Marwes/combine")
    (synopsis "Parser combinators on arbitrary streams with zero-copy support")
    (description
     "This package is an implementation of parser combinators for Rust,
inspired by the Haskell library Parsec.  As in Parsec the parsers are LL(1) by
default but they can opt-in to arbitrary lookahead using the attempt
combinator.")
    (license license:expat)))

(define-public rust-combine-3
  (package
    (inherit rust-combine-4)
    (name "rust-combine")
    (version "3.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1006sbl3ybiky3d5q28p0lyph37hk7sipls1rkhikv11lfxacgfs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ascii" ,rust-ascii-0.9)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-combine-regex-1" ,rust-combine-regex-1-1)
        ("rust-either" ,rust-either-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-unreachable" ,rust-unreachable-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-partial-io" ,rust-partial-io-0.3)
        ("rust-tokio-codec" ,rust-tokio-codec-0.1))))))

(define-public rust-combine-regex-1-1
  (package
    (name "rust-combine-regex-1")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine-regex-1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bzir63nvrg98i8g6b7crhgq5qbj4vq9f4y6d279af537djvh5ns"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/Marwes/combine")
    (synopsis "Re-export of regex 1.0 letting combine use both 0.2 and 1.0")
    (description
     "This package is a re-export of regex 1.0 letting combine use both 0.2
and 1.0.")
    (license (list license:expat license:asl2.0))))

(define-public rust-comfy-table-4
  (package
    (name "rust-comfy-table")
    (version "4.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comfy-table" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wzk894p2s725cpdip5968ydb50zczsl34040j6zs8klhqz5ms8i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossterm" ,rust-crossterm-0.20)
        ("rust-strum" ,rust-strum-0.21)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-unicode-width" ,rust-unicode-width-0.1))))
    (home-page "https://github.com/nukesor/comfy-table")
    (synopsis "Library for building tables with automatic content wrapping")
    (description
     "Comfy-tables is an utility for building tables with automatic content
wrapping.")
    (license license:expat)))

(define-public rust-comfy-table-1
  (package
    (inherit rust-comfy-table-4)
    (name "rust-comfy-table")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comfy-table" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y6lc8h2lyyrrrdc36fz7brwyjz5l9w4nld4qx9mlacfibm8i92j"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossterm" ,rust-crossterm-0.19)
        ("rust-strum" ,rust-strum-0.20)
        ("rust-strum-macros" ,rust-strum-macros-0.20))))))

(define-public rust-commoncrypto-sys-0.2
  (package
    (name "rust-commoncrypto-sys")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "commoncrypto-sys" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1ql381ziqh594a7z6m9bvs583lkrhbynk02pmbgp7aj7czs39v8z"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t                ;requires the Mac OS library
        #:cargo-inputs
        (("rust-clippy" ,rust-clippy-0.0)
         ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/malept/rust-commoncrypto")
    (synopsis "FFI bindings to Mac OS X's CommonCrypto library")
    (description "This package is a component of the @code{commoncrypto}
library which provides Rust FFI bindings and idiomatic wrappers for Mac OS X's
CommonCrypto library.")
    (license license:expat)))

(define-public rust-commoncrypto-0.2
  (package
    (name "rust-commoncrypto")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "commoncrypto" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "01whnqcziclsj1gwavvqhrw2r5cmwh00j2fbc56iwnm2ddcahmnh"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-clippy" ,rust-clippy-0.0)
         ("rust-commoncrypto-sys" ,rust-commoncrypto-sys-0.2))))
    (home-page "https://github.com/malept/rust-commoncrypto")
    (synopsis "Idiomatic Rust wrappers for Mac OS X's CommonCrypto library")
    (description "The @{commoncrypto} library provides Rust FFI bindings and
idiomatic wrappers for Mac OS X's CommonCrypto library.")
    (license license:expat)))

(define-public rust-common-path-1
  (package
    (name "rust-common-path")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "common-path" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00firjly5xpb5hhmivnnhwakr1cwbqv8ckzyj0vbxczl89czg0i3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://gitlab.com/pwoolcoc/common-path")
    (synopsis "Find the common prefix between a set of paths")
    (description
     "Common path finds the common prefix between a set of paths.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-cstr-0.3
  (package
    (name "rust-const-cstr")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "const-cstr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "19ij6m8s16d0i7vma535l7w4x8bcanjcxs7c6n7sci86ydghnggd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cybergeek94/const-cstr")
    (synopsis "Create static C-compatible strings from Rust string literals")
    (description
     "This crate lets you create static C-compatible strings from Rust string
literals.")
    (license (list license:expat license:asl2.0))))

;; This package requires features which are unavailable
;; on the stable releases of Rust.
(define-public rust-compiler-builtins-0.1
  (package
    (name "rust-compiler-builtins")
    (version "0.1.26")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "compiler_builtins" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1rhj6ccmfkh9gcxnxgjq4fg257yi4f9325nfzsphbmxwkrg06sq3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/rust-lang/compiler-builtins")
    (synopsis "Compiler intrinsics used by the Rust compiler")
    (description
     "This package provides compiler intrinsics used by the Rust compiler.  This
package is primarily useful when building the @code{core} crate yourself and you
need compiler-rt intrinsics.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-compiler-error-0.1
  (package
    (name "rust-compiler-error")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiler_error" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0irh7c0gznk2k6mj3cmqw7x4pg59lppmy1y8d6k5xc926rnmz5zg"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/lu-zero/compiler_error")
    (synopsis "Triggerable compiler error")
    (description "This package provides a triggerable compiler error for Rust.")
    (license license:expat)))

(define-public rust-compiletest-rs-0.3
  (package
    (name "rust-compiletest-rs")
    (version "0.3.22")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1di7kl2zv7jcwqq343aafqhn31gfa600zh4mi6cp10mn6a9wq3pl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-diff" ,rust-diff-0.1)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-getopts" ,rust-getopts-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustfix" ,rust-rustfix-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tester" ,rust-tester-0.5)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/laumann/compiletest-rs")
    (synopsis "Compiletest utility from the Rust compiler")
    (description
     "The compiletest utility from the Rust compiler as a standalone testing
harness.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-compiletest-rs-0.2
  (package
    (inherit rust-compiletest-rs-0.3)
    (name "rust-compiletest-rs")
    (version "0.2.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0njz4shbhl1pvb6ngpi1wpz2gr5lf2dcha22lpdk995pzrwd6h97"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-concat-idents-1
  (package
    (name "rust-concat-idents")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concat-idents" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bqdl6vml2ksyz6hc4xlpw3iqaagxs7xn0xinwa51ms80a390vsb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/DzenanJupic/concat-idents")
    (synopsis "Concatenate multiple identifiers and use them everywhere")
    (description
     "This package allows concatenating multiple identifiers and using them
everywhere.")
    (license (list license:expat license:asl2.0))))

(define-public rust-concolor-0.0.8
  (package
    (name "rust-concolor")
    (version "0.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bs03868bywgz2f8x4h41akvxpxiax9b036hrpf0mwhx7db6flh1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-concolor-query" ,rust-concolor-query-0.0.5))))
    (home-page "https://github.com/rust-cli/concolor")
    (synopsis "Control console coloring across all dependencies")
    (description "Concolor is a terminal styling library that can be used to:
@itemize
@item Detect interactive @samp{stdout} or @samp{stderr}
@item Detect terminal capabilities via @samp{TERM}
@item Support @url{https://bixense.com/clicolors/, CLICOLOR} and
@url{https://no-color.org/, NO_COLOR}.
@end itemize")
    (license (list license:expat license:asl2.0))))

(define-public rust-concolor-control-0.0.7
  (package
    (inherit rust-concolor-0.0.8)
    (name "rust-concolor-control")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-control" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nplakbdb9sbd3h62d9zkan0xm1w0c7cbl3rk0iqgn405yf1213i"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-concolor-query" ,rust-concolor-query-0.0.4))))))

(define-public rust-concolor-query-0.0.5
  (package
    (name "rust-concolor-query")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-query" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jcll1lnnkbdr6xcgppf6dr0ra9rxcp78xr1zlrvba03zkk7yhfn"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rust-cli/concolor")
    (synopsis "Look up colored console capabilities")
    (description "@code{concolor-query} can be used to query a terminal
capabilities, for example to find out about its colored console abilities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-concolor-query-0.0.4
  (package
    (inherit rust-concolor-query-0.0.5)
    (name "rust-concolor-query")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-query" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1isbqpyiwblp0rglnaqzai5hav23095s82mwgi09v3xcck4rq5dd"))))))

(define-public rust-concurrent-queue-1
  (package
    (name "rust-concurrent-queue")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concurrent-queue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18w6hblcjjk9d0my3657ra1zdj79gwfjmzvc0b3985g01dahgv9h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cache-padded" ,rust-cache-padded-1))
       #:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-fastrand" ,rust-fastrand-1))))
    (home-page "https://github.com/stjepang/concurrent-queue")
    (synopsis "Concurrent multi-producer multi-consumer queue")
    (description
     "This package provides a concurrent multi-producer multi-consumer
queue.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-config-0.11
  (package
    (name "rust-config")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sdkxv77m65frsn3bx0r3v7asxar3gy3hmghcfk6h4rbijars6qv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-nom" ,rust-nom-5)
        ("rust-rust-ini" ,rust-rust-ini-0.13)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-hjson" ,rust-serde-hjson-0.9)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-yaml-rust" ,rust-yaml-rust-0.4))))
    (home-page "https://github.com/mehcode/config-rs")
    (synopsis "Layered configuration system for Rust applications")
    (description
     "This package provides a layered configuration system for Rust
applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-config-0.10
  (package
    (inherit rust-config-0.11)
    (name "rust-config")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qrcp7nm24xzp418xnqf0i26qahw93w31nk5vs6m7ng18ghpdc0r"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-nom" ,rust-nom-5)
        ("rust-rust-ini" ,rust-rust-ini-0.13)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-hjson" ,rust-serde-hjson-0.9)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-yaml-rust" ,rust-yaml-rust-0.4))))))

(define-public rust-configparser-2
  (package
    (name "rust-configparser")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "configparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qdaggalm3js86s2i11pjjcndrrvpk0pw1lfvmv7v25z3y66sqg2"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/mexili/configparser-rs")
    (synopsis "Simple parsing utility for INI and ini-style syntax")
    (description
     "This package provides a simple configuration parsing utility with no
dependencies that allows you to parse INI and ini-style syntax.  You can use
this to write Rust programs which can be customized by end users easily.")
    (license (list license:expat license:lgpl3+))))

(define-public rust-console-0.15
  (package
    (name "rust-console")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c9wif28i3q231gvjprqdq1glmgmmcdxpmxcwk1p0jx45k9k52x2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))
    (home-page "https://github.com/mitsuhiko/console")
    (synopsis "Terminal and console abstraction for Rust")
    (description
     "This package provides a terminal and console abstraction for Rust.")
    (license license:expat)))

(define-public rust-console-0.14
  (package
    (inherit rust-console-0.15)
    (name "rust-console")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i8z1bdbv8is1lamd81jdsf4pa1ww2jl3h0yjdshc5mabd2fd4rr"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.13
  (package
    (inherit rust-console-0.14)
    (name "rust-console")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "022ai0jbbawngrx396qppwgzk4pk3v2fdwckzamvz6h154jsn2m5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.11
  (package
    (inherit rust-console-0.13)
    (name "rust-console")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nmwkbb1j1zjb2z4akk83rqgnbv7j3dla4nxv0ibk9xvavk982cc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.9
  (package
    (inherit rust-console-0.11)
    (name "rust-console")
    (version "0.9.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "console" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1h765951c9mywff534f0191slazykmif4290g2yarcwhd2cg7q25"))))
    (arguments
     `(#:cargo-inputs
       (("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-clicolors-control" ,rust-clicolors-control-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-console-0.7
  (package
    (name "rust-console")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0a4n2syzik9lh02v2i4wdazvm05d99bib7dw0lqvz8mq2hn7r9cc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-clicolors-control" ,rust-clicolors-control-1)
        ("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-parking-lot" ,rust-parking-lot-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/mitsuhiko/console")
    (synopsis "Terminal and console abstraction for Rust")
    (description
     "This package provides a terminal and console abstraction for Rust.")
    (license license:expat)))

(define-public rust-console-error-panic-hook-0.1
  (package
    (name "rust-console-error-panic-hook")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console_error_panic_hook" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04d2narcrzk9bnddz17rr2l819l82pr0h6d98s2w9q236n87dndq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))))
    (home-page "https://github.com/rustwasm/console_error_panic_hook")
    (synopsis "Logs panics to console.error")
    (description
     "This package provides a panic hook for @code{wasm32-unknown-unknown}
that logs panics to @code{console.error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-console-log-0.2
  (package
    (name "rust-console-log")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "console_log" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "150li8pznpfpn4q0f7g9jwq2hnd5wik0w8378zaa1wffc5ckf6jh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))))
    (home-page "https://github.com/iamcodemaker/console_log")
    (synopsis "Route Rust log messages to the browser's console")
    (description
     "This package provides a logging facility that routes Rust log messages to
the browser's console.")
    (license (list license:expat license:asl2.0))))

(define-public rust-console-log-0.1
  (package
    (name "rust-console-log")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "console-log" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0j1wd2885m3245bhsb2qjvw08lzplbi1rgg2v3yv0hbljk972y0y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-web-sys" ,rust-web-sys-0.3))))
    (home-page "https://github.com/iamcodemaker/console_log")
    (synopsis "Route Rust log messages to the browser's console")
    (description
     "This package provides a logging facility that routes Rust log messages to
the browser's console.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-fn-0.4
  (package
    (name "rust-const-fn")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-fn" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1wnhzyrhfcaawnzi172k98cfawwi5zwqql7pg0nz2qlccm6dz46f"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/taiki-e/const_fn")
    (synopsis "Generate const functions with conditional compilations")
    (description "This package provides an attribute for easy generation of
const functions with conditional compilations.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-const-oid-0.6
  (package
    (name "rust-const-oid")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-oid" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12vv7csqqjj0x1l5mf51lgqiw76k5c3mb1yzfhfcqysks2j2lvwx"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/RustCrypto/formats/tree/master/const-oid")
    (synopsis "Implementation of the ISO/IEC Object Identifier (OID)")
    (description
     "This package is a const-friendly implementation of the ISO/IEC Object
Identifier (OID) standard as defined in ITU X.660, with support for BER/DER
encoding/decoding as well as heapless no_std (i.e., embedded) support.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-const-random-0.1
  (package
    (name "rust-const-random")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-random" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i3pmhmmcdw3rr1pv1p9yhm4danm5r156cpy7w30pa0s05fxk47m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-const-random-macro" ,rust-const-random-macro-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/tkaitchuck/constrandom")
    (synopsis "Compile time random number generation")
    (description "This package provides compile time random number
generation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-random-macro-0.1
  (package
    (name "rust-const-random-macro")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-random-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h7vvskw1pw5x44sbl74gsi8ydvrj5kaixpjqzxvz8h0s0knwpv1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-tiny-keccak" ,rust-tiny-keccak-2))))
    (home-page "https://github.com/tkaitchuck/constrandom")
    (synopsis "Procedural macro used by const-random")
    (description "This package provides the procedural macro used by
@code{rust-const-random}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-sha1-0.2
  (package
    (name "rust-const-sha1")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-sha1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "179cgi2m3wj5g80j49pggs95xalc6y1ivvbrv4m82alc3r2vcn7v"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rylev/const-sha1")
    (synopsis "sha1 implementation for use in const contexts")
    (description
     "This package provides a sha1 implementation for use in const contexts.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-constant-time-eq-0.1
  (package
    (name "rust-constant-time-eq")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "constant_time_eq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g3vp04qzmk6cpzrd19yci6a95m7ap6wy7wkwgiy2pjklklrfl14"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cesarb/constant_time_eq")
    (synopsis
     "Compares two equal-sized byte strings in constant time")
    (description
     "This package compares two equal-sized byte strings in constant time.
It is inspired by the Linux kernel's @code{crypto_memneq}.")
    (license license:cc0)))

(define-public rust-content-inspector-0.2
  (package
    (name "rust-content-inspector")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "content_inspector" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f1gwv4axxw9wck4a4jxlkm7xjjakb3616isll2k0s4chmpadgdp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/sharkdp/content_inspector")
    (synopsis "Fast inspection of binary buffers to guess the encoding")
    (description
     "This package is a simple library for fast inspection of binary buffers
to guess the type of content.")
    (license (list license:expat license:asl2.0))))

(define-public rust-conv-0.3
  (package
    (name "rust-conv")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "conv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "168j1npqrif1yqxbgbk0pdrx9shzhs5ylc5a4xw49b6hbxi11zvq"))
        (modules '((guix build utils)))
        (snippet
         '(begin (substitute* "Cargo.toml"
                   (("0.2.21.*") "0.2.21\"\n"))
                 #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-custom-derive" ,rust-custom-derive-0.1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-winapi" ,rust-winapi-0.2))))
    (home-page "https://github.com/DanielKeep/rust-conv")
    (synopsis "Conversion traits with more specific semantics")
    (description
     "This crate provides a number of conversion traits with more specific
semantics than those provided by @code{as} or @code{From}/@code{Into}.")
    (license license:expat)))

(define-public rust-convert-case-0.4
  (package
    (name "rust-convert-case")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "convert-case" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03jaf1wrsyqzcaah9jf8l1iznvdw5mlsca2qghhzr9w27sddaib2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/rutrum/convert-case")
    (synopsis "Convert strings into any case")
    (description "Convert strings into any case.")
    (license license:expat)))

(define-public rust-cookie-0.12
  (package
    (name "rust-cookie")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mdvqixahcywvqp0y8k2skkgbpfhsp0w73l9mz93dcrx1gq091l8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-ring" ,rust-ring-0.14)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-1))))
    (home-page "https://github.com/SergioBenitez/cookie-rs")
    (synopsis
     "Crate for parsing HTTP cookie headers and managing a cookie jar")
    (description
     "Parse HTTP cookie headers and manage a cookie jar with this crate.
It supports signed and private (encrypted + signed) jars.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cookie-0.11
  (package
    (inherit rust-cookie-0.12)
    (name "rust-cookie")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i2x04kx1ifljsnwsa83k7cpmajk9j4ayyx2h11y6lkji6hcv5ap"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aes-gcm" ,rust-aes-gcm-0.5)
        ("rust-base64" ,rust-base64-0.12)
        ("rust-hkdf" ,rust-hkdf-0.8)
        ("rust-hmac" ,rust-hmac-0.7)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-sha2" ,rust-sha2-0.8)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-cookie-factory-0.3
  (package
    (name "rust-cookie-factory")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie-factory" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sqjmw85ckqhppff6gjwmvjpkii35441a51xx7cv0ih3jy2fjv9r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs (("rust-maplit" ,rust-maplit-1))))
    (home-page "https://github.com/rust-bakery/cookie-factory")
    (synopsis "Combinator-based serialization library")
    (description
     "This package provides a serialization library with a combinator design
similar to the nom parser combinators library.")
    (license license:expat)))

(define-public rust-copyless-0.1
  (package
    (name "rust-copyless")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "copyless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dmmxsq3m0i6g9s2kj96n777qhmm7vjgv4r7agc2v6w6bl7rdpx2"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/kvark/copyless")
    (synopsis "Ways to eliminate @code{memcpy} calls")
    (description
     "This package provides ways to eliminate @code{memcpy} calls when using
the standard library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-copypasta-0.7
  (package
    (name "rust-copypasta")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "copypasta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02zz6yndszmzr5yjhn11g1hsj0232jbzl8gch6mxksw3xngxf8s4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-clipboard-win" ,rust-clipboard-win-3)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-foundation" ,rust-objc-foundation-0.1)
        ("rust-objc-id" ,rust-objc-id-0.1)
        ("rust-smithay-clipboard" ,rust-smithay-clipboard-0.6)
        ("rust-x11-clipboard" ,rust-x11-clipboard-0.5))))
    (home-page "https://github.com/alacritty/copypasta")
    (synopsis "Get and set the contents of the OS-level clipboard")
    (description
     "Copypasta is a cross-platform library for getting and setting the
contents of the OS-level clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cordic-0.1
  (package
    (name "rust-cordic")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cordic" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "13zvqn6c8d8lp18p9ik10q100wfsyv2m2n4fca16laq3yw7r231m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; rust-fixed fails to build
       #:cargo-inputs (("rust-fixed" ,rust-fixed-1))))
    (home-page "https://github.com/sebcrozet/cordic")
    (synopsis "Special functions for fixed-point numbers using the CORDIC method")
    (description "This package provides special functions for fixed-point
numbers using the CORDIC method.")
    (license license:bsd-3)))

(define-public rust-cookie-0.15
  (package
    (name "rust-cookie")
    (version "0.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03gql9c2l0wg3hpfp67wg2ns21wysk0xsjxwdbjrf0s6grrcgwfm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aes-gcm" ,rust-aes-gcm-0.8)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-hkdf" ,rust-hkdf-0.10)
        ("rust-hmac" ,rust-hmac-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-time" ,rust-time-0.2)
        ("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/SergioBenitez/cookie-rs")
    (synopsis "HTTP cookie parsing and cookie jar management")
    (description "This package provides HTTP cookie parsing and cookie jar
management.  It supports signed and private (encrypted, authenticated) jars.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core2-0.3
  (package
    (name "rust-core2")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "core2" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1wzzy5iazdk5caadxvjfwrd312rbg7a55a1zpmsdrhk3kfpa77r3"))))
    (build-system cargo-build-system)
    (arguments `(#:cargo-inputs (("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/bbqsrc/core2")
    (synopsis "Bare essentials of @code{std::io} for use in @code{no_std}")
    (description
      "This package provides the bare essentials of @code{std::io} for use
in @code{no_std}.  Alloc support is optional.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cookie-0.14
  (package
    (inherit rust-cookie-0.15)
    (name "rust-cookie")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q56fl2cqrci9ksa80d7g220phq02nf1yfbvxkpk9g1p95ma2wqk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-aes-gcm" ,rust-aes-gcm-0.6)
        ("rust-base64" ,rust-base64-0.12)
        ("rust-hkdf" ,rust-hkdf-0.9)
        ("rust-hmac" ,rust-hmac-0.8)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-time" ,rust-time-0.2))
       #:cargo-development-inputs
       (("rust-version-check" ,rust-version-check-0.9))))))

(define-public rust-cookie-store-0.15
  (package
    (name "rust-cookie-store-15")
    (version "0.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie-store" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0z0navy9k0ivrdvz492q8c4nhd3iv5l77hwfppskdp1j15607xxk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cookie" ,rust-cookie-0.15)
        ("rust-idna" ,rust-idna-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-publicsuffix" ,rust-publicsuffix-2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.2)
        ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/pfernie/cookie_store")
    (synopsis "Cookie storage and retrieval")
    (description "This package implements cookie storage and retrieval.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cookie-store-0.12
  (package
    (inherit rust-cookie-store-0.15)
    (name "rust-cookie-store")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie_store" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lqhmdwgnyvi1mjmw4rbgd02fwav4aabpg4vcld23d8c9g5dy61q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cookie" ,rust-cookie-0.14)
        ("rust-idna" ,rust-idna-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-publicsuffix" ,rust-publicsuffix-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))))

(define-public rust-core-affinity-0.5
  (package
    (name "rust-core-affinity")
    (version "0.5.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-affinity" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07qpwyxps4gp3gci2p6c5h4cmcql7551bp91qgbv0ky3bh8h72kz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-winapi" ,rust-winapi-0.2))))
    (home-page "https://github.com/Elzair/core_affinity_rs")
    (synopsis "Manage CPU affinities")
    (description "This package manages CPU affinities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-arch-0.1
  (package
    (name "rust-core-arch")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_arch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04vdvr9vj0f1cv2p54nsszmrrk9w1js4c0z4i0bdlajl1lydslim"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.2))))
    (home-page "https://github.com/rust-lang/stdarch")
    (synopsis
     "Rust's core library architecture-specific intrinsics")
    (description
     "@code{core::arch} - Rust's core library architecture-specific
intrinsics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-foundation-0.9
  (package
    (name "rust-core-foundation")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qhackx0i914nbhcwi6bbxnyyqqldgxc046gviak3a3f8apf528a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f             ;tests fail with a lot of "undefined reference"
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-uuid" ,rust-uuid-0.5))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Core Foundation for macOS")
    (description "This package provides bindings to Core Foundation for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-foundation-0.7
  (package
    (inherit rust-core-foundation-0.9)
    (name "rust-core-foundation")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wbias8f0m5kyn2pcksi0h58fdslams6nmf16w78fgn42dx4rljp"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.7)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-uuid" ,rust-uuid-0.5))))))

(define-public rust-core-foundation-0.6
  (package
    (inherit rust-core-foundation-0.7)
    (name "rust-core-foundation")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0va97wf49c8dzm9c8pgyk1jn7z21rl0bj1syf2zz5m2z2hzy1f95"))))
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.6)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-uuid" ,rust-uuid-0.5))))))

(define-public rust-core-foundation-0.2
  (package
    (inherit rust-core-foundation-0.6)
    (name "rust-core-foundation")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rvcn7ab5r69wvn7gby745jlpy8pirfywcdxbiypy083s93dggr5"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-core-foundation-sys" ,rust-core-foundation-sys-0.2)
        ("rust-libc" ,rust-libc-0.2))))))

(define-public rust-core-foundation-sys-0.8
  (package
    (name "rust-core-foundation-sys")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06wq7yb7mlkc4h2kbc0yjfi0xv44z4snzdpr7c1l0zm4hi91n8pa"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Core Foundation for macOS")
    (description "This package provides bindings to Core Foundation for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-foundation-sys-0.7
  (package
    (inherit rust-core-foundation-sys-0.8)
    (name "rust-core-foundation-sys")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ghrg46h4ci306agr2vwm28w6gb5l455nzp61y2zkhwfs49p4nis"))))))

(define-public rust-core-foundation-sys-0.6
  (package
    (inherit rust-core-foundation-sys-0.7)
    (name "rust-core-foundation-sys")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fzsw1j9g1x598yhwklg59l15hwzc0pyvs01w9fg2kin4598mjp7"))))))

(define-public rust-core-foundation-sys-0.2
  (package
    (inherit rust-core-foundation-sys-0.6)
    (name "rust-core-foundation-sys")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13f7f3kblyj6yxcxm74yg84vj9ahaprlc1vgblagmj6bzmzmsnh6"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))))

(define-public rust-core-text-19
  (package
    (name "rust-core-text")
    (version "19.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-text" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q1sr55v8zq82y0dwnwwksz1radh515i0a45nbsda3w2idpg9iyj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to the Core Text framework")
    (description "This package provides bindings to the Core Text framework.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cov-mark-2
  (package
    (name "rust-cov-mark")
    (version "2.0.0-pre.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cov-mark" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jj4yz70k31ax1n3s7iyjv1k5yzrm4hkibrazqciycyrdgvxhj0d"))))
    (arguments `(#:skip-build? #t))
    (build-system cargo-build-system)
    (home-page "https://github.com/matklad/cov-mark")
    (synopsis "Manual coverage marks")
    (description "This package provides a Manual coverage marks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-countme-3
  (package
    (name "rust-countme")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "countme" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10z4r1xx77sr8axp3lsgc0azidazwgnhpzig2gcx5dfrdl66wx03"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dashmap" ,rust-dashmap-4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1))))
    (home-page "https://github.com/matklad/countme")
    (synopsis
     "Counts the number of live instances of types")
    (description
     "This package provides a counts the number of live instances of types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cpp-demangle-0.3
  (package
    (name "rust-cpp-demangle")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpp_demangle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "142knq32bpa2hbp4z0bldjd1x869664l0ff2gdrqx7pryv59x4a4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-afl" ,rust-afl-0.8)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-glob" ,rust-glob-0.3))))
    (home-page "https://github.com/gimli-rs/cpp_demangle")
    (synopsis "Demangle C++ symbols")
    (description
     "This package provides a crate for demangling C++ symbols.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cpufeatures-0.2
  (package
    (name "rust-cpufeatures")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpufeatures" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sgllzsvs8hinylaiigmd9c908gd8wclxnqz8dinpxbdyql981cm"))))
    (build-system cargo-build-system)
    (arguments `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Alternative to the @code{is_x86_feature_detected!} macro")
    (description
     "Cpufeatures is a lightweight and efficient no-std compatible alternative
to the @code{is_x86_feature_detected!} macro.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cpufeatures-0.1
  (package
    (inherit rust-cpufeatures-0.2)
    (name "rust-cpufeatures")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpufeatures" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j0i97325c2grndsfgnm3lqk0xbyvdl2dbgn8i5dd9yhnmycc07d"))))))

(define-public rust-cpuprofiler-0.0
  (package
    (name "rust-cpuprofiler")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpuprofiler" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0az588yyl9r13w4k7xfdh5ckfaq52fwpjry2q2hblazxpjflgy23"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (inputs
     (list gperftools))
    (home-page "https://github.com/AtheMathmo/cpuprofiler")
    (synopsis "Bindings to Google's cpu profiler")
    (description "This package provides bindings to Google's cpu profiler.")
    (license license:bsd-2)))

(define-public rust-crates-index-0.18
  (package
    (name "rust-crates-index")
    (version "0.18.10")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crates-index" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1x7f7xfvqzlacji88iaz9n4k7wip72sk4gfvxvccli0cbf2yqirl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-git2" ,rust-git2-0.15)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-home" ,rust-home-0.5)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smartstring" ,rust-smartstring-1))))
    (home-page "https://github.com/frewsxcv/rust-crates-index")
    (synopsis "Retrieving and interacting with the crates.io index")
    (description
     "Library for retrieving and interacting with the crates.io index.")
    (license license:asl2.0)))

(define-public rust-crates-index-0.17
  (package
    (inherit rust-crates-index-0.18)
    (name "rust-crates-index")
    (version "0.17.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crates-index" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0izrm8m4wic5kp5y4p3f3d50lrlbamp3wizlgr4hm56rimfazm4a"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-git2" ,rust-git2-0.13)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-home" ,rust-home-0.5)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smartstring" ,rust-smartstring-0.2))))))

(define-public rust-crates-index-0.13
  (package
    (inherit rust-crates-index-0.17)
    (name "rust-crates-index")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-index" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n7pp6mk59hw3nqlh8irxc9pp0g5ziw7bprqsw2lxvg13cvdp76s"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-git2" ,rust-git2-0.9)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-crates-index-0.5
  (package
    (inherit rust-crates-index-0.13)
    (name "rust-crates-index-5")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-index" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gak1czvvdz7l00vkkj61srrfa1sj2yl4ydghhgywydby5qh3mlg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ;"curl error: Could not resolve host: github.com\n"
       #:cargo-inputs
       (("rust-git2" ,rust-git2-0.6)
        ("rust-glob" ,rust-glob-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (native-inputs (list pkg-config))
    (inputs (list zlib openssl libssh2 curl cmake))))

(define-public rust-crates-io-0.33
  (package
    (name "rust-crates-io")
    (version "0.33.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "147mggf85fz77vsrzsvsxxwid4f4fg30zwfyirx7sl1k7y33hw91"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-curl" ,rust-curl-0.4)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))))
    (native-inputs
     (list curl openssl pkg-config zlib))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Helpers for interacting with @url{crates.io}")
    (description "This package provides helpers for interacting with
@url{crates.io}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc-1
  (package
    (name "rust-crc")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1sqal6gm6lbj7f45iv3rw2s9w3pvvha8v970y51s7k7mwy6m8qyn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-build-const" ,rust-build-const-0.2))))
    (home-page "https://crates.io/crates/crc")
    (synopsis "Rust implementation of CRC(16, 32, 64)")
    (description "This package provides a Rust implementation of CRC(16, 32,
64) with support for various standards.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc-any-2
  (package
    (name "rust-crc-any")
    (version "2.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc-any" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fq85y5akcadahnj5nqbs47qhgp5cpfn2z19zc3gp4wpxr3989kr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-debug-helper" ,rust-debug-helper-0.3)
        ("rust-heapless" ,rust-heapless-0.5))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1))))
    (home-page "https://magiclen.org/crc-any")
    (synopsis "Compute CRC values")
    (description "This package provides a crate to compute CRC values by
providing the length of bits, expression, reflection, an initial value and a
final xor value.  It has many built-in CRC functions.")
    (license license:expat)))

(define-public rust-crc32fast-1
  (package
    (name "rust-crc32fast")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc32fast" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "03c8f29yx293yf43xar946xbls1g60c207m9drf8ilqhr25vsh5m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/srijs/rust-crc32fast")
    (synopsis
     "Fast, SIMD-accelerated CRC32 (IEEE) checksum computation")
    (description
     "Fast, SIMD-accelerated CRC32 (IEEE) checksum computation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc64-1
  (package
    (name "rust-crc64")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0469vp0q9431pqx1236g60if5q3xyxpv4h14smkd45dfzsa6aqjm"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/badboy/crc64-rs")
    (synopsis "Rust CRC64 checksum implementation")
    (description "This package provides a CRC64 checksum implementation in
Rust.")
    (license license:bsd-3)))

(define-public rust-criterion-0.3
  (package
    (name "rust-criterion")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "044d2x7cxfvw2g558lzyllcv7jcdkw9xmacmb0nzx8pv4pyxl10n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-cast" ,rust-cast-0.2)
        ("rust-clap" ,rust-clap-2)
        ("rust-criterion-plot" ,rust-criterion-plot-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-oorandom" ,rust-oorandom-11.1)
        ("rust-plotters" ,rust-plotters-0.3)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-cbor" ,rust-serde-cbor-0.11)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smol" ,rust-smol-1)
        ("rust-tinytemplate" ,rust-tinytemplate-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.5)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://bheisler.github.io/criterion.rs/book/index.html")
    (synopsis "Statistics-driven micro-benchmarking library")
    (description
     "This package provides a statistics-driven micro-benchmarking library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-criterion-0.2
  (package
    (inherit rust-criterion-0.3)
    (name "rust-criterion")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1543wlpc4p1kz7sqqa7ylr8bkdr8l4f34hy4bxj7krpkahwhaqq3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-cast" ,rust-cast-0.2)
        ("rust-clap" ,rust-clap-2)
        ("rust-criterion-plot" ,rust-criterion-plot-0.3)
        ("rust-csv" ,rust-csv-1)
        ("rust-itertools" ,rust-itertools-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand-core" ,rust-rand-core-0.3)
        ("rust-rand-os" ,rust-rand-os-0.1)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rayon-core" ,rust-rayon-core-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tinytemplate" ,rust-tinytemplate-1)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-criterion-cycles-per-byte-0.1
  (package
    (name "rust-criterion-cycles-per-byte")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion-cycles-per-byte" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15iw8zvyilx6k3a7z79vpzmpm6kkyds4c1ng3jlwfc43axd4hd4d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://crates.io/crates/criterion-cycles-per-byte")
    (synopsis "Measure time with CPU cycles for criterion")
    (description "This package lets you measure time with CPU cycles for
criterion.")
    (license (list license:expat license:asl2.0))))

(define-public rust-criterion-plot-0.4
  (package
    (name "rust-criterion-plot")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion-plot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mys2zkizh5az6ax77m5aqifk0vz35rn0a6wykvmjx9gkzg9c2fh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cast" ,rust-cast-0.2)
        ("rust-itertools" ,rust-itertools-0.10))
       #:cargo-development-inputs
       (("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/bheisler/criterion.rs")
    (synopsis "Criterion's plotting library")
    (description "This package provides criterion's plotting library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-criterion-plot-0.3
  (package
    (inherit rust-criterion-plot-0.4)
    (name "rust-criterion-plot")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion-plot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13pv09z4ryp70qyzablkibwa2mh6c2852qq1sjr9wjigvwnj3ybn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-cast" ,rust-cast-0.2)
        ("rust-itertools" ,rust-itertools-0.8))
       #:cargo-development-inputs
       (("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-critical-section-1
  (package
    (name "rust-critical-section")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "critical-section" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "06p0j7yy289six3k7j3m3f1phk9n7h9x2cd8fjfbw6fhh4aaaayh"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/rust-embedded/critical-section")
    (synopsis "Critical section abstraction")
    (description "This package provides a critical section abstraction.")
    (license (list license:expat license:asl2.0))))

(define-public rust-critical-section-0.2
  (package
    (name "rust-critical-section")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "critical-section" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w1xl04q3qn3c67wnbiz6d5dsaqgdimyyxwpcydsvvgnlsjr3q81"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bare-metal" ,rust-bare-metal-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cortex-m" ,rust-cortex-m-0.7)
        ("rust-riscv" ,rust-riscv-0.7))))
    (home-page "https://github.com/embassy-rs/critical-section")
    (synopsis "Critical section abstraction")
    (description "This package provides a critical section abstraction.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-0.8
  (package
    (name "rust-crossbeam")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "103xnwzkk1zd9kiy6f0f131ap433qfkc757wyrha5bxa7pmsc0gx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.8)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.9)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.3)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page "https://github.com/crossbeam-rs/crossbeam")
    (synopsis "Tools for concurrent programming in Rust")
    (description "This package provides tools for concurrent programming.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-0.7
  (package
    (inherit rust-crossbeam-0.8)
    (name "rust-crossbeam")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13kzn2d49n2qn5q42y2dj48kyv6aln2d9smq8x9n675l3zzknck9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.7)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.8)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.2)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-channel-0.5
  (package
    (name "rust-crossbeam-channel")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08f5f043rljl82a06d1inda6nl2b030s7yfqp31ps8w8mzfh9pf2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-channel")
    (synopsis "Multi-producer multi-consumer channels for message passing")
    (description
     "This package provides multi-producer multi-consumer channels for
message passing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-channel-0.4
  (package
    (inherit rust-crossbeam-channel-0.5)
    (name "rust-crossbeam-channel")
    (version "0.4.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crossbeam-channel" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0qd05n5bcwafkmbzq1lspwrfi29xnzlw46qarg1sl0lwj68qdvfc"))))
    (arguments
     `(#:cargo-inputs
        (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
         ("rust-maybe-uninit" ,rust-maybe-uninit-2))
        #:cargo-development-inputs
        (("rust-num-cpus" ,rust-num-cpus-1)
         ("rust-rand" ,rust-rand-0.6)
         ("rust-signal-hook" ,rust-signal-hook-0.1))))))

(define-public rust-crossbeam-channel-0.3
  (package
    (inherit rust-crossbeam-channel-0.4)
    (name "rust-crossbeam-channel")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-channel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ylyzb1m9qbvd1nd3vy38x9073wdmcy295ncjs7wf7ap476pzv68"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-signal-hook" ,rust-signal-hook-0.1))))))

(define-public rust-crossbeam-deque-0.8
  (package
    (name "rust-crossbeam-deque")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-deque" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ad995vzq74k7jd1pgn9zxbacyzj9ii6l0svhlb2dxzy8vxnxbwl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.9)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-deque")
    (synopsis "Concurrent work-stealing deque")
    (description "This package provides a concurrent work-stealing deque.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-deque-0.7
  (package
    (inherit rust-crossbeam-deque-0.8)
    (name "rust-crossbeam-deque")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-deque" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11c2c0x5grdba3ah3g94yn6b8s47xi8qwm85h8hq5vmf9nbsy0lz"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.8)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-epoch-0.9
  (package
    (name "rust-crossbeam-epoch")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17anyfg5azjpmcfidq6wn4phj9h0a0zqcxksi33w44akz4wsgam1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-const-fn" ,rust-const-fn-0.4)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memoffset" ,rust-memoffset-0.6)
        ("rust-scopeguard" ,rust-scopeguard-1))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-epoch")
    (synopsis "Epoch-based garbage collection")
    (description "This package provides an Epoch-based garbage collection.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-epoch-0.8
  (package
    (inherit rust-crossbeam-epoch-0.9)
    (name "rust-crossbeam-epoch")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1knsf0zz7rgzxn0nwz5gajjcrivxpw3zrdcp946gdhdgr9sd53h5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2)
        ("rust-memoffset" ,rust-memoffset-0.5)
        ("rust-scopeguard" ,rust-scopeguard-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-queue-0.3
  (package
    (name "rust-crossbeam-queue")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19ram1wp87i57w834hwl95mzz9g53qlzkraq6lvab629n21jbm0w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils")
    (synopsis "Concurrent queues in Rust")
    (description
     "This crate provides concurrent queues that can be shared among threads.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-queue-0.2
  (package
    (inherit rust-crossbeam-queue-0.3)
    (name "rust-crossbeam-queue")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w15z68nz3ac4f2s4djhwha8vmlwsh9dlfrmsl4x84y2ah5acjvp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-queue-0.1
  (package
    (inherit rust-crossbeam-queue-0.2)
    (name "rust-crossbeam-queue")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jsa9dbxnwqcxfws09vaschf92d4imlbbikmcn4ka8z7rzb9r5vw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-utils-0.8
  (package
    (name "rust-crossbeam-utils")
    (version "0.8.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g426qw2j7czkbg0vw6mzifhgy1ng4qgpp2sn4vlamkvvi57v22i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-loom" ,rust-loom-0.5)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils")
    (synopsis "Utilities for concurrent programming")
    (description
     "This crate provides miscellaneous tools for concurrent programming.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-utils-0.7
  (package
    (inherit rust-crossbeam-utils-0.8)
    (name "rust-crossbeam-utils")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a31wbrda1320gj2a6az1lin2d34xfc3xf88da4c17qy5lxcgiy3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-utils-0.6
  (package
    (inherit rust-crossbeam-utils-0.7)
    (name "rust-crossbeam-utils")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rk0r9n04bmq4a3g2q5qhvvlmrmx780gc6h9lmc94mwndslkz5q4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossfont-0.3
  (package
    (name "rust-crossfont")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossfont" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "079431wkjc18zj3038djai83z6fna0x7r1hxpxjhhi50jdz9dh5n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cocoa" ,rust-cocoa-0.24)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-core-text" ,rust-core-text-19)
        ("rust-dwrote" ,rust-dwrote-0.11)
        ("rust-foreign-types" ,rust-foreign-types-0.5)
        ("rust-freetype-rs" ,rust-freetype-rs-0.26)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-servo-fontconfig" ,rust-servo-fontconfig-0.5)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/alacritty/crossfont")
    (synopsis "Native font loading and rasterization")
    (description
     "Crossfont is a cross-platform Rust library for loading fonts and
rasterizing glyphs, using native font engines whenever possible.")
    (license license:asl2.0)))

(define-public rust-crossterm-0.20
  (package
    (name "rust-crossterm")
    (version "0.20.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z8zkk2mfiirbr3slfv564n685yiahr2aj3gdk6k3qymkmmdxsy0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.8)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/crossterm-rs/crossterm")
    (synopsis "Crossplatform terminal library for manipulating terminals")
    (description
     "This package provides a crossplatform terminal library for manipulating
terminals.")
    (license license:expat)))

(define-public rust-crossterm-0.19
  (package
    (inherit rust-crossterm-0.20)
    (name "rust-crossterm")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1348lqf8vy3lb2s5icsl3rxs4a4vrpfw5z2j6lplnhnz600w2dkw"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.7)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.8
  (package
    (name "rust-crossterm-winapi")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01q57jwnlicqxa2igg5nig3916kf5w6sqgbxk40q6hr2frh6cs9s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/crossterm-rs/crossterm-winapi")
    (synopsis "Basic simple abstractions around common WinAPI calls")
    (description
     "This package is a WinAPI wrapper that provides some basic simple
abstractions around common WinAPI calls.")
    (license license:expat)))

(define-public rust-crossterm-winapi-0.7
  (package
    (inherit rust-crossterm-winapi-0.8)
    (name "rust-crossterm-winapi")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fa047zz228qyqbcjdss64j0n01p4adr29yh9w24lgjdrr59da0d"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.6
  (package
    (inherit rust-crossterm-winapi-0.7)
    (name "rust-crossterm-winapi")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nqhjp979c6iv092dbxl6hpncwgwjciafyj1nvcpa008iqzmq9n2"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.4
  (package
    (inherit rust-crossterm-winapi-0.7)
    (name "rust-crossterm-winapi")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm-winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j3av8bba3f5y4n4w1vgn0iz28vdajxrli6lqxnvpddbphskmph2"))))
    (arguments
     `(#:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crunchy-0.2
  (package
    (name "rust-crunchy")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crunchy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dx9mypwd5mpfbbajm78xcrg5lirqk7934ik980mmaffg3hdm0bs"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://docs.rs/crate/crunchy/0.2.2/source/")
    (synopsis "Deterministically unroll constant loops")
    (description
     "The Crunchy unroller deterministically unrolls constant loops, for
number ``crunching``.")
    (license license:expat)))

(define-public rust-crunchy-0.1
  (package
    (inherit rust-crunchy-0.2)
    (name "rust-crunchy")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crunchy" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1nnbh2k3pv1diyd0i0p3a08kd4afqc17yz0b43hn5xn9qlqs9x52"))))))

(define-public rust-roxmltree-0.14
  (package
    (name "rust-roxmltree")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "roxmltree" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "010mahzyarkzb7kaawgga1a9y46nsp209yh2i4g4pq98bg8afn5z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-xmlparser" ,rust-xmlparser-0.13))))
    (home-page "https://github.com/RazrFalcon/roxmltree")
    (synopsis "Represent an XML as a read-only tree")
    (description
     "@code{roxmltree} represents an XML 1.0 document as a read-only tree.")
    (license (list license:expat license:asl2.0))))

(define-public rust-rust-crypto-0.2
  (package
    (name "rust-rust-crypto")
    (version "0.2.36")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "rust-crypto" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0aias7gh2ypj4skmh6hfsjli4fhnvcvf9s1ljjpz9m9zk79havgp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gcc" ,rust-gcc-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/DaGenix/rust-crypto/")
    (synopsis "Mostly pure-Rust implementation of various cryptographic algorithms")
    (description
     "This package provides a (mostly) pure-Rust implementation of various
common cryptographic algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-rusticata-macros-4
  (package
    (name "rust-rusticata-macros")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "rusticata-macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "03dmfxhgwzpm1360iwcpcg3y18ddgya0i0hc599am212pdvj7ib5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-7))))
    (home-page "https://github.com/rusticata/rusticata-macros")
    (synopsis "Helper macros for Rusticata")
    (description "Helper macros for Rusticata.")
    (license (list license:expat license:asl2.0))))

(define-public rust-rusticata-macros-3
  (package
    (inherit rust-rusticata-macros-4)
    (name "rust-rusticata-macros")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "rusticata-macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1b91k644rqblbam6rfhhmgcxs0zddldi2h0w93aapv1kqq9fbgpv"))))
    (arguments
     `(#:cargo-inputs (("rust-nom" ,rust-nom-6))))))

(define-public rust-crypto-bigint-0.2
  (package
    (name "rust-crypto-bigint")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-bigint" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00qckh65nzb7s7vd60wylw6alxf9g37xh31lirb1qw0l8fxx6fzq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-rand-core" ,rust-rand-core-0.6)
        ("rust-rlp" ,rust-rlp-0.5)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://github.com/RustCrypto/crypto-bigint")
    (synopsis "Big integer library designed for use in cryptography")
    (description
     "This crate is a pure Rust implementation of a big integer library which
has been designed from the ground-up for use in cryptographic applications.
Provides constant-time, no_std-friendly implementations of modern formulas
using const generics.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-crypto-common-0.1
  (package
    (name "rust-crypto-common")
    (version "0.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crypto-common" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1l4q4ync13i056vjc775v0za8qh987da7yvrjj25q909cd9nngb8"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build?
        #t
        #:cargo-inputs
        (("rust-generic-array" ,rust-generic-array-0.14)
         ("rust-rand-core" ,rust-rand-core-0.6))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Common cryptographic traits")
    (description "Common cryptographic traits")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-mac-0.11
  (package
    (name "rust-crypto-mac")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ghh3qmjf7hv580zqdk4yrbg99v57jx773zb7lzi7j4hj24bdyi5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.3)
        ("rust-cipher" ,rust-cipher-0.3)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-subtle" ,rust-subtle-2))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Trait for Message Authentication Code (MAC) algorithms")
    (description "This package provides trait for @dfn{Message Authentication
Code} (MAC) algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-mac-0.10
  (package
    (inherit rust-crypto-mac-0.11)
    (name "rust-crypto-mac")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crypto-mac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "19iyh7h9qaqrv29dhbd31rm6pq023ry78nw7jwr3qjy3l22zsms8"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.3)
        ("rust-cipher" ,rust-cipher-0.2)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-subtle" ,rust-subtle-2))))))

(define-public rust-crypto-mac-0.8
  (package
    (inherit rust-crypto-mac-0.10)
    (name "rust-crypto-mac")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1axfs4zmy74rn9666p92j7nmcv11zdp2d51yrppc2dv26cqa715m"))))
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-subtle" ,rust-subtle-2))))))

(define-public rust-crypto-mac-0.7
  (package
    (inherit rust-crypto-mac-0.10)
    (name "rust-crypto-mac")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rbrq6qy9dl0pj4ym2zy33miaaa8vpzdss60p9bdb58xy46l0d24"))))
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.12)
        ("rust-subtle" ,rust-subtle-1))))))

(define-public rust-crypto-mac-0.5
  (package
    (inherit rust-crypto-mac-0.10)
    (name "rust-crypto-mac")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n6r10zlnfv9gbjj0380sxfffxhq1khfjqwsn7fx8iil9pzv9689"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-constant-time-eq" ,rust-constant-time-eq-0.1)
        ("rust-generic-array" ,rust-generic-array-0.9))))))

(define-public rust-crypto-mac-0.4
  (package
    (name "rust-crypto-mac")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "160ixpghhz5kz16f38kzcyv6lx8wmi4cgbhlhq4nazf678iib43p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-constant-time-eq" ,rust-constant-time-eq-0.1)
        ("rust-generic-array" ,rust-generic-array-0.8))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Trait for Message Authentication Code (MAC) algorithms")
    (description "This package provides traits for Message Authentication
Code (MAC) algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-tests-0.5
  (package
    (name "rust-crypto-tests")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-tests" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08yrh40a9ll4k29ppizg2yjf96i6s3i9pbkhxp60y8arar93134v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-block-cipher-trait" ,rust-block-cipher-trait-0.4)
        ("rust-crypto-mac" ,rust-crypto-mac-0.4)
        ("rust-digest" ,rust-digest-0.6)
        ("rust-generic-array" ,rust-generic-array-0.8))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Test helpers for cryptographic algorithms")
    (description "This package provides test helpers for cryptographic
algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-hash-0.3
  (package
    (name "rust-crypto-hash")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-hash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jnxgpk0j29hzcv42viq5dckyfjnxdjsar55366j95zx80i1cxwa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-commoncrypto" ,rust-commoncrypto-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-winapi" ,rust-winapi-0.3))))
    (inputs
     (list openssl))
    (home-page "https://github.com/malept/crypto-hash")
    (synopsis "Wrapper for OS-level cryptographic hash functions")
    (description "This package provides a wrapper for OS-level cryptographic
hash functions.")
    (license license:expat)))

(define-public rust-cssparser-0.28
  (package
    (name "rust-cssparser")
    (version "0.28.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h924c5g2rwlmgk8hllciyky3ih3z9vf04xz3xsp3cv1jyd5kf0x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/servo/rust-cssparser")
    (synopsis "Rust implementation of CSS Syntax Level 3")
    (description
     "This package contains a Rust implementation of CSS Syntax Level 3.")
    (license license:mpl2.0)))

(define-public rust-cssparser-0.27
  (package
    (inherit rust-cssparser-0.28)
    (name "rust-cssparser")
    (version "0.27.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02nbm690rmkaz1ca0383qq7mc1g066w3s85f17pdihnda79njjvm"))))
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-0.25
  (package
    (inherit rust-cssparser-0.27)
    (name "rust-cssparser")
    (version "0.25.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "03klvpdzsk4cyh8k0dbnlngzafv7gqywqrnsqqb3gfmrxyj8rqgv"))))
    (arguments
     `(#:tests? #f      ; Some test files missing.
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.3)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-heapsize" ,rust-heapsize-0.4)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.7)
        ("rust-procedural-masquerade" ,rust-procedural-masquerade-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-autocfg" ,rust-autocfg-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-macros-0.6
  (package
    (name "rust-cssparser-macros")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vp13g4blyjvhg3j4r9b7vrwhnfi1y2fmhv8hxgficpjazg7bbnz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/servo/rust-cssparser")
    (synopsis "Procedural macros for cssparser")
    (description
     "This package provides the procedural macros for rust-cssparser.")
    (license license:mpl2.0)))

(define-public rust-cssparser-macros-0.3
  (package
    (inherit rust-cssparser-macros-0.6)
    (name "rust-cssparser-macros")
    (version "0.3.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vqyc5xm8a4va92vs1nn0cc46c930l2n21gccijnc5y7hx7cicav"))))
    (arguments
     `(#:cargo-inputs
       (("rust-phf-codegen" ,rust-phf-codegen-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-procedural-masquerade" ,rust-procedural-masquerade-0.1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-csv-1
  (package
    (name "rust-csv")
    (version "1.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q9nqn0qlamwl18v57p82c8yhxy43lkzf2z1mndmycsvqinkm092"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-csv-core" ,rust-csv-core-0.1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-ryu" ,rust-ryu-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis "Fast CSV parsing with support for serde")
    (description
     "Fast CSV parsing with support for serde.")
    (license (list license:unlicense license:expat))))

(define-public rust-csv-0.14
  (package
    (inherit rust-csv-1)
    (name "rust-csv")
    (version "0.14.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g0qvr9fj25fq1fy0p758glrb30yz7x46h18hsysaqyaswaihv16"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-0.5)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))
       #:cargo-development-inputs
       (("rust-regex" ,rust-regex-0.1))))))

(define-public rust-cortex-m-0.7
  (package
    (name "rust-cortex-m")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cortex-m" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cw3nyip3s81r6qaa3azrb0654jxw465j5fm126fqja48bpikj9a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bare-metal" ,rust-bare-metal-0.2)
        ("rust-bitfield" ,rust-bitfield-0.13)
        ("rust-embedded-hal" ,rust-embedded-hal-0.2)
        ("rust-volatile-register" ,rust-volatile-register-0.2))))
    (home-page "https://github.com/rust-embedded/cortex-m")
    (synopsis "Low level access to Cortex-M processors")
    (description "This package provides low level access to Cortex-M
processors.")
    (license (list license:expat license:asl2.0))))

(define-public rust-csv-core-0.1
  (package
    (name "rust-csv-core")
    (version "0.1.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "145wcc3560v1kmysqqspvddppiysr2rifqzy4nnlh3r6kxanc91b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.5))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis
     "Bare bones CSV parsing with no_std support")
    (description
     "Bare bones CSV parsing with no_std support.")
    (license (list license:unlicense license:expat))))

(define-public rust-cstr-core-0.2
  (package
    (name "rust-cstr-core")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cstr_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fymp34mv7bix8m35pw3qs30b7879wmaym03ihfbzdl84plwa1r8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cty" ,rust-cty-0.2)
        ("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/Amanieu/cstr_core")
    (synopsis "Implementation of CStr and CString for no_std environments")
    (description
     "This crates implements CStr and CString for no_std environments.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ct-logs-0.8
  (package
    (name "rust-ct-logs")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j5as2h789c2gazq3drl5i58xk8zzx6sxd1wdr19x3d6dwc1da61"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-sct" ,rust-sct-0.6))))
    (home-page "https://github.com/ctz/ct-logs")
    (synopsis "Google's list of Certificate Transparency logs")
    (description
     "This package contains Google's list of Certificate Transparency logs for
use with sct crate.")
    (license (list license:asl2.0 license:isc license:expat))))

(define-public rust-ct-logs-0.7
  (package
    (inherit rust-ct-logs-0.8)
    (name "rust-ct-logs")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bk7pbmkjm18cgccm4a76vyn3wkaf2z4bh0jy9fk3dl4188i73lc"))))
    (arguments
     `(#:cargo-inputs (("rust-sct" ,rust-sct-0.6))))))

(define-public rust-ct-logs-0.6
  (package
    (inherit rust-ct-logs-0.7)
    (name "rust-ct-logs")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04wiwiv4ghni3x2vni3z711mlz0ndqvh04vmdkbw3nr7zbsqcdjd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-sct" ,rust-sct-0.6))))))

(define-public rust-ct-logs-0.3
  (package
    (inherit rust-ct-logs-0.7)
    (name "rust-ct-logs")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f0885ws3p49xh6dfgnhh7zjw9h4rhs9ljs8i9cnkhifzz98784f"))))
    (arguments
     `(#:cargo-inputs
       (("rust-sct" ,rust-sct-0.3))))))

(define-public rust-ctor-0.1
  (package
    (name "rust-ctor")
    (version "0.1.15")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ctor" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09x2my9x33srjdip8yf4lm5gq7xqis2694abvpa64r60pajqm19r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))
       #:cargo-development-inputs
       (("rust-libc-print" ,rust-libc-print-0.1))))
    (home-page "https://github.com/mmastrac/rust-ctor")
    (synopsis "__attribute__((constructor)) for Rust")
    (description
     "This package provides an @code{__attribute__((constructor))} for Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ctr-0.8
  (package
    (name "rust-ctr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ctr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sk1aykwhkny92cnvl6s75dx3fyvfzw5xkd6xz3y7w5anhgvk6q4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-cipher" ,rust-cipher-0.3))))
    (home-page "https://docs.rs/ctr/")
    (synopsis "CTR block mode of operation")
    (description "This package provides a generic implementations of CTR mode
for block ciphers. Mode functionality is accessed using traits from
re-exported cipher crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ctr-0.6
  (package
    (inherit rust-ctr-0.8)
    (name "rust-ctr")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ctr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zvyf13675hrlc37myj97k5ng7m1mj3d9p4ic4yvyhvl9zak0jpv"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-cipher" ,rust-cipher-0.2))))))

(define-public rust-ctrlc-3
  (package
    (name "rust-ctrlc")
    (version "3.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ctrlc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "027bzbddk0wg7s2wnbgcwx2iv6bjzvxfpp0s2xdg444yfklr4ymm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nix" ,rust-nix-0.18)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Detegr/rust-ctrlc")
    (synopsis "Easy Ctrl-C handler for Rust projects")
    (description
     "This package provides an easy Ctrl-C handler for Rust projects.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cty-0.2
  (package
    (name "rust-cty")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cty" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qvkdnkxmd7g6fwhmv26zxqi0l7b9cd4d7h1knylvjyh43bc04vk"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/japaric/cty")
    (synopsis "Type aliases to C types")
    (description "This package provides type aliases to C types like c_int for
use with bindgen.")
    (license (list license:expat license:asl2.0))))

(define-public rust-curl-0.4
  (package
    (name "rust-curl")
    (version "0.4.34")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "curl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vkm6fyizf8m9yxpv3n5pm9ag3bwlyqa6nz2ga8qkzm5y4m1cs72"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;require internet access
       #:cargo-inputs
       (("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-schannel" ,rust-schannel-0.1)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list curl nghttp2 openssl zlib))
    (home-page "https://github.com/alexcrichton/curl-rust")
    (synopsis "Rust bindings to libcurl for making HTTP requests")
    (description
     "This package provides Rust bindings to libcurl for making HTTP
requests")
    (license license:expat)))

(define-public rust-curl-sys-0.4
  (package
    (name "rust-curl-sys")
    (version "0.4.44+curl-7.77.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "curl-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wds1gi15fja0i8gjfgk0a6c17ljsv17jvlngh8ky69b6blqavab"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "curl") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-libnghttp2-sys" ,rust-libnghttp2-sys-0.1)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-mesalink" ,rust-mesalink-1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list curl nghttp2 openssl zlib))
    (home-page "https://github.com/alexcrichton/curl-rust")
    (synopsis "Native bindings to the libcurl library")
    (description
     "This package provides native bindings to the @code{libcurl} library.")
    (license license:expat)))

(define-public rust-curve25519-dalek-3
  (package
    (name "rust-curve25519-dalek")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "curve25519-dalek" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q8v97275cy6v4ly6y2qwv9a8phnpjg9sy8kv7r6mgdjfacxz7qb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-fiat-crypto" ,rust-fiat-crypto-0.1)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-rand-core" ,rust-rand-core-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-sha2" ,rust-sha2-0.9))))
    (home-page "https://dalek.rs/curve25519-dalek")
    (synopsis "Group operations on ristretto255 and Curve25519")
    (description
     "This package provides a pure-Rust implementation of group operations on
ristretto255 and Curve25519.")
    (license license:bsd-3)))

(define-public rust-custom-derive-0.1
  (package
    (name "rust-custom-derive")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "custom_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f81bavw1wnykwh21hh4yyzigs6zl6f6pkk9p3car8kq95yfb2pg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (home-page
     "https://github.com/DanielKeep/rust-custom-derive/tree/custom_derive-master")
    (synopsis "Custom derivation macro for Rust")
    (description
     "This crate provides a macro that enables the use of custom @code{derive}
attributes.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cxx-1
  (package
    (name "rust-cxx")
    (version "1.0.49")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0xj29zzd45bkk797902h22kppzmrzm7v9a2wijfiqr964vhrldk5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Cannot compile cxx-test-suite.
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-cxxbridge-flags" ,rust-cxxbridge-flags-1)
        ("rust-cxxbridge-macro" ,rust-cxxbridge-macro-1)
        ("rust-link-cplusplus" ,rust-link-cplusplus-1))
       #:cargo-development-inputs
       (("rust-cxx-build" ,rust-cxx-build-1)
        ("rust-cxx-gen" ,rust-cxx-gen-0.7)
        ("rust-cxx-test-suite" ,rust-cxx-test-suite-0.0.0)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://cxx.rs")
    (synopsis "Safe interop between Rust and C++")
    (description "This package provides a safe interop between Rust and C++.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-0.5
  (package
    (inherit rust-cxx-1)
    (name "rust-cxx")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1alj19zf8jm5j8c8hynqb36f0vyjqs8yhwmxpcapfmb5lav4ipgb"))))
    (arguments
     `(#:tests? #f  ; Cannot compile cxx-test-suite.
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-cxxbridge-flags" ,rust-cxxbridge-flags-0.5)
        ("rust-cxxbridge-macro" ,rust-cxxbridge-macro-0.5)
        ("rust-link-cplusplus" ,rust-link-cplusplus-1))
       #:cargo-development-inputs
       (("rust-cxx-build" ,rust-cxx-build-0.5)
        ("rust-cxx-gen" ,rust-cxx-gen-0.6)
        ("rust-cxx-test-suite" ,rust-cxx-test-suite-0.0.0)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-cxx-build-1
  (package
    (name "rust-cxx-build")
    (version "1.0.49")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-build" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0shmkgv3cnh06ws1p555znj1hh23phynaz73rgnz95gradsdwnwg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.11)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-scratch" ,rust-scratch-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cxx-gen" ,rust-cxx-gen-0.7)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://cxx.rs")
    (synopsis "C++ code generator")
    (description
     "This package provides a C++ code generator for integrating the @code{cxx}
crate into a Cargo build.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-build-0.5
  (package
    (inherit rust-cxx-build-1)
    (name "rust-cxx-build")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-build" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "01109arjlj8wdq2rcyy3s76a5aidkn7zvhhhvhvkg1cxgqza9p22"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-scratch" ,rust-scratch-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cxx-gen" ,rust-cxx-gen-0.6)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))))

(define-public rust-cxx-gen-0.7
  (package
    (name "rust-cxx-gen")
    (version "0.7.49")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-gen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "08v366jxd2vc8jc2cbvrga0866pwfcaq6hl8yylfx0vhs2n53j53"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.11)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://cxx.rs")
    (synopsis "C++ code generator")
    (description
     "This package provides a C++ code generator for integrating the @code{cxx}
crate into higher level tools.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-gen-0.6
  (package
    (inherit rust-cxx-gen-0.7)
    (name "rust-cxx-gen")
    (version "0.6.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-gen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0avkca16wjy0paplq1ycaf04bj62agfj0awyhyzxyfpdn9rm45j2"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.9)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-cxx-test-suite-0.0.0
  (package
    (name "rust-cxx-test-suite")
    (version "0.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-test-suite" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1pkf4ay1210g9wqyqhkgvlcsv4i6kgdcmgnh19mrymylznv7pcal"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t)) ; Not meant to be built independantly.
    (home-page "https://github.com/dtolnay/cxx")
    (synopsis "Test suite of the cxx crate")
    (description "This package provides the test suite of the cxx crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-flags-1
  (package
    (name "rust-cxxbridge-flags")
    (version "1.0.49")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-flags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18cv8a8sgyiwfqspdyfq18jizf0rlhg90ibdl0zp8jhcv498s6gr"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/cxx")
    (synopsis "Compiler configuration of the `cxx` crate")
    (description "This package provides a compiler configuration of the `cxx`
crate (implementation detail).")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-flags-0.5
  (package
    (inherit rust-cxxbridge-flags-1)
    (name "rust-cxxbridge-flags")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-flags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0jfwsm85s5kalgqbqlg1kq79zcb5zwk375h0qw7ycz5i6v3c8j0k"))))))

(define-public rust-cxxbridge-macro-1
  (package
    (name "rust-cxxbridge-macro")
    (version "1.0.49")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-macro" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0gkwvihw74dh8p3fz3552wnxanrpwmwfy38ylz2z8knjq0y8y4v3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clang-ast" ,rust-clang-ast-0.1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cxx" ,rust-cxx-1))))
    (home-page "https://cxx.rs")
    (synopsis "Implementation detail of the `cxx` crate")
    (description
     "This package provides an implementation detail of the @code{cxx} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-macro-0.5
  (package
    (inherit rust-cxxbridge-macro-1)
    (name "rust-cxxbridge-macro")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-macro" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05mhvchmcb8dpgcqkl5vyxycywp2x42vw1qh2hyxxyi576nmmxsr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cxx" ,rust-cxx-0.5))))))

(define-public rust-daemonize-0.4
  (package
    (name "rust-daemonize")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "daemonize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05cqr2zjxrxyg23snykd03sgqwxn0pvwj2lzh50bclsgwc9lbhkh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-boxfnonce" ,rust-boxfnonce-0.1)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/knsd/daemonize")
    (synopsis "Library for writing system daemons")
    (description "Daemonize is a Rust library for writing system deaemons.")
    (license (list license:expat license:asl2.0))))

(define-public rust-darling-0.14
  (package
    (name "rust-darling")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00mc7svmwphywkwndzkjxsqaxhygrm8f4jv1p1lngzd7vn5naaa5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.14)
        ("rust-darling-macro" ,rust-darling-macro-0.14))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Proc-macro library for reading attributes in custom derives")
    (description
     "This package provides a proc-macro library for reading attributes
into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-darling-0.13
  (package
    (inherit rust-darling-0.14)
    (name "rust-darling")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x7pgzjswg28798zd5gk5g6nifhcaqq0apqmclydi39zd2w21myh"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.13)
        ("rust-darling-macro" ,rust-darling-macro-0.13))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-0.12
  (package
    (inherit rust-darling-0.13)
    (name "rust-darling")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g4bkxpwl6i5jav5qqzny39yd5a1fdlh5l0mj020njza6ksl6b2z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.12)
        ("rust-darling-macro" ,rust-darling-macro-0.12))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-0.10
  (package
    (inherit rust-darling-0.12)
    (name "rust-darling")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0n7qsp6854wm3y1q1lvylhv15zvc87ibbac1nyfmcdbyv1snww0d"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.10)
        ("rust-darling-macro" ,rust-darling-macro-0.10))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-0.9
  (package
    (inherit rust-darling-0.10)
    (name "rust-darling")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1mnksf0i47pb7sxvi1iqfwmqy9iny0x8w56ilybpb431b46cpyzw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.9)
        ("rust-darling-macro" ,rust-darling-macro-0.9))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-darling-core-0.14
  (package
    (name "rust-darling-core")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vyvkx7qkz6ap5dwgsz8dg588xjigny8s7mrkz0fmcg806y93734"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.10)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Helper crate for @code{rust-darling}")
    (description
     "Helper crate for @code{rust-darling}, a proc-macro library for
reading attributes into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-darling-core-0.13
  (package
    (inherit rust-darling-core-0.14)
    (name "rust-darling-core")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0933k2avb6xk9j4ryr0bvp3pww5j8i0nrqvsnkgd3vic3lj0yd3s"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.10)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-core-0.12
  (package
    (inherit rust-darling-core-0.13)
    (name "rust-darling-core")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dpscl87s75h6yhrmzdsapx86lc4y16m554xg4hiq2l3hrdlb4cf"))))))

(define-public rust-darling-core-0.10
  (package
    (inherit rust-darling-core-0.12)
    (name "rust-darling-core")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16sija1jv0l754x4aa6b6fy01d1kf8m0r4id3flqipm45np61jgh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.9)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-core-0.9
  (package
    (inherit rust-darling-core-0.10)
    (name "rust-darling-core")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_core" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0b201dx4m58l5ac7gmbjvbf4z2xipnk5d4pqa7mz7gy3f21h3z3a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-strsim" ,rust-strsim-0.7)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-darling-macro-0.14
  (package
    (name "rust-darling-macro")
    (version "0.14.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_macro" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1dag2f4bq38vdn886slqczip5qzhvb95317kl04zrlnbpz2nkz6x"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-darling-core" ,rust-darling-core-0.14)
         ("rust-quote" ,rust-quote-1)
         ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Helper crate for @code{rust-darling}")
    (description
     "This package provides internal support for @code{rust-darling},
a proc-macro library for reading attributes into structs when implementing
custom derives.")
    (license license:expat)))

(define-public rust-darling-macro-0.13
  (package
    (inherit rust-darling-macro-0.14)
    (name "rust-darling-macro")
    (version "0.13.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_macro" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0jzljnd0y7idi5lb7lhvymh3nkhaf32ksx0d38hv7zjjfcxipi3j"))))
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-darling-core" ,rust-darling-core-0.13)
         ("rust-quote" ,rust-quote-1)
         ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.12
  (package
    (inherit rust-darling-macro-0.13)
    (name "rust-darling-macro")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nn9mxl7gs827rx5s6lbjvvghipxjdg2qpdjyxk7yym3vvqard99"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.12)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.10
  (package
    (inherit rust-darling-macro-0.12)
    (name "rust-darling-macro")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wlv31cxkrjijz5gv13hvk55c9lmd781aj12c8n84sa9mksa5dfr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.10)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.9
  (package
    (inherit rust-darling-macro-0.10)
    (name "rust-darling-macro")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_macro" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1lcq9418w0vmvncg4a3n9k64zjvqz0048aviqi0rmlpiqv0xmn66"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.9)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-dashmap-4
  (package
    (name "rust-dashmap")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1773x18k5m2zw1iyibs8l3wl1p1aijdbrc0w844xys06inr46yp7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/xacrimon/dashmap")
    (synopsis "Blazing fast concurrent HashMap for Rust")
    (description "This package implements a blazing fast concurrent HashMap
for Rust.")
    (license license:expat)))

(define-public rust-dashmap-3
  (package
    (inherit rust-dashmap-4)
    (name "rust-dashmap")
    (version "3.11.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ddrjj4khb0s263pw278g5dvbhaid40611h123s9w5shr0phw9hg"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Enable unstable features
           (substitute* "src/lib.rs"
             (("#!\\[cfg_attr" all)
              (string-append "#![feature(map_get_key_value)]" "\n"
                             "#![feature(inner_deref)]" "\n"
                             all)))
           #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.3)
        ("rust-hashbrown" ,rust-hashbrown-0.8)
        ("rust-serde" ,rust-serde-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))))

(define-public rust-data-encoding-2
  (package
    (name "rust-data-encoding")
    (version "2.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "data-encoding" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "027rcrwdschrkdr2n9d24gnh03vl41qmvhjqn9vn6z1njy2n0flr"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/ia0/data-encoding")
    (synopsis "Efficient and customizable data-encoding functions")
    (description
     "This library provides encodings for many different common cases, including
hexadecimal, base32, and base64.")
    (license license:expat)))

(define-public rust-data-url-0.1
  (package
    (name "rust-data-url")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "data-url" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "176wa1n8h71iwyaxhar4sqwrgrvb5sxk26az0fy88vnxrsffjgyk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-matches" ,rust-matches-0.1))
       #:cargo-development-inputs
       (("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/servo/rust-url")
    (synopsis "Processing of data: URL according to WHATWG's Fetch Standard")
    (description
     "Processing of data: URL according to WHATWG's Fetch Standard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-datetime-0.5
  (package
    (name "rust-datetime")
    (version "0.5.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "datetime" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1g2lhc2ay46njrnnyc0729ibyzkpv3r3d4g0h3gzwmrygykzghs4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
        (("rust-iso8601" ,rust-iso8601-0.3)
         ("rust-libc" ,rust-libc-0.2)
         ("rust-locale" ,rust-locale-0.2)
         ("rust-num-traits" ,rust-num-traits-0.2)
         ("rust-pad" ,rust-pad-0.1)
         ("rust-redox-syscall" ,rust-redox-syscall-0.1)
         ("rust-winapi" ,rust-winapi-0.3))
        #:cargo-development-inputs
        (("rust-regex" ,rust-regex-0.1)
         ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (home-page "https://github.com/rust-datetime/datetime")
    (synopsis "Library for date and time formatting and arithmetic")
    (description "This package provides a library for date and time formatting
and arithmetic.")
    (license license:expat)))

(define-public rust-dbl-0.3
  (package
    (name "rust-dbl")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dbl" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1pihf6zrzncbs3lsyqkzxxxqmjf8rfpwvs1sg8nmz8cv7df18d97"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://docs.rs/dbl")
    (synopsis "Double operation in Galois Field")
    (description
      "This package provides double and inverse double over Galois Field -
GF(2^n).  This trait is implemented for 64, 128 and 256 bit block
sizes.  Big-endian order is used.  WARNING: Block must be aligned!")
    (license (list license:expat license:asl2.0))))

(define-public rust-dbus-0.9
  (package
    (name "rust-dbus")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dbus" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ny01n0gzfdmcy5ydn4q78pamidj4c5q9ixz7gr97dbrza6y15zm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f          ;it needs display and sockets and launches daemons
       #:cargo-inputs
       (("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libdbus-sys" ,rust-libdbus-sys-0.2))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list dbus))
    (home-page "https://github.com/diwic/dbus-rs")
    (synopsis "Rust bindings to D-Bus")
    (description "This package provides Rust bindings to D-Bus.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dbus-tree-0.9
  (package
    (name "rust-dbus-tree")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dbus-tree" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l2gi8073cwvv5vxlg5lafw6sppyhgm88hhpq7hak424x4kifpmi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-dbus" ,rust-dbus-0.9))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list dbus))
    (home-page "https://github.com/diwic/dbus-rs")
    (synopsis "Framework for writing D-Bus method handlers (legacy)")
    (description
     "This crate is a framework for writing D-Bus method handlers (legacy).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-deadpool-0.7
  (package
    (name "rust-deadpool")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deadpool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vb18xvhmyg6gvvq5vrcqmy4x26ryrmkqpsgwmb4bvkav1wn24ix"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-config" ,rust-config-0.10)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/bikeshedder/deadpool")
    (synopsis "Dead simple async pool")
    (description
     "Deadpool is a dead simple async pool for connections and objects of any
type.")
    (license (list license:expat license:asl2.0))))

(define-public rust-debug-helper-0.3
  (package
    (name "rust-debug-helper")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "debug-helper" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a73xl73psmzyihd62jy30g1acfmgjmyi2k8khmh170mrq6x3yvn"))))
    (build-system cargo-build-system)
    (home-page "https://magiclen.org/debug-helper")
    (synopsis "Declarative macros to implement the Debug trait manually")
    (description "This crate provides declarative macros to help you implement
the Debug trait manually.")
    (license license:expat)))

(define-public rust-debugger-test-0.1
  (package
    (name "rust-debugger-test")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "debugger-test" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "182j5sk71yhbn7f5qkx509bdcjz83n1nshpfgfa8dfrgb5gvanyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
        #:cargo-development-inputs
        (("rust-debugger-test-parser" ,rust-debugger-test-parser-0.1)
         ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/microsoft/rust_debugger_test")
    (synopsis "Proc macro for writing tests with a debugger")
    (description
     "This package provides a proc macro for writing tests that launch a
debugger and run commands while verifying the output.")
    (license (list license:expat license:asl2.0))))

(define-public rust-debugger-test-parser-0.1
  (package
    (name "rust-debugger-test-parser")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "debugger-test-parser" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0xcyxw0si7j4h701aksdd08j8jmrzc58833g66wm4xvp592kdrgb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1))))
    (home-page
     "https://github.com/microsoft/rust_debugger_test/debugger_test_parser")
    (synopsis "Library for parsing debugger output")
    (description
     "This package provides a library for parsing the output of a debugger and
verifying the contents.")
    (license (list license:expat license:asl2.0))))

(define-public rust-decimal-2
  (package
    (name "rust-decimal")
    (version "2.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "decimal" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vb3i8vg1dxrw3kzbfiag3gg7rdjd73z80mwbwkq60vnphiqfig6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-ord-subset" ,rust-ord-subset-3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-cc" ,rust-cc-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/alkis/decimal")
    (synopsis "Decimal floating point arithmetic for Rust")
    (description
     "Decimal floating point arithmetic for Rust.")
    (license license:asl2.0)))

(define-public rust-defer-drop-1
  (package
    (name "rust-defer-drop")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defer-drop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d3pmmn5k2ir3yv8z8fnv4jprs5aijkz5pbdyl8x8kp18m90bbhq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/Lucretiel/defer-drop")
    (synopsis "Defer dropping large types to a background thread")
    (description
     "This package provides a defer dropping large types to a background
thread.")
    (license license:mpl2.0)))

(define-public rust-deflate-1
  (package
    (name "rust-deflate")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "deflate" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0bs319wa9wl7pn9j6jrrxg1gaqbak581rkx210cbix0qyljpwvy8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-gzip-header" ,rust-gzip-header-1))
       #:cargo-development-inputs
       (("rust-miniz-oxide" ,rust-miniz-oxide-0.5))))
    (home-page "https://github.com/image-rs/deflate-rs")
    (synopsis "DEFLATE, zlib and gzip encoder written in rust")
    (description "This package provides a DEFLATE, zlib and gzip encoder
written in rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-deflate-0.9
  (package
    (inherit rust-deflate-1)
    (name "rust-deflate")
    (version "0.9.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "deflate" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0w0ww0hrq4bjnihxgbnrri4lj5c8yzg31fyzx36fd9pvvw2vz5az"))))
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-gzip-header" ,rust-gzip-header-0.3))
       #:cargo-development-inputs
       (("rust-miniz-oxide" ,rust-miniz-oxide-0.3))))))

(define-public rust-deflate-0.8
  (package
    (inherit rust-deflate-0.9)
    (name "rust-deflate")
    (version "0.8.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "deflate" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x6iqlayg129w63999kz97m279m0jj4x4sm6gkqlvmp73y70yxvk"))))
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
         (("rust-adler32" ,rust-adler32-1)
          ("rust-byteorder" ,rust-byteorder-1)
          ("rust-gzip-header" ,rust-gzip-header-0.3))
       #:cargo-development-inputs
         (("rust-miniz-oxide" ,rust-miniz-oxide-0.3))))))

(define-public rust-deflate-0.7
  (package
    (inherit rust-deflate-0.8)
    (name "rust-deflate")
    (version "0.7.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deflate" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1d7d9fpmgjnznrksmd3vlv3dyw01wsrm11ifil6ag22871xnlyvh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-gzip-header" ,rust-gzip-header-0.3)
        ("rust-flate2" ,rust-flate2-1))))))

(define-public rust-defmac-0.2
  (package
    (name "rust-defmac")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "defmac" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "14cqfvc0f1pkd6gdhjxa2wv3iibqprc0n203ims8lvg96752ynfm"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluss/defmac")
    (synopsis "Macro to define lambda-like macros inline")
    (description "A macro to define lambda-like macros inline.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-defmac-0.1
  (package
    (inherit rust-defmac-0.2)
    (name "rust-defmac")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "defmac" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "17giv0n0n1r64z0dahfvkjy3ys517jxyhs8sd9lmgvcljpjyryxa"))))))

(define-public rust-defmt-0.3
  (package
    (name "rust-defmt")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defmt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "181l5wv6sihrjwjvk97wznmg2iaz3w1ljsx2dfzjssmhsbs5vyv2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-defmt-macros" ,rust-defmt-macros-0.3))))
    (home-page "https://knurling.ferrous-systems.com/")
    (synopsis "Logging framework for resource-constrained devices")
    (description
     "This package provides an efficient logging framework that targets
resource-constrained devices, like micro-controllers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-defmt-macros-0.3
  (package
    (name "rust-defmt-macros")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defmt-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rx25gp12c6j3krwjjsknigd803ycz1rpxh5jhr6ny51cfvrd0q9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-defmt-parser" ,rust-defmt-parser-0.3)
        ("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/knurling-rs/defmt")
    (synopsis "Macros for rust-defmt")
    (description "This package provides macros for rust-defmt crate")
    (license (list license:expat license:asl2.0))))

(define-public rust-defmt-parser-0.3
  (package
    (name "rust-defmt-parser")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defmt-parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1is90zrcifdky4rpra450779c3jf3bc2xwcqbj9fy6m5w48f074d"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/knurling-rs/defmt")
    (synopsis "Parsing library for defmt format strings")
    (description "This package is a parsing library for defmt format
strings.")
    (license (list license:expat license:asl2.0))))

(define-public rust-demo-hack-0.0
  (package
    (name "rust-demo-hack")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0m0114p1g0zzrdph5bg03i8m8p70vrwn3whs191jrbjcrmh5lmnp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-demo-hack-impl" ,rust-demo-hack-impl-0.0)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/dtolnay/proc-macro-hack")
    (synopsis "Demo of proc-macro-hack")
    (description "Demo of proc-macro-hack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-demo-hack-impl-0.0
  (package
    (name "rust-demo-hack-impl")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f1fdl60xjas9wlmcl9v6f56vgm3mzwr019kcifav5464rx3w3ld"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/dtolnay/proc-macro-hack")
    (synopsis "Demo of proc-macro-hack")
    (description "Demo of proc-macro-hack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-der-0.4
  (package
    (name "rust-der")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "der" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x4k0jln8va1657cghl40l6p7hyvr1ixz71v9cd6imwmgp51rdvr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build?
       #t                               ; FIXME
       #:cargo-inputs
       (("rust-const-oid" ,rust-const-oid-0.6)
        ("rust-crypto-bigint" ,rust-crypto-bigint-0.2)
        ("rust-der-derive" ,rust-der-derive-0.4))))
    (home-page "https://github.com/RustCrypto/formats/tree/master/der")
    (synopsis
     "Implementation of the Distinguished Encoding Rules (DER)")
    (description
     "This package provides a pure Rust embedded-friendly implementation of
the Distinguished Encoding Rules (DER) for Abstract Syntax Notation One
(ASN.1) as described in ITU X.690 with full support for heapless no_std
targets")
    (license (list license:asl2.0 license:expat))))

(define-public rust-der-derive-0.4
  (package
    (name "rust-der-derive")
    (version "0.4.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "der_derive" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0snv85yfy9iln05qsgbhwr1159gd0jfrgzj5dkrnricdc0y3pvca"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build?
        #t                              ; FIXME
        #:cargo-inputs
        (("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-syn" ,rust-syn-1)
         ("rust-synstructure" ,rust-synstructure-0.12))))
    (home-page "https://github.com/RustCrypto/formats/tree/master/der/derive")
    (synopsis
      "Custom derive support for the `der` crate's `Choice` and `Sequence` traits")
    (description
      "This package provides a custom derive support for the `der` crate's
`Choice` and `Sequence` traits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-der-oid-macro-0.5
  (package
    (name "rust-der-oid-macro")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "der-oid-macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dply8g2p72hfhyymkrkr7fjqy844drj19xbrfkqrp55nq4z4fn7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rusticata/der-parser")
    (synopsis "Macro to encode DER oids at compile time")
    (description
     "This crate provides a macro to encode DER oids at compile time.")
    (license (list license:expat license:asl2.0))))

(define-public rust-der-parser-6
  (package
    (name "rust-der-parser")
    (version "6.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "der-parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gn465dncghmj52k8dlkl71wkmlz5zc6jfjgj9ra2knf22ryy1wq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitvec" ,rust-bitvec-0.22)
        ("rust-cookie-factory" ,rust-cookie-factory-0.3)
        ("rust-der-oid-macro" ,rust-der-oid-macro-0.5)
        ("rust-nom" ,rust-nom-7)
        ("rust-num-bigint" ,rust-num-bigint-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rusticata-macros" ,rust-rusticata-macros-4))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.3)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.7)
        ("rust-test-case" ,rust-test-case-1))))
    (home-page "https://github.com/rusticata/der-parser")
    (synopsis "BER/DER parser written in pure Rust")
    (description "This crate provides a parser for Basic Encoding Rules (BER
[X.690]) and Distinguished Encoding Rules(DER [X.690]), implemented with the
@code{nom} parser combinator framework.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derivative-2
  (package
    (name "rust-derivative")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derivative" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03rqx8j9q5nlrpr7w8cwwrvw916pr0ahzs3y8yln18cx6mh2nn6b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/mcarton/rust-derivative")
    (synopsis "Set of alternative @code{derive} attributes for Rust")
    (description
     "This package provides a set of alternative @code{derive} attributes for
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-arbitrary-1
  (package
    (name "rust-derive-arbitrary")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nig0iydva7a9h9i9qyi6an9w5qjafmn3qlzvdqqiw0x2kp824jz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rust-fuzz/arbitrary")
    (synopsis "Derives arbitrary traits")
    (description "This crate implements support for automatically deriving the
@code{Arbitrary} trait.  Don't depend on this crate directly, though.
Instead, enable the @code{derive} feature of the @code{arbitrary} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-arbitrary-0.4
  (package/inherit rust-derive-arbitrary-1
    (name "rust-derive-arbitrary")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rp0z4k0j5ip0bx6dssg97l4q6bakhf6lm5h1lpr3p3kwjsi585i"))))))

(define-public rust-derive-builder-0.11
  (package
    (name "rust-derive-builder")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18q4jx8zvg2pkx2d1nmlklx8m48bwrghyg8rdg1irdwkw5xxyynh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.11))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Builder pattern for arbitrary structs")
    (description "Rust macro to automatically implement the builder pattern
for arbitrary structs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-0.10
  (package
    (inherit rust-derive-builder-0.11)
    (name "rust-derive-builder")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c2v6vi0lih3fwwgwx92pspcmkrjz8wxfqwhmr01060ipvg04cni"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.10))))))

(define-public rust-derive-builder-0.9
  (package
    (inherit rust-derive-builder-0.10)
    (name "rust-derive-builder")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "derive-builder" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1h4f8vnggmpyw27fznl3cpyjrzz1nw5xrxx6ca3zcb3z54hqcrd2"))))
    (arguments
      `(#:cargo-inputs
        (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
         ("rust-darling" ,rust-darling-0.10)
         ("rust-derive-builder-core" ,rust-derive-builder-core-0.9)
         ("rust-env-logger" ,rust-env-logger-0.5)
         ("rust-log" ,rust-log-0.4)
         ("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-skeptic" ,rust-skeptic-0.13)
         ("rust-syn" ,rust-syn-1))
        #:cargo-development-inputs
        (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))))

(define-public rust-derive-builder-0.7
  (package
    (inherit rust-derive-builder-0.9)
    (name "rust-derive-builder")
    (version "0.7.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "derive_builder" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1m34zpj6fw764g7s368r2wgazp154m24d4rshbgn18fdlfk3zi9s"))))
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
         ("rust-darling" ,rust-darling-0.9)
         ("rust-derive-builder-core" ,rust-derive-builder-core-0.5)
         ("rust-env-logger" ,rust-env-logger-0.5)
         ("rust-log" ,rust-log-0.4)
         ("rust-proc-macro2" ,rust-proc-macro2-0.4)
         ("rust-quote" ,rust-quote-0.6)
         ("rust-skeptic" ,rust-skeptic-0.13)
         ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-derive-builder-core-0.11
  (package
    (name "rust-derive-builder-core")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i5gmf5lglbg7agj1khc6k9swf1clfs5fg6w0icw1w91m77x948z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling" ,rust-darling-0.14)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Internal helper library for @code{rust-derive-builder}")
    (description
     "Internal helper library for @code{rust-derive-builder}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-core-0.10
  (package
    (inherit rust-derive-builder-core-0.11)
    (name "rust-derive-builder-core")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r9ngcrfcvqv5l5p86bzg9v863bjf5nlmippin1fv1v1iy2idrk6"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling" ,rust-darling-0.12)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-core-0.9
  (package
    (inherit rust-derive-builder-core-0.10)
    (name "rust-derive-builder-core")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-builder-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vwb8nwls4lhd2yiyj87kmwws4mmfqfrjcr0pk09b11c6wzfm497"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.10)
        ("rust-log" ,rust-log-0.4)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))))

(define-public rust-derive-builder-core-0.5
  (package
    (inherit rust-derive-builder-core-0.9)
    (name "rust-derive-builder-core")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "derive_builder_core" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0drbjk6n8ywls8cmhp4r8xkyjsja0wk3854cn5mj8g1km4ys5202"))))
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-darling" ,rust-darling-0.9)
         ("rust-log" ,rust-log-0.4)
         ("rust-proc-macro2" ,rust-proc-macro2-0.4)
         ("rust-quote" ,rust-quote-0.6)
         ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-derive-builder-macro-0.11
  (package
    (name "rust-derive-builder-macro")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s6xfgsybd9wbk39hbgqjcn7d1l36a33q6v7d0x5y17d5fvi80wg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-derive-builder-core" ,rust-derive-builder-core-0.11)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis
     "Rust macro to automatically implement the builder pattern for arbitrary structs")
    (description
     "This crate provides a Rust macro to automatically implement the builder
pattern for arbitrary structs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-macro-0.10
  (package
    (inherit rust-derive-builder-macro-0.11)
    (name "rust-derive-builder-macro")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wwdm4cgd4vlvabj5xsjjr4vvkqhnd3fi9wp3v5mlb09jp74maaq"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-builder-core" ,rust-derive-builder-core-0.10)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-error-chain-0.10
  (package
    (name "rust-derive-error-chain")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-error-chain" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jnybrpiq5jzx69xq74cwxply36js02z14y9sym8sf2iwsnsk71w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.14))))
    (home-page "https://github.com/Arnavion/derive-error-chain")
    (synopsis "Macros 1.1 implementation of error-chain")
    (description "This package provides a Macros 1.1 implementation of
error-chain.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-more-0.99
  (package
    (name "rust-derive-more")
    (version "0.99.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-more" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0883jr0gdf9mi8rn7qbz1p0z7hqzfd275pil2gwm66bw1b9i1f2g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Some test files missing.
       #:cargo-inputs
       (("rust-convert-case" ,rust-convert-case-0.4)
        ("rust-peg" ,rust-peg-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-version" ,rust-rustc-version-0.4)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/JelteF/derive_more")
    (synopsis "Adds derive macros for more traits")
    (description
     "Rust has lots of builtin traits that are implemented for its basic
types, such as @code{Add}, @code{Not}, @code{From} or @code{Display}.
However, when wrapping these types inside your own structs or enums you lose
the implementations of these traits and are required to recreate them.  This is
especially annoying when your own structures are very simple, such as when
using the commonly advised newtype pattern (e.g. @code{MyInt(i32)}).

This library tries to remove these annoyances and the corresponding
boilerplate code.  It does this by allowing you to derive lots of commonly used
traits for both structs and enums.")
    (license license:expat)))

(define-public rust-derive-more-0.15
  (package
    (inherit rust-derive-more-0.99)
    (name "rust-derive-more")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-more" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zks5bn7hmqfz927spmridk9bvy7ly4f38vls331x4hc4hq1653s"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-derive-more-0.14
  (package
    (inherit rust-derive-more-0.99)
    (name "rust-derive-more-1")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-more" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fgq5ziyg0gwr5j7pghfrxgzqzmmadknivpigrsniliy0334m53d"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-derive-new-0.5
  (package
    (name "rust-derive-new")
    (version "0.5.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-new" version))
      (file-name (string-append name "-" version ".tar.gz"))
      (sha256
       (base32 "1ncibp4jhpkym7namg3viqyw8hljd32n6abg64af8qjwrn91iwvi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/nrc/derive-new")
    (synopsis "Simple constructor functions for structs and enums")
    (description "`#[derive(new)]` implements simple constructor functions for
structs and enums.")
  (license license:expat)))

(define-public rust-des-0.7
  (package
    (name "rust-des")
    (version "0.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "des" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0pbsfkkwfqnd4nsv3ik4z09h248f57y7bj2j1l134i2mzd4xshdc"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build?
        #t
        #:cargo-inputs
        (("rust-byteorder" ,rust-byteorder-1)
         ("rust-cipher" ,rust-cipher-0.3)
         ("rust-opaque-debug" ,rust-opaque-debug-0.3))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "DES and Triple DES block ciphers implementation")
    (description "This package provides DES and Triple DES (3DES, TDES) block
ciphers implementations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-des-0.6
  (package
    (inherit rust-des-0.7)
    (name "rust-des")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "des" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bigk1x1kxvnfjn1alr8cc383z1flmj8q7g2pjl2zal8i1s7qkmj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-cipher" ,rust-cipher-0.2)
        ("rust-opaque-debug" ,rust-opaque-debug-0.3))
       #:cargo-development-inputs
       (("rust-cipher" ,rust-cipher-0.2))))))

(define-public rust-deunicode-0.4
  (package
    (name "rust-deunicode")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deunicode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "146nc3wlwz2j9awwf7zf76qvjcahnls0mlv9jm6clcvr9dlph245"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://lib.rs/crates/deunicode")
    (synopsis "Convert Unicode strings to pure ASCII")
    (description
     "This package converts Unicode strings to pure ASCII by
intelligently transliterating them.  It supports Emoji and Chinese.")
    (license license:bsd-3)))

(define-public rust-devise-0.2
  (package
    (name "rust-devise")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lryvr39ia3rfswfnwn2zynsv2r8kj6gqqf0akcs0prws2i4pq3l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-devise-codegen" ,rust-devise-codegen-0.2)
        ("rust-devise-core" ,rust-devise-core-0.2))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-codegen-0.2
  (package
    (name "rust-devise-codegen")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1msmq0h19l03n9qmkxxi1a5h8904i8m623kdvjzak4ya51wynv06"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-devise-core" ,rust-devise-core-0.2)
        ("rust-quote" ,rust-quote-0.6))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-core-0.2
  (package
    (name "rust-devise-core")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11v4z5kljmpiyif3mmfnm3rl1lsqygjlfy2wll7frqxm4adwahfg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dhcp4r-0.2
  (package
    (name "rust-dhcp4r")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dhcp4r" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0paq13i9iz5545f5aw8ijxflw20fvb3k8s4m3inr5q19q5rirpbc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-enum-primitive-derive" ,rust-enum-primitive-derive-0.2)
        ("rust-nom" ,rust-nom-6)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-time" ,rust-time-0.2))))
    (home-page "https://github.com/krolaw/dhcp4r")
    (synopsis "IPv4 DHCP library with working server example")
    (description
     "This package provides a library for IPv4 DHCP including a working server
example.")
    (license license:bsd-3)))

(define-public rust-diesel-1
  (package
    (name "rust-diesel")
    (version "1.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diesel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hpmwrc0zx3zvpgwp9zrm6wj8d8i8q8990grlrnfzlivbi6zqyq4"))))
    (build-system cargo-build-system)
    (native-inputs
     (list sqlite))
    (arguments
     `(#:cargo-inputs
       (("rust-bigdecimal" ,rust-bigdecimal-0.1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-diesel-derives" ,rust-diesel-derives-1)
        ("rust-ipnetwork" ,rust-ipnetwork-0.17)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libsqlite3-sys" ,rust-libsqlite3-sys-0.20)
        ("rust-mysqlclient-sys" ,rust-mysqlclient-sys-0.2)
        ("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pq-sys" ,rust-pq-sys-0.4)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-r2d2" ,rust-r2d2)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-1)
        ("rust-uuid" ,rust-uuid-0.5)
        ("rust-uuid" ,rust-uuid-0.8))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dotenv" ,rust-dotenv-0.10)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-tempdir" ,rust-tempdir-0.3))
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "cargo" "test" "--features" "sqlite" "--"
                     "--skip=expression::count::count"))))))
    (home-page "https://diesel.rs")
    (synopsis "Safe, extensible ORM and Query Builder")
    (description "This package provides a safe, extensible ORM and Query
Builder for PostgreSQL, SQLite, and MySQL.")
    (license (list license:expat license:asl2.0))))

(define-public rust-diesel-derives-1
  (package
    (name "rust-diesel-derives")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diesel_derives" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lsq133fwk0zj8xvxhdxqgg0xs31zf3abnwdyshaf0ldca7hkxa5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-diesel" ,rust-diesel-1)
        ("rust-dotenv" ,rust-dotenv-0.10))))
    (home-page "https://diesel.rs")
    (synopsis "Crate internal to Diesel")
    (description "You should not use this crate directly, it is internal to
Diesel.")
    (license (list license:expat license:asl2.0))))

(define-public rust-diesel-migrations-1
  (package
    (name "rust-diesel-migrations")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diesel_migrations" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k4g03ciqwya2xc1xvy5s9cs6q55k45wxa1gszswfg9m2f2dwg5z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;doctest_setup.rs: No such file or directory
       #:cargo-inputs
       (("rust-migrations-internals"
         ,rust-migrations-internals-1)
        ("rust-migrations-macros"
         ,rust-migrations-macros-1))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-diesel" ,rust-diesel-1)
        ("rust-dotenv" ,rust-dotenv-0.10))))
    (home-page "https://diesel.rs")
    (synopsis "Migration management for diesel")
    (description "This package provides migration management for Diesel.")
    (license (list license:expat license:asl2.0))))

(define-public rust-diff-0.1
  (package
    (name "rust-diff")
    (version "0.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diff" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16b40bhsa2qgvgvxs983l625pkxyp6m0mzmpwg2605cvj53yl98f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-speculate" ,rust-speculate-0.1))))
    (home-page "https://github.com/utkarshkukreti/diff.rs")
    (synopsis
     "LCS based slice and string diffing implementation")
    (description
     "An LCS based slice and string diffing implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-difference-2
  (package
    (name "rust-difference")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difference" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1621wx4k8h452p6xzmzzvm7mz87kxh4yqz0kzxfjj9xmjxlbyk2j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-getopts" ,rust-getopts-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-term" ,rust-term-0.5))))
    (home-page "https://github.com/johannhof/difference.rs")
    (synopsis "Rust text diffing and assertion library")
    (description
     "This package provides a Rust text diffing and assertion library.")
    (license license:expat)))

(define-public rust-difference-1
  (package
    (inherit rust-difference-2)
    (name "rust-difference")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difference" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a5v0b73z7vywbclll32wjsfkdgh6wn9prnq91z0d3lag4clsc5k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getopts" ,rust-getopts-0.2))
       #:cargo-development-inputs
       (("rust-term" ,rust-term-0.2))))))

(define-public rust-difflib-0.4
  (package
    (name "rust-difflib")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difflib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s7byq4d7jgf2hcp2lcqxi2piqwl8xqlharfbi8kf90n8csy7131"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/DimaKudosh/difflib")
    (synopsis "Compare word sequences in Rust")
    (description
     "This crate provides all necessary tools for comparing word sequences.")
    (license license:expat)))

(define-public rust-diffr-lib-0.1
  (package
    (name "rust-diffr-lib")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "diffr-lib" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "0id3hpblvvcw4ydcd1cc7wgcwqjbh3grlihrmd8zp7k0d2h47i3g"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mookid/diffr")
    (synopsis "Implementation of Myers diff algorithm")
    (description "An implementation of Myers diff algorithm.")
    (license license:expat)))

(define-public rust-diffs-0.3
  (package
    (name "rust-diffs")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diffs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "036sqycmir4bbl4016jprsyjq4hicc31r68dyqadmc8ac9pk55d1"))))
    (build-system cargo-build-system)
    (home-page "https://nest.pijul.com/pijul_org/pijul")
    (synopsis "Diff algorithms, also called longest common subsequence")
    (description
     "This package provides a number of diff algorithms, also called longest
common subsequence.  The diff algorithms include Myer's diff and Patience
diff.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-digest-0.10
  (package
    (name "rust-digest")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16wpqnwlzx0lbnwccwikns7dq8fblcc6kma2l7xz8anlh5hdd5xn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.3)
        ("rust-block-buffer" ,rust-block-buffer-0.10)
        ("rust-crypto-common" ,rust-crypto-common-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-subtle" ,rust-subtle-2))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for cryptographic hash functions")
    (description
     "Traits for cryptographic hash functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-digest-0.9
  (package
    (inherit rust-digest-0.10)
    (name "rust-digest")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rmhvk33rgvd6ll71z8sng91a52rw14p0drjn1da0mqa138n1pfk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14))))))

(define-public rust-digest-0.8
  (package
    (inherit rust-digest-0.9)
    (name "rust-digest")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1madjl27f3kj5ql7kwgvb9c8b7yb7bv7yfgx7rqzj4i3fp4cil7k"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.12))))))

(define-public rust-digest-0.7
  (package
    (inherit rust-digest-0.9)
    (name "rust-digest")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "142vdpvkqlqk9s1dcgpqb2wz76n5a39gjnk68p0zkflc58j75c03"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.9))))))

(define-public rust-digest-0.6
  (package
    (name "rust-digest")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02mgf8z4hi96w9nl2zb5w3k6lqbhjgv5z8hhyv2b7x7kavqrpcp5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.8))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for cryptographic hash functions")
    (description "This package provides traits for cryptographic hash
functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-directories-4
  (package
    (name "rust-directories")
    (version "4.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "045jbj5y2f1fmjs9rfcw95y0vjydb2rqqhz1sdnqhdmxv96ms77m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))))
    (home-page "https://github.com/dirs-dev/directories-rs")
    (synopsis "Library for standard locations of data directories")
    (description
     "This package provides a tiny mid-level library that provides
platform-specific standard locations of directories for config,
cache and other data on Linux, Windows and macOS by leveraging the
mechanisms defined by the XDG base/user directory specifications
on Linux, the Known Folder API on Windows, and the Standard
Directory guidelines on macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-directories-3
  (package
    (inherit rust-directories-4)
    (name "rust-directories")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03ysv4m6mhsc3w1xnvncd5sxf7v2dz917awq6ksx0n0bsqwxdzpq"))))
    (arguments
     `(#:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1))))))

(define-public rust-directories-next-2
  (package
    (name "rust-directories-next")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g1vq8d8mv0vp0l317gh9y46ipqg2fxjnbc7lnjhwqbsv4qf37ik"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys-next" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs/tree/master/directories")
    (synopsis "Mid-level library for standard locations of data directories")
    (description
     "This package provides a tiny mid-level library that provides
platform-specific standard locations of directories for config, cache and
other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-4
  (package
    (name "rust-dirs")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n8020zl4f0frfnzvgb9agvk4a14i1kjz4daqnxkgslndwmaffna"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))))
    (home-page "https://github.com/soc/dirs-rs")
    (synopsis "Abstractions for standard locations for various platforms")
    (description
     "This package is a tiny low-level library that provides platform-specific
standard locations of directories for config, cache and other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-3
  (package
    (inherit rust-dirs-4)
    (name "rust-dirs")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "028kqy0vrbfgrk1yc1flq2fqh8snyg17qlygawm0r79w211s1fih"))))))

(define-public rust-dirs-2
  (package
    (inherit rust-dirs-3)
    (name "rust-dirs")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qymhyq7w7wlf1dirq6gsnabdyzg6yi2yyxkx6c4ldlkbjdaibhk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dirs-sys" ,rust-dirs-sys-0.3))))
    (inputs
     (list rust-cfg-if-0.1 rust-dirs-sys-0.3))))

(define-public rust-dirs-1
  (package
    (inherit rust-dirs-2)
    (name "rust-dirs")
    (version "1.0.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dirs" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "009rrhzj9pxyncmm2vhlj70npg0cgggv2hjbbkiwdl9vccq8kmrz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.3)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-dirs-next-2
  (package
    (name "rust-dirs-next")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q9kr151h9681wwp6is18750ssghz6j9j7qm7qi1ngcwy7mzi35r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys-next" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs")
    (synopsis "Abstractions for standard locations for various platforms")
    (description
     "This package provides a tiny low-level library that provides
platform-specific standard locations of directories for config, cache and
other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-next-1
  (package
    (inherit rust-dirs-next-2)
    (name "rust-dirs-next")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-next" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dl2dqzsrcb7qigfiwpdpakhdkpz0629pvylbj2ylyrkh1dfcdng"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-sys-0.3
  (package
    (name "rust-dirs-sys")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "102pbpcrfhvhfyfnyvmvvwpl6mfvynh170f6ima6fyinxls6bn03"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.4)
        ("rust-winapi" ,rust-winapi-0.3))))
    (inputs
     (list rust-cfg-if-0.1 rust-libc-0.2 rust-redox-users-0.3
           rust-winapi-0.3))
    (home-page "https://github.com/soc/dirs-sys-rs")
    (synopsis
     "System-level helper functions for the dirs and directories crates")
    (description
     "This package provides system-level helper functions for the @code{dirs}
and @code{directories} crates.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dirs-sys-next-0.1
  (package
    (inherit rust-dirs-sys-0.3)
    (name "rust-dirs-sys-next")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-sys-next" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0zgy7is3h2dyf1l4sa7k065w2kvx0l12l40my4rswm2mc1gkdplr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.3)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/xdg-rs/dirs/tree/master/dirs-sys")))

(define-public rust-discard-1
  (package
    (name "rust-discard")
    (version "1.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "discard" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1h67ni5bxvg95s91wgicily4ix7lcw7cq0a5gy9njrybaibhyb91"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/Pauan/rust-discard")
    (synopsis "Allow for intentionally leaking memory")
    (description "There are situations where you need to intentionally leak some
memory but not other memory.  This package provides a discard trait which allows
for intentionally leaking memory")
    (license license:expat)))

(define-public rust-dispatch-0.2
  (package
    (name "rust-dispatch")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dispatch" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fwjr9b7582ic5689zxj8lf7zl94iklhlns3yivrnv8c9fxr635x"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/SSheldon/rust-dispatch")
    (synopsis "Rust wrapper for Apple's Grand Central Dispatch")
    (description "This package provides a Rust wrapper for Apple's Grand
Central Dispatch.")
    (license license:expat)))

(define-public rust-dispatch-0.1
  (package
    (inherit rust-dispatch-0.2)
    (name "rust-dispatch")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dispatch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "019nzy993hxaiazcdnayx3csv2iki34i535asw11ki96hakkrs84"))))
    (arguments '(#:tests? #f))))  ; Tests only run on Mac.

(define-public rust-dissimilar-1
  (package
    (name "rust-dissimilar")
    (version "1.0.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dissimilar" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1fwa892hcf7y36b8w41p14b3ld3df389y9jpglkbz55vp7s2jjzw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/dissimilar")
    (synopsis "Diff library with semantic cleanup")
    (description
     "This package provides a diff library with semantic cleanup, based on
Google's diff-match-patch.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dlib-0.5
  (package
    (name "rust-dlib")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1547hy7nrhkrb2i09va244c0h8mr845ccbs2d2mc414c68bpa6xc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ;FIXME: Several macros are not found.
       #:cargo-inputs
       (("rust-libloading" ,rust-libloading-0.7))))
    (inputs
     (list rust-libloading-0.7))
    (home-page "https://github.com/vberger/dlib")
    (synopsis "Helper macros for manually loading optional system libraries")
    (description
     "This package provides helper macros for handling manually loading optional
system libraries.")
    (license license:expat)))

(define-public rust-dlib-0.4
  (package
    (inherit rust-dlib-0.5)
    (name "rust-dlib")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlib" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xlsf3lrz9hd7q3ff6lp5mw4kn3nbryn746kd07i93r6wg8ia7xi"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libloading" ,rust-libloading-0.6))))
    (inputs
     (list rust-libloading-0.6))))

(define-public rust-dlv-list-0.2
  (package
    (name "rust-dlv-list")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlv-list" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06r1nskj3x56p5wqz2bgl6q3rpyymrb0k0zpbvk8c6qcd4mkzpv8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/sgodwincs/dlv-list-rs")
    (synopsis "Semi-doubly linked list implemented using a vector")
    (description
     "This crate provides semi-doubly linked lists implemented using
a vector.")
    (license license:expat)))

(define-public rust-dns-parser-0.8
  (package
    (name "rust-dns-parser")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dns-parser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1spv0psvxc31qg9xnqf0gmjclyiim7vp23r2b1gzf1ix8zlkply4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-quick-error" ,rust-quick-error-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-matches" ,rust-matches-0.1))))
    (home-page "https://github.com/tailhook/dns-parser")
    (synopsis "DNS protocol parser library")
    (description "This package provide a DNS protocol parser library.  It does
not support network, only raw protocol parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-doc-comment-0.3
  (package
    (name "rust-doc-comment")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "doc-comment" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "15rsqxgarfpb1yim9sbp9yfgj7p2dq6v51c6bq1a62paii9ylgcj"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/GuillaumeGomez/doc-comment")
    (synopsis "Macro to generate doc comments")
    (description "This package provides a way to generate doc comments
from macros.")
    (license license:expat)))

(define-public rust-docmatic-0.1
  (package
    (name "rust-docmatic")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docmatic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hx85n266lxswqxrbbinqlhi1qcnjgd4cc7v42abg72kmz7fnn4d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-which" ,rust-which-2))))
    (home-page "https://github.com/assert-rs/docmatic")
    (synopsis "Test Rust examples in your documentation")
    (description "Test Rust examples in your documentation.")
    (license license:expat)))

(define-public rust-docopt-1
  (package
    (name "rust-docopt")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0s9rcpmnnivs502q69lc1h1wrwapkq09ikgbfbgqf31idmc5llkz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-strsim" ,rust-strsim-0.9))))
    (home-page "https://github.com/docopt/docopt.rs")
    (synopsis "Command line argument parsing")
    (description "Command line argument parsing.")
    (license (list license:expat license:unlicense))))

(define-public rust-docopt-0.8
  (package
    (inherit rust-docopt-1)
    (name "rust-docopt")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jha611mffc2qnxvdl3pmglz07akl99lk1vihhb3nl1cd69x7b6q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-strsim" ,rust-strsim-0.6))))))

(define-public rust-docopt-0.7
  (package
    (inherit rust-docopt-1)
    (name "rust-docopt")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n6gbhsks2w9y0b4bwqyawh4ghbkka09w6pjcrq9i1sd51pflcmb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-strsim" ,rust-strsim-0.6))))))

(define-public rust-docopt-0.6
  (package
    (inherit rust-docopt-0.7)
    (name "rust-docopt")
    (version "0.6.86")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1nf4f4zf5yk0d0l4kl7hkii4na22fhn0l2hgfb46yzv08l2g6zja"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.1)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-strsim" ,rust-strsim-0.5))))))

(define-public rust-document-features-0.2
  (package
    (name "rust-document-features")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "document-features" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "121wr2bd8a4s5i5yrxjz8c5amw2l69xmqqma86x6y4xmcgyhj75h"))))
    (build-system cargo-build-system)
    (home-page "https://slint-ui.com")
    (synopsis "Extract documentation for feature flags from Cargo.toml")
    (description "Extract documentation for the feature flags from comments in
@code{Cargo.toml}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-downcast-rs-1
  (package
    (name "rust-downcast-rs")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "downcast-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l36kgxqd5djhqwf5abxjmgasdw8n0qsjvw3jdvhi91nj393ba4y"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/marcianx/downcast-rs")
    (synopsis "Trait object downcasting support using only safe Rust")
    (description
     "Trait object downcasting support using only safe Rust.  It supports type
parameters, associated types, and type constraints.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dogged-0.2
  (package
    (name "rust-dogged")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dogged" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yk5l6qqidl5y935x15gi9kkd6niim1wb64r1l7kdzl9jw8dyf16"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/nikomatsakis/dogged")
    (synopsis "Persistent vector, similar to Clojure")
    (description "This package experimental persistent collections in Rust.
Based on a digit-indexed trie, as in Clojure.  Supports @code{push()},
@code{get()}, and @code{get_mut()} as its primitive operations for now.  All
O(1)-in-practice, if not in theory, but obviously not as fast as a
non-persistent vector.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dot-0.1
  (package
    (name "rust-dot")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "01jr7px6anh3yasz8cbbr9ij989gnwb3qdk4852mzzqw996nqjx7"))))
    (build-system cargo-build-system)
    (home-page
     "https://github.com/GrahamDennis/dot-rust")
    (synopsis
     "Library for generating Graphviz DOT language files for graphs")
    (description
     "This package provides a library for generating Graphviz DOT language files
for graphs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dotenv-0.15
  (package
    (name "rust-dotenv")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dotenv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13ysjx7n2bqxxqydvnnbdwgik7i8n6h5c1qhr9g11x6cxnnhpjbp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-2))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/dotenv-rs/dotenv")
    (synopsis "@code{dotenv} implementation for Rust")
    (description "This package provides a @code{dotenv} implementation for
Rust.")
    (license license:expat)))

(define-public rust-dotenv-0.13
  (package
    (inherit rust-dotenv-0.15)
    (name "rust-dotenv")
    (version "0.13.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dotenv" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "11jdifvvwbn60gf5iq2awyq9fik1d9xk7rhch332nwwnkhks3l60"))))
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-clap" ,rust-clap-2)
         ("rust-failure" ,rust-failure-0.1)
         ("rust-lazy-static" ,rust-lazy-static-1)
         ("rust-regex" ,rust-regex-1))
        #:cargo-development-inputs
        (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-dotenv-0.10
  (package
    (inherit rust-dotenv-0.15)
    (name "rust-dotenv")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dotenv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ww0wfnilz4cy789fni06gckm45xsb9fplrih26l4qyi4jxy5w6n"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-error-chain" ,rust-derive-error-chain-0.10)
        ("rust-error-chain" ,rust-error-chain-0.10)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-syn" ,rust-syn-0.11))))))

(define-public rust-draw-state-0.8
  (package
    (name "rust-draw-state")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "draw_state" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lfng4fz9x7bwsmzv9r20ply10w0iid6vfcrhx292s6hw8vrbkrk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://github.com/gfx-rs/draw_state")
    (synopsis "Graphics state blocks for gfx-rs")
    (description "Graphics state blocks for gfx-rs.")
    (license license:asl2.0)))

(define-public rust-drop-bomb-0.1
  (package
    (name "rust-drop-bomb")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "drop-bomb" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qc59a53ngwxpnbvl8xidp2cmwrl671dhbzw7zijmjjaq0hqxnlv"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page
     "https://github.com/matklad/drop_bomb")
    (synopsis
     "Runtime guard for implementing linear types")
    (description
     "This package provides a runtime guard for implementing linear types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dtoa-0.4
  (package
    (name "rust-dtoa")
    (version "0.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0phbm7i0dpn44gzi07683zxaicjap5064w62pidci4fhhciv8mza"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/dtolnay/dtoa")
    (synopsis "Fast functions for printing floating-point primitives")
    (description "This crate provides fast functions for printing
floating-point primitives to an @code{io::Write}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-dtoa-short-0.3
  (package
    (name "rust-dtoa-short")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa-short" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wkn7ziqffq8hj0a411lgn7674ackzdk734ikp230rmp2f2hn0jr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dtoa" ,rust-dtoa-0.4))
       #:cargo-development-inputs
       (("rust-float-cmp" ,rust-float-cmp-0.3))))
    (home-page "https://github.com/upsuper/dtoa-short")
    (synopsis "Serialize float number and truncate to certain precision")
    (description
     "Serialize float number and truncate to certain precision in Rust.")
    (license license:mpl2.0)))

(define-public rust-dtparse-1
  (package
    (name "rust-dtparse")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dtparse" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xh9hasfffnfyv8q9pwr31g63rigfx114qz6xw05wdkzpmfnq9qk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.5)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rust-decimal" ,rust-rust-decimal-0.10))))
    (home-page "https://github.com/bspeice/dtparse.git")
    (synopsis "Dateutil-compatible timestamp parser for Rust")
    (description
     "This package provides a @code{dateutil}-compatible timestamp parser for
Rust.")
    (license license:asl2.0)))

(define-public rust-duct-0.13
  (package
    (name "rust-duct")
    (version "0.13.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "duct" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13bxiy0y1dck3xz28rqw5ylf2ykv6mk8ww6g8408x26hksjs1ihg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-os-pipe" ,rust-os-pipe-0.9)
        ("rust-shared-child" ,rust-shared-child-0.3))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page
     "https://github.com/oconnor663/duct.rs")
    (synopsis
     "Library for running child processes")
    (description
     "A library for running child processes.")
    (license license:expat)))

(define-public rust-duct-0.8
  (package
    (inherit rust-duct-0.13)
    (name "rust-duct")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "duct" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0p06yslfi1wa68c2x068wmi9pr2mzmm64d6qwq8zba58w1gs2np4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.8)
        ("rust-lazycell" ,rust-lazycell-0.5)
        ("rust-os-pipe" ,rust-os-pipe-0.5)
        ("rust-shared-child" ,rust-shared-child-0.2))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-dunce-1
  (package
    (name "rust-dunce")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dunce" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d7f7wg83i1by16rxc1fdipi872nvkzjnmzaaggh2h8cgi51qr5j"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://gitlab.com/kornelski/dunce")
    (synopsis "Normalize Windows paths to the most compatible format")
    (description
     "This crate converts Windows UNC paths to the MS-DOS-compatible format
whenever possible, but leaves UNC paths as-is when they can't be unambiguously
expressed in a simpler way.  This allows legacy programs to access all paths
they can possibly access, and doesn't break any paths for UNC-aware
programs.")
    (license license:cc0)))

(define-public rust-dyn-clone-1
  (package
    (name "rust-dyn-clone")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dyn-clone" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kxb16nxiixn558gn82yaq2fl6271jay4rqkrw31lmnprjpjc9pf"))))
    (arguments
     `(#:skip-build? #t))
    (build-system cargo-build-system)
    (home-page "https://crates.io/crates/dyn-clone")
    (synopsis "Clone trait that is object-safe")
    (description "Clone trait that is object-safe")
    (license (list license:expat license:asl2.0))))

(define-public rust-dwrote-0.11
  (package
    (name "rust-dwrote")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dwrote" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nx6d9ddqjv0gfi1if3zbsnc9sfj6qfm900jfgnx66k1llmir6j3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-wio" ,rust-wio-0.2))))
    (home-page "https://github.com/servo/dwrote-rs")
    (synopsis "Lightweight binding to DirectWrite")
    (description
     "This package provides lightweight binding to DirectWrite.")
    (license license:mpl2.0)))

(define-public rust-easy-cast-0.4
  (package
    (name "rust-easy-cast")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easy-cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13ilmaplp2s4vw1vjh4pwbzk7jdxrn0kpf0rk5sli0s1ikp05lab"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/kas-gui/easy-cast")
    (synopsis "Type conversions which are expected to succeed")
    (description "This library is written to make numeric type conversions
easy.")
    (license license:asl2.0)))

(define-public rust-easy-parallel-3
  (package
    (name "rust-easy-parallel")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easy-parallel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x28z540fc4g8fqm1sbpqbpdfbi40mkas4xr57s3yn0jjbbszm0x"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stjepang/easy-parallel")
    (synopsis "Run closures in parallel")
    (description
     "This crate provides a simple primitive for spawning threads in bulk and
waiting for them to complete.  Threads are allowed to borrow local variables
from the main thread.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-easycurses-0.12
  (package
    (name "rust-easycurses")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easycurses" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10cp60lrhn1k0vg97jgzqbk03x4hmhrgxbz9m3gcmzhzbpn88m2a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-pancurses" ,rust-pancurses-0.16))))
    (home-page "https://github.com/Lokathor/easycurses-rs")
    (synopsis "Work with @code{curses} easily")
    (description
     "This package provides a crate that makes working with @code{curses}
easy.")
    (license (list license:unlicense license:zlib))))

(define-public rust-ecies-ed25519-0.5
  (package
    (name "rust-ecies-ed25519")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ecies-ed25519" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nrmam79mn2y6b235rpq6lhlsfl63275j2yxps86424gh99j720a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aes-gcm" ,rust-aes-gcm-0.8)
        ("rust-curve25519-dalek" ,rust-curve25519-dalek-3)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-hkdf" ,rust-hkdf-0.10)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-ring" ,rust-ring-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://github.com/phayes/ecies-ed25519")
    (synopsis
     "Integrated encryption scheme on Twisted Edwards Curve25519")
    (description
     "ECIES on Twisted Edwards Curve25519 using AES-GCM and HKDF-SHA256.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ed25519-1
  (package
    (name "rust-ed25519")
    (version "1.0.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ed25519" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1vxn7x1xinbv1cl31015m0fw08jwkphylxrll17animv9i9nmiip"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-serde" ,rust-serde-1)
         ("rust-signature" ,rust-signature-1))))
    (home-page "")
    (synopsis "Edwards Digital Signature Algorithm (EdDSA) over Curve25519")
    (description
      "EdDSA over Curve25519 is specified in RFC 8032.  This package contains
an ed25519::Signature type which other packages can use in conjunction with
the signature::Signer and signature::Verifier traits It doesn't contain an
implementation of Ed25519.

These traits allow packages which produce and consume Ed25519 signatures to be
written abstractly in such a way that different signer/verifier providers can
be plugged in, enabling support for using different Ed25519 implementations,
including HSMs or Cloud KMS services.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ed25519-dalek-1
  (package
    (name "rust-ed25519-dalek")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ed25519-dalek" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "17bsriciv93nkm39z22w7mr0h2a3hnbmgf378v4c895gvkkblqn7"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-curve25519-dalek" ,rust-curve25519-dalek-3)
         ("rust-ed25519" ,rust-ed25519-1)
         ("rust-merlin" ,rust-merlin-2)
         ("rust-rand" ,rust-rand-0.7)
         ("rust-rand-core" ,rust-rand-core-0.5)
         ("rust-serde" ,rust-serde-1)
         ("rust-serde-bytes" ,rust-serde-bytes-0.11)
         ("rust-sha2" ,rust-sha2-0.9)
         ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://dalek.rs")
    (synopsis "Ed25519 EdDSA key generations, signing, and verification")
    (description
      "This package provides fast and efficient ed25519 EdDSA key generations,
signing, and verification in pure Rust.")
    (license license:bsd-3)))

(define-public rust-edit-distance-2
  (package
    (name "rust-edit-distance")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "edit-distance" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0yq3wlmd7ly22qxhfysi77qp31yvpx2ll9waa75bkpiih7rsmfmv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/febeling/edit-distance")
    (synopsis "Levenshtein edit distance between strings")
    (description
     "Levenshtein edit distance between strings, a measure for similarity.")
    (license license:asl2.0)))

(define-public rust-ego-tree-0.6
  (package
    (name "rust-ego-tree")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ego-tree" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "149mkc6j7bx653s39rpnsnpl5dvd1rj18czcil57w54k868a8s1s"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/programble/ego-tree")
    (synopsis "Vec-backed ID-tree")
    (description "Ego Tree provides a vec-backed ID-tree.")
    (license license:isc)))

(define-public rust-either-1
  (package
    (name "rust-either")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "either" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mwl9vngqf5jvrhmhn9x60kr5hivxyjxbmby2pybncxfqhf4z3g7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/bluss/either")
    (synopsis
     "Enum @code{Either} with variants @code{Left} and @code{Right}")
    (description
     "The enum @code{Either} with variants @code{Left} and
@code{Right} is a general purpose sum type with two cases.")
    (license (list license:expat license:asl2.0))))

(define-public rust-elf-0.0.10
  (package
    (name "rust-elf")
    (version "0.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "elf" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xcpf7jdmrl7rdmd6009grahvgp3k695h5x4cadrpr70vcaxwha8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-byteorder" ,rust-byteorder-0.5))))
    (home-page "https://github.com/cole14/rust-elf/")
    (synopsis "Library for parsing ELF files")
    (description
     "This package provides a pure-Rust library for parsing ELF files.")
    (license (list license:expat license:asl2.0))))

(define-public rust-emacs-0.18
  (package
    (name "rust-emacs")
    (version "0.18.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0r860i73b2680i2fhdl2l1wwvvmf2zksncpckgkksdcx310ak5v7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-ctor" ,rust-ctor-0.1)
        ("rust-emacs-macros" ,rust-emacs-macros-0.17)
        ("rust-emacs-module" ,rust-emacs-module-0.18)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-thiserror" ,rust-thiserror-1))))
    (inputs
     (list clang))
    (home-page "https://github.com/ubolonton/emacs-module-rs")
    (synopsis "Library for creating Emacs's dynamic modules")
    (description
     "This crate provides a high level binding to emacs-module:
Emacs' support for dynamic modules.")
    (license license:bsd-3)))

(define-public rust-emacs-0.11
  (package (inherit rust-emacs-0.18)
    (name "rust-emacs")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1xn6nr8m3p24irlmv3i7c9n95yb10qc6aikwqv99qlmhbky5x0z7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ctor" ,rust-ctor-0.1)
        ("rust-emacs-macros" ,rust-emacs-macros-0.11)
        ("rust-emacs-module" ,rust-emacs-module-0.10)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-emacs-macros-0.17
  (package
    (name "rust-emacs-macros")
    (version "0.17.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs-macros" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0qg1dcn5acbirq617qq2fgg9adswif2dnr292s3qnq62wzgnyrb9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.10)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/ubolonton/emacs-module-rs")
    (synopsis "Proc macros for Emacs modules")
    (description "This package provides proc macros for Emacs modules.")
    (license license:bsd-3)))

(define-public rust-emacs-macros-0.11
  (package (inherit rust-emacs-macros-0.17)
    (name "rust-emacs-macros")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0390y8vafxdi334hhgrzvcqjq3n5ckcmvilqcfp8vajjq8irrly6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.9)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-emacs-module-0.18
  (package
    (name "rust-emacs-module")
    (version "0.18.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs_module" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ypjyyv2ca3vza4sia91ckxamgfk63yd8frkvg3d4ph4fk4pn1mk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.59))))
    (inputs
     (list clang))
    (home-page "https://github.com/ubolonton/emacs-module-rs")
    (synopsis "Raw FFI for emacs-module")
    (description "This module provides a high-level binding to emacs-module:
Emacs' support for dynamic modules.")
    (license license:bsd-3)))

(define-public rust-emacs-module-0.10
  (package (inherit rust-emacs-module-0.18)
    (name "rust-emacs-module")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs_module" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1gf9lz735xbkyir53dyv362drfx3nin5an5cx39kd8q8kjjwix5g"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.48))))))

(define-public rust-email-0.0.20
  (package
    (name "rust-email")
    (version "0.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "email" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r12byj69x6bkq0qn1zvi103n1pg5k3w8zym2dgich82pd8rlm4i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-encoding" ,rust-encoding-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-time" ,rust-time-0.1)
        ("rust-version-check" ,rust-version-check-0.1))))
    (home-page "https://github.com/niax/rust-email")
    (synopsis "Implementation of RFC 5322 email messages")
    (description
     "This crate provides an implementation of RFC 5322 email messages.")
    (license license:expat)))

(define-public rust-lettre-email-0.9
  (package
    (name "rust-lettre-email")
    (version "0.9.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lettre_email" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mar4njchjd33q7s47r43njjj8farkb78f8ica77jj6gil7lh0px"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-email" ,rust-email-0.0.20)
        ("rust-lettre" ,rust-lettre-0.9)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-time" ,rust-time-0.1)
        ("rust-uuid" ,rust-uuid-0.7))))
    (home-page "https://github.com/lettre/lettre")
    (synopsis "Mailer library for Rust")
    (description "Lettre is a mailer library for Rust.  It provides multiple
transport methods, unicode support, secure delivery with SMTP using encryption
and authentication, easy email builders, and async support.")
    (license license:expat)))

(define-public rust-embed-resource-1
  (package
    (name "rust-embed-resource")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "embed-resource" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w6l2zh82sx8rqjpr2a0y56m6hjb6zrqbp3l8b984a96y7mnvsnh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-vswhom" ,rust-vswhom-0.1)
        ("rust-winreg" ,rust-winreg-0.8))))
    (home-page "https://github.com/nabijaczleweli/rust-embed-resource")
    (synopsis
     "Cargo library to handle compilation and inclusion of Windows resources")
    (description
     "This package provides a Cargo library to handle compilation and
inclusion of Windows resources in the most resilient fashion imaginable.")
    (license license:expat)))

(define-public rust-embedded-hal-0.2
  (package
    (name "rust-embedded-hal")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "embedded-hal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1faa71mvs9zklyiiy9l5br9f2bwmxwak0br7jb49cr8mzxignv73"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nb" ,rust-nb-0.1)
        ("rust-void" ,rust-void-1))))
    (home-page "https://github.com/rust-embedded/embedded-hal")
    (synopsis "Hardware Abstraction Layer (HAL) for embedded systems")
    (description "This package provides a Hardware Abstraction Layer (HAL) for
embedded systems.")
    (license (list license:expat license:asl2.0))))

(define-public rust-empfindung-0.2
  (package
    (name "rust-empfindung")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "empfindung" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h68h3sxsa79a47jag3yim5jm63ffz72ifj46xkn12j2s5nss85l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lab" ,rust-lab-0.11)
        ("rust-rgb" ,rust-rgb-0.8))))
    (home-page "https://github.com/mina86/empfindung")
    (synopsis "Rust implementation of the CIEDE2000 colour difference")
    (description
     "Empfindung is a pure-Rust implementation of the CIEDE2000 colour
difference.")
    (license license:expat)))

(define-public rust-ena-0.14
  (package
    (name "rust-ena")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ena" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hrnkx2swbczn0jzpscxxipx7jcxhg6sf9vk911ff91wm6a2nh6p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-dogged" ,rust-dogged-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-petgraph" ,rust-petgraph-0.4))))
    (home-page "https://github.com/rust-lang/ena")
    (synopsis "Union-find, congruence closure, and other unification code")
    (description "This package provides an implementation of union-find /
congruence-closure in Rust.  It was extracted from rustc for independent
experimentation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ena-0.13
  (package
    (inherit rust-ena-0.14)
    (name "rust-ena")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ena" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dkggq0qwv140y2kjfd4spp77zi3v7vnpm4bfy7s7r4cla7xqi49"))))))

(define-public rust-encode-unicode-0.3
  (package
    (name "rust-encode-unicode")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encode_unicode" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07w3vzrhxh9lpjgsg2y5bwzfar2aq35mdznvcp3zjl0ssj7d4mx3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ascii" ,rust-ascii-1)
        ("rust-clippy" ,rust-clippy-0.0))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/tormol/encode_unicode")
    (synopsis
     "UTF-8 and UTF-16 support for char, u8 and u16")
    (description
     "UTF-8 and UTF-16 character types, iterators and related methods for
char, u8 and u16.")
    (license (list license:expat license:asl2.0))))

(define-public rust-encoding-0.2
  (package
    (name "rust-encoding")
    (version "0.2.33")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v1ndmkarh9z3n5hk53da4z56hgk9wa5kcsm7cnx345raqw983bb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-japanese"
         ,rust-encoding-index-japanese-1.20141219)
        ("rust-encoding-index-korean"
         ,rust-encoding-index-korean-1.20141219)
        ("rust-encoding-index-simpchinese"
         ,rust-encoding-index-simpchinese-1.20141219)
        ("rust-encoding-index-singlebyte"
         ,rust-encoding-index-singlebyte-1.20141219)
        ("rust-encoding-index-tradchinese"
         ,rust-encoding-index-tradchinese-1.20141219))
       #:cargo-development-inputs
       (("rust-getopts" ,rust-getopts-0.2))))
    (home-page
     "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Character encoding support for Rust")
    (description
     "Character encoding support for Rust.")
    (license license:expat)))

(define-public rust-encoding-index-japanese-1.20141219
  (package
    (name "rust-encoding-index-japanese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-japanese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "148c1lmd640p1d7fzk0nv7892mbyavvwddgqvcsm78798bzv5s04"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for Japanese character encodings")
    (description
     "Index tables for Japanese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-korean-1.20141219
  (package
    (name "rust-encoding-index-korean")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-korean" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10cxabp5ppygbq4y6y680856zl9zjvq7ahpiw8zj3fmwwsw3zhsd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for Korean character encodings")
    (description
     "Index tables for Korean character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-simpchinese-1.20141219
  (package
    (name "rust-encoding-index-simpchinese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-simpchinese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xria2i7mc5dqdrpqxasdbxv1qx46jjbm53if3y1i4cvj2a72ynq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for simplified Chinese character encodings")
    (description
     "Index tables for simplified Chinese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-singlebyte-1.20141219
  (package
    (name "rust-encoding-index-singlebyte")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-singlebyte" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jp85bz2pprzvg9m95w4q0vibh67b6w3bx35lafay95jzyndal9k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for various single-byte character encodings")
    (description
     "Index tables for various single-byte character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-tests-0.1
  (package
    (name "rust-encoding-index-tests")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_index_tests" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0s85y091gl17ixass49bzaivng7w8p82p6nyvz2r3my9w4mxhim2"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis
     "Macros used to test index tables for character encodings")
    (description
     "Helper macros used to test index tables for character
encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-tradchinese-1.20141219
  (package
    (name "rust-encoding-index-tradchinese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-tradchinese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "060ci4iz6xfvzk38syfbjvs7pix5hch3mvxkksswmqwcd3aj03px"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for traditional Chinese character encodings")
    (description
     "Index tables for traditional Chinese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-rs-0.8
  (package
    (name "rust-encoding-rs")
    (version "0.8.28")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rf0r99q4kgjrx22kx7pjyjg4lm21599y3ggvy3hzj2spi7h5pw0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-packed-simd" ,rust-packed-simd-2-0.3)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://docs.rs/encoding_rs/")
    (synopsis "Gecko-oriented implementation of the Encoding Standard")
    (description
     "This package provides a Gecko-oriented implementation of the Encoding
Standard.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-encoding-rs-io-0.1
  (package
    (name "rust-encoding-rs-io")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_rs_io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10ra4l688cdadd8h1lsbahld1zbywnnqv68366mbhamn3xjwbhqw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-encoding-rs" ,rust-encoding-rs-0.8))))
    (home-page "https://github.com/BurntSushi/encoding_rs_io")
    (synopsis "Streaming transcoding for encoding_rs")
    (description
     "Streaming transcoding for encoding_rs.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-endian-type-0.1
  (package
    (name "rust-endian-type")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "endian-type" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bbh88zaig1jfqrm7w3gx0pz81kw2jakk3055vbgapw3dmk08ky3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/Lolirofle/endian-type")
    (synopsis "Type safe wrappers for types with a defined byte order")
    (description
     "This crates provides type safe wrappers for types with a defined byte
order.")
    (license license:expat)))

(define-public rust-entities-1
  (package
    (name "rust-entities")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "entities" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jnpr0zvj97wm9pnh7fnl74rzaar39hhg65p03cm08bqqgj0lcmm"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/p-jackson/entities")
    (synopsis "Raw data needed to convert to and from HTML entities")
    (description "This package provides the raw data needed to convert to and
from HTML entities.")
    (license license:expat)))

(define-public rust-enum-as-inner-0.3
  (package
    (name "rust-enum-as-inner")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-as-inner" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15gmpgywijda93lkq7hf2y53h66sqkhzabzbxich288xm6b00pvw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-heck" ,rust-heck-0.3)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/bluejekyll/enum-as-inner")
    (synopsis "Proc-macro for deriving inner field accessor functions on enums")
    (description "This package provides a proc-macro for deriving inner field
accessor functions on enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-as-inner-0.2
  (package
    (inherit rust-enum-as-inner-0.3)
    (name "rust-enum-as-inner")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "enum-as-inner" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0zg3h7k3g1z7a9ayqy63sk302d4dg5g2h274ddv80mj4jxn2cn1x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-enum-map-derive-0.4
  (package
    (name "rust-enum-map-derive")
    (version "0.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-map-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mg43p1x90cz604zddk9qzss077v2id04qmmbpa1i7jc637m1i75"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://gitlab.com/KonradBorowski/enum-map")
    (synopsis "Macros 1.1 implementation of #[derive(Enum)]")
    (description "This package provides a macros 1.1 implementation of
@code{#[derive(Enum)]}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-map-0.6
  (package
    (name "rust-enum-map")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-map" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0m8qg32fnjdf6z64j4wmyp935p5838wd31gibkiqpbpl76c9k1s1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-array-macro" ,rust-array-macro-1)
        ("rust-enum-map-derive" ,rust-enum-map-derive-0.4)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://gitlab.com/KonradBorowski/enum-map")
    (synopsis "Map with C-like enum keys represented internally as an array")
    (description
     "This package provides a map with C-like enum keys represented internally
as an array.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-primitive-0.1
  (package
    (name "rust-enum-primitive")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-primitive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "100ip2p3w1rq0clca2ai5shhvpxfipnsjncj0f9ralad5w4m2idy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.1))))
    (home-page "https://github.com/andersk/enum_primitive-rs")
    (synopsis "Macro to generate @code{num::FromPrimitive} instances for enum")
    (description
     "This package provides a macro to generate @code{num::FromPrimitive}
instances for enum.")
    (license license:expat)))

(define-public rust-enum-primitive-derive-0.2
  (package
    (name "rust-enum-primitive-derive")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-primitive-derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0h1k2izdl5lf2na8xnj7rgwjm8gawxc2p1w8j6ahifvyka7jhljz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://gitlab.com/cardoe/enum-primitive-derive")
    (synopsis "Reimplementation of enum_primitive using a #[derive] macro")
    (description
     "This package provides a custom derive using procedural macros to
implement enum_primitive.")
    (license license:expat)))

(define-public rust-enum-to-u8-slice-derive-0.1
  (package
    (name "rust-enum-to-u8-slice-derive")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum_to_u8_slice_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hvzi74pnh5a7f4klrk0dz45l0mgcy5l3zajjhjsxzws28js4yc4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.11))))
    (home-page "https://github.com/mesalock-linux/enum_to_u8_slice_derive")
    (synopsis "Convert enum to u8 slice ref")
    (description
     "This package provides a simple fork of @code{enum_to_str_derive},
convert enum to u8 slice ref.")
    (license license:bsd-3)))

(define-public rust-enumset-1
  (package
    (name "rust-enumset")
    (version "1.0.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "enumset" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0b2vdggbsnvvw09czxaazbqcpa378fycf7fs3afz5dbgkb0x45k2"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-enumset-derive" ,rust-enumset-derive-0.5)
         ("rust-serde" ,rust-serde-1))
        #:cargo-development-inputs
        (("rust-bincode" ,rust-bincode-1)
         ("rust-rustversion" ,rust-rustversion-1)
         ("rust-serde-derive" ,rust-serde-derive-1)
         ("rust-serde-json" ,rust-serde-json-1)
         ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/Lymia/enumset")
    (synopsis "Library for creating compact sets of enums")
    (description "This package provides a Rust library for creating
compact sets of enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enumset-derive-0.5
  (package
    (name "rust-enumset-derive")
    (version "0.5.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "enumset-derive" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1m7ccz9fcxsx3s1drj77psk62xfgjia0hp9lal3qhpb5ls514lb4"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-darling" ,rust-darling-0.13)
         ("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/Lymia/enumset")
    (synopsis "Internal helper crate for enumset")
    (description "This package is an internal helper crate for
@code{rust-enumset}.  It is not public API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-logger-0.9
  (package
    (name "rust-env-logger")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hzr53r0wga51j0w5zid69ylbfizg4qdbq0vqdj6rvki94sg0b0b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))
    (home-page "https://github.com/sebasmagri/env_logger/")
    (synopsis "Logging implementation for @code{log}")
    (description
     "This package provides a logging implementation for @code{log} which
is configured via an environment variable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-logger-0.8
  (package
    (inherit rust-env-logger-0.9)
    (name "rust-env-logger")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env-logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qzw8g11dbdfi7ixm44ldykwcqsxqkh8vx5cgpd88zmclgz8g4d1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.7
  (package
    (inherit rust-env-logger-0.8)
    (name "rust-env-logger")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0djx8h8xfib43g5w94r1m1mkky5spcw4wblzgnhiyg5vnfxknls4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.6
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lx2s5nk96xx4i3m4zc4ghqgi8kb07dsnyiv8jk2clhax42dxz5a"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.5
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.5.13")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "env-logger" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0f0c4i4c65jh8lci0afl5yg74ac0lbnpxcp81chj114zwg9a9c0m"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.4
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.4.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "env-logger" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nydz2lidsvx9gs0v2zcz68rzqx8in7fzmiprgsrhqh17vkj3prx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-regex" ,rust-regex-0.2))))))

(define-public rust-env-logger-0.3
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bvcjgkw4s3k1rd7glpflgc8s9a393zjd6jfdgvs8gjvwj0dgaqm"))))
    (arguments
     `(#:skip-build? #t     ; Cannot find dependent crates.
       #:cargo-inputs
       (("rust-regex" ,rust-regex-0.1)
        ("rust-log" ,rust-log-0.3))))))

(define-public rust-env-proxy-0.4
  (package
    (name "rust-env-proxy")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "env_proxy" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1qabqhgybx1jzh6dmpx7kssciw312i8aa6al7fj0d12k32z1jl1s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4) ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/inejge/env_proxy")
    (synopsis "Proxy URL from the environment variables")
    (description
     "This package provides a way to determinate proxy parameters for a URL
from the environment.")
    (license (list license:expat license:asl2.0))))

(define-public rust-environment-0.1
  (package
    (name "rust-environment")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "environment" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vh32mcxf3z8xaibwv751zj14d08nh7iwk1vqdj90rkq17i18jqz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f)) ;; 3/6 tests fail due to missing file
    (home-page "https://github.com/Freyskeyd/environment")
    (synopsis "Helper to deal with environment variables")
    (description "This package provides helper to deal with environment
variables.")
    (license (list license:expat license:asl2.0))))

(define-public rust-envy-0.4
  (package
    (name "rust-envy")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "envy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rar459p7pl19v6pbx98q3hi2hxfl8q1ndxxw5d4zd9cgway0irz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/softprops/envy")
    (synopsis "Deserialize environment variables into Rust structs")
    (description
     "This package provides access to typesafe config structs
deserialized from environment variables.")
     (license license:expat)))

(define-public rust-erased-serde-0.3
  (package
    (name "rust-erased-serde")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "erased-serde" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lgkpkk7nx6f24gmr3psyj8d2avc9701r9jyw1i4ssp10lbnv2yq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (;("rust-serde-cbor" ,rust-serde-cbor-0.9)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/dtolnay/erased-serde")
    (synopsis "Type-erased Serialize and Serializer traits")
    (description
     "Type-erased Serialize and Serializer traits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-errno-0.2
  (package
    (name "rust-errno")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "errno" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kn8mlygxxr02cm97401nppd2dbkwsalpcbai67rh6yh3rh73862"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-errno-dragonfly" ,rust-errno-dragonfly-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/lambda-fairy/rust-errno")
    (synopsis "Cross-platform interface to the @code{errno} variable")
    (description
     "Cross-platform interface to the @code{errno} variable.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-errno-dragonfly-0.1
  (package
    (name "rust-errno-dragonfly")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "errno-dragonfly" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rshlc00nv45f14v2l1w0ma2nf1jg5j7q9pvw7hh018r6r73bjhl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-gcc" ,rust-gcc-0.3))))
    (home-page "https://github.com/mneumann/errno-dragonfly-rs")
    (synopsis "Exposes errno functionality to stable Rust on DragonFlyBSD")
    (description
     "Exposes errno functionality to stable Rust on DragonFlyBSD.")
    (license license:expat)))

(define-public rust-error-chain-0.12
  (package
    (name "rust-error-chain")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-chain" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1z6y5isg0il93jp287sv7pn10i4wrkik2cpyk376wl61rawhcbrd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/rust-lang-nursery/error-chain")
    (synopsis "Yet another error boilerplate library")
    (description
     "Yet another error boilerplate library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-error-chain-0.11
  (package
    (inherit rust-error-chain-0.12)
    (name "rust-error-chain")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "error-chain" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wykkr0naizbkwxjwia1rch8xhwvgij9khqvjzs07mrmqifislgz"))))
    (arguments
     `(#:tests? #f      ; Not all test files included.
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-chain-0.10
  (package
    (inherit rust-error-chain-0.11)
    (name "rust-error-chain")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "error-chain" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1y1gyj9g5c3k1nzkvxrgry8v9k86kcc585mczrm3qz019s35shyr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-chain-0.8
  (package
    (inherit rust-error-chain-0.11)
    (name "rust-error-chain")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-chain" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ijxazr966gjvckl3yrkcziazk3ryrfc466m84p9m2iq314y0c39"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-code-2
  (package
    (name "rust-error-code")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-code" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zxi3pfrmj7hmv2bv94ax8vpylsfs49vwwp48c04wrr5mikma4dm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-str-buf" ,rust-str-buf-1))))
    (home-page "")
    (synopsis "Alternative @code{Error} for Rust")
    (description
     "This package provides a simplified @code{Error} which works in
@code{no_std} environment.")
    (license license:boost1.0)))

(define-public rust-escaper-0.1
  (package
    (name "rust-escaper")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "escaper" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rhn3ipb5c3zns4wakclilfqzbmax6pwx7l367dipfj9fdxvjgm5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-entities" ,rust-entities-1))
       #:cargo-development-inputs
       (("rust-num" ,rust-num-0.4)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/dignifiedquire/rust-escaper")
    (synopsis "Library for HTML entity encoding and decoding")
    (description "This package provides a library for HTML entity encoding and
decoding.")
    (license (list license:asl2.0 license:expat license:mpl2.0))))

(define-public rust-escargot-0.5
  (package
    (name "rust-escargot")
    (version "0.5.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "escargot" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "19h1yvg9x7lvyb7p75ypyb94sacns5dkxwc4fa56mcksgnhlnn7m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-assert-fs" ,rust-assert-fs-1))))
    (home-page "https://github.com/crate-ci/escargot")
    (synopsis "Cargo API written in Paris")
    (description "Cargo API written in Paris.")
    (license (list license:expat license:asl2.0))))

(define-public rust-escargot-0.3
  (package
    (inherit rust-escargot-0.5)
    (name "rust-escargot")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "escargot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19fmn7bz1h6nlqy0mp825xwjwnrjn4xjdpwc06jl51j3fiz1znqr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-ethbloom-0.11
  (package
    (name "rust-ethbloom")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ethbloom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y73c4v60jy6wc4gssrg775y6vzc4axn523qkxswbxm8iyn89dmz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crunchy" ,rust-crunchy-0.2)
        ("rust-fixed-hash" ,rust-fixed-hash-0.7)
        ("rust-impl-codec" ,rust-impl-codec-0.5)
        ("rust-impl-rlp" ,rust-impl-rlp-0.3)
        ("rust-impl-serde" ,rust-impl-serde-0.3)
        ("rust-scale-info" ,rust-scale-info-1)
        ("rust-tiny-keccak" ,rust-tiny-keccak-2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-hex-literal" ,rust-hex-literal-0.3)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/paritytech/parity-common")
    (synopsis "Ethereum bloom filter")
    (description "This Rust library implements the Ethereum bloom filter.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ethbloom-0.5
  (package
    (inherit rust-ethbloom-0.11)
    (name "rust-ethbloom")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ethbloom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q2kix0p067rrfffhbfra453dw51s4cfgs0lhirslsv4callsad6"))))
    (arguments
     `(#:tests? #f                      ; The tests fail.
       #:cargo-inputs
       (("rust-crunchy" ,rust-crunchy-0.1)
        ("rust-ethereum-types-serialize" ,rust-ethereum-types-serialize-0.2)
        ("rust-fixed-hash" ,rust-fixed-hash-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-tiny-keccak" ,rust-tiny-keccak-1))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.1)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-rustc-hex" ,rust-rustc-hex-1))))))

(define-public rust-ethereum-types-0.12
  (package
    (name "rust-ethereum-types")
    (version "0.12.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ethereum-types" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1bxxacsmb9majw7vd4sndv4dhw3g9srhf7flwq39yy7yaxq6y4q5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t))
    (home-page "https://github.com/paritytech/parity-common")
    (synopsis "Rust crate exporting some Ethereum types")
    (description "This crate exports Rust types for values in the Ethereum
ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ethereum-types-0.9
  (package
    (inherit rust-ethereum-types-0.12)
    (name "rust-ethereum-types")
    (version "0.9.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ethereum-types" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1c1l2sg6li301izl4nzkkfrpc8snafxwnr81vfwygn3bd3zyqfj7"))))))

(define-public rust-ethereum-types-serialize-0.2
  (package
    (name "rust-ethereum-types-serialize")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ethereum-types-serialize" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0l53rvzvwpxwkl7i3f9q5fafw663rcm5z4mdknkr265w69xxfwqq"))))
    (build-system cargo-build-system)
    (arguments `(#:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/paritytech/primitives")
    (synopsis "Rust library of Ethereum types")
    (description "This package is a Rust library of Ethereum types.")
    (license license:expat)))

(define-public rust-event-listener-2
  (package
    (name "rust-event-listener")
    (version "2.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ndyp41pb2cx7gxijqh4ymnc47nyrvhvir7rvjlw6x09ayb10lzp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-waker-fn" ,rust-waker-fn-1))))
    (home-page "https://github.com/stjepang/event-listener")
    (synopsis "Notify async tasks or threads")
    (description
     "This is a synchronization primitive similar to @code{eventcounts}.
You can use this crate to turn non-blocking data structures into async or
blocking data structures.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-executors-0.9
  (package
    (name "rust-executors")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "executors" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0z8gn5vcr0x1db1bvahhmby9mpr1jgzd4qfvm25mja5js3agk51a"))))
    (build-system cargo-build-system)
    (arguments
     ;; TODO: build needs metrics_printer
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arr-macro" ,rust-arr-macro-0.1)
        ("rust-async-task" ,rust-async-task-4)
        ("rust-core-affinity" ,rust-core-affinity-0.5)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.8)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-metrics" ,rust-metrics-0.14)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-synchronoise" ,rust-synchronoise-1)
        ("rust-threadpool" ,rust-threadpool-1))))
    (home-page "https://github.com/Bathtor/rust-executors")
    (synopsis "Collection of high-performance task executors")
    (description
     "This package provides a collection of high-performance task executors.")
    (license license:expat)))

(define-public rust-exitcode-1
  (package
    (name "rust-exitcode")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exitcode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14x1pgwx86x1gfc5zqgj04akr9pzg14w75d9cblc49vhnij3g1fy"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/benwilber/exitcode")
    (synopsis "Preferred system exit codes as defined by @file{sysexits.h}")
    (description "This package provides preferred system exit codes as defined
by @file{sysexits.h}.")
    (license license:asl2.0)))

(define-public rust-exitfailure-0.5
  (package
    (name "rust-exitfailure")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exitfailure" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0585wix3b3pjjj90fkqj9x4ar46d24x82k8rdin3czzk5a1vvx9g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-failure" ,rust-failure-0.1))
       #:cargo-development-inputs
       (("rust-assert-cmd" ,rust-assert-cmd-0.9)
        ("rust-predicates" ,rust-predicates-0.9))
       ;; Tests fail with "No such file or directory".
       #:tests? #f))
    (home-page "https://github.com/tismith/exitfailure")
    (synopsis "Provide @code{newtype} wrappers for using @code{?} in @code{main}")
    (description
     "This package provides a basic @code{newtype} wrappers to help with using
@code{?} in @code{main}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-expat-sys-2
  (package
    (name "rust-expat-sys")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expat-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1yj5pqynds776ay8wg9mhi3hvna4fv7vf244yr1864r0i5r1k3v5"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "expat") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cmake" ,rust-cmake-0.1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list expat))
    (home-page "http://www.libexpat.org/")
    (synopsis "XML parser library written in C")
    (description "XML parser library written in C")
    (license license:expat)))

(define-public rust-expect-test-1
  (package
    (name "rust-expect-test")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expect-test" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05nv365xd5fqydmzbsvzqz0148a1vbxp2p0r8a3ivafdvhl6ngky"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build?
       #t
       #:cargo-inputs
       (("rust-dissimilar" ,rust-dissimilar-1)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page
     "https://github.com/rust-analyzer/expect-test")
    (synopsis
     "Minimalistic snapshot testing library")
    (description
     "This package provides a minimalistic snapshot testing library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-expectest-0.12
  (package
    (name "rust-expectest")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expectest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0y290ak3q5l8l8ajg00mqx1lx9f1pagk6ckmplzibf5ach5pr0bq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/zummenix/expectest")
    (synopsis "Matchers and matcher functions for unit testing")
    (description "This crate provides matchers and matcher functions for unit
testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-extend-0.1
  (package
    (name "rust-extend")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "extend" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01azyniinxrwng13hkj450gplp1ajslbqzksjg4dk6655sks6zgl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=test::test_ui" )
       #:cargo-inputs
       (("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/davidpdrsn/extend")
    (synopsis "Create extensions for types you don't own")
    (description
     "This crates creates extensions for types you don't own with extension
traits but without the boilerplate.")
    (license license:expat)))

(define-public rust-eyre-0.6
  (package
    (name "rust-eyre")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "eyre" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f0fbmrcykp84av1yb1d4cqj28jwf0zg1z49a1cgw8vrcf7ms8mw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-indenter" ,rust-indenter-0.3)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/yaahc/eyre")
    (synopsis "Trait object based error handling type")
    (description
     "This library provides @code{eyre::Report}, a trait object based error
handling type for easy idiomatic error handling and reporting in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fake-simd-0.1
  (package
    (name "rust-fake-simd")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fake-simd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vfylvk4va2ivqx85603lyqqp0zk52cgbs4n5nfbbbqx577qm2p8"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Crate for mimicking simd crate on stable Rust")
    (description
     "Crate for mimicking simd crate on stable Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fallible-collections-0.4
  (package
    (name "rust-fallible-collections")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible_collections" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1sk6ckixvf0pax47qgs8lfd2zi2gmyg1xgk1k7z2qgalhaaidnaa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-hashbrown" ,rust-hashbrown-0.9))))
    (home-page "https://github.com/vcombey/fallible_collections")
    (synopsis "Fallible collections implementation in Rust")
    (description "This library extends the Rust standard collections to return
a result when an allocation error occurs, ala
@url{https://github.com/rust-lang/rfcs/blob/master/text/2116-alloc-me-maybe.md,RFC
2116}.  The API currently proposes a fallible interface for @code{Vec},
@code{Box}, @code{Arc}, @code{Btree} and @code{Rc}, as well as a
@code{TryClone} trait which is implemented for primitive Rust traits and a
fallible format macro.")
    (license (list license:expat license:asl2.0))))

(define-public rust-failure-0.1
  (package
    (name "rust-failure")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "failure" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0js6i6mb42q1g6q3csfbmi6q40s64k96705xbim0d8zg44j9qlmq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-failure-derive" ,rust-failure-derive-0.1))))
    (home-page "https://rust-lang-nursery.github.io/failure/")
    (synopsis "Experimental error handling abstraction")
    (description
     "Experimental error handling abstraction.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-failure-derive-0.1
  (package
    (name "rust-failure-derive")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "failure_derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cfjz0c9szqpxn43b2r722p6m3swzxj7aj6xhqw23ml7h8y762h3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-synstructure" ,rust-synstructure-0.12))
       #:cargo-development-inputs
       (("rust-failure" ,rust-failure-0.1))))
    (home-page "https://rust-lang-nursery.github.io/failure/")
    (synopsis "Derives for the failure crate")
    (description "Derives for the failure crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fallible-iterator-0.2
  (package
    (name "rust-fallible-iterator")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fallible-iterator" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1xq759lsr8gqss7hva42azn3whgrbrs2sd9xpn92c5ickxm1fhs4"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-fallible-iterator")
    (synopsis "Fallible iterator traits")
    (description "If the @code{std} or @code{alloc} features are enabled, this
crate provides implementations for @code{Box}, @code{Vec}, @code{BTreeMap}, and
@code{BTreeSet}.  If the @code{std} feature is enabled, this crate additionally
provides implementations for @code{HashMap} and @code{HashSet}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-fallible-iterator-0.1
  (package
    (inherit rust-fallible-iterator-0.2)
    (name "rust-fallible-iterator")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible-iterator" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bpp2812lxm9fjv082dsy70ggsfg40nhqva7nxr5dp0j9091fwpb"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-fallible-streaming-iterator-0.1
  (package
    (name "rust-fallible-streaming-iterator")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible-streaming-iterator" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nj6j26p71bjy8h42x6jahx1hn0ng6mc2miwpgwnp8vnwqf4jq3k"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/fallible-streaming-iterator")
    (synopsis "Fallible streaming iteration")
    (description "Fallible streaming iteration")
    (license (list license:expat license:asl2.0))))

(define-public rust-fancy-regex-0.7
  (package
    (name "rust-fancy-regex")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1krwc8mbj8zv4ahvh3lqkmfxf38cg79ya02by19fn4jil1h8aswx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/fancy-regex/fancy-regex")
    (synopsis "Implementation of regexes with a rich set of features")
    (description
     "This package is a Rust library for compiling and matching regular
expressions.  It uses a hybrid regex implementation designed to support
a relatively rich set of features.  In particular, it uses backtracking to
implement features such as look-around and backtracking, which are not
supported in purely NFA-based implementations.")
    (license license:expat)))

(define-public rust-fast-chemail-0.9
  (package
    (name "rust-fast-chemail")
    (version "0.9.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fast_chemail" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r79x2i7bhk8y4nv7q245dlifxryszmby4k3psm2qk321p9kjnj9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ascii-utils" ,rust-ascii-utils-0.9))))
    (home-page "https://gitlab.com/fast_chemail/fast_chemail-rs")
    (synopsis "Check email address")
    (description "Fast Chemail is a library used to validate the email as it
is defined in the HTML specification.")
    (license license:mpl2.0)))

(define-public rust-fast-float-0.2
  (package
    (name "rust-fast-float")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fast-float" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g7kfll3xyh99kc7r352lhljnwvgayxxa6saifb6725inikmyxlm"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/aldanor/fast-float-rust")
    (synopsis "Fast floating-point number parser")
    (description
     "This crate provides a fast decimal number parser from strings into
floats.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fastq-0.6
  (package
    (name "rust-fastq")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fastq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "177jsfabnk3zl5zml6qvidzjpk53dp62rqjbdhbhr8cg7ms59p60"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-build-flags '("-vv")
       #:phases
       (modify-phases %standard-phases
         ;; This is needed for the parasail-sys package.
         (add-after 'unpack 'set-shell-for-configure-script
           (lambda _
             (setenv "SHELL" (which "sh"))
             (setenv "CONFIG_SHELL" (which "sh")))))
       #:cargo-inputs
       (("rust-flate2" ,rust-flate2-1)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-bio" ,rust-bio-0.33)
        ("rust-parasailors" ,rust-parasailors-0.3))))
    (inputs
     (list zlib))
    (native-inputs
     (list libtool))
    (home-page "https://github.com/aseyboldt/fastq-rs")
    (synopsis "Parser for fastq files")
    (description "This package provides a parser for fastq files.")
    (license license:expat)))

(define-public rust-fastrand-1
  (package
    (name "rust-fastrand")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fastrand" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16b4z2rig7zmyxw1hsiydv89h9wcshilds13dfpc919kmb7hg957"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-instant" ,rust-instant-0.1))
       #:cargo-development-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-instant" ,rust-instant-0.1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3)
        ("rust-wyhash" ,rust-wyhash-0.5))))
    (home-page "https://github.com/stjepang/fastrand")
    (synopsis "Simple and fast random number generator")
    (description
     "This package provides a simple and fast random number generator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fd-lock-3
  (package
    (name "rust-fd-lock")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fd-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dif8wk9xrqkjyfgqqy3zfg4ckmkpyzzk5p5m01s99q63bcnv05q"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/yoshuawuyts/fd-lock")
    (synopsis "Advisory lock on a file")
    (description
     "Fd-lock provides an advisory lock on a file using a file descriptor to
it.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fd-lock-2
  (package
    (inherit rust-fd-lock-3)
    (name "rust-fd-lock")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fd-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01kzrikg3a60lxmr0k8bbm4nggh6693f1pf530ip136qzwpg0400"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-fdlimit-0.1
  (package
    (name "rust-fdlimit")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fdlimit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g30d6gqkrwy8ylwdy7pqm443iq0p5dmnpz4ks41pirl7dclm98d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/paritytech/fdlimit")
    (synopsis "Utility crate for raising file descriptors limit")
    (description "This package provides a Rust library to raise file
descriptors limit.")
    (license license:asl2.0)))

(define-public rust-feature-probe-0.1
  (package
    (name "rust-feature-probe")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feature-probe" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nhif9zpr2f17gagf0qb0v914wc3jr9sfjzvnpi7b7pcs73ksnl3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tov/feature-probe-rs")
    (synopsis "Probe for rustc features from build.rs")
    (description "To support multiple versions of Rust, it's often necessary
to conditionally compile parts of our libraries or programs.  It's possible to
allow users to specify what features to enable, but detection is better,
because users get all the features that their version of Rust supports.  And
while we could check the rustc version, it's better to probe for individual
features.  This package probes for rustc features from build.rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-feed-rs-0.6
  (package
    (name "rust-feed-rs")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feed-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a1ain6r9k8bx7cz9pxqh3hdqbn8cqdkrbx78c8rxb7vqngyg53z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-quick-xml" ,rust-quick-xml-0.20)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-siphasher" ,rust-siphasher-0.3)
        ("rust-url" ,rust-url-2)
        ("rust-uuid" ,rust-uuid-0.8))))
    (home-page "https://github.com/feed-rs/feed-rs")
    (synopsis "Unified feed parser")
    (description "This package provides a unified feed parser that handles
Atom, RSS 2.0, RSS 1.0, RSS 0.x and JSON Feed")
    (license license:expat)))

(define-public rust-feedbin-api-0.1
  (package
    (name "rust-feedbin-api")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feedbin-api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "170xf3cgsqgqpnafpdmzzw9yvzc51r22lgr4f4hcrmidxlxpmlkp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests use the network
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-dotenv" ,rust-dotenv-0.15)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (home-page "https://gitlab.com/news-flash/feedbin_api")
    (synopsis  "Rust implementation of the Feedbin REST API")
    (description
     "This package provides a Rust implementation of the Feedbin REST API.")
    (license license:unlicense)))

(define-public rust-feedly-api-0.4
  (package
    (name "rust-feedly-api")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feedly-api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1knad1bghc8hhfcyl35fcnhrk01vklamq07630rdk0pg6ax04swi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests open external connections
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-percent-encoding"
         ,rust-percent-encoding-2)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-dotenv" ,rust-dotenv-0.15)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (home-page "https://gitlab.com/news-flash/feedly_api")
    (synopsis "Rust implementation of the feedly REST API")
    (description
     "This package provides a Rust implementation of the feedly REST API.")
    ;; No copyright headers in the source code.  LICENSE indicates gpl3.
    (license license:gpl3)))

(define-public rust-femme-2
  (package
    (name "rust-femme")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "femme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d7h1lzbcrqcn8v5l6m7i15lkbbaaz394l6vavbr8nhs757s5w9a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-kv-log-macro" ,rust-kv-log-macro-1))))
    (home-page "https://github.com/lrlna/femme")
    (synopsis "Pretty-printer and @code{ndjson} logger for @code{log} crate")
    (description
     "This package provides a pretty-printer and @code{ndjson} logger for
@code{log} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-femme-1
  (package
    (inherit rust-femme-2)
    (name "rust-femme")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "femme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0spf66m22dvnz6x077znybk906lh4p5z30nh8c37mad2c3dc56jd"))))
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-async-log" ,rust-async-log-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-console" ,rust-console-0.7)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))))))

(define-public rust-fern-0.6
  (package
    (name "rust-fern")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fern" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rghkbmpm7ckchd2fr2ifahprc7ll3qs0fbwsspsgj6cy0h4i6lc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-colored" ,rust-colored-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-reopen" ,rust-reopen-0.3)
        ("rust-syslog" ,rust-syslog-3)
        ("rust-syslog" ,rust-syslog-4))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-clap" ,rust-clap-2)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/daboross/fern")
    (synopsis "Simple, efficient logging")
    (description
     "This package provides a simple, efficient logging system for Rust.")
    (license license:expat)))

(define-public rust-fever-api-0.2
  (package
    (name "rust-fever-api")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fever-api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pv4g241pc0bfwy9gjwsmrdv7mplzbifxr5mxf0k82yxawg55anc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests use the network
       #:cargo-inputs
       (("rust-failure" ,rust-failure-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-md5" ,rust-md5-0.7)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-dotenv" ,rust-dotenv-0.15)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (home-page "https://gitlab.com/news-flash/fever_api")
    (synopsis "Rust implementation of the Fever API")
    (description
     "This package provides a Rust implementation of the Fever API.")
    ;; No copyright headers in the source code.  LICENSE indicates gpl3.
    (license license:gpl3)))

(define-public rust-fiat-crypto-0.1
  (package
    (name "rust-fiat-crypto")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fiat-crypto" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12gyr01z3bkahbxcrj2nsdq42qbqgq12w32dvpr6a7930i0qfxi1"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mit-plv/fiat-crypto")
    (synopsis "Fiat-crypto generated Rust")
    (description "This crate provides the extracted Rust code from the Coq
@code{fiat-crypto} libraries.")
    (license (list license:expat license:asl2.0))))

(define-public rust-filesize-0.2
  (package
    (name "rust-filesize")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filesize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hvx4dfnara3a2dnhb9ci5bmm1m8s44h9l61s5djwkjx87i43mqj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Freaky/rust-filesize")
    (synopsis "Find the physical space used by a file")
    (description
     "@code{filesize} abstracts platform-specific methods of determining the
real space used by files, taking into account file system compression and
sparse files.")
    (license license:expat)))

(define-public rust-filetime-0.2
  (package
    (name "rust-filetime")
    (version "0.2.14")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "filetime" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1s71cb7hzkk4ahc5j53w8933gnxv2giyj7v0za5hbbk37ahwyd0x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-redox-syscall" ,rust-redox-syscall-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/alexcrichton/filetime")
    (synopsis "Platform-agnostic accessors of timestamps in File metadata")
    (description
     "This library contains a helper library for inspecting and setting the
various timestamps of files in Rust.  This library takes into account
cross-platform differences in terms of where the timestamps are located, what
they are called, and how to convert them into a platform-independent
representation.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-field-offset-0.3
  (package
    (name "rust-field-offset")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "field-offset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14pvxz7yr0r3mlhaf65zva3r9d0kqid01wdw7ngx7jsh2jam870y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build?
       #t
       #:cargo-inputs
       (("rust-memoffset" ,rust-memoffset-0.6)
        ("rust-rustc-version" ,rust-rustc-version-0.3))))
    (home-page "https://github.com/Diggsey/rust-field-offset")
    (synopsis "Safe pointer-to-member implementation")
    (description "This package provides safe pointer-to-member
implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-findshlibs-0.10
  (package
    (name "rust-findshlibs")
    (version "0.10.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "findshlibs" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0r3zy2r12rxzwqgz53830bk38r6b7rl8kq2br9n81q7ps2ffbfa0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/gimli-rs/findshlibs")
    (synopsis "Find the set of shared libraries loaded in the current process")
    (description
     "Find the set of shared libraries loaded in the current process with a
cross platform API.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-fixed-1
  (package
    (name "rust-fixed")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixed" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0p0v4jjgbbvp91sl8rkfqb2hldaxbzv89mzwmp8753mlrfqwn185"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-az" ,rust-az-1)
        ("rust-half" ,rust-half-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4))))
    (home-page "https://gitlab.com/tspiteri/fixed")
    (synopsis "Rust fixed-point numbers")
    (description "This package provides fixed-point numbers in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixed-hash-0.7
  (package
    (name "rust-fixed-hash")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fixed-hash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g29r0zwf09kg70nprn0s444bn6nfsglmiafhl1pm8ajzvbhxkyg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-0.4)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rustc-hex" ,rust-rustc-hex-2)
        ("rust-static-assertions" ,rust-static-assertions-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rand-xorshift" ,rust-rand-xorshift-0.2))))
    (home-page "https://github.com/paritytech/parity-common")
    (synopsis "Macros to define custom fixed-size hash types")
    (description "This package provides Rust macros to define
custom fixed-size hash types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixed-hash-0.2
  (package
    (inherit rust-fixed-hash-0.7)
    (name "rust-fixed-hash")
    (version "0.2.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixed-hash" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0wvj52bf37nhg6mv5h235zgdg7nsdarag58mf4i49cdgc3l6rzks"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-heapsize" ,rust-heapsize-0.4)
         ("rust-libc" ,rust-libc-0.2)
         ("rust-quickcheck" ,rust-quickcheck-0.6)
         ("rust-rand" ,rust-rand-0.4)
         ("rust-rustc-hex" ,rust-rustc-hex-2)
         ("rust-serde" ,rust-serde-1)
         ("rust-serde-derive" ,rust-serde-derive-1)
         ("rust-uint" ,rust-uint-0.4))))))

(define-public rust-fixedbitset-0.4
  (package
    (name "rust-fixedbitset")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fixedbitset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17mnwa48dy11dnbasxa0c92sdj243acjl2ilhpcb1fa0pvxa93ir"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/bluss/fixedbitset")
    (synopsis "Simple bitset collection")
    (description "FixedBitSet is a simple bitset collection.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixedbitset-0.2
  (package
    (inherit rust-fixedbitset-0.4)
    (name "rust-fixedbitset")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixedbitset" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kg03p777wc0dajd9pvlcnsyrwa8dhqwf0sd9r4dw0p82rs39arp"))))))

(define-public rust-fixedbitset-0.1
  (package
    (inherit rust-fixedbitset-0.2)
    (name "rust-fixedbitset")
    (version "0.1.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixedbitset" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0czam11mi80dbyhf4rd4lz0ihcf7vkfchrdcrn45wbs0h40dxm46"))))))

(define-public rust-flame-0.2
  (package
    (name "rust-flame")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flame" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c5bmhyimzxch3pmh0w3z9n57saasgix4bmbbksr9vp1c5j71hhz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-thread-id" ,rust-thread-id-3))))
    (home-page "https://github.com/llogiq/flame")
    (synopsis "Profiling and flamegraph library")
    (description "A profiling and flamegraph library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-flamer-0.3
  (package
    (name "rust-flamer")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flamer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1b2d7jx80f3p7hqpgdi7wksaiq18k9w23p0cs2sxf7jbx2jx3bgj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Uses features not available in stable Rust release
       #:cargo-inputs
       (("rust-flame" ,rust-flame-0.2)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/llogiq/flamer")
    (synopsis "Macro to insert @code{flame::start_guard(_)}")
    (description
     "A procedural macro to insert @code{flame::start_guard(_)} calls.")
    (license license:asl2.0)))

(define-public rust-flatbuffers-2
  (package
    (name "rust-flatbuffers")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flatbuffers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xp5ppif0hvgh9kfvy1199gdmjc3dw1517022l1x3ynpphw5fk7g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://google.github.io/flatbuffers/")
    (synopsis "FlatBuffers Rust serialization library")
    (description
     "This crates provides FlatBuffers runtime serialization library.")
    (license license:asl2.0)))

(define-public rust-flatbuffers-0.8
  (package
    (inherit rust-flatbuffers-2)
    (name "rust-flatbuffers")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flatbuffers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sc0ngk9xim7xgqydx36xz4a1sqxq2fv7fmqn6z76vbx5cs05if3"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-flate2-1
  (package
    (name "rust-flate2")
    (version "1.0.23")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flate2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1bq9vavadgqqr72z5bzbp952c4q67a71kfc4r55qzlw6cvlj55dk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cloudflare-zlib-sys" ,rust-cloudflare-zlib-sys-0.3)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-miniz-sys" ,rust-miniz-sys-0.1)
        ("rust-miniz-oxide" ,rust-miniz-oxide-0.5)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-threadpool" ,rust-tokio-threadpool-0.1))))
    (home-page "https://github.com/alexcrichton/flate2-rs")
    (synopsis
     "Bindings to miniz.c for DEFLATE compression and decompression")
    (description
     "Bindings to miniz.c for DEFLATE compression and decompression exposed as
Reader/Writer streams.  Contains bindings for zlib, deflate, and gzip-based
streams.")
    (license (list license:expat license:asl2.0))))

(define-public rust-float-cmp-0.9
  (package
    (name "rust-float-cmp")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "float-cmp" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i799ksbq7fj9rm9m82g1yqgm6xi3jnrmylddmqknmksajylpplq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/mikedilger/float-cmp")
    (synopsis "Floating point approximate comparison traits")
    (description "This package provides floating point approximate comparison
traits.")
    (license license:expat)))

(define-public rust-float-cmp-0.8
  (package
    (inherit rust-float-cmp-0.9)
    (name "rust-float-cmp")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1i56hnzjn5pmrcm47fwkmfxiihk7wz5vvcgpb0kpfhzkqi57y9p1"))))
    (arguments
     `(#:cargo-inputs (("rust-num-traits" ,rust-num-traits-0.2))))))

(define-public rust-float-cmp-0.6
  (package
    (inherit rust-float-cmp-0.8)
    (name "rust-float-cmp")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0zb1lv3ga18vsnpjjdg87yazbzvmfwwllj3aiid8660rp3qw8qns"))))))

(define-public rust-float-cmp-0.5
  (package
    (inherit rust-float-cmp-0.6)
    (name "rust-float-cmp")
    (version "0.5.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "03hmx3n48hjm0x1ig84n1j87kzp75lzr6cj1sgi6a6pykgn4n8km"))))))

(define-public rust-float-cmp-0.4
  (package
    (inherit rust-float-cmp-0.5)
    (name "rust-float-cmp")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "float-cmp" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0036jb8ry4h83n319jb20b5yvyfyq8mx8dkxnyjm22nq8fl8yjhk"))))))

(define-public rust-float-cmp-0.3
  (package
    (inherit rust-float-cmp-0.5)
    (name "rust-float-cmp")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1c0hmj46xma5aysz0qb49padhc26aw875whx6q6rglsj5dqpds1b"))))
    (arguments
     `(#:cargo-inputs (("rust-num" ,rust-num-0.1))))))

(define-public rust-float-ord-0.3
  (package
    (name "rust-float-ord")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "float-ord" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gbvx6dzz8xvj38bj02cajpqd9p5syxjx9jyqpj8414amr4izs4c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/notriddle/rust-float-ord")
    (synopsis "Total ordering for floating-point numbers")
    (description
     "This package provides a total ordering for floating-point numbers")
    (license (list license:expat license:asl2.0))))

(define-public rust-float-ord-0.2
  (package
    (name "rust-float-ord")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "float-ord" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kin50365sr3spnbscq43lksymybi99ai9rkqdw90m6vixhlibbv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/notriddle/rust-float-ord")
    (synopsis "Total ordering for floating-point numbers")
    (description
     "This package provides a total ordering for floating-point numbers.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fluid-0.4
  (package
    (name "rust-fluid")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fluid" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04qgdc4lx934158icx9rvs0v6lyvirmb0brllvz38hj9fsaqfbsp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-colored" ,rust-colored-1)
        ("rust-fluid-attributes" ,rust-fluid-attributes-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://crates.io/crates/fluid")
    (synopsis "Human readable test library")
    (description "This package provides a human readable test library.")
    (license license:asl2.0)))

(define-public rust-fluid-attributes-0.4
  (package
    (name "rust-fluid-attributes")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fluid_attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1i67vcas0gr64bc8spprlfp7m7msv1jyspghgq1q8f0qrnvy8px8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15)
        ("rust-uuid" ,rust-uuid-0.7))))
    (home-page "https://gitlab.com/Boiethios/fluid-rs/wikis")
    (synopsis "Proc macro attributes for the fluid crate")
    (description "This package provides proc macro attributes for the fluid
crate.")
    (license license:asl2.0)))

(define-public rust-flume-0.10
  (package
    (name "rust-flume")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flume" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14dvj6d2r6vgsy3adv4lncbddjwc59rgl0rcwc1kdnsmqkh7lwhy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true    ;XXX: remove when rust-async-std-1 is packaged
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-nanorand" ,rust-nanorand-0.5)
        ("rust-spinning-top" ,rust-spinning-top-0.2))
       #:cargo-development-inputs
       (;("rust-async-std" ,rust-async-std-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-waker-fn" ,rust-waker-fn-1))))
    (home-page "https://github.com/zesterer/flume")
    (synopsis "Fast multi-producer channel")
    (description
     "This package provides a fast multi-producer channel.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-flume-0.9
  (package
    (inherit rust-flume-0.10)
    (name "rust-flume")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flume" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ck1w9881848xjjk93nxqsvnxfp4xsaysxxn23a210bg2amsvsqv"))))
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-nanorand" ,rust-nanorand-0.4)
        ("rust-spinning-top" ,rust-spinning-top-0.2))))))

(define-public rust-fnv-1
  (package
    (name "rust-fnv")
    (version "1.0.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fnv" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1hc2mcqha06aibcaza94vbi81j6pr9a1bbxrxjfhc91zin8yr7iz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/servo/rust-fnv")
    (synopsis "Implementation of the Fowler-Noll-Vo hash function")
    (description "The @code{fnv} hash function is a custom @code{Hasher}
implementation that is more efficient for smaller hash keys.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-font-kit-0.10
  (package
    (name "rust-font-kit")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "font-kit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a7fm757af2s9sk2i02plpa280mmygjmchcwpjclk1iqxiba3ja6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-core-text" ,rust-core-text-19)
        ("rust-dirs-next" ,rust-dirs-next-2)
        ("rust-dwrote" ,rust-dwrote-0.11)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-freetype" ,rust-freetype-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-pathfinder-geometry" ,rust-pathfinder-geometry-0.5)
        ("rust-pathfinder-simd" ,rust-pathfinder-simd-0.5)
        ("rust-servo-fontconfig" ,rust-servo-fontconfig-0.5)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/servo/font-kit")
    (synopsis "Font loading library")
    (description "This package provides a font loading library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-0.5
  (package
    (name "rust-foreign-types")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rfr2zfxnx9rz3292z5nyk8qs2iirznn5ff3rd4vgdwza6mdjdyp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-foreign-types-macros" ,rust-foreign-types-macros-0.2)
        ("rust-foreign-types-shared" ,rust-foreign-types-shared-0.3))))
    (home-page "https://github.com/sfackler/foreign-types")
    (synopsis "Framework for Rust wrappers over C APIs")
    (description
     "This package provides a framework for Rust wrappers over C APIs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-0.3
  (package
    (inherit rust-foreign-types-0.5)
    (name "rust-foreign-types")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cgk0vyd7r45cj769jym4a6s7vwshvd0z4bqrb92q1fwibmkkwzn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-foreign-types-macros" ,rust-foreign-types-macros-0.1)
        ("rust-foreign-types-shared" ,rust-foreign-types-shared-0.1))))))

(define-public rust-foreign-types-macros-0.2
  (package
    (name "rust-foreign-types-macros")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0x71sdffjfb123l2jn5vhz0ni09b4rdq3h3gpczd1dj1g5qlr2yv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/sfackler/foreign-types")
    (synopsis "Internal crate used by foreign-types")
    (description
     "This package is an internal crate used by foreign-types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-macros-0.1
  (package
    (inherit rust-foreign-types-macros-0.2)
    (name "rust-foreign-types-macros")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bh6z5rwdhfm987idal8r0ha5svz1li7md5l1g2a5966gya1jns0"))))))

(define-public rust-foreign-types-shared-0.3
  (package
    (name "rust-foreign-types-shared")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-shared" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mg85r21bxg2i97zl3q8l3cviqz4wcbwziz875wlja3zpcrwz13n"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/foreign-types")
    (synopsis "Internal crate used by foreign-types")
    (description
     "An internal crate used by foreign-types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-shared-0.2
  (package
    (inherit rust-foreign-types-shared-0.3)
    (name "rust-foreign-types-shared")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "foreign-types-shared" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kanxlif1vp0ffh2r9l610jqbkmb3183yqykxq1z5w1vay2rn7y6"))))))

(define-public rust-foreign-types-shared-0.1
  (package
    (inherit rust-foreign-types-shared-0.2)
    (name "rust-foreign-types-shared")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-shared" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jxgzd04ra4imjv8jgkmdq59kj8fsz6w4zxsbmlai34h26225c00"))))))

(define-public rust-form-urlencoded-1
  (package
    (name "rust-form-urlencoded")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "form_urlencoded" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y3bwavygjzv7b0yqsjqk33yi6wz25b7q2aaq9h54vqmc7qq9hx9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-percent-encoding" ,rust-percent-encoding-2))))
    (home-page "https://github.com/servo/rust-url")
    (synopsis "Parser and serializer for the urlencoded syntax")
    (description
     "Parser and serializer for the application/x-www-form-urlencoded
syntax, as used by HTML forms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fragile-1
  (package
    (name "rust-fragile")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fragile" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wlihmkjyhvl5rckal32p010piy1l15s6l81h7z31jcd971kk839"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/mitsuhiko/rust-fragile")
    (synopsis "Wrapper types for sending non-send values to other threads")
    (description "This package provides wrapper types for sending non-send
values to other threads.")
    (license license:asl2.0)))

(define-public rust-freetype-0.7
  (package
    (name "rust-freetype")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ijxyd8isq0w7qkbhp7p1y536xg3d8b8vy5ljg31rnz3m5w87qxy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-freetype-sys" ,rust-freetype-sys-0.13)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/servo/rust-freetype")
    (synopsis "Bindings for Freetype used by Servo")
    (description "This package provides bindings for Freetype used by Servo.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-freetype-rs-0.26
  (package
    (name "rust-freetype-rs")
    (version "0.26.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yzmbd73hlblbns0dqkcwfj54l97hx3yb0lqpda8rhm5s34xxskl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-freetype-sys" ,rust-freetype-sys-0.13)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/PistonDevelopers/freetype-rs")
    (synopsis "Bindings for FreeType font library")
    (description "This package provides bindings for FreeType font library.")
    (license license:expat)))

(define-public rust-freetype-sys-0.13
  (package
    (name "rust-freetype-sys")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06kkds31s6b1i39dyanwmzbnic7laia1kk3gfvx8sqncq08l0zd3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cmake" ,rust-cmake-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/PistonDevelopers/freetype-sys")
    (synopsis "Low level binding for FreeType font library")
    (description
     "This package provides low level binding for FreeType font library.")
    (license license:expat)))

(define-public rust-fs2-0.4
  (package
    (name "rust-fs2")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fs2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04v2hwk7035c088f19mfl5b1lz84gnvv2hv6m935n0hmirszqr4m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;; "#![feature] may not be used on stable release channel"
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/danburkert/fs2-rs")
    (synopsis "Cross-platform file locks and file duplication")
    (description "This package provides cross-platform file locks and file
duplication.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fs-extra-1
  (package
    (name "rust-fs-extra")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fs_extra" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "151k6dr35mhq5d8pc8krhw55ajhkyiv0pm14s7zzlc5bc9fp28i0"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/webdesus/fs_extra")
    (synopsis "Extra file system methods")
    (description "Expanding opportunities standard library @code{std::fs} and
@code{std::io}.  Recursively copy folders with recept information about
process and much more.")
    (license license:expat)))

(define-public rust-fs-utils-1
  (package
    (name "rust-fs-utils")
    (version "1.1.4")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "fs-utils" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "14r5wl14mz227v0lpy89lvjzfnxgdxigvrrmm6c4r52w03fakivg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quick-error" ,rust-quick-error-1))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/Byron/fs-utils-rs")
    (synopsis "Utilities to help working with the filesystem")
    (description "This package provides a bunch of utilities to help working
with the filesystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fs2-0.2
  (package
    (name "rust-fs2")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fs2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vsih93cvds3x6f3w9bc5rnkyv8haix1px4jpcqvjyd9l7ji9m5w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.2))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/danburkert/fs2-rs")
    (synopsis "File locks and file duplication")
    (description
     "This package provides cross-platform file locks and file duplication.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fsevent-2
  (package
    (name "rust-fsevent")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fsevent" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0qsylfbhgha319q6a8yvkznbm3hf47gy3y8nq82qijcm5hh4gwwp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-fsevent-sys" ,rust-fsevent-sys-3))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3)
        ("rust-time" ,rust-time-0.2))))
    (home-page "https://github.com/octplane/fsevent-rust")
    (synopsis "Rust bindings to the fsevent-sys macOS API")
    (description
     "This package provides Rust bindings to the @code{fsevent-sys} macOS API
for file changes notifications")
    (license license:expat)))

(define-public rust-fsevent-0.4
  (package
    (inherit rust-fsevent-2)
    (name "rust-fsevent")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fsevent" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1djxnc2fmv265xqf1iyfz56smh13v9r1p0w9125wjg6k3fyx3dss"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; only available on macOS
       #:cargo-inputs
        (("rust-bitflags" ,rust-bitflags-1)
         ("rust-fsevent-sys" ,rust-fsevent-sys-2))
        #:cargo-development-inputs
        (("rust-tempdir" ,rust-tempdir-0.3)
         ("rust-time" ,rust-time-0.1))))))

(define-public rust-fsevent-sys-4
  (package
    (name "rust-fsevent-sys")
    (version "4.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fsevent-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1liz67v8b0gcs8r31vxkvm2jzgl9p14i78yfqx81c8sdv817mvkn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/octplane/fsevent-rust/tree/master/fsevent-sys")
    (synopsis "Rust bindings to the fsevent macOS API")
    (description "This package provides Rust bindings to the @code{fsevent}
macOS API for file changes notifications")
    (license license:expat)))

(define-public rust-fsevent-sys-3
  (package
    (inherit rust-fsevent-sys-4)
    (name "rust-fsevent-sys")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fsevent-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mav57d1zcp4x17h0wprcr188d8yvxfz1c0f1z0p31q52xl5wvya"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))))

(define-public rust-fsevent-sys-2
  (package
    (inherit rust-fsevent-sys-3)
    (name "rust-fsevent-sys")
    (version "2.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fsevent-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18246vxk7rqn52m0sfrhivxq802i34p2wqqx5zsa0pamjj5086zl"))))
    (arguments
     `(#:skip-build? #t     ; only available on macOS
       #:cargo-inputs (("rust-libc" ,rust-libc-0.2))))))

(define-public rust-fslock-0.2
  (package
    (name "rust-fslock")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "fslock" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1yrv9j44k3njzpnh8m2jc0gr3hklzyzwfj3gmsdklbi76n4jnh84"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/brunoczim/fslock")
    (synopsis "Lock file library")
    (description "This package provides a library to use files as locks.")
    (license license:expat)))

(define-public rust-fst-0.4
  (package
    (name "rust-fst")
    (version "0.4.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fst" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "06mnksicgv9rp8b7w0ykkshf355l05zym3ygm74qr5z30ndmpf3s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-utf8-ranges" ,rust-utf8-ranges-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/BurntSushi/fst")
    (synopsis "Represent sets or maps of large numbers of strings")
    (description
     "Use finite state transducers to compactly represent sets or maps of many
strings (> 1 billion is possible).")
    (license (list license:unlicense license:expat))))

(define-public rust-fuchsia-cprng-0.1
  (package
    (name "rust-fuchsia-cprng")
    (version "0.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuchsia-cprng" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1fnkqrbz7ixxzsb04bsz9p0zzazanma8znfdqjvh39n14vapfvx0"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page
     "https://fuchsia.googlesource.com/fuchsia/+/master/garnet/public/rust/fuchsia-cprng")
    (synopsis "Fuchsia cryptographically secure pseudorandom number generator")
    (description "Rust crate for the Fuchsia cryptographically secure
pseudorandom number generator")
    (license license:bsd-3)))

(define-public rust-fuchsia-zircon-0.3
  (package
    (name "rust-fuchsia-zircon")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuchsia-zircon" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "10jxc5ks1x06gpd0xg51kcjrxr35nj6qhx2zlc5n7bmskv3675rf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-fuchsia-zircon-sys" ,rust-fuchsia-zircon-sys-0.3))))
    (home-page "https://fuchsia.googlesource.com/garnet/")
    (synopsis "Rust bindings for the Zircon kernel")
    (description "Rust bindings for the Zircon kernel.")
    (license license:bsd-3)))

(define-public rust-fuchsia-zircon-sys-0.3
  (package
    (name "rust-fuchsia-zircon-sys")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuchsia-zircon-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19zp2085qsyq2bh1gvcxq1lb8w6v6jj9kbdkhpdjrl95fypakjix"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://fuchsia.googlesource.com/garnet/")
    (synopsis "Low-level Rust bindings for the Zircon kernel")
    (description "Low-level Rust bindings for the Zircon kernel.")
    (license license:bsd-3)))

(define-public rust-funty-1
  (package
    (name "rust-funty")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "funty" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07lb1f8yih3g694id3n90anlgxf8m6p98bllsnn6dmb5rfwsniqq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://github.com/myrrlyn/funty")
    (synopsis "Trait generalization over the primitive types")
    (description
     "Prior to 1.0, Rust had traits for the numeric primitive types to permit
code to generalize over which specific type it accepted. This was never
stabilized, and eventually removed.  This library reïnstates these traits.")
    (license license:expat)))

(define-public rust-funty-1.1
  (package
    (inherit rust-funty-1)
    (name "rust-funty")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "funty" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19wx3p3jmv863y0mjb56sr4qf1kvqhl3fsyslkd92zli0p8lrlzy"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-static-assertions" ,rust-static-assertions-1))))))

(define-public rust-futf-0.1
  (package
    (name "rust-futf")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futf" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fxc18bnabird5jl941nsd6d25vq8cn8barmz4d30dlkzbiir73w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-mac" ,rust-mac-0.1)
        ("rust-new-debug-unreachable" ,rust-new-debug-unreachable-1))))
    (home-page "https://github.com/servo/futf")
    (synopsis "Handling fragments of UTF-8")
    (description "Handling fragments of UTF-8.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-futures-0.3
  (package
    (name "rust-futures")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l7i1hcag46k5v34cbn5dk45gwxn5yy5rxcvmbaxhi02lnhm546s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Rust implementation of futures and streams")
    (description
     "This package is a Rust implementation of futures and streams featuring
zero allocations, composability, and iterator-like interfaces.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-0.1
  (package
    (name "rust-futures")
    (version "0.1.29")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vq3cw37knnd0afw3rcjzh71i2l01v5m4ysinrrqdvnn2ql0z60v"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis "Implementation of zero-cost futures in Rust")
    (description "An implementation of @code{futures} and @code{streams}
featuring zero allocations, composability, and iterator-like interfaces.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-channel-0.3
  (package
    (name "rust-futures-channel")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-channel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ihq3a3yc6ial3sw536q75hrhixq22xk6wn5qzpnxazgqxz1plzj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3))))
    (home-page  "https://rust-lang.github.io/futures-rs")
    (synopsis "Channels for asynchronous communication using @code{futures-rs}")
    (description
     "This package provides channels for asynchronous communication using
@code{futures-rs}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-channel-preview-0.3
  (package
    (name "rust-futures-channel-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-channel-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fi6bi4lpyxjigy11y5sjg6wlc8nc71vbpmxz31c3aagjvgz9rfm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3))))
    (home-page "https://rust-lang.github.io/futures-rs/")
    (synopsis
     "Channels for asynchronous communication using futures-rs")
    (description
     "Channels for asynchronous communication using futures-rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-core-0.3
  (package
    (name "rust-futures-core")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0r8ag0mkxx9cd74yrccjk31lph4gr6lhgb9di6rx39wdvrfi9rbr"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Core traits and types in for the @code{futures} library")
    (description "This package provides the core traits and types in for the
@code{futures} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-core-preview-0.3
  (package
    (name "rust-futures-core-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-core-preview" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "02n66jkjhpy210dv24pz0j30lvyin5kzlrb50p1j7x8yzdin4nxk"))))
    (build-system cargo-build-system)
    (arguments '(#:tests? #f))
    (home-page "https://rust-lang-nursery.github.io/futures-rs/")
    (synopsis "Core traits and types in for the @code{futures} library")
    (description "This crate provides the core traits and types in for the
@code{futures} library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-cpupool-0.1
  (package
    (name "rust-futures-cpupool")
    (version "0.1.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-cpupool" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1r32456gpblzfvnkf60545v8acqk7gh5zhyhi1jn669k9gicv45b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://github.com/rust-lang-nursery/futures-rs")
    (synopsis "Implementation of thread pools which hand out futures")
    (description
     "An implementation of thread pools which hand out futures to the results of
the computation on the threads themselves.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-executor-0.3
  (package
    (name "rust-futures-executor")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-executor" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ffr1zclhz60ql49n2pj44jhhk22yah41xwlpyb30jws03f9zrg9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis
     "Executors for asynchronous tasks based on the @code{futures-rs} library")
    (description
     "This package provides executors for asynchronous tasks based on the
@code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-executor-preview-0.3
  (package
    (name "rust-futures-executor-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-executor-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "161yv7wwha60mdzj1id47kh8ylnhcnv7blgwidg8xs4zpn46w8vm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis
     "Executors for asynchronous tasks based on futures-rs")
    (description
     "Executors for asynchronous tasks based on the futures-rs
library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-intrusive-0.3
  (package
    (name "rust-futures-intrusive")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-intrusive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00qpir3q6j7blwpnpffj7ypf1z8wc87ldn62qr7sapymgg82j5dw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;XXX: need rust-async-std-1
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-lock-api" ,rust-lock-api-0.3)
        ("rust-parking-lot" ,rust-parking-lot-0.10))))
    (home-page "https://github.com/Matthias247/futures-intrusive")
    (synopsis "Futures based on intrusive data structures")
    (description
     "This crate provides a variety of Futures-based and
@code{async/await} compatible types that are based on the idea of
intrusive collections.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-io-0.3
  (package
    (name "rust-futures-io")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0005hz30pdxlbdamhd0imixmxcjpwrfxxr27kljxh6i84lshbgi8"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis
     "@code{AsyncRead} and @code{AsyncWrite} traits for the @code{futures-rs}
library")
    (description
     "This package provides the @code{AsyncRead} and @code{AsyncWrite} traits
for the @code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-io-preview-0.3
  (package
    (name "rust-futures-io-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-io-preview" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1npb04xbn2gw5rjllz88cb88fql44xxfkgcidjjj26fva3j4m4gl"))))
    (build-system cargo-build-system)
    (home-page "https://rust-lang-nursery.github.io/futures-rs/")
    (synopsis "Async read and write traits for the futures library")
    (description "This crate provides the @code{AsyncRead} and
@code{AsyncWrite} traits for the @code{futures-rs} library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-join-macro-preview-0.3
  (package
    (name "rust-futures-join-macro-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-join-macro-preview" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1smwaja466yjh5adlhgggfk9k942sy4702n46scxkrwcnkk61qjr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://rust-lang-nursery.github.io/futures-rs")
    (synopsis "Definition of the `join!` macro and the `try_join!` macro")
    (description
     "This package provides the definition of the @code{join!} macro and the
@code{try_join!} macro.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-lite-1
  (package
    (name "rust-futures-lite")
    (version "1.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ywmyvpy4f348jri8rxhpj59a7bvy12pspm59x5207fys061sj5l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-parking" ,rust-parking-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-waker-fn" ,rust-waker-fn-1))
       #:cargo-development-inputs
       (("rust-spin-on" ,rust-spin-on-0.1))))
    (home-page "https://github.com/stjepang/futures-lite")
    (synopsis "Futures, streams, and async I/O combinators")
    (description
     "This crate is a subset of @code{futures} that compiles an order of
magnitude faster, fixes minor warts in its API, fills in some obvious gaps,
and removes almost all unsafe code from it.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-futures-lite-0.1
  (package
    (inherit rust-futures-lite-1)
    (name "rust-futures-lite")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lnflz8ysp0vlq1sxzz1sw9cq7s33lh12cm9rc68z04v29q9k6cp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-parking" ,rust-parking-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-futures-macro-0.3
  (package
    (name "rust-futures-macro")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pgyb219ybh3fj3ig0h1c2b7k4cqldy95ifdpnd9yb9jvmdd51y2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "@code{futures-rs} procedural macro implementations")
    (description
     "This package provides the @code{futures-rs} procedural macro
implementations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-preview-0.3
  (package
    (name "rust-futures-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-preview" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vnp63aicm9vgapn4hm45ag9lrsf9f3bma3mzz3abbb708mcw79v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-executor-preview" ,rust-futures-executor-preview-0.3)
        ("rust-futures-io-preview" ,rust-futures-io-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3))
       #:cargo-development-inputs
       (("rust-futures-join-macro-preview"
         ,rust-futures-join-macro-preview-0.3))))
    (home-page "https://rust-lang-nursery.github.io/futures-rs")
    (synopsis "Implementation of futures and streams")
    (description
     "This package provides an implementation of futures and streams featuring
zero allocations, composability, and iterator-like interfaces.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-select-macro-preview-0.3
  (package
    (name "rust-futures-select-macro-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-select-macro-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xsq55cf2rnf7k6r04q8wynmxiy9svm3pi840vjva47bc0sy8anz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis
     "Handle the first Future to complete")
    (description
     "This package provides the @code{select!} macro for waiting on multiple
different @code{Future}s at once and handling the first one to complete.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-sink-0.3
  (package
    (name "rust-futures-sink")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-sink" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mj22d4w6digh7wfp6jkr5fdcl9r138q41fxzm1yg8mx568cdxfa"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Asynchronous @code{Sink} trait for the @code{futures-rs} library")
    (description "This package provides the asynchronous @code{Sink} trait for
the @code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-sink-preview-0.3
  (package
    (name "rust-futures-sink-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-sink-preview" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1v7y5qvgvl0d6hd9s4k7bd5qrj2gdlrs5yfl22v5pxv9dgpliwc6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3))))
    (home-page "https://rust-lang-nursery.github.io/futures-rs/")
    (synopsis  "Asynchronous `Sink` trait for the futures-rs library")
    (description
     "This package provides the asynchronous @code{Sink} trait for the
futures-rs library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-task-0.3
  (package
    (name "rust-futures-task")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11ldlpl7mis5crys731dj7s7npgigdgrzdm7mi2y86m8ivmhgphk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Tools for working with tasks")
    (description "This package provides tools for working with tasks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-test-0.3
  (package
    (name "rust-futures-test")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v9r2mmgdbm0x4gppd5jzf4rss7439ivkqwi604m0r2il3zap6ci"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Test components built off futures-rs")
    (description "This package provides common utilities for testing
components built off futures-rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-timer-3
  (package
    (name "rust-futures-timer")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b5v7lk9838ix6jdcrainsyrh7xrf24pwm61dp13907qkn806jz6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gloo-timers" ,rust-gloo-timers-0.2)
        ("rust-send-wrapper" ,rust-send-wrapper-0.4))))
    (home-page "https://github.com/async-rs/futures-timer")
    (synopsis "Timeouts for futures")
    (description "This package is a general purpose crate for working with
timeouts and delays with futures.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-timer-1
  (package
    (inherit rust-futures-timer-3)
    (name "rust-futures-timer")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0idyz2k72jbl9z0wj48n15wjv6qgxgsgvs6k8lrhkzr9jj728ikr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))))

(define-public rust-futures-timer-0.3
  (package
    (inherit rust-futures-timer-3)
    (name "rust-futures-timer")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0l35r7nm8p43j0adkhybnwxzbjiqy0b00kgccjy3l513m9abb7lg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-preview" ,rust-futures-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))))

(define-public rust-futures-timer-0.1
  (package
    (inherit rust-futures-timer-1)
    (name "rust-futures-timer")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hw0nlyrq5an6l6y8md1rg6r380zrddvmh9cg0h64xfwnvlxzkm5"))))
    (arguments
     `(#:cargo-inputs (("rust-futures" ,rust-futures-0.1))))))

(define-public rust-futures-util-0.3
  (package
    (name "rust-futures-util")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-util" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jv25s07igmqavigdfzr02yw6j1q0vg8pw2p2vmgvcx4yb88qak3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-macro" ,rust-futures-macro-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro-nested" ,rust-proc-macro-nested-0.1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis
     "Common utilities and extension traits for the @code{futures-rs} library")
    (description "This package provides common utilities and extension traits
for the @code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-util-preview-0.3
  (package
    (name "rust-futures-util-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-util-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "138f8wy0vqy2gsgk28kldbqnrdcgwfv9f9xx6rwzkr8p7iinisaw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-io-preview" ,rust-futures-io-preview-0.3)
        ("rust-futures-select-macro-preview"
         ,rust-futures-select-macro-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro-nested" ,rust-proc-macro-nested-0.1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-futures-join-macro-preview"
         ,rust-futures-join-macro-preview-0.3))))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis "Utilities and extension traits for futures-rs library")
    (description
     "This package provides common utilities and extension traits for the
futures-rs library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fuzzy-matcher-0.3
  (package
    (name "rust-fuzzy-matcher")
    (version "0.3.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuzzy-matcher" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "153csv8rsk2vxagb68kpmiknvdd3bzqj03x805khckck28rllqal"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-thread-local" ,rust-thread-local-1))
       #:cargo-development-inputs
       (("rust-termion" ,rust-termion-1))))
    (home-page "https://github.com/lotabout/fuzzy-matcher")
    (synopsis "Fuzzy Matching Library")
    (description "This package provides a fuzzy matching library in Rust.")
    (license license:expat)))

(define-public rust-fwdansi-1
  (package
    (name "rust-fwdansi")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fwdansi" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "027jz2x5fbi6rskic8sd6xx0mn03a7dnhwkpyz8hamg8gxwgbh88"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2)
        ("rust-termcolor" ,rust-termcolor-1))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-0.9))))
    (home-page "https://github.com/kennytm/fwdansi")
    (synopsis "ANSI escape codes to termcolor terminal library")
    (description "This library can be used to forward a byte string with ANSI
escape codes to a termcolor terminal.")
    (license license:expat)))

(define-public rust-fxhash-0.2
  (package
    (name "rust-fxhash")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fxhash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "037mb9ichariqi45xm6mz0b11pa92gj38ba0409z3iz239sns6y3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-seahash" ,rust-seahash-3))))
    (home-page "https://github.com/cbreeden/fxhash")
    (synopsis "Hashing algorithm from hasher used in FireFox and Rustc")
    (description
     "This package provides a fast, non-secure, hashing algorithm
derived from an internal hasher used in FireFox and Rustc.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-gag-0.1
  (package
    (name "rust-gag")
    (version "0.1.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gag" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d874gmyhyqbb78k6mkk9p0sd21n5vwd5w88m2nmzp3m6bsvkh4c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/Stebalien/gag-rs")
    (synopsis "Gag, redirect, or hold stdout/stderr output")
    (description
     "This package gags, redirects, or holds stdout/stderr output.")
    (license license:expat)))

(define-public rust-galil-seiferas-0.1
  (package
    (name "rust-galil-seiferas")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "galil-seiferas" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nhxks4qv1q6wrclxxbdch8k9h66i5ccdy3zn3913ym3zmfc4jkr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-defmac" ,rust-defmac-0.1)
        ("rust-unchecked-index" ,rust-unchecked-index-0.2))))
    (home-page "https://github.com/bluss/galil-seiferas")
    (synopsis "General string search in constant space, linear time")
    (description
     "This package provides general string search in constant space, linear
time, for nonorderable alphabets.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gcc-0.3
  (package
    (name "rust-gcc")
    (version "0.3.55")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gcc" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1hng1sajn4r67hndvhjysswz8niayjwvcj42zphpxzhbz89kjpwg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; gcc-test folder missing from release tarball.
       #:cargo-inputs
       (("rust-rayon" ,rust-rayon-0.8))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/alexcrichton/cc-rs")
    (synopsis "Library to compile C/C++ code into a Rust library/application")
    (description
     "This package provides a build-time dependency for Cargo build scripts to
assist in invoking the native C compiler to compile native C code into a static
archive to be linked into Rustcode.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-gdi32-sys-0.2
  (package
    (name "rust-gdi32-sys")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gdi32-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0605d4ngjsspghwjv4jicajich1gnl0aik9f880ajjzjixd524h9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.2)
        ("rust-winapi-build" ,rust-winapi-build-0.1))))
    (home-page "https://github.com/retep998/winapi-rs")
    (synopsis "Function definitions for the Windows API library gdi32")
    (description "This package contains function definitions for the Windows
API library @code{gdi32}.")
    (license license:expat)))

(define-public rust-generational-arena-0.2
  (package
    (name "rust-generational-arena")
    (version "0.2.8")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "generational-arena" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "00gn1g6nlky883qkacvsbp19yzl5ay8avq6f902jvxkl2mvkn7cf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/fitzgen/generational-arena")
    (synopsis "Safe arena allocator that supports deletion")
    (description
     "This package provides a safe arena allocator that supports deletion without
suffering from the ABA problem by using generational indices.")
    (license license:mpl2.0)))

(define-public rust-generator-0.7
  (package
    (name "rust-generator")
    (version "0.7.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "generator" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1iwfjhlf76fl50hanfvglzwaq60gm0fwqwd48x837a6fw6n4q66c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-windows" ,rust-windows-0.32))))
    (home-page "https://github.com/Xudong-Huang/generator-rs.git")
    (synopsis "Stackfull Generator Library in Rust")
    (description "This package provides a stackfull generator library in
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-generator-0.6
  (package
    (name "rust-generator")
    (version "0.6.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0f07mwkarwrqrykhkzqpvfnd5crz20dd8l24psn01kiqzc71dana"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-cc" ,rust-cc-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))
    (home-page "https://github.com/Xudong-Huang/generator-rs")
    (synopsis "Stackfull Generator Library in Rust")
    (description "Stackfull Generator Library in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-generic-array-0.14
  (package
    (name "rust-generic-array")
    (version "0.14.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "generic-array" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05qqwm9v5asbil9z28wjkmpfvs1c5c99n8n9gwxis3d3r3n6c52h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1)
        ("rust-version-check" ,rust-version-check-0.9))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/fizyk20/generic-array.git")
    (synopsis
     "Generic types implementing functionality of arrays")
    (description
     "Generic types implementing functionality of arrays.")
    (license license:expat)))

(define-public rust-generic-array-0.13
  (package
    (inherit rust-generic-array-0.14)
    (name "rust-generic-array")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02g3zhqc086zmsb6kcmjs2fiprz8gq12g0xbm9g23215ydxfd5zp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-generic-array-0.12
  (package
    (inherit rust-generic-array-0.13)
    (name "rust-generic-array")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1gfpay78vijl9vrwl1k9v7fbvbhkhcmnrk4kfg9l6x24y4s9zpzz"))))))

(define-public rust-generic-array-0.9
  (package
    (inherit rust-generic-array-0.14)
    (name "rust-generic-array")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17avshwh41d1w9p75mw2k6pflmbaj9ra7svxplmhqmv76xlca9gg"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))))))

(define-public rust-generic-array-0.8
  (package
    (inherit rust-generic-array-0.12)
    (name "rust-generic-array")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1wi6rlx3dmrvl26yxm4z5n68kyj2ikk4nllk1kazw2ik9scnkszw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nodrop" ,rust-nodrop-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-genmesh-0.6
  (package
    (name "rust-genmesh")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "genmesh" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17qybydyblf3hjiw7mq181jpi4vrbb8dmsj0wi347r8k0m354g89"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cgmath" ,rust-cgmath-0.16)
        ("rust-mint" ,rust-mint-0.5))))
    (home-page "https://github.com/gfx-rs/genmesh")
    (synopsis "Package for generating 3D meshes")
    (description
     "This package provides a package for generating 3D meshes/")
    (license license:asl2.0)))

(define-public rust-geo-0.4
  (package
    (name "rust-geo")
    (version "0.4.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "geo" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10mvrmi5xgpil6hxl6h3b0w4lvg7mxy04n3388ah0gwhcnc1whh3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/georust/geo")
    (synopsis "Geospatial primitives and algorithms")
    (description
     "This package provides geospatial primitives and algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-geo-types-0.7
  (package
    (name "rust-geo-types")
    (version "0.7.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "geo-types" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1fyj8ldl4xirhr8aawwiaslkklkzml2r5var87vqyp4zvnajxgfq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-approx" ,rust-approx-0.4)
        ("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rstar" ,rust-rstar-0.8)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.4))))
    (home-page "https://github.com/georust/geo")
    (synopsis "Geospatial primitive data types")
    (description "This package provides geospatial primitive data types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-geo-types-0.6
  (package
    (inherit rust-geo-types-0.7)
    (name "rust-geo-types")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "geo-types" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wivy6r2bzc32gxp5g5j689qz6p9ls5qgq0z8q64aayv3xd950vm"))))
    (arguments
     `(#:cargo-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rstar" ,rust-rstar-0.8)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3))))))

(define-public rust-get-if-addrs-0.5
  (package
    (name "rust-get-if-addrs")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "get_if_addrs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xsfxq3ga63vllw5k6pxpdlfp3m6fh8jiga865gr4cldi5dbbpdb"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("\\~1.1.0") "^1.1"))
           #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Tests use the network.
       #:cargo-inputs
       (("rust-c-linked-list" ,rust-c-linked-list-1)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-get-if-addrs-sys" ,rust-get-if-addrs-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.2))
       #:cargo-development-inputs
       (("rust-unwrap" ,rust-unwrap-1))))
    (home-page "https://maidsafe.net")
    (synopsis "Return interface IP addresses")
    (description "This library returns interface IP addresses.")
    (license (list license:expat license:bsd-3))))

(define-public rust-get-if-addrs-sys-0.1
  (package
    (name "rust-get-if-addrs-sys")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "get_if_addrs-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j5bypizbk59jhkaw1abkx7ydj79pplfvwq03hcnpwvcfkxzj10d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-gcc" ,rust-gcc-0.3)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/maidsafe-archive/get_if_addrs")
    (synopsis "Retrieve IP addresses for all interfaces")
    (description "This library retrieves network interface info for all
interfaces on the system.")
    (license (list license:expat license:bsd-3))))

(define-public rust-gethostname-0.2
  (package
    (name "rust-gethostname")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gethostname" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a609j9dhk816il2f2a01avvi5sqzxh0p38nxwrja7dcpybf54p6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ; test panics
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))
    (home-page "https://github.com/lunaryorn/gethostname.rs")
    (synopsis "Gethostname for all platforms")
    (description "This library provides @code{gethostname()} for all
platforms.")
    (license license:asl2.0)))

(define-public rust-getopts-0.2
  (package
    (name "rust-getopts")
    (version "0.2.21")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "getopts" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1mgb3qvivi26gs6ihqqhh8iyhp3vgxri6vwyrwg28w0xqzavznql"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-rustc-std-workspace-std" ,rust-rustc-std-workspace-std-1))
       #:cargo-development-inputs
       (("rust-log" ,rust-log-0.3))))
    (home-page "https://github.com/rust-lang/getopts")
    (synopsis "Rust library for option parsing for CLI utilities")
    (description "This library provides getopts-like option parsing.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-getrandom-0.2
  (package
    (name "rust-getrandom")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getrandom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x3clmvj5k2h9qv3ihbyif1rns3pf5y5n66f5jjyc5zr6v7jb07f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-stdweb" ,rust-stdweb-0.4)
        ("rust-wasi" ,rust-wasi-0.9)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/rust-random/getrandom")
    (synopsis "Retrieve random data from system source")
    (description
     "This package provides a small cross-platform library for
retrieving random data from system source.")
    (license (list license:expat license:asl2.0))))

(define-public rust-getrandom-0.1
  (package
    (inherit rust-getrandom-0.2)
    (name "rust-getrandom")
    (version "0.1.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getrandom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1sq30li71h19rhnhs1h6576ja68insajx8wvh1nn088r8pc8vg3s"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-stdweb" ,rust-stdweb-0.4)
        ("rust-wasi" ,rust-wasi-0.9)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))))

(define-public rust-getset-0.1
  (package
    (name "rust-getset")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "016590lxhlqga016z1qnavl0zavk59b97aix2zcd4wad3b02icr4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/Hoverbear/getset")
    (synopsis "Getters and setters for Rust")
    (description
     "This package provides a procedural macro for generating the most basic
getters and setters on fields.")
    (license license:expat)))

(define-public rust-getset-0.0.9
  (package
    (name "rust-getset")
    (version "0.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0aaldwfs2690rjqg2ygan27l2qa614w2p6zj7k99n36pv2vzbcsv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/Hoverbear/getset")
    (synopsis "Getters and setters for Rust")
    (description
     "This package provides a procedural macro for generating the most basic
getters and setters on fields.")
    (license license:expat)))

(define-public rust-gettext-rs-0.7
  (package
    (name "rust-gettext-rs")
    (version "0.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gettext-rs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0r7kahqcjrkm83d3gzzkn83fnw2bnqj2ank5z6hsm66izalai7p4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-gettext-sys" ,rust-gettext-sys-0.21)
        ("rust-locale-config" ,rust-locale-config-0.3))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))
    (inputs
     `(("gettext" ,gettext-minimal)))
    (home-page "https://github.com/Koka/gettext-rs")
    (synopsis "GNU Gettext FFI binding for Rust")
    (description "This package provides GNU Gettext FFI bindings for Rust.")
    (license license:expat)))

(define-public rust-gettext-sys-0.21
  (package
    (name "rust-gettext-sys")
    (version "0.21.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gettext-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "105d5zh67yc5vyzmqxdw7hx82h606ca6rzhsfjgzjczn2s012pc8"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file "gettext-0.21.tar.xz") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (inputs
     `(("gettext" ,gettext-minimal)))
    (home-page "https://github.com/Koka/gettext-rs")
    (synopsis "Gettext raw FFI bindings")
    (description "This package provides raw FFI bindings for GNU Gettext.")
    (license license:expat)))

(define-public rust-gettext-sys-0.19
  (package
    (inherit rust-gettext-sys-0.21)
    (name "rust-gettext-sys")
    (version "0.19.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gettext-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0lzi6ja81vc16mhcdmn3lw35120n9ijhvsy5dh5775mpbfxc8d70"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file "gettext-0.19.8.1.tar.xz") #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1))))))

(define-public rust-gfa-0.10
  (package
    (name "rust-gfa")
    (version "0.10.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gfa" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1x996rpfnflgi2j4dgaj5sdxdbf24zfm9d2ha0zy8aid0cd60cln"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-bytemuck" ,rust-bytemuck-1)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-nom" ,rust-nom-5)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/chfi/rs-gfa")
    (synopsis "Library for graphs in the GFA (Graphical Fragment Assembly) format")
    (description
     "This package provides a library for working with graphs in the
@acronym{GFA, Graphical Fragment Assembly} format.")
    (license license:expat)))

(define-public rust-ghash-0.3
  (package
    (name "rust-ghash")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ghash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c957q9sk1q93pqqfvhcmflfm1zvbr14aznfpm25kqd6i437zqnn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-polyval" ,rust-polyval-0.4)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.1))))
    (home-page "https://github.com/RustCrypto/universal-hashes")
    (synopsis "Universal hash over GF(2^128)")
    (description "This package provides a universal hash over GF(2^128) useful
for constructing a Message Authentication Code (MAC), as in the AES-GCM
authenticated encryption cipher.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ghash-0.2
  (package
    (inherit rust-ghash-0.3)
    (name "rust-ghash")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ghash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lijv1y6qcysnxv45ny5fjvc4v9gmpggxlj6xa4l065737nk02cz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-polyval" ,rust-polyval-0.3)
        ("rust-zeroize" ,rust-zeroize-1))))))

(define-public rust-ghost-0.1
  (package
    (name "rust-ghost")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ghost" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fj42hmlgcj1rbqcshlvk65npsks4ba7vdzphb9202gawf6zw6gb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/dtolnay/ghost")
    (synopsis "Define your own PhantomData")
    (description
     "This package makes it possible to define your own PhantomData and
similarly behaved unit types with generic parameters, which is not
permitted in ordinary Rust.")
    ;; Either license can be chosen at the users option.
    (license (list license:expat license:asl2.0))))

(define-public rust-gif-0.11
  (package
    (name "rust-gif")
    (version "0.11.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gif" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1pnqfg0k84v0cnqyf85jqvwy3jcs580bfjaps5rzbl3kk5lqyrjs"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-color-quant" ,rust-color-quant-1)
         ("rust-weezl" ,rust-weezl-0.1))))
    (home-page "https://github.com/image-rs/image-gif")
    (synopsis "GIF de- and encoder")
    (description "This crate provides a GIF de- and encoder.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gimli-0.26
  (package
    (name "rust-gimli")
    (version "0.26.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "gimli" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0pafbk64rznibgnvfidhm1pqxd14a5s9m50yvsgnbv38b8n0w0r2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))
       #:cargo-development-inputs
       (("rust-byteorder" ,rust-byteorder-0.5)
        ("rust-crossbeam" ,rust-crossbeam-0.8)
        ("rust-getopts" ,rust-getopts-0.2)
        ("rust-memmap2" ,rust-memmap2-0.5)
        ("rust-object" ,rust-object-0.29)
        ("rust-test-assembler" ,rust-test-assembler-0.1)
        ("rust-typed-arena" ,rust-typed-arena-2))))
    (home-page "https://github.com/gimli-rs/gimli")
    (synopsis "Library for reading and writing the DWARF debugging format")
    (description
     "This package provides a library for reading and writing the DWARF
debugging format.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-gimli-0.23
  (package
    (inherit rust-gimli-0.26)
    (name "rust-gimli")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gimli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1km657nwcrb0pnv7v0ldhgl9y8s889y2j9jckmws8k2i8bhkyl7n"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))))

(define-public rust-git-version-0.3
  (package
    (name "rust-git-version")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git-version" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qj1rd19v8vg094b3fj0gy6ca53v93lhrl31wg1fs7g0y61qx4cl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-git-version-macro" ,rust-git-version-macro-0.3)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/fusion-engineering/rust-git-version")
    (synopsis "Embed git information in your code at compile-time")
    (description
     "This crates compiles the git version (tag name, or hash otherwise) and
dirty state into your program.")
    (license license:bsd-2)))

(define-public rust-git-version-macro-0.3
  (package
    (name "rust-git-version-macro")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git-version-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mynlf8sfaa4xx7qff0qgnr339fbf1svgr569yip067fzm97ma9l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/fusion-engineering/rust-git-version")
    (synopsis "Internal macro crate for git-version")
    (description
     "This is an internal macro crate for git-version.")
    (license license:bsd-2)))

(define-public rust-git2-0.15
  (package
    (name "rust-git2")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lf7yxgrbglx5qqvk033n44ymmrg72z271911jwix9d6lgjbx519"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.14)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-1)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-time" ,rust-time-0.1))))
    (native-inputs
     `(("pkg-config" ,pkg-config)
       ("git" ,git-minimal)))           ;for a single test
    (inputs
     (list libgit2 libssh2 openssl zlib))
    (home-page "https://github.com/rust-lang/git2-rs")
    (synopsis "Rust bindings to libgit2")
    (description
     "This package provides bindings to libgit2 for interoperating with git
repositories.  This library is both threadsafe and memory safe and allows both
reading and writing git repositories.")
    (license (list license:expat license:asl2.0))))

(define-public rust-git2-0.14
  (package
    (inherit rust-git2-0.15)
    (name "rust-git2")
    (version "0.14.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "074kqlmh7q39pqcj9rmrnmx4v5njh2j09dfxc1hsh45pm835a5fh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.13)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-1)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-git2-0.13
  (package
    (inherit rust-git2-0.15)
    (name "rust-git2")
    (version "0.13.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07rlxwvl5iyyqwh0mci5v27lbicf9qiqm60maw1srz7i51x00pl4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.12)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-1)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-time" ,rust-time-0.1))))
    (inputs
     (list libgit2-1.3 libssh2 openssl zlib))))

(define-public rust-git2-0.11
  (package
    (inherit rust-git2-0.13)
    (name "rust-git2")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i0fgsr91r97hsjbgqnymkcyiyg0057m7m04116k3vmyqpvrwlbp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.10)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-docopt" ,rust-docopt-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-git2-0.9
  (package
    (inherit rust-git2-0.11)
    (name "rust-git2")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cayf5w7wkvclvs8brbi7lyfxbdklwls9s49mpf2brl655yjwjwj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-1))
       #:cargo-development-inputs
       (("rust-docopt" ,rust-docopt-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-git2-0.6
  (package
    (inherit rust-git2-0.11)
    (name "rust-git2-6")
    (version "0.6.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "115ys6vlfjy5pcwkip0wfzi4q3d1kimbl9isxvjyci1arnvlnnzf"))))
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-0.9)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.6)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-1))
       #:cargo-development-inputs
       (("rust-docopt" ,rust-docopt-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-time" ,rust-time-0.1))))
    (inputs
     (modify-inputs (package-inputs rust-git2-0.11)
       (prepend curl)))))

(define-public rust-git2-curl-0.14
  (package
    (name "rust-git2-curl")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2-curl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l1sckmpvhd498c9ji04gkpfkfrpx7c8rabihczsnjx91v5kjdc8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t                 ;need rust-civet and others
       #:cargo-inputs
       (("rust-curl" ,rust-curl-0.4)
        ("rust-git2" ,rust-git2-0.13)
        ("rust-log" ,rust-log-0.4)
        ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/rust-lang/git2-rs")
    (synopsis "Libgit2 HTTP transport backend powered by @code{libcurl}")
    (description "Backend for an HTTP transport in @code{libgit2}, powered by
libcurl, which is intended to be used with the @code{git2} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gjson-0.8
  (package
    (name "rust-gjson")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gjson" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "164nwjx81j8cnnvi63h0dcxdc9ib3s0k9wx15l72hxp4vklx16a5"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/tidwall/gjson.rs")
    (synopsis "JSON parser for Rust")
    (description "Gjson is a JSON parser for Rust.")
    (license license:expat)))

(define-public rust-glam-0.17
  (package
    (name "rust-glam")
    (version "0.17.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xm7jdygbxchdvk6k1l1pdag843nkwdm8fikwgp0i1gxgawk45z0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-approx" ,rust-approx-0.5)
        ("rust-bytemuck" ,rust-bytemuck-1.5)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/bitshifter/glam-rs")
    (synopsis "3D math library for games and graphics")
    (description
     "This package provides a simple and fast 3D math library for games and
graphics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-glam-0.16
  (package
    (name "rust-glam")
    (version "0.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05izbgx93hnjk200144h9yxhy51cbygp2bbaqdj8czngki3w09j1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t  ; TODO: we need a more recent criterion
       #:cargo-inputs
       (("rust-approx" ,rust-approx-0.4)
        ("rust-bytemuck" ,rust-bytemuck-1.5)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/bitshifter/glam-rs")
    (synopsis "3D math library for games and graphics")
    (description
     "This package provides a simple and fast 3D math library for games and
graphics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-glam-0.15
  (package
    (name "rust-glam")
    (version "0.15.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jx587lxz9v9m0ph4dlshfgy0abax1zhlbjj5nvkchz4ir7mbfrs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t  ; TODO: we need a more recent criterion
       #:cargo-inputs
       (("rust-bytemuck" ,rust-bytemuck-1.5)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-spirv-std" ,rust-spirv-std-0.4))))
    (home-page "https://github.com/bitshifter/glam-rs")
    (synopsis "3D math library for games and graphics")
    (description
     "This package provides a simple and fast 3D math library for games and
graphics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-glam-0.14
  (package
    (name "rust-glam")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1njk0cskaspc62ywxlzpiszbcb9hhh1yqg2ka105sg0hxgajhf9k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytemuck" ,rust-bytemuck-1.5)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-spirv-std" ,rust-spirv-std-0.4))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.6)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/bitshifter/glam-rs")
    (synopsis "3D math library for games and graphics")
    (description
     "This package provides a simple and fast 3D math library for games and
graphics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-glam-0.13
  (package
    (name "rust-glam")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ps7f44844ydj7cjr7wk1hn2d83ds1ilq7p9b2vvhr0711b5n5bh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytemuck" ,rust-bytemuck-1.5)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-spirv-std" ,rust-spirv-std-0.4))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/bitshifter/glam-rs")
    (synopsis "3D math library for games and graphics")
    (description
     "This package provides a simple and fast 3D math library for games and
graphics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-glium-0.31
  (package
    (name "rust-glium")
    (version "0.31.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glium" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06cfsq3mgjlq3bnxv7jh5bb5is7040xyvf8cf1x45vnq8fdz1d0a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;XXX circular dependencies
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-glutin" ,rust-glutin-0.28)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memoffset" ,rust-memoffset-0.6)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-takeable-option" ,rust-takeable-option-0.5))
       #:cargo-development-inputs
       (("rust-cgmath" ,rust-cgmath-0.18)
        ("rust-genmesh" ,rust-genmesh-0.6)
        ("rust-gl-generator" ,rust-gl-generator-0.14)
        ("rust-obj" ,rust-obj-0.10)
        ("rust-ouroboros" ,rust-ouroboros-0.14))))
    (home-page "https://github.com/glium/glium")
    (synopsis "OpenGL wrapper")
    (description
     "Glium is an intermediate layer between OpenGL and your application.  You
still need to manually handle the graphics pipeline, but without having to use
OpenGL's old and error-prone API.")
    (license license:asl2.0)))

(define-public rust-glium-0.25
  (package
    (inherit rust-glium-0.31)
    (name "rust-glium")
    (version "0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glium" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mhjly07x10lxg802ppg16wbxddhh4fdnlg10i99qwpfamvqhzbd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-glutin" ,rust-glutin-0.21)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-takeable-option" ,rust-takeable-option-0.4))
       #:cargo-development-inputs
       (("rust-cgmath" ,rust-cgmath-0.17)
        ("rust-genmesh" ,rust-genmesh-0.6)
        ("rust-gl-generator" ,rust-gl-generator-0.11)
        ("rust-image" ,rust-image-0.21)
        ("rust-obj" ,rust-obj-0.9)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-glob-0.3
  (package
    (name "rust-glob")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "glob" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x25wfr7vg3mzxc9x05dcphvd3nwlcmbnxrvwcvrrdwplcrrk4cv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/rust-lang-nursery/glob")
    (synopsis "Match file paths against Unix shell style patterns")
    (description
     "This package provides support for matching file paths against Unix
shell style patterns.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-glob-0.2
  (package
    (inherit rust-glob-0.3)
    (name "rust-glob")
    (version "0.2.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "glob" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ysvi72slkw784fcsymgj4308c3y03gwjjzqxp80xdjnkbh8vqcb"))))))

(define-public rust-globset-0.4
  (package
    (name "rust-globset")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "globset" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ca96s29s7aqpkm04z4babyk8xqn1w7slpdrlldgnkz6l2gipz7h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aho-corasick" ,rust-aho-corasick-0.7)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/BurntSushi/ripgrep/tree/master/globset")
    (synopsis "Single glob and glob set matching")
    (description
     "This crate provides glob and glob set matching.  Glob set matching is
the process of matching one or more glob patterns against a single candidate
path simultaneously, and returning all of the globs that matched.")
    (license (list license:expat license:unlicense))))

(define-public rust-globwalk-0.8
  (package
    (name "rust-globwalk")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "globwalk" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k6xwkydr7igvwjn3xkwjywk4213lcs53f576ilqz1h84jaazqwk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-ignore" ,rust-ignore-0.4)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-backtrace" ,rust-backtrace-0.3.35)
        ("rust-docmatic" ,rust-docmatic-0.1)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/gilnaa/globwalk")
    (synopsis "Glob-matched recursive file system walking")
    (description "This package provides glob-matched recursive file system
walking.  Based on both @code{rust-walkdir} and @code{rust-ignore}, this crate
inherits many goodies from both, such as limiting search depth and amount of
open file descriptors.")
    (license license:expat)))

(define-public rust-gloo-timers-0.2
  (package
    (name "rust-gloo-timers")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gloo-timers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07w999jm1r1i8r574qbmsa3l4w3gxhyx04cbllg0m4pzm934l827"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/rustwasm/gloo")
    (synopsis "Convenience crate for working with JavaScript timers")
    (description
     "This package is a convenience crate for working with JavaScript
timers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gmp-mpfr-sys-1
  (package
    (name "rust-gmp-mpfr-sys")
    (version "1.4.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gmp-mpfr-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1ysvdf352vcnb5ygmbwf5pkndqb0p6clmz0nqkf3nmz9ghssfim1"))))
    (build-system cargo-build-system)
    (arguments
      `(#:phases
        (modify-phases %standard-phases
          (add-after 'unpack 'set-shell-for-configure-script
            (lambda _
              (setenv "CONFIG_SHELL" (which "sh")))))
       #:cargo-inputs
        (("rust-libc" ,rust-libc-0.2)
         ("rust-winapi" ,rust-winapi-0.3))))
    (native-inputs
     (list bash-minimal m4))
    (home-page "https://gitlab.com/tspiteri/gmp-mpfr-sys")
    (synopsis "Rust FFI bindings for GMP, MPFR, and MPC")
    (description "This package provides Rust FFI bindings for the numeric
libraries GMP, MPFR, and MPC.")
    (license license:lgpl3+)))

(define-public rust-goblin-0.2
  (package
    (name "rust-goblin")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "goblin" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1j38fkqadbsjxawr3wnj9m0qaihcwp6pmfakmhsar881509y7mfx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-scroll" ,rust-scroll-0.10)
        ("rust-plain" ,rust-plain-0.2)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/m4b/goblin")
    (synopsis "ELF, Mach-o, and PE binary parsing and loading crate")
    (description "This package provides an ELF, Mach-o, and PE binary parsing
and loading crate.")
    (license license:expat)))

(define-public rust-goblin-0.0
  (package
    (name "rust-goblin")
    (version "0.0.23")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "goblin" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g92bl76dgc3v3rins61l811pkwsl3jif1x35h2jx33b7dsv8mmc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-plain" ,rust-plain-0.2)
        ("rust-scroll" ,rust-scroll-0.9))))
    (home-page "https://github.com/m4b/goblin")
    (synopsis "Binary parsing and loading")
    (description
     "An impish, cross-platform, ELF, Mach-o, and PE binary parsing and
loading crate.")
    (license license:expat)))

(define-public rust-greetd-ipc-0.8
  (package
    (name "rust-greetd-ipc")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "greetd-ipc" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1dscriv3adjyaxfaax3cmqrzx6q2vwwchbh86dhll783wjc4ivw0"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs
           `(("rust-async-trait" ,rust-async-trait-0.1)
             ("rust-serde" ,rust-serde-1)
             ("rust-serde-json" ,rust-serde-json-1)
             ("rust-thiserror" ,rust-thiserror-1)
             ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://kl.wtf/projects/greetd")
    (synopsis "@command{greetd} IPC protocol library for Rust")
    (description
     "This package provides library that helps you use the
@command{greetd} JSON-based IPC protocol from Rust.")
    (license license:gpl3)))

(define-public rust-grep-0.2
  (package
    (name "rust-grep")
    (version "0.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mw61v132ng0nbz5ygb6jvsx729772803w5bv3zs4i8baq689jsi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-grep-cli" ,rust-grep-cli-0.1)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-grep-pcre2" ,rust-grep-pcre2-0.1)
        ("rust-grep-printer" ,rust-grep-printer-0.1)
        ("rust-grep-regex" ,rust-grep-regex-0.1)
        ("rust-grep-searcher" ,rust-grep-searcher-0.1))
       #:cargo-development-inputs
       (("rust-termcolor" ,rust-termcolor-1)
        ("rust-walkdir" ,rust-walkdir-2))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Line oriented regex searching as a library")
    (description
     "Fast line oriented regex searching as a library.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-cli-0.1
  (package
    (name "rust-grep-cli")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-cli" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12lyww4hl4cham9zqqssm3wcp1g3ffvi6906wl6hsiml9g1i1l9d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-same-file" ,rust-same-file-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Utilities for search oriented command line applications")
    (description
     "This crate provides utilities for search oriented command line
applications.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-matcher-0.1
  (package
    (name "rust-grep-matcher")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-matcher" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1k618qni7bgx9mvdp1kaznqjvn2gpgiasrmi0cqd6b066cy5c9vd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Trait for regular expressions")
    (description
     "This crate provides a low level interface for describing regular
expression matchers.  The @code{grep} crate uses this interface in order to make
the regex engine it uses pluggable.")
    (license (list license:expat license:unlicense))))

(define-public rust-grep-pcre2-0.1
  (package
    (name "rust-grep-pcre2")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-pcre2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hfyxsavqzf4rb5vc2a4hhi8dqw75vw1h95hinp4km9b6yxyvv66"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-pcre2" ,rust-pcre2-0.2))))
    (native-inputs
     (list pcre2 pkg-config))
    (home-page
     "https://github.com/BurntSushi/ripgrep")
    (synopsis "Use PCRE2 with the grep crate")
    (description "Use PCRE2 with the grep crate.")
    (license (list license:expat license:unlicense))))

(define-public rust-grep-printer-0.1
  (package
    (name "rust-grep-printer")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-printer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wnw8khcvris8canv1dp58qh6vph18fml9qsnrsmdpxf9ni73hh5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-grep-searcher" ,rust-grep-searcher-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-termcolor" ,rust-termcolor-1))
       #:cargo-development-inputs
       (("rust-grep-regex" ,rust-grep-regex-0.1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Standard printing of search results")
    (description
     "This package is an implementation of the grep crate's Sink trait that
provides standard printing of search results, similar to grep itself.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-regex-0.1
  (package
    (name "rust-grep-regex")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-regex" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "01mx4xsrfp5hf8dpnvld1svs6i5dpg6xghigp4wkhdlcfv4m658j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aho-corasick" ,rust-aho-corasick-0.7)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-regex-syntax" ,rust-regex-syntax-0.6)
        ("rust-thread-local" ,rust-thread-local-1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Use Rust's regex library with the grep crate")
    (description
     "Use Rust's regex library with the grep crate.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-searcher-0.1
  (package
    (name "rust-grep-searcher")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-searcher" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0gf2qkkfsywvzrqvfx6h88qzb68zmnvggvid1ljdqam51glvvgbz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-encoding-rs-io" ,rust-encoding-rs-io-0.1)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memmap" ,rust-memmap2-0.3))
       #:cargo-development-inputs
       (("rust-grep-regex" ,rust-grep-regex-0.1)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Line oriented regex searching as a library")
    (description
     "Fast line oriented regex searching as a library.")
    (license (list license:unlicense license:expat))))

(define-public rust-groupable-0.2
  (package
    (name "rust-groupable")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "groupable" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0msfvg8xw4bqi7y7xdkm8nvjjllznc10dnzkx8wnjr5yp119jq9j"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/ryman/groupable-rs")
    (synopsis "Easily aggregate groups of values from key-value iterators")
    (description
     "This package aggregates groups of values from key-value iterators.")
    (license license:expat)))

(define-public rust-gumdrop-0.8
  (package
    (name "rust-gumdrop")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "gumdrop" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "02waas37nr8y669lnm1ifp6bkx79v3bd0bd4s9qcyy04aifiyms6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gumdrop-derive" ,rust-gumdrop-derive-0.8))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1))))
    (home-page "https://github.com/murarth/gumdrop")
    (synopsis "Option parser with custom derive support")
    (description "This package provides option parser with custom derive
support.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gumdrop-derive-0.8
  (package
    (name "rust-gumdrop-derive")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "gumdrop_derive" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "01cdc7w5wf1g9i04ykcssczjmmnl6jky47a648sp710df5yg0pli"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/murarth/gumdrop")
    (synopsis "Custom derive support for gumdrop")
    (description "This package provides custom derive support for gumdrop.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gzip-header-1
  (package
    (name "rust-gzip-header")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gzip-header" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18lm2y96mahkmcd76pzyam2sl3v6lsl9mn8ajri9l0p6j9xm5k4m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crc32fast" ,rust-crc32fast-1))))
    (home-page "https://github.com/oyvindln/gzip-header")
    (synopsis "Decoding and encoding the header part of gzip files")
    (description
     "This package provides a crate for decoding and encoding the header part
of gzip files based on the gzip header implementation in the @code{flate2} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gzip-header-0.3
  (package
    (inherit rust-gzip-header-1)
    (name "rust-gzip-header")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gzip-header" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fg6vm8sgsm69szwqyz7abfbyziv6pv0jkcailimlamvsfrzwc81"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crc32fast" ,rust-crc32fast-1))))))

(define-public rust-h2-0.3
  (package
    (name "rust-h2")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "h2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mdf0x3cxj4rhx2zrm0gnx02i43gqcz3q4awzidargff5xb1kn3z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-util" ,rust-tokio-util-0.6)
        ("rust-tracing" ,rust-tracing-0.1))))
    (home-page "https://github.com/hyperium/h2")
    (synopsis "HTTP/2.0 client and server")
    (description "This package provides an HTTP/2.0 client and server.")
    (license license:expat)))

(define-public rust-h2-0.2
  (package
    (inherit rust-h2-0.3)
    (name "rust-h2")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "h2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lvdrzn43iikl521dlrb7z96lsmy7l6nnm35ylf00q7dmq5rwgwr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3)
        ("rust-tracing" ,rust-tracing-0.1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-hex" ,rust-hex-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-walkdir" ,rust-walkdir-1)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))))))

(define-public rust-h2-0.1
  (package
    (inherit rust-h2-0.2)
    (name "rust-h2")
    (version "0.1.26")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "h2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qn457y8xh03p7c7cpk76r22gqpyqxc58g5022j3iya7d0j4rcx5"))))
    (arguments
     `(#:skip-build? #t ;; TODO missing indirect dependency
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-string" ,rust-string-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-hex" ,rust-hex-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-rand" ,rust-rand-0.3)
        ;;("rust-rustls" ,rust-rustls-0.12) requires 0.5
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-walkdir" ,rust-walkdir-1)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))))))

(define-public rust-half-1
  (package
    (name "rust-half")
    (version "1.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "half" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wzavaaaa2jwkm4i1dbglmwjfsdhn4n73wrkbdzllaynlams5b32"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-quickcheck-macros" ,rust-quickcheck-macros-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/starkat99/half-rs")
    (synopsis "Half-precision floating point f16 type")
    (description
     "Half-precision floating point f16 type for Rust implementing the
IEEE 754-2008 binary16 type.")
    (license (list license:expat license:asl2.0))))

(define-public rust-home-0.5
  (package
    (name "rust-home")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "home" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0m3nfcksrj784liji1c5j47dymxw2l7hqy5fj90piadnwvrawmi4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/brson/home")
    (synopsis "Shared definitions of home directories")
    (description "This package provides the definition of @code{home_dir}
used by @command{cargo} and @command{rustup}, as well as functions to find the
correct value of @samp{CARGO_HOME} and @samp{RUSTUP_HOME}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hamcrest2-0.3
  (package
    (name "rust-hamcrest2")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hamcrest2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x8hx7jyzz2bl0wf6nir62imd26yhp6qcr7zf76cjpg05p33gy29"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num" ,rust-num-0.2)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/Valloric/hamcrest2-rust")
    (synopsis "Rust port of the Hamcrest testing library")
    (description
     "This package provides a port of the Hamcrest testing library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hash-hasher-2
  (package
    (name "rust-hash-hasher")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hash_hasher" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "034cd4m3znwff3cd1i54c40944y999jz086d70rwpl0jfl01swkl"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/Fraser999/Hash-Hasher.git")
    (synopsis "Hasher designed to work with already-hashed or hash-like data")
    (description
     "This package provides a hasher which is designed to work with
already-hashed or hash-like data.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hash32-0.2
  (package
    (name "rust-hash32")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hash32" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rrbv5pc5b1vax6j6hk7zvlrpw0h6aybshxy9vbpgsrgfrc5zhxh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))))
    (home-page "https://github.com/japaric/hash32")
    (synopsis "32-bit hashing machinery")
    (description "This package provides 32-bit hashing machinery.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hash32-0.1
  (package
    (inherit rust-hash32-0.2)
    (name "rust-hash32")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hash32" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k7lv7hsbzv14pz90cxay6v7avh6d6kcrra0rsc45b33dvw1l16l"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-hash32-derive" ,rust-hash32-derive-0.1))))))

(define-public rust-hash32-derive-0.1
  (package
    (name "rust-hash32-derive")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hash32-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18lrlxycq45kaz0l688shxnhgh3ryjp3zn0n6vfcs5sa2nyyzh7b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.3)
        ("rust-quote" ,rust-quote-0.5)
        ("rust-syn" ,rust-syn-0.13))))
    (home-page "https://github.com/japaric/hash32")
    (synopsis "Macros 1.1 implementation of @code{#[derive(Hash32)]}")
    (description "This package provides a macros 1.1 implementation of
@code{#[derive(Hash32)]}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hashbrown-0.12
  (package
    (name "rust-hashbrown")
    (version "0.12.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "hashbrown" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1268ka4750pyg2pbgsr43f0289l5zah4arir2k4igx5a8c6fg7la"))
              (modules '((guix build utils)))
              (snippet
               ;; Without this line users of hashbrown would be unable to
               ;; parse the contents of the Cargo.toml.
               '(substitute* "Cargo.toml"
                  (("\\[package\\]" m)
                   (string-append "cargo-features = [\"edition2021\"]\n" m))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.7)
        ("rust-bumpalo" ,rust-bumpalo-3)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/rust-lang/hashbrown")
    (synopsis "Rust port of Google's SwissTable hash map")
    (description
     "This package provides a Rust port of Google's SwissTable hash map")
    (license (list license:expat license:asl2.0))))

(define-public rust-hashbrown-0.11
  (package
    (name "rust-hashbrown")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vkjsf5nzs7qcia5ya79j9sq2p1caz4crrncr1675wwyj3ag0pmb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.7)
        ("rust-bumpalo" ,rust-bumpalo-3)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/rust-lang/hashbrown")
    (synopsis "Rust port of Google's SwissTable hash map")
    (description "This package provides a Rust port of Google's SwissTable
hash map.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hashbrown-0.9
  (package
    (inherit rust-hashbrown-0.11)
    (name "rust-hashbrown")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "016dsm9s4xmxlkw2jfikm54qlz6vyk0qr280gab7kzp342jf9byp"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.4)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashbrown-0.8
  (package
    (inherit rust-hashbrown-0.9)
    (name "rust-hashbrown")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09y86zmf59n6ys9yf2bvg9ckwwa1ijv2i3flkz45iqkwfmh7i6xb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.3)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashbrown-0.6
  (package
    (inherit rust-hashbrown-0.9)
    (name "rust-hashbrown")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bbf9k46v57zi41m6hjwn83rjldyipv5zwxmdsa7a9c1rb876q4f"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.2)
        ("rust-autocfg" ,rust-autocfg-0.1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashbrown-0.5
  (package
    (inherit rust-hashbrown-0.8)
    (name "rust-hashbrown")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lr3gsicplw7czapsscmii87hgzpvxf5ch92v7pi95xsipxl3pp1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashbrown-0.3
  (package
    (inherit rust-hashbrown-0.8)
    (name "rust-hashbrown")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "063fy36q5796kd836sc5dgcc58bkgr7sw1hczmnmhbblwjmskyr9"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))))))

(define-public rust-hashbrown-0.1
  (package
    (inherit rust-hashbrown-0.5)
    (name "rust-hashbrown")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1np350nrzysy021ndn2135q5vpzrp5nli78ywz114d1vcnv2kbiv"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("~1.2") "1.2"))
           #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-scopeguard" ,rust-scopeguard-0.3)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashlink-0.7
  (package
    (name "rust-hashlink")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashlink" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kzs54xq1g41zph39cfdfchiafij99382zw5fk6zq7xwkh9a6jbj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hashbrown" ,rust-hashbrown-0.11)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://crates.io/crates/hashlink")
    (synopsis "HashMap-like containers with user controllable order")
    (description "This package provides HashMap-like containers that hold
their key-value pairs in a user controllable order.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hashlink-0.6
  (package
    (inherit rust-hashlink-0.7)
    (name "rust-hashlink")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashlink" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a2gi4737lmqq1i48b9w13gvbkh4g3gc7gj6d3974hywy21gg76r"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hashbrown" ,rust-hashbrown-0.9)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hdrhistogram-6
  (package
    (name "rust-hdrhistogram")
    (version "6.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hdrhistogram" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17dqk0rp8kimcd8wr542i8cny91fkclw7a2xzszar95wrpmk3lq8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.3)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-nom" ,rust-nom-4)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/HdrHistogram/HdrHistogram_rust")
    (synopsis "Port of HdrHistogram to Rust")
    (description "This package provides a port of HdrHistogram to Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-headers-0.3
  (package
    (name "rust-headers")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hyafm9q5havnbljfdzpkb7wrpx11ayzqzv02abycmklgk2rss32"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-headers-core" ,rust-headers-core-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-sha-1" ,rust-sha-1-0.8)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://hyper.rs")
    (synopsis "Typed HTTP headers")
    (description "This package provides typed HTTP headers.")
    (license license:expat)))

(define-public rust-headers-0.2
  (package
    (inherit rust-headers-0.3)
    (name "rust-headers")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hmnrra00cjqpsn05klnr9cysrv2bm19akxl5lncwcrgfbcafb48"))))
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-headers-core" ,rust-headers-core-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-sha-1" ,rust-sha-1-0.8)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-headers-core-0.2
  (package
    (name "rust-headers-core")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ab469xfpd411mc3dhmjhmzrhqikzyj8a17jn5bkj9zfpy0n9xp7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-http" ,rust-http-0.2))))
    (home-page "https://hyper.rs")
    (synopsis "Typed HTTP headers core trait")
    (description "This package provides typed HTTP headers core trait.")
    (license license:expat)))

(define-public rust-headers-core-0.1
  (package
    (inherit rust-headers-core-0.2)
    (name "rust-headers-core")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ds20kg0igncs2r0jrcf26mq72k3j6ilanr0qwh7r7xak8kk2wcn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-http" ,rust-http-0.1))))))

(define-public rust-heapless-0.7
  (package
    (name "rust-heapless")
    (version "0.7.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heapless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lnrbzf1cpxg3n5s00lyi1gal2ajkqzsrw11arrc6rbn35j6qivy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atomic-polyfill" ,rust-atomic-polyfill-0.1)
        ("rust-defmt" ,rust-defmt-0.3)
        ("rust-hash32" ,rust-hash32-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-spin" ,rust-spin-0.9)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1)
        ("rust-ufmt-write" ,rust-ufmt-write-0.1))
       #:cargo-development-inputs
       (("rust-scoped-threadpool" ,rust-scoped-threadpool-0.1)
        ("rust-ufmt" ,rust-ufmt-0.1))))
    (home-page "https://github.com/japaric/heapless")
    (synopsis "@code{statice} friendly data structures")
    (description "This package provides @code{static} friendly data structures
that don't require dynamic memory allocation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-heapless-0.6
  (package
    (inherit rust-heapless-0.7)
    (name "rust-heapless")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heapless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08il083hcffis6km4is24kf2j0cnqs0bzz2b196l495zkk9d8jv3"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-as-slice" ,rust-as-slice-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-hash32" ,rust-hash32-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1)
        ("rust-ufmt-write" ,rust-ufmt-write-0.1))))))

(define-public rust-heapless-0.5
  (package
    (inherit rust-heapless-0.6)
    (name "rust-heapless")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heapless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1h1d6s1f9zn0rz2vkdn0b42kcnkmlpd90yhfyqqhpirv38ws5a3k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-as-slice" ,rust-as-slice-0.1)
        ("rust-generic-array" ,rust-generic-array-0.13)
        ("rust-hash32" ,rust-hash32-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1)
        ("rust-ufmt-write" ,rust-ufmt-write-0.1))
       #:cargo-development-inputs
       (("rust-scoped-threadpool" ,rust-scoped-threadpool-0.1)
        ("rust-ufmt" ,rust-ufmt-0.1))))))

(define-public rust-heapsize-0.4
  (package
    (name "rust-heapsize")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heapsize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0q94q9ppqjgrw71swiyia4hgby2cz6dldp7ij57nkvhd6zmfcy8n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/servo/heapsize")
    (synopsis "Measure the total runtime size of an object on the heap")
    (description
     "Infrastructure for measuring the total runtime size of an object on the
heap.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-heapsize-0.3
  (package
    (inherit rust-heapsize-0.4)
    (name "rust-heapsize")
    (version "0.3.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "heapsize" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0dmwc37vgsdjzk10443dj4f23439i9gch28jcwzmry3chrwx8v2m"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-kernel32-sys" ,rust-kernel32-sys-0.2))))))

;; This package makes use of removed features
(define-public rust-heapsize-plugin-0.1
  (package
    (name "rust-heapsize-plugin")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "heapsize_plugin" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1i72isf699q9jl167g2kg4xd6h3cd05rc79zaph58aqjy0g0m9y9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-heapsize" ,rust-heapsize-0.3))))
    (home-page "https://github.com/servo/heapsize")
    (synopsis "Measure runtime size of an object on the heap")
    (description
     "This package automatically generates infrastructure for measuring the
total runtime size of an object on the heap")
    (license license:mpl2.0)))

(define-public rust-heck-0.4
  (package
    (name "rust-heck")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heck" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ygphsnfwl2xpa211vbqkz1db6ri1kvkg8p8sqybi37wclg7fh15"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build?
       #t
       #:cargo-inputs
       (("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/withoutboats/heck")
    (synopsis "Case conversion library")
    (description
     "This library exists to provide case conversion between common cases like
CamelCase and snake_case.  It is intended to be unicode aware, internally
consistent, and reasonably well performing.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-heck-0.3
  (package
    (inherit rust-heck-0.4)
    (name "rust-heck")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "heck" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1b56s2c1ymdd0qmy31bw0ndhm31hcdamnhg3npp7ssrmc1ag9jw7"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))))

(define-public rust-hermit-abi-0.1
  (package
    (name "rust-hermit-abi")
    (version "0.1.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hermit-abi" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0blmmzik5cs79ivq70s9gal8ypgzj50wnl2hwsaam46gjjbz2p3j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
        (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
         ("rust-libc" ,rust-libc-0.2)
         ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/hermitcore/rusty-hermit")
    (synopsis "Small interface to call functions from RustyHermit")
    (description
     "Hermit-abi is small interface to call functions from the unikernel RustyHermit.
It is used to build the target x86_64-unknown-hermit.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hex-0.4
  (package
    (name "rust-hex")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w1a4davm1lgzpamwnba907aysmlrnygbqmfis2mqjx5m552a93z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/KokaKiwi/rust-hex")
    (synopsis "Encode and decode data to/from hexadecimals")
    (description "This crate allows for encoding and decoding data into/from
hexadecimal representation.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-hex-0.3
  (package
    (inherit rust-hex-0.4)
    (name "rust-hex")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hex" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0xsdcjiik5j750j67zk42qdnmm4ahirk3gmkmcqgq7qls2jjcl40"))))))

(define-public rust-hex-0.2
  (package
    (inherit rust-hex-0.4)
    (name "rust-hex")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ajkw40qzn2ygnqjj9w584f6l31wi318258n84pn2hax8la2i8nn"))))))

(define-public rust-hex-literal-0.3
  (package
    (name "rust-hex-literal")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0nzljsyz9rwhh4vi0xs9ya4l5g0ka754wgpy97r1j3v42c75kr11"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis
     "Convert hexadecimal string to byte array at compile time")
    (description
     "Procedural macro for converting hexadecimal string to byte array at
compile time.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hex-literal-0.2
  (package
    (inherit rust-hex-literal-0.3)
    (name "rust-hex-literal")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q36f0qq31ggh4ipcwb7a5g6jmci2010vn2v3qpaz4csxhhf47cn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-hex-literal-impl" ,rust-hex-literal-impl-0.2)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))))

(define-public rust-hex-literal-0.1
  (package
    (inherit rust-hex-literal-0.2)
    (name "rust-hex-literal")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ffnn5g9q5xhdmzj2ic5hk9y18kyqflbmqcssqcya9gixs5r5hnx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-hex-literal-impl" ,rust-hex-literal-impl-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.4))))))

(define-public rust-hex-literal-impl-0.2
  (package
    (name "rust-hex-literal-impl")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bgldhp5gdwwnikfdxigmz9b64qpgwbjqk6mfgv0pvig9s25qk4x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Internal implementation of the hex-literal crate")
    (description
     "Internal implementation of the hex-literal crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hex-literal-impl-0.1
  (package
    (inherit rust-hex-literal-impl-0.2)
    (name "rust-hex-literal-impl")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1nnxqhyn9l998ma04ip79bmpqv1as6003s03g26ynhrr471p022j"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.4))))))

(define-public rust-hkdf-0.11
  (package
    (name "rust-hkdf")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hkdf" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sw8bz79xqq3bc5dh6nzv084g7va13j3lrqf91c10a2wimbnsw01"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-digest" ,rust-digest-0.9)
        ("rust-hmac" ,rust-hmac-0.11))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-blobby" ,rust-blobby-0.3)
        ("rust-crypto-tests" ,rust-crypto-tests-0.5)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))
    (home-page "https://github.com/RustCrypto/KDFs/")
    (synopsis "HMAC-based Extract-and-Expand Key Derivation Function (HKDF)")
    (description "This package provides a HMAC-based Extract-and-Expand Key
Derivation Function (HKDF).")
    (license (list license:expat license:asl2.0))))

(define-public rust-hkdf-0.10
  (package
    (inherit rust-hkdf-0.11)
    (name "rust-hkdf")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hkdf" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kwn3scjvv2x8zc6nz3wrnzxp9shpsdxnjqiyv2r65r3kiijzasi"))))
    (arguments
     `(#:cargo-inputs
       (("rust-digest" ,rust-digest-0.9)
        ("rust-hmac" ,rust-hmac-0.10))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-crypto-tests" ,rust-crypto-tests-0.5)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))))

(define-public rust-hkdf-0.9
  (package
    (inherit rust-hkdf-0.11)
    (name "rust-hkdf")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hkdf" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jdvmf8aadk3s0kn9kk3dj00nprjk9glks5f8dm55r43af34j4gy"))))
    (arguments
     `(#:cargo-inputs
       (("rust-digest" ,rust-digest-0.9)
        ("rust-hmac" ,rust-hmac-0.8))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-crypto-tests" ,rust-crypto-tests-0.5)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))))

(define-public rust-hkdf-0.8
  (package
    (inherit rust-hkdf-0.9)
    (name "rust-hkdf")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hkdf" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qzsmqrvcmgnrb109qr2mvsmr5c4psm1702vrpcqnj02c408m81z"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-digest" ,rust-digest-0.8)
        ("rust-hmac" ,rust-hmac-0.7))))))

(define-public rust-hmac-0.12
  (package
    (name "rust-hmac")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hmac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18nnjkvvpkjw6ppcyijysgxmr4a7knd98msb6vgy4b3z7qgi7jnx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-digest" ,rust-digest-0.10))))
    (home-page "https://github.com/RustCrypto/MACs")
    (synopsis "Generic implementation of Hash-based Message Authentication Code")
    (description
     "This package provides a generic implementation of @acronym{HMAC,
Hash-based Message Authentication Code}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hmac-0.11
  (package
    (inherit rust-hmac-0.12)
    (name "rust-hmac")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hmac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "16z61aibdg4di40sqi4ks2s4rz6r29w4sx4gvblfph3yxch26aia"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.11)
        ("rust-digest" ,rust-digest-0.9))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.11)
        ("rust-md-5" ,rust-md-5-0.9)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-streebog" ,rust-streebog-0.9))))))

(define-public rust-hmac-0.10
  (package
    (inherit rust-hmac-0.11)
    (name "rust-hmac")
    (version "0.10.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hmac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "058yxq54x7xn0gk2vy9bl51r32c9z7qlcl2b80bjh3lk3rmiqi61"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.10)
        ("rust-digest" ,rust-digest-0.9))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.10)
        ("rust-md-5" ,rust-md-5-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))))

(define-public rust-hmac-0.8
  (package
    (inherit rust-hmac-0.11)
    (name "rust-hmac")
    (version "0.8.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hmac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0h48wc7iysh4xd6ci4prh8bb7nszijrh9w3blaaq8a6cilk8hs0j"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-digest" ,rust-digest-0.9))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-md-5" ,rust-md-5-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))))

(define-public rust-hmac-0.7
  (package
    (inherit rust-hmac-0.8)
    (name "rust-hmac")
    (version "0.7.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hmac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "15cnwpssp2n1kdm9x7abir67f2hp3q6rdfj1mcck3hm4rmj5xjsx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-digest" ,rust-digest-0.8))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-md-5" ,rust-md-5-0.8)
        ("rust-sha2" ,rust-sha2-0.8))))))

(define-public rust-hmac-0.5
  (package
    (inherit rust-hmac-0.8)
    (name "rust-hmac")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hmac" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ppm927wsczkkvybj0y7r2w2lprvy5kf5h31qxyrvnbrhnqbvws4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.5)
        ("rust-digest" ,rust-digest-0.7))))))

(define-public rust-hmac-sha1-0.1
  (package
    (name "rust-hmac-sha1")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hmac-sha1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08k7aylc0v8x3abmxn3h73dkad3anfq2i94xk2mjrf4linnkycz1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-sha1" ,rust-sha1-0.2))))
    (home-page "https://github.com/pantsman0/rust-hmac-sha1")
    (synopsis "Minimal implementation of HMAC-SHA1 in Rust")
    (description
     "This package is a pure Rust implementation of the @acronym{HMAC,
Hash-based Message Authentication Code algorithm} for SHA1.")
    (license license:bsd-3)))

(define-public rust-hostname-0.3
  (package
    (name "rust-hostname")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hostname" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rz8yf70cvzl3nry71m4bz9w6x4j9kdz3qng6pnwhk2h20z1qwrw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-match-cfg" ,rust-match-cfg-0.1)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/svartalf/hostname")
    (synopsis "Get hostname for Rust")
    (description
     "Get hostname for Rust.")
    (license license:expat)))

(define-public rust-hostname-0.1
  (package
    (inherit rust-hostname-0.3)
    (name "rust-hostname")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hostname" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kprf862qaa7lwdms6aw7f3275h0j2rwhs9nz5784pm8hdmb9ki1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winutil" ,rust-winutil-0.1))))))

(define-public rust-html5ever-0.25
  (package
    (name "rust-html5ever")
    (version "0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "html5ever" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0szdpwr6l3p21flf01pdlpj6fkpqisqf34lvs918449n3a5g7z5a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mac" ,rust-mac-0.1)
        ("rust-markup5ever" ,rust-markup5ever-0.10)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/servo/html5ever")
    (synopsis "High-performance browser-grade HTML5 parser")
    (description
     "This package provides a high-performance browser-grade HTML5 parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-html5ever-0.24
  (package
    (inherit rust-html5ever-0.25)
    (name "rust-html5ever")
    (version "0.24.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "html5ever" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1js4cr04941ld4r4fqpblvfigy75ds48qcbqhnr7nmz4l6q86m02"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mac" ,rust-mac-0.1)
        ("rust-markup5ever" ,rust-markup5ever-0.9)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-typed-arena" ,rust-typed-arena-1))))))

(define-public rust-html5ever-0.23
  (package
    (inherit rust-html5ever-0.24)
    (name "rust-html5ever")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "html5ever" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dx8k7synrmf3fl6gcfm5q1cybfglvhc9xnvly3s5xcc0b45mrjw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mac" ,rust-mac-0.1)
        ("rust-markup5ever" ,rust-markup5ever-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-typed-arena" ,rust-typed-arena-1))))))

(define-public rust-htmlescape-0.3
  (package
    (name "rust-htmlescape")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "htmlescape" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qria8paf19qy5sgzzk3iiii9fp2j7spbhqf0zjxwrg7v9c500p9"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/veddan/rust-htmlescape")
    (synopsis "Library for HTML entity encoding and decoding")
    (description
     "This package provides a library for HTML entity encoding and decoding.")
    (license (list license:asl2.0 license:expat license:mpl2.0))))

(define-public rust-hts-sys-2
  (package
    (name "rust-hts-sys")
    (version "2.0.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "hts-sys" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1qn1qz2xa69x2dj1fbh91avm9943rbcykr37zs68pb2bdy847i3j"))
              (modules '((guix build utils)))
              (snippet
               '(substitute* "Cargo.toml"
                  ;; Do not use zlib-ng; just use zlib.
                  (("features = \\[\"zlib-ng\", \"static\"\\]") "")
                  ;; No static libraries please.
                  (("\"static-curl\", \"static-ssl\",") "")
                  ((", \"static\"") "")
                  (("\\[\"static\"\\]") "[]")))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.53)
        ("rust-bzip2-sys" ,rust-bzip2-sys-0.1)
        ("rust-cc" ,rust-cc-1)
        ("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-fs-utils" ,rust-fs-utils-1)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-libdeflate-sys" ,rust-libdeflate-sys-0.5)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-lzma-sys" ,rust-lzma-sys-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9))))
    (inputs
     (list curl openssl xz zlib))
    (native-inputs
     (list cmake-minimal pkg-config))
    (home-page "https://github.com/samtools/htslib.git")
    (synopsis "Rust bindings to HTSlib")
    (description "This library provides Rust bindings to HTSlib.")
    (license license:expat)))

(define-public rust-http-0.2
  (package
    (name "rust-http")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y827q7j0gvs8z2x12biaik9db6nb902lpqv889cbcj84sbnkm98"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-itoa" ,rust-itoa-0.4))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/hyperium/http")
    (synopsis "Set of types for representing HTTP requests and responses")
    (description "This package provides a set of types for representing HTTP
requests and responses.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-http-0.1
  (package
    (inherit rust-http-0.2)
    (name "rust-http")
    (version "0.1.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06icxvrd26r6s7dzjavja7r47hgjb9851wblqh8frxnsy3q29lzf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-itoa" ,rust-itoa-0.4))
       #:cargo-development-inputs
       (("rust-indexmap" ,rust-indexmap-1)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-http-body-0.4
  (package
    (name "rust-http-body")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-body" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1imjszmk34603m7chfnhd3rq263bxbdlaxhlbzd06wv7354zix0z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-http" ,rust-http-0.2))))
    (home-page "https://github.com/hyperium/http-body")
    (synopsis "Asynchronous, streaming, HTTP request or response body")
    (description
     "This crate provides a trait representing an asynchronous, streaming,
HTTP request or response body.")
    (license license:expat)))

(define-public rust-http-body-0.3
  (package
    (inherit rust-http-body-0.4)
    (name "rust-http-body")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-body" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06qi0ni45lb92w3ml260c0bxbq5zd4snjmz0a9k69xq6021zzm8k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-http" ,rust-http-0.2))))))

(define-public rust-http-body-0.1
  (package
    (inherit rust-http-body-0.3)
    (name "rust-http-body")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-body" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b99404k4mw6a92hvyr0qwzkqv4f866ykg0x7913limjq5cwhhb7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-tokio-buf" ,rust-tokio-buf-0.1))))))

(define-public rust-http-client-6
  (package
    (name "rust-http-client")
    (version "6.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-client" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i0mys38gsih9kkrdbfsmd8p9lnb2nd5wch76cpkjmqk8mm2mhcq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-h1" ,rust-async-h1-2)
        ("rust-async-native-tls" ,rust-async-native-tls-0.3)
        ("rust-async-std" ,rust-async-std-1)
        ("rust-async-tls" ,rust-async-tls-0.10)
        ("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dashmap" ,rust-dashmap-4)
        ("rust-deadpool" ,rust-deadpool-0.7)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http-types" ,rust-http-types-2)
        ("rust-hyper" ,rust-hyper-0.13)
        ("rust-hyper-tls" ,rust-hyper-tls-0.4)
        ("rust-isahc" ,rust-isahc-0.9)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4)
        ("rust-web-sys" ,rust-web-sys-0.3))))
    (home-page "https://github.com/http-rs/http-client")
    (synopsis "Types and traits for HTTP clients")
    (description "This package provides types and traits for HTTP clients.")
    (license (list license:expat license:asl2.0))))

(define-public rust-http-types-2
  (package
    (name "rust-http-types")
    (version "2.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-types" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0p7g2rzgzvnd419a5ddlyb2nz85z9bw7cdkqyl7467cx2fxkwq9j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-std" ,rust-async-std-1)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-cookie" ,rust-cookie-0.14)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-http" ,rust-http-0.2)
        ("rust-infer" ,rust-infer-0.2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-qs" ,rust-serde-qs-0.7)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7)
        ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/http-rs/http-types")
    (synopsis "Common types for HTTP operations")
    (description
     "This package provides common types for HTTP operations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-httparse-1
  (package
    (name "rust-httparse")
    (version "1.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "httparse" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k60q1hx96cvmjn6k3yjkff87fz0ga2a4z0g9ss8a9x5nndy4v29"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/seanmonstar/httparse")
    (synopsis "Zero-copy HTTP/1.x parser")
    (description
     "This package provides a tiny, safe, speedy, zero-copy HTTP/1.x parser.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-httpdate-1
  (package
    (name "rust-httpdate")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "httpdate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08bln7b1ibdw26gl8h4dr6rlybvlkyhlha309xbh9ghxh9nf78f4"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/pyfisch/httpdate")
    (synopsis "HTTP date parsing and formatting")
    (description
     "This crates parses and formats HTTP datetime strings.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humantime-serde-1
  (package
    (name "rust-humantime-serde")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "humantime-serde" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0n208zzy69f7pgwcm1d0id4nzhssxn3z3zy7ki3dpkaazmnaad5c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-humantime" ,rust-humantime-2)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/jean-airoldie/humantime-serde")
    (synopsis "Humantime serialization timestamp format")
    (description
     "This package provides a Humantime serialization timestamp format.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humansize-1
  (package
    (name "rust-humansize")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "humansize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0piadmwjah1jv6q288im4za9szlgalzjyq2811w35i6gg9ib5jmn"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/LeopoldArkham/humansize")
    (synopsis "Represent file sizes in a human-readable format")
    (description "This package provides a configurable crate to easily
represent file sizes in a human-readable format.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humantime-2
  (package
    (name "rust-humantime")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "humantime" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1r55pfkkf5v0ji1x6izrjwdq9v6sc7bv99xj6srywcar37xmnfls"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/tailhook/humantime")
    (synopsis
     "Parser and formatter for Duration and SystemTime")
    (description
     "A parser and formatter for @code{std::time::{Duration,
SystemTime}}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humantime-1
  (package
    (inherit rust-humantime-2)
    (name "rust-humantime")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "humantime" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0krwgbf35pd46xvkqg14j070vircsndabahahlv3rwhflpy4q06z"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quick-error" ,rust-quick-error-1))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-hyper-0.14
  (package
    (name "rust-hyper")
    (version "0.14.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g4mnsacfvj4127587ihm802kzkh6zgs0c3a2mayc82g3q4w0vj3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-h2" ,rust-h2-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-http-body" ,rust-http-body-0.4)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-httpdate" ,rust-httpdate-1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-pin-project" ,rust-pin-project-lite-0.2)
        ("rust-socket2" ,rust-socket2-0.4)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tower-service" ,rust-tower-service-0.3)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-want" ,rust-want-0.3))))
    (home-page "https://hyper.rs")
    (synopsis "Fast and correct HTTP library")
    (description "This package provides a fast and correct HTTP library.")
    (license license:expat)))

(define-public rust-hyper-0.13
  (package
    (inherit rust-hyper-0.14)
    (name "rust-hyper")
    (version "0.13.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1symcnba2y03b8lj6xp2wd994lk3xyk3wizacjg5s60njzfshs1y"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-h2" ,rust-h2-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-http-body" ,rust-http-body-0.3)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tower-service" ,rust-tower-service-0.3)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-want" ,rust-want-0.3))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-pretty-env-logger" ,rust-pretty-env-logger-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-spmc" ,rust-spmc-0.3)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-test" ,rust-tokio-test-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3)
        ("rust-tower-util" ,rust-tower-util-0.3)
        ("rust-url" ,rust-url-1))))))

(define-public rust-hyper-0.12
  (package
    (inherit rust-hyper-0.13)
    (name "rust-hyper")
    (version "0.12.35")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xnm8zi4bdjqhlnx3238kx8yjf29jjd1ww54apcql7wf8g8nxglx"))))
    (arguments
     `(#:skip-build? #t ;; fails due to some missing example file
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-futures-cpupool" ,rust-futures-cpupool-0.1)
        ("rust-h2" ,rust-h2-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-http-body" ,rust-http-body-0.1)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-log" ,rust-log-0.4)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-buf" ,rust-tokio-buf-0.1)
        ("rust-tokio-executor" ,rust-tokio-executor-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-threadpool" ,rust-tokio-threadpool-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2)
        ("rust-want" ,rust-want-0.2))
       #:cargo-development-inputs
       (("rust-futures-timer" ,rust-futures-timer-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-pretty-env-logger" ,rust-pretty-env-logger-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-spmc" ,rust-spmc-0.3)
        ("rust-tokio-fs" ,rust-tokio-fs-0.1)
        ("rust-tokio-mockstream" ,rust-tokio-mockstream-1)
        ("rust-url" ,rust-url-1))))))

(define-public rust-hyper-0.10
  (package
    (inherit rust-hyper-0.13)
    (name "rust-hyper")
    (version "0.10.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wwjh9p3mzvg3fss2lqz5r7ddcgl1fh9w6my2j69d6k0lbcm41ha"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-log" ,rust-log-0.3)
        ("rust-mime" ,rust-mime-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-traitobject" ,rust-traitobject-0.1)
        ("rust-typeable" ,rust-typeable-0.1)
        ("rust-unicase" ,rust-unicase-1)
        ("rust-url" ,rust-url-1))))))

(define-public rust-hyper-native-tls-0.3
  (package
    (name "rust-hyper-native-tls")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-native-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s30y20qy0akzss91yxsq1x1q7rr04jy33i0cq72nx22yjc5advd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-antidote" ,rust-antidote-1)
        ("rust-hyper" ,rust-hyper-0.10)
        ("rust-native-tls" ,rust-native-tls-0.2))))
    (home-page "https://github.com/sfackler/hyper-native-tls")
    (synopsis "native-tls support for Hyper 0.10")
    (description "This package provides native-tls support for Hyper 0.10.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-rustls-0.22
  (package
    (name "rust-hyper-rustls")
    (version "0.22.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0r2szp06nzqx6gblcw69kwx8afjp218fc083kfpw0i3d66bpm7sz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ct-logs" ,rust-ct-logs-0.8)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-hyper" ,rust-hyper-0.14)
        ("rust-log" ,rust-log-0.4)
        ("rust-rustls" ,rust-rustls-0.19)
        ("rust-rustls-native-certs" ,rust-rustls-native-certs-0.5)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.22)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.21))))
    (home-page "https://github.com/ctz/hyper-rustls")
    (synopsis "Rustls+Hyper integration for pure Rust HTTPS")
    (description
     "This package provides Rustls+Hyper integration for pure Rust HTTPS.")
    (license
     (list license:asl2.0 license:isc license:expat))))

(define-public rust-hyper-rustls-0.21
  (package
    (inherit rust-hyper-rustls-0.22)
    (name "rust-hyper-rustls")
    (version "0.21.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dmbj15fx6qyg26hji2jm7q9y383090jy3z9zjn5xs4f7v43qx1p"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-ct-logs" ,rust-ct-logs-0.7)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-hyper" ,rust-hyper-0.13)
        ("rust-log" ,rust-log-0.4)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-rustls-native-certs" ,rust-rustls-native-certs-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.14)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.20))
       #:cargo-development-inputs
       (("rust-tokio" ,rust-tokio-0.2))))))

(define-public rust-hyper-rustls-0.17
  (package
    (inherit rust-hyper-rustls-0.21)
    (name "rust-hyper-rustls")
    (version "0.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0li9xkzmqd40dbjbl9g0nbf2ka9y0q538ififyd30zsavz3qb7bi"))))
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=server" "--skip=client"
                            "--skip=custom_ca_store")
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-ct-logs" ,rust-ct-logs-0.6)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-hyper" ,rust-hyper-0.12)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.10)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))))))

(define-public rust-hyper-sync-rustls-0.3
  (package
    (name "rust-hyper-sync-rustls")
    (version "0.3.0-rc.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-sync-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16zirxhsk26kz5jxxxs37wxsm02id97h57kkqs512fj1j0x486kd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hyper" ,rust-hyper-0.10)
        ("rust-rustls" ,rust-rustls-0.14)
        ("rust-webpki" ,rust-webpki-0.18)
        ("rust-webpki-roots" ,rust-webpki-roots-0.15))))
    (home-page "https://github.com/SergioBenitez/hyper-sync-rustls")
    (synopsis "Glue code for Rustls and synchronous Hyper")
    (description
     "This package provides glue code for Rustls and synchronous Hyper.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-timeout-0.4
  (package
    (name "rust-hyper-timeout")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-timeout" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c8k3g8k2yh1gxvsx9p7amkimgxhl9kafwpj7jyf8ywc5r45ifdv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hyper" ,rust-hyper-0.14)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-io-timeout" ,rust-tokio-io-timeout-1))))
    (home-page "https://github.com/hjr3/hyper-timeout")
    (synopsis "Connect, read and write timeout aware connector for Hyper")
    (description
     "This package provides a connect, read and write timeout aware connector
to be used with Hyper client.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-tls-0.5
  (package
    (name "rust-hyper-tls")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01crgy13102iagakf6q4mb75dprzr7ps1gj0l5hxm1cvm7gks66n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-hyper" ,rust-hyper-0.14)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-native-tls" ,rust-tokio-native-tls-0.3))))
    (home-page "https://hyper.rs")
    (synopsis "Default TLS implementation for use with hyper")
    (description "This package provides the default TLS implementation for use
with hyper.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-tls-0.4
  (package
    (inherit rust-hyper-tls-0.5)
    (name "rust-hyper-tls")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vcfyz7dxavf4brns15afmj5fxz88lbn05rrpbfqsnybdp2sqyfr"))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-hyper" ,rust-hyper-0.13)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-tls" ,rust-tokio-tls-0.3))
       #:cargo-development-inputs
       (("rust-tokio" ,rust-tokio-0.2))))))

(define-public rust-hyphenation-commons-0.8
  (package
    (name "rust-hyphenation-commons")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyphenation_commons" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gq59h9h8597k04yl53an0j56cvb0in98pxpp27dkiz5mnifgssz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fst" ,rust-fst-0.4)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/tapeinosyne/hyphenation")
    (synopsis "Proemial code for the @code{hyphenation} library")
    (description
     "This package provides a proemial code for the @code{hyphenation} library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hyphenation-0.8
  (package
    (name "rust-hyphenation")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyphenation" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w2hib167vpz7jbg3zs92ifihj4akirlhb5509aib1df8i6dvx5w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-fst" ,rust-fst-0.4)
        ("rust-hyphenation-commons" ,rust-hyphenation-commons-0.8)
        ("rust-pocket-resources" ,rust-pocket-resources-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/tapeinosyne/hyphenation")
    (synopsis "Knuth-Liang hyphenation for a variety of languages")
    (description
     "This package provides a Knuth-Liang hyphenation for a variety of languages.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ident-case-1
  (package
    (name "rust-ident-case")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ident_case" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fac21q6pwns8gh1hz3nbq15j8fi441ncl6w4vlnd1cmc55kiq5r"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/TedDriggs/ident_case")
    (synopsis "Utility for applying case rules to Rust identifiers")
    (description
     "Utility for applying case rules to Rust identifiers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-idna-0.3
  (package
    (name "rust-idna")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "idna" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rh9f9jls0jy3g8rh2bfpjhvvhh4q80348jc4jr2s844133xykg1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-unicode-bidi" ,rust-unicode-bidi-0.3)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-bencher" ,rust-bencher-0.1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tester" ,rust-tester-0.9))))
    (home-page "https://github.com/servo/rust-url/")
    (synopsis "Internationalizing Domain Names in Applications and Punycode")
    (description
     "IDNA (Internationalizing Domain Names in Applications) and Punycode.")
    (license (list license:expat license:asl2.0))))

(define-public rust-idna-0.2
  (package
    (inherit rust-idna-0.3)
    (name "rust-idna")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "idna" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y7ca2w5qp9msgl57n03zqp78gq1bk2crqzg6kv7a542mdphm2j1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-matches" ,rust-matches-0.1)
        ("rust-unicode-bidi" ,rust-unicode-bidi-0.3)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))))))

(define-public rust-idna-0.1
  (package
    (inherit rust-idna-0.2)
    (name "rust-idna")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "idna" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kl4gs5kaydn4v07c6ka33spm9qdh2np0x7iw7g5zd8z1c7rxw1q"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-matches" ,rust-matches-0.1)
        ("rust-unicode-bidi" ,rust-unicode-bidi-0.3)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))
       #:cargo-development-inputs
       (("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-rustc-test" ,rust-rustc-test-0.3))))))

(define-public rust-ieee754-0.2
  (package
    (name "rust-ieee754")
    (version "0.2.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ieee754" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1771d2kvw1wga65yrg9m7maky0fzsaq9hvhkv91n6gmxmjfdl1wh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2))))
    (home-page "https://github.com/huonw/ieee754")
    (synopsis "Low-level manipulations of IEEE754 floating-point numbers")
    (description "This is a package for low-level manipulations of IEEE754
floating-point numbers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-if-chain-1
  (package
    (name "rust-if-chain")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "if_chain" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0zgcn31bahnsmsjc0cgk0cy38p8sfjs79yvi6rjs5zz5b5xhqdn3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/lfairy/if_chain")
    (synopsis "Macro for writing nested @code{if let} expressions")
    (description "This package provides a macro for writing nested @code{if
let} expressions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ignore-0.4
  (package
    (name "rust-ignore")
    (version "0.4.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ignore" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07bmnv96msggqb040z6xqp1p7s8ys0f97b731hp6mybkjc9ingvi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-same-file" ,rust-same-file-1)
        ("rust-thread-local" ,rust-thread-local-1)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-winapi-util" ,rust-winapi-util-0.1))
       #:cargo-development-inputs
       (("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5))))
    (home-page "https://github.com/BurntSushi/ripgrep/tree/master/crates/ignore")
    (synopsis "Efficiently match ignore files such as @file{.gitignore}")
    (description
     "This package provides a fast library for efficiently matching
ignore files such as @file{.gitignore} against file paths.")
    (license (list license:unlicense license:expat))))

(define-public rust-include-flate-0.1
  (package
    (name "rust-include-flate")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "include-flate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xd63rhr03ax1w327ws46wc9zyw5k9jsaxfy24j6wg9km3xhfqii"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-include-flate-codegen-exports" ,rust-include-flate-codegen-exports-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libflate" ,rust-libflate-0.1))))
    (home-page "https://github.com/SOF3/include-flate")
    (synopsis "Variant of @code{include_bytes!/include_str!} with compression")
    (description
     "This package provides a variant of @code{include_bytes!/include_str!}
with compile-time deflation and runtime lazy inflation.")
    (license license:asl2.0)))

(define-public rust-include-flate-codegen-0.1
  (package
    (name "rust-include-flate-codegen")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "include-flate-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mbw6fcczmfw4dabps4l90mdn2wdy9zhqwh60xx4fjcxqfsm9ksb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libflate" ,rust-libflate-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/SOF3/include-flate")
    (synopsis "Macro codegen for the @code{include-flate} crate")
    (description
     "This package provides macro codegen for the @code{include-flate}
crate.")
    (license license:asl2.0)))

(define-public rust-include-flate-codegen-exports-0.1
  (package
    (name "rust-include-flate-codegen-exports")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "include-flate-codegen-exports" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dk7xdrck9f3bjnwm3rmh5gl1hs64lr2gnd3dv3jznharcmyb4mw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-include-flate-codegen" ,rust-include-flate-codegen-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/SOF3/include-flate")
    (synopsis "Macro codegen for the @code{include-flate} crate")
    (description
     "This package provides macro codegen for the @code{include-flate}
crate.")
    (license license:asl2.0)))

(define-public rust-indenter-0.3
  (package
    (name "rust-indenter")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indenter" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10y6i6y4ls7xsfsc1r3p5j2hhbxhaqnk5zzk8aj52b14v05ba8yf"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/yaahc/indenter")
    (synopsis "Display trait indentation helper for errors")
    (description
     "This package provides a few wrappers for the @code{fmt::Write} object
that efficiently appends and removes common indentation after every newline.")
    (license (list license:expat license:asl2.0))))

(define-public rust-indexmap-1
  (package
    (name "rust-indexmap")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indexmap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19b2zwfajhsfcgny0clv8y4jppy704znfhv8nv2dw9a18l2kcqxw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-hashbrown" ,rust-hashbrown-0.11)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/bluss/indexmap")
    (synopsis "Hash table with consistent order and fast iteration")
    (description
     "This package provides a hash table with consistent order and fast iteration.

The indexmap is a hash table where the iteration order of the key-value
pairs is independent of the hash values of the keys.  It has the usual
hash table functionality, it preserves insertion order except after
removals, and it allows lookup of its elements by either hash table key
or numerical index.  A corresponding hash set type is also provided.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-indicatif-0.15
  (package
    (name "rust-indicatif")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indicatif" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r4n50mclyi4c7b9c9mlma1rhchjamw71r3z8vgqcmp24mhvbakv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-console" ,rust-console-0.13)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-number-prefix" ,rust-number-prefix-0.3)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.7)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/mitsuhiko/indicatif")
    (synopsis "Progress bar and CLI reporting library for Rust")
    (description
     "This package provides a progress bar and CLI reporting library for
Rust.")
    (license license:expat)))

(define-public rust-indoc-1
  (package
    (name "rust-indoc")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indoc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qs42cn8rj7kdpmp1dlkzhv62rfmbx3ffwvsfw67zyq86jm1xaxd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-unindent" ,rust-unindent-0.1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/indoc")
    (synopsis "Indented document literals for Rust")
    (description
     "This crate provides a procedural macro for indented string literals.
The @code{indoc!()} macro takes a multiline string literal and un-indents it
at compile time so the leftmost non-space character is in the first column.")
    (license (list license:expat license:asl2.0))))

(define-public rust-indoc-0.3
  (package
    (inherit rust-indoc-1)
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indoc" version))
       (file-name (string-append "rust-indoc-" version ".tar.gz"))
       (sha256
        (base32 "1n2fd2wm1h005hd7pjgx4gv5ymyq4sxqn8z0ssw6xchgqs5ilx27"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-indoc-impl" ,rust-indoc-impl-0.3)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))))

(define-public rust-indoc-impl-0.3
  (package
    (inherit rust-indoc-0.3)
    (name "rust-indoc-impl")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indoc-impl" version))
       (file-name (string-append "rust-indoc-impl-" version ".tar.gz"))
       (sha256
        (base32 "1w58yg249kmzsn75kcj34qaxqh839l1hsaj3bzggy3q03wb6s16f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-unindent" ,rust-unindent-0.1))))
    (synopsis "Macros for @code{rust-indoc}")
    (description
     "This package provides macros for use with the @code{rust-indoc}
package.  It is obsolete for indoc versions > 1.")))

(define-public rust-infer-0.2
  (package
    (name "rust-infer")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "infer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1b4ziqcv0d1wga5yfqf620dkgzijsdw3ylnzq61bfaxla2d85sb4"))))
    (build-system cargo-build-system)
    (arguments `(#:tests? #false))      ;missing files
    (home-page "https://github.com/bojand/infer")
    (synopsis "Infer file types based on its magic number signature")
    (description
     "This crate infers a file types based on its magic number
signature.")
    (license license:expat)))

(define-public rust-inflate-0.4
  (package
    (name "rust-inflate")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inflate" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zxjdn8iwa0ssxrnjmywm3r1v284wryvzrf8vkc7nyf5ijbjknqw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-adler32" ,rust-adler32-1))))
    (home-page "https://github.com/PistonDevelopers/inflate.git")
    (synopsis "DEFLATE decoding")
    (description "This package provides DEFLATE decoding.")
    (license license:expat)))

(define-public rust-inflector-0.11
  (package
    (name "rust-inflector")
    (version "0.11.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "Inflector" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lqmcni21ifzyq41fhz6k1j2b23cmsx469s4g4sf01l78miqqhzy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/whatisinternet/inflector")
    (synopsis "String based inflections for Rust")
    (description "This package adds String based inflections for Rust.  Snake,
kebab, camel, sentence, class, title and table cases as well as ordinalize,
deordinalize, demodulize, foreign key, and pluralize/singularize are supported
as both traits and pure functions acting on String types.")
    (license license:bsd-2)))

(define-public rust-inotify-0.9
  (package
    (name "rust-inotify")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cs3xlkq3fnfca3mimvifazp01ayscinm07v38ifw0xin5f4fcdh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-inotify-sys" ,rust-inotify-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/inotify-rs/inotify")
    (synopsis "Idiomatic wrapper for inotify")
    (description "This package provides an idiomatic wrapper for inotify
written in Rust.")
    (license license:isc)))

(define-public rust-inotify-0.8
  (package
    (inherit rust-inotify-0.9)
    (name "rust-inotify")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m74znskinrvfcp0hczwwdxvc7kvnrrailngkivk1iwknfa0mpa6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-inotify-sys" ,rust-inotify-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-tokio" ,rust-tokio-0.2))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-tokio" ,rust-tokio-0.2))))))

(define-public rust-inotify-0.7
  (package
    (inherit rust-inotify-0.8)
    (name "rust-inotify")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0byhq4x4b2rlbkmfrab5dni39wiq2ls1hv1nhggp7rla5inwc5j8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-inotify-sys" ,rust-inotify-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-inotify-sys-0.1
  (package
    (name "rust-inotify-sys")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1h2nwgajz80qddjm4mpma94zahxw84nscbycy9pgzbjrgjl1ljp7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/inotify-rs/inotify-sys")
    (synopsis "Inotify bindings for Rust")
    (description
     "This package provides inotify bindings for the Rust programming language.")
    (license license:isc)))

(define-public rust-input-buffer-0.3
  (package
    (name "rust-input-buffer")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "input_buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0m4pamqvr00z90cmrgjj25iwpqy6fyac53k1ms63k86m8d9aka0r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5))))
    (home-page "https://github.com/snapview/input_buffer")
    (synopsis
     "Peekable FIFO-like buffer for receiving network data efficiently")
    (description
     "This package provides a peekable FIFO-like buffer for receiving network
data efficiently.")
    (license (list license:expat license:asl2.0))))

(define-public rust-insta-1
  (package
    (name "rust-insta")
    (version "1.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i4jdrr888h0qvfhy2b4vvswlpi2x2ghwg31ljfa9kki54db58f4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-console" ,rust-console-0.14)
        ("rust-csv" ,rust-csv-1)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-similar" ,rust-similar-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-uuid" ,rust-uuid-0.8)
        ("rust-walkdir" ,rust-walkdir-2))))
    (home-page "https://insta.rs/")
    (synopsis "Snapshot testing library for Rust")
    (description
     "This package provides a snapshot testing library for Rust.")
    (license license:asl2.0)))

(define-public rust-insta-0.16
  (package
    (inherit rust-insta-1)
    (name "rust-insta")
    (version "0.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vhqlirp75nx8qalz87qk2wjs7mzwxww0n09n2ircgw1phd94zk1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-console" ,rust-console-0.11)
        ("rust-difference" ,rust-difference-2)
        ("rust-globwalk" ,rust-globwalk-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8))))))

(define-public rust-insta-0.12
  (package
    (inherit rust-insta-0.16)
    (name "rust-insta")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j8k8rfcbdvh2s3jfj9hj7mspl32rqxqa393cw55jhg8cb09sj8d"))))
    (arguments
     `(#:cargo-test-flags
       '("--release"
         "--"
         "--skip=runtime::test_format_rust_expression")
       #:cargo-inputs
       (("rust-console" ,rust-console-0.9)
        ("rust-difference" ,rust-difference-2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-uuid" ,rust-uuid-0.8))))))

(define-public rust-insta-0.8
  (package
    (inherit rust-insta-0.16)
    (name "rust-insta")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17rvqw9xm61prncbqi3cplphr3l2dl85sljdpyr3fz2mqjgbdfwb"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-ci-info" ,rust-ci-info-0.3)
        ("rust-console" ,rust-console-0.7)
        ("rust-difference" ,rust-difference-2)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-uuid" ,rust-uuid-0.7))))))

(define-public rust-instant-0.1
  (package
    (name "rust-instant")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "instant" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v659qqm55misvjijfbl1p7azjp4yynjbwldan8836ynpgp4w4k1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Issue during the wasm test.
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-stdweb" ,rust-stdweb-0.4)
        ("rust-time" ,rust-time-0.2)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/sebcrozet/instant")
    (synopsis
     "Partial replacement for std::time::Instant that works on WASM too")
    (description
     "This package provides a partial replacement for @code{std::time::Instant}
that works on WASM too.")
    (license license:bsd-3)))

(define-public rust-integer-encoding-3
  (package
    (name "rust-integer-encoding")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "integer-encoding" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f0mk7d694g2sz4my5zh7i5w4kijx5y16x6dip7fv0pazx013hch"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/dermesser/integer-encoding-rs")
    (synopsis "Encoding and decoding integers to and from bytestrings")
    (description
     "This crate provides encoding and decoding of integers to and from
bytestring representations.")
    (license license:expat)))

(define-public rust-integer-encoding-1
  (package
    (inherit rust-integer-encoding-3)
    (name "rust-integer-encoding")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "integer-encoding" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c032xhif5d6a8nc4cak60g5ylwd6p9569122m5hm67brx2l5yhb"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-0.2))))))

(define-public rust-interpolate-name-0.2
  (package
    (name "rust-interpolate-name")
    (version "0.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "interpolate_name" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05vzsiqb69d1mbpaphcg4ifjsjs6g03b8pacskfcydqhh555zcxl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/lu-zero/interpolate_name")
    (synopsis "Simple procedural macro attribute for repetitive tests")
    (description
     "Simple procedural macro attribute for repetitive tests.")
    (license license:expat)))

(define-public rust-inventory-0.2
  (package
    (name "rust-inventory")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inventory" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06h9xw67wx18rank4yyz93iq89j0fk6fbazryfvf5ach1dp4qd44"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ctor" ,rust-ctor-0.1)
        ("rust-ghost" ,rust-ghost-0.1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/inventory")
    (synopsis "Typed distributed plugin registration")
    (description
     "This package provides a way to set up a plugin registry into which
plugins can be registered from any source file linked into your program.
There does not need to be a central list of all the plugins.")
    ;; Either license can be chosen at the users option.
    (license (list license:expat license:asl2.0))))

(define-public rust-inventory-0.1
  (package
    (inherit rust-inventory-0.2)
    (name "rust-inventory")
    (version "0.1.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "inventory" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1m1zdjgs3nzfdxf86mc1i0id56fvk8rfw63rf04yi88bqrh53szh"))))
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-ctor" ,rust-ctor-0.1)
         ("rust-ghost" ,rust-ghost-0.1)
         ("rust-inventory-impl" ,rust-inventory-impl-0.1))))))

(define-public rust-inventory-impl-0.1
  (package
    (name "rust-inventory-impl")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inventory-impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j45a7nq4vircnz5m23db34527icxqnvh2si96zc9w662lvvahby"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/dtolnay/inventory")
    (synopsis "Macros for the @code{inventory} crate")
    (description
     "This package provides macros for the @code{rust-inventory} package.
It has been merged with the @code{inventory} crate and is only useful for
versions < 0.2.")
    ;; Either license can be chosen at the users option.
    (license (list license:expat license:asl2.0))))

(define-public rust-iovec-0.1
  (package
    (name "rust-iovec")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "iovec" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ph73qygwx8i0mblrf110cj59l00gkmsgrpzz1rm85syz5pymcxj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/carllerche/iovec")
    (synopsis "Portable buffer type for scatter/gather I/O operations")
    (description
     "Portable buffer type for scatter/gather I/O operations.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-ipconfig-0.2
  (package
    (name "rust-ipconfig")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ipconfig" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mzsagc6bk3i3fpggqlq8am5rxn4hgs297rsaya90w79xj5g3qpp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-socket2" ,rust-socket2-0.3)
        ("rust-widestring" ,rust-widestring-0.4)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winreg" ,rust-winreg-0.6))))
    (home-page "https://github.com/liranringel/ipconfig")
    (synopsis "Get network adapters and configuration information for Windows")
    (description "This package lets you get network adapters information and
network configuration for Windows.")
    (license (list license:expat license:asl2.0))))

(define-public rust-is-macro-0.1
  (package
    (name "rust-is-macro")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "is-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vjh4sdpvx1kdf1znyk3b54gkyk7f8lsasc47ypkksp3r4ypz004"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-inflector" ,rust-inflector-0.11)
        ("rust-pmutil" ,rust-pmutil-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/kdy1/is-macro")
    (synopsis "Create methods to use custom enum like Option/Result")
    (description "This package lets you easily create methods to use a custom
enum like Option/Result.")
    (license license:expat)))

(define-public rust-isahc-0.9
  (package
    (name "rust-isahc")
    (version "0.9.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "isahc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12iqz5fj0509pr813pds2fgdk649a0b6ipvy3pqjwb1ywh68m572"))))
    (build-system cargo-build-system)
    (arguments
     ;; Build fails with "failed to run custom build command for `curl-sys
     ;; v0.4.39+curl-7.74.0`".  Skip for now.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-curl" ,rust-curl-0.4)
        ("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-flume" ,rust-flume-0.9)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-publicsuffix" ,rust-publicsuffix-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-sluice" ,rust-sluice-0.5)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-futures" ,rust-tracing-futures-0.2)
        ("rust-url" ,rust-url-2)
        ("rust-waker-fn" ,rust-waker-fn-1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-indicatif" ,rust-indicatif-0.15)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-test-case" ,rust-test-case-1)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.2))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list curl openssl zlib))
    (home-page "https://github.com/sagebind/isahc")
    (synopsis "Practical HTTP client")
    (description
     "Isahc is an acronym that stands for Incredible Streaming Asynchronous
HTTP Client.  It is an asynchronous HTTP client for the Rust language.  It
uses libcurl as an HTTP engine inside, and provides an easy-to-use API on top
that integrates with Rust idioms.")
    (license license:expat)))

(define-public rust-ipnet-2
  (package
    (name "rust-ipnet")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ipnet" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0db147nh8jnxr23yxa7hwqn7dcjivdqi3aq4mgf2zgkqqqa2zgj7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/krisprice/ipnet")
    (synopsis "Work with IPv4 and IPv6 network addresses")
    (description "This package provides types and useful methods for working
with IPv4 and IPv6 network addresses, commonly called IP prefixes.  The new
IpNet, Ipv4Net, and Ipv6Net types build on the existing IpAddr, Ipv4Addr, and
Ipv6Addr types already provided in Rust's standard library and align to their
design to stay consistent.  The module also provides useful traits that extend
Ipv4Addr and Ipv6Addr with methods for Add, Sub, BitAnd, and BitOr operations.
The module only uses stable feature so it is guaranteed to compile using the
stable toolchain.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ipnetwork-0.17
  (package
    (name "rust-ipnetwork")
    (version "0.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ipnetwork" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sviri9ksb3cmhx3h0rcfy8pvpx7f0cx5ba1z87ydvf07amymhq2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://crates.io/crates/ipnetwork")
    (synopsis "Work with IP CIDRs in Rust")
    (description "This package provides a library to work with IP CIDRs in
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-iron-0.6
  (package
    (name "rust-iron")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "iron" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s4mf8395f693nhwsr0znw3j5frzn56gzllypyl50il85p50ily6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hyper" ,rust-hyper-0.10)
        ("rust-hyper-native-tls" ,rust-hyper-native-tls-0.3)
        ("rust-log" ,rust-log-0.3)
        ("rust-mime-guess" ,rust-mime-guess-1)
        ("rust-modifier" ,rust-modifier-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-plugin" ,rust-plugin-0.2)
        ("rust-typemap" ,rust-typemap-0.3)
        ("rust-url" ,rust-url-1))))
    (home-page "https://github.com/iron/iron")
    (synopsis "Extensible, concurrency focused web development in Rust")
    (description
     "Iron is a high level web framework built in and for Rust.  It is highly
concurrent and can scale horizontally on more machines behind a load balancer
or by running more threads on a more powerful machine.  Iron avoids the
bottlenecks encountered in highly concurrent code by avoiding shared writes
and locking in the core framework.")
    (license license:expat)))

(define-public rust-is-debug-1
  (package
    (name "rust-is-debug")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "is_debug" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12bwspph88wgmzcyl8dg3s28gph41r9shfq8yzaj564xj7lril86"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/baoyachi/rust_is_debug")
    (synopsis "get build model is debug")
    (description "get build model is debug")
    (license (list license:expat license:asl2.0))))

(define-public rust-is-executable-1
  (package
    (name "rust-is-executable")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "is_executable" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j59iqaxcgax0qll30rarpcr7y3dpkl38iv4mlkfcxbvsv3cv6ps"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/fitzgen/is_executable")
    (synopsis "Find executable files at path")
    (description
     "This package provides a small helper function which determines
whether or not a given path points to an executable file.")
    (license (list license:expat license:asl2.0))))

(define-public rust-iso8601-0.3
  (package
    (name "rust-iso8601")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "iso8601" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vvn6f9gv2295ik77nvaz99wzbwz1bmasrd787sz6d9mlwa6ks23"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-nom" ,rust-nom-4))))
    (home-page "https://github.com/badboy/iso8601")
    (synopsis "Parsing ISO8601 dates using nom")
    (description "Parsing ISO8601 dates using nom.")
    (license license:expat)))

(define-public rust-itertools-0.10
  (package
    (name "rust-itertools")
    (version "0.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qy55fqbaisr9qgbn7cvdvqlfqbh1f4ddf99zwan56z7l6gx3ad9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-paste" ,rust-paste-1)
        ("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/rust-itertools/itertools")
    (synopsis "Extra iterator adaptors, methods, free functions, and macros")
    (description
     "This package provides extra iterator adaptors, iterator methods, free
functions, and macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-itertools-0.9
  (package
    (inherit rust-itertools-0.10)
    (name "rust-itertools")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itertools" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0jyml7ygr7kijkcjdl3fk5f34y5h5jsavclim7l13zjiavw1hkr8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-cargo-toml
           (lambda _
             (substitute* "Cargo.toml"
               (("=0.3.0") "0.3"))
             #t)))))))

(define-public rust-itertools-0.8
  (package
    (inherit rust-itertools-0.9)
    (name "rust-itertools")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1154j48aw913v5jnyhpxialxhdn2sfpl4d7bwididyb1r05jsspm"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-itertools-0.7
  (package
    (inherit rust-itertools-0.8)
    (name "rust-itertools")
    (version "0.7.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itertools" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "03cpsj26xmyamcalclqzr1i700vwx8hnbgxbpjvs354f8mnr8iqd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.5))))))

(define-public rust-itertools-0.6
  (package
    (inherit rust-itertools-0.10)
    (name "rust-itertools")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08fx60wxmjakssqn3w9045dasqvaf1gmgzg5kag062k9l56vxwnk"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-itertools-0.5
  (package
    (inherit rust-itertools-0.7)
    (name "rust-itertools")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itertools" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1z4lyrakgynvhylya72qb3vizmxmd62whjmg4r8k01d4inbxccs8"))))
    (arguments
     `(#:tests? #f ; Tests fail to compile
       #:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-itertools-num-0.1
  (package
    (name "rust-itertools-num")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools-num" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rr7ig9nkpampcas23s91x7yac6qdnwssq3nap522xbgkqps4wm8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-itertools" ,rust-itertools-0.8)
        ("rust-quickcheck" ,rust-quickcheck-0.8))))
    (home-page
     "https://github.com/bluss/itertools-num")
    (synopsis
     "Numerical iterator tools")
    (description
     "Numerical iterator tools.  Extra iterators and iterator methods
and functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-itoa-1
  (package
    (name "rust-itoa")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d8wr2qf5b25a04xf10rz9r0pdbjdgb0zaw3xvf8k2sqcz1qzaqs"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/itoa")
    (synopsis "Fast functions for printing integer primitives")
    (description "This crate provides fast functions for printing integer
primitives to an @code{io::Write}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-itoa-0.4
  (package
    (name "rust-itoa")
    (version "0.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m1dairwyx8kfxi7ab3b5jc71z1vigh9w4shnhiajji9avzr26dp"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/itoa")
    (synopsis "Fast functions for printing integer primitives")
    (description "This crate provides fast functions for printing integer
primitives to an @code{io::Write}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-itoa-0.3
  (package
    (inherit rust-itoa-0.4)
    (name "rust-itoa")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itoa" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "136vwi6l2k1vrlvfx49lhficj813pk88xrcx1q3axqh1mwms6943"))))))

(define-public rust-ivf-0.1
  (package
    (name "rust-ivf")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ivf" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wfjf3rilqavrhvwagzinvng9dg28wcjk3c6c6p5qmc1xy65qfh1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitstream-io" ,rust-bitstream-io-0.8))))
    (home-page "https://github.com/xiph/rav1e")
    (synopsis "Simple ivf muxer")
    (description "This package provides a simple ivf muxer.")
    (license license:bsd-2)))

(define-public rust-javascriptcore-rs-sys-0.2
  (package
    (name "rust-javascriptcore-rs-sys")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "javascriptcore-rs-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1619vl48yw3wrjw4c3dfm3s5s9sizgxp5s7s1ahpbkcdl2lasiiz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/tauri-apps/javascriptcore-rs")
    (synopsis "JavaScriptCore bindings and wrappers for Rust")
    (description
     "Sys functions for the Rust bindings of the javacriptcore library.")
    (license license:expat)))

(define-public rust-jemalloc-sys-0.3
  (package
    (name "rust-jemalloc-sys")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "jemalloc-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ify9vlql01qhfxlj7d4p9jvcp90mj2h69nkbq7slccvbhzryfqd"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "jemalloc") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ;; Build dependencies:
        ("rust-cc" ,rust-cc-1)
        ("rust-fs-extra" ,rust-fs-extra-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'configure 'override-jemalloc
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jemalloc (assoc-ref inputs "jemalloc")))
               (setenv "JEMALLOC_OVERRIDE"
                       (string-append jemalloc "/lib/libjemalloc_pic.a")))
             #t)))))
    (native-inputs
     (list jemalloc))
    (home-page "https://github.com/gnzlbg/jemallocator")
    (synopsis "Rust FFI bindings to jemalloc")
    (description "This package provides Rust FFI bindings to jemalloc.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-jemalloc-sys-0.1
  (package
    (inherit rust-jemalloc-sys-0.3)
    (name "rust-jemalloc-sys")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jemalloc-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1bh07rlzgg39ys1lsgnpxgvjj6blagp2h17fx267d0g3a272rimz"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "jemalloc") #t))))))

(define-public rust-jemallocator-0.3
  (package
    (name "rust-jemallocator")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jemallocator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sabfa5118b7l4ars5n36s2fjyfn59w4d6mjs6rrmsa5zky67bj3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-jemalloc-sys" ,rust-jemalloc-sys-0.3)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-0.1))))
    (home-page "https://github.com/gnzlbg/jemallocator")
    (synopsis "Rust allocator backed by jemalloc")
    (description
     "This package provides a Rust allocator backed by jemalloc.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jemallocator-0.1
  (package
    (inherit rust-jemallocator-0.3)
    (name "rust-jemallocator")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jemallocator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1csabk36p06nlh3qxxsg6nkf074b2jq2cld5zriq0xazqqmd834z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jemalloc-sys" ,rust-jemalloc-sys-0.1)
        ("rust-libc" ,rust-libc-0.2))
       #:phases
       (modify-phases %standard-phases
         (add-after 'configure 'override-jemalloc
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jemalloc (assoc-ref inputs "jemalloc")))
               (setenv "JEMALLOC_OVERRIDE"
                       (string-append jemalloc "/lib/libjemalloc_pic.a")))
             #t)))))
    (native-inputs
     (list jemalloc))))

(define-public rust-jetscii-0.5
  (package
    (name "rust-jetscii")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jetscii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x4z5ixlxv1wa70d3d6ad3n8qxz6z00i13zwnv219v45qcwybbnb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-region" ,rust-region-2))))
    (home-page "https://github.com/shepmaster/jetscii")
    (synopsis
     "Search strings and byte slices for sets of ASCII characters or bytes")
    (description "This package provides a tiny library to efficiently search
strings and byte slices for sets of ASCII characters or bytes.")
    (license license:expat)))

(define-public rust-jetscii-0.3
  (package
    (inherit rust-jetscii-0.5)
    (name "rust-jetscii")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jetscii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sq6d6c9vi44gkr566w2f1d4n6mmrjx8gjdwgnhkgcsg051j391j"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-jni-0.18
  (package
    (name "rust-jni")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1brglk3kfia9wkr6rkm6p297b8qk6rv3k8rf6jjiqc74l49735i4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cesu8" ,rust-cesu8-1)
        ("rust-combine" ,rust-combine-4)
        ("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/jni-rs/jni-rs")
    (synopsis "Rust bindings to the JNI")
    (description
     "This package provides Rust bindings to the JNI.  It
implements native Java methods for JVM and Android in Rust, call Java
code from Rust, embed JVM in Rust applications and use any Java
libraries.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jni-0.14
  (package
    (inherit rust-jni-0.18)
    (name "rust-jni")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00jl4jzzbbcf1nyziras5drp501xsk89g0132pwg194ilh6k308r"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cesu8" ,rust-cesu8-1)
        ("rust-combine" ,rust-combine-3)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-jni-glue-0.0
  (package
    (name "rust-jni-glue")
    (version "0.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni-glue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "054kc2hkdfjiihy7ssrn97s9hs35c2v32ph2h0jlv4vkazx39ddb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/MaulingMonkey/jni-bindgen")
    (synopsis "Glue code to accompany the jni-bindgen code generator")
    (description
     "This package provides manually written glue code to accompany
the jni-bindgen code generator for binding to JVM APIs from Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jni-sys-0.3
  (package
    (name "rust-jni-sys")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c01zb9ygvwg9wdx2fii2d39myzprnpqqhy7yizxvjqp5p04pbwf"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-jni-sys")
    (synopsis "Rust definitions corresponding to @file{jni.h}")
    (description
     "This package provides Rust definitions corresponding to
@file{jni.h}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jobserver-0.1
  (package
    (name "rust-jobserver")
    (version "0.1.22")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jobserver" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zg7p4khibisbvd8b1lqvvni6lr00g49d4bq2zj6m76bs7jmlbwp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-tokio-core" ,rust-tokio-core-0.1)
        ("rust-tokio-process" ,rust-tokio-process-0.2))))
    (home-page "https://github.com/alexcrichton/jobserver-rs")
    (synopsis "GNU make jobserver for Rust")
    (description
     "An implementation of the GNU make jobserver for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jod-thread-0.1
  (package
    (name "rust-jod-thread")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jod-thread" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1bj7g6l59ybcf33znf80ccqbxvs1cmd8ynd4m8h7ywdqk473c8wb"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page
     "https://github.com/matklad/jod-thread")
    (synopsis
     "Thin wrapper around @code{std::thread} which joins on drop by default")
    (description
     "Join On Drop thread (jod_thread) is a thin wrapper around
@code{std::thread}, which makes sure that by default all threads are joined.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jsonpath-lib-0.3
  (package
    (name "rust-jsonpath-lib")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jsonpath_lib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kvp4fargixqlwjvpb3w6f1lvmiysnmj7an5h75wqc42ss8k39pa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/freestrings/jsonpath")
    (synopsis "JsonPath engine written in Rust")
    (description
     "It is JsonPath engine written in Rust.  It provides a similar API
interface in Webassembly and Javascript too.")
    (license license:expat)))

(define-public rust-jsonrpc-core-14
  (package
    (name "rust-jsonrpc-core")
    (version "14.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jsonrpc-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qkvgkr05sg0j25jqgw7zcw4r1agzg8gnfnrmw1rgyqz283p6x50"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/paritytech/jsonrpc")
    (synopsis "Transport agnostic Rust implementation of JSON-RPC 2.0")
    (description
     "This package provides a transport agnostic Rust implementation of
JSON-RPC 2.0 specification.")
    (license license:expat)))

(define-public rust-js-sys-0.3
  (package
    (name "rust-js-sys")
    (version "0.3.55")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "js-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "116cg9vn62cl3vifbs6cjdsg7hz98kr7sr8kpy31liccsg6gzjbw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://rustwasm.github.io/wasm-bindgen/")
    (synopsis "Bindings for all JS global objects and functions in WASM")
    (description
     "Bindings for all JS global objects and functions in all JS environments
like Node.js and browsers, built on @code{#[wasm_bindgen]} using the
wasm-bindgen crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-json-0.11
  (package
    (name "rust-json")
    (version "0.11.15")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "json" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1rg9jxf6bpbwis3ixd5ak8rp37him7n4z8awz4ssrxl6hyplbhlj"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/maciejhirsz/json-rust")
    (synopsis "JSON implementation in Rust")
    (description "This crate provides a JSON implementation in Rust, reducing
friction with idiomatic Rust structs to ease interopability.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-juliex-0.3
  (package
    (name "rust-juliex")
    (version "0.3.0-alpha.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "juliex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g4r23i7dkpid8zmkg6aiw73gkp7jagwhrjfi12yklyx4dczvp12"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures-preview" ,rust-futures-preview-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://github.com/withoutboats/juliex")
    (synopsis "Very basic future executor")
    (description
     "juliex is a concurrent executor for Rust futures.  It is implemented as
a threadpool executor using a single, shared queue.  Algorithmically, it is
very similar to the Threadpool executor provided by the futures crate.  The
main difference is that juliex uses a crossbeam channel and performs a single
allocation per spawned future, whereas the futures Threadpool uses std
concurrency primitives and multiple allocations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-juniper-codegen-0.14
  (package
    (name "rust-juniper-codegen")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "juniper_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06ym8568k9p75kvnfc4ywqbkzaa4ib6gngx9vpbsjwg9v0sg42nl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;FIXME: fail due to unresolved import
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-juniper" ,rust-juniper-0.14))))
    (home-page "https://github.com/graphql-rust/juniper")
    (synopsis "Internal custom derive trait for Juniper GraphQL")
    (description
     "This package provides an internal custom derive trait for Juniper
GraphQL.")
    (license license:bsd-2)))

(define-public rust-juniper-0.14
  (package
    (name "rust-juniper")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "juniper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s56rb31yddhvjynl5bk8jihcdln8h5yfsx63kfxdhzvw98vlqpn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-juniper-codegen" ,rust-juniper-codegen-0.14)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2)
        ("rust-uuid" ,rust-uuid-0.7))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/graphql-rust/juniper")
    (synopsis "GraphQL server library for Rust")
    (description
     "Juniper makes it possible to write GraphQL servers in Rust that are
type-safe and fast.  It also tries to make declaring and resolving GraphQL
schemas convenient.

Juniper does not include a web server.  Instead it provides building blocks to
make integration with existing servers straightforward.  It optionally
provides a pre-built integration for the Actix, Hyper, Iron, Rocket, and Warp
frameworks, including embedded Graphiql and GraphQL Playground for easy
debugging.")
    (license license:bsd-2)))

(define-public rust-keccak-0.1
  (package
    (name "rust-keccak")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "keccak" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "19ybbvxrdk9yy65rk7f5ad0hcxszkjwph68yzkj3954lnir1bhk7"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://crates.io/crates/keccak")
    (synopsis "Keccak-f sponge function for Rust")
    (description "This package provides a keccak-f sponge function")
    (license license:cc0)))

(define-public rust-kernel32-sys-0.2
  (package
    (name "rust-kernel32-sys")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "kernel32-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1389av0601a9yz8dvx5zha9vmkd6ik7ax0idpb032d28555n41vm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.2)
        ("rust-winapi-build" ,rust-winapi-build-0.1))))
    (home-page "https://github.com/retep998/winapi-rs")
    (synopsis "Function definitions for the Windows API library kernel32")
    (description "Contains function definitions for the Windows API library
kernel32.")
    (license license:expat)))

(define-public rust-khronos-api-3
  (package
    (name "rust-khronos-api")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "khronos-api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1p0xj5mlbagqyvvnv8wmv3cr7l9y1m153888pxqwg3vk3mg5inz2"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/brendanzab/gl-rs/")
    (synopsis "Khronos XML API Registry")
    (description
     "The Khronos XML API Registry, exposed as byte string constants.")
    (license license:asl2.0)))

(define-public rust-kqueue-sys-1
  (package
    (name "rust-kqueue-sys")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "kqueue-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11z5labbms9vn9m6csi5383dmrlmdgsxq13ls9fwa6zhi5a5hrw3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build?
       #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1) ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://gitlab.com/worr/rust-kqueue-sys")
    (synopsis "Low-level kqueue interface for BSDs")
    (description "This package provides a low-level kqueue interface for BSDs.")
    (license license:expat)))

(define-public rust-kqueue-1
  (package
    (name "rust-kqueue")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "kqueue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ad4vifr0kmla8a5pgig7plx5kmc9w7k1h9mgm6fk2sgg1x112h5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-kqueue-sys" ,rust-kqueue-sys-1) ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://gitlab.com/worr/rust-kqueue")
    (synopsis "kqueue interface for BSDs")
    (description "This package provides a kqueue interface for BSDs.")
    (license license:expat)))

(define-public rust-kstring-2
  (package
    (name "rust-kstring")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "kstring" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0isp7kmk4q0qxpcd877q77ykgb3ryfbmj18djmnwv8c210sncc7c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t                 ; Uses unstable features.
       #:cargo-inputs
       (("rust-document-features" ,rust-document-features-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-static-assertions" ,rust-static-assertions-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-proptest" ,rust-proptest-1))))
    (home-page "https://github.com/cobalt-org/kstring")
    (synopsis "String optimized for map keys")
    (description "Key String provides a Rust package optimized for map keys.")
    (license (list license:expat license:asl2.0))))

(define-public rust-kv-log-macro-1
  (package
    (name "rust-kv-log-macro")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "kv-log-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zwp4bxkkp87rl7xy2dain77z977rvcry1gmr5bssdbn541v7s0d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4))
       #:cargo-development-inputs
       (("rust-femme" ,rust-femme-1))))
    (home-page "https://github.com/yoshuawuyts/kv-log-macro")
    (synopsis "Log macro for log's kv-unstable backend")
    (description
     "This package provides a Log macro for log's kv-unstable backend.")
    (license (list license:expat license:asl2.0))))

(define-public rust-language-tags-0.3
  (package
    (name "rust-language-tags")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "language-tags" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "124k6w9nx33q4xs8rpa9f7klshrsa0x4f7qngdwq890lpdj5jd6l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/pyfisch/rust-language-tags")
    (synopsis "Language tags for Rust")
    (description
     "Language tags can be used identify human languages, scripts e.g. Latin
script, countries and other regions.  They are commonly used in HTML and HTTP
@code{Content-Language} and @code{Accept-Language} header fields.  This package
currently supports parsing (fully conformant parser), formatting and comparing
language tags.")
    (license license:expat)))

(define-public rust-language-tags-0.2
  (package
    (inherit rust-language-tags-0.3)
    (name "rust-language-tags")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "language-tags" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "16hrjdpa827carq5x4b8zhas24d8kg4s16m6nmmn1kb7cr5qh7d9"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-heapsize" ,rust-heapsize-0.3)
        ("rust-heapsize-plugin" ,rust-heapsize-plugin-0.1))))))

(define-public rust-lab-0.11
  (package
    (name "rust-lab")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lab" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "13ymsn5cwl5i9pmp5mfmbap7q688dcp9a17q82crkvb784yifdmz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.5)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.7)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/TooManyBees/lab")
    (synopsis "Convert RGB to CIE-LAB for Rust")
    (description
     "This package contains tools for converting RGB colors to the CIE-LAB color
space, and comparing differences in color.")
    (license license:expat)))

(define-public rust-lalrpop-0.19
  (package
    (name "rust-lalrpop")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lalrpop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j52sybjhn82ydgsmnw7nkywjyb7pvg50mvyb48m7vdq3wcmdyv0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
      (("rust-ascii-canvas" ,rust-ascii-canvas-2)
       ("rust-atty" ,rust-atty-0.2)
       ("rust-bit-set" ,rust-bit-set-0.5)
       ("rust-diff" ,rust-diff-0.1)
       ("rust-docopt" ,rust-docopt-1)
       ("rust-ena" ,rust-ena-0.14)
       ("rust-itertools" ,rust-itertools-0.9)
       ("rust-lalrpop-util" ,rust-lalrpop-util-0.19)
       ("rust-petgraph" ,rust-petgraph-0.5)
       ("rust-regex" ,rust-regex-1)
       ("rust-regex-syntax" ,rust