/*
  This file is part of TALER
  Copyright (C) 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-exchange-httpd_withdraw.h
 * @brief Handle /withdraw requests
 * @note This endpoint was introduced in v26 of the protocol.
 * @author Özgür Kesim
 */
#ifndef TALER_EXCHANGE_HTTPD_WITHDRAW_H
#define TALER_EXCHANGE_HTTPD_WITHDRAW_H

#include <microhttpd.h>
#include "taler-exchange-httpd.h"

/**
 * Resume suspended connections, we are shutting down.
 */
void
TEH_withdraw_cleanup (void);

/**
 * @brief Handle a "/withdraw" request.
 * @note This endpoint was introduced in v24 of the protocol.
 *
 * Parses the batch of requested "denom_pub" which specifies
 * the key/value of the respective coin to be withdrawn,
 * and checks the signature "reserve_sig" for given "reserve_pub"
 * makes this a valid withdrawal request from the specific reserve.
 * If the "max_age" value is set in the request,
 * it is considered a commitment to withdraw age restricted coins.
 * If the request is valid, the response contains a  noreveal_index
 * which the client has to use for the subsequent call to /reveal-withdraw.
 * If "max_age" value is not set, and the request is valid, the envelopes
 * with the blinded coins "blinded_coin_evs" is processed
 * and the client receives the blinded signatures as response.
 *
 * @param rc request context
 * @param root uploaded JSON data
 * @param args array of additional options, not used.
 * @return MHD result code
  */
MHD_RESULT
TEH_handler_withdraw (
  struct TEH_RequestContext *rc,
  const json_t *root,
  const char *const args[0]);

#endif
