/*
  This file is part of TALER
  (C) 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_post-reports-ID.h
 * @brief headers for POST /reports handler
 * @author Christian Grothoff
 */
#ifndef TALER_EXCHANGE_HTTPD_POST_REPORTS_ID_H
#define TALER_EXCHANGE_HTTPD_POST_REPORTS_ID_H
#include <microhttpd.h>
#include "taler-merchant-httpd.h"


/**
 * Handles a POST /reports/$REPORT_ID request.
 *
 * @param rc request context
 * @param root uploaded JSON data
 * @param args array of additional options (first must be the report_id)
 * @return MHD result code
 */
MHD_RESULT
TMH_post_reports_ID (
  const struct TMH_RequestHandler *rh,
  struct MHD_Connection *connection,
  struct TMH_HandlerContext *hc);

#endif
