/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_money_pot.c
 * @brief Implementation of the select_money_pot function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_select_money_pot.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_select_money_pot (void *cls,
                         const char *instance_id,
                         uint64_t money_pot_id,
                         char **name,
                         char **description,
                         size_t *pot_total_len,
                         struct TALER_Amount **pot_totals)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_uint64 (&money_pot_id),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_string ("money_pot_name",
                                  name),
    GNUNET_PQ_result_spec_string ("money_pot_description",
                                  description),
    TALER_PQ_result_spec_array_amount_with_currency (pg->conn,
                                                     "pot_totals",
                                                     pot_total_len,
                                                     pot_totals),
    GNUNET_PQ_result_spec_end
  };

  check_connection (pg);
  PREPARE (pg,
           "select_money_pot",
           "SELECT"
           "  mp.money_pot_name"
           " ,mp.money_pot_description"
           " ,mp.pot_totals"
           " FROM merchant_money_pots mp"
           " JOIN merchant_instances mi"
           "   USING (merchant_serial)"
           " WHERE merchant_id=$1"
           "   AND money_pot_serial=$2;");
  return GNUNET_PQ_eval_prepared_singleton_select (
    pg->conn,
    "select_money_pot",
    params,
    rs);
}
