// Copyright (C) 2017-2025 Internet Systems Consortium, Inc. ("ISC")
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#include <config.h>

#include <cc/command_interpreter.h>
#include <cc/data.h>
#include <cc/simple_parser.h>
#include <config/testutils/socket_path.h>
#include <dhcp/testutils/iface_mgr_test_config.h>
#include <dhcp6/ctrl_dhcp6_srv.h>
#include <dhcp6/dhcp6_srv.h>
#include <dhcp6/json_config_parser.h>
#include <dhcp6/tests/dhcp6_test_utils.h>
#include <dhcp6/tests/get_config_unittest.h>
#include <dhcpsrv/cfgmgr.h>
#include <util/filesystem.h>
#include <testutils/gtest_utils.h>
#include <testutils/user_context_utils.h>

#include <iostream>
#include <list>
#include <sstream>
#include <string>

#include <boost/algorithm/string.hpp>

#include <gtest/gtest.h>

using namespace isc::config;
using namespace isc::config::test;
using namespace isc::data;
using namespace isc::dhcp;
using namespace isc::dhcp::test;
using namespace isc::test;
using namespace isc::util;

namespace {

/// @name How to fill configurations
///
/// Copy get_config_unittest.cc.skel into get_config_unittest.cc
///
/// For the extracted configurations define the EXTRACT_CONFIG and
/// recompile this file. Run dhcp6_unittests on Dhcp6ParserTest
/// redirecting the standard error to a temporary file, e.g. by
/// @code
///    ./dhcp6_unittests --gtest_filter="Dhcp6Parser*" > /dev/null 2> x
/// @endcode
///
/// Update EXTRACTED_CONFIGS with the file content
///
/// When configurations have been extracted the corresponding unparsed
/// configurations must be generated. To do that define GENERATE_ACTION
/// and recompile this file. Run dhcp6_unittests on Dhcp6GetConfigTest
/// redirecting the standard error to a temporary file, e.g. by
/// @code
///    ./dhcp6_unittests --gtest_filter="Dhcp6GetConfig*" > /dev/null 2> u
/// @endcode
///
/// Update UNPARSED_CONFIGS with the file content, recompile this file
/// without EXTRACT_CONFIG and GENERATE_ACTION.
///
/// @note Check for failures at each step!
/// @note The tests of this file do not check if configs returned
/// by @ref isc::dhcp::CfgToElement::ToElement() are complete.
/// This has to be done manually.
///
///@{
/// @brief extracted configurations
const char* EXTRACTED_CONFIGS[] = {
/// put this after const char* EXTRACTED_CONFIGS[] = {
    // CONFIGURATION 0
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"rebind-timer\": 2000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::/64\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 1
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::/64\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 2
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [ ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 3
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"max-preferred-lifetime\": 4000,\n"
"        \"max-valid-lifetime\": 5000,\n"
"        \"min-preferred-lifetime\": 2000,\n"
"        \"min-valid-lifetime\": 3000,\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 4
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1024,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 100,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 34,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:4::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 5
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 3,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 4,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:4::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 6
"{\n"
"        \"compatibility\": {\n"
"            \"lenient-option-parsing\": true\n"
"        },\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 7
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"max-preferred-lifetime\": 4000,\n"
"        \"max-valid-lifetime\": 5000,\n"
"        \"min-preferred-lifetime\": 2000,\n"
"        \"min-valid-lifetime\": 3000,\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 4,\n"
"                \"max-valid-lifetime\": 5,\n"
"                \"min-preferred-lifetime\": 2,\n"
"                \"min-valid-lifetime\": 3,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3,\n"
"                \"rebind-timer\": 2,\n"
"                \"renew-timer\": 1,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"valid-lifetime\": 4\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 8
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"interface\": \"eth0\",\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 9
"{\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"interface-id\": \"foobar\",\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 10
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/96\"\n"
"                    },\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1:0:abcd::/112\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::1 - 2001:db8:2::ff\"\n"
"                    },\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::300 - 2001:db8:2::3ff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 11
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 12
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 128,\n"
"                        \"prefix\": \"2001:db8:1::\",\n"
"                        \"prefix-len\": 64\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 13
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"excluded-prefix\": \"3000:0:0:0:1000::\",\n"
"                        \"excluded-prefix-len\": 72,\n"
"                        \"prefix\": \"3000::\",\n"
"                        \"prefix-len\": 48\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 14
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 80,\n"
"                        \"prefix\": \"2001:db8:1:01::\",\n"
"                        \"prefix-len\": 72\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 88,\n"
"                        \"prefix\": \"2001:db8:1:02::\",\n"
"                        \"prefix-len\": 72\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 96,\n"
"                        \"prefix\": \"3000:1:03::\",\n"
"                        \"prefix-len\": 72\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1:04::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/40\",\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 15
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8:1::\",\n"
"                        \"prefix-len\": 64\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 16
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv6-address\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 17
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"uint16, ipv4-address, ipv6-address, string\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"record\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 18
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            },\n"
"            {\n"
"                \"code\": 101,\n"
"                \"name\": \"foo-2\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv4-address\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 19
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": true,\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 20
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"sub-opts-space\",\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 21
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"dhcp6\",\n"
"                \"type\": \"string\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 22
"{\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 63,\n"
"                \"name\": \"geolocation\",\n"
"                \"space\": \"dhcp6\",\n"
"                \"type\": \"string\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 23
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"subscriber-id\"\n"
"            },\n"
"            {\n"
"                \"data\": \"01\",\n"
"                \"name\": \"preference\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 24
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"ABCDEF0105\",\n"
"                        \"name\": \"subscriber-id\"\n"
"                    },\n"
"                    {\n"
"                        \"data\": \"01\",\n"
"                        \"name\": \"preference\"\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 25
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"subscriber-id\"\n"
"            },\n"
"            {\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 38,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 26
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\"\n"
"            },\n"
"            {\n"
"                \"data\": \"192.168.2.1\",\n"
"                \"name\": \"foo2\",\n"
"                \"space\": \"isc\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 110,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            },\n"
"            {\n"
"                \"code\": 111,\n"
"                \"name\": \"foo2\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv4-address\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 27
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"data\": \"11\",\n"
"                \"name\": \"base-option\"\n"
"            },\n"
"            {\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\"\n"
"            },\n"
"            {\n"
"                \"data\": \"192.168.2.1\",\n"
"                \"name\": \"foo2\",\n"
"                \"space\": \"isc\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"isc\",\n"
"                \"name\": \"base-option\",\n"
"                \"space\": \"dhcp6\",\n"
"                \"type\": \"uint8\"\n"
"            },\n"
"            {\n"
"                \"code\": 110,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            },\n"
"            {\n"
"                \"code\": 111,\n"
"                \"name\": \"foo2\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv4-address\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 28
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"csv-format\": false,\n"
"                \"data\": \"AB\",\n"
"                \"name\": \"subscriber-id\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"ABCDEF0105\",\n"
"                        \"name\": \"subscriber-id\"\n"
"                    },\n"
"                    {\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"FFFEFDFCFB\",\n"
"                        \"name\": \"user-class\"\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 29
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"0102030405060708090A\",\n"
"                        \"name\": \"subscriber-id\"\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"FFFEFDFCFB\",\n"
"                        \"name\": \"user-class\"\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 30
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"0102030405060708090A\",\n"
"                                \"name\": \"subscriber-id\"\n"
"                            },\n"
"                            {\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"FFFEFDFCFB\",\n"
"                                \"name\": \"user-class\"\n"
"                            }\n"
"                        ],\n"
"                        \"pool\": \"2001:db8:1::10 - 2001:db8:1::100\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 31
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"112233445566\",\n"
"                                \"name\": \"subscriber-id\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefix\": \"3000::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"aabbccddee\",\n"
"                                \"name\": \"user-class\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefix\": \"3001::\",\n"
"                        \"prefix-len\": 48\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"0102030405060708090A\",\n"
"                                \"name\": \"subscriber-id\"\n"
"                            }\n"
"                        ],\n"
"                        \"pool\": \"2001:db8:1::10 - 2001:db8:1::100\"\n"
"                    },\n"
"                    {\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"FFFEFDFCFB\",\n"
"                                \"name\": \"user-class\"\n"
"                            }\n"
"                        ],\n"
"                        \"pool\": \"2001:db8:1::300 - 2001:db8:1::400\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 32
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"option-one\",\n"
"                \"space\": \"vendor-4491\"\n"
"            },\n"
"            {\n"
"                \"code\": 100,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"option-two\",\n"
"                \"space\": \"vendor-1234\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 33
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"data\": \"this is a string vendor-opt\",\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"vendor-4491\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"vendor-4491\",\n"
"                \"type\": \"string\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 34
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"eth0\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 35
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"eth0\", \"eth1\", \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 36
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rebind-timer\": 2,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ \"2001:db8:1::abcd\" ]\n"
"                },\n"
"                \"renew-timer\": 1,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"valid-lifetime\": 4\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 37
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rebind-timer\": 2,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ \"2001:db9::abcd\", \"2001:db9::abce\" ]\n"
"                },\n"
"                \"renew-timer\": 1,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"valid-lifetime\": 4\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 38
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"client-classes\": [ \"alpha\" ],\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"client-classes\": [ \"beta\" ],\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            },\n"
"            {\n"
"                \"client-classes\": [ \"gamma\" ],\n"
"                \"id\": 3,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 4,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:4::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 39
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"client-classes\": [ \"alpha\" ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"beta\" ],\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"gamma\" ],\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    },\n"
"                    {\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:0::/40\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 40
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"client-classes\": [ \"alpha\" ],\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8:1::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"beta\" ],\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8:2::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"gamma\" ],\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8:3::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8:4::\",\n"
"                        \"prefix-len\": 48\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 41
"{\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": true,\n"
"            \"max-queue-size\": 2048,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"3001::2\",\n"
"            \"sender-port\": 778,\n"
"            \"server-ip\": \"3001::1\",\n"
"            \"server-port\": 777\n"
"        },\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 42
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 123,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"reservations\": [ ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 234,\n"
"                \"pools\": [ ],\n"
"                \"reservations\": [\n"
"                    {\n"
"                        \"duid\": \"01:02:03:04:05:06:07:08:09:0A\",\n"
"                        \"hostname\": \"\",\n"
"                        \"ip-addresses\": [ \"2001:db8:2::1234\" ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"data\": \"2001:db8:2::1111\",\n"
"                                \"name\": \"dns-servers\"\n"
"                            },\n"
"                            {\n"
"                                \"data\": \"11\",\n"
"                                \"name\": \"preference\"\n"
"                            }\n"
"                        ]\n"
"                    },\n"
"                    {\n"
"                        \"hostname\": \"\",\n"
"                        \"hw-address\": \"01:02:03:04:05:06\",\n"
"                        \"ip-addresses\": [ \"2001:db8:2::abcd\" ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"data\": \"2001:db8:2::abbc\",\n"
"                                \"name\": \"dns-servers\"\n"
"                            },\n"
"                            {\n"
"                                \"data\": \"25\",\n"
"                                \"name\": \"preference\"\n"
"                            }\n"
"                        ]\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 542,\n"
"                \"pools\": [ ],\n"
"                \"reservations\": [\n"
"                    {\n"
"                        \"duid\": \"0A:09:08:07:06:05:04:03:02:01\",\n"
"                        \"hostname\": \"\",\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"data\": \"2001:db8:3::3333\",\n"
"                                \"name\": \"dns-servers\"\n"
"                            },\n"
"                            {\n"
"                                \"data\": \"33\",\n"
"                                \"name\": \"preference\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefixes\": [ \"2001:db8:3:2::/96\" ]\n"
"                    },\n"
"                    {\n"
"                        \"hostname\": \"\",\n"
"                        \"hw-address\": \"06:05:04:03:02:01\",\n"
"                        \"prefixes\": [ \"2001:db8:3:1::/96\" ]\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 43
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 234,\n"
"                \"pools\": [ ],\n"
"                \"reservations\": [\n"
"                    {\n"
"                        \"duid\": \"01:02:03:04:05:06:07:08:09:0A\",\n"
"                        \"hostname\": \"\",\n"
"                        \"ip-addresses\": [ \"2001:db8:2::1234\" ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"data\": \"11\",\n"
"                                \"name\": \"foo\",\n"
"                                \"space\": \"isc\"\n"
"                            }\n"
"                        ]\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 44
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"mac-sources\": [ \"rfc6939\", \"rfc4649\", \"rfc4580\" ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [ ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 45
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"mac-sources\": [ \"client-link-addr-option\", \"remote-id\", \"subscriber-id\" ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [ ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 46
"{\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": false,\n"
"                \"subnet\": \"2001:db8:1::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": true,\n"
"                \"subnet\": \"2001:db8:2::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 3,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:3::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": false,\n"
"                \"subnet\": \"2001:db8:3::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 4,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:4::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": true,\n"
"                \"reservations-in-subnet\": false,\n"
"                \"subnet\": \"2001:db8:4::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 5,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:5::/64\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:5::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 6,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:6::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": true,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": false,\n"
"                \"subnet\": \"2001:db8:6::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 7,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:7::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": true,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": true,\n"
"                \"subnet\": \"2001:db8:7::/48\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 47
"{\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-out-of-pool\": true,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": false,\n"
"                \"subnet\": \"2001:db8:1::/48\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/48\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 48
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [ ]\n"
"    }\n",
    // CONFIGURATION 49
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"dns-servers\", \"remote-id\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [ ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 50
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [ ]\n"
"    }\n",
    // CONFIGURATION 51
"{\n"
"        \"decline-probation-period\": 12345,\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [ ]\n"
"    }\n",
    // CONFIGURATION 52
"{\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 35,\n"
"            \"hold-reclaimed-time\": 1800,\n"
"            \"max-reclaim-leases\": 50,\n"
"            \"max-reclaim-time\": 100,\n"
"            \"reclaim-timer-wait-time\": 20,\n"
"            \"unwarned-reclaim-cycles\": 10\n"
"        },\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [ ]\n"
"    }\n",
    // CONFIGURATION 53
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"one\"\n"
"            },\n"
"            {\n"
"                \"name\": \"two\"\n"
"            },\n"
"            {\n"
"                \"name\": \"three\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 54
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::1 - 2001:db8::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/64\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 55
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"template-test\": \"''\",\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"template-test\": \"''\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::1 - 2001:db8::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/64\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 56
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::/64\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 57
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": { }\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 58
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 59
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 60
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:: - 2001:db8::ffff:ffff:ffff:ffff\",\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 61
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8::\",\n"
"                        \"prefix-len\": 56\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 62
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8::\",\n"
"                        \"prefix-len\": 56,\n"
"                        \"user-context\": { }\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 63
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"prefix\": \"2001:db8::\",\n"
"                        \"prefix-len\": 56,\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 64
"{\n"
"        \"hosts-databases\": [\n"
"            {\n"
"                \"name\": \"keatest1\",\n"
"                \"password\": \"keatest\",\n"
"                \"type\": \"mysql\",\n"
"                \"user\": \"keatest\"\n"
"            },\n"
"            {\n"
"                \"name\": \"keatest2\",\n"
"                \"password\": \"keatest\",\n"
"                \"retry-on-startup\": true,\n"
"                \"type\": \"mysql\",\n"
"                \"user\": \"keatest\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 65
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"all\",\n"
"                \"test\": \"'' == ''\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"match all\"\n"
"                }\n"
"            },\n"
"            {\n"
"                \"name\": \"none\"\n"
"            },\n"
"            {\n"
"                \"name\": \"both\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"a comment\",\n"
"                    \"version\": 1\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"control-sockets\": [\n"
"            {\n"
"                \"socket-name\": \"kea6-ctrl-socket\",\n"
"                \"socket-type\": \"unix\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"Indirect comment\"\n"
"                }\n"
"            },\n"
"            {\n"
"                \"authentication\": {\n"
"                    \"clients\": [\n"
"                        {\n"
"                            \"password\": \"foobar\",\n"
"                            \"user\": \"admin\",\n"
"                            \"user-context\": {\n"
"                                \"comment\": \"admin is authorized\"\n"
"                            }\n"
"                        }\n"
"                    ],\n"
"                    \"type\": \"basic\",\n"
"                    \"user-context\": {\n"
"                        \"comment\": \"basic HTTP authentication\"\n"
"                    }\n"
"                },\n"
"                \"http-headers\": [\n"
"                    {\n"
"                        \"name\": \"Strict-Transport-Security\",\n"
"                        \"user-context\": {\n"
"                            \"comment\": \"HSTS header\"\n"
"                        },\n"
"                        \"value\": \"max-age=31536000\"\n"
"                    }\n"
"                ],\n"
"                \"socket-address\": \"127.0.0.1\",\n"
"                \"socket-port\": 8000,\n"
"                \"socket-type\": \"http\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"HTTP control socket\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"user-context\": {\n"
"                \"comment\": \"No dynamic DNS\"\n"
"            }\n"
"        },\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false,\n"
"            \"user-context\": {\n"
"                \"comment\": \"Use wildcard\"\n"
"            }\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"subscriber-id\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"Set option value\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"code\": 100,\n"
"                \"name\": \"foo\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv6-address\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"An option definition\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"server-id\": {\n"
"            \"type\": \"LL\",\n"
"            \"user-context\": {\n"
"                \"comment\": \"DHCPv6 specific\"\n"
"            }\n"
"        },\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"name\": \"foo\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"id\": 100,\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"delegated-len\": 64,\n"
"                                \"prefix\": \"2001:db2::\",\n"
"                                \"prefix-len\": 48,\n"
"                                \"user-context\": {\n"
"                                    \"comment\": \"A prefix pool\"\n"
"                                }\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"pool\": \"2001:db1::/64\",\n"
"                                \"user-context\": {\n"
"                                    \"comment\": \"A pool\"\n"
"                                }\n"
"                            }\n"
"                        ],\n"
"                        \"reservations\": [\n"
"                            {\n"
"                                \"hostname\": \"foo.example.com\",\n"
"                                \"hw-address\": \"AA:BB:CC:DD:EE:FF\",\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\",\n"
"                                        \"user-context\": {\n"
"                                            \"comment\": \"An option in a reservation\"\n"
"                                        }\n"
"                                    }\n"
"                                ],\n"
"                                \"user-context\": {\n"
"                                    \"comment\": \"A host reservation\"\n"
"                                }\n"
"                            }\n"
"                        ],\n"
"                        \"subnet\": \"2001:db1::/48\",\n"
"                        \"user-context\": {\n"
"                            \"comment\": \"A subnet\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"user-context\": {\n"
"                    \"comment\": \"A shared network\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"user-context\": {\n"
"            \"comment\": \"A DHCPv6 server\"\n"
"        }\n"
"    }\n",
    // CONFIGURATION 66
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations\": [\n"
"            {\n"
"                \"duid\": \"01:02:03:04:05:06:07:08:09:0A\",\n"
"                \"hostname\": \"\",\n"
"                \"ip-addresses\": [ \"2001:db8:2::1234\" ],\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"data\": \"2001:db8:2::1111\",\n"
"                        \"name\": \"dns-servers\"\n"
"                    },\n"
"                    {\n"
"                        \"data\": \"11\",\n"
"                        \"name\": \"preference\"\n"
"                    }\n"
"                ]\n"
"            },\n"
"            {\n"
"                \"hostname\": \"\",\n"
"                \"hw-address\": \"01:02:03:04:05:06\",\n"
"                \"ip-addresses\": [ \"2001:db8:2::abcd\" ],\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"data\": \"2001:db8:2::abbc\",\n"
"                        \"name\": \"dns-servers\"\n"
"                    },\n"
"                    {\n"
"                        \"data\": \"25\",\n"
"                        \"name\": \"preference\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 123,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"reservations\": [ ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 234,\n"
"                \"pools\": [ ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 542,\n"
"                \"pools\": [ ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 67
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"calculate-tee-times\": true,\n"
"                \"name\": \"foo\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"calculate-tee-times\": false,\n"
"                        \"id\": 100,\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"pool\": \"2001:db8:1::/80\"\n"
"                            }\n"
"                        ],\n"
"                        \"subnet\": \"2001:db8:1::/64\",\n"
"                        \"t1-percent\": 0.45,\n"
"                        \"t2-percent\": 0.65\n"
"                    },\n"
"                    {\n"
"                        \"id\": 200,\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"pool\": \"2001:db8:2::/80\"\n"
"                            }\n"
"                        ],\n"
"                        \"subnet\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.4,\n"
"                \"t2-percent\": 0.75\n"
"            }\n"
"        ],\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 300,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 68
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::1 - 2001:db8:2::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"store-extended-info\": true,\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 69
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"store-extended-info\": true,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::1 - 2001:db8:2::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 70
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"statistic-default-sample-age\": 5,\n"
"        \"statistic-default-sample-count\": 10,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 71
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [ ]\n"
"    }\n",
    // CONFIGURATION 72
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 1024,\n"
"            \"thread-pool-size\": 48\n"
"        },\n"
"        \"subnet6\": [ ]\n"
"    }\n",
    // CONFIGURATION 73
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-preferred-lifetime\": 6000,\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-preferred-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"preferred-lifetime\": 5000,\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 74
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-preferred-lifetime\": 6000,\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-preferred-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"preferred-lifetime\": 5000,\n"
"                \"template-test\": \"''\",\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"template-test\": \"''\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            }\n"
"        ]\n"
"    }\n",
    // CONFIGURATION 75
"{\n"
"        \"ddns-conflict-resolution-mode\": \"no-check-with-dhcid\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:1::1 - 2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:1::/64\"\n"
"            },\n"
"            {\n"
"                \"ddns-conflict-resolution-mode\": \"check-exists-with-dhcid\",\n"
"                \"id\": 2,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:2::1 - 2001:db8:2::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:2::/64\"\n"
"            },\n"
"            {\n"
"                \"ddns-conflict-resolution-mode\": \"no-check-without-dhcid\",\n"
"                \"id\": 3,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:3::1 - 2001:db8:3::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:3::/64\"\n"
"            },\n"
"            {\n"
"                \"ddns-conflict-resolution-mode\": \"no-check-with-dhcid\",\n"
"                \"id\": 4,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:4::1 - 2001:db8:4::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:4::/64\"\n"
"            },\n"
"            {\n"
"                \"id\": 5,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"pool\": \"2001:db8:5::1 - 2001:db8:5::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8:5::/64\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 76
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"foo\",\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"client-classes\": [ \"in-class\" ],\n"
"                        \"data\": \"example.com\",\n"
"                        \"name\": \"domain-search\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"client-classes\": [ \"in-global\" ],\n"
"                \"data\": \"example.com\",\n"
"                \"name\": \"domain-search\"\n"
"            }\n"
"        ],\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"name\": \"foo\",\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"client-classes\": [ \"in-network\" ],\n"
"                        \"data\": \"example.com\",\n"
"                        \"name\": \"domain-search\"\n"
"                    }\n"
"                ],\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"id\": 1,\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"client-classes\": [ \"in-subnet\" ],\n"
"                                \"data\": \"example.com\",\n"
"                                \"name\": \"domain-search\"\n"
"                            }\n"
"                        ],\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"delegated-len\": 64,\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"client-classes\": [ \"in-pd-pool\" ],\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\"\n"
"                                    }\n"
"                                ],\n"
"                                \"prefix\": \"3001:db8::\",\n"
"                                \"prefix-len\": 56\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"client-classes\": [ \"in-pool\" ],\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\"\n"
"                                    }\n"
"                                ],\n"
"                                \"pool\": \"2001:db8::/64\"\n"
"                            }\n"
"                        ],\n"
"                        \"reservations\": [\n"
"                            {\n"
"                                \"hw-address\": \"AA:BB:CC:DD:EE:FF\",\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"client-classes\": [ \"in-reservation\" ],\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\"\n"
"                                    }\n"
"                                ]\n"
"                            }\n"
"                        ],\n"
"                        \"subnet\": \"2001:db8::/32\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 77
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"client-classes\": [ \"foo\", \"bar\", \"foo\", \"bar\" ],\n"
"                \"data\": \"example.com\",\n"
"                \"name\": \"domain-search\"\n"
"            }\n"
"        ],\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [ ],\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 78
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"name\": \"net1\",\n"
"                \"require-client-classes\": [ \"one\" ],\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"id\": 1,\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"delegated-len\": 64,\n"
"                                \"prefix\": \"3001:db8::\",\n"
"                                \"prefix-len\": 56,\n"
"                                \"require-client-classes\": [ \"four\" ]\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"pool\": \"2001:db8::/64\",\n"
"                                \"require-client-classes\": [ \"three\" ]\n"
"                            }\n"
"                        ],\n"
"                        \"require-client-classes\": [ \"two\" ],\n"
"                        \"subnet\": \"2001:db8::/64\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 79
"{\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"foo\",\n"
"                \"only-if-required\": true\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"subnet6\": [ ],\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 80
"{\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"rebind-timer\": 2000,\n"
"        \"renew-timer\": 1000,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"client-class\": \"one\",\n"
"                \"name\": \"net1\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"client-class\": \"two\",\n"
"                        \"id\": 1,\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"client-class\": \"four\",\n"
"                                \"delegated-len\": 64,\n"
"                                \"prefix\": \"3001:db8::\",\n"
"                                \"prefix-len\": 56\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"client-class\": \"three\",\n"
"                                \"pool\": \"2001:db8::/64\"\n"
"                            }\n"
"                        ],\n"
"                        \"subnet\": \"2001:db8::/64\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 81
"{\n"
"        \"ddns-ttl-percent\": 0.75,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"ddns-ttl-percent\": 0.5,\n"
"                \"name\": \"net\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"ddns-ttl-percent\": 0.25,\n"
"                        \"id\": 1,\n"
"                        \"subnet\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 82
"{\n"
"        \"ddns-ttl\": 750,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"ddns-ttl\": 500,\n"
"                \"name\": \"net\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"ddns-ttl\": 250,\n"
"                        \"id\": 1,\n"
"                        \"subnet\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 83
"{\n"
"        \"ddns-ttl-min\": 750,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"ddns-ttl-min\": 500,\n"
"                \"name\": \"net\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"ddns-ttl-min\": 250,\n"
"                        \"id\": 1,\n"
"                        \"subnet\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 84
"{\n"
"        \"ddns-ttl-max\": 750,\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"ddns-ttl-max\": 500,\n"
"                \"name\": \"net\",\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"ddns-ttl-max\": 250,\n"
"                        \"id\": 1,\n"
"                        \"subnet\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 85
"{\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"id\": 1,\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"                        \"ddns-generated-prefix\": \"prefix\",\n"
"                        \"ddns-override-client-update\": true,\n"
"                        \"ddns-override-no-update\": true,\n"
"                        \"ddns-qualifying-suffix\": \"suffix\",\n"
"                        \"ddns-replace-client-name\": \"always\",\n"
"                        \"ddns-send-updates\": true,\n"
"                        \"ddns-ttl-max\": 500,\n"
"                        \"ddns-ttl-min\": 200,\n"
"                        \"ddns-ttl-percent\": 0.5,\n"
"                        \"ddns-update-on-renew\": true,\n"
"                        \"hostname-char-replacement\": \"X\",\n"
"                        \"hostname-char-set\": \"[a-z]\",\n"
"                        \"pool\": \"2001:db8:1::/64\"\n"
"                    },\n"
"                    {\n"
"                        \"ddns-ttl\": 300,\n"
"                        \"pool\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"subnet\": \"2001:db8::/32\"\n"
"            }\n"
"        ],\n"
"        \"valid-lifetime\": 4000\n"
"    }\n"
};

/// @brief unparsed configurations
const char* UNPARSED_CONFIGS[] = {
/// put this after const char* UNPARSED_CONFIGS[] = {
    // CONFIGURATION 0
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 1
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 2
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 3
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"max-preferred-lifetime\": 4000,\n"
"        \"max-valid-lifetime\": 5000,\n"
"        \"min-preferred-lifetime\": 2000,\n"
"        \"min-valid-lifetime\": 3000,\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 4000,\n"
"                \"max-valid-lifetime\": 5000,\n"
"                \"min-preferred-lifetime\": 2000,\n"
"                \"min-valid-lifetime\": 3000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 4
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 34,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:4::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 100,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1024,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 5
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 3,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 4,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:4::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 6
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"compatibility\": {\n"
"            \"lenient-option-parsing\": true\n"
"        },\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 7
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"max-preferred-lifetime\": 4000,\n"
"        \"max-valid-lifetime\": 5000,\n"
"        \"min-preferred-lifetime\": 2000,\n"
"        \"min-valid-lifetime\": 3000,\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 4,\n"
"                \"max-valid-lifetime\": 5,\n"
"                \"min-preferred-lifetime\": 2,\n"
"                \"min-valid-lifetime\": 3,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 8
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"interface\": \"eth0\",\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 9
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"interface-id\": \"foobar\",\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 10
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/96\"\n"
"                    },\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1:0:abcd::/112\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::1-2001:db8:2::ff\"\n"
"                    },\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::300/120\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 11
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 12
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 128,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:1::\",\n"
"                        \"prefix-len\": 64\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 13
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"excluded-prefix\": \"3000::1000:0:0:0\",\n"
"                        \"excluded-prefix-len\": 72,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"3000::\",\n"
"                        \"prefix-len\": 48\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 14
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 80,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:1:1::\",\n"
"                        \"prefix-len\": 72\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 88,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:1:2::\",\n"
"                        \"prefix-len\": 72\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 96,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"3000:1:3::\",\n"
"                        \"prefix-len\": 72\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/40\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 15
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:1::\",\n"
"                        \"prefix-len\": 64\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 16
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv6-address\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 17
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"uint16, ipv4-address, ipv6-address, string\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"record\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 18
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            },\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 101,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo-2\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv4-address\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 19
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": true,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 20
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"sub-opts-space\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 21
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"dhcp6\",\n"
"                \"type\": \"string\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 22
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 63,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"geolocation\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"dhcp6\",\n"
"                \"type\": \"string\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 23
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 38,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"subscriber-id\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            },\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 7,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"01\",\n"
"                \"name\": \"preference\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 24
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 38,\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"ABCDEF0105\",\n"
"                        \"name\": \"subscriber-id\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    },\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 7,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"01\",\n"
"                        \"name\": \"preference\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 25
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 38,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"subscriber-id\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            },\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 38,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"foo\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"isc\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 38,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 26
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 110,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"foo\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"isc\"\n"
"            },\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 111,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"192.168.2.1\",\n"
"                \"name\": \"foo2\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"isc\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 110,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            },\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 111,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo2\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv4-address\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 27
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 100,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"11\",\n"
"                \"name\": \"base-option\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            },\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 110,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"1234\",\n"
"                \"name\": \"foo\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"isc\"\n"
"            },\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 111,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"192.168.2.1\",\n"
"                \"name\": \"foo2\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"isc\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"isc\",\n"
"                \"name\": \"base-option\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"dhcp6\",\n"
"                \"type\": \"uint8\"\n"
"            },\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 110,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            },\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 111,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo2\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv4-address\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 28
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 38,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"AB\",\n"
"                \"name\": \"subscriber-id\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 38,\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"ABCDEF0105\",\n"
"                        \"name\": \"subscriber-id\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    },\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 15,\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"FFFEFDFCFB\",\n"
"                        \"name\": \"user-class\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 29
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 38,\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"0102030405060708090A\",\n"
"                        \"name\": \"subscriber-id\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 15,\n"
"                        \"csv-format\": false,\n"
"                        \"data\": \"FFFEFDFCFB\",\n"
"                        \"name\": \"user-class\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 30
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 38,\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"0102030405060708090A\",\n"
"                                \"name\": \"subscriber-id\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            },\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 15,\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"FFFEFDFCFB\",\n"
"                                \"name\": \"user-class\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"pool\": \"2001:db8:1::10-2001:db8:1::100\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 31
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 38,\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"112233445566\",\n"
"                                \"name\": \"subscriber-id\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefix\": \"3000::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 15,\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"AABBCCDDEE\",\n"
"                                \"name\": \"user-class\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefix\": \"3001::\",\n"
"                        \"prefix-len\": 48\n"
"                    }\n"
"                ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 38,\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"0102030405060708090A\",\n"
"                                \"name\": \"subscriber-id\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"pool\": \"2001:db8:1::10-2001:db8:1::100\"\n"
"                    },\n"
"                    {\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 15,\n"
"                                \"csv-format\": false,\n"
"                                \"data\": \"FFFEFDFCFB\",\n"
"                                \"name\": \"user-class\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"pool\": \"2001:db8:1::300-2001:db8:1::400\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 32
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 100,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"1234\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"vendor-1234\"\n"
"            },\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 100,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"vendor-4491\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 33
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 100,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"this is a string vendor-opt\",\n"
"                \"name\": \"foo\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"vendor-4491\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"vendor-4491\",\n"
"                \"type\": \"string\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 34
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"eth0\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 35
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\", \"eth0\", \"eth1\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 36
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ \"2001:db8:1::abcd\" ]\n"
"                },\n"
"                \"renew-timer\": 1,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 37
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ \"2001:db9::abcd\", \"2001:db9::abce\" ]\n"
"                },\n"
"                \"renew-timer\": 1,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 38
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"client-classes\": [ \"alpha\" ],\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"client-classes\": [ \"beta\" ],\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"client-classes\": [ \"gamma\" ],\n"
"                \"id\": 3,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 4,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:4::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 39
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"client-classes\": [ \"alpha\" ],\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"beta\" ],\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/80\"\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"gamma\" ],\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    },\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:4::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/40\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 40
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"client-classes\": [ \"alpha\" ],\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:1::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"beta\" ],\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:2::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ \"gamma\" ],\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:3::\",\n"
"                        \"prefix-len\": 48\n"
"                    },\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8:4::\",\n"
"                        \"prefix-len\": 48\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 41
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": true,\n"
"            \"max-queue-size\": 2048,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"3001::2\",\n"
"            \"sender-port\": 778,\n"
"            \"server-ip\": \"3001::1\",\n"
"            \"server-port\": 777\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 42
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 123,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 234,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [\n"
"                    {\n"
"                        \"client-classes\": [ ],\n"
"                        \"hostname\": \"\",\n"
"                        \"hw-address\": \"01:02:03:04:05:06\",\n"
"                        \"ip-addresses\": [ \"2001:db8:2::abcd\" ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 23,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"2001:db8:2::abbc\",\n"
"                                \"name\": \"dns-servers\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            },\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 7,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"25\",\n"
"                                \"name\": \"preference\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefixes\": [ ]\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ ],\n"
"                        \"duid\": \"01:02:03:04:05:06:07:08:09:0a\",\n"
"                        \"hostname\": \"\",\n"
"                        \"ip-addresses\": [ \"2001:db8:2::1234\" ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 23,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"2001:db8:2::1111\",\n"
"                                \"name\": \"dns-servers\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            },\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 7,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"11\",\n"
"                                \"name\": \"preference\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefixes\": [ ]\n"
"                    }\n"
"                ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 542,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [\n"
"                    {\n"
"                        \"client-classes\": [ ],\n"
"                        \"hostname\": \"\",\n"
"                        \"hw-address\": \"06:05:04:03:02:01\",\n"
"                        \"ip-addresses\": [ ],\n"
"                        \"option-data\": [ ],\n"
"                        \"prefixes\": [ \"2001:db8:3:1::/96\" ]\n"
"                    },\n"
"                    {\n"
"                        \"client-classes\": [ ],\n"
"                        \"duid\": \"0a:09:08:07:06:05:04:03:02:01\",\n"
"                        \"hostname\": \"\",\n"
"                        \"ip-addresses\": [ ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 23,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"2001:db8:3::3333\",\n"
"                                \"name\": \"dns-servers\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            },\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 7,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"33\",\n"
"                                \"name\": \"preference\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefixes\": [ \"2001:db8:3:2::/96\" ]\n"
"                    }\n"
"                ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 43
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"uint32\"\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 234,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [\n"
"                    {\n"
"                        \"client-classes\": [ ],\n"
"                        \"duid\": \"01:02:03:04:05:06:07:08:09:0a\",\n"
"                        \"hostname\": \"\",\n"
"                        \"ip-addresses\": [ \"2001:db8:2::1234\" ],\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"code\": 100,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"11\",\n"
"                                \"name\": \"foo\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"isc\"\n"
"                            }\n"
"                        ],\n"
"                        \"prefixes\": [ ]\n"
"                    }\n"
"                ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 44
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"client-link-addr-option\", \"remote-id\", \"subscriber-id\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 45
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"client-link-addr-option\", \"remote-id\", \"subscriber-id\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 46
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": false,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": true,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 3,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": false,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 4,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:4::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": true,\n"
"                \"reservations-in-subnet\": false,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:4::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 5,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:5::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:5::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 6,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:6::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": true,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": false,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:6::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 7,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:7::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": true,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": true,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:7::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 47
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": true,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"reservations-global\": false,\n"
"                \"reservations-in-subnet\": true,\n"
"                \"reservations-out-of-pool\": false,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/48\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 48
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 49
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"23\", \"37\", \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 50
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 51
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 12345,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 52
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 35,\n"
"            \"hold-reclaimed-time\": 1800,\n"
"            \"max-reclaim-leases\": 50,\n"
"            \"max-reclaim-time\": 100,\n"
"            \"reclaim-timer-wait-time\": 20,\n"
"            \"unwarned-reclaim-cycles\": 10\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 53
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"one\",\n"
"                \"option-data\": [ ]\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"option-data\": [ ]\n"
"            },\n"
"            {\n"
"                \"name\": \"three\",\n"
"                \"option-data\": [ ]\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 54
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"option-data\": [ ],\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"option-data\": [ ]\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 7200,\n"
"                \"min-valid-lifetime\": 7200,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::1-2001:db8::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 7200\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 55
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"option-data\": [ ],\n"
"                \"template-test\": \"''\",\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"option-data\": [ ],\n"
"                \"template-test\": \"''\"\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 7200,\n"
"                \"min-valid-lifetime\": 7200,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::1-2001:db8::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 7200\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 56
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 57
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": { }\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 58
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 59
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 60
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8::/64\",\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 61
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8::\",\n"
"                        \"prefix-len\": 56\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 62
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8::\",\n"
"                        \"prefix-len\": 56,\n"
"                        \"user-context\": { }\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 63
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [\n"
"                    {\n"
"                        \"delegated-len\": 64,\n"
"                        \"option-data\": [ ],\n"
"                        \"prefix\": \"2001:db8::\",\n"
"                        \"prefix-len\": 56,\n"
"                        \"user-context\": {\n"
"                            \"lw4over6-bind-prefix-len\": 56,\n"
"                            \"lw4over6-sharing-ratio\": 64,\n"
"                            \"lw4over6-sysports-exclude\": true,\n"
"                            \"lw4over6-v4-pool\": \"192.0.2.0/24\"\n"
"                        }\n"
"                    }\n"
"                ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 64
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"hosts-databases\": [\n"
"            {\n"
"                \"name\": \"keatest1\",\n"
"                \"password\": \"keatest\",\n"
"                \"type\": \"mysql\",\n"
"                \"user\": \"keatest\"\n"
"            },\n"
"            {\n"
"                \"name\": \"keatest2\",\n"
"                \"password\": \"keatest\",\n"
"                \"retry-on-startup\": true,\n"
"                \"type\": \"mysql\",\n"
"                \"user\": \"keatest\"\n"
"            }\n"
"        ],\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 65
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"all\",\n"
"                \"option-data\": [ ],\n"
"                \"test\": \"'' == ''\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"match all\"\n"
"                }\n"
"            },\n"
"            {\n"
"                \"name\": \"none\",\n"
"                \"option-data\": [ ]\n"
"            },\n"
"            {\n"
"                \"name\": \"both\",\n"
"                \"option-data\": [ ],\n"
"                \"user-context\": {\n"
"                    \"comment\": \"a comment\",\n"
"                    \"version\": 1\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"control-sockets\": [\n"
"            {\n"
"                \"socket-name\": \"kea6-ctrl-socket\",\n"
"                \"socket-type\": \"unix\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"Indirect comment\"\n"
"                }\n"
"            },\n"
"            {\n"
"                \"authentication\": {\n"
"                    \"clients\": [\n"
"                        {\n"
"                            \"password\": \"foobar\",\n"
"                            \"user\": \"admin\",\n"
"                            \"user-context\": {\n"
"                                \"comment\": \"admin is authorized\"\n"
"                            }\n"
"                        }\n"
"                    ],\n"
"                    \"realm\": \"kea-dhcpv6-server\",\n"
"                    \"type\": \"basic\",\n"
"                    \"user-context\": {\n"
"                        \"comment\": \"basic HTTP authentication\"\n"
"                    }\n"
"                },\n"
"                \"http-headers\": [\n"
"                    {\n"
"                        \"name\": \"Strict-Transport-Security\",\n"
"                        \"user-context\": {\n"
"                            \"comment\": \"HSTS header\"\n"
"                        },\n"
"                        \"value\": \"max-age=31536000\"\n"
"                    }\n"
"                ],\n"
"                \"socket-address\": \"127.0.0.1\",\n"
"                \"socket-port\": 8000,\n"
"                \"socket-type\": \"http\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"HTTP control socket\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001,\n"
"            \"user-context\": {\n"
"                \"comment\": \"No dynamic DNS\"\n"
"            }\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false,\n"
"            \"user-context\": {\n"
"                \"comment\": \"Use wildcard\"\n"
"            }\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"code\": 38,\n"
"                \"csv-format\": false,\n"
"                \"data\": \"ABCDEF0105\",\n"
"                \"name\": \"subscriber-id\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"Set option value\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"option-def\": [\n"
"            {\n"
"                \"array\": false,\n"
"                \"code\": 100,\n"
"                \"encapsulate\": \"\",\n"
"                \"name\": \"foo\",\n"
"                \"record-types\": \"\",\n"
"                \"space\": \"isc\",\n"
"                \"type\": \"ipv6-address\",\n"
"                \"user-context\": {\n"
"                    \"comment\": \"An option definition\"\n"
"                }\n"
"            }\n"
"        ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LL\",\n"
"            \"user-context\": {\n"
"                \"comment\": \"DHCPv6 specific\"\n"
"            }\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"max-valid-lifetime\": 7200,\n"
"                \"min-valid-lifetime\": 7200,\n"
"                \"name\": \"foo\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"id\": 100,\n"
"                        \"max-valid-lifetime\": 7200,\n"
"                        \"min-valid-lifetime\": 7200,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"delegated-len\": 64,\n"
"                                \"option-data\": [ ],\n"
"                                \"prefix\": \"2001:db2::\",\n"
"                                \"prefix-len\": 48,\n"
"                                \"user-context\": {\n"
"                                    \"comment\": \"A prefix pool\"\n"
"                                }\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"option-data\": [ ],\n"
"                                \"pool\": \"2001:db1::/64\",\n"
"                                \"user-context\": {\n"
"                                    \"comment\": \"A pool\"\n"
"                                }\n"
"                            }\n"
"                        ],\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [\n"
"                            {\n"
"                                \"client-classes\": [ ],\n"
"                                \"hostname\": \"foo.example.com\",\n"
"                                \"hw-address\": \"aa:bb:cc:dd:ee:ff\",\n"
"                                \"ip-addresses\": [ ],\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"always-send\": false,\n"
"                                        \"code\": 24,\n"
"                                        \"csv-format\": true,\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\",\n"
"                                        \"never-send\": false,\n"
"                                        \"space\": \"dhcp6\",\n"
"                                        \"user-context\": {\n"
"                                            \"comment\": \"An option in a reservation\"\n"
"                                        }\n"
"                                    }\n"
"                                ],\n"
"                                \"prefixes\": [ ],\n"
"                                \"user-context\": {\n"
"                                    \"comment\": \"A host reservation\"\n"
"                                }\n"
"                            }\n"
"                        ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db1::/48\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"user-context\": {\n"
"                            \"comment\": \"A subnet\"\n"
"                        },\n"
"                        \"valid-lifetime\": 7200\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"user-context\": {\n"
"                    \"comment\": \"A shared network\"\n"
"                },\n"
"                \"valid-lifetime\": 7200\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"user-context\": {\n"
"            \"comment\": \"A DHCPv6 server\"\n"
"        },\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 66
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations\": [\n"
"            {\n"
"                \"client-classes\": [ ],\n"
"                \"hostname\": \"\",\n"
"                \"hw-address\": \"01:02:03:04:05:06\",\n"
"                \"ip-addresses\": [ \"2001:db8:2::abcd\" ],\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 23,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"2001:db8:2::abbc\",\n"
"                        \"name\": \"dns-servers\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    },\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 7,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"25\",\n"
"                        \"name\": \"preference\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"prefixes\": [ ]\n"
"            },\n"
"            {\n"
"                \"client-classes\": [ ],\n"
"                \"duid\": \"01:02:03:04:05:06:07:08:09:0a\",\n"
"                \"hostname\": \"\",\n"
"                \"ip-addresses\": [ \"2001:db8:2::1234\" ],\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 23,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"2001:db8:2::1111\",\n"
"                        \"name\": \"dns-servers\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    },\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"code\": 7,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"11\",\n"
"                        \"name\": \"preference\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"prefixes\": [ ]\n"
"            }\n"
"        ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 123,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 234,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 542,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [ ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 67
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"name\": \"foo\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": false,\n"
"                        \"id\": 100,\n"
"                        \"max-preferred-lifetime\": 3000,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-preferred-lifetime\": 3000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [ ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"option-data\": [ ],\n"
"                                \"pool\": \"2001:db8:1::/80\"\n"
"                            }\n"
"                        ],\n"
"                        \"preferred-lifetime\": 3000,\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8:1::/64\",\n"
"                        \"t1-percent\": 0.45,\n"
"                        \"t2-percent\": 0.65,\n"
"                        \"valid-lifetime\": 4000\n"
"                    },\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"id\": 200,\n"
"                        \"max-preferred-lifetime\": 3000,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-preferred-lifetime\": 3000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [ ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"option-data\": [ ],\n"
"                                \"pool\": \"2001:db8:2::/80\"\n"
"                            }\n"
"                        ],\n"
"                        \"preferred-lifetime\": 3000,\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8:2::/64\",\n"
"                        \"t1-percent\": 0.4,\n"
"                        \"t2-percent\": 0.75,\n"
"                        \"valid-lifetime\": 4000\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.4,\n"
"                \"t2-percent\": 0.75,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 300,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::/80\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 68
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::1-2001:db8:2::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": true,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 69
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": true,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 2,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::1-2001:db8:2::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": true,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 70
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 5,\n"
"        \"statistic-default-sample-count\": 10,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 71
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 72
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 1024,\n"
"            \"thread-pool-size\": 48\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 73
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-preferred-lifetime\": 6000,\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-preferred-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"option-data\": [ ],\n"
"                \"preferred-lifetime\": 5000,\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"option-data\": [ ]\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 7200,\n"
"                \"min-valid-lifetime\": 7200,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 7200\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 74
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"max-preferred-lifetime\": 6000,\n"
"                \"max-valid-lifetime\": 3000,\n"
"                \"min-preferred-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 1000,\n"
"                \"name\": \"one\",\n"
"                \"option-data\": [ ],\n"
"                \"preferred-lifetime\": 5000,\n"
"                \"template-test\": \"''\",\n"
"                \"valid-lifetime\": 2000\n"
"            },\n"
"            {\n"
"                \"name\": \"two\",\n"
"                \"option-data\": [ ],\n"
"                \"template-test\": \"''\"\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 7200,\n"
"                \"min-valid-lifetime\": 7200,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 7200\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 7200\n"
"    }\n",
    // CONFIGURATION 75
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"no-check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::1-2001:db8:1::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:1::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-conflict-resolution-mode\": \"check-exists-with-dhcid\",\n"
"                \"id\": 2,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::1-2001:db8:2::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:2::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-conflict-resolution-mode\": \"no-check-without-dhcid\",\n"
"                \"id\": 3,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:3::1-2001:db8:3::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:3::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-conflict-resolution-mode\": \"no-check-with-dhcid\",\n"
"                \"id\": 4,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:4::1-2001:db8:4::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:4::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            },\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 5,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:5::1-2001:db8:5::ffff\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8:5::/64\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 76
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"foo\",\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"client-classes\": [ \"in-class\" ],\n"
"                        \"code\": 24,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"example.com\",\n"
"                        \"name\": \"domain-search\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ]\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"client-classes\": [ \"in-global\" ],\n"
"                \"code\": 24,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"example.com\",\n"
"                \"name\": \"domain-search\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"preferred-lifetime\": 3000,\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"max-preferred-lifetime\": 3000,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-preferred-lifetime\": 3000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"name\": \"foo\",\n"
"                \"option-data\": [\n"
"                    {\n"
"                        \"always-send\": false,\n"
"                        \"client-classes\": [ \"in-network\" ],\n"
"                        \"code\": 24,\n"
"                        \"csv-format\": true,\n"
"                        \"data\": \"example.com\",\n"
"                        \"name\": \"domain-search\",\n"
"                        \"never-send\": false,\n"
"                        \"space\": \"dhcp6\"\n"
"                    }\n"
"                ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"preferred-lifetime\": 3000,\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"id\": 1,\n"
"                        \"max-preferred-lifetime\": 3000,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-preferred-lifetime\": 3000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [\n"
"                            {\n"
"                                \"always-send\": false,\n"
"                                \"client-classes\": [ \"in-subnet\" ],\n"
"                                \"code\": 24,\n"
"                                \"csv-format\": true,\n"
"                                \"data\": \"example.com\",\n"
"                                \"name\": \"domain-search\",\n"
"                                \"never-send\": false,\n"
"                                \"space\": \"dhcp6\"\n"
"                            }\n"
"                        ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"delegated-len\": 64,\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"always-send\": false,\n"
"                                        \"client-classes\": [ \"in-pd-pool\" ],\n"
"                                        \"code\": 24,\n"
"                                        \"csv-format\": true,\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\",\n"
"                                        \"never-send\": false,\n"
"                                        \"space\": \"dhcp6\"\n"
"                                    }\n"
"                                ],\n"
"                                \"prefix\": \"3001:db8::\",\n"
"                                \"prefix-len\": 56\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"always-send\": false,\n"
"                                        \"client-classes\": [ \"in-pool\" ],\n"
"                                        \"code\": 24,\n"
"                                        \"csv-format\": true,\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\",\n"
"                                        \"never-send\": false,\n"
"                                        \"space\": \"dhcp6\"\n"
"                                    }\n"
"                                ],\n"
"                                \"pool\": \"2001:db8::/64\"\n"
"                            }\n"
"                        ],\n"
"                        \"preferred-lifetime\": 3000,\n"
"                        \"rebind-timer\": 2000,\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"renew-timer\": 1000,\n"
"                        \"reservations\": [\n"
"                            {\n"
"                                \"client-classes\": [ ],\n"
"                                \"hostname\": \"\",\n"
"                                \"hw-address\": \"aa:bb:cc:dd:ee:ff\",\n"
"                                \"ip-addresses\": [ ],\n"
"                                \"option-data\": [\n"
"                                    {\n"
"                                        \"always-send\": false,\n"
"                                        \"client-classes\": [ \"in-reservation\" ],\n"
"                                        \"code\": 24,\n"
"                                        \"csv-format\": true,\n"
"                                        \"data\": \"example.com\",\n"
"                                        \"name\": \"domain-search\",\n"
"                                        \"never-send\": false,\n"
"                                        \"space\": \"dhcp6\"\n"
"                                    }\n"
"                                ],\n"
"                                \"prefixes\": [ ]\n"
"                            }\n"
"                        ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8::/32\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 4000\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 77
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [\n"
"            {\n"
"                \"always-send\": false,\n"
"                \"client-classes\": [ \"foo\", \"bar\" ],\n"
"                \"code\": 24,\n"
"                \"csv-format\": true,\n"
"                \"data\": \"example.com\",\n"
"                \"name\": \"domain-search\",\n"
"                \"never-send\": false,\n"
"                \"space\": \"dhcp6\"\n"
"            }\n"
"        ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 78
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"evaluate-additional-classes\": [ \"one\" ],\n"
"                \"max-valid-lifetime\": 400,\n"
"                \"min-valid-lifetime\": 400,\n"
"                \"name\": \"net1\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"evaluate-additional-classes\": [ \"two\" ],\n"
"                        \"id\": 1,\n"
"                        \"max-valid-lifetime\": 400,\n"
"                        \"min-valid-lifetime\": 400,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"delegated-len\": 64,\n"
"                                \"evaluate-additional-classes\": [ \"four\" ],\n"
"                                \"option-data\": [ ],\n"
"                                \"prefix\": \"3001:db8::\",\n"
"                                \"prefix-len\": 56\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"evaluate-additional-classes\": [ \"three\" ],\n"
"                                \"option-data\": [ ],\n"
"                                \"pool\": \"2001:db8::/64\"\n"
"                            }\n"
"                        ],\n"
"                        \"rebind-timer\": 2000,\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"renew-timer\": 1000,\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8::/64\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 400\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 400\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 79
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"client-classes\": [\n"
"            {\n"
"                \"name\": \"foo\",\n"
"                \"only-in-additional-list\": true,\n"
"                \"option-data\": [ ]\n"
"            }\n"
"        ],\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 80
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ \"*\" ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"rebind-timer\": 2000,\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"renew-timer\": 1000,\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"client-classes\": [ \"one\" ],\n"
"                \"max-valid-lifetime\": 400,\n"
"                \"min-valid-lifetime\": 400,\n"
"                \"name\": \"net1\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"rebind-timer\": 2000,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"renew-timer\": 1000,\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"client-classes\": [ \"two\" ],\n"
"                        \"id\": 1,\n"
"                        \"max-valid-lifetime\": 400,\n"
"                        \"min-valid-lifetime\": 400,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [\n"
"                            {\n"
"                                \"client-classes\": [ \"four\" ],\n"
"                                \"delegated-len\": 64,\n"
"                                \"option-data\": [ ],\n"
"                                \"prefix\": \"3001:db8::\",\n"
"                                \"prefix-len\": 56\n"
"                            }\n"
"                        ],\n"
"                        \"pools\": [\n"
"                            {\n"
"                                \"client-classes\": [ \"three\" ],\n"
"                                \"option-data\": [ ],\n"
"                                \"pool\": \"2001:db8::/64\"\n"
"                            }\n"
"                        ],\n"
"                        \"rebind-timer\": 2000,\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"renew-timer\": 1000,\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8::/64\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 400\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 400\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 400\n"
"    }\n",
    // CONFIGURATION 81
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-ttl-percent\": 0.75,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-ttl-percent\": 0.5,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"name\": \"net\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"ddns-ttl-percent\": 0.25,\n"
"                        \"id\": 1,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [ ],\n"
"                        \"pools\": [ ],\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8:1::/64\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 4000\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 82
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-ttl\": 750,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-ttl\": 500,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"name\": \"net\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"ddns-ttl\": 250,\n"
"                        \"id\": 1,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [ ],\n"
"                        \"pools\": [ ],\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8:1::/64\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 4000\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 83
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-ttl-min\": 750,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-ttl-min\": 500,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"name\": \"net\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"ddns-ttl-min\": 250,\n"
"                        \"id\": 1,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [ ],\n"
"                        \"pools\": [ ],\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8:1::/64\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 4000\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 84
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-ttl-max\": 750,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"ddns-ttl-max\": 500,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"name\": \"net\",\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"store-extended-info\": false,\n"
"                \"subnet6\": [\n"
"                    {\n"
"                        \"allocator\": \"iterative\",\n"
"                        \"cache-threshold\": 0.25,\n"
"                        \"calculate-tee-times\": true,\n"
"                        \"ddns-ttl-max\": 250,\n"
"                        \"id\": 1,\n"
"                        \"max-valid-lifetime\": 4000,\n"
"                        \"min-valid-lifetime\": 4000,\n"
"                        \"option-data\": [ ],\n"
"                        \"pd-allocator\": \"iterative\",\n"
"                        \"pd-pools\": [ ],\n"
"                        \"pools\": [ ],\n"
"                        \"relay\": {\n"
"                            \"ip-addresses\": [ ]\n"
"                        },\n"
"                        \"reservations\": [ ],\n"
"                        \"store-extended-info\": false,\n"
"                        \"subnet\": \"2001:db8:1::/64\",\n"
"                        \"t1-percent\": 0.5,\n"
"                        \"t2-percent\": 0.8,\n"
"                        \"valid-lifetime\": 4000\n"
"                    }\n"
"                ],\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [ ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n",
    // CONFIGURATION 85
"{\n"
"        \"allocator\": \"iterative\",\n"
"        \"allow-address-registration\": true,\n"
"        \"cache-threshold\": 0.25,\n"
"        \"calculate-tee-times\": true,\n"
"        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"        \"ddns-generated-prefix\": \"myhost\",\n"
"        \"ddns-override-client-update\": false,\n"
"        \"ddns-override-no-update\": false,\n"
"        \"ddns-qualifying-suffix\": \"\",\n"
"        \"ddns-replace-client-name\": \"never\",\n"
"        \"ddns-send-updates\": true,\n"
"        \"ddns-update-on-renew\": false,\n"
"        \"decline-probation-period\": 86400,\n"
"        \"dhcp-ddns\": {\n"
"            \"enable-updates\": false,\n"
"            \"max-queue-size\": 1024,\n"
"            \"ncr-format\": \"JSON\",\n"
"            \"ncr-protocol\": \"UDP\",\n"
"            \"sender-ip\": \"0.0.0.0\",\n"
"            \"sender-port\": 0,\n"
"            \"server-ip\": \"127.0.0.1\",\n"
"            \"server-port\": 53001\n"
"        },\n"
"        \"dhcp-queue-control\": {\n"
"            \"capacity\": 64,\n"
"            \"enable-queue\": false,\n"
"            \"queue-type\": \"kea-ring6\"\n"
"        },\n"
"        \"dhcp4o6-port\": 0,\n"
"        \"early-global-reservations-lookup\": false,\n"
"        \"expired-leases-processing\": {\n"
"            \"flush-reclaimed-timer-wait-time\": 25,\n"
"            \"hold-reclaimed-time\": 3600,\n"
"            \"max-reclaim-leases\": 100,\n"
"            \"max-reclaim-time\": 250,\n"
"            \"reclaim-timer-wait-time\": 10,\n"
"            \"unwarned-reclaim-cycles\": 5\n"
"        },\n"
"        \"hooks-libraries\": [ ],\n"
"        \"host-reservation-identifiers\": [ \"hw-address\", \"duid\" ],\n"
"        \"hostname-char-replacement\": \"\",\n"
"        \"hostname-char-set\": \"[^A-Za-z0-9.-]\",\n"
"        \"interfaces-config\": {\n"
"            \"interfaces\": [ ],\n"
"            \"re-detect\": false\n"
"        },\n"
"        \"ip-reservations-unique\": true,\n"
"        \"lease-database\": {\n"
"            \"type\": \"memfile\"\n"
"        },\n"
"        \"mac-sources\": [ \"any\" ],\n"
"        \"multi-threading\": {\n"
"            \"enable-multi-threading\": true,\n"
"            \"packet-queue-size\": 64,\n"
"            \"thread-pool-size\": 0\n"
"        },\n"
"        \"option-data\": [ ],\n"
"        \"option-def\": [ ],\n"
"        \"parked-packet-limit\": 256,\n"
"        \"pd-allocator\": \"iterative\",\n"
"        \"relay-supplied-options\": [ \"65\" ],\n"
"        \"reservations-global\": false,\n"
"        \"reservations-in-subnet\": true,\n"
"        \"reservations-lookup-first\": false,\n"
"        \"reservations-out-of-pool\": false,\n"
"        \"sanity-checks\": {\n"
"            \"extended-info-checks\": \"fix\",\n"
"            \"lease-checks\": \"warn\"\n"
"        },\n"
"        \"server-id\": {\n"
"            \"enterprise-id\": 0,\n"
"            \"htype\": 0,\n"
"            \"identifier\": \"\",\n"
"            \"persist\": true,\n"
"            \"time\": 0,\n"
"            \"type\": \"LLT\"\n"
"        },\n"
"        \"server-tag\": \"\",\n"
"        \"shared-networks\": [ ],\n"
"        \"statistic-default-sample-age\": 0,\n"
"        \"statistic-default-sample-count\": 20,\n"
"        \"store-extended-info\": false,\n"
"        \"subnet6\": [\n"
"            {\n"
"                \"allocator\": \"iterative\",\n"
"                \"cache-threshold\": 0.25,\n"
"                \"calculate-tee-times\": true,\n"
"                \"id\": 1,\n"
"                \"max-valid-lifetime\": 4000,\n"
"                \"min-valid-lifetime\": 4000,\n"
"                \"option-data\": [ ],\n"
"                \"pd-allocator\": \"iterative\",\n"
"                \"pd-pools\": [ ],\n"
"                \"pools\": [\n"
"                    {\n"
"                        \"ddns-conflict-resolution-mode\": \"check-with-dhcid\",\n"
"                        \"ddns-generated-prefix\": \"prefix\",\n"
"                        \"ddns-override-client-update\": true,\n"
"                        \"ddns-override-no-update\": true,\n"
"                        \"ddns-qualifying-suffix\": \"suffix\",\n"
"                        \"ddns-replace-client-name\": \"always\",\n"
"                        \"ddns-send-updates\": true,\n"
"                        \"ddns-ttl-max\": 500,\n"
"                        \"ddns-ttl-min\": 200,\n"
"                        \"ddns-ttl-percent\": 0.5,\n"
"                        \"ddns-update-on-renew\": true,\n"
"                        \"hostname-char-replacement\": \"X\",\n"
"                        \"hostname-char-set\": \"[a-z]\",\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:1::/64\"\n"
"                    },\n"
"                    {\n"
"                        \"ddns-ttl\": 300,\n"
"                        \"option-data\": [ ],\n"
"                        \"pool\": \"2001:db8:2::/64\"\n"
"                    }\n"
"                ],\n"
"                \"rapid-commit\": false,\n"
"                \"relay\": {\n"
"                    \"ip-addresses\": [ ]\n"
"                },\n"
"                \"reservations\": [ ],\n"
"                \"store-extended-info\": false,\n"
"                \"subnet\": \"2001:db8::/32\",\n"
"                \"t1-percent\": 0.5,\n"
"                \"t2-percent\": 0.8,\n"
"                \"valid-lifetime\": 4000\n"
"            }\n"
"        ],\n"
"        \"t1-percent\": 0.5,\n"
"        \"t2-percent\": 0.8,\n"
"        \"valid-lifetime\": 4000\n"
"    }\n"
};

/// @brief the number of configurations
const size_t max_config_counter = sizeof(EXTRACTED_CONFIGS) / sizeof(char*);
///@}

/// @brief the extraction counter
///
/// < 0 means do not extract, >= 0 means extract on extractConfig() calls
/// and increment
#ifdef EXTRACT_CONFIG
int extract_count = 0;
#else
int extract_count = -1;
#endif

/// @brief the generate action
/// false means do nothing, true means unparse extracted configurations
#ifdef GENERATE_ACTION
const bool generate_action = true;
#else
const bool generate_action = false;
static_assert(max_config_counter == sizeof(UNPARSED_CONFIGS) / sizeof(char*),
              "unparsed configurations must be generated");
#endif

/// @brief format and output a configuration
void
outputFormatted(const std::string& config) {
    // pretty print it
    ConstElementPtr json = parseDHCP6(config);
    std::string prettier = prettyPrint(json, 4, 4);
    // get it as a line array
    std::list<std::string> lines;
    boost::split(lines, prettier, boost::is_any_of("\n"));
    // add escapes using again JSON
    std::list<std::string> escapes;
    while (!lines.empty()) {
        const std::string& line = lines.front();
        ConstElementPtr escaping = Element::create(line + "\n");
        escapes.push_back(escaping->str());
        lines.pop_front();
    }
    // output them on std::cerr
    while (!escapes.empty()) {
        std::cerr << "\n" << escapes.front();
        escapes.pop_front();
    }
}

} // namespace

namespace isc {
namespace dhcp {
namespace test {

/// @ref isc::dhcp::test::extractConfig in the header
void
extractConfig(const std::string& config) {
    // skip when disable
    if (extract_count < 0) {
        return;
    }
    // mark beginning
    if (extract_count == 0) {
        // header (note there is no trailer)
        std::cerr << "/// put this after const char* EXTRACTED_CONFIGS[] = {\n";
    } else {
        // end of previous configuration
        std::cerr << ",\n";
    }
    std::cerr << "    // CONFIGURATION " << extract_count;
    try {
        outputFormatted(config);
    } catch (...) {
        // mark error
        std::cerr << "\n//// got an error\n";
    }
    ++extract_count;
}

}  // namespace test
}  // namespace dhcp
}  // namespace isc

namespace {

/// Test fixture class (code from Dhcp6ParserTest)
class Dhcp6GetConfigTest : public ::testing::TestWithParam<size_t> {
public:
    Dhcp6GetConfigTest() : rcode_(-1), srv_(0) {
        // srv_(0) means to not open any sockets. We don't want to
        // deal with sockets here, just check if configuration handling
        // is sane.

        // Reset configuration for each test.
        resetConfiguration();
        BaseServerTest::setSocketTestPath();
        file::PathChecker::enableEnforcement(false);
    }

    ~Dhcp6GetConfigTest() {
        // Reset configuration database after each test.
        resetConfiguration();
        BaseServerTest::resetSocketPath();
        file::PathChecker::enableEnforcement(true);
    };

    /// @brief Parse and Execute configuration
    ///
    /// Parses a configuration and executes a configuration of the server.
    /// If the operation fails, the current test will register a failure.
    ///
    /// @param config Configuration to parse
    /// @param operation Operation being performed.  In the case of an error,
    ///        the error text will include the string "unable to <operation>.".
    ///
    /// @return true if the configuration succeeded, false if not.
    bool
    executeConfiguration(const std::string& config, const char* operation) {
        // clear config manager
        CfgMgr::instance().clear();

        // enable fake network interfaces
        IfaceMgrTestConfig test_config(true);

        // try JSON parser
        ConstElementPtr json;
        try {
            json = parseJSON(config);
        } catch (const std::exception& ex) {
            ADD_FAILURE() << "invalid JSON for " << operation
                          << " failed with " << ex.what()
                          << " on\n" << config << "\n";
            return (false);
        }

        // try DHCP6 parser
        try {
            json = parseDHCP6(config, true);
        } catch (...) {
            ADD_FAILURE() << "parsing failed for " << operation
                          << " on\n" << prettyPrint(json) << "\n";
            return (false);
        }

        // try DHCP6 configure
        ConstElementPtr status;
        try {
            status = configureDhcp6Server(srv_, json);
        } catch (const std::exception& ex) {
            ADD_FAILURE() << "configure for " << operation
                          << " failed with " << ex.what()
                          << " on\n" << prettyPrint(json) << "\n";
            return (false);
        }

        // The status object must not be NULL
        if (!status) {
            ADD_FAILURE() << "configure for " << operation
                          << " returned null on\n"
                          << prettyPrint(json) << "\n";
            return (false);
        }

        // Returned value should be 0 (configuration success)
        comment_ = parseAnswer(rcode_, status);
        if (rcode_ != 0) {
            string reason = "";
            if (comment_) {
                reason = string(" (") + comment_->stringValue() + string(")");
            }

            bool const too_long(SocketPath::isTooLongFromConfig(json));
            if (too_long) {
                EXPECT_EQ(CONTROL_RESULT_ERROR, rcode_);
                string const exp_error("name too long");
                string const error(comment_->stringValue());
                EXPECT_NE(std::string::npos, error.find(exp_error));
                return (true);
            }

            ADD_FAILURE() << "configure for " << operation
                          << " returned error code "
                          << rcode_ << reason << " on\n"
                          << prettyPrint(json) << "\n";
            return (false);
        }
        return (true);
    }

    /// @brief Reset configuration database.
    ///
    /// This function resets configuration data base by
    /// removing all subnets and option-data. Reset must
    /// be performed after each test to make sure that
    /// contents of the database do not affect result of
    /// subsequent tests.
    void resetConfiguration() {
        string config = "{"
            "\"interfaces-config\": { \"interfaces\": [ \"*\" ] },"
            "\"preferred-lifetime\": 3000,"
            "\"rebind-timer\": 2000, "
            "\"renew-timer\": 1000, "
            "\"valid-lifetime\": 4000, "
            "\"subnet6\": [ ], "
            "\"dhcp-ddns\": { \"enable-updates\" : false }, "
            "\"option-def\": [ ], "
            "\"option-data\": [ ] }";
        EXPECT_TRUE(executeConfiguration(config, "reset configuration"));
        CfgMgr::instance().clear();
        CfgMgr::instance().setFamily(AF_INET6);
    }

    int rcode_; ///< Return code (see @ref isc::config::parseAnswer)
    ControlledDhcpv6Srv srv_; ///< Instance of the ControlledDhcp6Srv used during tests
    ConstElementPtr comment_; ///< Comment (see @ref isc::config::parseAnswer)
};

/// Test a configuration
TEST_P(Dhcp6GetConfigTest, run) {
    // configurations have not been extracted yet
    if (max_config_counter == 0) {
        return;
    }

    // get the index of configurations to test
    size_t config_counter = GetParam();

    // emit unparsed header if wanted
    if ((config_counter == 0) && generate_action) {
        std::cerr << "/// put this after const char* UNPARSED_CONFIGS[] = {\n";
    }

    // get the extracted configuration
    std::string config = EXTRACTED_CONFIGS[config_counter];
    std::ostringstream ss;
    ss << "extracted config #" << config_counter;

    // execute the extracted configuration
    ASSERT_TRUE(executeConfiguration(config, ss.str().c_str()));

    // unparse it
    ConstSrvConfigPtr extracted = CfgMgr::instance().getStagingCfg();
    ConstElementPtr unparsed;
    ASSERT_NO_THROW_LOG(unparsed = extracted->toElement());
    ConstElementPtr dhcp;
    ASSERT_NO_THROW_LOG(dhcp = unparsed->get("Dhcp6"));
    ASSERT_TRUE(dhcp);

    // dump if wanted else check
    std::string expected;
    if (generate_action) {
        if (config_counter > 0) {
            std::cerr << ",\n";
        }
        std::cerr << "    // CONFIGURATION " << config_counter;
        ASSERT_NO_THROW_LOG(expected = prettyPrint(dhcp));
        ASSERT_NO_THROW_LOG(outputFormatted(dhcp->str()));
    } else {
        expected = UNPARSED_CONFIGS[config_counter];
        // get the expected config using the dhcpv6 syntax parser
        ElementPtr jsond;
        ASSERT_NO_THROW_LOG(jsond = parseDHCP6(expected, true));
        // get the expected config using the generic JSON syntax parser
        ElementPtr jsonj;
        ASSERT_NO_THROW_LOG(jsonj = parseJSON(expected));
        // the generic JSON parser does not handle comments
        EXPECT_TRUE(isEquivalent(jsond, moveComments(jsonj)));
        // check that unparsed and expected values match
        EXPECT_TRUE(isEquivalent(dhcp, jsonj));
        // check on pretty prints too
        std::string current = prettyPrint(dhcp, 4, 4) + "\n";
        EXPECT_EQ(expected, current);
        if (expected != current) {
            expected = current;
        }
    }

    // execute the dhcp configuration
    ss.str("");
    ss << "unparsed config #" << config_counter;
    EXPECT_TRUE(executeConfiguration(expected, ss.str().c_str()));

    // is it a fixed point?
    ConstSrvConfigPtr extracted2 = CfgMgr::instance().getStagingCfg();
    ConstElementPtr unparsed2;
    ASSERT_NO_THROW_LOG(unparsed2 = extracted2->toElement());
    ASSERT_TRUE(unparsed2);
    EXPECT_TRUE(isEquivalent(unparsed, unparsed2));
}

class IntToString {
public:
    std::string operator()(const testing::TestParamInfo<size_t>& n) {
        std::ostringstream ss;
        ss << static_cast<size_t>(n.param);
        return (ss.str());
    }
};

/// Define the parameterized test loop.
#ifdef INSTANTIATE_TEST_SUITE_P
INSTANTIATE_TEST_SUITE_P(Dhcp6GetConfigTest, Dhcp6GetConfigTest,
                         ::testing::Range(static_cast<size_t>(0),
                                          max_config_counter),
                         IntToString());
#else
INSTANTIATE_TEST_CASE_P(Dhcp6GetConfigTest, Dhcp6GetConfigTest,
                        ::testing::Range(static_cast<size_t>(0),
                                         max_config_counter),
                        IntToString());
#endif
}  // namespace
