/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesPanel;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class ClientHomesSelector
implements ISelectionProvider {
    private Composite selectorPanel;
    private Combo homesCombo;
    private DBPDriver driver;
    private List<String> homeIds = new ArrayList<String>();
    private String currentHomeId;
    private int currentHomeIndex;
    private final Map<ISelectionChangedListener, SelectionListener> listeners = new IdentityHashMap<ISelectionChangedListener, SelectionListener>();

    public ClientHomesSelector(Composite parent, String title) {
        this(parent, title, true);
    }

    public ClientHomesSelector(Composite parent, String title, boolean createComposite) {
        this.selectorPanel = createComposite ? UIUtils.createComposite((Composite)parent, (int)2) : parent;
        Label controlLabel = UIUtils.createControlLabel((Composite)this.selectorPanel, (String)title);
        controlLabel.setToolTipText(UIConnectionMessages.controls_client_home_selector_tip);
        this.homesCombo = new Combo(this.selectorPanel, 8);
        GridData gd = new GridData(32);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = UIUtils.getFontHeight((Control)this.homesCombo) * 30;
        this.homesCombo.setLayoutData((Object)gd);
        this.homesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientHomesSelector.this.homesCombo.getSelectionIndex() == ClientHomesSelector.this.homesCombo.getItemCount() - 1) {
                    ClientHomesSelector.this.homesCombo.select(ClientHomesSelector.this.currentHomeIndex);
                    ClientHomesSelector.this.manageHomes();
                } else {
                    ClientHomesSelector.this.currentHomeId = ClientHomesSelector.this.homeIds.get(ClientHomesSelector.this.homesCombo.getSelectionIndex());
                    ClientHomesSelector.this.currentHomeIndex = ClientHomesSelector.this.homesCombo.getSelectionIndex();
                }
                ClientHomesSelector.this.displayClientVersion();
                ClientHomesSelector.this.handleHomeChange();
            }
        });
        this.homesCombo.setEnabled(false);
    }

    public Composite getPanel() {
        return this.selectorPanel;
    }

    private void manageHomes() {
        String newHomeId = ClientHomesPanel.chooseClientHome(this.selectorPanel.getShell(), this.driver);
        if (newHomeId != null) {
            this.currentHomeId = newHomeId;
        }
        this.populateHomes(this.driver, this.currentHomeId, true);
    }

    public void populateHomes(final DBPDriver driver, String currentHome, final boolean selectDefault) {
        this.driver = driver;
        this.currentHomeId = currentHome;
        this.homesCombo.removeAll();
        this.homeIds.clear();
        final LinkedHashMap homes = new LinkedHashMap();
        AbstractJob hlJob = new AbstractJob("Find local client homes"){

            protected IStatus run(DBRProgressMonitor monitor) {
                for (DBPNativeClientLocation ncl : driver.getNativeClientLocations()) {
                    homes.put(ncl.getName(), ncl);
                }
                DBPNativeClientLocationManager clientManager = driver.getNativeClientManager();
                if (clientManager != null) {
                    for (DBPNativeClientLocation location : clientManager.findLocalClientLocations()) {
                        homes.putIfAbsent(location.getName(), location);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        hlJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIUtils.syncExec(() -> {
                    for (DBPNativeClientLocation location : homes.values()) {
                        ClientHomesSelector.this.homesCombo.add(location.getDisplayName());
                        ClientHomesSelector.this.homeIds.add(location.getName());
                        if (ClientHomesSelector.this.currentHomeId == null || !location.getName().equals(ClientHomesSelector.this.currentHomeId)) continue;
                        ClientHomesSelector.this.homesCombo.select(ClientHomesSelector.this.homesCombo.getItemCount() - 1);
                    }
                    if (ClientHomesSelector.this.homesCombo.getItemCount() == 0) {
                        ClientHomesSelector.this.homesCombo.add(UIConnectionMessages.controls_client_home_selector_missing);
                        ClientHomesSelector.this.homeIds.add(null);
                    }
                    if (selectDefault && ClientHomesSelector.this.homesCombo.getSelectionIndex() == -1) {
                        ClientHomesSelector.this.homesCombo.select(0);
                        ClientHomesSelector.this.currentHomeId = ClientHomesSelector.this.homeIds.get(0);
                    }
                    ClientHomesSelector.this.homesCombo.add(UIConnectionMessages.controls_client_home_selector_browse);
                    ClientHomesSelector.this.displayClientVersion();
                    ClientHomesSelector.this.homesCombo.setEnabled(true);
                });
                super.done(event);
            }
        });
        hlJob.schedule();
    }

    private void displayClientVersion() {
    }

    protected void handleHomeChange() {
    }

    public String getSelectedHome() {
        return CommonUtils.isEmpty((String)this.currentHomeId) ? null : this.currentHomeId;
    }

    public ISelection getSelection() {
        int selectionIndex = this.homesCombo.getSelectionIndex();
        String selection = selectionIndex < 0 ? null : this.homesCombo.getItem(selectionIndex);
        return selection == null ? new StructuredSelection() : new StructuredSelection((Object)selection);
    }

    public void addSelectionChangedListener(final ISelectionChangedListener listener) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ClientHomesSelector.this, ClientHomesSelector.this.getSelection()));
            }
        };
        this.homesCombo.addSelectionListener((SelectionListener)selectionAdapter);
        this.listeners.put(listener, (SelectionListener)selectionAdapter);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.homesCombo.removeSelectionListener(this.listeners.remove(listener));
    }

    public void setSelection(ISelection selection) {
    }
}

