// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateMemberAccount = "AssociateMemberAccount"

// AssociateMemberAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberAccount for more information on using the AssociateMemberAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateMemberAccountRequest method.
//	req, resp := client.AssociateMemberAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateMemberAccount
func (c *Macie) AssociateMemberAccountRequest(input *AssociateMemberAccountInput) (req *request.Request, output *AssociateMemberAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateMemberAccountInput{}
	}

	output = &AssociateMemberAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateMemberAccount API operation for Amazon Macie.
//
// (Discontinued) Associates a specified Amazon Web Services account with Amazon
// Macie Classic as a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation AssociateMemberAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
//   - LimitExceededException
//     (Discontinued) The request was rejected because it attempted to create resources
//     beyond the current Amazon Web Services account quotas. The error code describes
//     the quota exceeded.
//
//   - InternalException
//     (Discontinued) Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateMemberAccount
func (c *Macie) AssociateMemberAccount(input *AssociateMemberAccountInput) (*AssociateMemberAccountOutput, error) {
	req, out := c.AssociateMemberAccountRequest(input)
	return out, req.Send()
}

// AssociateMemberAccountWithContext is the same as AssociateMemberAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) AssociateMemberAccountWithContext(ctx aws.Context, input *AssociateMemberAccountInput, opts ...request.Option) (*AssociateMemberAccountOutput, error) {
	req, out := c.AssociateMemberAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateS3Resources = "AssociateS3Resources"

// AssociateS3ResourcesRequest generates a "aws/request.Request" representing the
// client's request for the AssociateS3Resources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateS3Resources for more information on using the AssociateS3Resources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateS3ResourcesRequest method.
//	req, resp := client.AssociateS3ResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateS3Resources
func (c *Macie) AssociateS3ResourcesRequest(input *AssociateS3ResourcesInput) (req *request.Request, output *AssociateS3ResourcesOutput) {
	op := &request.Operation{
		Name:       opAssociateS3Resources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateS3ResourcesInput{}
	}

	output = &AssociateS3ResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateS3Resources API operation for Amazon Macie.
//
// (Discontinued) Associates specified S3 resources with Amazon Macie Classic
// for monitoring and data classification. If memberAccountId isn't specified,
// the action associates specified S3 resources with Macie Classic for the current
// Macie Classic administrator account. If memberAccountId is specified, the
// action associates specified S3 resources with Macie Classic for the specified
// member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation AssociateS3Resources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
//   - AccessDeniedException
//     (Discontinued) You do not have required permissions to access the requested
//     resource.
//
//   - LimitExceededException
//     (Discontinued) The request was rejected because it attempted to create resources
//     beyond the current Amazon Web Services account quotas. The error code describes
//     the quota exceeded.
//
//   - InternalException
//     (Discontinued) Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateS3Resources
func (c *Macie) AssociateS3Resources(input *AssociateS3ResourcesInput) (*AssociateS3ResourcesOutput, error) {
	req, out := c.AssociateS3ResourcesRequest(input)
	return out, req.Send()
}

// AssociateS3ResourcesWithContext is the same as AssociateS3Resources with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateS3Resources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) AssociateS3ResourcesWithContext(ctx aws.Context, input *AssociateS3ResourcesInput, opts ...request.Option) (*AssociateS3ResourcesOutput, error) {
	req, out := c.AssociateS3ResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberAccount = "DisassociateMemberAccount"

// DisassociateMemberAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberAccount for more information on using the DisassociateMemberAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMemberAccountRequest method.
//	req, resp := client.DisassociateMemberAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateMemberAccount
func (c *Macie) DisassociateMemberAccountRequest(input *DisassociateMemberAccountInput) (req *request.Request, output *DisassociateMemberAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateMemberAccountInput{}
	}

	output = &DisassociateMemberAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMemberAccount API operation for Amazon Macie.
//
// (Discontinued) Removes the specified member account from Amazon Macie Classic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation DisassociateMemberAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
//   - InternalException
//     (Discontinued) Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateMemberAccount
func (c *Macie) DisassociateMemberAccount(input *DisassociateMemberAccountInput) (*DisassociateMemberAccountOutput, error) {
	req, out := c.DisassociateMemberAccountRequest(input)
	return out, req.Send()
}

// DisassociateMemberAccountWithContext is the same as DisassociateMemberAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) DisassociateMemberAccountWithContext(ctx aws.Context, input *DisassociateMemberAccountInput, opts ...request.Option) (*DisassociateMemberAccountOutput, error) {
	req, out := c.DisassociateMemberAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateS3Resources = "DisassociateS3Resources"

// DisassociateS3ResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateS3Resources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateS3Resources for more information on using the DisassociateS3Resources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateS3ResourcesRequest method.
//	req, resp := client.DisassociateS3ResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateS3Resources
func (c *Macie) DisassociateS3ResourcesRequest(input *DisassociateS3ResourcesInput) (req *request.Request, output *DisassociateS3ResourcesOutput) {
	op := &request.Operation{
		Name:       opDisassociateS3Resources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateS3ResourcesInput{}
	}

	output = &DisassociateS3ResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateS3Resources API operation for Amazon Macie.
//
// (Discontinued) Removes specified S3 resources from being monitored by Amazon
// Macie Classic. If memberAccountId isn't specified, the action removes specified
// S3 resources from Macie Classic for the current Macie Classic administrator
// account. If memberAccountId is specified, the action removes specified S3
// resources from Macie Classic for the specified member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation DisassociateS3Resources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
//   - AccessDeniedException
//     (Discontinued) You do not have required permissions to access the requested
//     resource.
//
//   - InternalException
//     (Discontinued) Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateS3Resources
func (c *Macie) DisassociateS3Resources(input *DisassociateS3ResourcesInput) (*DisassociateS3ResourcesOutput, error) {
	req, out := c.DisassociateS3ResourcesRequest(input)
	return out, req.Send()
}

// DisassociateS3ResourcesWithContext is the same as DisassociateS3Resources with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateS3Resources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) DisassociateS3ResourcesWithContext(ctx aws.Context, input *DisassociateS3ResourcesInput, opts ...request.Option) (*DisassociateS3ResourcesOutput, error) {
	req, out := c.DisassociateS3ResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMemberAccounts = "ListMemberAccounts"

// ListMemberAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListMemberAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMemberAccounts for more information on using the ListMemberAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMemberAccountsRequest method.
//	req, resp := client.ListMemberAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts
func (c *Macie) ListMemberAccountsRequest(input *ListMemberAccountsInput) (req *request.Request, output *ListMemberAccountsOutput) {
	op := &request.Operation{
		Name:       opListMemberAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMemberAccountsInput{}
	}

	output = &ListMemberAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMemberAccounts API operation for Amazon Macie.
//
// (Discontinued) Lists all Amazon Macie Classic member accounts for the current
// Macie Classic administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation ListMemberAccounts for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     (Discontinued) Internal server error.
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts
func (c *Macie) ListMemberAccounts(input *ListMemberAccountsInput) (*ListMemberAccountsOutput, error) {
	req, out := c.ListMemberAccountsRequest(input)
	return out, req.Send()
}

// ListMemberAccountsWithContext is the same as ListMemberAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListMemberAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) ListMemberAccountsWithContext(ctx aws.Context, input *ListMemberAccountsInput, opts ...request.Option) (*ListMemberAccountsOutput, error) {
	req, out := c.ListMemberAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMemberAccountsPages iterates over the pages of a ListMemberAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMemberAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMemberAccounts operation.
//	pageNum := 0
//	err := client.ListMemberAccountsPages(params,
//	    func(page *macie.ListMemberAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Macie) ListMemberAccountsPages(input *ListMemberAccountsInput, fn func(*ListMemberAccountsOutput, bool) bool) error {
	return c.ListMemberAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMemberAccountsPagesWithContext same as ListMemberAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) ListMemberAccountsPagesWithContext(ctx aws.Context, input *ListMemberAccountsInput, fn func(*ListMemberAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMemberAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMemberAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMemberAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListS3Resources = "ListS3Resources"

// ListS3ResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListS3Resources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListS3Resources for more information on using the ListS3Resources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListS3ResourcesRequest method.
//	req, resp := client.ListS3ResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListS3Resources
func (c *Macie) ListS3ResourcesRequest(input *ListS3ResourcesInput) (req *request.Request, output *ListS3ResourcesOutput) {
	op := &request.Operation{
		Name:       opListS3Resources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListS3ResourcesInput{}
	}

	output = &ListS3ResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListS3Resources API operation for Amazon Macie.
//
// (Discontinued) Lists all the S3 resources associated with Amazon Macie Classic.
// If memberAccountId isn't specified, the action lists the S3 resources associated
// with Macie Classic for the current Macie Classic administrator account. If
// memberAccountId is specified, the action lists the S3 resources associated
// with Macie Classic for the specified member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation ListS3Resources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
//   - AccessDeniedException
//     (Discontinued) You do not have required permissions to access the requested
//     resource.
//
//   - InternalException
//     (Discontinued) Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListS3Resources
func (c *Macie) ListS3Resources(input *ListS3ResourcesInput) (*ListS3ResourcesOutput, error) {
	req, out := c.ListS3ResourcesRequest(input)
	return out, req.Send()
}

// ListS3ResourcesWithContext is the same as ListS3Resources with the addition of
// the ability to pass a context and additional request options.
//
// See ListS3Resources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) ListS3ResourcesWithContext(ctx aws.Context, input *ListS3ResourcesInput, opts ...request.Option) (*ListS3ResourcesOutput, error) {
	req, out := c.ListS3ResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListS3ResourcesPages iterates over the pages of a ListS3Resources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListS3Resources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListS3Resources operation.
//	pageNum := 0
//	err := client.ListS3ResourcesPages(params,
//	    func(page *macie.ListS3ResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Macie) ListS3ResourcesPages(input *ListS3ResourcesInput, fn func(*ListS3ResourcesOutput, bool) bool) error {
	return c.ListS3ResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListS3ResourcesPagesWithContext same as ListS3ResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) ListS3ResourcesPagesWithContext(ctx aws.Context, input *ListS3ResourcesInput, fn func(*ListS3ResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListS3ResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListS3ResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListS3ResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateS3Resources = "UpdateS3Resources"

// UpdateS3ResourcesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateS3Resources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateS3Resources for more information on using the UpdateS3Resources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateS3ResourcesRequest method.
//	req, resp := client.UpdateS3ResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/UpdateS3Resources
func (c *Macie) UpdateS3ResourcesRequest(input *UpdateS3ResourcesInput) (req *request.Request, output *UpdateS3ResourcesOutput) {
	op := &request.Operation{
		Name:       opUpdateS3Resources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateS3ResourcesInput{}
	}

	output = &UpdateS3ResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateS3Resources API operation for Amazon Macie.
//
// (Discontinued) Updates the classification types for the specified S3 resources.
// If memberAccountId isn't specified, the action updates the classification
// types of the S3 resources associated with Amazon Macie Classic for the current
// Macie Classic administrator account. If memberAccountId is specified, the
// action updates the classification types of the S3 resources associated with
// Macie Classic for the specified member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Macie's
// API operation UpdateS3Resources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     (Discontinued) The request was rejected because an invalid or out-of-range
//     value was supplied for an input parameter.
//
//   - AccessDeniedException
//     (Discontinued) You do not have required permissions to access the requested
//     resource.
//
//   - InternalException
//     (Discontinued) Internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/UpdateS3Resources
func (c *Macie) UpdateS3Resources(input *UpdateS3ResourcesInput) (*UpdateS3ResourcesOutput, error) {
	req, out := c.UpdateS3ResourcesRequest(input)
	return out, req.Send()
}

// UpdateS3ResourcesWithContext is the same as UpdateS3Resources with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateS3Resources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Macie) UpdateS3ResourcesWithContext(ctx aws.Context, input *UpdateS3ResourcesInput, opts ...request.Option) (*UpdateS3ResourcesOutput, error) {
	req, out := c.UpdateS3ResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// (Discontinued) You do not have required permissions to access the requested
// resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Resource type that caused the exception
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateMemberAccountInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The ID of the Amazon Web Services account that you want to
	// associate with Amazon Macie Classic as a member account.
	//
	// MemberAccountId is a required field
	MemberAccountId *string `locationName:"memberAccountId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberAccountInput"}
	if s.MemberAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *AssociateMemberAccountInput) SetMemberAccountId(v string) *AssociateMemberAccountInput {
	s.MemberAccountId = &v
	return s
}

type AssociateMemberAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberAccountOutput) GoString() string {
	return s.String()
}

type AssociateS3ResourcesInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The ID of the Amazon Macie Classic member account whose resources
	// you want to associate with Macie Classic.
	MemberAccountId *string `locationName:"memberAccountId" type:"string"`

	// (Discontinued) The S3 resources that you want to associate with Amazon Macie
	// Classic for monitoring and data classification.
	//
	// S3Resources is a required field
	S3Resources []*S3ResourceClassification `locationName:"s3Resources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateS3ResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateS3ResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateS3ResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateS3ResourcesInput"}
	if s.S3Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Resources"))
	}
	if s.S3Resources != nil {
		for i, v := range s.S3Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *AssociateS3ResourcesInput) SetMemberAccountId(v string) *AssociateS3ResourcesInput {
	s.MemberAccountId = &v
	return s
}

// SetS3Resources sets the S3Resources field's value.
func (s *AssociateS3ResourcesInput) SetS3Resources(v []*S3ResourceClassification) *AssociateS3ResourcesInput {
	s.S3Resources = v
	return s
}

type AssociateS3ResourcesOutput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) S3 resources that couldn't be associated with Amazon Macie
	// Classic. An error code and an error message are provided for each failed
	// item.
	FailedS3Resources []*FailedS3Resource `locationName:"failedS3Resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateS3ResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateS3ResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedS3Resources sets the FailedS3Resources field's value.
func (s *AssociateS3ResourcesOutput) SetFailedS3Resources(v []*FailedS3Resource) *AssociateS3ResourcesOutput {
	s.FailedS3Resources = v
	return s
}

// (Discontinued) The classification type that Amazon Macie Classic applies
// to the associated S3 resources.
type ClassificationType struct {
	_ struct{} `type:"structure"`

	// (Discontinued) A continuous classification of the objects that are added
	// to a specified S3 bucket. Amazon Macie Classic begins performing continuous
	// classification after a bucket is successfully associated with Macie Classic.
	//
	// Continuous is a required field
	Continuous *string `locationName:"continuous" type:"string" required:"true" enum:"S3ContinuousClassificationType"`

	// (Discontinued) A one-time classification of all of the existing objects in
	// a specified S3 bucket.
	//
	// OneTime is a required field
	OneTime *string `locationName:"oneTime" type:"string" required:"true" enum:"S3OneTimeClassificationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassificationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassificationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClassificationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClassificationType"}
	if s.Continuous == nil {
		invalidParams.Add(request.NewErrParamRequired("Continuous"))
	}
	if s.OneTime == nil {
		invalidParams.Add(request.NewErrParamRequired("OneTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContinuous sets the Continuous field's value.
func (s *ClassificationType) SetContinuous(v string) *ClassificationType {
	s.Continuous = &v
	return s
}

// SetOneTime sets the OneTime field's value.
func (s *ClassificationType) SetOneTime(v string) *ClassificationType {
	s.OneTime = &v
	return s
}

// (Discontinued) The classification type that Amazon Macie Classic applies
// to the associated S3 resources. At least one of the classification types
// (oneTime or continuous) must be specified.
type ClassificationTypeUpdate struct {
	_ struct{} `type:"structure"`

	// (Discontinued) A continuous classification of the objects that are added
	// to a specified S3 bucket. Amazon Macie Classic begins performing continuous
	// classification after a bucket is successfully associated with Macie Classic.
	Continuous *string `locationName:"continuous" type:"string" enum:"S3ContinuousClassificationType"`

	// (Discontinued) A one-time classification of all of the existing objects in
	// a specified S3 bucket.
	OneTime *string `locationName:"oneTime" type:"string" enum:"S3OneTimeClassificationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassificationTypeUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassificationTypeUpdate) GoString() string {
	return s.String()
}

// SetContinuous sets the Continuous field's value.
func (s *ClassificationTypeUpdate) SetContinuous(v string) *ClassificationTypeUpdate {
	s.Continuous = &v
	return s
}

// SetOneTime sets the OneTime field's value.
func (s *ClassificationTypeUpdate) SetOneTime(v string) *ClassificationTypeUpdate {
	s.OneTime = &v
	return s
}

type DisassociateMemberAccountInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The ID of the member account that you want to remove from
	// Amazon Macie Classic.
	//
	// MemberAccountId is a required field
	MemberAccountId *string `locationName:"memberAccountId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberAccountInput"}
	if s.MemberAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *DisassociateMemberAccountInput) SetMemberAccountId(v string) *DisassociateMemberAccountInput {
	s.MemberAccountId = &v
	return s
}

type DisassociateMemberAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberAccountOutput) GoString() string {
	return s.String()
}

type DisassociateS3ResourcesInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The S3 resources (buckets or prefixes) that you want to remove
	// from being monitored and classified by Amazon Macie Classic.
	//
	// AssociatedS3Resources is a required field
	AssociatedS3Resources []*S3Resource `locationName:"associatedS3Resources" type:"list" required:"true"`

	// (Discontinued) The ID of the Amazon Macie Classic member account whose resources
	// you want to remove from being monitored by Macie Classic.
	MemberAccountId *string `locationName:"memberAccountId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateS3ResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateS3ResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateS3ResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateS3ResourcesInput"}
	if s.AssociatedS3Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociatedS3Resources"))
	}
	if s.AssociatedS3Resources != nil {
		for i, v := range s.AssociatedS3Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssociatedS3Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedS3Resources sets the AssociatedS3Resources field's value.
func (s *DisassociateS3ResourcesInput) SetAssociatedS3Resources(v []*S3Resource) *DisassociateS3ResourcesInput {
	s.AssociatedS3Resources = v
	return s
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *DisassociateS3ResourcesInput) SetMemberAccountId(v string) *DisassociateS3ResourcesInput {
	s.MemberAccountId = &v
	return s
}

type DisassociateS3ResourcesOutput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) S3 resources that couldn't be removed from being monitored
	// and classified by Amazon Macie Classic. An error code and an error message
	// are provided for each failed item.
	FailedS3Resources []*FailedS3Resource `locationName:"failedS3Resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateS3ResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateS3ResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedS3Resources sets the FailedS3Resources field's value.
func (s *DisassociateS3ResourcesOutput) SetFailedS3Resources(v []*FailedS3Resource) *DisassociateS3ResourcesOutput {
	s.FailedS3Resources = v
	return s
}

// (Discontinued) Includes details about the failed S3 resources.
type FailedS3Resource struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The status code of a failed item.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// (Discontinued) The error message of a failed item.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// (Discontinued) The failed S3 resources.
	FailedItem *S3Resource `locationName:"failedItem" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedS3Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedS3Resource) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedS3Resource) SetErrorCode(v string) *FailedS3Resource {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedS3Resource) SetErrorMessage(v string) *FailedS3Resource {
	s.ErrorMessage = &v
	return s
}

// SetFailedItem sets the FailedItem field's value.
func (s *FailedS3Resource) SetFailedItem(v *S3Resource) *FailedS3Resource {
	s.FailedItem = v
	return s
}

// (Discontinued) Internal server error.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Error code for the exception
	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// (Discontinued) The request was rejected because an invalid or out-of-range
// value was supplied for an input parameter.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Error code for the exception
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// Field that has invalid input
	FieldName *string `locationName:"fieldName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// (Discontinued) The request was rejected because it attempted to create resources
// beyond the current Amazon Web Services account quotas. The error code describes
// the quota exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Error code for the exception
	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// Resource type that caused the exception
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListMemberAccountsInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) Use this parameter to indicate the maximum number of items
	// that you want in the response. The default value is 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// (Discontinued) Use this parameter when paginating results. Set the value
	// of this parameter to null on your first call to the ListMemberAccounts action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of nextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMemberAccountsInput) SetMaxResults(v int64) *ListMemberAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMemberAccountsInput) SetNextToken(v string) *ListMemberAccountsInput {
	s.NextToken = &v
	return s
}

type ListMemberAccountsOutput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) A list of the Amazon Macie Classic member accounts returned
	// by the action. The current Macie Classic administrator account is also included
	// in this list.
	MemberAccounts []*MemberAccount `locationName:"memberAccounts" type:"list"`

	// (Discontinued) When a response is generated, if there is more data to be
	// listed, this parameter is present in the response and contains the value
	// to use for the nextToken parameter in a subsequent pagination request. If
	// there is no more data to be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMemberAccountsOutput) GoString() string {
	return s.String()
}

// SetMemberAccounts sets the MemberAccounts field's value.
func (s *ListMemberAccountsOutput) SetMemberAccounts(v []*MemberAccount) *ListMemberAccountsOutput {
	s.MemberAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMemberAccountsOutput) SetNextToken(v string) *ListMemberAccountsOutput {
	s.NextToken = &v
	return s
}

type ListS3ResourcesInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) Use this parameter to indicate the maximum number of items
	// that you want in the response. The default value is 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// (Discontinued) The Amazon Macie Classic member account ID whose associated
	// S3 resources you want to list.
	MemberAccountId *string `locationName:"memberAccountId" type:"string"`

	// (Discontinued) Use this parameter when paginating results. Set its value
	// to null on your first call to the ListS3Resources action. Subsequent calls
	// to the action fill nextToken in the request with the value of nextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3ResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3ResourcesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListS3ResourcesInput) SetMaxResults(v int64) *ListS3ResourcesInput {
	s.MaxResults = &v
	return s
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *ListS3ResourcesInput) SetMemberAccountId(v string) *ListS3ResourcesInput {
	s.MemberAccountId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListS3ResourcesInput) SetNextToken(v string) *ListS3ResourcesInput {
	s.NextToken = &v
	return s
}

type ListS3ResourcesOutput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) When a response is generated, if there is more data to be
	// listed, this parameter is present in the response and contains the value
	// to use for the nextToken parameter in a subsequent pagination request. If
	// there is no more data to be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// (Discontinued) A list of the associated S3 resources returned by the action.
	S3Resources []*S3ResourceClassification `locationName:"s3Resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3ResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3ResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListS3ResourcesOutput) SetNextToken(v string) *ListS3ResourcesOutput {
	s.NextToken = &v
	return s
}

// SetS3Resources sets the S3Resources field's value.
func (s *ListS3ResourcesOutput) SetS3Resources(v []*S3ResourceClassification) *ListS3ResourcesOutput {
	s.S3Resources = v
	return s
}

// (Discontinued) Contains information about the Amazon Macie Classic member
// account.
type MemberAccount struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The Amazon Web Services account ID of the Amazon Macie Classic
	// member account.
	AccountId *string `locationName:"accountId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberAccount) SetAccountId(v string) *MemberAccount {
	s.AccountId = &v
	return s
}

// (Discontinued) Contains information about the S3 resource. This data type
// is used as a request parameter in the DisassociateS3Resources action and
// can be used as a response parameter in the AssociateS3Resources and UpdateS3Resources
// actions.
type S3Resource struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The name of the S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// (Discontinued) The prefix of the S3 bucket.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Resource"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Resource) SetBucketName(v string) *S3Resource {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Resource) SetPrefix(v string) *S3Resource {
	s.Prefix = &v
	return s
}

// (Discontinued) The S3 resources that you want to associate with Amazon Macie
// Classic for monitoring and data classification. This data type is used as
// a request parameter in the AssociateS3Resources action and a response parameter
// in the ListS3Resources action.
type S3ResourceClassification struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The name of the S3 bucket that you want to associate with
	// Amazon Macie Classic.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// (Discontinued) The classification type that you want to specify for the resource
	// associated with Amazon Macie Classic.
	//
	// ClassificationType is a required field
	ClassificationType *ClassificationType `locationName:"classificationType" type:"structure" required:"true"`

	// (Discontinued) The prefix of the S3 bucket that you want to associate with
	// Amazon Macie Classic.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ResourceClassification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ResourceClassification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ResourceClassification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ResourceClassification"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.ClassificationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ClassificationType"))
	}
	if s.ClassificationType != nil {
		if err := s.ClassificationType.Validate(); err != nil {
			invalidParams.AddNested("ClassificationType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3ResourceClassification) SetBucketName(v string) *S3ResourceClassification {
	s.BucketName = &v
	return s
}

// SetClassificationType sets the ClassificationType field's value.
func (s *S3ResourceClassification) SetClassificationType(v *ClassificationType) *S3ResourceClassification {
	s.ClassificationType = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3ResourceClassification) SetPrefix(v string) *S3ResourceClassification {
	s.Prefix = &v
	return s
}

// (Discontinued) The S3 resources whose classification types you want to update.
// This data type is used as a request parameter in the UpdateS3Resources action.
type S3ResourceClassificationUpdate struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The name of the S3 bucket whose classification types you want
	// to update.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// (Discontinued) The classification type that you want to update for the resource
	// associated with Amazon Macie Classic.
	//
	// ClassificationTypeUpdate is a required field
	ClassificationTypeUpdate *ClassificationTypeUpdate `locationName:"classificationTypeUpdate" type:"structure" required:"true"`

	// (Discontinued) The prefix of the S3 bucket whose classification types you
	// want to update.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ResourceClassificationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ResourceClassificationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ResourceClassificationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ResourceClassificationUpdate"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.ClassificationTypeUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ClassificationTypeUpdate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3ResourceClassificationUpdate) SetBucketName(v string) *S3ResourceClassificationUpdate {
	s.BucketName = &v
	return s
}

// SetClassificationTypeUpdate sets the ClassificationTypeUpdate field's value.
func (s *S3ResourceClassificationUpdate) SetClassificationTypeUpdate(v *ClassificationTypeUpdate) *S3ResourceClassificationUpdate {
	s.ClassificationTypeUpdate = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3ResourceClassificationUpdate) SetPrefix(v string) *S3ResourceClassificationUpdate {
	s.Prefix = &v
	return s
}

type UpdateS3ResourcesInput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The Amazon Web Services account ID of the Amazon Macie Classic
	// member account whose S3 resources' classification types you want to update.
	MemberAccountId *string `locationName:"memberAccountId" type:"string"`

	// (Discontinued) The S3 resources whose classification types you want to update.
	//
	// S3ResourcesUpdate is a required field
	S3ResourcesUpdate []*S3ResourceClassificationUpdate `locationName:"s3ResourcesUpdate" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateS3ResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateS3ResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateS3ResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateS3ResourcesInput"}
	if s.S3ResourcesUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("S3ResourcesUpdate"))
	}
	if s.S3ResourcesUpdate != nil {
		for i, v := range s.S3ResourcesUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3ResourcesUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberAccountId sets the MemberAccountId field's value.
func (s *UpdateS3ResourcesInput) SetMemberAccountId(v string) *UpdateS3ResourcesInput {
	s.MemberAccountId = &v
	return s
}

// SetS3ResourcesUpdate sets the S3ResourcesUpdate field's value.
func (s *UpdateS3ResourcesInput) SetS3ResourcesUpdate(v []*S3ResourceClassificationUpdate) *UpdateS3ResourcesInput {
	s.S3ResourcesUpdate = v
	return s
}

type UpdateS3ResourcesOutput struct {
	_ struct{} `type:"structure"`

	// (Discontinued) The S3 resources whose classification types can't be updated.
	// An error code and an error message are provided for each failed item.
	FailedS3Resources []*FailedS3Resource `locationName:"failedS3Resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateS3ResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateS3ResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedS3Resources sets the FailedS3Resources field's value.
func (s *UpdateS3ResourcesOutput) SetFailedS3Resources(v []*FailedS3Resource) *UpdateS3ResourcesOutput {
	s.FailedS3Resources = v
	return s
}

const (
	// S3ContinuousClassificationTypeFull is a S3ContinuousClassificationType enum value
	S3ContinuousClassificationTypeFull = "FULL"
)

// S3ContinuousClassificationType_Values returns all elements of the S3ContinuousClassificationType enum
func S3ContinuousClassificationType_Values() []string {
	return []string{
		S3ContinuousClassificationTypeFull,
	}
}

const (
	// S3OneTimeClassificationTypeFull is a S3OneTimeClassificationType enum value
	S3OneTimeClassificationTypeFull = "FULL"

	// S3OneTimeClassificationTypeNone is a S3OneTimeClassificationType enum value
	S3OneTimeClassificationTypeNone = "NONE"
)

// S3OneTimeClassificationType_Values returns all elements of the S3OneTimeClassificationType enum
func S3OneTimeClassificationType_Values() []string {
	return []string{
		S3OneTimeClassificationTypeFull,
		S3OneTimeClassificationTypeNone,
	}
}
