      SUBROUTINE WIINWS(IERASE)
C
C     PURPOSE--INITIALIZE THE WINDOW SYSTEM
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IERASE
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'INWS')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIINWS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IERASE,IWERIN
   55 FORMAT('IERASE,IWERIN = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWERIN=IERASE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 8-45          **
C               ************************************************
C
 1100 CONTINUE
      CALL SHINIT(' ')
      IF(IERASE.EQ.'ON')CALL CLSCRN
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'INWS')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIINWS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IERASE,IWERIN
 9015 FORMAT('IERASE,IWERIN = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIEXWS(IERASE)
C
C     PURPOSE--EXIT FROM THE WINDOW SYSTEM
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IERASE
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'INIT')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIEXWS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IERASE,IWEREX
   55 FORMAT('IERASE,IWEREX = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWEREX=IERASE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 8-47          **
C               ************************************************
C
 1100 CONTINUE
      IF(IWEREX.EQ.'OFF')CALL SHQUIT(' ')
      IF(IWEREX.EQ.'ON')CALL SHQUIT('C')
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'INIT')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIEXWS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IERASE,IWEREX
 9015 FORMAT('IERASE,IWEREX = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIOPWI
C
C     PURPOSE--OPEN A WINDOW
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'OPWI')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIOPWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW,MAXWIN
   54 FORMAT('IWINCW,MAXWIN = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,61)IWINBC(IWINCW),IWINFC(IWINCW),IWINCW
   61 FORMAT('IWINBC(IWINCW),IWINFC(IWINCW),IWINCW = ',
     1A4,2X,A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,62)IWINFR(IWINCW),IWEROP(IWINCW),WIPOP(IWINCW)
   62 FORMAT('IWINFR(IWINCW),IWEROP(IWINCW),WIPOP(IWINCW) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,63)IWINX1(IWINCW),IWINY1(IWINCW)
   63 FORMAT('IWINX1(IWINCW),IWINY1(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,64)IWINX2(IWINCW),IWINY2(IWINCW)
   64 FORMAT('IWINX2(IWINCW),IWINY2(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEED BE DONE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-30          **
C               ************************************************
C
 1100 CONTINUE
      IX1=IWINX1(IWINCW)
      IY1=IWINY1(IWINCW)
      IXLEN=IWINXL(IWINCW)
      IYLEN=IWINYL(IWINCW)
      CALL WNOPEN(IX1,IY1,IXLEN,IYLEN)
      WRITE(ICOUT,777)
  777 FORMAT('WNOPEN HAS JUST BEEN CALLED')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'OPWI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIOPWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW,MAXWIN
 9014 FORMAT('IWINCW,MAXWIN = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX1,IY1,IXLEN,IYLEN
 9015 FORMAT('IX1,IY1,IXLEN,IYLEN = ',4I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)IWINBC(IWINCW),IWINFC(IWINCW),IWINCW
 9021 FORMAT('IWINBC(IWINCW),IWINFC(IWINCW),IWINCW = ',
     1A4,2X,A4,2X,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)IWINFR(IWINCW),IWEROP(IWINCW),WIPOP(IWINCW)
 9022 FORMAT('IWINFR(IWINCW),IWEROP(IWINCW),WIPOP(IWINCW) = ',
     1A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9023)IWINX1(IWINCW),IWINY1(IWINCW)
 9023 FORMAT('IWINX1(IWINCW),IWINY1(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9024)IWINXL(IWINCW),IWINYL(IWINCW)
 9024 FORMAT('IWINXL(IWINCW),IWINYL(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9025)IWINX2(IWINCW),IWINY2(IWINCW)
 9025 FORMAT('IWINX2(IWINCW),IWINY2(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WICLWI(IERASE,IWRPRE)
C
C     PURPOSE--CLOSE A WINDOW
C              (CLEAR?  WRITE PREVIOUS WINDOW?)
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IERASE
      CHARACTER*4 IWRPRE
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'CLWI')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WICLWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IERASE,IWRPRE
   55 FORMAT('IERASE,IWRPRE = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IWEROP(IWINCW),IWINTY(IWINCW)
   56 FORMAT('IWEROP(IWINCW),IWINTY(IWINCW) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWERCL(IWINCW)=IERASE
      IWWRPR(IWINCW)=IWRPRE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-28          **
C               ************************************************
C
 1100 CONTINUE
      IFLAG=0
      IF(IERASE.EQ.'ON'.OR.IWRPRE.EQ.'ON')IFLAG=1
      CALL WNCLOS(IFLAG)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'CLWI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WICLWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IERASE,IWRPRE
 9015 FORMAT('IERASE,IWRPRE = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IWEROP(IWINCW),IWINTY(IWINCW)
 9016 FORMAT('IWEROP(IWINCW),IWINTY(IWINCW) = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IFLAG
 9017 FORMAT('IFLAG = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISEWI(ICURWI)
C
C     PURPOSE--SELECT A WINDOW (TO OPERATE ON)
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SEWI')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISEWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ICURWI
   54 FORMAT('ICURWI = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IWINCW
   55 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWINCW=ICURWI
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-37          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNSEL(ICURWI)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SEWI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISEWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)ICURWI
 9014 FORMAT('ICURWI = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IWINCW
 9015 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISECO(IBCOL,IFCOL)
C
C     PURPOSE--SET THE COLOR FOR A WINDOW
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IBCOL
      CHARACTER*4 IFCOL
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SECO')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISECO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW,MAXWIN
   54 FORMAT('IWINCW,MAXWIN = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IBCOL,IFCOL,IWINCW
   55 FORMAT('IBCOL,IFCOL,IWINCW = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IWINBC(IWINCW),IWINFC(IWINCW),IWINCW
   56 FORMAT('IWINBC(IWINCW),IWINFC(IWINCW),IWINCW = ',
     1A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWINBC(IWINCW)=IBCOL
      IWINFC(IWINCW)=IFCOL
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-15          **
C               ************************************************
C
 1100 CONTINUE
      CALL COLOR(IFCOL,IBCOL)
      WRITE(ICOUT,777)
  777 FORMAT('COLOR HAS JUST BEEN CALLED')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SECO')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISECO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW,MAXWIN
 9014 FORMAT('IWINCW,MAXWIN = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IBCOL,IFCOL,IWINCW
 9015 FORMAT('IBCOL,IFCOL,IWINCW = ',A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IWINBC(IWINCW),IWINFC(IWINCW),IWINCW
 9016 FORMAT('IWINBC(IWINCW),IWINFC(IWINCW),IWINCW = ',
     1A4,2X,A4,I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISETY(ITYPE)
C
C     PURPOSE--SET THE FRAME (ON/OFF) FOR A WINDOW
C              FOR OTG INTERACTER WINDOW WYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IERASE
      CHARACTER*4 ITYPE
      CHARACTER*4 IFRAME
C
      CHARACTER*4 IC4
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
      IC4='XXXX'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SETY')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISETY--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)ITYPE
   55 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IWEROP(IWINCW)
   57 FORMAT('IWEROP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)WIPOP(IWINCW)
   58 FORMAT('WIPOP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IWINFR(IWINCW)
   59 FORMAT('IWINFR(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      WIPOP(IWINCW)=ITYPE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-27          **
C               ************************************************
C
 1100 CONTINUE
      IERASE=IWEROP(IWINCW)
      IFRAME=IWINFR(IWINCW)
      IC4='    '
      IF(IERASE.EQ.'ON')IC4(1:1)='C'
      IF(ITYPE.EQ.'POP')IC4(2:2)='P'
      IF(IFRAME.EQ.'ON')IC4(3:3)='F'
      CALL WNACTN(IC4)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SETY')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISETY--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)ITYPE
 9015 FORMAT('ITYPE = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IWEROP(IWINCW)
 9017 FORMAT('IWEROP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)WIPOP(IWINCW)
 9018 FORMAT('WIPOP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9019)IWINFR(IWINCW)
 9019 FORMAT('IWINFR(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)IC4
 9021 FORMAT('IC4 = ',A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISEFR(IFRAME)
C
C     PURPOSE--SET THE FRAME (ON/OFF) FOR A WINDOW
C              FOR OTG INTERACTER WINDOW WYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IERASE
      CHARACTER*4 ITYPE
      CHARACTER*4 IFRAME
C
      CHARACTER*4 IC4
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SEFR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISEFR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IFRAME
   55 FORMAT('IFRAME = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IWEROP(IWINCW)
   57 FORMAT('IWEROP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)WIPOP(IWINCW)
   58 FORMAT('WIPOP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,59)IWINFR(IWINCW)
   59 FORMAT('IWINFR(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWINFR(IWINCW)=IFRAME
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-27          **
C               ************************************************
C
 1100 CONTINUE
      IERASE=IWEROP(IWINCW)
      ITYPE=WIPOP(IWINCW)
      IC4='    '
      IF(IERASE.EQ.'ON')IC4(1:1)='C'
      IF(ITYPE.EQ.'POP')IC4(2:2)='P'
      IF(IFRAME.EQ.'ON')IC4(3:3)='F'
      CALL WNACTN(IC4)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SEFR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISEFR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IFRAME
 9015 FORMAT('IFRAME = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IWEROP(IWINCW)
 9017 FORMAT('IWEROP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)WIPOP(IWINCW)
 9018 FORMAT('WIPOP(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9019)IWINFR(IWINCW)
 9019 FORMAT('IWINFR(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)IC4
 9021 FORMAT('IC4 = ',A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISEWR(IWRAP)
C
C     PURPOSE--SET THE WITHIN-WINDOW TEXT WRAP ATTRIBUTE
C              (OFF = NO WRAP        ON = WRAP)
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IWRAP
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SEWR')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISEWR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IWRAP,IWINCW
   55 FORMAT('IWRAP,IWINCW = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IWINWR(IWINCW)
   56 FORMAT('IWINWR(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWINWR(IWINCW)=IWRAP
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-15          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNWRAP(IWRAP)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SEWR')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISEWR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IWRAP,IWINCW
 9015 FORMAT('IWRAP,IWINCW = ',A4,I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IWINWR(IWINCW)
 9016 FORMAT('IWINWR(IWINCW) = ',A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISELS(IX1,IY1,IXLEN,IYLEN)
C
C     PURPOSE--SET THE LOCATION AND SIZE OF A WINDOW
C              (IX1,IY1) IXLEN,IYLEN
C             WHERE (1,1) IS TOP/LEFT POINT ON THE SCREEN
C             AND SCREEN IS 80 COLUMNS WIDE AND 24 LINES DOWN
C             FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SELS')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISELS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX1,IY1,IXLEN,IYLEN
   55 FORMAT('IX1,IY1,IXLEN,IYLEN = ',4I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IWINX1(IWINCW),IWINY1(IWINCW)
   56 FORMAT('IWINX1(IWINCW),IWINY1(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IWINXL(IWINCW),IWINYL(IWINCW)
   57 FORMAT('IWINXL(IWINCW),IWINYL(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)IWINX2(IWINCW),IWINY2(IWINCW)
   58 FORMAT('IWINX2(IWINCW),IWINY2(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)IERRWI='YES'
      IF(IWINCW.LE.0.OR.IWINCW.GE.MAXWIN)GOTO9000
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWINX1(IWINCW)=IX1
      IWINY1(IWINCW)=IY1
      IWINXL(IWINCW)=IXLEN
      IWINYL(IWINCW)=IYLEN
      IX2=IX1+IXLEN-1
      IY2=IY1+IYLEN-1
      IWINX2(IWINCW)=IX2
      IWINY2(IWINCW)=IY2
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-30          **
C               **  (NO ACTION DONE UNTIL WNOPEN(.) COMMAND   **
C               ************************************************
C
 1100 CONTINUE
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SELS')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISELS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX1,IY1,IXLEN,IYLEN,IX2,IY2
 9015 FORMAT('IX1,IY1,IXLEN,IYLEN,IX2,IY2 = ',6I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IWINX1(IWINCW),IWINY1(IWINCW)
 9016 FORMAT('IWINX1(IWINCW),IWINY1(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IWINXL(IWINCW),IWINYL(IWINCW)
 9017 FORMAT('IWINXL(IWINCW),IWINYL(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)IWINX2(IWINCW),IWINY2(IWINCW)
 9018 FORMAT('IWINX2(IWINCW),IWINY2(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIERWI
C
C     PURPOSE--ERASE (= CLEAR) CURRENT WINDOW
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'ERWI')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIERWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEED BE DONE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-28          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNCLR
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'ERWI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIERWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIMOHO
C
C     PURPOSE--MOVE TO HOME POSITION (= UPPER LEFT) OF CURRENT WINDOW
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MOHO')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIMOHO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEED BE DONE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-29          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNHOME
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MOHO')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIMOHO--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIMOCU(IX,IY)
C
C     PURPOSE--MOVE WINDOW CURSOR TO (IX,IY)
C              (WHERE (1,1) IS THE UPPER LEFT OF THE WINDOW)
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MOCU')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIMOCU--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX,IY
   55 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)IWINXC(IWINCW),IWINYC(IWINCW)
   56 FORMAT('IWINXC(IWINCW),IWINYC(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
      IWINXC(IWINCW)=IX
      IWINYC(IWINCW)=IY
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-29          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNCUXY(IX,IY)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MOCU')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIMOCU--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX,IY
 9015 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)IWINXC(IWINCW),IWINYC(IWINCW)
 9016 FORMAT('IWINXC(IWINCW),IWINYC(IWINCW) = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIMWST(IX,IY,ISTRIN,NSTRIN)
C
C     PURPOSE--MOVE TO (IX,IY) WITHIN A WINDOW
C              AND WRITE NSTRIN CHARACTERS
C              OF THE STRING ISTRIN
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*80 ISTRIN
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MWST')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIMWST--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX,IY
   55 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)NSTRIN
   56 FORMAT('NSTRIN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)(ISTRIN(I:I),I=1,NSTRIN)
   57 FORMAT('ISTRIN = ',80A1)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEEDED
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-29          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNOUSX(IX,IY,ISTRIN(1:NSTRIN))
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MWST')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIMWST--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX,IY
 9015 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)NSTRIN
 9016 FORMAT('NSTRIN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)(ISTRIN(I:I),I=1,NSTRIN)
 9017 FORMAT('ISTRIN = ',80A1)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIMWIN(IX,IY,IVALUE,NVALUE)
C
C     PURPOSE--MOVE TO (IX,IY) WITHIN A WINDOW
C              AND WRITE OUT THE INTEGER    IVALUE
C              WITH AN I-NVALUE FORMAT (E.G., I1,I2,I3,...)
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MWIN')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIMWIN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX,IY
   55 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)NVALUE
   56 FORMAT('NVALUE = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)IVALUE
   57 FORMAT('IVALUE = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEEDED
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-29 AND 5-34 **
C               ************************************************
C
 1100 CONTINUE
 
      CALL WNCUXY(IX,IY)
      CALL WNOUIN(IVALUE,NVALUE)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MWIN')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIMWIN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX,IY
 9015 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)NVALUE
 9016 FORMAT('NVALUE = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)IVALUE
 9017 FORMAT('IVALUE = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIMWRE(IX,IY,VALUE,ICFORM,NCFORM)
C
C     PURPOSE--MOVE TO (IX,IY) WITHIN A WINDOW
C              AND WRITE OUT THE REAL    VALUE
C              WITH A F FORMAT AS DEFINED BY THE FIRST NCFORM
C              CHARACTERS OF THE STRING ICFORM
C              (WITH FIRST AND LAST CHARACTERS BEING ( AND ))
C              (E.G., (F6.2), (F10.4), ETC.)
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*80 ICFORM
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MWRE')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIMWRE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IX,IY
   55 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)NCFORM
   56 FORMAT('NCFORM = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,57)(ICFORM(I:I),I=1,NCFORM)
   57 FORMAT('ICFORM = ',80A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,58)VALUE
   58 FORMAT('VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEED BE DONE
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-29 AND 5-35 **
C               ************************************************
C
 1100 CONTINUE
      CALL WNCUXY(IX,IY)
      CALL WNOURE(VALUE,ICFORM(1:NCFORM))
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'MWRE')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIMWRE--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IX,IY
 9015 FORMAT('IX,IY = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)NCFORM
 9016 FORMAT('NCFORM = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)(ICFORM(I:I),I=1,NCFORM)
 9017 FORMAT('ICFORM = ',80A1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)VALUE
 9018 FORMAT('VALUE = ',E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WIREST(ISTRIN,NSTRIN)
C
C     PURPOSE--READ A STRING (ISTRIN) WITHIN A WINDOW
C              AND REPORT NUMBER OF ENTERED CHARACTERS (NSTRIN).
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*80 ISTRIN
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
      ISTRIN=' '
      NSTRIN=(-999)
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'REST')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WIREST--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)NSTRIN
   56 FORMAT('NSTRIN = ',I8)
      CALL DPWRST('XXX','BUG ')
      IF(NSTRIN.GE.1)WRITE(ICOUT,57)(ISTRIN(I:I),I=1,NSTRIN)
   57 FORMAT('ISTRIN = ',80A1)
      IF(NSTRIN.GE.1)CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     NO COPYING NEEDED
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-29          **
C               ************************************************
C
 1100 CONTINUE
      CALL INSTR(ISTRIN,NSTRIN)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'REST')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WIREST--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)NSTRIN
 9016 FORMAT('NSTRIN = ',I8)
      CALL DPWRST('XXX','BUG ')
      IF(NSTRIN.GE.1)WRITE(ICOUT,9017)(ISTRIN(I:I),I=1,NSTRIN)
 9017 FORMAT('ISTRIN = ',80A1)
      IF(NSTRIN.GE.1)CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WISCWI(IDIR,NUMLIN)
C
C     PURPOSE--SCROLL WINDOW CONTENTS UP/DOWN BY NUMLIN LINES
C              FOR OTG INTERACTER WINDOW SYSTEM
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 CENTER FOR APPLIED MATHEMATICS
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--90.9
C     ORIGINAL VERSION --AUGUST      1990
C
C-----NON-COMMON VARIABLES-----------------------------
C
      CHARACTER*4 IDIR
C
C-----COMMON (FOR WINDOW SYSTEM)-----------------------------
C
      INCLUDE 'DPCOWI.INC'
      INCLUDE 'DPCOHO.INC'
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERRWI='NO'
C
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SCWI')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF WISCWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGWI,ISUBWI,IERRWI
   52 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IWINSY,IHOST1,IHOST2
   53 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)IWINCW
   54 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,55)IDIR
   55 FORMAT('IDIR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,56)NUMLIN
   56 FORMAT('NUMLIN = ',I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               **************************************************
C               **  STEP 1--                                    **
C               **  COPY OVER THE TEMPORARY INPUT VARIABLES     **
C               **  INTO PERMANENT COMMON VARIABLES             **
C               **************************************************
C
C     COPYING NOT NEEDED
C
C               ************************************************
C               **  STEP 11--                                 **
C               **  TREAT THE OTG (UNIV. OF SALFORD) SYSTEM   **
C               **  OTG INTERACTOR MANUAL, PAGE 5-36          **
C               ************************************************
C
 1100 CONTINUE
      CALL WNSCRL(IDIR,NUMLIN)
      GOTO9000
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGWI.EQ.'OFF'.AND.ISUBWI.NE.'SCWI')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF WISCWI--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGWI,ISUBWI,IERRWI
 9012 FORMAT('IBUGWI,ISUBWI,IERRWI = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IWINSY,IHOST1,IHOST2
 9013 FORMAT('IWINSY,IHOST1,IHOST2 = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)IWINCW
 9014 FORMAT('IWINCW = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IDIR
 9015 FORMAT('IDIR = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)NUMLIN
 9016 FORMAT('NUMLIN = ',I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE WNCLR
      RETURN
      END
      SUBROUTINE WNSEL(IN)
      RETURN
      END
      SUBROUTINE SHQUIT(IA)
      CHARACTER*(*) IA
      RETURN
      END
      SUBROUTINE WNHOME
      RETURN
      END
      SUBROUTINE WNWRAP(IA)
      CHARACTER*(*) IA
      RETURN
      END
      SUBROUTINE WNOUSX(IN1,IN2,IA)
      CHARACTER*(*) IA
      RETURN
      END
      SUBROUTINE WNACTN(IA)
      CHARACTER*(*) IA
      RETURN
      END
      SUBROUTINE COLOR(IA1,IA2)
      CHARACTER*(*) IA1, IA2
      RETURN
      END
      SUBROUTINE INSTR(IA1,LENGTH)
      CHARACTER*(*) IA1
      RETURN
      END
      SUBROUTINE WNSCRL(IA1,LENGTH)
      CHARACTER*(*) IA1
      RETURN
      END
      SUBROUTINE SHINIT(IA1)
      CHARACTER*(*) IA1
      RETURN
      END
      SUBROUTINE CLSCRN
      RETURN
      END
      SUBROUTINE WNOURE(VALUE,IA1)
      CHARACTER*(*) IA1
      RETURN
      END
      SUBROUTINE WNCUXY(IX,IY)
      RETURN
      END
      SUBROUTINE WNOUIN(IVALUE,NVALUE)
      RETURN
      END
      SUBROUTINE ZSCORE(X,ULAB,XREF,UREF,SIGMA,N,ICASE,IWRITE,Y,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES SEVERAL Z-SCORE VARIANTS
C              DEFINED BY THE ISO-13528 STANDARD.
C
C              1) Z-SCORE:
C
C                   Y(i) = (X(I) - XREF)/SIGMA
C
C                 WHERE XREF IS THE "ASSIGNED VALUE" AND SIGMA IS
C                 THE STANDARD DEVIATION OF THE PROFICIENCY ASSESSMENT.
C
C              2) Z'-SCORE:
C
C                   Y(i) = (X(I) - XREF)/SQRT(SIGMA**2 + U(ref)**2)
C
C                 WHERE XREF IS THE "ASSIGNED VALUE", SIGMA IS
C                 THE STANDARD DEVIATION OF THE PROFICIENCY ASSESSMENT,
C                 AND U(ref) IS THE STANDARD UNCERTAINTY OF THE
C                 ASSIGNED VALUE.
C
C              3) ZETA-SCORE
C
C                    ZETA(i) = (X(i) - XREF)/SQRT(U(lab)**2 + U(ref)**2)
C
C                  WHERE
C
C                    XREF    = THE ASSIGNED VALUE (DETERMINED FROM A
C                              REFERENCE LABORATORY)
C                    U(ref)  = THE STANDARD UNCERTAINTY FOR THE ASSIGNED
C                              VALUE
C                    U(lab)  = THE STANDARD UNCERTAINTY FOR THE LAB
C
C                  NOTE THAT SINCE THE LAB UNCERTAINTY CAN VARY DEPENDING
C                  ON THE LAB, THIS IS INPUT AS A VECTOR RATHER THAN A
C                  PARAMETER.  XREF AND UREF ARE INPUT AS PARAMETERS SINCE
C                  THEY ARE FIXED FOR ALL LABS.  ULAB EFFECTIVELY ACTS AS
C                  AS A PROXY FOR LAB-ID, SO NO NEED TO INPUT THIS AS A
C                  SEPARATE VALUE.
C
C                  NOTE ALSO THAT THE ZETA-SCORE IS SIMILAR TO THE
C                  EN NUMBERS.  THE DISTINCTION IS THAT ZETA-SCORES
C                  USE STANDARD UNCERTAINTIES WHILE THE EN NUMBERS
C                  USE EXPANDED UNCERTAINTIES.
C
C              4) Ez SCORES
C
C                    Ez-(i) = (X(i) - (X-U(ref)))/U(lab)
C                    Ez+(i) = (X(i) - (X+U(ref)))/U(lab)
C
C                 WHERE
C
C                    X       = THE ASSIGNED VALUE
C                    U(ref)  = THE EXPANDED UNCERTAINTY FOR THE ASSIGNED
C                              VALUE
C                    U(lab)  = THE EXPANDED UNCERTAINTY FOR THE LAB
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --ULAB   = THE SINGLE PRECISION VECTOR OF
C                                LAB UNCERTAINTIES
C                     --XREF   = THE SINGLE PRECISION VALUE CONTAINING
C                                THE ASSIGNED VALUE
C                     --UREF   = THE SINGLE PRECISION VALUE CONTAINING
C                                THE UNCERTAINTY FOR THE
C                                ASSIGNED VALUE
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR OF THE
C                                COMPUTED VALUES.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VECTOR OF THE SAMPLE
C             Z-SCORE VALUES.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--ISO 13528, FIRST EDITION, STATISTICAL METHODS FOR USE
C                IN PROFICIENCY TESTING BY INTERLABORATORY COMPARISONS,
C                2005, PP. 25-30.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012.1
C     ORIGINAL VERSION--JANUARY   2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*9 INAME
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION ULAB(*)
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EN  '
      ISUBN2='    '
C
      IERROR='NO'
      IF(ICASE.EQ.1)THEN
        INAME='Z-SCORE'
      ELSEIF(ICASE.EQ.2)THEN
        INAME='ZP-SCORE'
      ELSEIF(ICASE.EQ.3)THEN
        INAME='ZETA-SCORE'
      ELSEIF(ICASE.EQ.4)THEN
        INAME='Ez- SCORE'
      ELSEIF(ICASE.EQ.5)THEN
        INAME='Ez+ SCORE'
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CORE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF EN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,N,ICASE,XREF,UREF
   52   FORMAT('IBUGA3,N,ICASE,XREF,UREF = ',A4,2X,2I8,2G15.7)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I),ULAB(I)
   56     FORMAT('I,X(I),ULAB(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)INAME
  111   FORMAT('***** ERROR IN ISO 13528 ',A9,'--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS IN THE VARIABLE FOR')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,114)
  114   FORMAT('      WHICH THE Z-SCORE IS TO BE COMPUTED MUST BE AT ',
     1         'LEAST 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(UREF.LE.0.0 .AND. ICASE.GE.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)INAME
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,122)
  122   FORMAT('      THE REFERENCE UNCERTAINTY IS NOT POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,127)UREF
  127   FORMAT('      THE REFERENCE UNCERTAINTY = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(SIGMA.LE.0.0 .AND. ICASE.LE.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)INAME
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,132)
  132   FORMAT('      THE PROFICIENCY ASSESSMENT STANDARD DEVIATION ',
     1         '(SIGMA) IS NOT POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,137)SIGMA
  137   FORMAT('      SIGMA = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               *****************************
C               **  STEP 2A-               **
C               **  COMPUTE THE Z-SCORE    **
C               *****************************
C
      IF(ICASE.EQ.1)THEN
        DO210I=1,N
          Y(I)=(X(I) - XREF)/SIGMA
  210   CONTINUE
C
C               *****************************
C               **  STEP 2B-               **
C               **  COMPUTE THE Z'-SCORE   **
C               *****************************
C
      ELSEIF(ICASE.EQ.2)THEN
        DO220I=1,N
          Y(I)=(X(I) - XREF)/SQRT(SIGMA**2 + UREF**2)
  220   CONTINUE
C
C               *****************************
C               **  STEP 2C-               **
C               **  COMPUTE THE ZETA-SCORE **
C               *****************************
C
      ELSEIF(ICASE.EQ.3)THEN
        DO230I=1,N
          UTEMP1=ULAB(I)
          UTEMP2=UTEMP1**2 + UREF**2
C
          IF(UTEMP1.LT.0.0 .OR. UTEMP2.LE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,111)INAME
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,232)
  232       FORMAT('      EITHER THE LAB STANDARD UNCERTAINTY IS ',
     1             'NEGATIVE OR')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,234)
  234       FORMAT('      BOTH THE LAB STANDARD UNCERTAINTY AND THE ',
     1             'STANDARD')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,236)
  236       FORMAT('      REFERENCE UNCERTAINTY ARE ZERO.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,127)UREF
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,237)ULAB(I)
  237       FORMAT('      THE LAB EXPANDED UNCERTAINTY = ',G15.7)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
C
          Y(I)=(X(I) - XREF)/SQRT(UTEMP1**2 + UREF**2)
  230   CONTINUE
C
C               *****************************
C               **  STEP 2D-               **
C               **  COMPUTE THE Ez--SCORE  **
C               *****************************
C
      ELSEIF(ICASE.EQ.4)THEN
        DO240I=1,N
C
          IF(ULAB(I).LE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,111)INAME
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,242)
  242       FORMAT('      THE LAB EXPANDED UNCERTAINTY IS NEGATIVE.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,247)ULAB(I)
  247       FORMAT('      THE LAB EXPANDED UNCERTAINTY = ',G15.7)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
C
          Y(I)=(X(I) - (XREF - UREF))/ULAB(I)
  240   CONTINUE
C
C               *****************************
C               **  STEP 2E-               **
C               **  COMPUTE THE Ez+-SCORE  **
C               *****************************
C
      ELSEIF(ICASE.EQ.5)THEN
        DO250I=1,N
C
          IF(ULAB(I).LE.0.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,111)INAME
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,252)
  252       FORMAT('      THE LAB EXPANDED UNCERTAINTY IS NEGATIVE.')
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,257)ULAB(I)
  257       FORMAT('      THE LAB EXPANDED UNCERTAINTY = ',G15.7)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9000
          ENDIF
C
          Y(I)=(X(I) - (XREF + UREF))/ULAB(I)
  250   CONTINUE
C
      ENDIF
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)INAME,N
  811   FORMAT('THE NUMBER OF ISO-13528 ',A9,' VALUES GENERATED = ',I8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'CORE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF ZSCORE--')
        CALL DPWRST('XXX','BUG ')
        DO9012I=1,N
          WRITE(ICOUT,9015)I,X(I),ULAB(I),Y(I)
 9015     FORMAT('I,X(I),ULAB(I),Y(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9012   CONTINUE
      ENDIF
C
      RETURN
      END
