/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.math.MathContext;
import java.math.RoundingMode;

public class Decimal128Context {
    private MathContext bdctx;
    public int status = 0;
    public static final Decimal128Context DECIMAL128 = new Decimal128Context(34, Decimal128Context.defaultMode());
    static final int DEC_Conversion_syntax = 1;
    static final int DEC_Division_by_zero = 2;
    static final int DEC_Division_impossible = 4;
    static final int DEC_Division_undefined = 8;
    static final int DEC_Insufficient_storage = 16;
    static final int DEC_Inexact = 32;
    static final int DEC_Invalid_context = 64;
    static final int DEC_Invalid_operation = 128;
    static final int DEC_Overflow = 512;
    static final int DEC_Clamped = 1024;
    static final int DEC_Rounded = 2048;
    static final int DEC_Subnormal = 4096;
    static final int DEC_Underflow = 8192;
    static final int DEC_sNaN = 0x40000000;
    static final String DEC_Condition_CS = "Conversion syntax";
    static final String DEC_Condition_DZ = "Division by zero";
    static final String DEC_Condition_DI = "Division impossible";
    static final String DEC_Condition_DU = "Division undefined";
    static final String DEC_Condition_IE = "Inexact";
    static final String DEC_Condition_IS = "Insufficient storage";
    static final String DEC_Condition_IC = "Invalid context";
    static final String DEC_Condition_IO = "Invalid operation";
    static final String DEC_Condition_OV = "Overflow";
    static final String DEC_Condition_PA = "Clamped";
    static final String DEC_Condition_RO = "Rounded";
    static final String DEC_Condition_SU = "Subnormal";
    static final String DEC_Condition_UN = "Underflow";
    static final String DEC_Condition_ZE = "No status";
    static final String DEC_Condition_MU = "Multiple status";
    static final int DEC_Condition_Length = 21;

    public Decimal128Context() {
        try {
            this.bdctx = new MathContext(34, RoundingMode.HALF_EVEN);
        }
        catch (NoClassDefFoundError e) {
            this.bdctx = null;
        }
    }

    public Decimal128Context(int precision, RoundingMode rounding) {
        try {
            this.bdctx = new MathContext(precision, rounding);
        }
        catch (NoClassDefFoundError e) {
            this.bdctx = null;
        }
    }

    public int getPrecision() {
        return this.bdctx.getPrecision();
    }

    public RoundingMode getRoundingMode() {
        return this.bdctx.getRoundingMode();
    }

    protected MathContext mathCtx() {
        return this.bdctx;
    }

    public void setPrecision(int precision) {
        if (precision < 1 || precision > 34) {
            throw new IllegalArgumentException("Precision must be between 1 and 34");
        }
        if (this.bdctx.getPrecision() != precision) {
            this.bdctx = new MathContext(precision, this.bdctx.getRoundingMode());
        }
    }

    public void setRoundingMode(RoundingMode mode) {
        if (this.bdctx.getRoundingMode() != mode) {
            this.bdctx = new MathContext(this.bdctx.getPrecision(), mode);
        }
    }

    private static RoundingMode defaultMode() {
        RoundingMode result;
        try {
            result = RoundingMode.HALF_EVEN;
        }
        catch (NoClassDefFoundError e) {
            result = null;
        }
        return result;
    }
}

