/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndexColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;

public class OracleTableIndex
extends JDBCTableIndex<OracleSchema, OracleTableBase>
implements DBSObjectLazy,
DBPScriptObject,
DBPNamedObject2 {
    private Object tablespace;
    private boolean nonUnique;
    private List<OracleTableIndexColumn> columns;
    private String indexDDL;

    public OracleTableIndex(OracleSchema schema, OracleTableBase table, String indexName, ResultSet dbResult) {
        super((DBSObjectContainer)schema, (JDBCTable)table, indexName, null, true);
        String indexTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INDEX_TYPE");
        boolean bl = this.nonUnique = !"UNIQUE".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"UNIQUENESS"));
        this.indexType = OracleConstants.INDEX_TYPE_NORMAL.getId().equals(indexTypeName) ? OracleConstants.INDEX_TYPE_NORMAL : (OracleConstants.INDEX_TYPE_BITMAP.getId().equals(indexTypeName) ? OracleConstants.INDEX_TYPE_BITMAP : (OracleConstants.INDEX_TYPE_FUNCTION_BASED_NORMAL.getId().equals(indexTypeName) ? OracleConstants.INDEX_TYPE_FUNCTION_BASED_NORMAL : (OracleConstants.INDEX_TYPE_FUNCTION_BASED_BITMAP.getId().equals(indexTypeName) ? OracleConstants.INDEX_TYPE_FUNCTION_BASED_BITMAP : (OracleConstants.INDEX_TYPE_DOMAIN.getId().equals(indexTypeName) ? OracleConstants.INDEX_TYPE_DOMAIN : DBSIndexType.OTHER))));
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
    }

    public OracleTableIndex(OracleSchema schema, OracleTableBase parent, String name, boolean unique, DBSIndexType indexType) {
        super((DBSObjectContainer)schema, (JDBCTable)parent, name, indexType, false);
        this.nonUnique = !unique;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return (OracleDataSource)((OracleTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=true, order=5)
    public boolean isUnique() {
        return !this.nonUnique;
    }

    public void setUnique(boolean unique) {
        this.nonUnique = !unique;
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return this.tablespace;
    }

    @Property(viewable=true, order=10)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, null);
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public List<OracleTableIndexColumn> getAttributeReferences(@NotNull DBRProgressMonitor monitor) {
        return this.columns;
    }

    @Nullable
    @Association
    public OracleTableIndexColumn getColumn(String columnName) {
        return (OracleTableIndexColumn)DBUtils.findObject(this.columns, (String)columnName);
    }

    void setColumns(List<OracleTableIndexColumn> columns) {
        this.columns = columns;
    }

    public void addColumn(OracleTableIndexColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<OracleTableIndexColumn>();
        }
        this.columns.add(column);
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((OracleTableBase)this.getTable()).getContainer(), this});
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.indexDDL == null && this.isPersisted()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read index definition");){
                    this.indexDDL = JDBCUtils.queryString((Connection)session, (String)"SELECT DBMS_METADATA.GET_DDL('INDEX', ?, ?) TXT FROM DUAL", (Object[])new Object[]{this.getName(), ((OracleTableBase)this.getTable()).getSchema().getName()});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        return this.indexDDL;
    }
}

