﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Text.Json.Serialization;

namespace Cake.Common.Tools.DotNet.Package.List
{
    /// <summary>
    /// The vulnerability information.
    /// </summary>
    public sealed class DotNetPackageListVulnerabilityItem
    {
        /// <summary>
        /// Gets the severity level: Low, Moderate, High, Critical.
        /// </summary>
        [JsonInclude]
        public string Severity { get; private set; }

        /// <summary>
        /// Gets the URL of advisory.
        /// </summary>
        [JsonInclude]
        public Uri AdvisoryUrl { get; private set; }
    }
}
