/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.tools;

import com.google.common.net.InetAddresses;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.graylog2.utilities.IpSubnet;

public class PrivateNet {
    private static IpSubnet UNIQUE_LOCAL_ADDR_MASK = null;

    public static boolean isInPrivateAddressSpace(String ip) {
        InetAddress inetAddress = InetAddresses.forString((String)ip);
        if (inetAddress instanceof Inet6Address) {
            return UNIQUE_LOCAL_ADDR_MASK.contains(inetAddress);
        }
        return inetAddress.isSiteLocalAddress();
    }

    static {
        try {
            UNIQUE_LOCAL_ADDR_MASK = new IpSubnet("FC00::/7");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

