/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ActiveInstance;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeFleetInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ActiveInstance> activeInstances;
    private String nextToken;
    private String fleetId;

    public List<ActiveInstance> getActiveInstances() {
        if (this.activeInstances == null) {
            this.activeInstances = new SdkInternalList();
        }
        return this.activeInstances;
    }

    public void setActiveInstances(Collection<ActiveInstance> activeInstances) {
        if (activeInstances == null) {
            this.activeInstances = null;
            return;
        }
        this.activeInstances = new SdkInternalList<ActiveInstance>(activeInstances);
    }

    public DescribeFleetInstancesResult withActiveInstances(ActiveInstance ... activeInstances) {
        if (this.activeInstances == null) {
            this.setActiveInstances(new SdkInternalList<ActiveInstance>(activeInstances.length));
        }
        for (ActiveInstance ele : activeInstances) {
            this.activeInstances.add(ele);
        }
        return this;
    }

    public DescribeFleetInstancesResult withActiveInstances(Collection<ActiveInstance> activeInstances) {
        this.setActiveInstances(activeInstances);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeFleetInstancesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setFleetId(String fleetId) {
        this.fleetId = fleetId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public DescribeFleetInstancesResult withFleetId(String fleetId) {
        this.setFleetId(fleetId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActiveInstances() != null) {
            sb.append("ActiveInstances: ").append(this.getActiveInstances()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getFleetId() != null) {
            sb.append("FleetId: ").append(this.getFleetId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetInstancesResult)) {
            return false;
        }
        DescribeFleetInstancesResult other = (DescribeFleetInstancesResult)obj;
        if (other.getActiveInstances() == null ^ this.getActiveInstances() == null) {
            return false;
        }
        if (other.getActiveInstances() != null && !other.getActiveInstances().equals(this.getActiveInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFleetId() == null ^ this.getFleetId() == null) {
            return false;
        }
        return other.getFleetId() == null || other.getFleetId().equals(this.getFleetId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActiveInstances() == null ? 0 : this.getActiveInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFleetId() == null ? 0 : this.getFleetId().hashCode());
        return hashCode;
    }

    public DescribeFleetInstancesResult clone() {
        try {
            return (DescribeFleetInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

