/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.SnapshotTaskDetail;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImportSnapshotTask
implements Serializable,
Cloneable {
    private String description;
    private String importTaskId;
    private SnapshotTaskDetail snapshotTaskDetail;
    private SdkInternalList<Tag> tags;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportSnapshotTask withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setImportTaskId(String importTaskId) {
        this.importTaskId = importTaskId;
    }

    public String getImportTaskId() {
        return this.importTaskId;
    }

    public ImportSnapshotTask withImportTaskId(String importTaskId) {
        this.setImportTaskId(importTaskId);
        return this;
    }

    public void setSnapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
        this.snapshotTaskDetail = snapshotTaskDetail;
    }

    public SnapshotTaskDetail getSnapshotTaskDetail() {
        return this.snapshotTaskDetail;
    }

    public ImportSnapshotTask withSnapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
        this.setSnapshotTaskDetail(snapshotTaskDetail);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public ImportSnapshotTask withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportSnapshotTask withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getImportTaskId() != null) {
            sb.append("ImportTaskId: ").append(this.getImportTaskId()).append(",");
        }
        if (this.getSnapshotTaskDetail() != null) {
            sb.append("SnapshotTaskDetail: ").append(this.getSnapshotTaskDetail()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotTask)) {
            return false;
        }
        ImportSnapshotTask other = (ImportSnapshotTask)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getImportTaskId() == null ^ this.getImportTaskId() == null) {
            return false;
        }
        if (other.getImportTaskId() != null && !other.getImportTaskId().equals(this.getImportTaskId())) {
            return false;
        }
        if (other.getSnapshotTaskDetail() == null ^ this.getSnapshotTaskDetail() == null) {
            return false;
        }
        if (other.getSnapshotTaskDetail() != null && !other.getSnapshotTaskDetail().equals(this.getSnapshotTaskDetail())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getImportTaskId() == null ? 0 : this.getImportTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotTaskDetail() == null ? 0 : this.getSnapshotTaskDetail().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ImportSnapshotTask clone() {
        try {
            return (ImportSnapshotTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

