/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ClientDataStaxUnmarshaller
implements Unmarshaller<ClientData, StaxUnmarshallerContext> {
    private static ClientDataStaxUnmarshaller instance;

    @Override
    public ClientData unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClientData clientData = new ClientData();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return clientData;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Comment", targetDepth)) {
                    clientData.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UploadEnd", targetDepth)) {
                    clientData.setUploadEnd(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("UploadSize", targetDepth)) {
                    clientData.setUploadSize(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UploadStart", targetDepth)) continue;
                clientData.setUploadStart(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return clientData;
    }

    public static ClientDataStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ClientDataStaxUnmarshaller();
        }
        return instance;
    }
}

