/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateCarrierGatewayRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateCarrierGatewayRequestMarshaller
implements Marshaller<Request<CreateCarrierGatewayRequest>, CreateCarrierGatewayRequest> {
    @Override
    public Request<CreateCarrierGatewayRequest> marshall(CreateCarrierGatewayRequest createCarrierGatewayRequest) {
        SdkInternalList createCarrierGatewayRequestTagSpecificationsList;
        if (createCarrierGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCarrierGatewayRequest> request = new DefaultRequest<CreateCarrierGatewayRequest>(createCarrierGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateCarrierGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCarrierGatewayRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createCarrierGatewayRequest.getVpcId()));
        }
        if (!(createCarrierGatewayRequestTagSpecificationsList = (SdkInternalList)createCarrierGatewayRequest.getTagSpecifications()).isEmpty() || !createCarrierGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createCarrierGatewayRequestTagSpecificationsListValue : createCarrierGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createCarrierGatewayRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createCarrierGatewayRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createCarrierGatewayRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createCarrierGatewayRequest.getClientToken()));
        return request;
    }
}

