/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeBundleTasksRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeBundleTasksRequestMarshaller
implements Marshaller<Request<DescribeBundleTasksRequest>, DescribeBundleTasksRequest> {
    @Override
    public Request<DescribeBundleTasksRequest> marshall(DescribeBundleTasksRequest describeBundleTasksRequest) {
        SdkInternalList describeBundleTasksRequestFiltersList;
        if (describeBundleTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeBundleTasksRequest> request = new DefaultRequest<DescribeBundleTasksRequest>(describeBundleTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeBundleTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeBundleTasksRequestBundleIdsList = (SdkInternalList)describeBundleTasksRequest.getBundleIds();
        if (!describeBundleTasksRequestBundleIdsList.isEmpty() || !describeBundleTasksRequestBundleIdsList.isAutoConstruct()) {
            int bundleIdsListIndex = 1;
            for (String describeBundleTasksRequestBundleIdsListValue : describeBundleTasksRequestBundleIdsList) {
                if (describeBundleTasksRequestBundleIdsListValue != null) {
                    request.addParameter("BundleId." + bundleIdsListIndex, StringUtils.fromString(describeBundleTasksRequestBundleIdsListValue));
                }
                ++bundleIdsListIndex;
            }
        }
        if (!(describeBundleTasksRequestFiltersList = (SdkInternalList)describeBundleTasksRequest.getFilters()).isEmpty() || !describeBundleTasksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeBundleTasksRequestFiltersListValue : describeBundleTasksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeBundleTasksRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeBundleTasksRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeBundleTasksRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

